/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: security/access/PartnerPermissions.proto

package io.bloombox.schema.security.access;

/**
 * Protobuf type {@code bloombox.schema.security.access.PartnerAccess}
 */
public  final class PartnerAccess extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.security.access.PartnerAccess)
    PartnerAccessOrBuilder {
private static final long serialVersionUID = 0L;
  // Use PartnerAccess.newBuilder() to construct.
  private PartnerAccess(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private PartnerAccess() {
    active_ = false;
    grantedBy_ = "";
    privileges_ = java.util.Collections.emptyList();
    locations_ = java.util.Collections.emptyList();
    allLocations_ = false;
    admin_ = false;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private PartnerAccess(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 8: {

            active_ = input.readBool();
            break;
          }
          case 18: {
            java.lang.String s = input.readStringRequireUtf8();

            grantedBy_ = s;
            break;
          }
          case 26: {
            io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
            if (grantedAt_ != null) {
              subBuilder = grantedAt_.toBuilder();
            }
            grantedAt_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(grantedAt_);
              grantedAt_ = subBuilder.buildPartial();
            }

            break;
          }
          case 32: {
            int rawValue = input.readEnum();
            if (!((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
              privileges_ = new java.util.ArrayList<java.lang.Integer>();
              mutable_bitField0_ |= 0x00000008;
            }
            privileges_.add(rawValue);
            break;
          }
          case 34: {
            int length = input.readRawVarint32();
            int oldLimit = input.pushLimit(length);
            while(input.getBytesUntilLimit() > 0) {
              int rawValue = input.readEnum();
              if (!((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
                privileges_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x00000008;
              }
              privileges_.add(rawValue);
            }
            input.popLimit(oldLimit);
            break;
          }
          case 42: {
            if (!((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
              locations_ = new java.util.ArrayList<io.bloombox.schema.security.access.LocationAccess>();
              mutable_bitField0_ |= 0x00000010;
            }
            locations_.add(
                input.readMessage(io.bloombox.schema.security.access.LocationAccess.parser(), extensionRegistry));
            break;
          }
          case 48: {

            allLocations_ = input.readBool();
            break;
          }
          case 800: {

            admin_ = input.readBool();
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
        privileges_ = java.util.Collections.unmodifiableList(privileges_);
      }
      if (((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
        locations_ = java.util.Collections.unmodifiableList(locations_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.security.access.PartnerPermissions.internal_static_bloombox_schema_security_access_PartnerAccess_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.security.access.PartnerPermissions.internal_static_bloombox_schema_security_access_PartnerAccess_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.security.access.PartnerAccess.class, io.bloombox.schema.security.access.PartnerAccess.Builder.class);
  }

  private int bitField0_;
  public static final int ACTIVE_FIELD_NUMBER = 1;
  private boolean active_;
  /**
   * <code>bool active = 1;</code>
   */
  public boolean getActive() {
    return active_;
  }

  public static final int GRANTED_BY_FIELD_NUMBER = 2;
  private volatile java.lang.Object grantedBy_;
  /**
   * <code>string granted_by = 2;</code>
   */
  public java.lang.String getGrantedBy() {
    java.lang.Object ref = grantedBy_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      grantedBy_ = s;
      return s;
    }
  }
  /**
   * <code>string granted_by = 2;</code>
   */
  public com.google.protobuf.ByteString
      getGrantedByBytes() {
    java.lang.Object ref = grantedBy_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      grantedBy_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GRANTED_AT_FIELD_NUMBER = 3;
  private io.opencannabis.schema.temporal.Instant grantedAt_;
  /**
   * <code>.opencannabis.temporal.Instant granted_at = 3;</code>
   */
  public boolean hasGrantedAt() {
    return grantedAt_ != null;
  }
  /**
   * <code>.opencannabis.temporal.Instant granted_at = 3;</code>
   */
  public io.opencannabis.schema.temporal.Instant getGrantedAt() {
    return grantedAt_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : grantedAt_;
  }
  /**
   * <code>.opencannabis.temporal.Instant granted_at = 3;</code>
   */
  public io.opencannabis.schema.temporal.InstantOrBuilder getGrantedAtOrBuilder() {
    return getGrantedAt();
  }

  public static final int PRIVILEGES_FIELD_NUMBER = 4;
  private java.util.List<java.lang.Integer> privileges_;
  private static final com.google.protobuf.Internal.ListAdapter.Converter<
      java.lang.Integer, io.bloombox.schema.security.access.PartnerPermission> privileges_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, io.bloombox.schema.security.access.PartnerPermission>() {
            public io.bloombox.schema.security.access.PartnerPermission convert(java.lang.Integer from) {
              io.bloombox.schema.security.access.PartnerPermission result = io.bloombox.schema.security.access.PartnerPermission.valueOf(from);
              return result == null ? io.bloombox.schema.security.access.PartnerPermission.UNRECOGNIZED : result;
            }
          };
  /**
   * <code>repeated .bloombox.schema.security.access.PartnerPermission privileges = 4;</code>
   */
  public java.util.List<io.bloombox.schema.security.access.PartnerPermission> getPrivilegesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, io.bloombox.schema.security.access.PartnerPermission>(privileges_, privileges_converter_);
  }
  /**
   * <code>repeated .bloombox.schema.security.access.PartnerPermission privileges = 4;</code>
   */
  public int getPrivilegesCount() {
    return privileges_.size();
  }
  /**
   * <code>repeated .bloombox.schema.security.access.PartnerPermission privileges = 4;</code>
   */
  public io.bloombox.schema.security.access.PartnerPermission getPrivileges(int index) {
    return privileges_converter_.convert(privileges_.get(index));
  }
  /**
   * <code>repeated .bloombox.schema.security.access.PartnerPermission privileges = 4;</code>
   */
  public java.util.List<java.lang.Integer>
  getPrivilegesValueList() {
    return privileges_;
  }
  /**
   * <code>repeated .bloombox.schema.security.access.PartnerPermission privileges = 4;</code>
   */
  public int getPrivilegesValue(int index) {
    return privileges_.get(index);
  }
  private int privilegesMemoizedSerializedSize;

  public static final int LOCATIONS_FIELD_NUMBER = 5;
  private java.util.List<io.bloombox.schema.security.access.LocationAccess> locations_;
  /**
   * <code>repeated .bloombox.schema.security.access.LocationAccess locations = 5;</code>
   */
  public java.util.List<io.bloombox.schema.security.access.LocationAccess> getLocationsList() {
    return locations_;
  }
  /**
   * <code>repeated .bloombox.schema.security.access.LocationAccess locations = 5;</code>
   */
  public java.util.List<? extends io.bloombox.schema.security.access.LocationAccessOrBuilder> 
      getLocationsOrBuilderList() {
    return locations_;
  }
  /**
   * <code>repeated .bloombox.schema.security.access.LocationAccess locations = 5;</code>
   */
  public int getLocationsCount() {
    return locations_.size();
  }
  /**
   * <code>repeated .bloombox.schema.security.access.LocationAccess locations = 5;</code>
   */
  public io.bloombox.schema.security.access.LocationAccess getLocations(int index) {
    return locations_.get(index);
  }
  /**
   * <code>repeated .bloombox.schema.security.access.LocationAccess locations = 5;</code>
   */
  public io.bloombox.schema.security.access.LocationAccessOrBuilder getLocationsOrBuilder(
      int index) {
    return locations_.get(index);
  }

  public static final int ALL_LOCATIONS_FIELD_NUMBER = 6;
  private boolean allLocations_;
  /**
   * <code>bool all_locations = 6;</code>
   */
  public boolean getAllLocations() {
    return allLocations_;
  }

  public static final int ADMIN_FIELD_NUMBER = 100;
  private boolean admin_;
  /**
   * <code>bool admin = 100;</code>
   */
  public boolean getAdmin() {
    return admin_;
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    getSerializedSize();
    if (active_ != false) {
      output.writeBool(1, active_);
    }
    if (!getGrantedByBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, grantedBy_);
    }
    if (grantedAt_ != null) {
      output.writeMessage(3, getGrantedAt());
    }
    if (getPrivilegesList().size() > 0) {
      output.writeUInt32NoTag(34);
      output.writeUInt32NoTag(privilegesMemoizedSerializedSize);
    }
    for (int i = 0; i < privileges_.size(); i++) {
      output.writeEnumNoTag(privileges_.get(i));
    }
    for (int i = 0; i < locations_.size(); i++) {
      output.writeMessage(5, locations_.get(i));
    }
    if (allLocations_ != false) {
      output.writeBool(6, allLocations_);
    }
    if (admin_ != false) {
      output.writeBool(100, admin_);
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (active_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(1, active_);
    }
    if (!getGrantedByBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, grantedBy_);
    }
    if (grantedAt_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, getGrantedAt());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < privileges_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeEnumSizeNoTag(privileges_.get(i));
      }
      size += dataSize;
      if (!getPrivilegesList().isEmpty()) {  size += 1;
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32SizeNoTag(dataSize);
      }privilegesMemoizedSerializedSize = dataSize;
    }
    for (int i = 0; i < locations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, locations_.get(i));
    }
    if (allLocations_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(6, allLocations_);
    }
    if (admin_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(100, admin_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.security.access.PartnerAccess)) {
      return super.equals(obj);
    }
    io.bloombox.schema.security.access.PartnerAccess other = (io.bloombox.schema.security.access.PartnerAccess) obj;

    boolean result = true;
    result = result && (getActive()
        == other.getActive());
    result = result && getGrantedBy()
        .equals(other.getGrantedBy());
    result = result && (hasGrantedAt() == other.hasGrantedAt());
    if (hasGrantedAt()) {
      result = result && getGrantedAt()
          .equals(other.getGrantedAt());
    }
    result = result && privileges_.equals(other.privileges_);
    result = result && getLocationsList()
        .equals(other.getLocationsList());
    result = result && (getAllLocations()
        == other.getAllLocations());
    result = result && (getAdmin()
        == other.getAdmin());
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ACTIVE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getActive());
    hash = (37 * hash) + GRANTED_BY_FIELD_NUMBER;
    hash = (53 * hash) + getGrantedBy().hashCode();
    if (hasGrantedAt()) {
      hash = (37 * hash) + GRANTED_AT_FIELD_NUMBER;
      hash = (53 * hash) + getGrantedAt().hashCode();
    }
    if (getPrivilegesCount() > 0) {
      hash = (37 * hash) + PRIVILEGES_FIELD_NUMBER;
      hash = (53 * hash) + privileges_.hashCode();
    }
    if (getLocationsCount() > 0) {
      hash = (37 * hash) + LOCATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getLocationsList().hashCode();
    }
    hash = (37 * hash) + ALL_LOCATIONS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getAllLocations());
    hash = (37 * hash) + ADMIN_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getAdmin());
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.security.access.PartnerAccess parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.security.access.PartnerAccess parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.security.access.PartnerAccess parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.security.access.PartnerAccess parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.security.access.PartnerAccess parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.security.access.PartnerAccess parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.security.access.PartnerAccess parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.security.access.PartnerAccess parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.security.access.PartnerAccess parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.security.access.PartnerAccess parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.security.access.PartnerAccess parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.security.access.PartnerAccess parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.security.access.PartnerAccess prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * Protobuf type {@code bloombox.schema.security.access.PartnerAccess}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.security.access.PartnerAccess)
      io.bloombox.schema.security.access.PartnerAccessOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.security.access.PartnerPermissions.internal_static_bloombox_schema_security_access_PartnerAccess_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.security.access.PartnerPermissions.internal_static_bloombox_schema_security_access_PartnerAccess_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.security.access.PartnerAccess.class, io.bloombox.schema.security.access.PartnerAccess.Builder.class);
    }

    // Construct using io.bloombox.schema.security.access.PartnerAccess.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getLocationsFieldBuilder();
      }
    }
    public Builder clear() {
      super.clear();
      active_ = false;

      grantedBy_ = "";

      if (grantedAtBuilder_ == null) {
        grantedAt_ = null;
      } else {
        grantedAt_ = null;
        grantedAtBuilder_ = null;
      }
      privileges_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      if (locationsBuilder_ == null) {
        locations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
      } else {
        locationsBuilder_.clear();
      }
      allLocations_ = false;

      admin_ = false;

      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.security.access.PartnerPermissions.internal_static_bloombox_schema_security_access_PartnerAccess_descriptor;
    }

    public io.bloombox.schema.security.access.PartnerAccess getDefaultInstanceForType() {
      return io.bloombox.schema.security.access.PartnerAccess.getDefaultInstance();
    }

    public io.bloombox.schema.security.access.PartnerAccess build() {
      io.bloombox.schema.security.access.PartnerAccess result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.security.access.PartnerAccess buildPartial() {
      io.bloombox.schema.security.access.PartnerAccess result = new io.bloombox.schema.security.access.PartnerAccess(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.active_ = active_;
      result.grantedBy_ = grantedBy_;
      if (grantedAtBuilder_ == null) {
        result.grantedAt_ = grantedAt_;
      } else {
        result.grantedAt_ = grantedAtBuilder_.build();
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        privileges_ = java.util.Collections.unmodifiableList(privileges_);
        bitField0_ = (bitField0_ & ~0x00000008);
      }
      result.privileges_ = privileges_;
      if (locationsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) == 0x00000010)) {
          locations_ = java.util.Collections.unmodifiableList(locations_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.locations_ = locations_;
      } else {
        result.locations_ = locationsBuilder_.build();
      }
      result.allLocations_ = allLocations_;
      result.admin_ = admin_;
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.security.access.PartnerAccess) {
        return mergeFrom((io.bloombox.schema.security.access.PartnerAccess)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.security.access.PartnerAccess other) {
      if (other == io.bloombox.schema.security.access.PartnerAccess.getDefaultInstance()) return this;
      if (other.getActive() != false) {
        setActive(other.getActive());
      }
      if (!other.getGrantedBy().isEmpty()) {
        grantedBy_ = other.grantedBy_;
        onChanged();
      }
      if (other.hasGrantedAt()) {
        mergeGrantedAt(other.getGrantedAt());
      }
      if (!other.privileges_.isEmpty()) {
        if (privileges_.isEmpty()) {
          privileges_ = other.privileges_;
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          ensurePrivilegesIsMutable();
          privileges_.addAll(other.privileges_);
        }
        onChanged();
      }
      if (locationsBuilder_ == null) {
        if (!other.locations_.isEmpty()) {
          if (locations_.isEmpty()) {
            locations_ = other.locations_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureLocationsIsMutable();
            locations_.addAll(other.locations_);
          }
          onChanged();
        }
      } else {
        if (!other.locations_.isEmpty()) {
          if (locationsBuilder_.isEmpty()) {
            locationsBuilder_.dispose();
            locationsBuilder_ = null;
            locations_ = other.locations_;
            bitField0_ = (bitField0_ & ~0x00000010);
            locationsBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getLocationsFieldBuilder() : null;
          } else {
            locationsBuilder_.addAllMessages(other.locations_);
          }
        }
      }
      if (other.getAllLocations() != false) {
        setAllLocations(other.getAllLocations());
      }
      if (other.getAdmin() != false) {
        setAdmin(other.getAdmin());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.security.access.PartnerAccess parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.security.access.PartnerAccess) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private boolean active_ ;
    /**
     * <code>bool active = 1;</code>
     */
    public boolean getActive() {
      return active_;
    }
    /**
     * <code>bool active = 1;</code>
     */
    public Builder setActive(boolean value) {
      
      active_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>bool active = 1;</code>
     */
    public Builder clearActive() {
      
      active_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object grantedBy_ = "";
    /**
     * <code>string granted_by = 2;</code>
     */
    public java.lang.String getGrantedBy() {
      java.lang.Object ref = grantedBy_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        grantedBy_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <code>string granted_by = 2;</code>
     */
    public com.google.protobuf.ByteString
        getGrantedByBytes() {
      java.lang.Object ref = grantedBy_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        grantedBy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <code>string granted_by = 2;</code>
     */
    public Builder setGrantedBy(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      grantedBy_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>string granted_by = 2;</code>
     */
    public Builder clearGrantedBy() {
      
      grantedBy_ = getDefaultInstance().getGrantedBy();
      onChanged();
      return this;
    }
    /**
     * <code>string granted_by = 2;</code>
     */
    public Builder setGrantedByBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      grantedBy_ = value;
      onChanged();
      return this;
    }

    private io.opencannabis.schema.temporal.Instant grantedAt_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> grantedAtBuilder_;
    /**
     * <code>.opencannabis.temporal.Instant granted_at = 3;</code>
     */
    public boolean hasGrantedAt() {
      return grantedAtBuilder_ != null || grantedAt_ != null;
    }
    /**
     * <code>.opencannabis.temporal.Instant granted_at = 3;</code>
     */
    public io.opencannabis.schema.temporal.Instant getGrantedAt() {
      if (grantedAtBuilder_ == null) {
        return grantedAt_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : grantedAt_;
      } else {
        return grantedAtBuilder_.getMessage();
      }
    }
    /**
     * <code>.opencannabis.temporal.Instant granted_at = 3;</code>
     */
    public Builder setGrantedAt(io.opencannabis.schema.temporal.Instant value) {
      if (grantedAtBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        grantedAt_ = value;
        onChanged();
      } else {
        grantedAtBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <code>.opencannabis.temporal.Instant granted_at = 3;</code>
     */
    public Builder setGrantedAt(
        io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
      if (grantedAtBuilder_ == null) {
        grantedAt_ = builderForValue.build();
        onChanged();
      } else {
        grantedAtBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <code>.opencannabis.temporal.Instant granted_at = 3;</code>
     */
    public Builder mergeGrantedAt(io.opencannabis.schema.temporal.Instant value) {
      if (grantedAtBuilder_ == null) {
        if (grantedAt_ != null) {
          grantedAt_ =
            io.opencannabis.schema.temporal.Instant.newBuilder(grantedAt_).mergeFrom(value).buildPartial();
        } else {
          grantedAt_ = value;
        }
        onChanged();
      } else {
        grantedAtBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <code>.opencannabis.temporal.Instant granted_at = 3;</code>
     */
    public Builder clearGrantedAt() {
      if (grantedAtBuilder_ == null) {
        grantedAt_ = null;
        onChanged();
      } else {
        grantedAt_ = null;
        grantedAtBuilder_ = null;
      }

      return this;
    }
    /**
     * <code>.opencannabis.temporal.Instant granted_at = 3;</code>
     */
    public io.opencannabis.schema.temporal.Instant.Builder getGrantedAtBuilder() {
      
      onChanged();
      return getGrantedAtFieldBuilder().getBuilder();
    }
    /**
     * <code>.opencannabis.temporal.Instant granted_at = 3;</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getGrantedAtOrBuilder() {
      if (grantedAtBuilder_ != null) {
        return grantedAtBuilder_.getMessageOrBuilder();
      } else {
        return grantedAt_ == null ?
            io.opencannabis.schema.temporal.Instant.getDefaultInstance() : grantedAt_;
      }
    }
    /**
     * <code>.opencannabis.temporal.Instant granted_at = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
        getGrantedAtFieldBuilder() {
      if (grantedAtBuilder_ == null) {
        grantedAtBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                getGrantedAt(),
                getParentForChildren(),
                isClean());
        grantedAt_ = null;
      }
      return grantedAtBuilder_;
    }

    private java.util.List<java.lang.Integer> privileges_ =
      java.util.Collections.emptyList();
    private void ensurePrivilegesIsMutable() {
      if (!((bitField0_ & 0x00000008) == 0x00000008)) {
        privileges_ = new java.util.ArrayList<java.lang.Integer>(privileges_);
        bitField0_ |= 0x00000008;
      }
    }
    /**
     * <code>repeated .bloombox.schema.security.access.PartnerPermission privileges = 4;</code>
     */
    public java.util.List<io.bloombox.schema.security.access.PartnerPermission> getPrivilegesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, io.bloombox.schema.security.access.PartnerPermission>(privileges_, privileges_converter_);
    }
    /**
     * <code>repeated .bloombox.schema.security.access.PartnerPermission privileges = 4;</code>
     */
    public int getPrivilegesCount() {
      return privileges_.size();
    }
    /**
     * <code>repeated .bloombox.schema.security.access.PartnerPermission privileges = 4;</code>
     */
    public io.bloombox.schema.security.access.PartnerPermission getPrivileges(int index) {
      return privileges_converter_.convert(privileges_.get(index));
    }
    /**
     * <code>repeated .bloombox.schema.security.access.PartnerPermission privileges = 4;</code>
     */
    public Builder setPrivileges(
        int index, io.bloombox.schema.security.access.PartnerPermission value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePrivilegesIsMutable();
      privileges_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <code>repeated .bloombox.schema.security.access.PartnerPermission privileges = 4;</code>
     */
    public Builder addPrivileges(io.bloombox.schema.security.access.PartnerPermission value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensurePrivilegesIsMutable();
      privileges_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <code>repeated .bloombox.schema.security.access.PartnerPermission privileges = 4;</code>
     */
    public Builder addAllPrivileges(
        java.lang.Iterable<? extends io.bloombox.schema.security.access.PartnerPermission> values) {
      ensurePrivilegesIsMutable();
      for (io.bloombox.schema.security.access.PartnerPermission value : values) {
        privileges_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     * <code>repeated .bloombox.schema.security.access.PartnerPermission privileges = 4;</code>
     */
    public Builder clearPrivileges() {
      privileges_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     * <code>repeated .bloombox.schema.security.access.PartnerPermission privileges = 4;</code>
     */
    public java.util.List<java.lang.Integer>
    getPrivilegesValueList() {
      return java.util.Collections.unmodifiableList(privileges_);
    }
    /**
     * <code>repeated .bloombox.schema.security.access.PartnerPermission privileges = 4;</code>
     */
    public int getPrivilegesValue(int index) {
      return privileges_.get(index);
    }
    /**
     * <code>repeated .bloombox.schema.security.access.PartnerPermission privileges = 4;</code>
     */
    public Builder setPrivilegesValue(
        int index, int value) {
      ensurePrivilegesIsMutable();
      privileges_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <code>repeated .bloombox.schema.security.access.PartnerPermission privileges = 4;</code>
     */
    public Builder addPrivilegesValue(int value) {
      ensurePrivilegesIsMutable();
      privileges_.add(value);
      onChanged();
      return this;
    }
    /**
     * <code>repeated .bloombox.schema.security.access.PartnerPermission privileges = 4;</code>
     */
    public Builder addAllPrivilegesValue(
        java.lang.Iterable<java.lang.Integer> values) {
      ensurePrivilegesIsMutable();
      for (int value : values) {
        privileges_.add(value);
      }
      onChanged();
      return this;
    }

    private java.util.List<io.bloombox.schema.security.access.LocationAccess> locations_ =
      java.util.Collections.emptyList();
    private void ensureLocationsIsMutable() {
      if (!((bitField0_ & 0x00000010) == 0x00000010)) {
        locations_ = new java.util.ArrayList<io.bloombox.schema.security.access.LocationAccess>(locations_);
        bitField0_ |= 0x00000010;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.bloombox.schema.security.access.LocationAccess, io.bloombox.schema.security.access.LocationAccess.Builder, io.bloombox.schema.security.access.LocationAccessOrBuilder> locationsBuilder_;

    /**
     * <code>repeated .bloombox.schema.security.access.LocationAccess locations = 5;</code>
     */
    public java.util.List<io.bloombox.schema.security.access.LocationAccess> getLocationsList() {
      if (locationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(locations_);
      } else {
        return locationsBuilder_.getMessageList();
      }
    }
    /**
     * <code>repeated .bloombox.schema.security.access.LocationAccess locations = 5;</code>
     */
    public int getLocationsCount() {
      if (locationsBuilder_ == null) {
        return locations_.size();
      } else {
        return locationsBuilder_.getCount();
      }
    }
    /**
     * <code>repeated .bloombox.schema.security.access.LocationAccess locations = 5;</code>
     */
    public io.bloombox.schema.security.access.LocationAccess getLocations(int index) {
      if (locationsBuilder_ == null) {
        return locations_.get(index);
      } else {
        return locationsBuilder_.getMessage(index);
      }
    }
    /**
     * <code>repeated .bloombox.schema.security.access.LocationAccess locations = 5;</code>
     */
    public Builder setLocations(
        int index, io.bloombox.schema.security.access.LocationAccess value) {
      if (locationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLocationsIsMutable();
        locations_.set(index, value);
        onChanged();
      } else {
        locationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <code>repeated .bloombox.schema.security.access.LocationAccess locations = 5;</code>
     */
    public Builder setLocations(
        int index, io.bloombox.schema.security.access.LocationAccess.Builder builderForValue) {
      if (locationsBuilder_ == null) {
        ensureLocationsIsMutable();
        locations_.set(index, builderForValue.build());
        onChanged();
      } else {
        locationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <code>repeated .bloombox.schema.security.access.LocationAccess locations = 5;</code>
     */
    public Builder addLocations(io.bloombox.schema.security.access.LocationAccess value) {
      if (locationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLocationsIsMutable();
        locations_.add(value);
        onChanged();
      } else {
        locationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <code>repeated .bloombox.schema.security.access.LocationAccess locations = 5;</code>
     */
    public Builder addLocations(
        int index, io.bloombox.schema.security.access.LocationAccess value) {
      if (locationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLocationsIsMutable();
        locations_.add(index, value);
        onChanged();
      } else {
        locationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <code>repeated .bloombox.schema.security.access.LocationAccess locations = 5;</code>
     */
    public Builder addLocations(
        io.bloombox.schema.security.access.LocationAccess.Builder builderForValue) {
      if (locationsBuilder_ == null) {
        ensureLocationsIsMutable();
        locations_.add(builderForValue.build());
        onChanged();
      } else {
        locationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <code>repeated .bloombox.schema.security.access.LocationAccess locations = 5;</code>
     */
    public Builder addLocations(
        int index, io.bloombox.schema.security.access.LocationAccess.Builder builderForValue) {
      if (locationsBuilder_ == null) {
        ensureLocationsIsMutable();
        locations_.add(index, builderForValue.build());
        onChanged();
      } else {
        locationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <code>repeated .bloombox.schema.security.access.LocationAccess locations = 5;</code>
     */
    public Builder addAllLocations(
        java.lang.Iterable<? extends io.bloombox.schema.security.access.LocationAccess> values) {
      if (locationsBuilder_ == null) {
        ensureLocationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, locations_);
        onChanged();
      } else {
        locationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <code>repeated .bloombox.schema.security.access.LocationAccess locations = 5;</code>
     */
    public Builder clearLocations() {
      if (locationsBuilder_ == null) {
        locations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        locationsBuilder_.clear();
      }
      return this;
    }
    /**
     * <code>repeated .bloombox.schema.security.access.LocationAccess locations = 5;</code>
     */
    public Builder removeLocations(int index) {
      if (locationsBuilder_ == null) {
        ensureLocationsIsMutable();
        locations_.remove(index);
        onChanged();
      } else {
        locationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <code>repeated .bloombox.schema.security.access.LocationAccess locations = 5;</code>
     */
    public io.bloombox.schema.security.access.LocationAccess.Builder getLocationsBuilder(
        int index) {
      return getLocationsFieldBuilder().getBuilder(index);
    }
    /**
     * <code>repeated .bloombox.schema.security.access.LocationAccess locations = 5;</code>
     */
    public io.bloombox.schema.security.access.LocationAccessOrBuilder getLocationsOrBuilder(
        int index) {
      if (locationsBuilder_ == null) {
        return locations_.get(index);  } else {
        return locationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <code>repeated .bloombox.schema.security.access.LocationAccess locations = 5;</code>
     */
    public java.util.List<? extends io.bloombox.schema.security.access.LocationAccessOrBuilder> 
         getLocationsOrBuilderList() {
      if (locationsBuilder_ != null) {
        return locationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(locations_);
      }
    }
    /**
     * <code>repeated .bloombox.schema.security.access.LocationAccess locations = 5;</code>
     */
    public io.bloombox.schema.security.access.LocationAccess.Builder addLocationsBuilder() {
      return getLocationsFieldBuilder().addBuilder(
          io.bloombox.schema.security.access.LocationAccess.getDefaultInstance());
    }
    /**
     * <code>repeated .bloombox.schema.security.access.LocationAccess locations = 5;</code>
     */
    public io.bloombox.schema.security.access.LocationAccess.Builder addLocationsBuilder(
        int index) {
      return getLocationsFieldBuilder().addBuilder(
          index, io.bloombox.schema.security.access.LocationAccess.getDefaultInstance());
    }
    /**
     * <code>repeated .bloombox.schema.security.access.LocationAccess locations = 5;</code>
     */
    public java.util.List<io.bloombox.schema.security.access.LocationAccess.Builder> 
         getLocationsBuilderList() {
      return getLocationsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.bloombox.schema.security.access.LocationAccess, io.bloombox.schema.security.access.LocationAccess.Builder, io.bloombox.schema.security.access.LocationAccessOrBuilder> 
        getLocationsFieldBuilder() {
      if (locationsBuilder_ == null) {
        locationsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            io.bloombox.schema.security.access.LocationAccess, io.bloombox.schema.security.access.LocationAccess.Builder, io.bloombox.schema.security.access.LocationAccessOrBuilder>(
                locations_,
                ((bitField0_ & 0x00000010) == 0x00000010),
                getParentForChildren(),
                isClean());
        locations_ = null;
      }
      return locationsBuilder_;
    }

    private boolean allLocations_ ;
    /**
     * <code>bool all_locations = 6;</code>
     */
    public boolean getAllLocations() {
      return allLocations_;
    }
    /**
     * <code>bool all_locations = 6;</code>
     */
    public Builder setAllLocations(boolean value) {
      
      allLocations_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>bool all_locations = 6;</code>
     */
    public Builder clearAllLocations() {
      
      allLocations_ = false;
      onChanged();
      return this;
    }

    private boolean admin_ ;
    /**
     * <code>bool admin = 100;</code>
     */
    public boolean getAdmin() {
      return admin_;
    }
    /**
     * <code>bool admin = 100;</code>
     */
    public Builder setAdmin(boolean value) {
      
      admin_ = value;
      onChanged();
      return this;
    }
    /**
     * <code>bool admin = 100;</code>
     */
    public Builder clearAdmin() {
      
      admin_ = false;
      onChanged();
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.security.access.PartnerAccess)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.security.access.PartnerAccess)
  private static final io.bloombox.schema.security.access.PartnerAccess DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.security.access.PartnerAccess();
  }

  public static io.bloombox.schema.security.access.PartnerAccess getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PartnerAccess>
      PARSER = new com.google.protobuf.AbstractParser<PartnerAccess>() {
    public PartnerAccess parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new PartnerAccess(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<PartnerAccess> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PartnerAccess> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.security.access.PartnerAccess getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

