/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: auth/v1beta1/AuthService_Beta1.proto

package io.bloombox.schema.services.auth.v1beta1;

/**
 * <pre>
 * Specifies an RPC operation wherein a user has requested an assertion of their identity be validated by the server.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.services.auth.v1beta1.AuthenticateUser}
 */
public  final class AuthenticateUser extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.services.auth.v1beta1.AuthenticateUser)
    AuthenticateUserOrBuilder {
private static final long serialVersionUID = 0L;
  // Use AuthenticateUser.newBuilder() to construct.
  private AuthenticateUser(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private AuthenticateUser() {
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private AuthenticateUser(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_AuthenticateUser_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_AuthenticateUser_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.class, io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Builder.class);
  }

  public interface RequestOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Provider the user would like to login with.
     * </pre>
     *
     * <code>.bloombox.schema.identity.IdentityProvider provider = 1;</code>
     */
    int getProviderValue();
    /**
     * <pre>
     * Provider the user would like to login with.
     * </pre>
     *
     * <code>.bloombox.schema.identity.IdentityProvider provider = 1;</code>
     */
    io.bloombox.schema.identity.IdentityProvider getProvider();

    /**
     * <pre>
     * Login credentials provided by the user or Firebase.
     * </pre>
     *
     * <code>.bloombox.schema.services.auth.v1beta1.AccountAssertion assertion = 2;</code>
     */
    boolean hasAssertion();
    /**
     * <pre>
     * Login credentials provided by the user or Firebase.
     * </pre>
     *
     * <code>.bloombox.schema.services.auth.v1beta1.AccountAssertion assertion = 2;</code>
     */
    io.bloombox.schema.services.auth.v1beta1.AccountAssertion getAssertion();
    /**
     * <pre>
     * Login credentials provided by the user or Firebase.
     * </pre>
     *
     * <code>.bloombox.schema.services.auth.v1beta1.AccountAssertion assertion = 2;</code>
     */
    io.bloombox.schema.services.auth.v1beta1.AccountAssertionOrBuilder getAssertionOrBuilder();
  }
  /**
   * <pre>
   * Request to authenticate a user.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request}
   */
  public  static final class Request extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request)
      RequestOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Request.newBuilder() to construct.
    private Request(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Request() {
      provider_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Request(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();

              provider_ = rawValue;
              break;
            }
            case 18: {
              io.bloombox.schema.services.auth.v1beta1.AccountAssertion.Builder subBuilder = null;
              if (assertion_ != null) {
                subBuilder = assertion_.toBuilder();
              }
              assertion_ = input.readMessage(io.bloombox.schema.services.auth.v1beta1.AccountAssertion.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(assertion_);
                assertion_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_AuthenticateUser_Request_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_AuthenticateUser_Request_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request.class, io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request.Builder.class);
    }

    public static final int PROVIDER_FIELD_NUMBER = 1;
    private int provider_;
    /**
     * <pre>
     * Provider the user would like to login with.
     * </pre>
     *
     * <code>.bloombox.schema.identity.IdentityProvider provider = 1;</code>
     */
    public int getProviderValue() {
      return provider_;
    }
    /**
     * <pre>
     * Provider the user would like to login with.
     * </pre>
     *
     * <code>.bloombox.schema.identity.IdentityProvider provider = 1;</code>
     */
    public io.bloombox.schema.identity.IdentityProvider getProvider() {
      io.bloombox.schema.identity.IdentityProvider result = io.bloombox.schema.identity.IdentityProvider.valueOf(provider_);
      return result == null ? io.bloombox.schema.identity.IdentityProvider.UNRECOGNIZED : result;
    }

    public static final int ASSERTION_FIELD_NUMBER = 2;
    private io.bloombox.schema.services.auth.v1beta1.AccountAssertion assertion_;
    /**
     * <pre>
     * Login credentials provided by the user or Firebase.
     * </pre>
     *
     * <code>.bloombox.schema.services.auth.v1beta1.AccountAssertion assertion = 2;</code>
     */
    public boolean hasAssertion() {
      return assertion_ != null;
    }
    /**
     * <pre>
     * Login credentials provided by the user or Firebase.
     * </pre>
     *
     * <code>.bloombox.schema.services.auth.v1beta1.AccountAssertion assertion = 2;</code>
     */
    public io.bloombox.schema.services.auth.v1beta1.AccountAssertion getAssertion() {
      return assertion_ == null ? io.bloombox.schema.services.auth.v1beta1.AccountAssertion.getDefaultInstance() : assertion_;
    }
    /**
     * <pre>
     * Login credentials provided by the user or Firebase.
     * </pre>
     *
     * <code>.bloombox.schema.services.auth.v1beta1.AccountAssertion assertion = 2;</code>
     */
    public io.bloombox.schema.services.auth.v1beta1.AccountAssertionOrBuilder getAssertionOrBuilder() {
      return getAssertion();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (provider_ != io.bloombox.schema.identity.IdentityProvider.EMAIL.getNumber()) {
        output.writeEnum(1, provider_);
      }
      if (assertion_ != null) {
        output.writeMessage(2, getAssertion());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (provider_ != io.bloombox.schema.identity.IdentityProvider.EMAIL.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, provider_);
      }
      if (assertion_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getAssertion());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request other = (io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request) obj;

      boolean result = true;
      result = result && provider_ == other.provider_;
      result = result && (hasAssertion() == other.hasAssertion());
      if (hasAssertion()) {
        result = result && getAssertion()
            .equals(other.getAssertion());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PROVIDER_FIELD_NUMBER;
      hash = (53 * hash) + provider_;
      if (hasAssertion()) {
        hash = (37 * hash) + ASSERTION_FIELD_NUMBER;
        hash = (53 * hash) + getAssertion().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Request to authenticate a user.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request)
        io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.RequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_AuthenticateUser_Request_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_AuthenticateUser_Request_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request.class, io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request.Builder.class);
      }

      // Construct using io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        provider_ = 0;

        if (assertionBuilder_ == null) {
          assertion_ = null;
        } else {
          assertion_ = null;
          assertionBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_AuthenticateUser_Request_descriptor;
      }

      public io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request getDefaultInstanceForType() {
        return io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request.getDefaultInstance();
      }

      public io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request build() {
        io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request buildPartial() {
        io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request result = new io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request(this);
        result.provider_ = provider_;
        if (assertionBuilder_ == null) {
          result.assertion_ = assertion_;
        } else {
          result.assertion_ = assertionBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request) {
          return mergeFrom((io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request other) {
        if (other == io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request.getDefaultInstance()) return this;
        if (other.provider_ != 0) {
          setProviderValue(other.getProviderValue());
        }
        if (other.hasAssertion()) {
          mergeAssertion(other.getAssertion());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int provider_ = 0;
      /**
       * <pre>
       * Provider the user would like to login with.
       * </pre>
       *
       * <code>.bloombox.schema.identity.IdentityProvider provider = 1;</code>
       */
      public int getProviderValue() {
        return provider_;
      }
      /**
       * <pre>
       * Provider the user would like to login with.
       * </pre>
       *
       * <code>.bloombox.schema.identity.IdentityProvider provider = 1;</code>
       */
      public Builder setProviderValue(int value) {
        provider_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Provider the user would like to login with.
       * </pre>
       *
       * <code>.bloombox.schema.identity.IdentityProvider provider = 1;</code>
       */
      public io.bloombox.schema.identity.IdentityProvider getProvider() {
        io.bloombox.schema.identity.IdentityProvider result = io.bloombox.schema.identity.IdentityProvider.valueOf(provider_);
        return result == null ? io.bloombox.schema.identity.IdentityProvider.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Provider the user would like to login with.
       * </pre>
       *
       * <code>.bloombox.schema.identity.IdentityProvider provider = 1;</code>
       */
      public Builder setProvider(io.bloombox.schema.identity.IdentityProvider value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        provider_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Provider the user would like to login with.
       * </pre>
       *
       * <code>.bloombox.schema.identity.IdentityProvider provider = 1;</code>
       */
      public Builder clearProvider() {
        
        provider_ = 0;
        onChanged();
        return this;
      }

      private io.bloombox.schema.services.auth.v1beta1.AccountAssertion assertion_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.services.auth.v1beta1.AccountAssertion, io.bloombox.schema.services.auth.v1beta1.AccountAssertion.Builder, io.bloombox.schema.services.auth.v1beta1.AccountAssertionOrBuilder> assertionBuilder_;
      /**
       * <pre>
       * Login credentials provided by the user or Firebase.
       * </pre>
       *
       * <code>.bloombox.schema.services.auth.v1beta1.AccountAssertion assertion = 2;</code>
       */
      public boolean hasAssertion() {
        return assertionBuilder_ != null || assertion_ != null;
      }
      /**
       * <pre>
       * Login credentials provided by the user or Firebase.
       * </pre>
       *
       * <code>.bloombox.schema.services.auth.v1beta1.AccountAssertion assertion = 2;</code>
       */
      public io.bloombox.schema.services.auth.v1beta1.AccountAssertion getAssertion() {
        if (assertionBuilder_ == null) {
          return assertion_ == null ? io.bloombox.schema.services.auth.v1beta1.AccountAssertion.getDefaultInstance() : assertion_;
        } else {
          return assertionBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Login credentials provided by the user or Firebase.
       * </pre>
       *
       * <code>.bloombox.schema.services.auth.v1beta1.AccountAssertion assertion = 2;</code>
       */
      public Builder setAssertion(io.bloombox.schema.services.auth.v1beta1.AccountAssertion value) {
        if (assertionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          assertion_ = value;
          onChanged();
        } else {
          assertionBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Login credentials provided by the user or Firebase.
       * </pre>
       *
       * <code>.bloombox.schema.services.auth.v1beta1.AccountAssertion assertion = 2;</code>
       */
      public Builder setAssertion(
          io.bloombox.schema.services.auth.v1beta1.AccountAssertion.Builder builderForValue) {
        if (assertionBuilder_ == null) {
          assertion_ = builderForValue.build();
          onChanged();
        } else {
          assertionBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Login credentials provided by the user or Firebase.
       * </pre>
       *
       * <code>.bloombox.schema.services.auth.v1beta1.AccountAssertion assertion = 2;</code>
       */
      public Builder mergeAssertion(io.bloombox.schema.services.auth.v1beta1.AccountAssertion value) {
        if (assertionBuilder_ == null) {
          if (assertion_ != null) {
            assertion_ =
              io.bloombox.schema.services.auth.v1beta1.AccountAssertion.newBuilder(assertion_).mergeFrom(value).buildPartial();
          } else {
            assertion_ = value;
          }
          onChanged();
        } else {
          assertionBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Login credentials provided by the user or Firebase.
       * </pre>
       *
       * <code>.bloombox.schema.services.auth.v1beta1.AccountAssertion assertion = 2;</code>
       */
      public Builder clearAssertion() {
        if (assertionBuilder_ == null) {
          assertion_ = null;
          onChanged();
        } else {
          assertion_ = null;
          assertionBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Login credentials provided by the user or Firebase.
       * </pre>
       *
       * <code>.bloombox.schema.services.auth.v1beta1.AccountAssertion assertion = 2;</code>
       */
      public io.bloombox.schema.services.auth.v1beta1.AccountAssertion.Builder getAssertionBuilder() {
        
        onChanged();
        return getAssertionFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Login credentials provided by the user or Firebase.
       * </pre>
       *
       * <code>.bloombox.schema.services.auth.v1beta1.AccountAssertion assertion = 2;</code>
       */
      public io.bloombox.schema.services.auth.v1beta1.AccountAssertionOrBuilder getAssertionOrBuilder() {
        if (assertionBuilder_ != null) {
          return assertionBuilder_.getMessageOrBuilder();
        } else {
          return assertion_ == null ?
              io.bloombox.schema.services.auth.v1beta1.AccountAssertion.getDefaultInstance() : assertion_;
        }
      }
      /**
       * <pre>
       * Login credentials provided by the user or Firebase.
       * </pre>
       *
       * <code>.bloombox.schema.services.auth.v1beta1.AccountAssertion assertion = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.services.auth.v1beta1.AccountAssertion, io.bloombox.schema.services.auth.v1beta1.AccountAssertion.Builder, io.bloombox.schema.services.auth.v1beta1.AccountAssertionOrBuilder> 
          getAssertionFieldBuilder() {
        if (assertionBuilder_ == null) {
          assertionBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.services.auth.v1beta1.AccountAssertion, io.bloombox.schema.services.auth.v1beta1.AccountAssertion.Builder, io.bloombox.schema.services.auth.v1beta1.AccountAssertionOrBuilder>(
                  getAssertion(),
                  getParentForChildren(),
                  isClean());
          assertion_ = null;
        }
        return assertionBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request)
    private static final io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request();
    }

    public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Request>
        PARSER = new com.google.protobuf.AbstractParser<Request>() {
      public Request parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Request(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Request> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Request> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Request getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ResponseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Indicates the user's identity ID.
     * </pre>
     *
     * <code>string uid = 1;</code>
     */
    java.lang.String getUid();
    /**
     * <pre>
     * Indicates the user's identity ID.
     * </pre>
     *
     * <code>string uid = 1;</code>
     */
    com.google.protobuf.ByteString
        getUidBytes();

    /**
     * <pre>
     * Indicates the user's account key.
     * </pre>
     *
     * <code>string key = 2;</code>
     */
    java.lang.String getKey();
    /**
     * <pre>
     * Indicates the user's account key.
     * </pre>
     *
     * <code>string key = 2;</code>
     */
    com.google.protobuf.ByteString
        getKeyBytes();

    /**
     * <pre>
     * Authorized token resulting from the authentication operation.
     * </pre>
     *
     * <code>string token = 3;</code>
     */
    java.lang.String getToken();
    /**
     * <pre>
     * Authorized token resulting from the authentication operation.
     * </pre>
     *
     * <code>string token = 3;</code>
     */
    com.google.protobuf.ByteString
        getTokenBytes();
  }
  /**
   * <pre>
   * Response to a request to authenticate a user.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response}
   */
  public  static final class Response extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response)
      ResponseOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Response.newBuilder() to construct.
    private Response(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Response() {
      uid_ = "";
      key_ = "";
      token_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Response(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              uid_ = s;
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();

              key_ = s;
              break;
            }
            case 26: {
              java.lang.String s = input.readStringRequireUtf8();

              token_ = s;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_AuthenticateUser_Response_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_AuthenticateUser_Response_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response.class, io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response.Builder.class);
    }

    public static final int UID_FIELD_NUMBER = 1;
    private volatile java.lang.Object uid_;
    /**
     * <pre>
     * Indicates the user's identity ID.
     * </pre>
     *
     * <code>string uid = 1;</code>
     */
    public java.lang.String getUid() {
      java.lang.Object ref = uid_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uid_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Indicates the user's identity ID.
     * </pre>
     *
     * <code>string uid = 1;</code>
     */
    public com.google.protobuf.ByteString
        getUidBytes() {
      java.lang.Object ref = uid_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        uid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int KEY_FIELD_NUMBER = 2;
    private volatile java.lang.Object key_;
    /**
     * <pre>
     * Indicates the user's account key.
     * </pre>
     *
     * <code>string key = 2;</code>
     */
    public java.lang.String getKey() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        key_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Indicates the user's account key.
     * </pre>
     *
     * <code>string key = 2;</code>
     */
    public com.google.protobuf.ByteString
        getKeyBytes() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        key_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TOKEN_FIELD_NUMBER = 3;
    private volatile java.lang.Object token_;
    /**
     * <pre>
     * Authorized token resulting from the authentication operation.
     * </pre>
     *
     * <code>string token = 3;</code>
     */
    public java.lang.String getToken() {
      java.lang.Object ref = token_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        token_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Authorized token resulting from the authentication operation.
     * </pre>
     *
     * <code>string token = 3;</code>
     */
    public com.google.protobuf.ByteString
        getTokenBytes() {
      java.lang.Object ref = token_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        token_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getUidBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, uid_);
      }
      if (!getKeyBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, key_);
      }
      if (!getTokenBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, token_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getUidBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, uid_);
      }
      if (!getKeyBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, key_);
      }
      if (!getTokenBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, token_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response other = (io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response) obj;

      boolean result = true;
      result = result && getUid()
          .equals(other.getUid());
      result = result && getKey()
          .equals(other.getKey());
      result = result && getToken()
          .equals(other.getToken());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + UID_FIELD_NUMBER;
      hash = (53 * hash) + getUid().hashCode();
      hash = (37 * hash) + KEY_FIELD_NUMBER;
      hash = (53 * hash) + getKey().hashCode();
      hash = (37 * hash) + TOKEN_FIELD_NUMBER;
      hash = (53 * hash) + getToken().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Response to a request to authenticate a user.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response)
        io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.ResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_AuthenticateUser_Response_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_AuthenticateUser_Response_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response.class, io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response.Builder.class);
      }

      // Construct using io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        uid_ = "";

        key_ = "";

        token_ = "";

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_AuthenticateUser_Response_descriptor;
      }

      public io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response getDefaultInstanceForType() {
        return io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response.getDefaultInstance();
      }

      public io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response build() {
        io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response buildPartial() {
        io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response result = new io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response(this);
        result.uid_ = uid_;
        result.key_ = key_;
        result.token_ = token_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response) {
          return mergeFrom((io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response other) {
        if (other == io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response.getDefaultInstance()) return this;
        if (!other.getUid().isEmpty()) {
          uid_ = other.uid_;
          onChanged();
        }
        if (!other.getKey().isEmpty()) {
          key_ = other.key_;
          onChanged();
        }
        if (!other.getToken().isEmpty()) {
          token_ = other.token_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object uid_ = "";
      /**
       * <pre>
       * Indicates the user's identity ID.
       * </pre>
       *
       * <code>string uid = 1;</code>
       */
      public java.lang.String getUid() {
        java.lang.Object ref = uid_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          uid_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Indicates the user's identity ID.
       * </pre>
       *
       * <code>string uid = 1;</code>
       */
      public com.google.protobuf.ByteString
          getUidBytes() {
        java.lang.Object ref = uid_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          uid_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Indicates the user's identity ID.
       * </pre>
       *
       * <code>string uid = 1;</code>
       */
      public Builder setUid(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        uid_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Indicates the user's identity ID.
       * </pre>
       *
       * <code>string uid = 1;</code>
       */
      public Builder clearUid() {
        
        uid_ = getDefaultInstance().getUid();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Indicates the user's identity ID.
       * </pre>
       *
       * <code>string uid = 1;</code>
       */
      public Builder setUidBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        uid_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object key_ = "";
      /**
       * <pre>
       * Indicates the user's account key.
       * </pre>
       *
       * <code>string key = 2;</code>
       */
      public java.lang.String getKey() {
        java.lang.Object ref = key_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          key_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Indicates the user's account key.
       * </pre>
       *
       * <code>string key = 2;</code>
       */
      public com.google.protobuf.ByteString
          getKeyBytes() {
        java.lang.Object ref = key_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          key_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Indicates the user's account key.
       * </pre>
       *
       * <code>string key = 2;</code>
       */
      public Builder setKey(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        key_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Indicates the user's account key.
       * </pre>
       *
       * <code>string key = 2;</code>
       */
      public Builder clearKey() {
        
        key_ = getDefaultInstance().getKey();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Indicates the user's account key.
       * </pre>
       *
       * <code>string key = 2;</code>
       */
      public Builder setKeyBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        key_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object token_ = "";
      /**
       * <pre>
       * Authorized token resulting from the authentication operation.
       * </pre>
       *
       * <code>string token = 3;</code>
       */
      public java.lang.String getToken() {
        java.lang.Object ref = token_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          token_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Authorized token resulting from the authentication operation.
       * </pre>
       *
       * <code>string token = 3;</code>
       */
      public com.google.protobuf.ByteString
          getTokenBytes() {
        java.lang.Object ref = token_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          token_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Authorized token resulting from the authentication operation.
       * </pre>
       *
       * <code>string token = 3;</code>
       */
      public Builder setToken(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        token_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Authorized token resulting from the authentication operation.
       * </pre>
       *
       * <code>string token = 3;</code>
       */
      public Builder clearToken() {
        
        token_ = getDefaultInstance().getToken();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Authorized token resulting from the authentication operation.
       * </pre>
       *
       * <code>string token = 3;</code>
       */
      public Builder setTokenBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        token_ = value;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response)
    private static final io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response();
    }

    public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Response>
        PARSER = new com.google.protobuf.AbstractParser<Response>() {
      public Response parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Response(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Response> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Response> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Response getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.services.auth.v1beta1.AuthenticateUser)) {
      return super.equals(obj);
    }
    io.bloombox.schema.services.auth.v1beta1.AuthenticateUser other = (io.bloombox.schema.services.auth.v1beta1.AuthenticateUser) obj;

    boolean result = true;
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.services.auth.v1beta1.AuthenticateUser prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies an RPC operation wherein a user has requested an assertion of their identity be validated by the server.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.auth.v1beta1.AuthenticateUser}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.services.auth.v1beta1.AuthenticateUser)
      io.bloombox.schema.services.auth.v1beta1.AuthenticateUserOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_AuthenticateUser_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_AuthenticateUser_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.class, io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.Builder.class);
    }

    // Construct using io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_AuthenticateUser_descriptor;
    }

    public io.bloombox.schema.services.auth.v1beta1.AuthenticateUser getDefaultInstanceForType() {
      return io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.getDefaultInstance();
    }

    public io.bloombox.schema.services.auth.v1beta1.AuthenticateUser build() {
      io.bloombox.schema.services.auth.v1beta1.AuthenticateUser result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.services.auth.v1beta1.AuthenticateUser buildPartial() {
      io.bloombox.schema.services.auth.v1beta1.AuthenticateUser result = new io.bloombox.schema.services.auth.v1beta1.AuthenticateUser(this);
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.services.auth.v1beta1.AuthenticateUser) {
        return mergeFrom((io.bloombox.schema.services.auth.v1beta1.AuthenticateUser)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.services.auth.v1beta1.AuthenticateUser other) {
      if (other == io.bloombox.schema.services.auth.v1beta1.AuthenticateUser.getDefaultInstance()) return this;
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.services.auth.v1beta1.AuthenticateUser parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.services.auth.v1beta1.AuthenticateUser) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.services.auth.v1beta1.AuthenticateUser)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.services.auth.v1beta1.AuthenticateUser)
  private static final io.bloombox.schema.services.auth.v1beta1.AuthenticateUser DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.services.auth.v1beta1.AuthenticateUser();
  }

  public static io.bloombox.schema.services.auth.v1beta1.AuthenticateUser getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AuthenticateUser>
      PARSER = new com.google.protobuf.AbstractParser<AuthenticateUser>() {
    public AuthenticateUser parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new AuthenticateUser(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<AuthenticateUser> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AuthenticateUser> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.services.auth.v1beta1.AuthenticateUser getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

