/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: auth/v1beta1/AuthService_Beta1.proto

package io.bloombox.schema.services.auth.v1beta1;

/**
 * <pre>
 * Specifies an operation wherein a user is demonstrating or indicating a decision regarding a consent flow, and would
 * like to proceed with the next sensible action.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.services.auth.v1beta1.ConsentDecision}
 */
public  final class ConsentDecision extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.services.auth.v1beta1.ConsentDecision)
    ConsentDecisionOrBuilder {
private static final long serialVersionUID = 0L;
  // Use ConsentDecision.newBuilder() to construct.
  private ConsentDecision(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private ConsentDecision() {
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private ConsentDecision(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ConsentDecision_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ConsentDecision_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.services.auth.v1beta1.ConsentDecision.class, io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Builder.class);
  }

  public interface AcceptOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * User ID from the on-page access or identity token.
     * </pre>
     *
     * <code>string uid = 1;</code>
     */
    java.lang.String getUid();
    /**
     * <pre>
     * User ID from the on-page access or identity token.
     * </pre>
     *
     * <code>string uid = 1;</code>
     */
    com.google.protobuf.ByteString
        getUidBytes();

    /**
     * <pre>
     * ID for the consent flow.
     * </pre>
     *
     * <code>string consent = 2;</code>
     */
    java.lang.String getConsent();
    /**
     * <pre>
     * ID for the consent flow.
     * </pre>
     *
     * <code>string consent = 2;</code>
     */
    com.google.protobuf.ByteString
        getConsentBytes();

    /**
     * <pre>
     * Scope(s) granted in the consent flow.
     * </pre>
     *
     * <code>repeated string scope = 3;</code>
     */
    java.util.List<java.lang.String>
        getScopeList();
    /**
     * <pre>
     * Scope(s) granted in the consent flow.
     * </pre>
     *
     * <code>repeated string scope = 3;</code>
     */
    int getScopeCount();
    /**
     * <pre>
     * Scope(s) granted in the consent flow.
     * </pre>
     *
     * <code>repeated string scope = 3;</code>
     */
    java.lang.String getScope(int index);
    /**
     * <pre>
     * Scope(s) granted in the consent flow.
     * </pre>
     *
     * <code>repeated string scope = 3;</code>
     */
    com.google.protobuf.ByteString
        getScopeBytes(int index);
  }
  /**
   * <pre>
   * Request indicating an acceptance of the consent challenge - or, 'authorizing' a consent flow.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept}
   */
  public  static final class Accept extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept)
      AcceptOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Accept.newBuilder() to construct.
    private Accept(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Accept() {
      uid_ = "";
      consent_ = "";
      scope_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Accept(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              uid_ = s;
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();

              consent_ = s;
              break;
            }
            case 26: {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
                scope_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000004;
              }
              scope_.add(s);
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
          scope_ = scope_.getUnmodifiableView();
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ConsentDecision_Accept_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ConsentDecision_Accept_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept.class, io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept.Builder.class);
    }

    private int bitField0_;
    public static final int UID_FIELD_NUMBER = 1;
    private volatile java.lang.Object uid_;
    /**
     * <pre>
     * User ID from the on-page access or identity token.
     * </pre>
     *
     * <code>string uid = 1;</code>
     */
    public java.lang.String getUid() {
      java.lang.Object ref = uid_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uid_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * User ID from the on-page access or identity token.
     * </pre>
     *
     * <code>string uid = 1;</code>
     */
    public com.google.protobuf.ByteString
        getUidBytes() {
      java.lang.Object ref = uid_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        uid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CONSENT_FIELD_NUMBER = 2;
    private volatile java.lang.Object consent_;
    /**
     * <pre>
     * ID for the consent flow.
     * </pre>
     *
     * <code>string consent = 2;</code>
     */
    public java.lang.String getConsent() {
      java.lang.Object ref = consent_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        consent_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * ID for the consent flow.
     * </pre>
     *
     * <code>string consent = 2;</code>
     */
    public com.google.protobuf.ByteString
        getConsentBytes() {
      java.lang.Object ref = consent_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        consent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SCOPE_FIELD_NUMBER = 3;
    private com.google.protobuf.LazyStringList scope_;
    /**
     * <pre>
     * Scope(s) granted in the consent flow.
     * </pre>
     *
     * <code>repeated string scope = 3;</code>
     */
    public com.google.protobuf.ProtocolStringList
        getScopeList() {
      return scope_;
    }
    /**
     * <pre>
     * Scope(s) granted in the consent flow.
     * </pre>
     *
     * <code>repeated string scope = 3;</code>
     */
    public int getScopeCount() {
      return scope_.size();
    }
    /**
     * <pre>
     * Scope(s) granted in the consent flow.
     * </pre>
     *
     * <code>repeated string scope = 3;</code>
     */
    public java.lang.String getScope(int index) {
      return scope_.get(index);
    }
    /**
     * <pre>
     * Scope(s) granted in the consent flow.
     * </pre>
     *
     * <code>repeated string scope = 3;</code>
     */
    public com.google.protobuf.ByteString
        getScopeBytes(int index) {
      return scope_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getUidBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, uid_);
      }
      if (!getConsentBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, consent_);
      }
      for (int i = 0; i < scope_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, scope_.getRaw(i));
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getUidBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, uid_);
      }
      if (!getConsentBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, consent_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < scope_.size(); i++) {
          dataSize += computeStringSizeNoTag(scope_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getScopeList().size();
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept other = (io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept) obj;

      boolean result = true;
      result = result && getUid()
          .equals(other.getUid());
      result = result && getConsent()
          .equals(other.getConsent());
      result = result && getScopeList()
          .equals(other.getScopeList());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + UID_FIELD_NUMBER;
      hash = (53 * hash) + getUid().hashCode();
      hash = (37 * hash) + CONSENT_FIELD_NUMBER;
      hash = (53 * hash) + getConsent().hashCode();
      if (getScopeCount() > 0) {
        hash = (37 * hash) + SCOPE_FIELD_NUMBER;
        hash = (53 * hash) + getScopeList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Request indicating an acceptance of the consent challenge - or, 'authorizing' a consent flow.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept)
        io.bloombox.schema.services.auth.v1beta1.ConsentDecision.AcceptOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ConsentDecision_Accept_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ConsentDecision_Accept_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept.class, io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept.Builder.class);
      }

      // Construct using io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        uid_ = "";

        consent_ = "";

        scope_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ConsentDecision_Accept_descriptor;
      }

      public io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept getDefaultInstanceForType() {
        return io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept.getDefaultInstance();
      }

      public io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept build() {
        io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept buildPartial() {
        io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept result = new io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        result.uid_ = uid_;
        result.consent_ = consent_;
        if (((bitField0_ & 0x00000004) == 0x00000004)) {
          scope_ = scope_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.scope_ = scope_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept) {
          return mergeFrom((io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept other) {
        if (other == io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept.getDefaultInstance()) return this;
        if (!other.getUid().isEmpty()) {
          uid_ = other.uid_;
          onChanged();
        }
        if (!other.getConsent().isEmpty()) {
          consent_ = other.consent_;
          onChanged();
        }
        if (!other.scope_.isEmpty()) {
          if (scope_.isEmpty()) {
            scope_ = other.scope_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureScopeIsMutable();
            scope_.addAll(other.scope_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object uid_ = "";
      /**
       * <pre>
       * User ID from the on-page access or identity token.
       * </pre>
       *
       * <code>string uid = 1;</code>
       */
      public java.lang.String getUid() {
        java.lang.Object ref = uid_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          uid_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * User ID from the on-page access or identity token.
       * </pre>
       *
       * <code>string uid = 1;</code>
       */
      public com.google.protobuf.ByteString
          getUidBytes() {
        java.lang.Object ref = uid_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          uid_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * User ID from the on-page access or identity token.
       * </pre>
       *
       * <code>string uid = 1;</code>
       */
      public Builder setUid(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        uid_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * User ID from the on-page access or identity token.
       * </pre>
       *
       * <code>string uid = 1;</code>
       */
      public Builder clearUid() {
        
        uid_ = getDefaultInstance().getUid();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * User ID from the on-page access or identity token.
       * </pre>
       *
       * <code>string uid = 1;</code>
       */
      public Builder setUidBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        uid_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object consent_ = "";
      /**
       * <pre>
       * ID for the consent flow.
       * </pre>
       *
       * <code>string consent = 2;</code>
       */
      public java.lang.String getConsent() {
        java.lang.Object ref = consent_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          consent_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * ID for the consent flow.
       * </pre>
       *
       * <code>string consent = 2;</code>
       */
      public com.google.protobuf.ByteString
          getConsentBytes() {
        java.lang.Object ref = consent_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          consent_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * ID for the consent flow.
       * </pre>
       *
       * <code>string consent = 2;</code>
       */
      public Builder setConsent(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        consent_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * ID for the consent flow.
       * </pre>
       *
       * <code>string consent = 2;</code>
       */
      public Builder clearConsent() {
        
        consent_ = getDefaultInstance().getConsent();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * ID for the consent flow.
       * </pre>
       *
       * <code>string consent = 2;</code>
       */
      public Builder setConsentBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        consent_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList scope_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureScopeIsMutable() {
        if (!((bitField0_ & 0x00000004) == 0x00000004)) {
          scope_ = new com.google.protobuf.LazyStringArrayList(scope_);
          bitField0_ |= 0x00000004;
         }
      }
      /**
       * <pre>
       * Scope(s) granted in the consent flow.
       * </pre>
       *
       * <code>repeated string scope = 3;</code>
       */
      public com.google.protobuf.ProtocolStringList
          getScopeList() {
        return scope_.getUnmodifiableView();
      }
      /**
       * <pre>
       * Scope(s) granted in the consent flow.
       * </pre>
       *
       * <code>repeated string scope = 3;</code>
       */
      public int getScopeCount() {
        return scope_.size();
      }
      /**
       * <pre>
       * Scope(s) granted in the consent flow.
       * </pre>
       *
       * <code>repeated string scope = 3;</code>
       */
      public java.lang.String getScope(int index) {
        return scope_.get(index);
      }
      /**
       * <pre>
       * Scope(s) granted in the consent flow.
       * </pre>
       *
       * <code>repeated string scope = 3;</code>
       */
      public com.google.protobuf.ByteString
          getScopeBytes(int index) {
        return scope_.getByteString(index);
      }
      /**
       * <pre>
       * Scope(s) granted in the consent flow.
       * </pre>
       *
       * <code>repeated string scope = 3;</code>
       */
      public Builder setScope(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureScopeIsMutable();
        scope_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Scope(s) granted in the consent flow.
       * </pre>
       *
       * <code>repeated string scope = 3;</code>
       */
      public Builder addScope(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureScopeIsMutable();
        scope_.add(value);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Scope(s) granted in the consent flow.
       * </pre>
       *
       * <code>repeated string scope = 3;</code>
       */
      public Builder addAllScope(
          java.lang.Iterable<java.lang.String> values) {
        ensureScopeIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, scope_);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Scope(s) granted in the consent flow.
       * </pre>
       *
       * <code>repeated string scope = 3;</code>
       */
      public Builder clearScope() {
        scope_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Scope(s) granted in the consent flow.
       * </pre>
       *
       * <code>repeated string scope = 3;</code>
       */
      public Builder addScopeBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        ensureScopeIsMutable();
        scope_.add(value);
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept)
    private static final io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept();
    }

    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Accept>
        PARSER = new com.google.protobuf.AbstractParser<Accept>() {
      public Accept parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Accept(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Accept> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Accept> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Accept getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface RejectOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * User ID from the on-page access or identity token.
     * </pre>
     *
     * <code>string uid = 1;</code>
     */
    java.lang.String getUid();
    /**
     * <pre>
     * User ID from the on-page access or identity token.
     * </pre>
     *
     * <code>string uid = 1;</code>
     */
    com.google.protobuf.ByteString
        getUidBytes();

    /**
     * <pre>
     * ID for the consent flow.
     * </pre>
     *
     * <code>string consent = 2;</code>
     */
    java.lang.String getConsent();
    /**
     * <pre>
     * ID for the consent flow.
     * </pre>
     *
     * <code>string consent = 2;</code>
     */
    com.google.protobuf.ByteString
        getConsentBytes();
  }
  /**
   * <pre>
   * Request indicating a rejection of the consent challenge - or, 'denying' a consent flow.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject}
   */
  public  static final class Reject extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject)
      RejectOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Reject.newBuilder() to construct.
    private Reject(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Reject() {
      uid_ = "";
      consent_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Reject(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              uid_ = s;
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();

              consent_ = s;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ConsentDecision_Reject_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ConsentDecision_Reject_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject.class, io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject.Builder.class);
    }

    public static final int UID_FIELD_NUMBER = 1;
    private volatile java.lang.Object uid_;
    /**
     * <pre>
     * User ID from the on-page access or identity token.
     * </pre>
     *
     * <code>string uid = 1;</code>
     */
    public java.lang.String getUid() {
      java.lang.Object ref = uid_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uid_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * User ID from the on-page access or identity token.
     * </pre>
     *
     * <code>string uid = 1;</code>
     */
    public com.google.protobuf.ByteString
        getUidBytes() {
      java.lang.Object ref = uid_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        uid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CONSENT_FIELD_NUMBER = 2;
    private volatile java.lang.Object consent_;
    /**
     * <pre>
     * ID for the consent flow.
     * </pre>
     *
     * <code>string consent = 2;</code>
     */
    public java.lang.String getConsent() {
      java.lang.Object ref = consent_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        consent_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * ID for the consent flow.
     * </pre>
     *
     * <code>string consent = 2;</code>
     */
    public com.google.protobuf.ByteString
        getConsentBytes() {
      java.lang.Object ref = consent_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        consent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getUidBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, uid_);
      }
      if (!getConsentBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, consent_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getUidBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, uid_);
      }
      if (!getConsentBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, consent_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject other = (io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject) obj;

      boolean result = true;
      result = result && getUid()
          .equals(other.getUid());
      result = result && getConsent()
          .equals(other.getConsent());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + UID_FIELD_NUMBER;
      hash = (53 * hash) + getUid().hashCode();
      hash = (37 * hash) + CONSENT_FIELD_NUMBER;
      hash = (53 * hash) + getConsent().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Request indicating a rejection of the consent challenge - or, 'denying' a consent flow.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject)
        io.bloombox.schema.services.auth.v1beta1.ConsentDecision.RejectOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ConsentDecision_Reject_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ConsentDecision_Reject_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject.class, io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject.Builder.class);
      }

      // Construct using io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        uid_ = "";

        consent_ = "";

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ConsentDecision_Reject_descriptor;
      }

      public io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject getDefaultInstanceForType() {
        return io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject.getDefaultInstance();
      }

      public io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject build() {
        io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject buildPartial() {
        io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject result = new io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject(this);
        result.uid_ = uid_;
        result.consent_ = consent_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject) {
          return mergeFrom((io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject other) {
        if (other == io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject.getDefaultInstance()) return this;
        if (!other.getUid().isEmpty()) {
          uid_ = other.uid_;
          onChanged();
        }
        if (!other.getConsent().isEmpty()) {
          consent_ = other.consent_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object uid_ = "";
      /**
       * <pre>
       * User ID from the on-page access or identity token.
       * </pre>
       *
       * <code>string uid = 1;</code>
       */
      public java.lang.String getUid() {
        java.lang.Object ref = uid_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          uid_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * User ID from the on-page access or identity token.
       * </pre>
       *
       * <code>string uid = 1;</code>
       */
      public com.google.protobuf.ByteString
          getUidBytes() {
        java.lang.Object ref = uid_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          uid_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * User ID from the on-page access or identity token.
       * </pre>
       *
       * <code>string uid = 1;</code>
       */
      public Builder setUid(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        uid_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * User ID from the on-page access or identity token.
       * </pre>
       *
       * <code>string uid = 1;</code>
       */
      public Builder clearUid() {
        
        uid_ = getDefaultInstance().getUid();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * User ID from the on-page access or identity token.
       * </pre>
       *
       * <code>string uid = 1;</code>
       */
      public Builder setUidBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        uid_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object consent_ = "";
      /**
       * <pre>
       * ID for the consent flow.
       * </pre>
       *
       * <code>string consent = 2;</code>
       */
      public java.lang.String getConsent() {
        java.lang.Object ref = consent_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          consent_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * ID for the consent flow.
       * </pre>
       *
       * <code>string consent = 2;</code>
       */
      public com.google.protobuf.ByteString
          getConsentBytes() {
        java.lang.Object ref = consent_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          consent_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * ID for the consent flow.
       * </pre>
       *
       * <code>string consent = 2;</code>
       */
      public Builder setConsent(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        consent_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * ID for the consent flow.
       * </pre>
       *
       * <code>string consent = 2;</code>
       */
      public Builder clearConsent() {
        
        consent_ = getDefaultInstance().getConsent();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * ID for the consent flow.
       * </pre>
       *
       * <code>string consent = 2;</code>
       */
      public Builder setConsentBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        consent_ = value;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject)
    private static final io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject();
    }

    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Reject>
        PARSER = new com.google.protobuf.AbstractParser<Reject>() {
      public Reject parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Reject(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Reject> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Reject> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Reject getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ResponseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.auth.v1beta1.ConsentDecision.Response)
      com.google.protobuf.MessageOrBuilder {
  }
  /**
   * <pre>
   * Specifies the response payload for a consent decision indication.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.auth.v1beta1.ConsentDecision.Response}
   */
  public  static final class Response extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.auth.v1beta1.ConsentDecision.Response)
      ResponseOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Response.newBuilder() to construct.
    private Response(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Response() {
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Response(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ConsentDecision_Response_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ConsentDecision_Response_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response.class, io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response.Builder.class);
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response other = (io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response) obj;

      boolean result = true;
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies the response payload for a consent decision indication.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.auth.v1beta1.ConsentDecision.Response}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.auth.v1beta1.ConsentDecision.Response)
        io.bloombox.schema.services.auth.v1beta1.ConsentDecision.ResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ConsentDecision_Response_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ConsentDecision_Response_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response.class, io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response.Builder.class);
      }

      // Construct using io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ConsentDecision_Response_descriptor;
      }

      public io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response getDefaultInstanceForType() {
        return io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response.getDefaultInstance();
      }

      public io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response build() {
        io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response buildPartial() {
        io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response result = new io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response(this);
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response) {
          return mergeFrom((io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response other) {
        if (other == io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response.getDefaultInstance()) return this;
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.auth.v1beta1.ConsentDecision.Response)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.auth.v1beta1.ConsentDecision.Response)
    private static final io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response();
    }

    public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Response>
        PARSER = new com.google.protobuf.AbstractParser<Response>() {
      public Response parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Response(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Response> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Response> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Response getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.services.auth.v1beta1.ConsentDecision)) {
      return super.equals(obj);
    }
    io.bloombox.schema.services.auth.v1beta1.ConsentDecision other = (io.bloombox.schema.services.auth.v1beta1.ConsentDecision) obj;

    boolean result = true;
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.services.auth.v1beta1.ConsentDecision prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies an operation wherein a user is demonstrating or indicating a decision regarding a consent flow, and would
   * like to proceed with the next sensible action.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.auth.v1beta1.ConsentDecision}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.services.auth.v1beta1.ConsentDecision)
      io.bloombox.schema.services.auth.v1beta1.ConsentDecisionOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ConsentDecision_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ConsentDecision_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.auth.v1beta1.ConsentDecision.class, io.bloombox.schema.services.auth.v1beta1.ConsentDecision.Builder.class);
    }

    // Construct using io.bloombox.schema.services.auth.v1beta1.ConsentDecision.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ConsentDecision_descriptor;
    }

    public io.bloombox.schema.services.auth.v1beta1.ConsentDecision getDefaultInstanceForType() {
      return io.bloombox.schema.services.auth.v1beta1.ConsentDecision.getDefaultInstance();
    }

    public io.bloombox.schema.services.auth.v1beta1.ConsentDecision build() {
      io.bloombox.schema.services.auth.v1beta1.ConsentDecision result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.services.auth.v1beta1.ConsentDecision buildPartial() {
      io.bloombox.schema.services.auth.v1beta1.ConsentDecision result = new io.bloombox.schema.services.auth.v1beta1.ConsentDecision(this);
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.services.auth.v1beta1.ConsentDecision) {
        return mergeFrom((io.bloombox.schema.services.auth.v1beta1.ConsentDecision)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.services.auth.v1beta1.ConsentDecision other) {
      if (other == io.bloombox.schema.services.auth.v1beta1.ConsentDecision.getDefaultInstance()) return this;
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.services.auth.v1beta1.ConsentDecision parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.services.auth.v1beta1.ConsentDecision) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.services.auth.v1beta1.ConsentDecision)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.services.auth.v1beta1.ConsentDecision)
  private static final io.bloombox.schema.services.auth.v1beta1.ConsentDecision DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.services.auth.v1beta1.ConsentDecision();
  }

  public static io.bloombox.schema.services.auth.v1beta1.ConsentDecision getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ConsentDecision>
      PARSER = new com.google.protobuf.AbstractParser<ConsentDecision>() {
    public ConsentDecision parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new ConsentDecision(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<ConsentDecision> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ConsentDecision> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.services.auth.v1beta1.ConsentDecision getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

