/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: auth/v1beta1/AuthService_Beta1.proto

package io.bloombox.schema.services.auth.v1beta1;

/**
 * <pre>
 * Specifies an operation to resolve authorized access credentials for Firebase and other services, based on a completed
 * authentication and authorization/consent flow.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.services.auth.v1beta1.ResolveToken}
 */
public  final class ResolveToken extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.services.auth.v1beta1.ResolveToken)
    ResolveTokenOrBuilder {
private static final long serialVersionUID = 0L;
  // Use ResolveToken.newBuilder() to construct.
  private ResolveToken(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private ResolveToken() {
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private ResolveToken(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ResolveToken_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ResolveToken_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.services.auth.v1beta1.ResolveToken.class, io.bloombox.schema.services.auth.v1beta1.ResolveToken.Builder.class);
  }

  public interface RequestOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.auth.v1beta1.ResolveToken.Request)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * OAuth2 client ID.
     * </pre>
     *
     * <code>string client_id = 1;</code>
     */
    java.lang.String getClientId();
    /**
     * <pre>
     * OAuth2 client ID.
     * </pre>
     *
     * <code>string client_id = 1;</code>
     */
    com.google.protobuf.ByteString
        getClientIdBytes();

    /**
     * <pre>
     * Encoded source origin.
     * </pre>
     *
     * <code>string origin = 2;</code>
     */
    java.lang.String getOrigin();
    /**
     * <pre>
     * Encoded source origin.
     * </pre>
     *
     * <code>string origin = 2;</code>
     */
    com.google.protobuf.ByteString
        getOriginBytes();

    /**
     * <pre>
     * State token for the active authentication flow.
     * </pre>
     *
     * <code>string state = 3;</code>
     */
    java.lang.String getState();
    /**
     * <pre>
     * State token for the active authentication flow.
     * </pre>
     *
     * <code>string state = 3;</code>
     */
    com.google.protobuf.ByteString
        getStateBytes();

    /**
     * <pre>
     * Captcha code to be used via reCAPTCHA.
     * </pre>
     *
     * <code>string captcha = 4;</code>
     */
    java.lang.String getCaptcha();
    /**
     * <pre>
     * Captcha code to be used via reCAPTCHA.
     * </pre>
     *
     * <code>string captcha = 4;</code>
     */
    com.google.protobuf.ByteString
        getCaptchaBytes();

    /**
     * <pre>
     * Active session ID.
     * </pre>
     *
     * <code>string session = 5;</code>
     */
    java.lang.String getSession();
    /**
     * <pre>
     * Active session ID.
     * </pre>
     *
     * <code>string session = 5;</code>
     */
    com.google.protobuf.ByteString
        getSessionBytes();

    /**
     * <pre>
     * Active device fingerprint.
     * </pre>
     *
     * <code>string fingerprint = 6;</code>
     */
    java.lang.String getFingerprint();
    /**
     * <pre>
     * Active device fingerprint.
     * </pre>
     *
     * <code>string fingerprint = 6;</code>
     */
    com.google.protobuf.ByteString
        getFingerprintBytes();

    /**
     * <pre>
     * Combined authentication/authorization ticket.
     * </pre>
     *
     * <code>.bloombox.schema.security.AuthPayload auth = 7;</code>
     */
    boolean hasAuth();
    /**
     * <pre>
     * Combined authentication/authorization ticket.
     * </pre>
     *
     * <code>.bloombox.schema.security.AuthPayload auth = 7;</code>
     */
    io.bloombox.schema.security.AuthPayload getAuth();
    /**
     * <pre>
     * Combined authentication/authorization ticket.
     * </pre>
     *
     * <code>.bloombox.schema.security.AuthPayload auth = 7;</code>
     */
    io.bloombox.schema.security.AuthPayloadOrBuilder getAuthOrBuilder();
  }
  /**
   * <pre>
   * Request to generate a platform authorization token.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.auth.v1beta1.ResolveToken.Request}
   */
  public  static final class Request extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.auth.v1beta1.ResolveToken.Request)
      RequestOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Request.newBuilder() to construct.
    private Request(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Request() {
      clientId_ = "";
      origin_ = "";
      state_ = "";
      captcha_ = "";
      session_ = "";
      fingerprint_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Request(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              clientId_ = s;
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();

              origin_ = s;
              break;
            }
            case 26: {
              java.lang.String s = input.readStringRequireUtf8();

              state_ = s;
              break;
            }
            case 34: {
              java.lang.String s = input.readStringRequireUtf8();

              captcha_ = s;
              break;
            }
            case 42: {
              java.lang.String s = input.readStringRequireUtf8();

              session_ = s;
              break;
            }
            case 50: {
              java.lang.String s = input.readStringRequireUtf8();

              fingerprint_ = s;
              break;
            }
            case 58: {
              io.bloombox.schema.security.AuthPayload.Builder subBuilder = null;
              if (auth_ != null) {
                subBuilder = auth_.toBuilder();
              }
              auth_ = input.readMessage(io.bloombox.schema.security.AuthPayload.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(auth_);
                auth_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ResolveToken_Request_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ResolveToken_Request_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request.class, io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request.Builder.class);
    }

    public static final int CLIENT_ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object clientId_;
    /**
     * <pre>
     * OAuth2 client ID.
     * </pre>
     *
     * <code>string client_id = 1;</code>
     */
    public java.lang.String getClientId() {
      java.lang.Object ref = clientId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clientId_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * OAuth2 client ID.
     * </pre>
     *
     * <code>string client_id = 1;</code>
     */
    public com.google.protobuf.ByteString
        getClientIdBytes() {
      java.lang.Object ref = clientId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        clientId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ORIGIN_FIELD_NUMBER = 2;
    private volatile java.lang.Object origin_;
    /**
     * <pre>
     * Encoded source origin.
     * </pre>
     *
     * <code>string origin = 2;</code>
     */
    public java.lang.String getOrigin() {
      java.lang.Object ref = origin_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        origin_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Encoded source origin.
     * </pre>
     *
     * <code>string origin = 2;</code>
     */
    public com.google.protobuf.ByteString
        getOriginBytes() {
      java.lang.Object ref = origin_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        origin_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int STATE_FIELD_NUMBER = 3;
    private volatile java.lang.Object state_;
    /**
     * <pre>
     * State token for the active authentication flow.
     * </pre>
     *
     * <code>string state = 3;</code>
     */
    public java.lang.String getState() {
      java.lang.Object ref = state_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        state_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * State token for the active authentication flow.
     * </pre>
     *
     * <code>string state = 3;</code>
     */
    public com.google.protobuf.ByteString
        getStateBytes() {
      java.lang.Object ref = state_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        state_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CAPTCHA_FIELD_NUMBER = 4;
    private volatile java.lang.Object captcha_;
    /**
     * <pre>
     * Captcha code to be used via reCAPTCHA.
     * </pre>
     *
     * <code>string captcha = 4;</code>
     */
    public java.lang.String getCaptcha() {
      java.lang.Object ref = captcha_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        captcha_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Captcha code to be used via reCAPTCHA.
     * </pre>
     *
     * <code>string captcha = 4;</code>
     */
    public com.google.protobuf.ByteString
        getCaptchaBytes() {
      java.lang.Object ref = captcha_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        captcha_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SESSION_FIELD_NUMBER = 5;
    private volatile java.lang.Object session_;
    /**
     * <pre>
     * Active session ID.
     * </pre>
     *
     * <code>string session = 5;</code>
     */
    public java.lang.String getSession() {
      java.lang.Object ref = session_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        session_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Active session ID.
     * </pre>
     *
     * <code>string session = 5;</code>
     */
    public com.google.protobuf.ByteString
        getSessionBytes() {
      java.lang.Object ref = session_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        session_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FINGERPRINT_FIELD_NUMBER = 6;
    private volatile java.lang.Object fingerprint_;
    /**
     * <pre>
     * Active device fingerprint.
     * </pre>
     *
     * <code>string fingerprint = 6;</code>
     */
    public java.lang.String getFingerprint() {
      java.lang.Object ref = fingerprint_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fingerprint_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Active device fingerprint.
     * </pre>
     *
     * <code>string fingerprint = 6;</code>
     */
    public com.google.protobuf.ByteString
        getFingerprintBytes() {
      java.lang.Object ref = fingerprint_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        fingerprint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int AUTH_FIELD_NUMBER = 7;
    private io.bloombox.schema.security.AuthPayload auth_;
    /**
     * <pre>
     * Combined authentication/authorization ticket.
     * </pre>
     *
     * <code>.bloombox.schema.security.AuthPayload auth = 7;</code>
     */
    public boolean hasAuth() {
      return auth_ != null;
    }
    /**
     * <pre>
     * Combined authentication/authorization ticket.
     * </pre>
     *
     * <code>.bloombox.schema.security.AuthPayload auth = 7;</code>
     */
    public io.bloombox.schema.security.AuthPayload getAuth() {
      return auth_ == null ? io.bloombox.schema.security.AuthPayload.getDefaultInstance() : auth_;
    }
    /**
     * <pre>
     * Combined authentication/authorization ticket.
     * </pre>
     *
     * <code>.bloombox.schema.security.AuthPayload auth = 7;</code>
     */
    public io.bloombox.schema.security.AuthPayloadOrBuilder getAuthOrBuilder() {
      return getAuth();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getClientIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, clientId_);
      }
      if (!getOriginBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, origin_);
      }
      if (!getStateBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, state_);
      }
      if (!getCaptchaBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, captcha_);
      }
      if (!getSessionBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, session_);
      }
      if (!getFingerprintBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, fingerprint_);
      }
      if (auth_ != null) {
        output.writeMessage(7, getAuth());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getClientIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, clientId_);
      }
      if (!getOriginBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, origin_);
      }
      if (!getStateBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, state_);
      }
      if (!getCaptchaBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, captcha_);
      }
      if (!getSessionBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, session_);
      }
      if (!getFingerprintBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, fingerprint_);
      }
      if (auth_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(7, getAuth());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request other = (io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request) obj;

      boolean result = true;
      result = result && getClientId()
          .equals(other.getClientId());
      result = result && getOrigin()
          .equals(other.getOrigin());
      result = result && getState()
          .equals(other.getState());
      result = result && getCaptcha()
          .equals(other.getCaptcha());
      result = result && getSession()
          .equals(other.getSession());
      result = result && getFingerprint()
          .equals(other.getFingerprint());
      result = result && (hasAuth() == other.hasAuth());
      if (hasAuth()) {
        result = result && getAuth()
            .equals(other.getAuth());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CLIENT_ID_FIELD_NUMBER;
      hash = (53 * hash) + getClientId().hashCode();
      hash = (37 * hash) + ORIGIN_FIELD_NUMBER;
      hash = (53 * hash) + getOrigin().hashCode();
      hash = (37 * hash) + STATE_FIELD_NUMBER;
      hash = (53 * hash) + getState().hashCode();
      hash = (37 * hash) + CAPTCHA_FIELD_NUMBER;
      hash = (53 * hash) + getCaptcha().hashCode();
      hash = (37 * hash) + SESSION_FIELD_NUMBER;
      hash = (53 * hash) + getSession().hashCode();
      hash = (37 * hash) + FINGERPRINT_FIELD_NUMBER;
      hash = (53 * hash) + getFingerprint().hashCode();
      if (hasAuth()) {
        hash = (37 * hash) + AUTH_FIELD_NUMBER;
        hash = (53 * hash) + getAuth().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Request to generate a platform authorization token.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.auth.v1beta1.ResolveToken.Request}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.auth.v1beta1.ResolveToken.Request)
        io.bloombox.schema.services.auth.v1beta1.ResolveToken.RequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ResolveToken_Request_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ResolveToken_Request_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request.class, io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request.Builder.class);
      }

      // Construct using io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        clientId_ = "";

        origin_ = "";

        state_ = "";

        captcha_ = "";

        session_ = "";

        fingerprint_ = "";

        if (authBuilder_ == null) {
          auth_ = null;
        } else {
          auth_ = null;
          authBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ResolveToken_Request_descriptor;
      }

      public io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request getDefaultInstanceForType() {
        return io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request.getDefaultInstance();
      }

      public io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request build() {
        io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request buildPartial() {
        io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request result = new io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request(this);
        result.clientId_ = clientId_;
        result.origin_ = origin_;
        result.state_ = state_;
        result.captcha_ = captcha_;
        result.session_ = session_;
        result.fingerprint_ = fingerprint_;
        if (authBuilder_ == null) {
          result.auth_ = auth_;
        } else {
          result.auth_ = authBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request) {
          return mergeFrom((io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request other) {
        if (other == io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request.getDefaultInstance()) return this;
        if (!other.getClientId().isEmpty()) {
          clientId_ = other.clientId_;
          onChanged();
        }
        if (!other.getOrigin().isEmpty()) {
          origin_ = other.origin_;
          onChanged();
        }
        if (!other.getState().isEmpty()) {
          state_ = other.state_;
          onChanged();
        }
        if (!other.getCaptcha().isEmpty()) {
          captcha_ = other.captcha_;
          onChanged();
        }
        if (!other.getSession().isEmpty()) {
          session_ = other.session_;
          onChanged();
        }
        if (!other.getFingerprint().isEmpty()) {
          fingerprint_ = other.fingerprint_;
          onChanged();
        }
        if (other.hasAuth()) {
          mergeAuth(other.getAuth());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object clientId_ = "";
      /**
       * <pre>
       * OAuth2 client ID.
       * </pre>
       *
       * <code>string client_id = 1;</code>
       */
      public java.lang.String getClientId() {
        java.lang.Object ref = clientId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          clientId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * OAuth2 client ID.
       * </pre>
       *
       * <code>string client_id = 1;</code>
       */
      public com.google.protobuf.ByteString
          getClientIdBytes() {
        java.lang.Object ref = clientId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          clientId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * OAuth2 client ID.
       * </pre>
       *
       * <code>string client_id = 1;</code>
       */
      public Builder setClientId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        clientId_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * OAuth2 client ID.
       * </pre>
       *
       * <code>string client_id = 1;</code>
       */
      public Builder clearClientId() {
        
        clientId_ = getDefaultInstance().getClientId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * OAuth2 client ID.
       * </pre>
       *
       * <code>string client_id = 1;</code>
       */
      public Builder setClientIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        clientId_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object origin_ = "";
      /**
       * <pre>
       * Encoded source origin.
       * </pre>
       *
       * <code>string origin = 2;</code>
       */
      public java.lang.String getOrigin() {
        java.lang.Object ref = origin_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          origin_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Encoded source origin.
       * </pre>
       *
       * <code>string origin = 2;</code>
       */
      public com.google.protobuf.ByteString
          getOriginBytes() {
        java.lang.Object ref = origin_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          origin_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Encoded source origin.
       * </pre>
       *
       * <code>string origin = 2;</code>
       */
      public Builder setOrigin(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        origin_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Encoded source origin.
       * </pre>
       *
       * <code>string origin = 2;</code>
       */
      public Builder clearOrigin() {
        
        origin_ = getDefaultInstance().getOrigin();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Encoded source origin.
       * </pre>
       *
       * <code>string origin = 2;</code>
       */
      public Builder setOriginBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        origin_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object state_ = "";
      /**
       * <pre>
       * State token for the active authentication flow.
       * </pre>
       *
       * <code>string state = 3;</code>
       */
      public java.lang.String getState() {
        java.lang.Object ref = state_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          state_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * State token for the active authentication flow.
       * </pre>
       *
       * <code>string state = 3;</code>
       */
      public com.google.protobuf.ByteString
          getStateBytes() {
        java.lang.Object ref = state_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          state_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * State token for the active authentication flow.
       * </pre>
       *
       * <code>string state = 3;</code>
       */
      public Builder setState(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        state_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * State token for the active authentication flow.
       * </pre>
       *
       * <code>string state = 3;</code>
       */
      public Builder clearState() {
        
        state_ = getDefaultInstance().getState();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * State token for the active authentication flow.
       * </pre>
       *
       * <code>string state = 3;</code>
       */
      public Builder setStateBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        state_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object captcha_ = "";
      /**
       * <pre>
       * Captcha code to be used via reCAPTCHA.
       * </pre>
       *
       * <code>string captcha = 4;</code>
       */
      public java.lang.String getCaptcha() {
        java.lang.Object ref = captcha_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          captcha_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Captcha code to be used via reCAPTCHA.
       * </pre>
       *
       * <code>string captcha = 4;</code>
       */
      public com.google.protobuf.ByteString
          getCaptchaBytes() {
        java.lang.Object ref = captcha_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          captcha_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Captcha code to be used via reCAPTCHA.
       * </pre>
       *
       * <code>string captcha = 4;</code>
       */
      public Builder setCaptcha(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        captcha_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Captcha code to be used via reCAPTCHA.
       * </pre>
       *
       * <code>string captcha = 4;</code>
       */
      public Builder clearCaptcha() {
        
        captcha_ = getDefaultInstance().getCaptcha();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Captcha code to be used via reCAPTCHA.
       * </pre>
       *
       * <code>string captcha = 4;</code>
       */
      public Builder setCaptchaBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        captcha_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object session_ = "";
      /**
       * <pre>
       * Active session ID.
       * </pre>
       *
       * <code>string session = 5;</code>
       */
      public java.lang.String getSession() {
        java.lang.Object ref = session_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          session_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Active session ID.
       * </pre>
       *
       * <code>string session = 5;</code>
       */
      public com.google.protobuf.ByteString
          getSessionBytes() {
        java.lang.Object ref = session_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          session_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Active session ID.
       * </pre>
       *
       * <code>string session = 5;</code>
       */
      public Builder setSession(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        session_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Active session ID.
       * </pre>
       *
       * <code>string session = 5;</code>
       */
      public Builder clearSession() {
        
        session_ = getDefaultInstance().getSession();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Active session ID.
       * </pre>
       *
       * <code>string session = 5;</code>
       */
      public Builder setSessionBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        session_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object fingerprint_ = "";
      /**
       * <pre>
       * Active device fingerprint.
       * </pre>
       *
       * <code>string fingerprint = 6;</code>
       */
      public java.lang.String getFingerprint() {
        java.lang.Object ref = fingerprint_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          fingerprint_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Active device fingerprint.
       * </pre>
       *
       * <code>string fingerprint = 6;</code>
       */
      public com.google.protobuf.ByteString
          getFingerprintBytes() {
        java.lang.Object ref = fingerprint_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          fingerprint_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Active device fingerprint.
       * </pre>
       *
       * <code>string fingerprint = 6;</code>
       */
      public Builder setFingerprint(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        fingerprint_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Active device fingerprint.
       * </pre>
       *
       * <code>string fingerprint = 6;</code>
       */
      public Builder clearFingerprint() {
        
        fingerprint_ = getDefaultInstance().getFingerprint();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Active device fingerprint.
       * </pre>
       *
       * <code>string fingerprint = 6;</code>
       */
      public Builder setFingerprintBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        fingerprint_ = value;
        onChanged();
        return this;
      }

      private io.bloombox.schema.security.AuthPayload auth_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.security.AuthPayload, io.bloombox.schema.security.AuthPayload.Builder, io.bloombox.schema.security.AuthPayloadOrBuilder> authBuilder_;
      /**
       * <pre>
       * Combined authentication/authorization ticket.
       * </pre>
       *
       * <code>.bloombox.schema.security.AuthPayload auth = 7;</code>
       */
      public boolean hasAuth() {
        return authBuilder_ != null || auth_ != null;
      }
      /**
       * <pre>
       * Combined authentication/authorization ticket.
       * </pre>
       *
       * <code>.bloombox.schema.security.AuthPayload auth = 7;</code>
       */
      public io.bloombox.schema.security.AuthPayload getAuth() {
        if (authBuilder_ == null) {
          return auth_ == null ? io.bloombox.schema.security.AuthPayload.getDefaultInstance() : auth_;
        } else {
          return authBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Combined authentication/authorization ticket.
       * </pre>
       *
       * <code>.bloombox.schema.security.AuthPayload auth = 7;</code>
       */
      public Builder setAuth(io.bloombox.schema.security.AuthPayload value) {
        if (authBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          auth_ = value;
          onChanged();
        } else {
          authBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Combined authentication/authorization ticket.
       * </pre>
       *
       * <code>.bloombox.schema.security.AuthPayload auth = 7;</code>
       */
      public Builder setAuth(
          io.bloombox.schema.security.AuthPayload.Builder builderForValue) {
        if (authBuilder_ == null) {
          auth_ = builderForValue.build();
          onChanged();
        } else {
          authBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Combined authentication/authorization ticket.
       * </pre>
       *
       * <code>.bloombox.schema.security.AuthPayload auth = 7;</code>
       */
      public Builder mergeAuth(io.bloombox.schema.security.AuthPayload value) {
        if (authBuilder_ == null) {
          if (auth_ != null) {
            auth_ =
              io.bloombox.schema.security.AuthPayload.newBuilder(auth_).mergeFrom(value).buildPartial();
          } else {
            auth_ = value;
          }
          onChanged();
        } else {
          authBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Combined authentication/authorization ticket.
       * </pre>
       *
       * <code>.bloombox.schema.security.AuthPayload auth = 7;</code>
       */
      public Builder clearAuth() {
        if (authBuilder_ == null) {
          auth_ = null;
          onChanged();
        } else {
          auth_ = null;
          authBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Combined authentication/authorization ticket.
       * </pre>
       *
       * <code>.bloombox.schema.security.AuthPayload auth = 7;</code>
       */
      public io.bloombox.schema.security.AuthPayload.Builder getAuthBuilder() {
        
        onChanged();
        return getAuthFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Combined authentication/authorization ticket.
       * </pre>
       *
       * <code>.bloombox.schema.security.AuthPayload auth = 7;</code>
       */
      public io.bloombox.schema.security.AuthPayloadOrBuilder getAuthOrBuilder() {
        if (authBuilder_ != null) {
          return authBuilder_.getMessageOrBuilder();
        } else {
          return auth_ == null ?
              io.bloombox.schema.security.AuthPayload.getDefaultInstance() : auth_;
        }
      }
      /**
       * <pre>
       * Combined authentication/authorization ticket.
       * </pre>
       *
       * <code>.bloombox.schema.security.AuthPayload auth = 7;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.security.AuthPayload, io.bloombox.schema.security.AuthPayload.Builder, io.bloombox.schema.security.AuthPayloadOrBuilder> 
          getAuthFieldBuilder() {
        if (authBuilder_ == null) {
          authBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.security.AuthPayload, io.bloombox.schema.security.AuthPayload.Builder, io.bloombox.schema.security.AuthPayloadOrBuilder>(
                  getAuth(),
                  getParentForChildren(),
                  isClean());
          auth_ = null;
        }
        return authBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.auth.v1beta1.ResolveToken.Request)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.auth.v1beta1.ResolveToken.Request)
    private static final io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request();
    }

    public static io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Request>
        PARSER = new com.google.protobuf.AbstractParser<Request>() {
      public Request parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Request(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Request> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Request> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.auth.v1beta1.ResolveToken.Request getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ResponseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.auth.v1beta1.ResolveToken.Response)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Resulting JSON web token.
     * </pre>
     *
     * <code>string jwt = 1;</code>
     */
    java.lang.String getJwt();
    /**
     * <pre>
     * Resulting JSON web token.
     * </pre>
     *
     * <code>string jwt = 1;</code>
     */
    com.google.protobuf.ByteString
        getJwtBytes();
  }
  /**
   * <pre>
   * Response to a request to generate a platform authorization token.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.auth.v1beta1.ResolveToken.Response}
   */
  public  static final class Response extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.auth.v1beta1.ResolveToken.Response)
      ResponseOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Response.newBuilder() to construct.
    private Response(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Response() {
      jwt_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Response(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              jwt_ = s;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ResolveToken_Response_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ResolveToken_Response_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response.class, io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response.Builder.class);
    }

    public static final int JWT_FIELD_NUMBER = 1;
    private volatile java.lang.Object jwt_;
    /**
     * <pre>
     * Resulting JSON web token.
     * </pre>
     *
     * <code>string jwt = 1;</code>
     */
    public java.lang.String getJwt() {
      java.lang.Object ref = jwt_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        jwt_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Resulting JSON web token.
     * </pre>
     *
     * <code>string jwt = 1;</code>
     */
    public com.google.protobuf.ByteString
        getJwtBytes() {
      java.lang.Object ref = jwt_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        jwt_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getJwtBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, jwt_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getJwtBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, jwt_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response other = (io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response) obj;

      boolean result = true;
      result = result && getJwt()
          .equals(other.getJwt());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + JWT_FIELD_NUMBER;
      hash = (53 * hash) + getJwt().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Response to a request to generate a platform authorization token.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.auth.v1beta1.ResolveToken.Response}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.auth.v1beta1.ResolveToken.Response)
        io.bloombox.schema.services.auth.v1beta1.ResolveToken.ResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ResolveToken_Response_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ResolveToken_Response_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response.class, io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response.Builder.class);
      }

      // Construct using io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        jwt_ = "";

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ResolveToken_Response_descriptor;
      }

      public io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response getDefaultInstanceForType() {
        return io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response.getDefaultInstance();
      }

      public io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response build() {
        io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response buildPartial() {
        io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response result = new io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response(this);
        result.jwt_ = jwt_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response) {
          return mergeFrom((io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response other) {
        if (other == io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response.getDefaultInstance()) return this;
        if (!other.getJwt().isEmpty()) {
          jwt_ = other.jwt_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object jwt_ = "";
      /**
       * <pre>
       * Resulting JSON web token.
       * </pre>
       *
       * <code>string jwt = 1;</code>
       */
      public java.lang.String getJwt() {
        java.lang.Object ref = jwt_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          jwt_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Resulting JSON web token.
       * </pre>
       *
       * <code>string jwt = 1;</code>
       */
      public com.google.protobuf.ByteString
          getJwtBytes() {
        java.lang.Object ref = jwt_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          jwt_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Resulting JSON web token.
       * </pre>
       *
       * <code>string jwt = 1;</code>
       */
      public Builder setJwt(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        jwt_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Resulting JSON web token.
       * </pre>
       *
       * <code>string jwt = 1;</code>
       */
      public Builder clearJwt() {
        
        jwt_ = getDefaultInstance().getJwt();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Resulting JSON web token.
       * </pre>
       *
       * <code>string jwt = 1;</code>
       */
      public Builder setJwtBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        jwt_ = value;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.auth.v1beta1.ResolveToken.Response)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.auth.v1beta1.ResolveToken.Response)
    private static final io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response();
    }

    public static io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Response>
        PARSER = new com.google.protobuf.AbstractParser<Response>() {
      public Response parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Response(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Response> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Response> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.auth.v1beta1.ResolveToken.Response getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.services.auth.v1beta1.ResolveToken)) {
      return super.equals(obj);
    }
    io.bloombox.schema.services.auth.v1beta1.ResolveToken other = (io.bloombox.schema.services.auth.v1beta1.ResolveToken) obj;

    boolean result = true;
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.services.auth.v1beta1.ResolveToken parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.auth.v1beta1.ResolveToken parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.auth.v1beta1.ResolveToken parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.auth.v1beta1.ResolveToken parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.auth.v1beta1.ResolveToken parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.auth.v1beta1.ResolveToken parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.auth.v1beta1.ResolveToken parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.auth.v1beta1.ResolveToken parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.auth.v1beta1.ResolveToken parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.auth.v1beta1.ResolveToken parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.auth.v1beta1.ResolveToken parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.auth.v1beta1.ResolveToken parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.services.auth.v1beta1.ResolveToken prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies an operation to resolve authorized access credentials for Firebase and other services, based on a completed
   * authentication and authorization/consent flow.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.auth.v1beta1.ResolveToken}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.services.auth.v1beta1.ResolveToken)
      io.bloombox.schema.services.auth.v1beta1.ResolveTokenOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ResolveToken_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ResolveToken_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.auth.v1beta1.ResolveToken.class, io.bloombox.schema.services.auth.v1beta1.ResolveToken.Builder.class);
    }

    // Construct using io.bloombox.schema.services.auth.v1beta1.ResolveToken.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_ResolveToken_descriptor;
    }

    public io.bloombox.schema.services.auth.v1beta1.ResolveToken getDefaultInstanceForType() {
      return io.bloombox.schema.services.auth.v1beta1.ResolveToken.getDefaultInstance();
    }

    public io.bloombox.schema.services.auth.v1beta1.ResolveToken build() {
      io.bloombox.schema.services.auth.v1beta1.ResolveToken result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.services.auth.v1beta1.ResolveToken buildPartial() {
      io.bloombox.schema.services.auth.v1beta1.ResolveToken result = new io.bloombox.schema.services.auth.v1beta1.ResolveToken(this);
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.services.auth.v1beta1.ResolveToken) {
        return mergeFrom((io.bloombox.schema.services.auth.v1beta1.ResolveToken)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.services.auth.v1beta1.ResolveToken other) {
      if (other == io.bloombox.schema.services.auth.v1beta1.ResolveToken.getDefaultInstance()) return this;
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.services.auth.v1beta1.ResolveToken parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.services.auth.v1beta1.ResolveToken) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.services.auth.v1beta1.ResolveToken)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.services.auth.v1beta1.ResolveToken)
  private static final io.bloombox.schema.services.auth.v1beta1.ResolveToken DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.services.auth.v1beta1.ResolveToken();
  }

  public static io.bloombox.schema.services.auth.v1beta1.ResolveToken getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ResolveToken>
      PARSER = new com.google.protobuf.AbstractParser<ResolveToken>() {
    public ResolveToken parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new ResolveToken(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<ResolveToken> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ResolveToken> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.services.auth.v1beta1.ResolveToken getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

