/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: auth/v1beta1/AuthService_Beta1.proto

package io.bloombox.schema.services.auth.v1beta1;

/**
 * <pre>
 * Specifies an operation to build a full user context after a successful ID and authorization/consent flow, including
 * a fresh JWT, resolved user key and profile, and access roles/rights related to particular partner/location scopes.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.services.auth.v1beta1.UserContext}
 */
public  final class UserContext extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.services.auth.v1beta1.UserContext)
    UserContextOrBuilder {
private static final long serialVersionUID = 0L;
  // Use UserContext.newBuilder() to construct.
  private UserContext(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private UserContext() {
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private UserContext(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_UserContext_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_UserContext_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.services.auth.v1beta1.UserContext.class, io.bloombox.schema.services.auth.v1beta1.UserContext.Builder.class);
  }

  public interface RequestOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.auth.v1beta1.UserContext.Request)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * User's identity ID, or 'uid'.
     * </pre>
     *
     * <code>string uid = 1;</code>
     */
    java.lang.String getUid();
    /**
     * <pre>
     * User's identity ID, or 'uid'.
     * </pre>
     *
     * <code>string uid = 1;</code>
     */
    com.google.protobuf.ByteString
        getUidBytes();

    /**
     * <pre>
     * Active session ID for the user.
     * </pre>
     *
     * <code>string session = 2;</code>
     */
    java.lang.String getSession();
    /**
     * <pre>
     * Active session ID for the user.
     * </pre>
     *
     * <code>string session = 2;</code>
     */
    com.google.protobuf.ByteString
        getSessionBytes();
  }
  /**
   * <pre>
   * Request to retrieve materialized user authentication context. Must include valid, one-use cryptographic information
   * along with the resulting ID and access tokens from the auth flow.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.auth.v1beta1.UserContext.Request}
   */
  public  static final class Request extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.auth.v1beta1.UserContext.Request)
      RequestOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Request.newBuilder() to construct.
    private Request(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Request() {
      uid_ = "";
      session_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Request(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              uid_ = s;
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();

              session_ = s;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_UserContext_Request_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_UserContext_Request_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.auth.v1beta1.UserContext.Request.class, io.bloombox.schema.services.auth.v1beta1.UserContext.Request.Builder.class);
    }

    public static final int UID_FIELD_NUMBER = 1;
    private volatile java.lang.Object uid_;
    /**
     * <pre>
     * User's identity ID, or 'uid'.
     * </pre>
     *
     * <code>string uid = 1;</code>
     */
    public java.lang.String getUid() {
      java.lang.Object ref = uid_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        uid_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * User's identity ID, or 'uid'.
     * </pre>
     *
     * <code>string uid = 1;</code>
     */
    public com.google.protobuf.ByteString
        getUidBytes() {
      java.lang.Object ref = uid_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        uid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SESSION_FIELD_NUMBER = 2;
    private volatile java.lang.Object session_;
    /**
     * <pre>
     * Active session ID for the user.
     * </pre>
     *
     * <code>string session = 2;</code>
     */
    public java.lang.String getSession() {
      java.lang.Object ref = session_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        session_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Active session ID for the user.
     * </pre>
     *
     * <code>string session = 2;</code>
     */
    public com.google.protobuf.ByteString
        getSessionBytes() {
      java.lang.Object ref = session_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        session_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getUidBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, uid_);
      }
      if (!getSessionBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, session_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getUidBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, uid_);
      }
      if (!getSessionBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, session_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.auth.v1beta1.UserContext.Request)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.auth.v1beta1.UserContext.Request other = (io.bloombox.schema.services.auth.v1beta1.UserContext.Request) obj;

      boolean result = true;
      result = result && getUid()
          .equals(other.getUid());
      result = result && getSession()
          .equals(other.getSession());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + UID_FIELD_NUMBER;
      hash = (53 * hash) + getUid().hashCode();
      hash = (37 * hash) + SESSION_FIELD_NUMBER;
      hash = (53 * hash) + getSession().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.auth.v1beta1.UserContext.Request parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.auth.v1beta1.UserContext.Request parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.UserContext.Request parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.auth.v1beta1.UserContext.Request parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.UserContext.Request parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.auth.v1beta1.UserContext.Request parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.UserContext.Request parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.auth.v1beta1.UserContext.Request parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.UserContext.Request parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.auth.v1beta1.UserContext.Request parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.UserContext.Request parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.auth.v1beta1.UserContext.Request parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.auth.v1beta1.UserContext.Request prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Request to retrieve materialized user authentication context. Must include valid, one-use cryptographic information
     * along with the resulting ID and access tokens from the auth flow.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.auth.v1beta1.UserContext.Request}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.auth.v1beta1.UserContext.Request)
        io.bloombox.schema.services.auth.v1beta1.UserContext.RequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_UserContext_Request_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_UserContext_Request_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.auth.v1beta1.UserContext.Request.class, io.bloombox.schema.services.auth.v1beta1.UserContext.Request.Builder.class);
      }

      // Construct using io.bloombox.schema.services.auth.v1beta1.UserContext.Request.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        uid_ = "";

        session_ = "";

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_UserContext_Request_descriptor;
      }

      public io.bloombox.schema.services.auth.v1beta1.UserContext.Request getDefaultInstanceForType() {
        return io.bloombox.schema.services.auth.v1beta1.UserContext.Request.getDefaultInstance();
      }

      public io.bloombox.schema.services.auth.v1beta1.UserContext.Request build() {
        io.bloombox.schema.services.auth.v1beta1.UserContext.Request result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.auth.v1beta1.UserContext.Request buildPartial() {
        io.bloombox.schema.services.auth.v1beta1.UserContext.Request result = new io.bloombox.schema.services.auth.v1beta1.UserContext.Request(this);
        result.uid_ = uid_;
        result.session_ = session_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.auth.v1beta1.UserContext.Request) {
          return mergeFrom((io.bloombox.schema.services.auth.v1beta1.UserContext.Request)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.auth.v1beta1.UserContext.Request other) {
        if (other == io.bloombox.schema.services.auth.v1beta1.UserContext.Request.getDefaultInstance()) return this;
        if (!other.getUid().isEmpty()) {
          uid_ = other.uid_;
          onChanged();
        }
        if (!other.getSession().isEmpty()) {
          session_ = other.session_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.auth.v1beta1.UserContext.Request parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.auth.v1beta1.UserContext.Request) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object uid_ = "";
      /**
       * <pre>
       * User's identity ID, or 'uid'.
       * </pre>
       *
       * <code>string uid = 1;</code>
       */
      public java.lang.String getUid() {
        java.lang.Object ref = uid_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          uid_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * User's identity ID, or 'uid'.
       * </pre>
       *
       * <code>string uid = 1;</code>
       */
      public com.google.protobuf.ByteString
          getUidBytes() {
        java.lang.Object ref = uid_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          uid_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * User's identity ID, or 'uid'.
       * </pre>
       *
       * <code>string uid = 1;</code>
       */
      public Builder setUid(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        uid_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * User's identity ID, or 'uid'.
       * </pre>
       *
       * <code>string uid = 1;</code>
       */
      public Builder clearUid() {
        
        uid_ = getDefaultInstance().getUid();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * User's identity ID, or 'uid'.
       * </pre>
       *
       * <code>string uid = 1;</code>
       */
      public Builder setUidBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        uid_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object session_ = "";
      /**
       * <pre>
       * Active session ID for the user.
       * </pre>
       *
       * <code>string session = 2;</code>
       */
      public java.lang.String getSession() {
        java.lang.Object ref = session_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          session_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Active session ID for the user.
       * </pre>
       *
       * <code>string session = 2;</code>
       */
      public com.google.protobuf.ByteString
          getSessionBytes() {
        java.lang.Object ref = session_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          session_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Active session ID for the user.
       * </pre>
       *
       * <code>string session = 2;</code>
       */
      public Builder setSession(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        session_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Active session ID for the user.
       * </pre>
       *
       * <code>string session = 2;</code>
       */
      public Builder clearSession() {
        
        session_ = getDefaultInstance().getSession();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Active session ID for the user.
       * </pre>
       *
       * <code>string session = 2;</code>
       */
      public Builder setSessionBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        session_ = value;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.auth.v1beta1.UserContext.Request)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.auth.v1beta1.UserContext.Request)
    private static final io.bloombox.schema.services.auth.v1beta1.UserContext.Request DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.auth.v1beta1.UserContext.Request();
    }

    public static io.bloombox.schema.services.auth.v1beta1.UserContext.Request getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Request>
        PARSER = new com.google.protobuf.AbstractParser<Request>() {
      public Request parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Request(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Request> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Request> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.auth.v1beta1.UserContext.Request getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ResponseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.auth.v1beta1.UserContext.Response)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Resulting JSON web token.
     * </pre>
     *
     * <code>string jwt = 1;</code>
     */
    java.lang.String getJwt();
    /**
     * <pre>
     * Resulting JSON web token.
     * </pre>
     *
     * <code>string jwt = 1;</code>
     */
    com.google.protobuf.ByteString
        getJwtBytes();

    /**
     * <pre>
     * User profile key.
     * </pre>
     *
     * <code>string key = 2;</code>
     */
    java.lang.String getKey();
    /**
     * <pre>
     * User profile key.
     * </pre>
     *
     * <code>string key = 2;</code>
     */
    com.google.protobuf.ByteString
        getKeyBytes();

    /**
     * <pre>
     * User's profile object.
     * </pre>
     *
     * <code>.bloombox.schema.identity.User profile = 3;</code>
     */
    boolean hasProfile();
    /**
     * <pre>
     * User's profile object.
     * </pre>
     *
     * <code>.bloombox.schema.identity.User profile = 3;</code>
     */
    io.bloombox.schema.identity.User getProfile();
    /**
     * <pre>
     * User's profile object.
     * </pre>
     *
     * <code>.bloombox.schema.identity.User profile = 3;</code>
     */
    io.bloombox.schema.identity.UserOrBuilder getProfileOrBuilder();
  }
  /**
   * <pre>
   * Response to a request to retrieve materialized user authentication context. Either specified an error or a set of
   * materialized credential data.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.auth.v1beta1.UserContext.Response}
   */
  public  static final class Response extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.auth.v1beta1.UserContext.Response)
      ResponseOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Response.newBuilder() to construct.
    private Response(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Response() {
      jwt_ = "";
      key_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Response(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              jwt_ = s;
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();

              key_ = s;
              break;
            }
            case 26: {
              io.bloombox.schema.identity.User.Builder subBuilder = null;
              if (profile_ != null) {
                subBuilder = profile_.toBuilder();
              }
              profile_ = input.readMessage(io.bloombox.schema.identity.User.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(profile_);
                profile_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_UserContext_Response_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_UserContext_Response_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.auth.v1beta1.UserContext.Response.class, io.bloombox.schema.services.auth.v1beta1.UserContext.Response.Builder.class);
    }

    public static final int JWT_FIELD_NUMBER = 1;
    private volatile java.lang.Object jwt_;
    /**
     * <pre>
     * Resulting JSON web token.
     * </pre>
     *
     * <code>string jwt = 1;</code>
     */
    public java.lang.String getJwt() {
      java.lang.Object ref = jwt_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        jwt_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Resulting JSON web token.
     * </pre>
     *
     * <code>string jwt = 1;</code>
     */
    public com.google.protobuf.ByteString
        getJwtBytes() {
      java.lang.Object ref = jwt_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        jwt_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int KEY_FIELD_NUMBER = 2;
    private volatile java.lang.Object key_;
    /**
     * <pre>
     * User profile key.
     * </pre>
     *
     * <code>string key = 2;</code>
     */
    public java.lang.String getKey() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        key_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * User profile key.
     * </pre>
     *
     * <code>string key = 2;</code>
     */
    public com.google.protobuf.ByteString
        getKeyBytes() {
      java.lang.Object ref = key_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        key_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PROFILE_FIELD_NUMBER = 3;
    private io.bloombox.schema.identity.User profile_;
    /**
     * <pre>
     * User's profile object.
     * </pre>
     *
     * <code>.bloombox.schema.identity.User profile = 3;</code>
     */
    public boolean hasProfile() {
      return profile_ != null;
    }
    /**
     * <pre>
     * User's profile object.
     * </pre>
     *
     * <code>.bloombox.schema.identity.User profile = 3;</code>
     */
    public io.bloombox.schema.identity.User getProfile() {
      return profile_ == null ? io.bloombox.schema.identity.User.getDefaultInstance() : profile_;
    }
    /**
     * <pre>
     * User's profile object.
     * </pre>
     *
     * <code>.bloombox.schema.identity.User profile = 3;</code>
     */
    public io.bloombox.schema.identity.UserOrBuilder getProfileOrBuilder() {
      return getProfile();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getJwtBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, jwt_);
      }
      if (!getKeyBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, key_);
      }
      if (profile_ != null) {
        output.writeMessage(3, getProfile());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getJwtBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, jwt_);
      }
      if (!getKeyBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, key_);
      }
      if (profile_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getProfile());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.auth.v1beta1.UserContext.Response)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.auth.v1beta1.UserContext.Response other = (io.bloombox.schema.services.auth.v1beta1.UserContext.Response) obj;

      boolean result = true;
      result = result && getJwt()
          .equals(other.getJwt());
      result = result && getKey()
          .equals(other.getKey());
      result = result && (hasProfile() == other.hasProfile());
      if (hasProfile()) {
        result = result && getProfile()
            .equals(other.getProfile());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + JWT_FIELD_NUMBER;
      hash = (53 * hash) + getJwt().hashCode();
      hash = (37 * hash) + KEY_FIELD_NUMBER;
      hash = (53 * hash) + getKey().hashCode();
      if (hasProfile()) {
        hash = (37 * hash) + PROFILE_FIELD_NUMBER;
        hash = (53 * hash) + getProfile().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.auth.v1beta1.UserContext.Response parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.auth.v1beta1.UserContext.Response parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.UserContext.Response parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.auth.v1beta1.UserContext.Response parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.UserContext.Response parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.auth.v1beta1.UserContext.Response parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.UserContext.Response parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.auth.v1beta1.UserContext.Response parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.UserContext.Response parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.auth.v1beta1.UserContext.Response parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.auth.v1beta1.UserContext.Response parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.auth.v1beta1.UserContext.Response parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.auth.v1beta1.UserContext.Response prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Response to a request to retrieve materialized user authentication context. Either specified an error or a set of
     * materialized credential data.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.auth.v1beta1.UserContext.Response}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.auth.v1beta1.UserContext.Response)
        io.bloombox.schema.services.auth.v1beta1.UserContext.ResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_UserContext_Response_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_UserContext_Response_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.auth.v1beta1.UserContext.Response.class, io.bloombox.schema.services.auth.v1beta1.UserContext.Response.Builder.class);
      }

      // Construct using io.bloombox.schema.services.auth.v1beta1.UserContext.Response.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        jwt_ = "";

        key_ = "";

        if (profileBuilder_ == null) {
          profile_ = null;
        } else {
          profile_ = null;
          profileBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_UserContext_Response_descriptor;
      }

      public io.bloombox.schema.services.auth.v1beta1.UserContext.Response getDefaultInstanceForType() {
        return io.bloombox.schema.services.auth.v1beta1.UserContext.Response.getDefaultInstance();
      }

      public io.bloombox.schema.services.auth.v1beta1.UserContext.Response build() {
        io.bloombox.schema.services.auth.v1beta1.UserContext.Response result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.auth.v1beta1.UserContext.Response buildPartial() {
        io.bloombox.schema.services.auth.v1beta1.UserContext.Response result = new io.bloombox.schema.services.auth.v1beta1.UserContext.Response(this);
        result.jwt_ = jwt_;
        result.key_ = key_;
        if (profileBuilder_ == null) {
          result.profile_ = profile_;
        } else {
          result.profile_ = profileBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.auth.v1beta1.UserContext.Response) {
          return mergeFrom((io.bloombox.schema.services.auth.v1beta1.UserContext.Response)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.auth.v1beta1.UserContext.Response other) {
        if (other == io.bloombox.schema.services.auth.v1beta1.UserContext.Response.getDefaultInstance()) return this;
        if (!other.getJwt().isEmpty()) {
          jwt_ = other.jwt_;
          onChanged();
        }
        if (!other.getKey().isEmpty()) {
          key_ = other.key_;
          onChanged();
        }
        if (other.hasProfile()) {
          mergeProfile(other.getProfile());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.auth.v1beta1.UserContext.Response parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.auth.v1beta1.UserContext.Response) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object jwt_ = "";
      /**
       * <pre>
       * Resulting JSON web token.
       * </pre>
       *
       * <code>string jwt = 1;</code>
       */
      public java.lang.String getJwt() {
        java.lang.Object ref = jwt_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          jwt_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Resulting JSON web token.
       * </pre>
       *
       * <code>string jwt = 1;</code>
       */
      public com.google.protobuf.ByteString
          getJwtBytes() {
        java.lang.Object ref = jwt_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          jwt_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Resulting JSON web token.
       * </pre>
       *
       * <code>string jwt = 1;</code>
       */
      public Builder setJwt(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        jwt_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Resulting JSON web token.
       * </pre>
       *
       * <code>string jwt = 1;</code>
       */
      public Builder clearJwt() {
        
        jwt_ = getDefaultInstance().getJwt();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Resulting JSON web token.
       * </pre>
       *
       * <code>string jwt = 1;</code>
       */
      public Builder setJwtBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        jwt_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object key_ = "";
      /**
       * <pre>
       * User profile key.
       * </pre>
       *
       * <code>string key = 2;</code>
       */
      public java.lang.String getKey() {
        java.lang.Object ref = key_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          key_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * User profile key.
       * </pre>
       *
       * <code>string key = 2;</code>
       */
      public com.google.protobuf.ByteString
          getKeyBytes() {
        java.lang.Object ref = key_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          key_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * User profile key.
       * </pre>
       *
       * <code>string key = 2;</code>
       */
      public Builder setKey(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        key_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * User profile key.
       * </pre>
       *
       * <code>string key = 2;</code>
       */
      public Builder clearKey() {
        
        key_ = getDefaultInstance().getKey();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * User profile key.
       * </pre>
       *
       * <code>string key = 2;</code>
       */
      public Builder setKeyBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        key_ = value;
        onChanged();
        return this;
      }

      private io.bloombox.schema.identity.User profile_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.identity.User, io.bloombox.schema.identity.User.Builder, io.bloombox.schema.identity.UserOrBuilder> profileBuilder_;
      /**
       * <pre>
       * User's profile object.
       * </pre>
       *
       * <code>.bloombox.schema.identity.User profile = 3;</code>
       */
      public boolean hasProfile() {
        return profileBuilder_ != null || profile_ != null;
      }
      /**
       * <pre>
       * User's profile object.
       * </pre>
       *
       * <code>.bloombox.schema.identity.User profile = 3;</code>
       */
      public io.bloombox.schema.identity.User getProfile() {
        if (profileBuilder_ == null) {
          return profile_ == null ? io.bloombox.schema.identity.User.getDefaultInstance() : profile_;
        } else {
          return profileBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * User's profile object.
       * </pre>
       *
       * <code>.bloombox.schema.identity.User profile = 3;</code>
       */
      public Builder setProfile(io.bloombox.schema.identity.User value) {
        if (profileBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          profile_ = value;
          onChanged();
        } else {
          profileBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * User's profile object.
       * </pre>
       *
       * <code>.bloombox.schema.identity.User profile = 3;</code>
       */
      public Builder setProfile(
          io.bloombox.schema.identity.User.Builder builderForValue) {
        if (profileBuilder_ == null) {
          profile_ = builderForValue.build();
          onChanged();
        } else {
          profileBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * User's profile object.
       * </pre>
       *
       * <code>.bloombox.schema.identity.User profile = 3;</code>
       */
      public Builder mergeProfile(io.bloombox.schema.identity.User value) {
        if (profileBuilder_ == null) {
          if (profile_ != null) {
            profile_ =
              io.bloombox.schema.identity.User.newBuilder(profile_).mergeFrom(value).buildPartial();
          } else {
            profile_ = value;
          }
          onChanged();
        } else {
          profileBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * User's profile object.
       * </pre>
       *
       * <code>.bloombox.schema.identity.User profile = 3;</code>
       */
      public Builder clearProfile() {
        if (profileBuilder_ == null) {
          profile_ = null;
          onChanged();
        } else {
          profile_ = null;
          profileBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * User's profile object.
       * </pre>
       *
       * <code>.bloombox.schema.identity.User profile = 3;</code>
       */
      public io.bloombox.schema.identity.User.Builder getProfileBuilder() {
        
        onChanged();
        return getProfileFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * User's profile object.
       * </pre>
       *
       * <code>.bloombox.schema.identity.User profile = 3;</code>
       */
      public io.bloombox.schema.identity.UserOrBuilder getProfileOrBuilder() {
        if (profileBuilder_ != null) {
          return profileBuilder_.getMessageOrBuilder();
        } else {
          return profile_ == null ?
              io.bloombox.schema.identity.User.getDefaultInstance() : profile_;
        }
      }
      /**
       * <pre>
       * User's profile object.
       * </pre>
       *
       * <code>.bloombox.schema.identity.User profile = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.identity.User, io.bloombox.schema.identity.User.Builder, io.bloombox.schema.identity.UserOrBuilder> 
          getProfileFieldBuilder() {
        if (profileBuilder_ == null) {
          profileBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.identity.User, io.bloombox.schema.identity.User.Builder, io.bloombox.schema.identity.UserOrBuilder>(
                  getProfile(),
                  getParentForChildren(),
                  isClean());
          profile_ = null;
        }
        return profileBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.auth.v1beta1.UserContext.Response)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.auth.v1beta1.UserContext.Response)
    private static final io.bloombox.schema.services.auth.v1beta1.UserContext.Response DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.auth.v1beta1.UserContext.Response();
    }

    public static io.bloombox.schema.services.auth.v1beta1.UserContext.Response getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Response>
        PARSER = new com.google.protobuf.AbstractParser<Response>() {
      public Response parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Response(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Response> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Response> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.auth.v1beta1.UserContext.Response getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.services.auth.v1beta1.UserContext)) {
      return super.equals(obj);
    }
    io.bloombox.schema.services.auth.v1beta1.UserContext other = (io.bloombox.schema.services.auth.v1beta1.UserContext) obj;

    boolean result = true;
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.services.auth.v1beta1.UserContext parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.auth.v1beta1.UserContext parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.auth.v1beta1.UserContext parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.auth.v1beta1.UserContext parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.auth.v1beta1.UserContext parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.auth.v1beta1.UserContext parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.auth.v1beta1.UserContext parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.auth.v1beta1.UserContext parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.auth.v1beta1.UserContext parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.auth.v1beta1.UserContext parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.auth.v1beta1.UserContext parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.auth.v1beta1.UserContext parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.services.auth.v1beta1.UserContext prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies an operation to build a full user context after a successful ID and authorization/consent flow, including
   * a fresh JWT, resolved user key and profile, and access roles/rights related to particular partner/location scopes.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.auth.v1beta1.UserContext}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.services.auth.v1beta1.UserContext)
      io.bloombox.schema.services.auth.v1beta1.UserContextOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_UserContext_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_UserContext_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.auth.v1beta1.UserContext.class, io.bloombox.schema.services.auth.v1beta1.UserContext.Builder.class);
    }

    // Construct using io.bloombox.schema.services.auth.v1beta1.UserContext.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.services.auth.v1beta1.AuthServiceBeta1.internal_static_bloombox_schema_services_auth_v1beta1_UserContext_descriptor;
    }

    public io.bloombox.schema.services.auth.v1beta1.UserContext getDefaultInstanceForType() {
      return io.bloombox.schema.services.auth.v1beta1.UserContext.getDefaultInstance();
    }

    public io.bloombox.schema.services.auth.v1beta1.UserContext build() {
      io.bloombox.schema.services.auth.v1beta1.UserContext result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.services.auth.v1beta1.UserContext buildPartial() {
      io.bloombox.schema.services.auth.v1beta1.UserContext result = new io.bloombox.schema.services.auth.v1beta1.UserContext(this);
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.services.auth.v1beta1.UserContext) {
        return mergeFrom((io.bloombox.schema.services.auth.v1beta1.UserContext)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.services.auth.v1beta1.UserContext other) {
      if (other == io.bloombox.schema.services.auth.v1beta1.UserContext.getDefaultInstance()) return this;
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.services.auth.v1beta1.UserContext parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.services.auth.v1beta1.UserContext) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.services.auth.v1beta1.UserContext)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.services.auth.v1beta1.UserContext)
  private static final io.bloombox.schema.services.auth.v1beta1.UserContext DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.services.auth.v1beta1.UserContext();
  }

  public static io.bloombox.schema.services.auth.v1beta1.UserContext getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UserContext>
      PARSER = new com.google.protobuf.AbstractParser<UserContext>() {
    public UserContext parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new UserContext(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<UserContext> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UserContext> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.services.auth.v1beta1.UserContext getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

