/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: checkin/v1beta1/CheckinService_Beta1.proto

package io.bloombox.schema.services.checkin.v1beta1;

/**
 * <pre>
 * Specifies an RPC operation to check a user via an authenticated digital representation of their identity, usually in
 * the form of an Apple Wallet based, Bloombox-issued pass.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.services.checkin.v1beta1.CardCheckin}
 */
public  final class CardCheckin extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.services.checkin.v1beta1.CardCheckin)
    CardCheckinOrBuilder {
private static final long serialVersionUID = 0L;
  // Use CardCheckin.newBuilder() to construct.
  private CardCheckin(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private CardCheckin() {
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private CardCheckin(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.services.checkin.v1beta1.CheckinServiceBeta1.internal_static_bloombox_schema_services_checkin_v1beta1_CardCheckin_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.services.checkin.v1beta1.CheckinServiceBeta1.internal_static_bloombox_schema_services_checkin_v1beta1_CardCheckin_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.services.checkin.v1beta1.CardCheckin.class, io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Builder.class);
  }

  public interface RequestOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.checkin.v1beta1.CardCheckin.Request)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Type ID of the subject digital card.
     * </pre>
     *
     * <code>string card_type = 1;</code>
     */
    java.lang.String getCardType();
    /**
     * <pre>
     * Type ID of the subject digital card.
     * </pre>
     *
     * <code>string card_type = 1;</code>
     */
    com.google.protobuf.ByteString
        getCardTypeBytes();

    /**
     * <pre>
     * Raw bytes of the card's barcode, encoded in base64.
     * </pre>
     *
     * <code>string payload = 2;</code>
     */
    java.lang.String getPayload();
    /**
     * <pre>
     * Raw bytes of the card's barcode, encoded in base64.
     * </pre>
     *
     * <code>string payload = 2;</code>
     */
    com.google.protobuf.ByteString
        getPayloadBytes();

    /**
     * <pre>
     * Embedded signature in the digital card, encoded in base64.
     * </pre>
     *
     * <code>string signature = 3;</code>
     */
    java.lang.String getSignature();
    /**
     * <pre>
     * Embedded signature in the digital card, encoded in base64.
     * </pre>
     *
     * <code>string signature = 3;</code>
     */
    com.google.protobuf.ByteString
        getSignatureBytes();

    /**
     * <pre>
     * Digital signature and hash from the submitting device, encoded in base64.
     * </pre>
     *
     * <code>string agent = 4;</code>
     */
    java.lang.String getAgent();
    /**
     * <pre>
     * Digital signature and hash from the submitting device, encoded in base64.
     * </pre>
     *
     * <code>string agent = 4;</code>
     */
    com.google.protobuf.ByteString
        getAgentBytes();

    /**
     * <pre>
     * Partnership scope for the request.
     * </pre>
     *
     * <code>string scope = 5;</code>
     */
    java.lang.String getScope();
    /**
     * <pre>
     * Partnership scope for the request.
     * </pre>
     *
     * <code>string scope = 5;</code>
     */
    com.google.protobuf.ByteString
        getScopeBytes();
  }
  /**
   * <pre>
   * Request to checkin via a user's digital card.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.checkin.v1beta1.CardCheckin.Request}
   */
  public  static final class Request extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.checkin.v1beta1.CardCheckin.Request)
      RequestOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Request.newBuilder() to construct.
    private Request(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Request() {
      cardType_ = "";
      payload_ = "";
      signature_ = "";
      agent_ = "";
      scope_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Request(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              cardType_ = s;
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();

              payload_ = s;
              break;
            }
            case 26: {
              java.lang.String s = input.readStringRequireUtf8();

              signature_ = s;
              break;
            }
            case 34: {
              java.lang.String s = input.readStringRequireUtf8();

              agent_ = s;
              break;
            }
            case 42: {
              java.lang.String s = input.readStringRequireUtf8();

              scope_ = s;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.checkin.v1beta1.CheckinServiceBeta1.internal_static_bloombox_schema_services_checkin_v1beta1_CardCheckin_Request_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.checkin.v1beta1.CheckinServiceBeta1.internal_static_bloombox_schema_services_checkin_v1beta1_CardCheckin_Request_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request.class, io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request.Builder.class);
    }

    public static final int CARD_TYPE_FIELD_NUMBER = 1;
    private volatile java.lang.Object cardType_;
    /**
     * <pre>
     * Type ID of the subject digital card.
     * </pre>
     *
     * <code>string card_type = 1;</code>
     */
    public java.lang.String getCardType() {
      java.lang.Object ref = cardType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        cardType_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Type ID of the subject digital card.
     * </pre>
     *
     * <code>string card_type = 1;</code>
     */
    public com.google.protobuf.ByteString
        getCardTypeBytes() {
      java.lang.Object ref = cardType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        cardType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PAYLOAD_FIELD_NUMBER = 2;
    private volatile java.lang.Object payload_;
    /**
     * <pre>
     * Raw bytes of the card's barcode, encoded in base64.
     * </pre>
     *
     * <code>string payload = 2;</code>
     */
    public java.lang.String getPayload() {
      java.lang.Object ref = payload_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        payload_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Raw bytes of the card's barcode, encoded in base64.
     * </pre>
     *
     * <code>string payload = 2;</code>
     */
    public com.google.protobuf.ByteString
        getPayloadBytes() {
      java.lang.Object ref = payload_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        payload_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SIGNATURE_FIELD_NUMBER = 3;
    private volatile java.lang.Object signature_;
    /**
     * <pre>
     * Embedded signature in the digital card, encoded in base64.
     * </pre>
     *
     * <code>string signature = 3;</code>
     */
    public java.lang.String getSignature() {
      java.lang.Object ref = signature_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        signature_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Embedded signature in the digital card, encoded in base64.
     * </pre>
     *
     * <code>string signature = 3;</code>
     */
    public com.google.protobuf.ByteString
        getSignatureBytes() {
      java.lang.Object ref = signature_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        signature_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int AGENT_FIELD_NUMBER = 4;
    private volatile java.lang.Object agent_;
    /**
     * <pre>
     * Digital signature and hash from the submitting device, encoded in base64.
     * </pre>
     *
     * <code>string agent = 4;</code>
     */
    public java.lang.String getAgent() {
      java.lang.Object ref = agent_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        agent_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Digital signature and hash from the submitting device, encoded in base64.
     * </pre>
     *
     * <code>string agent = 4;</code>
     */
    public com.google.protobuf.ByteString
        getAgentBytes() {
      java.lang.Object ref = agent_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        agent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SCOPE_FIELD_NUMBER = 5;
    private volatile java.lang.Object scope_;
    /**
     * <pre>
     * Partnership scope for the request.
     * </pre>
     *
     * <code>string scope = 5;</code>
     */
    public java.lang.String getScope() {
      java.lang.Object ref = scope_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        scope_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Partnership scope for the request.
     * </pre>
     *
     * <code>string scope = 5;</code>
     */
    public com.google.protobuf.ByteString
        getScopeBytes() {
      java.lang.Object ref = scope_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        scope_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getCardTypeBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, cardType_);
      }
      if (!getPayloadBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, payload_);
      }
      if (!getSignatureBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, signature_);
      }
      if (!getAgentBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, agent_);
      }
      if (!getScopeBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, scope_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getCardTypeBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, cardType_);
      }
      if (!getPayloadBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, payload_);
      }
      if (!getSignatureBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, signature_);
      }
      if (!getAgentBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, agent_);
      }
      if (!getScopeBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, scope_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request other = (io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request) obj;

      boolean result = true;
      result = result && getCardType()
          .equals(other.getCardType());
      result = result && getPayload()
          .equals(other.getPayload());
      result = result && getSignature()
          .equals(other.getSignature());
      result = result && getAgent()
          .equals(other.getAgent());
      result = result && getScope()
          .equals(other.getScope());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CARD_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getCardType().hashCode();
      hash = (37 * hash) + PAYLOAD_FIELD_NUMBER;
      hash = (53 * hash) + getPayload().hashCode();
      hash = (37 * hash) + SIGNATURE_FIELD_NUMBER;
      hash = (53 * hash) + getSignature().hashCode();
      hash = (37 * hash) + AGENT_FIELD_NUMBER;
      hash = (53 * hash) + getAgent().hashCode();
      hash = (37 * hash) + SCOPE_FIELD_NUMBER;
      hash = (53 * hash) + getScope().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Request to checkin via a user's digital card.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.checkin.v1beta1.CardCheckin.Request}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.checkin.v1beta1.CardCheckin.Request)
        io.bloombox.schema.services.checkin.v1beta1.CardCheckin.RequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.checkin.v1beta1.CheckinServiceBeta1.internal_static_bloombox_schema_services_checkin_v1beta1_CardCheckin_Request_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.checkin.v1beta1.CheckinServiceBeta1.internal_static_bloombox_schema_services_checkin_v1beta1_CardCheckin_Request_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request.class, io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request.Builder.class);
      }

      // Construct using io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        cardType_ = "";

        payload_ = "";

        signature_ = "";

        agent_ = "";

        scope_ = "";

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.checkin.v1beta1.CheckinServiceBeta1.internal_static_bloombox_schema_services_checkin_v1beta1_CardCheckin_Request_descriptor;
      }

      public io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request getDefaultInstanceForType() {
        return io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request.getDefaultInstance();
      }

      public io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request build() {
        io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request buildPartial() {
        io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request result = new io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request(this);
        result.cardType_ = cardType_;
        result.payload_ = payload_;
        result.signature_ = signature_;
        result.agent_ = agent_;
        result.scope_ = scope_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request) {
          return mergeFrom((io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request other) {
        if (other == io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request.getDefaultInstance()) return this;
        if (!other.getCardType().isEmpty()) {
          cardType_ = other.cardType_;
          onChanged();
        }
        if (!other.getPayload().isEmpty()) {
          payload_ = other.payload_;
          onChanged();
        }
        if (!other.getSignature().isEmpty()) {
          signature_ = other.signature_;
          onChanged();
        }
        if (!other.getAgent().isEmpty()) {
          agent_ = other.agent_;
          onChanged();
        }
        if (!other.getScope().isEmpty()) {
          scope_ = other.scope_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object cardType_ = "";
      /**
       * <pre>
       * Type ID of the subject digital card.
       * </pre>
       *
       * <code>string card_type = 1;</code>
       */
      public java.lang.String getCardType() {
        java.lang.Object ref = cardType_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          cardType_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Type ID of the subject digital card.
       * </pre>
       *
       * <code>string card_type = 1;</code>
       */
      public com.google.protobuf.ByteString
          getCardTypeBytes() {
        java.lang.Object ref = cardType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          cardType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Type ID of the subject digital card.
       * </pre>
       *
       * <code>string card_type = 1;</code>
       */
      public Builder setCardType(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        cardType_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Type ID of the subject digital card.
       * </pre>
       *
       * <code>string card_type = 1;</code>
       */
      public Builder clearCardType() {
        
        cardType_ = getDefaultInstance().getCardType();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Type ID of the subject digital card.
       * </pre>
       *
       * <code>string card_type = 1;</code>
       */
      public Builder setCardTypeBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        cardType_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object payload_ = "";
      /**
       * <pre>
       * Raw bytes of the card's barcode, encoded in base64.
       * </pre>
       *
       * <code>string payload = 2;</code>
       */
      public java.lang.String getPayload() {
        java.lang.Object ref = payload_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          payload_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Raw bytes of the card's barcode, encoded in base64.
       * </pre>
       *
       * <code>string payload = 2;</code>
       */
      public com.google.protobuf.ByteString
          getPayloadBytes() {
        java.lang.Object ref = payload_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          payload_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Raw bytes of the card's barcode, encoded in base64.
       * </pre>
       *
       * <code>string payload = 2;</code>
       */
      public Builder setPayload(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        payload_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Raw bytes of the card's barcode, encoded in base64.
       * </pre>
       *
       * <code>string payload = 2;</code>
       */
      public Builder clearPayload() {
        
        payload_ = getDefaultInstance().getPayload();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Raw bytes of the card's barcode, encoded in base64.
       * </pre>
       *
       * <code>string payload = 2;</code>
       */
      public Builder setPayloadBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        payload_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object signature_ = "";
      /**
       * <pre>
       * Embedded signature in the digital card, encoded in base64.
       * </pre>
       *
       * <code>string signature = 3;</code>
       */
      public java.lang.String getSignature() {
        java.lang.Object ref = signature_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          signature_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Embedded signature in the digital card, encoded in base64.
       * </pre>
       *
       * <code>string signature = 3;</code>
       */
      public com.google.protobuf.ByteString
          getSignatureBytes() {
        java.lang.Object ref = signature_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          signature_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Embedded signature in the digital card, encoded in base64.
       * </pre>
       *
       * <code>string signature = 3;</code>
       */
      public Builder setSignature(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        signature_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Embedded signature in the digital card, encoded in base64.
       * </pre>
       *
       * <code>string signature = 3;</code>
       */
      public Builder clearSignature() {
        
        signature_ = getDefaultInstance().getSignature();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Embedded signature in the digital card, encoded in base64.
       * </pre>
       *
       * <code>string signature = 3;</code>
       */
      public Builder setSignatureBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        signature_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object agent_ = "";
      /**
       * <pre>
       * Digital signature and hash from the submitting device, encoded in base64.
       * </pre>
       *
       * <code>string agent = 4;</code>
       */
      public java.lang.String getAgent() {
        java.lang.Object ref = agent_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          agent_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Digital signature and hash from the submitting device, encoded in base64.
       * </pre>
       *
       * <code>string agent = 4;</code>
       */
      public com.google.protobuf.ByteString
          getAgentBytes() {
        java.lang.Object ref = agent_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          agent_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Digital signature and hash from the submitting device, encoded in base64.
       * </pre>
       *
       * <code>string agent = 4;</code>
       */
      public Builder setAgent(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        agent_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Digital signature and hash from the submitting device, encoded in base64.
       * </pre>
       *
       * <code>string agent = 4;</code>
       */
      public Builder clearAgent() {
        
        agent_ = getDefaultInstance().getAgent();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Digital signature and hash from the submitting device, encoded in base64.
       * </pre>
       *
       * <code>string agent = 4;</code>
       */
      public Builder setAgentBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        agent_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object scope_ = "";
      /**
       * <pre>
       * Partnership scope for the request.
       * </pre>
       *
       * <code>string scope = 5;</code>
       */
      public java.lang.String getScope() {
        java.lang.Object ref = scope_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          scope_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Partnership scope for the request.
       * </pre>
       *
       * <code>string scope = 5;</code>
       */
      public com.google.protobuf.ByteString
          getScopeBytes() {
        java.lang.Object ref = scope_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          scope_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Partnership scope for the request.
       * </pre>
       *
       * <code>string scope = 5;</code>
       */
      public Builder setScope(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        scope_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Partnership scope for the request.
       * </pre>
       *
       * <code>string scope = 5;</code>
       */
      public Builder clearScope() {
        
        scope_ = getDefaultInstance().getScope();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Partnership scope for the request.
       * </pre>
       *
       * <code>string scope = 5;</code>
       */
      public Builder setScopeBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        scope_ = value;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.checkin.v1beta1.CardCheckin.Request)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.checkin.v1beta1.CardCheckin.Request)
    private static final io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request();
    }

    public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Request>
        PARSER = new com.google.protobuf.AbstractParser<Request>() {
      public Request parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Request(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Request> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Request> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface OperationOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Request to check a user in via their government ID.
     * </pre>
     *
     * <code>.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request request = 1;</code>
     */
    boolean hasRequest();
    /**
     * <pre>
     * Request to check a user in via their government ID.
     * </pre>
     *
     * <code>.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request request = 1;</code>
     */
    io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request getRequest();
    /**
     * <pre>
     * Request to check a user in via their government ID.
     * </pre>
     *
     * <code>.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request request = 1;</code>
     */
    io.bloombox.schema.services.checkin.v1beta1.CardCheckin.RequestOrBuilder getRequestOrBuilder();

    /**
     * <pre>
     * Generic checkin response.
     * </pre>
     *
     * <code>.bloombox.schema.services.checkin.v1beta1.CheckinResponse response = 2;</code>
     */
    boolean hasResponse();
    /**
     * <pre>
     * Generic checkin response.
     * </pre>
     *
     * <code>.bloombox.schema.services.checkin.v1beta1.CheckinResponse response = 2;</code>
     */
    io.bloombox.schema.services.checkin.v1beta1.CheckinResponse getResponse();
    /**
     * <pre>
     * Generic checkin response.
     * </pre>
     *
     * <code>.bloombox.schema.services.checkin.v1beta1.CheckinResponse response = 2;</code>
     */
    io.bloombox.schema.services.checkin.v1beta1.CheckinResponseOrBuilder getResponseOrBuilder();
  }
  /**
   * <pre>
   * Specifies a digital checkin operation, consisting of one request and one generic checkin response.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation}
   */
  public  static final class Operation extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation)
      OperationOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Operation.newBuilder() to construct.
    private Operation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Operation() {
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Operation(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request.Builder subBuilder = null;
              if (request_ != null) {
                subBuilder = request_.toBuilder();
              }
              request_ = input.readMessage(io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(request_);
                request_ = subBuilder.buildPartial();
              }

              break;
            }
            case 18: {
              io.bloombox.schema.services.checkin.v1beta1.CheckinResponse.Builder subBuilder = null;
              if (response_ != null) {
                subBuilder = response_.toBuilder();
              }
              response_ = input.readMessage(io.bloombox.schema.services.checkin.v1beta1.CheckinResponse.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(response_);
                response_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.checkin.v1beta1.CheckinServiceBeta1.internal_static_bloombox_schema_services_checkin_v1beta1_CardCheckin_Operation_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.checkin.v1beta1.CheckinServiceBeta1.internal_static_bloombox_schema_services_checkin_v1beta1_CardCheckin_Operation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation.class, io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation.Builder.class);
    }

    public static final int REQUEST_FIELD_NUMBER = 1;
    private io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request request_;
    /**
     * <pre>
     * Request to check a user in via their government ID.
     * </pre>
     *
     * <code>.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request request = 1;</code>
     */
    public boolean hasRequest() {
      return request_ != null;
    }
    /**
     * <pre>
     * Request to check a user in via their government ID.
     * </pre>
     *
     * <code>.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request request = 1;</code>
     */
    public io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request getRequest() {
      return request_ == null ? io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request.getDefaultInstance() : request_;
    }
    /**
     * <pre>
     * Request to check a user in via their government ID.
     * </pre>
     *
     * <code>.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request request = 1;</code>
     */
    public io.bloombox.schema.services.checkin.v1beta1.CardCheckin.RequestOrBuilder getRequestOrBuilder() {
      return getRequest();
    }

    public static final int RESPONSE_FIELD_NUMBER = 2;
    private io.bloombox.schema.services.checkin.v1beta1.CheckinResponse response_;
    /**
     * <pre>
     * Generic checkin response.
     * </pre>
     *
     * <code>.bloombox.schema.services.checkin.v1beta1.CheckinResponse response = 2;</code>
     */
    public boolean hasResponse() {
      return response_ != null;
    }
    /**
     * <pre>
     * Generic checkin response.
     * </pre>
     *
     * <code>.bloombox.schema.services.checkin.v1beta1.CheckinResponse response = 2;</code>
     */
    public io.bloombox.schema.services.checkin.v1beta1.CheckinResponse getResponse() {
      return response_ == null ? io.bloombox.schema.services.checkin.v1beta1.CheckinResponse.getDefaultInstance() : response_;
    }
    /**
     * <pre>
     * Generic checkin response.
     * </pre>
     *
     * <code>.bloombox.schema.services.checkin.v1beta1.CheckinResponse response = 2;</code>
     */
    public io.bloombox.schema.services.checkin.v1beta1.CheckinResponseOrBuilder getResponseOrBuilder() {
      return getResponse();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (request_ != null) {
        output.writeMessage(1, getRequest());
      }
      if (response_ != null) {
        output.writeMessage(2, getResponse());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (request_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getRequest());
      }
      if (response_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getResponse());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation other = (io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation) obj;

      boolean result = true;
      result = result && (hasRequest() == other.hasRequest());
      if (hasRequest()) {
        result = result && getRequest()
            .equals(other.getRequest());
      }
      result = result && (hasResponse() == other.hasResponse());
      if (hasResponse()) {
        result = result && getResponse()
            .equals(other.getResponse());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasRequest()) {
        hash = (37 * hash) + REQUEST_FIELD_NUMBER;
        hash = (53 * hash) + getRequest().hashCode();
      }
      if (hasResponse()) {
        hash = (37 * hash) + RESPONSE_FIELD_NUMBER;
        hash = (53 * hash) + getResponse().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies a digital checkin operation, consisting of one request and one generic checkin response.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation)
        io.bloombox.schema.services.checkin.v1beta1.CardCheckin.OperationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.checkin.v1beta1.CheckinServiceBeta1.internal_static_bloombox_schema_services_checkin_v1beta1_CardCheckin_Operation_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.checkin.v1beta1.CheckinServiceBeta1.internal_static_bloombox_schema_services_checkin_v1beta1_CardCheckin_Operation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation.class, io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation.Builder.class);
      }

      // Construct using io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        if (requestBuilder_ == null) {
          request_ = null;
        } else {
          request_ = null;
          requestBuilder_ = null;
        }
        if (responseBuilder_ == null) {
          response_ = null;
        } else {
          response_ = null;
          responseBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.checkin.v1beta1.CheckinServiceBeta1.internal_static_bloombox_schema_services_checkin_v1beta1_CardCheckin_Operation_descriptor;
      }

      public io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation getDefaultInstanceForType() {
        return io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation.getDefaultInstance();
      }

      public io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation build() {
        io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation buildPartial() {
        io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation result = new io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation(this);
        if (requestBuilder_ == null) {
          result.request_ = request_;
        } else {
          result.request_ = requestBuilder_.build();
        }
        if (responseBuilder_ == null) {
          result.response_ = response_;
        } else {
          result.response_ = responseBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation) {
          return mergeFrom((io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation other) {
        if (other == io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation.getDefaultInstance()) return this;
        if (other.hasRequest()) {
          mergeRequest(other.getRequest());
        }
        if (other.hasResponse()) {
          mergeResponse(other.getResponse());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request request_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request, io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request.Builder, io.bloombox.schema.services.checkin.v1beta1.CardCheckin.RequestOrBuilder> requestBuilder_;
      /**
       * <pre>
       * Request to check a user in via their government ID.
       * </pre>
       *
       * <code>.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request request = 1;</code>
       */
      public boolean hasRequest() {
        return requestBuilder_ != null || request_ != null;
      }
      /**
       * <pre>
       * Request to check a user in via their government ID.
       * </pre>
       *
       * <code>.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request request = 1;</code>
       */
      public io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request getRequest() {
        if (requestBuilder_ == null) {
          return request_ == null ? io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request.getDefaultInstance() : request_;
        } else {
          return requestBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Request to check a user in via their government ID.
       * </pre>
       *
       * <code>.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request request = 1;</code>
       */
      public Builder setRequest(io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request value) {
        if (requestBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          request_ = value;
          onChanged();
        } else {
          requestBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Request to check a user in via their government ID.
       * </pre>
       *
       * <code>.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request request = 1;</code>
       */
      public Builder setRequest(
          io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request.Builder builderForValue) {
        if (requestBuilder_ == null) {
          request_ = builderForValue.build();
          onChanged();
        } else {
          requestBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Request to check a user in via their government ID.
       * </pre>
       *
       * <code>.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request request = 1;</code>
       */
      public Builder mergeRequest(io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request value) {
        if (requestBuilder_ == null) {
          if (request_ != null) {
            request_ =
              io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request.newBuilder(request_).mergeFrom(value).buildPartial();
          } else {
            request_ = value;
          }
          onChanged();
        } else {
          requestBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Request to check a user in via their government ID.
       * </pre>
       *
       * <code>.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request request = 1;</code>
       */
      public Builder clearRequest() {
        if (requestBuilder_ == null) {
          request_ = null;
          onChanged();
        } else {
          request_ = null;
          requestBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Request to check a user in via their government ID.
       * </pre>
       *
       * <code>.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request request = 1;</code>
       */
      public io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request.Builder getRequestBuilder() {
        
        onChanged();
        return getRequestFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Request to check a user in via their government ID.
       * </pre>
       *
       * <code>.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request request = 1;</code>
       */
      public io.bloombox.schema.services.checkin.v1beta1.CardCheckin.RequestOrBuilder getRequestOrBuilder() {
        if (requestBuilder_ != null) {
          return requestBuilder_.getMessageOrBuilder();
        } else {
          return request_ == null ?
              io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request.getDefaultInstance() : request_;
        }
      }
      /**
       * <pre>
       * Request to check a user in via their government ID.
       * </pre>
       *
       * <code>.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request request = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request, io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request.Builder, io.bloombox.schema.services.checkin.v1beta1.CardCheckin.RequestOrBuilder> 
          getRequestFieldBuilder() {
        if (requestBuilder_ == null) {
          requestBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request, io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Request.Builder, io.bloombox.schema.services.checkin.v1beta1.CardCheckin.RequestOrBuilder>(
                  getRequest(),
                  getParentForChildren(),
                  isClean());
          request_ = null;
        }
        return requestBuilder_;
      }

      private io.bloombox.schema.services.checkin.v1beta1.CheckinResponse response_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.services.checkin.v1beta1.CheckinResponse, io.bloombox.schema.services.checkin.v1beta1.CheckinResponse.Builder, io.bloombox.schema.services.checkin.v1beta1.CheckinResponseOrBuilder> responseBuilder_;
      /**
       * <pre>
       * Generic checkin response.
       * </pre>
       *
       * <code>.bloombox.schema.services.checkin.v1beta1.CheckinResponse response = 2;</code>
       */
      public boolean hasResponse() {
        return responseBuilder_ != null || response_ != null;
      }
      /**
       * <pre>
       * Generic checkin response.
       * </pre>
       *
       * <code>.bloombox.schema.services.checkin.v1beta1.CheckinResponse response = 2;</code>
       */
      public io.bloombox.schema.services.checkin.v1beta1.CheckinResponse getResponse() {
        if (responseBuilder_ == null) {
          return response_ == null ? io.bloombox.schema.services.checkin.v1beta1.CheckinResponse.getDefaultInstance() : response_;
        } else {
          return responseBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Generic checkin response.
       * </pre>
       *
       * <code>.bloombox.schema.services.checkin.v1beta1.CheckinResponse response = 2;</code>
       */
      public Builder setResponse(io.bloombox.schema.services.checkin.v1beta1.CheckinResponse value) {
        if (responseBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          response_ = value;
          onChanged();
        } else {
          responseBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Generic checkin response.
       * </pre>
       *
       * <code>.bloombox.schema.services.checkin.v1beta1.CheckinResponse response = 2;</code>
       */
      public Builder setResponse(
          io.bloombox.schema.services.checkin.v1beta1.CheckinResponse.Builder builderForValue) {
        if (responseBuilder_ == null) {
          response_ = builderForValue.build();
          onChanged();
        } else {
          responseBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Generic checkin response.
       * </pre>
       *
       * <code>.bloombox.schema.services.checkin.v1beta1.CheckinResponse response = 2;</code>
       */
      public Builder mergeResponse(io.bloombox.schema.services.checkin.v1beta1.CheckinResponse value) {
        if (responseBuilder_ == null) {
          if (response_ != null) {
            response_ =
              io.bloombox.schema.services.checkin.v1beta1.CheckinResponse.newBuilder(response_).mergeFrom(value).buildPartial();
          } else {
            response_ = value;
          }
          onChanged();
        } else {
          responseBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Generic checkin response.
       * </pre>
       *
       * <code>.bloombox.schema.services.checkin.v1beta1.CheckinResponse response = 2;</code>
       */
      public Builder clearResponse() {
        if (responseBuilder_ == null) {
          response_ = null;
          onChanged();
        } else {
          response_ = null;
          responseBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Generic checkin response.
       * </pre>
       *
       * <code>.bloombox.schema.services.checkin.v1beta1.CheckinResponse response = 2;</code>
       */
      public io.bloombox.schema.services.checkin.v1beta1.CheckinResponse.Builder getResponseBuilder() {
        
        onChanged();
        return getResponseFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Generic checkin response.
       * </pre>
       *
       * <code>.bloombox.schema.services.checkin.v1beta1.CheckinResponse response = 2;</code>
       */
      public io.bloombox.schema.services.checkin.v1beta1.CheckinResponseOrBuilder getResponseOrBuilder() {
        if (responseBuilder_ != null) {
          return responseBuilder_.getMessageOrBuilder();
        } else {
          return response_ == null ?
              io.bloombox.schema.services.checkin.v1beta1.CheckinResponse.getDefaultInstance() : response_;
        }
      }
      /**
       * <pre>
       * Generic checkin response.
       * </pre>
       *
       * <code>.bloombox.schema.services.checkin.v1beta1.CheckinResponse response = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.services.checkin.v1beta1.CheckinResponse, io.bloombox.schema.services.checkin.v1beta1.CheckinResponse.Builder, io.bloombox.schema.services.checkin.v1beta1.CheckinResponseOrBuilder> 
          getResponseFieldBuilder() {
        if (responseBuilder_ == null) {
          responseBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.services.checkin.v1beta1.CheckinResponse, io.bloombox.schema.services.checkin.v1beta1.CheckinResponse.Builder, io.bloombox.schema.services.checkin.v1beta1.CheckinResponseOrBuilder>(
                  getResponse(),
                  getParentForChildren(),
                  isClean());
          response_ = null;
        }
        return responseBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation)
    private static final io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation();
    }

    public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Operation>
        PARSER = new com.google.protobuf.AbstractParser<Operation>() {
      public Operation parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Operation(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Operation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Operation> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Operation getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.services.checkin.v1beta1.CardCheckin)) {
      return super.equals(obj);
    }
    io.bloombox.schema.services.checkin.v1beta1.CardCheckin other = (io.bloombox.schema.services.checkin.v1beta1.CardCheckin) obj;

    boolean result = true;
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.services.checkin.v1beta1.CardCheckin prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies an RPC operation to check a user via an authenticated digital representation of their identity, usually in
   * the form of an Apple Wallet based, Bloombox-issued pass.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.checkin.v1beta1.CardCheckin}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.services.checkin.v1beta1.CardCheckin)
      io.bloombox.schema.services.checkin.v1beta1.CardCheckinOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.checkin.v1beta1.CheckinServiceBeta1.internal_static_bloombox_schema_services_checkin_v1beta1_CardCheckin_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.checkin.v1beta1.CheckinServiceBeta1.internal_static_bloombox_schema_services_checkin_v1beta1_CardCheckin_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.checkin.v1beta1.CardCheckin.class, io.bloombox.schema.services.checkin.v1beta1.CardCheckin.Builder.class);
    }

    // Construct using io.bloombox.schema.services.checkin.v1beta1.CardCheckin.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.services.checkin.v1beta1.CheckinServiceBeta1.internal_static_bloombox_schema_services_checkin_v1beta1_CardCheckin_descriptor;
    }

    public io.bloombox.schema.services.checkin.v1beta1.CardCheckin getDefaultInstanceForType() {
      return io.bloombox.schema.services.checkin.v1beta1.CardCheckin.getDefaultInstance();
    }

    public io.bloombox.schema.services.checkin.v1beta1.CardCheckin build() {
      io.bloombox.schema.services.checkin.v1beta1.CardCheckin result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.services.checkin.v1beta1.CardCheckin buildPartial() {
      io.bloombox.schema.services.checkin.v1beta1.CardCheckin result = new io.bloombox.schema.services.checkin.v1beta1.CardCheckin(this);
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.services.checkin.v1beta1.CardCheckin) {
        return mergeFrom((io.bloombox.schema.services.checkin.v1beta1.CardCheckin)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.services.checkin.v1beta1.CardCheckin other) {
      if (other == io.bloombox.schema.services.checkin.v1beta1.CardCheckin.getDefaultInstance()) return this;
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.services.checkin.v1beta1.CardCheckin parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.services.checkin.v1beta1.CardCheckin) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.services.checkin.v1beta1.CardCheckin)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.services.checkin.v1beta1.CardCheckin)
  private static final io.bloombox.schema.services.checkin.v1beta1.CardCheckin DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.services.checkin.v1beta1.CardCheckin();
  }

  public static io.bloombox.schema.services.checkin.v1beta1.CardCheckin getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CardCheckin>
      PARSER = new com.google.protobuf.AbstractParser<CardCheckin>() {
    public CardCheckin parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new CardCheckin(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<CardCheckin> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CardCheckin> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.services.checkin.v1beta1.CardCheckin getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

