/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: dash/v1beta1/DashService_Beta1.proto

package io.bloombox.schema.services.dash.v1beta1;

/**
 * <pre>
 * Enumerates known error states that may surface when interacting with the Dashboard Service.
 * </pre>
 *
 * Protobuf enum {@code bloombox.schema.services.dash.v1beta1.DashError}
 */
public enum DashError
    implements com.google.protobuf.ProtocolMessageEnum {
  /**
   * <pre>
   * No error was encountered.
   * </pre>
   *
   * <code>NO_ERROR = 0;</code>
   */
  NO_ERROR(0),
  /**
   * <pre>
   * The specified partner key was found to be invalid.
   * </pre>
   *
   * <code>PARTNER_INVALID = 1;</code>
   */
  PARTNER_INVALID(1),
  /**
   * <pre>
   * The specified partner key, while valid, could not be resolved.
   * </pre>
   *
   * <code>PARTNER_NOT_FOUND = 2;</code>
   */
  PARTNER_NOT_FOUND(2),
  /**
   * <pre>
   * The speciied location key was found to be invalid.
   * </pre>
   *
   * <code>LOCATION_INVALID = 3;</code>
   */
  LOCATION_INVALID(3),
  /**
   * <pre>
   * The specified location key, while valid, could not be resolved.
   * </pre>
   *
   * <code>LOCATION_NOT_FOUND = 4;</code>
   */
  LOCATION_NOT_FOUND(4),
  /**
   * <pre>
   * Permission was denied for the current security context.
   * </pre>
   *
   * <code>PERMISSION_DENIED = 90;</code>
   */
  PERMISSION_DENIED(90),
  /**
   * <pre>
   * A routine was found not be implemented.
   * </pre>
   *
   * <code>NOT_IMPLEMENTED = 91;</code>
   */
  NOT_IMPLEMENTED(91),
  /**
   * <pre>
   * An unknown or unidentified internal error occurred.
   * </pre>
   *
   * <code>INTERNAL_ERROR = 99;</code>
   */
  INTERNAL_ERROR(99),
  UNRECOGNIZED(-1),
  ;

  /**
   * <pre>
   * No error was encountered.
   * </pre>
   *
   * <code>NO_ERROR = 0;</code>
   */
  public static final int NO_ERROR_VALUE = 0;
  /**
   * <pre>
   * The specified partner key was found to be invalid.
   * </pre>
   *
   * <code>PARTNER_INVALID = 1;</code>
   */
  public static final int PARTNER_INVALID_VALUE = 1;
  /**
   * <pre>
   * The specified partner key, while valid, could not be resolved.
   * </pre>
   *
   * <code>PARTNER_NOT_FOUND = 2;</code>
   */
  public static final int PARTNER_NOT_FOUND_VALUE = 2;
  /**
   * <pre>
   * The speciied location key was found to be invalid.
   * </pre>
   *
   * <code>LOCATION_INVALID = 3;</code>
   */
  public static final int LOCATION_INVALID_VALUE = 3;
  /**
   * <pre>
   * The specified location key, while valid, could not be resolved.
   * </pre>
   *
   * <code>LOCATION_NOT_FOUND = 4;</code>
   */
  public static final int LOCATION_NOT_FOUND_VALUE = 4;
  /**
   * <pre>
   * Permission was denied for the current security context.
   * </pre>
   *
   * <code>PERMISSION_DENIED = 90;</code>
   */
  public static final int PERMISSION_DENIED_VALUE = 90;
  /**
   * <pre>
   * A routine was found not be implemented.
   * </pre>
   *
   * <code>NOT_IMPLEMENTED = 91;</code>
   */
  public static final int NOT_IMPLEMENTED_VALUE = 91;
  /**
   * <pre>
   * An unknown or unidentified internal error occurred.
   * </pre>
   *
   * <code>INTERNAL_ERROR = 99;</code>
   */
  public static final int INTERNAL_ERROR_VALUE = 99;


  public final int getNumber() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalArgumentException(
          "Can't get the number of an unknown enum value.");
    }
    return value;
  }

  /**
   * @deprecated Use {@link #forNumber(int)} instead.
   */
  @java.lang.Deprecated
  public static DashError valueOf(int value) {
    return forNumber(value);
  }

  public static DashError forNumber(int value) {
    switch (value) {
      case 0: return NO_ERROR;
      case 1: return PARTNER_INVALID;
      case 2: return PARTNER_NOT_FOUND;
      case 3: return LOCATION_INVALID;
      case 4: return LOCATION_NOT_FOUND;
      case 90: return PERMISSION_DENIED;
      case 91: return NOT_IMPLEMENTED;
      case 99: return INTERNAL_ERROR;
      default: return null;
    }
  }

  public static com.google.protobuf.Internal.EnumLiteMap<DashError>
      internalGetValueMap() {
    return internalValueMap;
  }
  private static final com.google.protobuf.Internal.EnumLiteMap<
      DashError> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<DashError>() {
          public DashError findValueByNumber(int number) {
            return DashError.forNumber(number);
          }
        };

  public final com.google.protobuf.Descriptors.EnumValueDescriptor
      getValueDescriptor() {
    return getDescriptor().getValues().get(ordinal());
  }
  public final com.google.protobuf.Descriptors.EnumDescriptor
      getDescriptorForType() {
    return getDescriptor();
  }
  public static final com.google.protobuf.Descriptors.EnumDescriptor
      getDescriptor() {
    return io.bloombox.schema.services.dash.v1beta1.DashServiceBeta1.getDescriptor().getEnumTypes().get(0);
  }

  private static final DashError[] VALUES = values();

  public static DashError valueOf(
      com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
    if (desc.getType() != getDescriptor()) {
      throw new java.lang.IllegalArgumentException(
        "EnumValueDescriptor is not for this type.");
    }
    if (desc.getIndex() == -1) {
      return UNRECOGNIZED;
    }
    return VALUES[desc.getIndex()];
  }

  private final int value;

  private DashError(int value) {
    this.value = value;
  }

  // @@protoc_insertion_point(enum_scope:bloombox.schema.services.dash.v1beta1.DashError)
}

