/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: devices/v1beta1/DevicesService_Beta1.proto

package io.bloombox.schema.services.devices.v1beta1;

/**
 * <pre>
 * Specifies an RPC operation to activate a hardware device for use.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.services.devices.v1beta1.Activation}
 */
public  final class Activation extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.services.devices.v1beta1.Activation)
    ActivationOrBuilder {
private static final long serialVersionUID = 0L;
  // Use Activation.newBuilder() to construct.
  private Activation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private Activation() {
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private Activation(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.services.devices.v1beta1.DevicesServiceBeta1.internal_static_bloombox_schema_services_devices_v1beta1_Activation_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.services.devices.v1beta1.DevicesServiceBeta1.internal_static_bloombox_schema_services_devices_v1beta1_Activation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.services.devices.v1beta1.Activation.class, io.bloombox.schema.services.devices.v1beta1.Activation.Builder.class);
  }

  public interface RequestOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.devices.v1beta1.Activation.Request)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Hardware device's serial number.
     * </pre>
     *
     * <code>string serial = 1;</code>
     */
    java.lang.String getSerial();
    /**
     * <pre>
     * Hardware device's serial number.
     * </pre>
     *
     * <code>string serial = 1;</code>
     */
    com.google.protobuf.ByteString
        getSerialBytes();

    /**
     * <pre>
     * Hardware fingerprint value.
     * </pre>
     *
     * <code>string fingerprint = 2;</code>
     */
    java.lang.String getFingerprint();
    /**
     * <pre>
     * Hardware fingerprint value.
     * </pre>
     *
     * <code>string fingerprint = 2;</code>
     */
    com.google.protobuf.ByteString
        getFingerprintBytes();
  }
  /**
   * <pre>
   * Request to activate a hardware device.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.devices.v1beta1.Activation.Request}
   */
  public  static final class Request extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.devices.v1beta1.Activation.Request)
      RequestOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Request.newBuilder() to construct.
    private Request(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Request() {
      serial_ = "";
      fingerprint_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Request(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              serial_ = s;
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();

              fingerprint_ = s;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.devices.v1beta1.DevicesServiceBeta1.internal_static_bloombox_schema_services_devices_v1beta1_Activation_Request_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.devices.v1beta1.DevicesServiceBeta1.internal_static_bloombox_schema_services_devices_v1beta1_Activation_Request_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.devices.v1beta1.Activation.Request.class, io.bloombox.schema.services.devices.v1beta1.Activation.Request.Builder.class);
    }

    public static final int SERIAL_FIELD_NUMBER = 1;
    private volatile java.lang.Object serial_;
    /**
     * <pre>
     * Hardware device's serial number.
     * </pre>
     *
     * <code>string serial = 1;</code>
     */
    public java.lang.String getSerial() {
      java.lang.Object ref = serial_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serial_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Hardware device's serial number.
     * </pre>
     *
     * <code>string serial = 1;</code>
     */
    public com.google.protobuf.ByteString
        getSerialBytes() {
      java.lang.Object ref = serial_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        serial_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FINGERPRINT_FIELD_NUMBER = 2;
    private volatile java.lang.Object fingerprint_;
    /**
     * <pre>
     * Hardware fingerprint value.
     * </pre>
     *
     * <code>string fingerprint = 2;</code>
     */
    public java.lang.String getFingerprint() {
      java.lang.Object ref = fingerprint_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fingerprint_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Hardware fingerprint value.
     * </pre>
     *
     * <code>string fingerprint = 2;</code>
     */
    public com.google.protobuf.ByteString
        getFingerprintBytes() {
      java.lang.Object ref = fingerprint_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        fingerprint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getSerialBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, serial_);
      }
      if (!getFingerprintBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, fingerprint_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getSerialBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, serial_);
      }
      if (!getFingerprintBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, fingerprint_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.devices.v1beta1.Activation.Request)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.devices.v1beta1.Activation.Request other = (io.bloombox.schema.services.devices.v1beta1.Activation.Request) obj;

      boolean result = true;
      result = result && getSerial()
          .equals(other.getSerial());
      result = result && getFingerprint()
          .equals(other.getFingerprint());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SERIAL_FIELD_NUMBER;
      hash = (53 * hash) + getSerial().hashCode();
      hash = (37 * hash) + FINGERPRINT_FIELD_NUMBER;
      hash = (53 * hash) + getFingerprint().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.devices.v1beta1.Activation.Request parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.devices.v1beta1.Activation.Request parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.devices.v1beta1.Activation.Request parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.devices.v1beta1.Activation.Request parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.devices.v1beta1.Activation.Request parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.devices.v1beta1.Activation.Request parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.devices.v1beta1.Activation.Request parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.devices.v1beta1.Activation.Request parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.devices.v1beta1.Activation.Request parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.devices.v1beta1.Activation.Request parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.devices.v1beta1.Activation.Request parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.devices.v1beta1.Activation.Request parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.devices.v1beta1.Activation.Request prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Request to activate a hardware device.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.devices.v1beta1.Activation.Request}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.devices.v1beta1.Activation.Request)
        io.bloombox.schema.services.devices.v1beta1.Activation.RequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.devices.v1beta1.DevicesServiceBeta1.internal_static_bloombox_schema_services_devices_v1beta1_Activation_Request_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.devices.v1beta1.DevicesServiceBeta1.internal_static_bloombox_schema_services_devices_v1beta1_Activation_Request_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.devices.v1beta1.Activation.Request.class, io.bloombox.schema.services.devices.v1beta1.Activation.Request.Builder.class);
      }

      // Construct using io.bloombox.schema.services.devices.v1beta1.Activation.Request.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        serial_ = "";

        fingerprint_ = "";

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.devices.v1beta1.DevicesServiceBeta1.internal_static_bloombox_schema_services_devices_v1beta1_Activation_Request_descriptor;
      }

      public io.bloombox.schema.services.devices.v1beta1.Activation.Request getDefaultInstanceForType() {
        return io.bloombox.schema.services.devices.v1beta1.Activation.Request.getDefaultInstance();
      }

      public io.bloombox.schema.services.devices.v1beta1.Activation.Request build() {
        io.bloombox.schema.services.devices.v1beta1.Activation.Request result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.devices.v1beta1.Activation.Request buildPartial() {
        io.bloombox.schema.services.devices.v1beta1.Activation.Request result = new io.bloombox.schema.services.devices.v1beta1.Activation.Request(this);
        result.serial_ = serial_;
        result.fingerprint_ = fingerprint_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.devices.v1beta1.Activation.Request) {
          return mergeFrom((io.bloombox.schema.services.devices.v1beta1.Activation.Request)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.devices.v1beta1.Activation.Request other) {
        if (other == io.bloombox.schema.services.devices.v1beta1.Activation.Request.getDefaultInstance()) return this;
        if (!other.getSerial().isEmpty()) {
          serial_ = other.serial_;
          onChanged();
        }
        if (!other.getFingerprint().isEmpty()) {
          fingerprint_ = other.fingerprint_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.devices.v1beta1.Activation.Request parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.devices.v1beta1.Activation.Request) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object serial_ = "";
      /**
       * <pre>
       * Hardware device's serial number.
       * </pre>
       *
       * <code>string serial = 1;</code>
       */
      public java.lang.String getSerial() {
        java.lang.Object ref = serial_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          serial_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Hardware device's serial number.
       * </pre>
       *
       * <code>string serial = 1;</code>
       */
      public com.google.protobuf.ByteString
          getSerialBytes() {
        java.lang.Object ref = serial_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          serial_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Hardware device's serial number.
       * </pre>
       *
       * <code>string serial = 1;</code>
       */
      public Builder setSerial(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        serial_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Hardware device's serial number.
       * </pre>
       *
       * <code>string serial = 1;</code>
       */
      public Builder clearSerial() {
        
        serial_ = getDefaultInstance().getSerial();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Hardware device's serial number.
       * </pre>
       *
       * <code>string serial = 1;</code>
       */
      public Builder setSerialBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        serial_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object fingerprint_ = "";
      /**
       * <pre>
       * Hardware fingerprint value.
       * </pre>
       *
       * <code>string fingerprint = 2;</code>
       */
      public java.lang.String getFingerprint() {
        java.lang.Object ref = fingerprint_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          fingerprint_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Hardware fingerprint value.
       * </pre>
       *
       * <code>string fingerprint = 2;</code>
       */
      public com.google.protobuf.ByteString
          getFingerprintBytes() {
        java.lang.Object ref = fingerprint_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          fingerprint_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Hardware fingerprint value.
       * </pre>
       *
       * <code>string fingerprint = 2;</code>
       */
      public Builder setFingerprint(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        fingerprint_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Hardware fingerprint value.
       * </pre>
       *
       * <code>string fingerprint = 2;</code>
       */
      public Builder clearFingerprint() {
        
        fingerprint_ = getDefaultInstance().getFingerprint();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Hardware fingerprint value.
       * </pre>
       *
       * <code>string fingerprint = 2;</code>
       */
      public Builder setFingerprintBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        fingerprint_ = value;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.devices.v1beta1.Activation.Request)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.devices.v1beta1.Activation.Request)
    private static final io.bloombox.schema.services.devices.v1beta1.Activation.Request DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.devices.v1beta1.Activation.Request();
    }

    public static io.bloombox.schema.services.devices.v1beta1.Activation.Request getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Request>
        PARSER = new com.google.protobuf.AbstractParser<Request>() {
      public Request parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Request(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Request> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Request> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.devices.v1beta1.Activation.Request getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ResponseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.devices.v1beta1.Activation.Response)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Device activation status, post-RPC.
     * </pre>
     *
     * <code>bool active = 1;</code>
     */
    boolean getActive();

    /**
     * <pre>
     * Error that occurred while activating, if any.
     * </pre>
     *
     * <code>.bloombox.schema.services.devices.v1beta1.DeviceError error = 2;</code>
     */
    int getErrorValue();
    /**
     * <pre>
     * Error that occurred while activating, if any.
     * </pre>
     *
     * <code>.bloombox.schema.services.devices.v1beta1.DeviceError error = 2;</code>
     */
    io.bloombox.schema.services.devices.v1beta1.DeviceError getError();

    /**
     * <pre>
     * Device activation information, including its assignment/role.
     * </pre>
     *
     * <code>.bloombox.schema.services.devices.v1beta1.DeviceActivation manifest = 3;</code>
     */
    boolean hasManifest();
    /**
     * <pre>
     * Device activation information, including its assignment/role.
     * </pre>
     *
     * <code>.bloombox.schema.services.devices.v1beta1.DeviceActivation manifest = 3;</code>
     */
    io.bloombox.schema.services.devices.v1beta1.DeviceActivation getManifest();
    /**
     * <pre>
     * Device activation information, including its assignment/role.
     * </pre>
     *
     * <code>.bloombox.schema.services.devices.v1beta1.DeviceActivation manifest = 3;</code>
     */
    io.bloombox.schema.services.devices.v1beta1.DeviceActivationOrBuilder getManifestOrBuilder();
  }
  /**
   * <pre>
   * Response to a request to activate a hardware device.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.devices.v1beta1.Activation.Response}
   */
  public  static final class Response extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.devices.v1beta1.Activation.Response)
      ResponseOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Response.newBuilder() to construct.
    private Response(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Response() {
      active_ = false;
      error_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Response(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {

              active_ = input.readBool();
              break;
            }
            case 16: {
              int rawValue = input.readEnum();

              error_ = rawValue;
              break;
            }
            case 26: {
              io.bloombox.schema.services.devices.v1beta1.DeviceActivation.Builder subBuilder = null;
              if (manifest_ != null) {
                subBuilder = manifest_.toBuilder();
              }
              manifest_ = input.readMessage(io.bloombox.schema.services.devices.v1beta1.DeviceActivation.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(manifest_);
                manifest_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.devices.v1beta1.DevicesServiceBeta1.internal_static_bloombox_schema_services_devices_v1beta1_Activation_Response_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.devices.v1beta1.DevicesServiceBeta1.internal_static_bloombox_schema_services_devices_v1beta1_Activation_Response_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.devices.v1beta1.Activation.Response.class, io.bloombox.schema.services.devices.v1beta1.Activation.Response.Builder.class);
    }

    public static final int ACTIVE_FIELD_NUMBER = 1;
    private boolean active_;
    /**
     * <pre>
     * Device activation status, post-RPC.
     * </pre>
     *
     * <code>bool active = 1;</code>
     */
    public boolean getActive() {
      return active_;
    }

    public static final int ERROR_FIELD_NUMBER = 2;
    private int error_;
    /**
     * <pre>
     * Error that occurred while activating, if any.
     * </pre>
     *
     * <code>.bloombox.schema.services.devices.v1beta1.DeviceError error = 2;</code>
     */
    public int getErrorValue() {
      return error_;
    }
    /**
     * <pre>
     * Error that occurred while activating, if any.
     * </pre>
     *
     * <code>.bloombox.schema.services.devices.v1beta1.DeviceError error = 2;</code>
     */
    public io.bloombox.schema.services.devices.v1beta1.DeviceError getError() {
      io.bloombox.schema.services.devices.v1beta1.DeviceError result = io.bloombox.schema.services.devices.v1beta1.DeviceError.valueOf(error_);
      return result == null ? io.bloombox.schema.services.devices.v1beta1.DeviceError.UNRECOGNIZED : result;
    }

    public static final int MANIFEST_FIELD_NUMBER = 3;
    private io.bloombox.schema.services.devices.v1beta1.DeviceActivation manifest_;
    /**
     * <pre>
     * Device activation information, including its assignment/role.
     * </pre>
     *
     * <code>.bloombox.schema.services.devices.v1beta1.DeviceActivation manifest = 3;</code>
     */
    public boolean hasManifest() {
      return manifest_ != null;
    }
    /**
     * <pre>
     * Device activation information, including its assignment/role.
     * </pre>
     *
     * <code>.bloombox.schema.services.devices.v1beta1.DeviceActivation manifest = 3;</code>
     */
    public io.bloombox.schema.services.devices.v1beta1.DeviceActivation getManifest() {
      return manifest_ == null ? io.bloombox.schema.services.devices.v1beta1.DeviceActivation.getDefaultInstance() : manifest_;
    }
    /**
     * <pre>
     * Device activation information, including its assignment/role.
     * </pre>
     *
     * <code>.bloombox.schema.services.devices.v1beta1.DeviceActivation manifest = 3;</code>
     */
    public io.bloombox.schema.services.devices.v1beta1.DeviceActivationOrBuilder getManifestOrBuilder() {
      return getManifest();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (active_ != false) {
        output.writeBool(1, active_);
      }
      if (error_ != io.bloombox.schema.services.devices.v1beta1.DeviceError.NO_ERROR.getNumber()) {
        output.writeEnum(2, error_);
      }
      if (manifest_ != null) {
        output.writeMessage(3, getManifest());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (active_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(1, active_);
      }
      if (error_ != io.bloombox.schema.services.devices.v1beta1.DeviceError.NO_ERROR.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, error_);
      }
      if (manifest_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getManifest());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.devices.v1beta1.Activation.Response)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.devices.v1beta1.Activation.Response other = (io.bloombox.schema.services.devices.v1beta1.Activation.Response) obj;

      boolean result = true;
      result = result && (getActive()
          == other.getActive());
      result = result && error_ == other.error_;
      result = result && (hasManifest() == other.hasManifest());
      if (hasManifest()) {
        result = result && getManifest()
            .equals(other.getManifest());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ACTIVE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getActive());
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + error_;
      if (hasManifest()) {
        hash = (37 * hash) + MANIFEST_FIELD_NUMBER;
        hash = (53 * hash) + getManifest().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.devices.v1beta1.Activation.Response parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.devices.v1beta1.Activation.Response parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.devices.v1beta1.Activation.Response parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.devices.v1beta1.Activation.Response parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.devices.v1beta1.Activation.Response parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.devices.v1beta1.Activation.Response parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.devices.v1beta1.Activation.Response parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.devices.v1beta1.Activation.Response parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.devices.v1beta1.Activation.Response parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.devices.v1beta1.Activation.Response parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.devices.v1beta1.Activation.Response parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.devices.v1beta1.Activation.Response parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.devices.v1beta1.Activation.Response prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Response to a request to activate a hardware device.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.devices.v1beta1.Activation.Response}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.devices.v1beta1.Activation.Response)
        io.bloombox.schema.services.devices.v1beta1.Activation.ResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.devices.v1beta1.DevicesServiceBeta1.internal_static_bloombox_schema_services_devices_v1beta1_Activation_Response_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.devices.v1beta1.DevicesServiceBeta1.internal_static_bloombox_schema_services_devices_v1beta1_Activation_Response_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.devices.v1beta1.Activation.Response.class, io.bloombox.schema.services.devices.v1beta1.Activation.Response.Builder.class);
      }

      // Construct using io.bloombox.schema.services.devices.v1beta1.Activation.Response.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        active_ = false;

        error_ = 0;

        if (manifestBuilder_ == null) {
          manifest_ = null;
        } else {
          manifest_ = null;
          manifestBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.devices.v1beta1.DevicesServiceBeta1.internal_static_bloombox_schema_services_devices_v1beta1_Activation_Response_descriptor;
      }

      public io.bloombox.schema.services.devices.v1beta1.Activation.Response getDefaultInstanceForType() {
        return io.bloombox.schema.services.devices.v1beta1.Activation.Response.getDefaultInstance();
      }

      public io.bloombox.schema.services.devices.v1beta1.Activation.Response build() {
        io.bloombox.schema.services.devices.v1beta1.Activation.Response result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.devices.v1beta1.Activation.Response buildPartial() {
        io.bloombox.schema.services.devices.v1beta1.Activation.Response result = new io.bloombox.schema.services.devices.v1beta1.Activation.Response(this);
        result.active_ = active_;
        result.error_ = error_;
        if (manifestBuilder_ == null) {
          result.manifest_ = manifest_;
        } else {
          result.manifest_ = manifestBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.devices.v1beta1.Activation.Response) {
          return mergeFrom((io.bloombox.schema.services.devices.v1beta1.Activation.Response)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.devices.v1beta1.Activation.Response other) {
        if (other == io.bloombox.schema.services.devices.v1beta1.Activation.Response.getDefaultInstance()) return this;
        if (other.getActive() != false) {
          setActive(other.getActive());
        }
        if (other.error_ != 0) {
          setErrorValue(other.getErrorValue());
        }
        if (other.hasManifest()) {
          mergeManifest(other.getManifest());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.devices.v1beta1.Activation.Response parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.devices.v1beta1.Activation.Response) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private boolean active_ ;
      /**
       * <pre>
       * Device activation status, post-RPC.
       * </pre>
       *
       * <code>bool active = 1;</code>
       */
      public boolean getActive() {
        return active_;
      }
      /**
       * <pre>
       * Device activation status, post-RPC.
       * </pre>
       *
       * <code>bool active = 1;</code>
       */
      public Builder setActive(boolean value) {
        
        active_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Device activation status, post-RPC.
       * </pre>
       *
       * <code>bool active = 1;</code>
       */
      public Builder clearActive() {
        
        active_ = false;
        onChanged();
        return this;
      }

      private int error_ = 0;
      /**
       * <pre>
       * Error that occurred while activating, if any.
       * </pre>
       *
       * <code>.bloombox.schema.services.devices.v1beta1.DeviceError error = 2;</code>
       */
      public int getErrorValue() {
        return error_;
      }
      /**
       * <pre>
       * Error that occurred while activating, if any.
       * </pre>
       *
       * <code>.bloombox.schema.services.devices.v1beta1.DeviceError error = 2;</code>
       */
      public Builder setErrorValue(int value) {
        error_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Error that occurred while activating, if any.
       * </pre>
       *
       * <code>.bloombox.schema.services.devices.v1beta1.DeviceError error = 2;</code>
       */
      public io.bloombox.schema.services.devices.v1beta1.DeviceError getError() {
        io.bloombox.schema.services.devices.v1beta1.DeviceError result = io.bloombox.schema.services.devices.v1beta1.DeviceError.valueOf(error_);
        return result == null ? io.bloombox.schema.services.devices.v1beta1.DeviceError.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Error that occurred while activating, if any.
       * </pre>
       *
       * <code>.bloombox.schema.services.devices.v1beta1.DeviceError error = 2;</code>
       */
      public Builder setError(io.bloombox.schema.services.devices.v1beta1.DeviceError value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        error_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Error that occurred while activating, if any.
       * </pre>
       *
       * <code>.bloombox.schema.services.devices.v1beta1.DeviceError error = 2;</code>
       */
      public Builder clearError() {
        
        error_ = 0;
        onChanged();
        return this;
      }

      private io.bloombox.schema.services.devices.v1beta1.DeviceActivation manifest_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.services.devices.v1beta1.DeviceActivation, io.bloombox.schema.services.devices.v1beta1.DeviceActivation.Builder, io.bloombox.schema.services.devices.v1beta1.DeviceActivationOrBuilder> manifestBuilder_;
      /**
       * <pre>
       * Device activation information, including its assignment/role.
       * </pre>
       *
       * <code>.bloombox.schema.services.devices.v1beta1.DeviceActivation manifest = 3;</code>
       */
      public boolean hasManifest() {
        return manifestBuilder_ != null || manifest_ != null;
      }
      /**
       * <pre>
       * Device activation information, including its assignment/role.
       * </pre>
       *
       * <code>.bloombox.schema.services.devices.v1beta1.DeviceActivation manifest = 3;</code>
       */
      public io.bloombox.schema.services.devices.v1beta1.DeviceActivation getManifest() {
        if (manifestBuilder_ == null) {
          return manifest_ == null ? io.bloombox.schema.services.devices.v1beta1.DeviceActivation.getDefaultInstance() : manifest_;
        } else {
          return manifestBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Device activation information, including its assignment/role.
       * </pre>
       *
       * <code>.bloombox.schema.services.devices.v1beta1.DeviceActivation manifest = 3;</code>
       */
      public Builder setManifest(io.bloombox.schema.services.devices.v1beta1.DeviceActivation value) {
        if (manifestBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          manifest_ = value;
          onChanged();
        } else {
          manifestBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Device activation information, including its assignment/role.
       * </pre>
       *
       * <code>.bloombox.schema.services.devices.v1beta1.DeviceActivation manifest = 3;</code>
       */
      public Builder setManifest(
          io.bloombox.schema.services.devices.v1beta1.DeviceActivation.Builder builderForValue) {
        if (manifestBuilder_ == null) {
          manifest_ = builderForValue.build();
          onChanged();
        } else {
          manifestBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Device activation information, including its assignment/role.
       * </pre>
       *
       * <code>.bloombox.schema.services.devices.v1beta1.DeviceActivation manifest = 3;</code>
       */
      public Builder mergeManifest(io.bloombox.schema.services.devices.v1beta1.DeviceActivation value) {
        if (manifestBuilder_ == null) {
          if (manifest_ != null) {
            manifest_ =
              io.bloombox.schema.services.devices.v1beta1.DeviceActivation.newBuilder(manifest_).mergeFrom(value).buildPartial();
          } else {
            manifest_ = value;
          }
          onChanged();
        } else {
          manifestBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Device activation information, including its assignment/role.
       * </pre>
       *
       * <code>.bloombox.schema.services.devices.v1beta1.DeviceActivation manifest = 3;</code>
       */
      public Builder clearManifest() {
        if (manifestBuilder_ == null) {
          manifest_ = null;
          onChanged();
        } else {
          manifest_ = null;
          manifestBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Device activation information, including its assignment/role.
       * </pre>
       *
       * <code>.bloombox.schema.services.devices.v1beta1.DeviceActivation manifest = 3;</code>
       */
      public io.bloombox.schema.services.devices.v1beta1.DeviceActivation.Builder getManifestBuilder() {
        
        onChanged();
        return getManifestFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Device activation information, including its assignment/role.
       * </pre>
       *
       * <code>.bloombox.schema.services.devices.v1beta1.DeviceActivation manifest = 3;</code>
       */
      public io.bloombox.schema.services.devices.v1beta1.DeviceActivationOrBuilder getManifestOrBuilder() {
        if (manifestBuilder_ != null) {
          return manifestBuilder_.getMessageOrBuilder();
        } else {
          return manifest_ == null ?
              io.bloombox.schema.services.devices.v1beta1.DeviceActivation.getDefaultInstance() : manifest_;
        }
      }
      /**
       * <pre>
       * Device activation information, including its assignment/role.
       * </pre>
       *
       * <code>.bloombox.schema.services.devices.v1beta1.DeviceActivation manifest = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.services.devices.v1beta1.DeviceActivation, io.bloombox.schema.services.devices.v1beta1.DeviceActivation.Builder, io.bloombox.schema.services.devices.v1beta1.DeviceActivationOrBuilder> 
          getManifestFieldBuilder() {
        if (manifestBuilder_ == null) {
          manifestBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.services.devices.v1beta1.DeviceActivation, io.bloombox.schema.services.devices.v1beta1.DeviceActivation.Builder, io.bloombox.schema.services.devices.v1beta1.DeviceActivationOrBuilder>(
                  getManifest(),
                  getParentForChildren(),
                  isClean());
          manifest_ = null;
        }
        return manifestBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.devices.v1beta1.Activation.Response)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.devices.v1beta1.Activation.Response)
    private static final io.bloombox.schema.services.devices.v1beta1.Activation.Response DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.devices.v1beta1.Activation.Response();
    }

    public static io.bloombox.schema.services.devices.v1beta1.Activation.Response getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Response>
        PARSER = new com.google.protobuf.AbstractParser<Response>() {
      public Response parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Response(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Response> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Response> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.devices.v1beta1.Activation.Response getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface OperationOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.devices.v1beta1.Activation.Operation)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Request to activate a device.
     * </pre>
     *
     * <code>.bloombox.schema.services.devices.v1beta1.Activation.Request request = 1;</code>
     */
    boolean hasRequest();
    /**
     * <pre>
     * Request to activate a device.
     * </pre>
     *
     * <code>.bloombox.schema.services.devices.v1beta1.Activation.Request request = 1;</code>
     */
    io.bloombox.schema.services.devices.v1beta1.Activation.Request getRequest();
    /**
     * <pre>
     * Request to activate a device.
     * </pre>
     *
     * <code>.bloombox.schema.services.devices.v1beta1.Activation.Request request = 1;</code>
     */
    io.bloombox.schema.services.devices.v1beta1.Activation.RequestOrBuilder getRequestOrBuilder();

    /**
     * <pre>
     * Response to a request to activate a device.
     * </pre>
     *
     * <code>.bloombox.schema.services.devices.v1beta1.Activation.Response response = 2;</code>
     */
    boolean hasResponse();
    /**
     * <pre>
     * Response to a request to activate a device.
     * </pre>
     *
     * <code>.bloombox.schema.services.devices.v1beta1.Activation.Response response = 2;</code>
     */
    io.bloombox.schema.services.devices.v1beta1.Activation.Response getResponse();
    /**
     * <pre>
     * Response to a request to activate a device.
     * </pre>
     *
     * <code>.bloombox.schema.services.devices.v1beta1.Activation.Response response = 2;</code>
     */
    io.bloombox.schema.services.devices.v1beta1.Activation.ResponseOrBuilder getResponseOrBuilder();
  }
  /**
   * <pre>
   * Specifies a device activation operation, consisting of one request and one response.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.devices.v1beta1.Activation.Operation}
   */
  public  static final class Operation extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.devices.v1beta1.Activation.Operation)
      OperationOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Operation.newBuilder() to construct.
    private Operation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Operation() {
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Operation(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              io.bloombox.schema.services.devices.v1beta1.Activation.Request.Builder subBuilder = null;
              if (request_ != null) {
                subBuilder = request_.toBuilder();
              }
              request_ = input.readMessage(io.bloombox.schema.services.devices.v1beta1.Activation.Request.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(request_);
                request_ = subBuilder.buildPartial();
              }

              break;
            }
            case 18: {
              io.bloombox.schema.services.devices.v1beta1.Activation.Response.Builder subBuilder = null;
              if (response_ != null) {
                subBuilder = response_.toBuilder();
              }
              response_ = input.readMessage(io.bloombox.schema.services.devices.v1beta1.Activation.Response.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(response_);
                response_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.devices.v1beta1.DevicesServiceBeta1.internal_static_bloombox_schema_services_devices_v1beta1_Activation_Operation_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.devices.v1beta1.DevicesServiceBeta1.internal_static_bloombox_schema_services_devices_v1beta1_Activation_Operation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.devices.v1beta1.Activation.Operation.class, io.bloombox.schema.services.devices.v1beta1.Activation.Operation.Builder.class);
    }

    public static final int REQUEST_FIELD_NUMBER = 1;
    private io.bloombox.schema.services.devices.v1beta1.Activation.Request request_;
    /**
     * <pre>
     * Request to activate a device.
     * </pre>
     *
     * <code>.bloombox.schema.services.devices.v1beta1.Activation.Request request = 1;</code>
     */
    public boolean hasRequest() {
      return request_ != null;
    }
    /**
     * <pre>
     * Request to activate a device.
     * </pre>
     *
     * <code>.bloombox.schema.services.devices.v1beta1.Activation.Request request = 1;</code>
     */
    public io.bloombox.schema.services.devices.v1beta1.Activation.Request getRequest() {
      return request_ == null ? io.bloombox.schema.services.devices.v1beta1.Activation.Request.getDefaultInstance() : request_;
    }
    /**
     * <pre>
     * Request to activate a device.
     * </pre>
     *
     * <code>.bloombox.schema.services.devices.v1beta1.Activation.Request request = 1;</code>
     */
    public io.bloombox.schema.services.devices.v1beta1.Activation.RequestOrBuilder getRequestOrBuilder() {
      return getRequest();
    }

    public static final int RESPONSE_FIELD_NUMBER = 2;
    private io.bloombox.schema.services.devices.v1beta1.Activation.Response response_;
    /**
     * <pre>
     * Response to a request to activate a device.
     * </pre>
     *
     * <code>.bloombox.schema.services.devices.v1beta1.Activation.Response response = 2;</code>
     */
    public boolean hasResponse() {
      return response_ != null;
    }
    /**
     * <pre>
     * Response to a request to activate a device.
     * </pre>
     *
     * <code>.bloombox.schema.services.devices.v1beta1.Activation.Response response = 2;</code>
     */
    public io.bloombox.schema.services.devices.v1beta1.Activation.Response getResponse() {
      return response_ == null ? io.bloombox.schema.services.devices.v1beta1.Activation.Response.getDefaultInstance() : response_;
    }
    /**
     * <pre>
     * Response to a request to activate a device.
     * </pre>
     *
     * <code>.bloombox.schema.services.devices.v1beta1.Activation.Response response = 2;</code>
     */
    public io.bloombox.schema.services.devices.v1beta1.Activation.ResponseOrBuilder getResponseOrBuilder() {
      return getResponse();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (request_ != null) {
        output.writeMessage(1, getRequest());
      }
      if (response_ != null) {
        output.writeMessage(2, getResponse());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (request_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getRequest());
      }
      if (response_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getResponse());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.devices.v1beta1.Activation.Operation)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.devices.v1beta1.Activation.Operation other = (io.bloombox.schema.services.devices.v1beta1.Activation.Operation) obj;

      boolean result = true;
      result = result && (hasRequest() == other.hasRequest());
      if (hasRequest()) {
        result = result && getRequest()
            .equals(other.getRequest());
      }
      result = result && (hasResponse() == other.hasResponse());
      if (hasResponse()) {
        result = result && getResponse()
            .equals(other.getResponse());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasRequest()) {
        hash = (37 * hash) + REQUEST_FIELD_NUMBER;
        hash = (53 * hash) + getRequest().hashCode();
      }
      if (hasResponse()) {
        hash = (37 * hash) + RESPONSE_FIELD_NUMBER;
        hash = (53 * hash) + getResponse().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.devices.v1beta1.Activation.Operation parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.devices.v1beta1.Activation.Operation parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.devices.v1beta1.Activation.Operation parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.devices.v1beta1.Activation.Operation parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.devices.v1beta1.Activation.Operation parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.devices.v1beta1.Activation.Operation parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.devices.v1beta1.Activation.Operation parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.devices.v1beta1.Activation.Operation parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.devices.v1beta1.Activation.Operation parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.devices.v1beta1.Activation.Operation parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.devices.v1beta1.Activation.Operation parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.devices.v1beta1.Activation.Operation parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.devices.v1beta1.Activation.Operation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies a device activation operation, consisting of one request and one response.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.devices.v1beta1.Activation.Operation}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.devices.v1beta1.Activation.Operation)
        io.bloombox.schema.services.devices.v1beta1.Activation.OperationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.devices.v1beta1.DevicesServiceBeta1.internal_static_bloombox_schema_services_devices_v1beta1_Activation_Operation_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.devices.v1beta1.DevicesServiceBeta1.internal_static_bloombox_schema_services_devices_v1beta1_Activation_Operation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.devices.v1beta1.Activation.Operation.class, io.bloombox.schema.services.devices.v1beta1.Activation.Operation.Builder.class);
      }

      // Construct using io.bloombox.schema.services.devices.v1beta1.Activation.Operation.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        if (requestBuilder_ == null) {
          request_ = null;
        } else {
          request_ = null;
          requestBuilder_ = null;
        }
        if (responseBuilder_ == null) {
          response_ = null;
        } else {
          response_ = null;
          responseBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.devices.v1beta1.DevicesServiceBeta1.internal_static_bloombox_schema_services_devices_v1beta1_Activation_Operation_descriptor;
      }

      public io.bloombox.schema.services.devices.v1beta1.Activation.Operation getDefaultInstanceForType() {
        return io.bloombox.schema.services.devices.v1beta1.Activation.Operation.getDefaultInstance();
      }

      public io.bloombox.schema.services.devices.v1beta1.Activation.Operation build() {
        io.bloombox.schema.services.devices.v1beta1.Activation.Operation result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.devices.v1beta1.Activation.Operation buildPartial() {
        io.bloombox.schema.services.devices.v1beta1.Activation.Operation result = new io.bloombox.schema.services.devices.v1beta1.Activation.Operation(this);
        if (requestBuilder_ == null) {
          result.request_ = request_;
        } else {
          result.request_ = requestBuilder_.build();
        }
        if (responseBuilder_ == null) {
          result.response_ = response_;
        } else {
          result.response_ = responseBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.devices.v1beta1.Activation.Operation) {
          return mergeFrom((io.bloombox.schema.services.devices.v1beta1.Activation.Operation)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.devices.v1beta1.Activation.Operation other) {
        if (other == io.bloombox.schema.services.devices.v1beta1.Activation.Operation.getDefaultInstance()) return this;
        if (other.hasRequest()) {
          mergeRequest(other.getRequest());
        }
        if (other.hasResponse()) {
          mergeResponse(other.getResponse());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.devices.v1beta1.Activation.Operation parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.devices.v1beta1.Activation.Operation) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private io.bloombox.schema.services.devices.v1beta1.Activation.Request request_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.services.devices.v1beta1.Activation.Request, io.bloombox.schema.services.devices.v1beta1.Activation.Request.Builder, io.bloombox.schema.services.devices.v1beta1.Activation.RequestOrBuilder> requestBuilder_;
      /**
       * <pre>
       * Request to activate a device.
       * </pre>
       *
       * <code>.bloombox.schema.services.devices.v1beta1.Activation.Request request = 1;</code>
       */
      public boolean hasRequest() {
        return requestBuilder_ != null || request_ != null;
      }
      /**
       * <pre>
       * Request to activate a device.
       * </pre>
       *
       * <code>.bloombox.schema.services.devices.v1beta1.Activation.Request request = 1;</code>
       */
      public io.bloombox.schema.services.devices.v1beta1.Activation.Request getRequest() {
        if (requestBuilder_ == null) {
          return request_ == null ? io.bloombox.schema.services.devices.v1beta1.Activation.Request.getDefaultInstance() : request_;
        } else {
          return requestBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Request to activate a device.
       * </pre>
       *
       * <code>.bloombox.schema.services.devices.v1beta1.Activation.Request request = 1;</code>
       */
      public Builder setRequest(io.bloombox.schema.services.devices.v1beta1.Activation.Request value) {
        if (requestBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          request_ = value;
          onChanged();
        } else {
          requestBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Request to activate a device.
       * </pre>
       *
       * <code>.bloombox.schema.services.devices.v1beta1.Activation.Request request = 1;</code>
       */
      public Builder setRequest(
          io.bloombox.schema.services.devices.v1beta1.Activation.Request.Builder builderForValue) {
        if (requestBuilder_ == null) {
          request_ = builderForValue.build();
          onChanged();
        } else {
          requestBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Request to activate a device.
       * </pre>
       *
       * <code>.bloombox.schema.services.devices.v1beta1.Activation.Request request = 1;</code>
       */
      public Builder mergeRequest(io.bloombox.schema.services.devices.v1beta1.Activation.Request value) {
        if (requestBuilder_ == null) {
          if (request_ != null) {
            request_ =
              io.bloombox.schema.services.devices.v1beta1.Activation.Request.newBuilder(request_).mergeFrom(value).buildPartial();
          } else {
            request_ = value;
          }
          onChanged();
        } else {
          requestBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Request to activate a device.
       * </pre>
       *
       * <code>.bloombox.schema.services.devices.v1beta1.Activation.Request request = 1;</code>
       */
      public Builder clearRequest() {
        if (requestBuilder_ == null) {
          request_ = null;
          onChanged();
        } else {
          request_ = null;
          requestBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Request to activate a device.
       * </pre>
       *
       * <code>.bloombox.schema.services.devices.v1beta1.Activation.Request request = 1;</code>
       */
      public io.bloombox.schema.services.devices.v1beta1.Activation.Request.Builder getRequestBuilder() {
        
        onChanged();
        return getRequestFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Request to activate a device.
       * </pre>
       *
       * <code>.bloombox.schema.services.devices.v1beta1.Activation.Request request = 1;</code>
       */
      public io.bloombox.schema.services.devices.v1beta1.Activation.RequestOrBuilder getRequestOrBuilder() {
        if (requestBuilder_ != null) {
          return requestBuilder_.getMessageOrBuilder();
        } else {
          return request_ == null ?
              io.bloombox.schema.services.devices.v1beta1.Activation.Request.getDefaultInstance() : request_;
        }
      }
      /**
       * <pre>
       * Request to activate a device.
       * </pre>
       *
       * <code>.bloombox.schema.services.devices.v1beta1.Activation.Request request = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.services.devices.v1beta1.Activation.Request, io.bloombox.schema.services.devices.v1beta1.Activation.Request.Builder, io.bloombox.schema.services.devices.v1beta1.Activation.RequestOrBuilder> 
          getRequestFieldBuilder() {
        if (requestBuilder_ == null) {
          requestBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.services.devices.v1beta1.Activation.Request, io.bloombox.schema.services.devices.v1beta1.Activation.Request.Builder, io.bloombox.schema.services.devices.v1beta1.Activation.RequestOrBuilder>(
                  getRequest(),
                  getParentForChildren(),
                  isClean());
          request_ = null;
        }
        return requestBuilder_;
      }

      private io.bloombox.schema.services.devices.v1beta1.Activation.Response response_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.services.devices.v1beta1.Activation.Response, io.bloombox.schema.services.devices.v1beta1.Activation.Response.Builder, io.bloombox.schema.services.devices.v1beta1.Activation.ResponseOrBuilder> responseBuilder_;
      /**
       * <pre>
       * Response to a request to activate a device.
       * </pre>
       *
       * <code>.bloombox.schema.services.devices.v1beta1.Activation.Response response = 2;</code>
       */
      public boolean hasResponse() {
        return responseBuilder_ != null || response_ != null;
      }
      /**
       * <pre>
       * Response to a request to activate a device.
       * </pre>
       *
       * <code>.bloombox.schema.services.devices.v1beta1.Activation.Response response = 2;</code>
       */
      public io.bloombox.schema.services.devices.v1beta1.Activation.Response getResponse() {
        if (responseBuilder_ == null) {
          return response_ == null ? io.bloombox.schema.services.devices.v1beta1.Activation.Response.getDefaultInstance() : response_;
        } else {
          return responseBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Response to a request to activate a device.
       * </pre>
       *
       * <code>.bloombox.schema.services.devices.v1beta1.Activation.Response response = 2;</code>
       */
      public Builder setResponse(io.bloombox.schema.services.devices.v1beta1.Activation.Response value) {
        if (responseBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          response_ = value;
          onChanged();
        } else {
          responseBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Response to a request to activate a device.
       * </pre>
       *
       * <code>.bloombox.schema.services.devices.v1beta1.Activation.Response response = 2;</code>
       */
      public Builder setResponse(
          io.bloombox.schema.services.devices.v1beta1.Activation.Response.Builder builderForValue) {
        if (responseBuilder_ == null) {
          response_ = builderForValue.build();
          onChanged();
        } else {
          responseBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Response to a request to activate a device.
       * </pre>
       *
       * <code>.bloombox.schema.services.devices.v1beta1.Activation.Response response = 2;</code>
       */
      public Builder mergeResponse(io.bloombox.schema.services.devices.v1beta1.Activation.Response value) {
        if (responseBuilder_ == null) {
          if (response_ != null) {
            response_ =
              io.bloombox.schema.services.devices.v1beta1.Activation.Response.newBuilder(response_).mergeFrom(value).buildPartial();
          } else {
            response_ = value;
          }
          onChanged();
        } else {
          responseBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Response to a request to activate a device.
       * </pre>
       *
       * <code>.bloombox.schema.services.devices.v1beta1.Activation.Response response = 2;</code>
       */
      public Builder clearResponse() {
        if (responseBuilder_ == null) {
          response_ = null;
          onChanged();
        } else {
          response_ = null;
          responseBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Response to a request to activate a device.
       * </pre>
       *
       * <code>.bloombox.schema.services.devices.v1beta1.Activation.Response response = 2;</code>
       */
      public io.bloombox.schema.services.devices.v1beta1.Activation.Response.Builder getResponseBuilder() {
        
        onChanged();
        return getResponseFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Response to a request to activate a device.
       * </pre>
       *
       * <code>.bloombox.schema.services.devices.v1beta1.Activation.Response response = 2;</code>
       */
      public io.bloombox.schema.services.devices.v1beta1.Activation.ResponseOrBuilder getResponseOrBuilder() {
        if (responseBuilder_ != null) {
          return responseBuilder_.getMessageOrBuilder();
        } else {
          return response_ == null ?
              io.bloombox.schema.services.devices.v1beta1.Activation.Response.getDefaultInstance() : response_;
        }
      }
      /**
       * <pre>
       * Response to a request to activate a device.
       * </pre>
       *
       * <code>.bloombox.schema.services.devices.v1beta1.Activation.Response response = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.services.devices.v1beta1.Activation.Response, io.bloombox.schema.services.devices.v1beta1.Activation.Response.Builder, io.bloombox.schema.services.devices.v1beta1.Activation.ResponseOrBuilder> 
          getResponseFieldBuilder() {
        if (responseBuilder_ == null) {
          responseBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.services.devices.v1beta1.Activation.Response, io.bloombox.schema.services.devices.v1beta1.Activation.Response.Builder, io.bloombox.schema.services.devices.v1beta1.Activation.ResponseOrBuilder>(
                  getResponse(),
                  getParentForChildren(),
                  isClean());
          response_ = null;
        }
        return responseBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.devices.v1beta1.Activation.Operation)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.devices.v1beta1.Activation.Operation)
    private static final io.bloombox.schema.services.devices.v1beta1.Activation.Operation DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.devices.v1beta1.Activation.Operation();
    }

    public static io.bloombox.schema.services.devices.v1beta1.Activation.Operation getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Operation>
        PARSER = new com.google.protobuf.AbstractParser<Operation>() {
      public Operation parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Operation(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Operation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Operation> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.devices.v1beta1.Activation.Operation getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.services.devices.v1beta1.Activation)) {
      return super.equals(obj);
    }
    io.bloombox.schema.services.devices.v1beta1.Activation other = (io.bloombox.schema.services.devices.v1beta1.Activation) obj;

    boolean result = true;
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.services.devices.v1beta1.Activation parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.devices.v1beta1.Activation parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.devices.v1beta1.Activation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.devices.v1beta1.Activation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.devices.v1beta1.Activation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.devices.v1beta1.Activation parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.devices.v1beta1.Activation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.devices.v1beta1.Activation parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.devices.v1beta1.Activation parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.devices.v1beta1.Activation parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.devices.v1beta1.Activation parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.devices.v1beta1.Activation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.services.devices.v1beta1.Activation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies an RPC operation to activate a hardware device for use.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.devices.v1beta1.Activation}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.services.devices.v1beta1.Activation)
      io.bloombox.schema.services.devices.v1beta1.ActivationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.devices.v1beta1.DevicesServiceBeta1.internal_static_bloombox_schema_services_devices_v1beta1_Activation_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.devices.v1beta1.DevicesServiceBeta1.internal_static_bloombox_schema_services_devices_v1beta1_Activation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.devices.v1beta1.Activation.class, io.bloombox.schema.services.devices.v1beta1.Activation.Builder.class);
    }

    // Construct using io.bloombox.schema.services.devices.v1beta1.Activation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.services.devices.v1beta1.DevicesServiceBeta1.internal_static_bloombox_schema_services_devices_v1beta1_Activation_descriptor;
    }

    public io.bloombox.schema.services.devices.v1beta1.Activation getDefaultInstanceForType() {
      return io.bloombox.schema.services.devices.v1beta1.Activation.getDefaultInstance();
    }

    public io.bloombox.schema.services.devices.v1beta1.Activation build() {
      io.bloombox.schema.services.devices.v1beta1.Activation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.services.devices.v1beta1.Activation buildPartial() {
      io.bloombox.schema.services.devices.v1beta1.Activation result = new io.bloombox.schema.services.devices.v1beta1.Activation(this);
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.services.devices.v1beta1.Activation) {
        return mergeFrom((io.bloombox.schema.services.devices.v1beta1.Activation)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.services.devices.v1beta1.Activation other) {
      if (other == io.bloombox.schema.services.devices.v1beta1.Activation.getDefaultInstance()) return this;
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.services.devices.v1beta1.Activation parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.services.devices.v1beta1.Activation) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.services.devices.v1beta1.Activation)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.services.devices.v1beta1.Activation)
  private static final io.bloombox.schema.services.devices.v1beta1.Activation DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.services.devices.v1beta1.Activation();
  }

  public static io.bloombox.schema.services.devices.v1beta1.Activation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Activation>
      PARSER = new com.google.protobuf.AbstractParser<Activation>() {
    public Activation parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new Activation(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<Activation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Activation> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.services.devices.v1beta1.Activation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

