/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: marketing/v1beta1/MarketingService_Beta1.proto

package io.bloombox.schema.services.marketing.v1beta1;

/**
 * <pre>
 * Represents an RPC operation to create a new adgroup and attach it to a specific marketing campaign. An "ad group,"
 * in Bloombox, is a containing group of ad parameters. Individual ads are calculated from these parameters.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.AdGroupCreate}
 */
public  final class AdGroupCreate extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.services.marketing.v1beta1.AdGroupCreate)
    AdGroupCreateOrBuilder {
private static final long serialVersionUID = 0L;
  // Use AdGroupCreate.newBuilder() to construct.
  private AdGroupCreate(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private AdGroupCreate() {
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private AdGroupCreate(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupCreate_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupCreate_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.class, io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Builder.class);
  }

  public interface RequestOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * ID for the campaign.
     * </pre>
     *
     * <code>string campaign_id = 1;</code>
     */
    java.lang.String getCampaignId();
    /**
     * <pre>
     * ID for the campaign.
     * </pre>
     *
     * <code>string campaign_id = 1;</code>
     */
    com.google.protobuf.ByteString
        getCampaignIdBytes();

    /**
     * <pre>
     * Marketing communication channel to employ.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.Channel channel = 2;</code>
     */
    int getChannelValue();
    /**
     * <pre>
     * Marketing communication channel to employ.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.Channel channel = 2;</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.Channel getChannel();

    /**
     * <pre>
     * Initial creative record to use.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.Creative creative = 3;</code>
     */
    boolean hasCreative();
    /**
     * <pre>
     * Initial creative record to use.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.Creative creative = 3;</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.Creative getCreative();
    /**
     * <pre>
     * Initial creative record to use.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.Creative creative = 3;</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.CreativeOrBuilder getCreativeOrBuilder();
  }
  /**
   * <pre>
   * Request to create a new adgroup and attach it to a specific campaign.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request}
   */
  public  static final class Request extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request)
      RequestOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Request.newBuilder() to construct.
    private Request(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Request() {
      campaignId_ = "";
      channel_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Request(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              campaignId_ = s;
              break;
            }
            case 16: {
              int rawValue = input.readEnum();

              channel_ = rawValue;
              break;
            }
            case 26: {
              io.bloombox.schema.marketing.MarketingCampaign.Creative.Builder subBuilder = null;
              if (creative_ != null) {
                subBuilder = creative_.toBuilder();
              }
              creative_ = input.readMessage(io.bloombox.schema.marketing.MarketingCampaign.Creative.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(creative_);
                creative_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupCreate_Request_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupCreate_Request_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request.class, io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request.Builder.class);
    }

    public static final int CAMPAIGN_ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object campaignId_;
    /**
     * <pre>
     * ID for the campaign.
     * </pre>
     *
     * <code>string campaign_id = 1;</code>
     */
    public java.lang.String getCampaignId() {
      java.lang.Object ref = campaignId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        campaignId_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * ID for the campaign.
     * </pre>
     *
     * <code>string campaign_id = 1;</code>
     */
    public com.google.protobuf.ByteString
        getCampaignIdBytes() {
      java.lang.Object ref = campaignId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        campaignId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CHANNEL_FIELD_NUMBER = 2;
    private int channel_;
    /**
     * <pre>
     * Marketing communication channel to employ.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.Channel channel = 2;</code>
     */
    public int getChannelValue() {
      return channel_;
    }
    /**
     * <pre>
     * Marketing communication channel to employ.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.Channel channel = 2;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.Channel getChannel() {
      io.bloombox.schema.marketing.MarketingCampaign.Channel result = io.bloombox.schema.marketing.MarketingCampaign.Channel.valueOf(channel_);
      return result == null ? io.bloombox.schema.marketing.MarketingCampaign.Channel.UNRECOGNIZED : result;
    }

    public static final int CREATIVE_FIELD_NUMBER = 3;
    private io.bloombox.schema.marketing.MarketingCampaign.Creative creative_;
    /**
     * <pre>
     * Initial creative record to use.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.Creative creative = 3;</code>
     */
    public boolean hasCreative() {
      return creative_ != null;
    }
    /**
     * <pre>
     * Initial creative record to use.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.Creative creative = 3;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.Creative getCreative() {
      return creative_ == null ? io.bloombox.schema.marketing.MarketingCampaign.Creative.getDefaultInstance() : creative_;
    }
    /**
     * <pre>
     * Initial creative record to use.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.Creative creative = 3;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.CreativeOrBuilder getCreativeOrBuilder() {
      return getCreative();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getCampaignIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, campaignId_);
      }
      if (channel_ != io.bloombox.schema.marketing.MarketingCampaign.Channel.UNSPECIFIED.getNumber()) {
        output.writeEnum(2, channel_);
      }
      if (creative_ != null) {
        output.writeMessage(3, getCreative());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getCampaignIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, campaignId_);
      }
      if (channel_ != io.bloombox.schema.marketing.MarketingCampaign.Channel.UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, channel_);
      }
      if (creative_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getCreative());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request other = (io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request) obj;

      boolean result = true;
      result = result && getCampaignId()
          .equals(other.getCampaignId());
      result = result && channel_ == other.channel_;
      result = result && (hasCreative() == other.hasCreative());
      if (hasCreative()) {
        result = result && getCreative()
            .equals(other.getCreative());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CAMPAIGN_ID_FIELD_NUMBER;
      hash = (53 * hash) + getCampaignId().hashCode();
      hash = (37 * hash) + CHANNEL_FIELD_NUMBER;
      hash = (53 * hash) + channel_;
      if (hasCreative()) {
        hash = (37 * hash) + CREATIVE_FIELD_NUMBER;
        hash = (53 * hash) + getCreative().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Request to create a new adgroup and attach it to a specific campaign.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request)
        io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.RequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupCreate_Request_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupCreate_Request_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request.class, io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request.Builder.class);
      }

      // Construct using io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        campaignId_ = "";

        channel_ = 0;

        if (creativeBuilder_ == null) {
          creative_ = null;
        } else {
          creative_ = null;
          creativeBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupCreate_Request_descriptor;
      }

      public io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request getDefaultInstanceForType() {
        return io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request.getDefaultInstance();
      }

      public io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request build() {
        io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request buildPartial() {
        io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request result = new io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request(this);
        result.campaignId_ = campaignId_;
        result.channel_ = channel_;
        if (creativeBuilder_ == null) {
          result.creative_ = creative_;
        } else {
          result.creative_ = creativeBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request) {
          return mergeFrom((io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request other) {
        if (other == io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request.getDefaultInstance()) return this;
        if (!other.getCampaignId().isEmpty()) {
          campaignId_ = other.campaignId_;
          onChanged();
        }
        if (other.channel_ != 0) {
          setChannelValue(other.getChannelValue());
        }
        if (other.hasCreative()) {
          mergeCreative(other.getCreative());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object campaignId_ = "";
      /**
       * <pre>
       * ID for the campaign.
       * </pre>
       *
       * <code>string campaign_id = 1;</code>
       */
      public java.lang.String getCampaignId() {
        java.lang.Object ref = campaignId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          campaignId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * ID for the campaign.
       * </pre>
       *
       * <code>string campaign_id = 1;</code>
       */
      public com.google.protobuf.ByteString
          getCampaignIdBytes() {
        java.lang.Object ref = campaignId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          campaignId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * ID for the campaign.
       * </pre>
       *
       * <code>string campaign_id = 1;</code>
       */
      public Builder setCampaignId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        campaignId_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * ID for the campaign.
       * </pre>
       *
       * <code>string campaign_id = 1;</code>
       */
      public Builder clearCampaignId() {
        
        campaignId_ = getDefaultInstance().getCampaignId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * ID for the campaign.
       * </pre>
       *
       * <code>string campaign_id = 1;</code>
       */
      public Builder setCampaignIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        campaignId_ = value;
        onChanged();
        return this;
      }

      private int channel_ = 0;
      /**
       * <pre>
       * Marketing communication channel to employ.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.Channel channel = 2;</code>
       */
      public int getChannelValue() {
        return channel_;
      }
      /**
       * <pre>
       * Marketing communication channel to employ.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.Channel channel = 2;</code>
       */
      public Builder setChannelValue(int value) {
        channel_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Marketing communication channel to employ.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.Channel channel = 2;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.Channel getChannel() {
        io.bloombox.schema.marketing.MarketingCampaign.Channel result = io.bloombox.schema.marketing.MarketingCampaign.Channel.valueOf(channel_);
        return result == null ? io.bloombox.schema.marketing.MarketingCampaign.Channel.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Marketing communication channel to employ.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.Channel channel = 2;</code>
       */
      public Builder setChannel(io.bloombox.schema.marketing.MarketingCampaign.Channel value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        channel_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Marketing communication channel to employ.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.Channel channel = 2;</code>
       */
      public Builder clearChannel() {
        
        channel_ = 0;
        onChanged();
        return this;
      }

      private io.bloombox.schema.marketing.MarketingCampaign.Creative creative_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.marketing.MarketingCampaign.Creative, io.bloombox.schema.marketing.MarketingCampaign.Creative.Builder, io.bloombox.schema.marketing.MarketingCampaign.CreativeOrBuilder> creativeBuilder_;
      /**
       * <pre>
       * Initial creative record to use.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.Creative creative = 3;</code>
       */
      public boolean hasCreative() {
        return creativeBuilder_ != null || creative_ != null;
      }
      /**
       * <pre>
       * Initial creative record to use.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.Creative creative = 3;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.Creative getCreative() {
        if (creativeBuilder_ == null) {
          return creative_ == null ? io.bloombox.schema.marketing.MarketingCampaign.Creative.getDefaultInstance() : creative_;
        } else {
          return creativeBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Initial creative record to use.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.Creative creative = 3;</code>
       */
      public Builder setCreative(io.bloombox.schema.marketing.MarketingCampaign.Creative value) {
        if (creativeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          creative_ = value;
          onChanged();
        } else {
          creativeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Initial creative record to use.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.Creative creative = 3;</code>
       */
      public Builder setCreative(
          io.bloombox.schema.marketing.MarketingCampaign.Creative.Builder builderForValue) {
        if (creativeBuilder_ == null) {
          creative_ = builderForValue.build();
          onChanged();
        } else {
          creativeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Initial creative record to use.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.Creative creative = 3;</code>
       */
      public Builder mergeCreative(io.bloombox.schema.marketing.MarketingCampaign.Creative value) {
        if (creativeBuilder_ == null) {
          if (creative_ != null) {
            creative_ =
              io.bloombox.schema.marketing.MarketingCampaign.Creative.newBuilder(creative_).mergeFrom(value).buildPartial();
          } else {
            creative_ = value;
          }
          onChanged();
        } else {
          creativeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Initial creative record to use.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.Creative creative = 3;</code>
       */
      public Builder clearCreative() {
        if (creativeBuilder_ == null) {
          creative_ = null;
          onChanged();
        } else {
          creative_ = null;
          creativeBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Initial creative record to use.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.Creative creative = 3;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.Creative.Builder getCreativeBuilder() {
        
        onChanged();
        return getCreativeFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Initial creative record to use.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.Creative creative = 3;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.CreativeOrBuilder getCreativeOrBuilder() {
        if (creativeBuilder_ != null) {
          return creativeBuilder_.getMessageOrBuilder();
        } else {
          return creative_ == null ?
              io.bloombox.schema.marketing.MarketingCampaign.Creative.getDefaultInstance() : creative_;
        }
      }
      /**
       * <pre>
       * Initial creative record to use.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.Creative creative = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.marketing.MarketingCampaign.Creative, io.bloombox.schema.marketing.MarketingCampaign.Creative.Builder, io.bloombox.schema.marketing.MarketingCampaign.CreativeOrBuilder> 
          getCreativeFieldBuilder() {
        if (creativeBuilder_ == null) {
          creativeBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.marketing.MarketingCampaign.Creative, io.bloombox.schema.marketing.MarketingCampaign.Creative.Builder, io.bloombox.schema.marketing.MarketingCampaign.CreativeOrBuilder>(
                  getCreative(),
                  getParentForChildren(),
                  isClean());
          creative_ = null;
        }
        return creativeBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request)
    private static final io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request();
    }

    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Request>
        PARSER = new com.google.protobuf.AbstractParser<Request>() {
      public Request parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Request(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Request> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Request> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Request getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ResponseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Resulting adgroup ID.
     * </pre>
     *
     * <code>string adgroup_id = 1;</code>
     */
    java.lang.String getAdgroupId();
    /**
     * <pre>
     * Resulting adgroup ID.
     * </pre>
     *
     * <code>string adgroup_id = 1;</code>
     */
    com.google.protobuf.ByteString
        getAdgroupIdBytes();
  }
  /**
   * <pre>
   * Response to a request to create a new adgroup and attach it to a specific campaign.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response}
   */
  public  static final class Response extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response)
      ResponseOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Response.newBuilder() to construct.
    private Response(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Response() {
      adgroupId_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Response(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              adgroupId_ = s;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupCreate_Response_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupCreate_Response_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response.class, io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response.Builder.class);
    }

    public static final int ADGROUP_ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object adgroupId_;
    /**
     * <pre>
     * Resulting adgroup ID.
     * </pre>
     *
     * <code>string adgroup_id = 1;</code>
     */
    public java.lang.String getAdgroupId() {
      java.lang.Object ref = adgroupId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        adgroupId_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Resulting adgroup ID.
     * </pre>
     *
     * <code>string adgroup_id = 1;</code>
     */
    public com.google.protobuf.ByteString
        getAdgroupIdBytes() {
      java.lang.Object ref = adgroupId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        adgroupId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getAdgroupIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, adgroupId_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getAdgroupIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, adgroupId_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response other = (io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response) obj;

      boolean result = true;
      result = result && getAdgroupId()
          .equals(other.getAdgroupId());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ADGROUP_ID_FIELD_NUMBER;
      hash = (53 * hash) + getAdgroupId().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Response to a request to create a new adgroup and attach it to a specific campaign.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response)
        io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.ResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupCreate_Response_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupCreate_Response_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response.class, io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response.Builder.class);
      }

      // Construct using io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        adgroupId_ = "";

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupCreate_Response_descriptor;
      }

      public io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response getDefaultInstanceForType() {
        return io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response.getDefaultInstance();
      }

      public io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response build() {
        io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response buildPartial() {
        io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response result = new io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response(this);
        result.adgroupId_ = adgroupId_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response) {
          return mergeFrom((io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response other) {
        if (other == io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response.getDefaultInstance()) return this;
        if (!other.getAdgroupId().isEmpty()) {
          adgroupId_ = other.adgroupId_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object adgroupId_ = "";
      /**
       * <pre>
       * Resulting adgroup ID.
       * </pre>
       *
       * <code>string adgroup_id = 1;</code>
       */
      public java.lang.String getAdgroupId() {
        java.lang.Object ref = adgroupId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          adgroupId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Resulting adgroup ID.
       * </pre>
       *
       * <code>string adgroup_id = 1;</code>
       */
      public com.google.protobuf.ByteString
          getAdgroupIdBytes() {
        java.lang.Object ref = adgroupId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          adgroupId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Resulting adgroup ID.
       * </pre>
       *
       * <code>string adgroup_id = 1;</code>
       */
      public Builder setAdgroupId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        adgroupId_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Resulting adgroup ID.
       * </pre>
       *
       * <code>string adgroup_id = 1;</code>
       */
      public Builder clearAdgroupId() {
        
        adgroupId_ = getDefaultInstance().getAdgroupId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Resulting adgroup ID.
       * </pre>
       *
       * <code>string adgroup_id = 1;</code>
       */
      public Builder setAdgroupIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        adgroupId_ = value;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response)
    private static final io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response();
    }

    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Response>
        PARSER = new com.google.protobuf.AbstractParser<Response>() {
      public Response parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Response(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Response> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Response> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Response getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate)) {
      return super.equals(obj);
    }
    io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate other = (io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate) obj;

    boolean result = true;
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Represents an RPC operation to create a new adgroup and attach it to a specific marketing campaign. An "ad group,"
   * in Bloombox, is a containing group of ad parameters. Individual ads are calculated from these parameters.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.AdGroupCreate}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.services.marketing.v1beta1.AdGroupCreate)
      io.bloombox.schema.services.marketing.v1beta1.AdGroupCreateOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupCreate_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupCreate_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.class, io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.Builder.class);
    }

    // Construct using io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupCreate_descriptor;
    }

    public io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate getDefaultInstanceForType() {
      return io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.getDefaultInstance();
    }

    public io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate build() {
      io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate buildPartial() {
      io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate result = new io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate(this);
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate) {
        return mergeFrom((io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate other) {
      if (other == io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate.getDefaultInstance()) return this;
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.services.marketing.v1beta1.AdGroupCreate)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.services.marketing.v1beta1.AdGroupCreate)
  private static final io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate();
  }

  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AdGroupCreate>
      PARSER = new com.google.protobuf.AbstractParser<AdGroupCreate>() {
    public AdGroupCreate parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new AdGroupCreate(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<AdGroupCreate> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AdGroupCreate> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.services.marketing.v1beta1.AdGroupCreate getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

