/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: marketing/v1beta1/MarketingService_Beta1.proto

package io.bloombox.schema.services.marketing.v1beta1;

/**
 * <pre>
 * Represents an RPC operation to retrieve an individual adgroup, addressed by its ID, under a specific marketing
 * campaign, also addressed by its ID.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.AdGroupGet}
 */
public  final class AdGroupGet extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.services.marketing.v1beta1.AdGroupGet)
    AdGroupGetOrBuilder {
private static final long serialVersionUID = 0L;
  // Use AdGroupGet.newBuilder() to construct.
  private AdGroupGet(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private AdGroupGet() {
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private AdGroupGet(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupGet_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupGet_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.class, io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Builder.class);
  }

  public interface RequestOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * ID for the campaign.
     * </pre>
     *
     * <code>string campaign_id = 1;</code>
     */
    java.lang.String getCampaignId();
    /**
     * <pre>
     * ID for the campaign.
     * </pre>
     *
     * <code>string campaign_id = 1;</code>
     */
    com.google.protobuf.ByteString
        getCampaignIdBytes();

    /**
     * <pre>
     * Adgroup ID to fetch.
     * </pre>
     *
     * <code>string adgroup_id = 2;</code>
     */
    java.lang.String getAdgroupId();
    /**
     * <pre>
     * Adgroup ID to fetch.
     * </pre>
     *
     * <code>string adgroup_id = 2;</code>
     */
    com.google.protobuf.ByteString
        getAdgroupIdBytes();
  }
  /**
   * <pre>
   * Request to retrieve a particular adgroup's data.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request}
   */
  public  static final class Request extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request)
      RequestOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Request.newBuilder() to construct.
    private Request(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Request() {
      campaignId_ = "";
      adgroupId_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Request(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              campaignId_ = s;
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();

              adgroupId_ = s;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupGet_Request_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupGet_Request_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request.class, io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request.Builder.class);
    }

    public static final int CAMPAIGN_ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object campaignId_;
    /**
     * <pre>
     * ID for the campaign.
     * </pre>
     *
     * <code>string campaign_id = 1;</code>
     */
    public java.lang.String getCampaignId() {
      java.lang.Object ref = campaignId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        campaignId_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * ID for the campaign.
     * </pre>
     *
     * <code>string campaign_id = 1;</code>
     */
    public com.google.protobuf.ByteString
        getCampaignIdBytes() {
      java.lang.Object ref = campaignId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        campaignId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ADGROUP_ID_FIELD_NUMBER = 2;
    private volatile java.lang.Object adgroupId_;
    /**
     * <pre>
     * Adgroup ID to fetch.
     * </pre>
     *
     * <code>string adgroup_id = 2;</code>
     */
    public java.lang.String getAdgroupId() {
      java.lang.Object ref = adgroupId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        adgroupId_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Adgroup ID to fetch.
     * </pre>
     *
     * <code>string adgroup_id = 2;</code>
     */
    public com.google.protobuf.ByteString
        getAdgroupIdBytes() {
      java.lang.Object ref = adgroupId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        adgroupId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getCampaignIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, campaignId_);
      }
      if (!getAdgroupIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, adgroupId_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getCampaignIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, campaignId_);
      }
      if (!getAdgroupIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, adgroupId_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request other = (io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request) obj;

      boolean result = true;
      result = result && getCampaignId()
          .equals(other.getCampaignId());
      result = result && getAdgroupId()
          .equals(other.getAdgroupId());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CAMPAIGN_ID_FIELD_NUMBER;
      hash = (53 * hash) + getCampaignId().hashCode();
      hash = (37 * hash) + ADGROUP_ID_FIELD_NUMBER;
      hash = (53 * hash) + getAdgroupId().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Request to retrieve a particular adgroup's data.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request)
        io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.RequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupGet_Request_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupGet_Request_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request.class, io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request.Builder.class);
      }

      // Construct using io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        campaignId_ = "";

        adgroupId_ = "";

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupGet_Request_descriptor;
      }

      public io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request getDefaultInstanceForType() {
        return io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request.getDefaultInstance();
      }

      public io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request build() {
        io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request buildPartial() {
        io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request result = new io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request(this);
        result.campaignId_ = campaignId_;
        result.adgroupId_ = adgroupId_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request) {
          return mergeFrom((io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request other) {
        if (other == io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request.getDefaultInstance()) return this;
        if (!other.getCampaignId().isEmpty()) {
          campaignId_ = other.campaignId_;
          onChanged();
        }
        if (!other.getAdgroupId().isEmpty()) {
          adgroupId_ = other.adgroupId_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object campaignId_ = "";
      /**
       * <pre>
       * ID for the campaign.
       * </pre>
       *
       * <code>string campaign_id = 1;</code>
       */
      public java.lang.String getCampaignId() {
        java.lang.Object ref = campaignId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          campaignId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * ID for the campaign.
       * </pre>
       *
       * <code>string campaign_id = 1;</code>
       */
      public com.google.protobuf.ByteString
          getCampaignIdBytes() {
        java.lang.Object ref = campaignId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          campaignId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * ID for the campaign.
       * </pre>
       *
       * <code>string campaign_id = 1;</code>
       */
      public Builder setCampaignId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        campaignId_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * ID for the campaign.
       * </pre>
       *
       * <code>string campaign_id = 1;</code>
       */
      public Builder clearCampaignId() {
        
        campaignId_ = getDefaultInstance().getCampaignId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * ID for the campaign.
       * </pre>
       *
       * <code>string campaign_id = 1;</code>
       */
      public Builder setCampaignIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        campaignId_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object adgroupId_ = "";
      /**
       * <pre>
       * Adgroup ID to fetch.
       * </pre>
       *
       * <code>string adgroup_id = 2;</code>
       */
      public java.lang.String getAdgroupId() {
        java.lang.Object ref = adgroupId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          adgroupId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Adgroup ID to fetch.
       * </pre>
       *
       * <code>string adgroup_id = 2;</code>
       */
      public com.google.protobuf.ByteString
          getAdgroupIdBytes() {
        java.lang.Object ref = adgroupId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          adgroupId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Adgroup ID to fetch.
       * </pre>
       *
       * <code>string adgroup_id = 2;</code>
       */
      public Builder setAdgroupId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        adgroupId_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Adgroup ID to fetch.
       * </pre>
       *
       * <code>string adgroup_id = 2;</code>
       */
      public Builder clearAdgroupId() {
        
        adgroupId_ = getDefaultInstance().getAdgroupId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Adgroup ID to fetch.
       * </pre>
       *
       * <code>string adgroup_id = 2;</code>
       */
      public Builder setAdgroupIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        adgroupId_ = value;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request)
    private static final io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request();
    }

    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Request>
        PARSER = new com.google.protobuf.AbstractParser<Request>() {
      public Request parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Request(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Request> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Request> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Request getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ResponseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Resulting adgroup, if it could be located.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.AdGroup adgroup = 1;</code>
     */
    boolean hasAdgroup();
    /**
     * <pre>
     * Resulting adgroup, if it could be located.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.AdGroup adgroup = 1;</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.AdGroup getAdgroup();
    /**
     * <pre>
     * Resulting adgroup, if it could be located.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.AdGroup adgroup = 1;</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.AdGroupOrBuilder getAdgroupOrBuilder();
  }
  /**
   * <pre>
   * Response to a request to retrieve a particular adgroup's data.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response}
   */
  public  static final class Response extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response)
      ResponseOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Response.newBuilder() to construct.
    private Response(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Response() {
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Response(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              io.bloombox.schema.marketing.MarketingCampaign.AdGroup.Builder subBuilder = null;
              if (adgroup_ != null) {
                subBuilder = adgroup_.toBuilder();
              }
              adgroup_ = input.readMessage(io.bloombox.schema.marketing.MarketingCampaign.AdGroup.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(adgroup_);
                adgroup_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupGet_Response_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupGet_Response_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response.class, io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response.Builder.class);
    }

    public static final int ADGROUP_FIELD_NUMBER = 1;
    private io.bloombox.schema.marketing.MarketingCampaign.AdGroup adgroup_;
    /**
     * <pre>
     * Resulting adgroup, if it could be located.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.AdGroup adgroup = 1;</code>
     */
    public boolean hasAdgroup() {
      return adgroup_ != null;
    }
    /**
     * <pre>
     * Resulting adgroup, if it could be located.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.AdGroup adgroup = 1;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.AdGroup getAdgroup() {
      return adgroup_ == null ? io.bloombox.schema.marketing.MarketingCampaign.AdGroup.getDefaultInstance() : adgroup_;
    }
    /**
     * <pre>
     * Resulting adgroup, if it could be located.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.AdGroup adgroup = 1;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.AdGroupOrBuilder getAdgroupOrBuilder() {
      return getAdgroup();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (adgroup_ != null) {
        output.writeMessage(1, getAdgroup());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (adgroup_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getAdgroup());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response other = (io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response) obj;

      boolean result = true;
      result = result && (hasAdgroup() == other.hasAdgroup());
      if (hasAdgroup()) {
        result = result && getAdgroup()
            .equals(other.getAdgroup());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasAdgroup()) {
        hash = (37 * hash) + ADGROUP_FIELD_NUMBER;
        hash = (53 * hash) + getAdgroup().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Response to a request to retrieve a particular adgroup's data.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response)
        io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.ResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupGet_Response_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupGet_Response_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response.class, io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response.Builder.class);
      }

      // Construct using io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        if (adgroupBuilder_ == null) {
          adgroup_ = null;
        } else {
          adgroup_ = null;
          adgroupBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupGet_Response_descriptor;
      }

      public io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response getDefaultInstanceForType() {
        return io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response.getDefaultInstance();
      }

      public io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response build() {
        io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response buildPartial() {
        io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response result = new io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response(this);
        if (adgroupBuilder_ == null) {
          result.adgroup_ = adgroup_;
        } else {
          result.adgroup_ = adgroupBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response) {
          return mergeFrom((io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response other) {
        if (other == io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response.getDefaultInstance()) return this;
        if (other.hasAdgroup()) {
          mergeAdgroup(other.getAdgroup());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private io.bloombox.schema.marketing.MarketingCampaign.AdGroup adgroup_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.marketing.MarketingCampaign.AdGroup, io.bloombox.schema.marketing.MarketingCampaign.AdGroup.Builder, io.bloombox.schema.marketing.MarketingCampaign.AdGroupOrBuilder> adgroupBuilder_;
      /**
       * <pre>
       * Resulting adgroup, if it could be located.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.AdGroup adgroup = 1;</code>
       */
      public boolean hasAdgroup() {
        return adgroupBuilder_ != null || adgroup_ != null;
      }
      /**
       * <pre>
       * Resulting adgroup, if it could be located.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.AdGroup adgroup = 1;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.AdGroup getAdgroup() {
        if (adgroupBuilder_ == null) {
          return adgroup_ == null ? io.bloombox.schema.marketing.MarketingCampaign.AdGroup.getDefaultInstance() : adgroup_;
        } else {
          return adgroupBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Resulting adgroup, if it could be located.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.AdGroup adgroup = 1;</code>
       */
      public Builder setAdgroup(io.bloombox.schema.marketing.MarketingCampaign.AdGroup value) {
        if (adgroupBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          adgroup_ = value;
          onChanged();
        } else {
          adgroupBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Resulting adgroup, if it could be located.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.AdGroup adgroup = 1;</code>
       */
      public Builder setAdgroup(
          io.bloombox.schema.marketing.MarketingCampaign.AdGroup.Builder builderForValue) {
        if (adgroupBuilder_ == null) {
          adgroup_ = builderForValue.build();
          onChanged();
        } else {
          adgroupBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Resulting adgroup, if it could be located.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.AdGroup adgroup = 1;</code>
       */
      public Builder mergeAdgroup(io.bloombox.schema.marketing.MarketingCampaign.AdGroup value) {
        if (adgroupBuilder_ == null) {
          if (adgroup_ != null) {
            adgroup_ =
              io.bloombox.schema.marketing.MarketingCampaign.AdGroup.newBuilder(adgroup_).mergeFrom(value).buildPartial();
          } else {
            adgroup_ = value;
          }
          onChanged();
        } else {
          adgroupBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Resulting adgroup, if it could be located.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.AdGroup adgroup = 1;</code>
       */
      public Builder clearAdgroup() {
        if (adgroupBuilder_ == null) {
          adgroup_ = null;
          onChanged();
        } else {
          adgroup_ = null;
          adgroupBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Resulting adgroup, if it could be located.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.AdGroup adgroup = 1;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.AdGroup.Builder getAdgroupBuilder() {
        
        onChanged();
        return getAdgroupFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Resulting adgroup, if it could be located.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.AdGroup adgroup = 1;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.AdGroupOrBuilder getAdgroupOrBuilder() {
        if (adgroupBuilder_ != null) {
          return adgroupBuilder_.getMessageOrBuilder();
        } else {
          return adgroup_ == null ?
              io.bloombox.schema.marketing.MarketingCampaign.AdGroup.getDefaultInstance() : adgroup_;
        }
      }
      /**
       * <pre>
       * Resulting adgroup, if it could be located.
       * </pre>
       *
       * <code>.bloombox.schema.marketing.AdGroup adgroup = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.marketing.MarketingCampaign.AdGroup, io.bloombox.schema.marketing.MarketingCampaign.AdGroup.Builder, io.bloombox.schema.marketing.MarketingCampaign.AdGroupOrBuilder> 
          getAdgroupFieldBuilder() {
        if (adgroupBuilder_ == null) {
          adgroupBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.marketing.MarketingCampaign.AdGroup, io.bloombox.schema.marketing.MarketingCampaign.AdGroup.Builder, io.bloombox.schema.marketing.MarketingCampaign.AdGroupOrBuilder>(
                  getAdgroup(),
                  getParentForChildren(),
                  isClean());
          adgroup_ = null;
        }
        return adgroupBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response)
    private static final io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response();
    }

    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Response>
        PARSER = new com.google.protobuf.AbstractParser<Response>() {
      public Response parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Response(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Response> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Response> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Response getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.services.marketing.v1beta1.AdGroupGet)) {
      return super.equals(obj);
    }
    io.bloombox.schema.services.marketing.v1beta1.AdGroupGet other = (io.bloombox.schema.services.marketing.v1beta1.AdGroupGet) obj;

    boolean result = true;
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.services.marketing.v1beta1.AdGroupGet prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Represents an RPC operation to retrieve an individual adgroup, addressed by its ID, under a specific marketing
   * campaign, also addressed by its ID.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.AdGroupGet}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.services.marketing.v1beta1.AdGroupGet)
      io.bloombox.schema.services.marketing.v1beta1.AdGroupGetOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupGet_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupGet_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.class, io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.Builder.class);
    }

    // Construct using io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupGet_descriptor;
    }

    public io.bloombox.schema.services.marketing.v1beta1.AdGroupGet getDefaultInstanceForType() {
      return io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.getDefaultInstance();
    }

    public io.bloombox.schema.services.marketing.v1beta1.AdGroupGet build() {
      io.bloombox.schema.services.marketing.v1beta1.AdGroupGet result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.services.marketing.v1beta1.AdGroupGet buildPartial() {
      io.bloombox.schema.services.marketing.v1beta1.AdGroupGet result = new io.bloombox.schema.services.marketing.v1beta1.AdGroupGet(this);
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.services.marketing.v1beta1.AdGroupGet) {
        return mergeFrom((io.bloombox.schema.services.marketing.v1beta1.AdGroupGet)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.services.marketing.v1beta1.AdGroupGet other) {
      if (other == io.bloombox.schema.services.marketing.v1beta1.AdGroupGet.getDefaultInstance()) return this;
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.services.marketing.v1beta1.AdGroupGet parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.services.marketing.v1beta1.AdGroupGet) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.services.marketing.v1beta1.AdGroupGet)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.services.marketing.v1beta1.AdGroupGet)
  private static final io.bloombox.schema.services.marketing.v1beta1.AdGroupGet DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.services.marketing.v1beta1.AdGroupGet();
  }

  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupGet getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AdGroupGet>
      PARSER = new com.google.protobuf.AbstractParser<AdGroupGet>() {
    public AdGroupGet parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new AdGroupGet(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<AdGroupGet> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AdGroupGet> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.services.marketing.v1beta1.AdGroupGet getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

