/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: marketing/v1beta1/MarketingService_Beta1.proto

package io.bloombox.schema.services.marketing.v1beta1;

/**
 * <pre>
 * Represents an RPC operation to list groups of ad parameters for a given marketing campaign.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.AdGroupList}
 */
public  final class AdGroupList extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.services.marketing.v1beta1.AdGroupList)
    AdGroupListOrBuilder {
private static final long serialVersionUID = 0L;
  // Use AdGroupList.newBuilder() to construct.
  private AdGroupList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private AdGroupList() {
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private AdGroupList(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupList_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupList_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.services.marketing.v1beta1.AdGroupList.class, io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Builder.class);
  }

  public interface RequestOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.marketing.v1beta1.AdGroupList.Request)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * ID of the campaign to send.
     * </pre>
     *
     * <code>string campaign_id = 1;</code>
     */
    java.lang.String getCampaignId();
    /**
     * <pre>
     * ID of the campaign to send.
     * </pre>
     *
     * <code>string campaign_id = 1;</code>
     */
    com.google.protobuf.ByteString
        getCampaignIdBytes();
  }
  /**
   * <pre>
   * Request to list adgroups for a specific campaign.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.AdGroupList.Request}
   */
  public  static final class Request extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.marketing.v1beta1.AdGroupList.Request)
      RequestOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Request.newBuilder() to construct.
    private Request(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Request() {
      campaignId_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Request(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              campaignId_ = s;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupList_Request_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupList_Request_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request.class, io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request.Builder.class);
    }

    public static final int CAMPAIGN_ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object campaignId_;
    /**
     * <pre>
     * ID of the campaign to send.
     * </pre>
     *
     * <code>string campaign_id = 1;</code>
     */
    public java.lang.String getCampaignId() {
      java.lang.Object ref = campaignId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        campaignId_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * ID of the campaign to send.
     * </pre>
     *
     * <code>string campaign_id = 1;</code>
     */
    public com.google.protobuf.ByteString
        getCampaignIdBytes() {
      java.lang.Object ref = campaignId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        campaignId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getCampaignIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, campaignId_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getCampaignIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, campaignId_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request other = (io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request) obj;

      boolean result = true;
      result = result && getCampaignId()
          .equals(other.getCampaignId());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CAMPAIGN_ID_FIELD_NUMBER;
      hash = (53 * hash) + getCampaignId().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Request to list adgroups for a specific campaign.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.AdGroupList.Request}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.marketing.v1beta1.AdGroupList.Request)
        io.bloombox.schema.services.marketing.v1beta1.AdGroupList.RequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupList_Request_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupList_Request_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request.class, io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request.Builder.class);
      }

      // Construct using io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        campaignId_ = "";

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupList_Request_descriptor;
      }

      public io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request getDefaultInstanceForType() {
        return io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request.getDefaultInstance();
      }

      public io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request build() {
        io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request buildPartial() {
        io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request result = new io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request(this);
        result.campaignId_ = campaignId_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request) {
          return mergeFrom((io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request other) {
        if (other == io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request.getDefaultInstance()) return this;
        if (!other.getCampaignId().isEmpty()) {
          campaignId_ = other.campaignId_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object campaignId_ = "";
      /**
       * <pre>
       * ID of the campaign to send.
       * </pre>
       *
       * <code>string campaign_id = 1;</code>
       */
      public java.lang.String getCampaignId() {
        java.lang.Object ref = campaignId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          campaignId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * ID of the campaign to send.
       * </pre>
       *
       * <code>string campaign_id = 1;</code>
       */
      public com.google.protobuf.ByteString
          getCampaignIdBytes() {
        java.lang.Object ref = campaignId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          campaignId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * ID of the campaign to send.
       * </pre>
       *
       * <code>string campaign_id = 1;</code>
       */
      public Builder setCampaignId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        campaignId_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * ID of the campaign to send.
       * </pre>
       *
       * <code>string campaign_id = 1;</code>
       */
      public Builder clearCampaignId() {
        
        campaignId_ = getDefaultInstance().getCampaignId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * ID of the campaign to send.
       * </pre>
       *
       * <code>string campaign_id = 1;</code>
       */
      public Builder setCampaignIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        campaignId_ = value;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.marketing.v1beta1.AdGroupList.Request)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.marketing.v1beta1.AdGroupList.Request)
    private static final io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request();
    }

    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Request>
        PARSER = new com.google.protobuf.AbstractParser<Request>() {
      public Request parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Request(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Request> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Request> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Request getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ResponseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.marketing.v1beta1.AdGroupList.Response)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Ad groups attached to the specified campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.AdGroup adgroup = 1;</code>
     */
    java.util.List<io.bloombox.schema.marketing.MarketingCampaign.AdGroup> 
        getAdgroupList();
    /**
     * <pre>
     * Ad groups attached to the specified campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.AdGroup adgroup = 1;</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.AdGroup getAdgroup(int index);
    /**
     * <pre>
     * Ad groups attached to the specified campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.AdGroup adgroup = 1;</code>
     */
    int getAdgroupCount();
    /**
     * <pre>
     * Ad groups attached to the specified campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.AdGroup adgroup = 1;</code>
     */
    java.util.List<? extends io.bloombox.schema.marketing.MarketingCampaign.AdGroupOrBuilder> 
        getAdgroupOrBuilderList();
    /**
     * <pre>
     * Ad groups attached to the specified campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.AdGroup adgroup = 1;</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.AdGroupOrBuilder getAdgroupOrBuilder(
        int index);
  }
  /**
   * <pre>
   * Response to a request to list adgroups for a specific campaign.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.AdGroupList.Response}
   */
  public  static final class Response extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.marketing.v1beta1.AdGroupList.Response)
      ResponseOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Response.newBuilder() to construct.
    private Response(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Response() {
      adgroup_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Response(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                adgroup_ = new java.util.ArrayList<io.bloombox.schema.marketing.MarketingCampaign.AdGroup>();
                mutable_bitField0_ |= 0x00000001;
              }
              adgroup_.add(
                  input.readMessage(io.bloombox.schema.marketing.MarketingCampaign.AdGroup.parser(), extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          adgroup_ = java.util.Collections.unmodifiableList(adgroup_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupList_Response_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupList_Response_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response.class, io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response.Builder.class);
    }

    public static final int ADGROUP_FIELD_NUMBER = 1;
    private java.util.List<io.bloombox.schema.marketing.MarketingCampaign.AdGroup> adgroup_;
    /**
     * <pre>
     * Ad groups attached to the specified campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.AdGroup adgroup = 1;</code>
     */
    public java.util.List<io.bloombox.schema.marketing.MarketingCampaign.AdGroup> getAdgroupList() {
      return adgroup_;
    }
    /**
     * <pre>
     * Ad groups attached to the specified campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.AdGroup adgroup = 1;</code>
     */
    public java.util.List<? extends io.bloombox.schema.marketing.MarketingCampaign.AdGroupOrBuilder> 
        getAdgroupOrBuilderList() {
      return adgroup_;
    }
    /**
     * <pre>
     * Ad groups attached to the specified campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.AdGroup adgroup = 1;</code>
     */
    public int getAdgroupCount() {
      return adgroup_.size();
    }
    /**
     * <pre>
     * Ad groups attached to the specified campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.AdGroup adgroup = 1;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.AdGroup getAdgroup(int index) {
      return adgroup_.get(index);
    }
    /**
     * <pre>
     * Ad groups attached to the specified campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.AdGroup adgroup = 1;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.AdGroupOrBuilder getAdgroupOrBuilder(
        int index) {
      return adgroup_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      for (int i = 0; i < adgroup_.size(); i++) {
        output.writeMessage(1, adgroup_.get(i));
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < adgroup_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, adgroup_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response other = (io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response) obj;

      boolean result = true;
      result = result && getAdgroupList()
          .equals(other.getAdgroupList());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getAdgroupCount() > 0) {
        hash = (37 * hash) + ADGROUP_FIELD_NUMBER;
        hash = (53 * hash) + getAdgroupList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Response to a request to list adgroups for a specific campaign.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.AdGroupList.Response}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.marketing.v1beta1.AdGroupList.Response)
        io.bloombox.schema.services.marketing.v1beta1.AdGroupList.ResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupList_Response_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupList_Response_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response.class, io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response.Builder.class);
      }

      // Construct using io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getAdgroupFieldBuilder();
        }
      }
      public Builder clear() {
        super.clear();
        if (adgroupBuilder_ == null) {
          adgroup_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          adgroupBuilder_.clear();
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupList_Response_descriptor;
      }

      public io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response getDefaultInstanceForType() {
        return io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response.getDefaultInstance();
      }

      public io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response build() {
        io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response buildPartial() {
        io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response result = new io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response(this);
        int from_bitField0_ = bitField0_;
        if (adgroupBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)) {
            adgroup_ = java.util.Collections.unmodifiableList(adgroup_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.adgroup_ = adgroup_;
        } else {
          result.adgroup_ = adgroupBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response) {
          return mergeFrom((io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response other) {
        if (other == io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response.getDefaultInstance()) return this;
        if (adgroupBuilder_ == null) {
          if (!other.adgroup_.isEmpty()) {
            if (adgroup_.isEmpty()) {
              adgroup_ = other.adgroup_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureAdgroupIsMutable();
              adgroup_.addAll(other.adgroup_);
            }
            onChanged();
          }
        } else {
          if (!other.adgroup_.isEmpty()) {
            if (adgroupBuilder_.isEmpty()) {
              adgroupBuilder_.dispose();
              adgroupBuilder_ = null;
              adgroup_ = other.adgroup_;
              bitField0_ = (bitField0_ & ~0x00000001);
              adgroupBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getAdgroupFieldBuilder() : null;
            } else {
              adgroupBuilder_.addAllMessages(other.adgroup_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.util.List<io.bloombox.schema.marketing.MarketingCampaign.AdGroup> adgroup_ =
        java.util.Collections.emptyList();
      private void ensureAdgroupIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          adgroup_ = new java.util.ArrayList<io.bloombox.schema.marketing.MarketingCampaign.AdGroup>(adgroup_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.bloombox.schema.marketing.MarketingCampaign.AdGroup, io.bloombox.schema.marketing.MarketingCampaign.AdGroup.Builder, io.bloombox.schema.marketing.MarketingCampaign.AdGroupOrBuilder> adgroupBuilder_;

      /**
       * <pre>
       * Ad groups attached to the specified campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup adgroup = 1;</code>
       */
      public java.util.List<io.bloombox.schema.marketing.MarketingCampaign.AdGroup> getAdgroupList() {
        if (adgroupBuilder_ == null) {
          return java.util.Collections.unmodifiableList(adgroup_);
        } else {
          return adgroupBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Ad groups attached to the specified campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup adgroup = 1;</code>
       */
      public int getAdgroupCount() {
        if (adgroupBuilder_ == null) {
          return adgroup_.size();
        } else {
          return adgroupBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Ad groups attached to the specified campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup adgroup = 1;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.AdGroup getAdgroup(int index) {
        if (adgroupBuilder_ == null) {
          return adgroup_.get(index);
        } else {
          return adgroupBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Ad groups attached to the specified campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup adgroup = 1;</code>
       */
      public Builder setAdgroup(
          int index, io.bloombox.schema.marketing.MarketingCampaign.AdGroup value) {
        if (adgroupBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAdgroupIsMutable();
          adgroup_.set(index, value);
          onChanged();
        } else {
          adgroupBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Ad groups attached to the specified campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup adgroup = 1;</code>
       */
      public Builder setAdgroup(
          int index, io.bloombox.schema.marketing.MarketingCampaign.AdGroup.Builder builderForValue) {
        if (adgroupBuilder_ == null) {
          ensureAdgroupIsMutable();
          adgroup_.set(index, builderForValue.build());
          onChanged();
        } else {
          adgroupBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Ad groups attached to the specified campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup adgroup = 1;</code>
       */
      public Builder addAdgroup(io.bloombox.schema.marketing.MarketingCampaign.AdGroup value) {
        if (adgroupBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAdgroupIsMutable();
          adgroup_.add(value);
          onChanged();
        } else {
          adgroupBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Ad groups attached to the specified campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup adgroup = 1;</code>
       */
      public Builder addAdgroup(
          int index, io.bloombox.schema.marketing.MarketingCampaign.AdGroup value) {
        if (adgroupBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureAdgroupIsMutable();
          adgroup_.add(index, value);
          onChanged();
        } else {
          adgroupBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Ad groups attached to the specified campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup adgroup = 1;</code>
       */
      public Builder addAdgroup(
          io.bloombox.schema.marketing.MarketingCampaign.AdGroup.Builder builderForValue) {
        if (adgroupBuilder_ == null) {
          ensureAdgroupIsMutable();
          adgroup_.add(builderForValue.build());
          onChanged();
        } else {
          adgroupBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Ad groups attached to the specified campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup adgroup = 1;</code>
       */
      public Builder addAdgroup(
          int index, io.bloombox.schema.marketing.MarketingCampaign.AdGroup.Builder builderForValue) {
        if (adgroupBuilder_ == null) {
          ensureAdgroupIsMutable();
          adgroup_.add(index, builderForValue.build());
          onChanged();
        } else {
          adgroupBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Ad groups attached to the specified campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup adgroup = 1;</code>
       */
      public Builder addAllAdgroup(
          java.lang.Iterable<? extends io.bloombox.schema.marketing.MarketingCampaign.AdGroup> values) {
        if (adgroupBuilder_ == null) {
          ensureAdgroupIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, adgroup_);
          onChanged();
        } else {
          adgroupBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Ad groups attached to the specified campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup adgroup = 1;</code>
       */
      public Builder clearAdgroup() {
        if (adgroupBuilder_ == null) {
          adgroup_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          adgroupBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Ad groups attached to the specified campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup adgroup = 1;</code>
       */
      public Builder removeAdgroup(int index) {
        if (adgroupBuilder_ == null) {
          ensureAdgroupIsMutable();
          adgroup_.remove(index);
          onChanged();
        } else {
          adgroupBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Ad groups attached to the specified campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup adgroup = 1;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.AdGroup.Builder getAdgroupBuilder(
          int index) {
        return getAdgroupFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Ad groups attached to the specified campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup adgroup = 1;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.AdGroupOrBuilder getAdgroupOrBuilder(
          int index) {
        if (adgroupBuilder_ == null) {
          return adgroup_.get(index);  } else {
          return adgroupBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Ad groups attached to the specified campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup adgroup = 1;</code>
       */
      public java.util.List<? extends io.bloombox.schema.marketing.MarketingCampaign.AdGroupOrBuilder> 
           getAdgroupOrBuilderList() {
        if (adgroupBuilder_ != null) {
          return adgroupBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(adgroup_);
        }
      }
      /**
       * <pre>
       * Ad groups attached to the specified campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup adgroup = 1;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.AdGroup.Builder addAdgroupBuilder() {
        return getAdgroupFieldBuilder().addBuilder(
            io.bloombox.schema.marketing.MarketingCampaign.AdGroup.getDefaultInstance());
      }
      /**
       * <pre>
       * Ad groups attached to the specified campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup adgroup = 1;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.AdGroup.Builder addAdgroupBuilder(
          int index) {
        return getAdgroupFieldBuilder().addBuilder(
            index, io.bloombox.schema.marketing.MarketingCampaign.AdGroup.getDefaultInstance());
      }
      /**
       * <pre>
       * Ad groups attached to the specified campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.AdGroup adgroup = 1;</code>
       */
      public java.util.List<io.bloombox.schema.marketing.MarketingCampaign.AdGroup.Builder> 
           getAdgroupBuilderList() {
        return getAdgroupFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.bloombox.schema.marketing.MarketingCampaign.AdGroup, io.bloombox.schema.marketing.MarketingCampaign.AdGroup.Builder, io.bloombox.schema.marketing.MarketingCampaign.AdGroupOrBuilder> 
          getAdgroupFieldBuilder() {
        if (adgroupBuilder_ == null) {
          adgroupBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              io.bloombox.schema.marketing.MarketingCampaign.AdGroup, io.bloombox.schema.marketing.MarketingCampaign.AdGroup.Builder, io.bloombox.schema.marketing.MarketingCampaign.AdGroupOrBuilder>(
                  adgroup_,
                  ((bitField0_ & 0x00000001) == 0x00000001),
                  getParentForChildren(),
                  isClean());
          adgroup_ = null;
        }
        return adgroupBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.marketing.v1beta1.AdGroupList.Response)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.marketing.v1beta1.AdGroupList.Response)
    private static final io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response();
    }

    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Response>
        PARSER = new com.google.protobuf.AbstractParser<Response>() {
      public Response parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Response(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Response> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Response> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Response getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.services.marketing.v1beta1.AdGroupList)) {
      return super.equals(obj);
    }
    io.bloombox.schema.services.marketing.v1beta1.AdGroupList other = (io.bloombox.schema.services.marketing.v1beta1.AdGroupList) obj;

    boolean result = true;
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.services.marketing.v1beta1.AdGroupList prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Represents an RPC operation to list groups of ad parameters for a given marketing campaign.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.AdGroupList}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.services.marketing.v1beta1.AdGroupList)
      io.bloombox.schema.services.marketing.v1beta1.AdGroupListOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupList_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupList_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.marketing.v1beta1.AdGroupList.class, io.bloombox.schema.services.marketing.v1beta1.AdGroupList.Builder.class);
    }

    // Construct using io.bloombox.schema.services.marketing.v1beta1.AdGroupList.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupList_descriptor;
    }

    public io.bloombox.schema.services.marketing.v1beta1.AdGroupList getDefaultInstanceForType() {
      return io.bloombox.schema.services.marketing.v1beta1.AdGroupList.getDefaultInstance();
    }

    public io.bloombox.schema.services.marketing.v1beta1.AdGroupList build() {
      io.bloombox.schema.services.marketing.v1beta1.AdGroupList result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.services.marketing.v1beta1.AdGroupList buildPartial() {
      io.bloombox.schema.services.marketing.v1beta1.AdGroupList result = new io.bloombox.schema.services.marketing.v1beta1.AdGroupList(this);
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.services.marketing.v1beta1.AdGroupList) {
        return mergeFrom((io.bloombox.schema.services.marketing.v1beta1.AdGroupList)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.services.marketing.v1beta1.AdGroupList other) {
      if (other == io.bloombox.schema.services.marketing.v1beta1.AdGroupList.getDefaultInstance()) return this;
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.services.marketing.v1beta1.AdGroupList parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.services.marketing.v1beta1.AdGroupList) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.services.marketing.v1beta1.AdGroupList)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.services.marketing.v1beta1.AdGroupList)
  private static final io.bloombox.schema.services.marketing.v1beta1.AdGroupList DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.services.marketing.v1beta1.AdGroupList();
  }

  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupList getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AdGroupList>
      PARSER = new com.google.protobuf.AbstractParser<AdGroupList>() {
    public AdGroupList parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new AdGroupList(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<AdGroupList> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AdGroupList> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.services.marketing.v1beta1.AdGroupList getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

