/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: marketing/v1beta1/MarketingService_Beta1.proto

package io.bloombox.schema.services.marketing.v1beta1;

/**
 * <pre>
 * Represents an RPC operation to update an individual ad group's configuration or content.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.AdGroupUpdate}
 */
public  final class AdGroupUpdate extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.services.marketing.v1beta1.AdGroupUpdate)
    AdGroupUpdateOrBuilder {
private static final long serialVersionUID = 0L;
  // Use AdGroupUpdate.newBuilder() to construct.
  private AdGroupUpdate(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private AdGroupUpdate() {
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private AdGroupUpdate(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupUpdate_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupUpdate_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.class, io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Builder.class);
  }

  public interface RequestOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * ID for the campaign.
     * </pre>
     *
     * <code>string campaign_id = 1;</code>
     */
    java.lang.String getCampaignId();
    /**
     * <pre>
     * ID for the campaign.
     * </pre>
     *
     * <code>string campaign_id = 1;</code>
     */
    com.google.protobuf.ByteString
        getCampaignIdBytes();

    /**
     * <pre>
     * Adgroup ID to fetch.
     * </pre>
     *
     * <code>string adgroup_id = 2;</code>
     */
    java.lang.String getAdgroupId();
    /**
     * <pre>
     * Adgroup ID to fetch.
     * </pre>
     *
     * <code>string adgroup_id = 2;</code>
     */
    com.google.protobuf.ByteString
        getAdgroupIdBytes();

    /**
     * <pre>
     * Creative updates to apply.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.Creative creative = 3;</code>
     */
    java.util.List<io.bloombox.schema.marketing.MarketingCampaign.Creative> 
        getCreativeList();
    /**
     * <pre>
     * Creative updates to apply.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.Creative creative = 3;</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.Creative getCreative(int index);
    /**
     * <pre>
     * Creative updates to apply.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.Creative creative = 3;</code>
     */
    int getCreativeCount();
    /**
     * <pre>
     * Creative updates to apply.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.Creative creative = 3;</code>
     */
    java.util.List<? extends io.bloombox.schema.marketing.MarketingCampaign.CreativeOrBuilder> 
        getCreativeOrBuilderList();
    /**
     * <pre>
     * Creative updates to apply.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.Creative creative = 3;</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.CreativeOrBuilder getCreativeOrBuilder(
        int index);
  }
  /**
   * <pre>
   * Request to update an individual adgroup.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request}
   */
  public  static final class Request extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request)
      RequestOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Request.newBuilder() to construct.
    private Request(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Request() {
      campaignId_ = "";
      adgroupId_ = "";
      creative_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Request(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              campaignId_ = s;
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();

              adgroupId_ = s;
              break;
            }
            case 26: {
              if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
                creative_ = new java.util.ArrayList<io.bloombox.schema.marketing.MarketingCampaign.Creative>();
                mutable_bitField0_ |= 0x00000004;
              }
              creative_.add(
                  input.readMessage(io.bloombox.schema.marketing.MarketingCampaign.Creative.parser(), extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
          creative_ = java.util.Collections.unmodifiableList(creative_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupUpdate_Request_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupUpdate_Request_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request.class, io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request.Builder.class);
    }

    private int bitField0_;
    public static final int CAMPAIGN_ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object campaignId_;
    /**
     * <pre>
     * ID for the campaign.
     * </pre>
     *
     * <code>string campaign_id = 1;</code>
     */
    public java.lang.String getCampaignId() {
      java.lang.Object ref = campaignId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        campaignId_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * ID for the campaign.
     * </pre>
     *
     * <code>string campaign_id = 1;</code>
     */
    public com.google.protobuf.ByteString
        getCampaignIdBytes() {
      java.lang.Object ref = campaignId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        campaignId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ADGROUP_ID_FIELD_NUMBER = 2;
    private volatile java.lang.Object adgroupId_;
    /**
     * <pre>
     * Adgroup ID to fetch.
     * </pre>
     *
     * <code>string adgroup_id = 2;</code>
     */
    public java.lang.String getAdgroupId() {
      java.lang.Object ref = adgroupId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        adgroupId_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Adgroup ID to fetch.
     * </pre>
     *
     * <code>string adgroup_id = 2;</code>
     */
    public com.google.protobuf.ByteString
        getAdgroupIdBytes() {
      java.lang.Object ref = adgroupId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        adgroupId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CREATIVE_FIELD_NUMBER = 3;
    private java.util.List<io.bloombox.schema.marketing.MarketingCampaign.Creative> creative_;
    /**
     * <pre>
     * Creative updates to apply.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.Creative creative = 3;</code>
     */
    public java.util.List<io.bloombox.schema.marketing.MarketingCampaign.Creative> getCreativeList() {
      return creative_;
    }
    /**
     * <pre>
     * Creative updates to apply.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.Creative creative = 3;</code>
     */
    public java.util.List<? extends io.bloombox.schema.marketing.MarketingCampaign.CreativeOrBuilder> 
        getCreativeOrBuilderList() {
      return creative_;
    }
    /**
     * <pre>
     * Creative updates to apply.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.Creative creative = 3;</code>
     */
    public int getCreativeCount() {
      return creative_.size();
    }
    /**
     * <pre>
     * Creative updates to apply.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.Creative creative = 3;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.Creative getCreative(int index) {
      return creative_.get(index);
    }
    /**
     * <pre>
     * Creative updates to apply.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.Creative creative = 3;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.CreativeOrBuilder getCreativeOrBuilder(
        int index) {
      return creative_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getCampaignIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, campaignId_);
      }
      if (!getAdgroupIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, adgroupId_);
      }
      for (int i = 0; i < creative_.size(); i++) {
        output.writeMessage(3, creative_.get(i));
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getCampaignIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, campaignId_);
      }
      if (!getAdgroupIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, adgroupId_);
      }
      for (int i = 0; i < creative_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, creative_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request other = (io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request) obj;

      boolean result = true;
      result = result && getCampaignId()
          .equals(other.getCampaignId());
      result = result && getAdgroupId()
          .equals(other.getAdgroupId());
      result = result && getCreativeList()
          .equals(other.getCreativeList());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + CAMPAIGN_ID_FIELD_NUMBER;
      hash = (53 * hash) + getCampaignId().hashCode();
      hash = (37 * hash) + ADGROUP_ID_FIELD_NUMBER;
      hash = (53 * hash) + getAdgroupId().hashCode();
      if (getCreativeCount() > 0) {
        hash = (37 * hash) + CREATIVE_FIELD_NUMBER;
        hash = (53 * hash) + getCreativeList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Request to update an individual adgroup.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request)
        io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.RequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupUpdate_Request_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupUpdate_Request_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request.class, io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request.Builder.class);
      }

      // Construct using io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getCreativeFieldBuilder();
        }
      }
      public Builder clear() {
        super.clear();
        campaignId_ = "";

        adgroupId_ = "";

        if (creativeBuilder_ == null) {
          creative_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          creativeBuilder_.clear();
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupUpdate_Request_descriptor;
      }

      public io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request getDefaultInstanceForType() {
        return io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request.getDefaultInstance();
      }

      public io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request build() {
        io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request buildPartial() {
        io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request result = new io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        result.campaignId_ = campaignId_;
        result.adgroupId_ = adgroupId_;
        if (creativeBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)) {
            creative_ = java.util.Collections.unmodifiableList(creative_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.creative_ = creative_;
        } else {
          result.creative_ = creativeBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request) {
          return mergeFrom((io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request other) {
        if (other == io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request.getDefaultInstance()) return this;
        if (!other.getCampaignId().isEmpty()) {
          campaignId_ = other.campaignId_;
          onChanged();
        }
        if (!other.getAdgroupId().isEmpty()) {
          adgroupId_ = other.adgroupId_;
          onChanged();
        }
        if (creativeBuilder_ == null) {
          if (!other.creative_.isEmpty()) {
            if (creative_.isEmpty()) {
              creative_ = other.creative_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureCreativeIsMutable();
              creative_.addAll(other.creative_);
            }
            onChanged();
          }
        } else {
          if (!other.creative_.isEmpty()) {
            if (creativeBuilder_.isEmpty()) {
              creativeBuilder_.dispose();
              creativeBuilder_ = null;
              creative_ = other.creative_;
              bitField0_ = (bitField0_ & ~0x00000004);
              creativeBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getCreativeFieldBuilder() : null;
            } else {
              creativeBuilder_.addAllMessages(other.creative_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object campaignId_ = "";
      /**
       * <pre>
       * ID for the campaign.
       * </pre>
       *
       * <code>string campaign_id = 1;</code>
       */
      public java.lang.String getCampaignId() {
        java.lang.Object ref = campaignId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          campaignId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * ID for the campaign.
       * </pre>
       *
       * <code>string campaign_id = 1;</code>
       */
      public com.google.protobuf.ByteString
          getCampaignIdBytes() {
        java.lang.Object ref = campaignId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          campaignId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * ID for the campaign.
       * </pre>
       *
       * <code>string campaign_id = 1;</code>
       */
      public Builder setCampaignId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        campaignId_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * ID for the campaign.
       * </pre>
       *
       * <code>string campaign_id = 1;</code>
       */
      public Builder clearCampaignId() {
        
        campaignId_ = getDefaultInstance().getCampaignId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * ID for the campaign.
       * </pre>
       *
       * <code>string campaign_id = 1;</code>
       */
      public Builder setCampaignIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        campaignId_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object adgroupId_ = "";
      /**
       * <pre>
       * Adgroup ID to fetch.
       * </pre>
       *
       * <code>string adgroup_id = 2;</code>
       */
      public java.lang.String getAdgroupId() {
        java.lang.Object ref = adgroupId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          adgroupId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Adgroup ID to fetch.
       * </pre>
       *
       * <code>string adgroup_id = 2;</code>
       */
      public com.google.protobuf.ByteString
          getAdgroupIdBytes() {
        java.lang.Object ref = adgroupId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          adgroupId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Adgroup ID to fetch.
       * </pre>
       *
       * <code>string adgroup_id = 2;</code>
       */
      public Builder setAdgroupId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        adgroupId_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Adgroup ID to fetch.
       * </pre>
       *
       * <code>string adgroup_id = 2;</code>
       */
      public Builder clearAdgroupId() {
        
        adgroupId_ = getDefaultInstance().getAdgroupId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Adgroup ID to fetch.
       * </pre>
       *
       * <code>string adgroup_id = 2;</code>
       */
      public Builder setAdgroupIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        adgroupId_ = value;
        onChanged();
        return this;
      }

      private java.util.List<io.bloombox.schema.marketing.MarketingCampaign.Creative> creative_ =
        java.util.Collections.emptyList();
      private void ensureCreativeIsMutable() {
        if (!((bitField0_ & 0x00000004) == 0x00000004)) {
          creative_ = new java.util.ArrayList<io.bloombox.schema.marketing.MarketingCampaign.Creative>(creative_);
          bitField0_ |= 0x00000004;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.bloombox.schema.marketing.MarketingCampaign.Creative, io.bloombox.schema.marketing.MarketingCampaign.Creative.Builder, io.bloombox.schema.marketing.MarketingCampaign.CreativeOrBuilder> creativeBuilder_;

      /**
       * <pre>
       * Creative updates to apply.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 3;</code>
       */
      public java.util.List<io.bloombox.schema.marketing.MarketingCampaign.Creative> getCreativeList() {
        if (creativeBuilder_ == null) {
          return java.util.Collections.unmodifiableList(creative_);
        } else {
          return creativeBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Creative updates to apply.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 3;</code>
       */
      public int getCreativeCount() {
        if (creativeBuilder_ == null) {
          return creative_.size();
        } else {
          return creativeBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Creative updates to apply.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 3;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.Creative getCreative(int index) {
        if (creativeBuilder_ == null) {
          return creative_.get(index);
        } else {
          return creativeBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Creative updates to apply.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 3;</code>
       */
      public Builder setCreative(
          int index, io.bloombox.schema.marketing.MarketingCampaign.Creative value) {
        if (creativeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCreativeIsMutable();
          creative_.set(index, value);
          onChanged();
        } else {
          creativeBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Creative updates to apply.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 3;</code>
       */
      public Builder setCreative(
          int index, io.bloombox.schema.marketing.MarketingCampaign.Creative.Builder builderForValue) {
        if (creativeBuilder_ == null) {
          ensureCreativeIsMutable();
          creative_.set(index, builderForValue.build());
          onChanged();
        } else {
          creativeBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Creative updates to apply.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 3;</code>
       */
      public Builder addCreative(io.bloombox.schema.marketing.MarketingCampaign.Creative value) {
        if (creativeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCreativeIsMutable();
          creative_.add(value);
          onChanged();
        } else {
          creativeBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Creative updates to apply.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 3;</code>
       */
      public Builder addCreative(
          int index, io.bloombox.schema.marketing.MarketingCampaign.Creative value) {
        if (creativeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCreativeIsMutable();
          creative_.add(index, value);
          onChanged();
        } else {
          creativeBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Creative updates to apply.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 3;</code>
       */
      public Builder addCreative(
          io.bloombox.schema.marketing.MarketingCampaign.Creative.Builder builderForValue) {
        if (creativeBuilder_ == null) {
          ensureCreativeIsMutable();
          creative_.add(builderForValue.build());
          onChanged();
        } else {
          creativeBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Creative updates to apply.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 3;</code>
       */
      public Builder addCreative(
          int index, io.bloombox.schema.marketing.MarketingCampaign.Creative.Builder builderForValue) {
        if (creativeBuilder_ == null) {
          ensureCreativeIsMutable();
          creative_.add(index, builderForValue.build());
          onChanged();
        } else {
          creativeBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Creative updates to apply.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 3;</code>
       */
      public Builder addAllCreative(
          java.lang.Iterable<? extends io.bloombox.schema.marketing.MarketingCampaign.Creative> values) {
        if (creativeBuilder_ == null) {
          ensureCreativeIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, creative_);
          onChanged();
        } else {
          creativeBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Creative updates to apply.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 3;</code>
       */
      public Builder clearCreative() {
        if (creativeBuilder_ == null) {
          creative_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          creativeBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Creative updates to apply.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 3;</code>
       */
      public Builder removeCreative(int index) {
        if (creativeBuilder_ == null) {
          ensureCreativeIsMutable();
          creative_.remove(index);
          onChanged();
        } else {
          creativeBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Creative updates to apply.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 3;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.Creative.Builder getCreativeBuilder(
          int index) {
        return getCreativeFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Creative updates to apply.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 3;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.CreativeOrBuilder getCreativeOrBuilder(
          int index) {
        if (creativeBuilder_ == null) {
          return creative_.get(index);  } else {
          return creativeBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Creative updates to apply.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 3;</code>
       */
      public java.util.List<? extends io.bloombox.schema.marketing.MarketingCampaign.CreativeOrBuilder> 
           getCreativeOrBuilderList() {
        if (creativeBuilder_ != null) {
          return creativeBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(creative_);
        }
      }
      /**
       * <pre>
       * Creative updates to apply.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 3;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.Creative.Builder addCreativeBuilder() {
        return getCreativeFieldBuilder().addBuilder(
            io.bloombox.schema.marketing.MarketingCampaign.Creative.getDefaultInstance());
      }
      /**
       * <pre>
       * Creative updates to apply.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 3;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.Creative.Builder addCreativeBuilder(
          int index) {
        return getCreativeFieldBuilder().addBuilder(
            index, io.bloombox.schema.marketing.MarketingCampaign.Creative.getDefaultInstance());
      }
      /**
       * <pre>
       * Creative updates to apply.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.Creative creative = 3;</code>
       */
      public java.util.List<io.bloombox.schema.marketing.MarketingCampaign.Creative.Builder> 
           getCreativeBuilderList() {
        return getCreativeFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.bloombox.schema.marketing.MarketingCampaign.Creative, io.bloombox.schema.marketing.MarketingCampaign.Creative.Builder, io.bloombox.schema.marketing.MarketingCampaign.CreativeOrBuilder> 
          getCreativeFieldBuilder() {
        if (creativeBuilder_ == null) {
          creativeBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              io.bloombox.schema.marketing.MarketingCampaign.Creative, io.bloombox.schema.marketing.MarketingCampaign.Creative.Builder, io.bloombox.schema.marketing.MarketingCampaign.CreativeOrBuilder>(
                  creative_,
                  ((bitField0_ & 0x00000004) == 0x00000004),
                  getParentForChildren(),
                  isClean());
          creative_ = null;
        }
        return creativeBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request)
    private static final io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request();
    }

    public static io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Request>
        PARSER = new com.google.protobuf.AbstractParser<Request>() {
      public Request parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Request(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Request> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Request> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Request getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate)) {
      return super.equals(obj);
    }
    io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate other = (io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate) obj;

    boolean result = true;
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Represents an RPC operation to update an individual ad group's configuration or content.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.AdGroupUpdate}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.services.marketing.v1beta1.AdGroupUpdate)
      io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdateOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupUpdate_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupUpdate_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.class, io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.Builder.class);
    }

    // Construct using io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_AdGroupUpdate_descriptor;
    }

    public io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate getDefaultInstanceForType() {
      return io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.getDefaultInstance();
    }

    public io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate build() {
      io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate buildPartial() {
      io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate result = new io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate(this);
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate) {
        return mergeFrom((io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate other) {
      if (other == io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate.getDefaultInstance()) return this;
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.services.marketing.v1beta1.AdGroupUpdate)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.services.marketing.v1beta1.AdGroupUpdate)
  private static final io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate();
  }

  public static io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AdGroupUpdate>
      PARSER = new com.google.protobuf.AbstractParser<AdGroupUpdate>() {
    public AdGroupUpdate parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new AdGroupUpdate(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<AdGroupUpdate> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AdGroupUpdate> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.services.marketing.v1beta1.AdGroupUpdate getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

