/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: marketing/v1beta1/MarketingService_Beta1.proto

package io.bloombox.schema.services.marketing.v1beta1;

/**
 * <pre>
 * Represents an RPC operation to create a new marketing campaign from scratch.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.CampaignCreate}
 */
public  final class CampaignCreate extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.services.marketing.v1beta1.CampaignCreate)
    CampaignCreateOrBuilder {
private static final long serialVersionUID = 0L;
  // Use CampaignCreate.newBuilder() to construct.
  private CampaignCreate(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private CampaignCreate() {
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private CampaignCreate(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignCreate_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignCreate_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.class, io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Builder.class);
  }

  public interface RequestOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Partner ID under which to create the campaign.
     * </pre>
     *
     * <code>string partner = 1;</code>
     */
    java.lang.String getPartner();
    /**
     * <pre>
     * Partner ID under which to create the campaign.
     * </pre>
     *
     * <code>string partner = 1;</code>
     */
    com.google.protobuf.ByteString
        getPartnerBytes();

    /**
     * <pre>
     * Location ID under which to create the campaign.
     * </pre>
     *
     * <code>string location = 2;</code>
     */
    java.lang.String getLocation();
    /**
     * <pre>
     * Location ID under which to create the campaign.
     * </pre>
     *
     * <code>string location = 2;</code>
     */
    com.google.protobuf.ByteString
        getLocationBytes();

    /**
     * <pre>
     * Name/label for the campaign.
     * </pre>
     *
     * <code>string name = 3;</code>
     */
    java.lang.String getName();
    /**
     * <pre>
     * Name/label for the campaign.
     * </pre>
     *
     * <code>string name = 3;</code>
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <pre>
     * Description for the campaign.
     * </pre>
     *
     * <code>string description = 4;</code>
     */
    java.lang.String getDescription();
    /**
     * <pre>
     * Description for the campaign.
     * </pre>
     *
     * <code>string description = 4;</code>
     */
    com.google.protobuf.ByteString
        getDescriptionBytes();

    /**
     * <pre>
     * Distribution/channel settings for this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 5;</code>
     */
    java.util.List<io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings> 
        getChannelList();
    /**
     * <pre>
     * Distribution/channel settings for this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 5;</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings getChannel(int index);
    /**
     * <pre>
     * Distribution/channel settings for this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 5;</code>
     */
    int getChannelCount();
    /**
     * <pre>
     * Distribution/channel settings for this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 5;</code>
     */
    java.util.List<? extends io.bloombox.schema.marketing.MarketingCampaign.ChannelSettingsOrBuilder> 
        getChannelOrBuilderList();
    /**
     * <pre>
     * Distribution/channel settings for this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 5;</code>
     */
    io.bloombox.schema.marketing.MarketingCampaign.ChannelSettingsOrBuilder getChannelOrBuilder(
        int index);
  }
  /**
   * <pre>
   * Request to create a marketing campaign.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request}
   */
  public  static final class Request extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request)
      RequestOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Request.newBuilder() to construct.
    private Request(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Request() {
      partner_ = "";
      location_ = "";
      name_ = "";
      description_ = "";
      channel_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Request(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              partner_ = s;
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();

              location_ = s;
              break;
            }
            case 26: {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
            case 34: {
              java.lang.String s = input.readStringRequireUtf8();

              description_ = s;
              break;
            }
            case 42: {
              if (!((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
                channel_ = new java.util.ArrayList<io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings>();
                mutable_bitField0_ |= 0x00000010;
              }
              channel_.add(
                  input.readMessage(io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.parser(), extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
          channel_ = java.util.Collections.unmodifiableList(channel_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignCreate_Request_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignCreate_Request_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request.class, io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request.Builder.class);
    }

    private int bitField0_;
    public static final int PARTNER_FIELD_NUMBER = 1;
    private volatile java.lang.Object partner_;
    /**
     * <pre>
     * Partner ID under which to create the campaign.
     * </pre>
     *
     * <code>string partner = 1;</code>
     */
    public java.lang.String getPartner() {
      java.lang.Object ref = partner_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        partner_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Partner ID under which to create the campaign.
     * </pre>
     *
     * <code>string partner = 1;</code>
     */
    public com.google.protobuf.ByteString
        getPartnerBytes() {
      java.lang.Object ref = partner_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        partner_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LOCATION_FIELD_NUMBER = 2;
    private volatile java.lang.Object location_;
    /**
     * <pre>
     * Location ID under which to create the campaign.
     * </pre>
     *
     * <code>string location = 2;</code>
     */
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Location ID under which to create the campaign.
     * </pre>
     *
     * <code>string location = 2;</code>
     */
    public com.google.protobuf.ByteString
        getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int NAME_FIELD_NUMBER = 3;
    private volatile java.lang.Object name_;
    /**
     * <pre>
     * Name/label for the campaign.
     * </pre>
     *
     * <code>string name = 3;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Name/label for the campaign.
     * </pre>
     *
     * <code>string name = 3;</code>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DESCRIPTION_FIELD_NUMBER = 4;
    private volatile java.lang.Object description_;
    /**
     * <pre>
     * Description for the campaign.
     * </pre>
     *
     * <code>string description = 4;</code>
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Description for the campaign.
     * </pre>
     *
     * <code>string description = 4;</code>
     */
    public com.google.protobuf.ByteString
        getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CHANNEL_FIELD_NUMBER = 5;
    private java.util.List<io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings> channel_;
    /**
     * <pre>
     * Distribution/channel settings for this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 5;</code>
     */
    public java.util.List<io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings> getChannelList() {
      return channel_;
    }
    /**
     * <pre>
     * Distribution/channel settings for this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 5;</code>
     */
    public java.util.List<? extends io.bloombox.schema.marketing.MarketingCampaign.ChannelSettingsOrBuilder> 
        getChannelOrBuilderList() {
      return channel_;
    }
    /**
     * <pre>
     * Distribution/channel settings for this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 5;</code>
     */
    public int getChannelCount() {
      return channel_.size();
    }
    /**
     * <pre>
     * Distribution/channel settings for this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 5;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings getChannel(int index) {
      return channel_.get(index);
    }
    /**
     * <pre>
     * Distribution/channel settings for this campaign.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 5;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettingsOrBuilder getChannelOrBuilder(
        int index) {
      return channel_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getPartnerBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, partner_);
      }
      if (!getLocationBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, location_);
      }
      if (!getNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, name_);
      }
      if (!getDescriptionBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, description_);
      }
      for (int i = 0; i < channel_.size(); i++) {
        output.writeMessage(5, channel_.get(i));
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getPartnerBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, partner_);
      }
      if (!getLocationBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, location_);
      }
      if (!getNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, name_);
      }
      if (!getDescriptionBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, description_);
      }
      for (int i = 0; i < channel_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, channel_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request other = (io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request) obj;

      boolean result = true;
      result = result && getPartner()
          .equals(other.getPartner());
      result = result && getLocation()
          .equals(other.getLocation());
      result = result && getName()
          .equals(other.getName());
      result = result && getDescription()
          .equals(other.getDescription());
      result = result && getChannelList()
          .equals(other.getChannelList());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PARTNER_FIELD_NUMBER;
      hash = (53 * hash) + getPartner().hashCode();
      hash = (37 * hash) + LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getLocation().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
      if (getChannelCount() > 0) {
        hash = (37 * hash) + CHANNEL_FIELD_NUMBER;
        hash = (53 * hash) + getChannelList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Request to create a marketing campaign.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request)
        io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.RequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignCreate_Request_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignCreate_Request_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request.class, io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request.Builder.class);
      }

      // Construct using io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getChannelFieldBuilder();
        }
      }
      public Builder clear() {
        super.clear();
        partner_ = "";

        location_ = "";

        name_ = "";

        description_ = "";

        if (channelBuilder_ == null) {
          channel_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
        } else {
          channelBuilder_.clear();
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignCreate_Request_descriptor;
      }

      public io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request getDefaultInstanceForType() {
        return io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request.getDefaultInstance();
      }

      public io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request build() {
        io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request buildPartial() {
        io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request result = new io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        result.partner_ = partner_;
        result.location_ = location_;
        result.name_ = name_;
        result.description_ = description_;
        if (channelBuilder_ == null) {
          if (((bitField0_ & 0x00000010) == 0x00000010)) {
            channel_ = java.util.Collections.unmodifiableList(channel_);
            bitField0_ = (bitField0_ & ~0x00000010);
          }
          result.channel_ = channel_;
        } else {
          result.channel_ = channelBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request) {
          return mergeFrom((io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request other) {
        if (other == io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request.getDefaultInstance()) return this;
        if (!other.getPartner().isEmpty()) {
          partner_ = other.partner_;
          onChanged();
        }
        if (!other.getLocation().isEmpty()) {
          location_ = other.location_;
          onChanged();
        }
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          onChanged();
        }
        if (!other.getDescription().isEmpty()) {
          description_ = other.description_;
          onChanged();
        }
        if (channelBuilder_ == null) {
          if (!other.channel_.isEmpty()) {
            if (channel_.isEmpty()) {
              channel_ = other.channel_;
              bitField0_ = (bitField0_ & ~0x00000010);
            } else {
              ensureChannelIsMutable();
              channel_.addAll(other.channel_);
            }
            onChanged();
          }
        } else {
          if (!other.channel_.isEmpty()) {
            if (channelBuilder_.isEmpty()) {
              channelBuilder_.dispose();
              channelBuilder_ = null;
              channel_ = other.channel_;
              bitField0_ = (bitField0_ & ~0x00000010);
              channelBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getChannelFieldBuilder() : null;
            } else {
              channelBuilder_.addAllMessages(other.channel_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object partner_ = "";
      /**
       * <pre>
       * Partner ID under which to create the campaign.
       * </pre>
       *
       * <code>string partner = 1;</code>
       */
      public java.lang.String getPartner() {
        java.lang.Object ref = partner_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          partner_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Partner ID under which to create the campaign.
       * </pre>
       *
       * <code>string partner = 1;</code>
       */
      public com.google.protobuf.ByteString
          getPartnerBytes() {
        java.lang.Object ref = partner_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          partner_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Partner ID under which to create the campaign.
       * </pre>
       *
       * <code>string partner = 1;</code>
       */
      public Builder setPartner(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        partner_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Partner ID under which to create the campaign.
       * </pre>
       *
       * <code>string partner = 1;</code>
       */
      public Builder clearPartner() {
        
        partner_ = getDefaultInstance().getPartner();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Partner ID under which to create the campaign.
       * </pre>
       *
       * <code>string partner = 1;</code>
       */
      public Builder setPartnerBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        partner_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object location_ = "";
      /**
       * <pre>
       * Location ID under which to create the campaign.
       * </pre>
       *
       * <code>string location = 2;</code>
       */
      public java.lang.String getLocation() {
        java.lang.Object ref = location_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          location_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Location ID under which to create the campaign.
       * </pre>
       *
       * <code>string location = 2;</code>
       */
      public com.google.protobuf.ByteString
          getLocationBytes() {
        java.lang.Object ref = location_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          location_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Location ID under which to create the campaign.
       * </pre>
       *
       * <code>string location = 2;</code>
       */
      public Builder setLocation(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        location_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Location ID under which to create the campaign.
       * </pre>
       *
       * <code>string location = 2;</code>
       */
      public Builder clearLocation() {
        
        location_ = getDefaultInstance().getLocation();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Location ID under which to create the campaign.
       * </pre>
       *
       * <code>string location = 2;</code>
       */
      public Builder setLocationBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        location_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object name_ = "";
      /**
       * <pre>
       * Name/label for the campaign.
       * </pre>
       *
       * <code>string name = 3;</code>
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Name/label for the campaign.
       * </pre>
       *
       * <code>string name = 3;</code>
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Name/label for the campaign.
       * </pre>
       *
       * <code>string name = 3;</code>
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        name_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Name/label for the campaign.
       * </pre>
       *
       * <code>string name = 3;</code>
       */
      public Builder clearName() {
        
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Name/label for the campaign.
       * </pre>
       *
       * <code>string name = 3;</code>
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        name_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object description_ = "";
      /**
       * <pre>
       * Description for the campaign.
       * </pre>
       *
       * <code>string description = 4;</code>
       */
      public java.lang.String getDescription() {
        java.lang.Object ref = description_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          description_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Description for the campaign.
       * </pre>
       *
       * <code>string description = 4;</code>
       */
      public com.google.protobuf.ByteString
          getDescriptionBytes() {
        java.lang.Object ref = description_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          description_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Description for the campaign.
       * </pre>
       *
       * <code>string description = 4;</code>
       */
      public Builder setDescription(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        description_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Description for the campaign.
       * </pre>
       *
       * <code>string description = 4;</code>
       */
      public Builder clearDescription() {
        
        description_ = getDefaultInstance().getDescription();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Description for the campaign.
       * </pre>
       *
       * <code>string description = 4;</code>
       */
      public Builder setDescriptionBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        description_ = value;
        onChanged();
        return this;
      }

      private java.util.List<io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings> channel_ =
        java.util.Collections.emptyList();
      private void ensureChannelIsMutable() {
        if (!((bitField0_ & 0x00000010) == 0x00000010)) {
          channel_ = new java.util.ArrayList<io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings>(channel_);
          bitField0_ |= 0x00000010;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Builder, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettingsOrBuilder> channelBuilder_;

      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 5;</code>
       */
      public java.util.List<io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings> getChannelList() {
        if (channelBuilder_ == null) {
          return java.util.Collections.unmodifiableList(channel_);
        } else {
          return channelBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 5;</code>
       */
      public int getChannelCount() {
        if (channelBuilder_ == null) {
          return channel_.size();
        } else {
          return channelBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 5;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings getChannel(int index) {
        if (channelBuilder_ == null) {
          return channel_.get(index);
        } else {
          return channelBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 5;</code>
       */
      public Builder setChannel(
          int index, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings value) {
        if (channelBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureChannelIsMutable();
          channel_.set(index, value);
          onChanged();
        } else {
          channelBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 5;</code>
       */
      public Builder setChannel(
          int index, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Builder builderForValue) {
        if (channelBuilder_ == null) {
          ensureChannelIsMutable();
          channel_.set(index, builderForValue.build());
          onChanged();
        } else {
          channelBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 5;</code>
       */
      public Builder addChannel(io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings value) {
        if (channelBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureChannelIsMutable();
          channel_.add(value);
          onChanged();
        } else {
          channelBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 5;</code>
       */
      public Builder addChannel(
          int index, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings value) {
        if (channelBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureChannelIsMutable();
          channel_.add(index, value);
          onChanged();
        } else {
          channelBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 5;</code>
       */
      public Builder addChannel(
          io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Builder builderForValue) {
        if (channelBuilder_ == null) {
          ensureChannelIsMutable();
          channel_.add(builderForValue.build());
          onChanged();
        } else {
          channelBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 5;</code>
       */
      public Builder addChannel(
          int index, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Builder builderForValue) {
        if (channelBuilder_ == null) {
          ensureChannelIsMutable();
          channel_.add(index, builderForValue.build());
          onChanged();
        } else {
          channelBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 5;</code>
       */
      public Builder addAllChannel(
          java.lang.Iterable<? extends io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings> values) {
        if (channelBuilder_ == null) {
          ensureChannelIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, channel_);
          onChanged();
        } else {
          channelBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 5;</code>
       */
      public Builder clearChannel() {
        if (channelBuilder_ == null) {
          channel_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
        } else {
          channelBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 5;</code>
       */
      public Builder removeChannel(int index) {
        if (channelBuilder_ == null) {
          ensureChannelIsMutable();
          channel_.remove(index);
          onChanged();
        } else {
          channelBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 5;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Builder getChannelBuilder(
          int index) {
        return getChannelFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 5;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettingsOrBuilder getChannelOrBuilder(
          int index) {
        if (channelBuilder_ == null) {
          return channel_.get(index);  } else {
          return channelBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 5;</code>
       */
      public java.util.List<? extends io.bloombox.schema.marketing.MarketingCampaign.ChannelSettingsOrBuilder> 
           getChannelOrBuilderList() {
        if (channelBuilder_ != null) {
          return channelBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(channel_);
        }
      }
      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 5;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Builder addChannelBuilder() {
        return getChannelFieldBuilder().addBuilder(
            io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.getDefaultInstance());
      }
      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 5;</code>
       */
      public io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Builder addChannelBuilder(
          int index) {
        return getChannelFieldBuilder().addBuilder(
            index, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.getDefaultInstance());
      }
      /**
       * <pre>
       * Distribution/channel settings for this campaign.
       * </pre>
       *
       * <code>repeated .bloombox.schema.marketing.ChannelSettings channel = 5;</code>
       */
      public java.util.List<io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Builder> 
           getChannelBuilderList() {
        return getChannelFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Builder, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettingsOrBuilder> 
          getChannelFieldBuilder() {
        if (channelBuilder_ == null) {
          channelBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettings.Builder, io.bloombox.schema.marketing.MarketingCampaign.ChannelSettingsOrBuilder>(
                  channel_,
                  ((bitField0_ & 0x00000010) == 0x00000010),
                  getParentForChildren(),
                  isClean());
          channel_ = null;
        }
        return channelBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request)
    private static final io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request();
    }

    public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Request>
        PARSER = new com.google.protobuf.AbstractParser<Request>() {
      public Request parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Request(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Request> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Request> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Request getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ResponseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * ID of the resulting campaign.
     * </pre>
     *
     * <code>string id = 1;</code>
     */
    java.lang.String getId();
    /**
     * <pre>
     * ID of the resulting campaign.
     * </pre>
     *
     * <code>string id = 1;</code>
     */
    com.google.protobuf.ByteString
        getIdBytes();
  }
  /**
   * <pre>
   * Response containing the resulting campaign ID.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response}
   */
  public  static final class Response extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response)
      ResponseOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Response.newBuilder() to construct.
    private Response(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Response() {
      id_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Response(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              id_ = s;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignCreate_Response_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignCreate_Response_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response.class, io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response.Builder.class);
    }

    public static final int ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object id_;
    /**
     * <pre>
     * ID of the resulting campaign.
     * </pre>
     *
     * <code>string id = 1;</code>
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * ID of the resulting campaign.
     * </pre>
     *
     * <code>string id = 1;</code>
     */
    public com.google.protobuf.ByteString
        getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response other = (io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response) obj;

      boolean result = true;
      result = result && getId()
          .equals(other.getId());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + getId().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Response containing the resulting campaign ID.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response)
        io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.ResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignCreate_Response_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignCreate_Response_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response.class, io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response.Builder.class);
      }

      // Construct using io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        id_ = "";

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignCreate_Response_descriptor;
      }

      public io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response getDefaultInstanceForType() {
        return io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response.getDefaultInstance();
      }

      public io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response build() {
        io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response buildPartial() {
        io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response result = new io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response(this);
        result.id_ = id_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response) {
          return mergeFrom((io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response other) {
        if (other == io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response.getDefaultInstance()) return this;
        if (!other.getId().isEmpty()) {
          id_ = other.id_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object id_ = "";
      /**
       * <pre>
       * ID of the resulting campaign.
       * </pre>
       *
       * <code>string id = 1;</code>
       */
      public java.lang.String getId() {
        java.lang.Object ref = id_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          id_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * ID of the resulting campaign.
       * </pre>
       *
       * <code>string id = 1;</code>
       */
      public com.google.protobuf.ByteString
          getIdBytes() {
        java.lang.Object ref = id_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          id_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * ID of the resulting campaign.
       * </pre>
       *
       * <code>string id = 1;</code>
       */
      public Builder setId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        id_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * ID of the resulting campaign.
       * </pre>
       *
       * <code>string id = 1;</code>
       */
      public Builder clearId() {
        
        id_ = getDefaultInstance().getId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * ID of the resulting campaign.
       * </pre>
       *
       * <code>string id = 1;</code>
       */
      public Builder setIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        id_ = value;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response)
    private static final io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response();
    }

    public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Response>
        PARSER = new com.google.protobuf.AbstractParser<Response>() {
      public Response parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Response(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Response> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Response> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Response getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.services.marketing.v1beta1.CampaignCreate)) {
      return super.equals(obj);
    }
    io.bloombox.schema.services.marketing.v1beta1.CampaignCreate other = (io.bloombox.schema.services.marketing.v1beta1.CampaignCreate) obj;

    boolean result = true;
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.services.marketing.v1beta1.CampaignCreate prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Represents an RPC operation to create a new marketing campaign from scratch.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.CampaignCreate}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.services.marketing.v1beta1.CampaignCreate)
      io.bloombox.schema.services.marketing.v1beta1.CampaignCreateOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignCreate_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignCreate_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.class, io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.Builder.class);
    }

    // Construct using io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignCreate_descriptor;
    }

    public io.bloombox.schema.services.marketing.v1beta1.CampaignCreate getDefaultInstanceForType() {
      return io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.getDefaultInstance();
    }

    public io.bloombox.schema.services.marketing.v1beta1.CampaignCreate build() {
      io.bloombox.schema.services.marketing.v1beta1.CampaignCreate result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.services.marketing.v1beta1.CampaignCreate buildPartial() {
      io.bloombox.schema.services.marketing.v1beta1.CampaignCreate result = new io.bloombox.schema.services.marketing.v1beta1.CampaignCreate(this);
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.services.marketing.v1beta1.CampaignCreate) {
        return mergeFrom((io.bloombox.schema.services.marketing.v1beta1.CampaignCreate)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.services.marketing.v1beta1.CampaignCreate other) {
      if (other == io.bloombox.schema.services.marketing.v1beta1.CampaignCreate.getDefaultInstance()) return this;
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.services.marketing.v1beta1.CampaignCreate parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.services.marketing.v1beta1.CampaignCreate) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.services.marketing.v1beta1.CampaignCreate)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.services.marketing.v1beta1.CampaignCreate)
  private static final io.bloombox.schema.services.marketing.v1beta1.CampaignCreate DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.services.marketing.v1beta1.CampaignCreate();
  }

  public static io.bloombox.schema.services.marketing.v1beta1.CampaignCreate getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CampaignCreate>
      PARSER = new com.google.protobuf.AbstractParser<CampaignCreate>() {
    public CampaignCreate parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new CampaignCreate(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<CampaignCreate> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CampaignCreate> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.services.marketing.v1beta1.CampaignCreate getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

