/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: marketing/v1beta1/MarketingService_Beta1.proto

package io.bloombox.schema.services.marketing.v1beta1;

/**
 * <pre>
 * Represents an RPC operation to list marketing campaigns for a given partner/location context.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.CampaignList}
 */
public  final class CampaignList extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.services.marketing.v1beta1.CampaignList)
    CampaignListOrBuilder {
private static final long serialVersionUID = 0L;
  // Use CampaignList.newBuilder() to construct.
  private CampaignList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private CampaignList() {
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private CampaignList(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignList_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignList_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.services.marketing.v1beta1.CampaignList.class, io.bloombox.schema.services.marketing.v1beta1.CampaignList.Builder.class);
  }

  public interface RequestOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.marketing.v1beta1.CampaignList.Request)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Partnership scope for the request.
     * </pre>
     *
     * <code>string partner = 1;</code>
     */
    java.lang.String getPartner();
    /**
     * <pre>
     * Partnership scope for the request.
     * </pre>
     *
     * <code>string partner = 1;</code>
     */
    com.google.protobuf.ByteString
        getPartnerBytes();

    /**
     * <pre>
     * Location scope for the request.
     * </pre>
     *
     * <code>string location = 2;</code>
     */
    java.lang.String getLocation();
    /**
     * <pre>
     * Location scope for the request.
     * </pre>
     *
     * <code>string location = 2;</code>
     */
    com.google.protobuf.ByteString
        getLocationBytes();
  }
  /**
   * <pre>
   * Request to list marketing campaigns.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.CampaignList.Request}
   */
  public  static final class Request extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.marketing.v1beta1.CampaignList.Request)
      RequestOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Request.newBuilder() to construct.
    private Request(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Request() {
      partner_ = "";
      location_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Request(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              partner_ = s;
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();

              location_ = s;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignList_Request_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignList_Request_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request.class, io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request.Builder.class);
    }

    public static final int PARTNER_FIELD_NUMBER = 1;
    private volatile java.lang.Object partner_;
    /**
     * <pre>
     * Partnership scope for the request.
     * </pre>
     *
     * <code>string partner = 1;</code>
     */
    public java.lang.String getPartner() {
      java.lang.Object ref = partner_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        partner_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Partnership scope for the request.
     * </pre>
     *
     * <code>string partner = 1;</code>
     */
    public com.google.protobuf.ByteString
        getPartnerBytes() {
      java.lang.Object ref = partner_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        partner_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LOCATION_FIELD_NUMBER = 2;
    private volatile java.lang.Object location_;
    /**
     * <pre>
     * Location scope for the request.
     * </pre>
     *
     * <code>string location = 2;</code>
     */
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Location scope for the request.
     * </pre>
     *
     * <code>string location = 2;</code>
     */
    public com.google.protobuf.ByteString
        getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getPartnerBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, partner_);
      }
      if (!getLocationBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, location_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getPartnerBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, partner_);
      }
      if (!getLocationBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, location_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request other = (io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request) obj;

      boolean result = true;
      result = result && getPartner()
          .equals(other.getPartner());
      result = result && getLocation()
          .equals(other.getLocation());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PARTNER_FIELD_NUMBER;
      hash = (53 * hash) + getPartner().hashCode();
      hash = (37 * hash) + LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getLocation().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Request to list marketing campaigns.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.CampaignList.Request}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.marketing.v1beta1.CampaignList.Request)
        io.bloombox.schema.services.marketing.v1beta1.CampaignList.RequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignList_Request_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignList_Request_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request.class, io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request.Builder.class);
      }

      // Construct using io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        partner_ = "";

        location_ = "";

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignList_Request_descriptor;
      }

      public io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request getDefaultInstanceForType() {
        return io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request.getDefaultInstance();
      }

      public io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request build() {
        io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request buildPartial() {
        io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request result = new io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request(this);
        result.partner_ = partner_;
        result.location_ = location_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request) {
          return mergeFrom((io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request other) {
        if (other == io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request.getDefaultInstance()) return this;
        if (!other.getPartner().isEmpty()) {
          partner_ = other.partner_;
          onChanged();
        }
        if (!other.getLocation().isEmpty()) {
          location_ = other.location_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object partner_ = "";
      /**
       * <pre>
       * Partnership scope for the request.
       * </pre>
       *
       * <code>string partner = 1;</code>
       */
      public java.lang.String getPartner() {
        java.lang.Object ref = partner_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          partner_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Partnership scope for the request.
       * </pre>
       *
       * <code>string partner = 1;</code>
       */
      public com.google.protobuf.ByteString
          getPartnerBytes() {
        java.lang.Object ref = partner_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          partner_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Partnership scope for the request.
       * </pre>
       *
       * <code>string partner = 1;</code>
       */
      public Builder setPartner(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        partner_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Partnership scope for the request.
       * </pre>
       *
       * <code>string partner = 1;</code>
       */
      public Builder clearPartner() {
        
        partner_ = getDefaultInstance().getPartner();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Partnership scope for the request.
       * </pre>
       *
       * <code>string partner = 1;</code>
       */
      public Builder setPartnerBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        partner_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object location_ = "";
      /**
       * <pre>
       * Location scope for the request.
       * </pre>
       *
       * <code>string location = 2;</code>
       */
      public java.lang.String getLocation() {
        java.lang.Object ref = location_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          location_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Location scope for the request.
       * </pre>
       *
       * <code>string location = 2;</code>
       */
      public com.google.protobuf.ByteString
          getLocationBytes() {
        java.lang.Object ref = location_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          location_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Location scope for the request.
       * </pre>
       *
       * <code>string location = 2;</code>
       */
      public Builder setLocation(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        location_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Location scope for the request.
       * </pre>
       *
       * <code>string location = 2;</code>
       */
      public Builder clearLocation() {
        
        location_ = getDefaultInstance().getLocation();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Location scope for the request.
       * </pre>
       *
       * <code>string location = 2;</code>
       */
      public Builder setLocationBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        location_ = value;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.marketing.v1beta1.CampaignList.Request)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.marketing.v1beta1.CampaignList.Request)
    private static final io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request();
    }

    public static io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Request>
        PARSER = new com.google.protobuf.AbstractParser<Request>() {
      public Request parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Request(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Request> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Request> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.marketing.v1beta1.CampaignList.Request getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ResponseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.marketing.v1beta1.CampaignList.Response)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Campaigns for a given partner/location pair.
     * </pre>
     *
     * <code>repeated .bloombox.schema.services.marketing.v1beta1.CampaignSummary campaign = 1;</code>
     */
    java.util.List<io.bloombox.schema.services.marketing.v1beta1.CampaignSummary> 
        getCampaignList();
    /**
     * <pre>
     * Campaigns for a given partner/location pair.
     * </pre>
     *
     * <code>repeated .bloombox.schema.services.marketing.v1beta1.CampaignSummary campaign = 1;</code>
     */
    io.bloombox.schema.services.marketing.v1beta1.CampaignSummary getCampaign(int index);
    /**
     * <pre>
     * Campaigns for a given partner/location pair.
     * </pre>
     *
     * <code>repeated .bloombox.schema.services.marketing.v1beta1.CampaignSummary campaign = 1;</code>
     */
    int getCampaignCount();
    /**
     * <pre>
     * Campaigns for a given partner/location pair.
     * </pre>
     *
     * <code>repeated .bloombox.schema.services.marketing.v1beta1.CampaignSummary campaign = 1;</code>
     */
    java.util.List<? extends io.bloombox.schema.services.marketing.v1beta1.CampaignSummaryOrBuilder> 
        getCampaignOrBuilderList();
    /**
     * <pre>
     * Campaigns for a given partner/location pair.
     * </pre>
     *
     * <code>repeated .bloombox.schema.services.marketing.v1beta1.CampaignSummary campaign = 1;</code>
     */
    io.bloombox.schema.services.marketing.v1beta1.CampaignSummaryOrBuilder getCampaignOrBuilder(
        int index);
  }
  /**
   * <pre>
   * Response to a request to list marketing campaigns.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.CampaignList.Response}
   */
  public  static final class Response extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.marketing.v1beta1.CampaignList.Response)
      ResponseOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Response.newBuilder() to construct.
    private Response(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Response() {
      campaign_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Response(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                campaign_ = new java.util.ArrayList<io.bloombox.schema.services.marketing.v1beta1.CampaignSummary>();
                mutable_bitField0_ |= 0x00000001;
              }
              campaign_.add(
                  input.readMessage(io.bloombox.schema.services.marketing.v1beta1.CampaignSummary.parser(), extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          campaign_ = java.util.Collections.unmodifiableList(campaign_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignList_Response_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignList_Response_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response.class, io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response.Builder.class);
    }

    public static final int CAMPAIGN_FIELD_NUMBER = 1;
    private java.util.List<io.bloombox.schema.services.marketing.v1beta1.CampaignSummary> campaign_;
    /**
     * <pre>
     * Campaigns for a given partner/location pair.
     * </pre>
     *
     * <code>repeated .bloombox.schema.services.marketing.v1beta1.CampaignSummary campaign = 1;</code>
     */
    public java.util.List<io.bloombox.schema.services.marketing.v1beta1.CampaignSummary> getCampaignList() {
      return campaign_;
    }
    /**
     * <pre>
     * Campaigns for a given partner/location pair.
     * </pre>
     *
     * <code>repeated .bloombox.schema.services.marketing.v1beta1.CampaignSummary campaign = 1;</code>
     */
    public java.util.List<? extends io.bloombox.schema.services.marketing.v1beta1.CampaignSummaryOrBuilder> 
        getCampaignOrBuilderList() {
      return campaign_;
    }
    /**
     * <pre>
     * Campaigns for a given partner/location pair.
     * </pre>
     *
     * <code>repeated .bloombox.schema.services.marketing.v1beta1.CampaignSummary campaign = 1;</code>
     */
    public int getCampaignCount() {
      return campaign_.size();
    }
    /**
     * <pre>
     * Campaigns for a given partner/location pair.
     * </pre>
     *
     * <code>repeated .bloombox.schema.services.marketing.v1beta1.CampaignSummary campaign = 1;</code>
     */
    public io.bloombox.schema.services.marketing.v1beta1.CampaignSummary getCampaign(int index) {
      return campaign_.get(index);
    }
    /**
     * <pre>
     * Campaigns for a given partner/location pair.
     * </pre>
     *
     * <code>repeated .bloombox.schema.services.marketing.v1beta1.CampaignSummary campaign = 1;</code>
     */
    public io.bloombox.schema.services.marketing.v1beta1.CampaignSummaryOrBuilder getCampaignOrBuilder(
        int index) {
      return campaign_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      for (int i = 0; i < campaign_.size(); i++) {
        output.writeMessage(1, campaign_.get(i));
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < campaign_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, campaign_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response other = (io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response) obj;

      boolean result = true;
      result = result && getCampaignList()
          .equals(other.getCampaignList());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getCampaignCount() > 0) {
        hash = (37 * hash) + CAMPAIGN_FIELD_NUMBER;
        hash = (53 * hash) + getCampaignList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Response to a request to list marketing campaigns.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.CampaignList.Response}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.marketing.v1beta1.CampaignList.Response)
        io.bloombox.schema.services.marketing.v1beta1.CampaignList.ResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignList_Response_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignList_Response_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response.class, io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response.Builder.class);
      }

      // Construct using io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getCampaignFieldBuilder();
        }
      }
      public Builder clear() {
        super.clear();
        if (campaignBuilder_ == null) {
          campaign_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          campaignBuilder_.clear();
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignList_Response_descriptor;
      }

      public io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response getDefaultInstanceForType() {
        return io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response.getDefaultInstance();
      }

      public io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response build() {
        io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response buildPartial() {
        io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response result = new io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response(this);
        int from_bitField0_ = bitField0_;
        if (campaignBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)) {
            campaign_ = java.util.Collections.unmodifiableList(campaign_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.campaign_ = campaign_;
        } else {
          result.campaign_ = campaignBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response) {
          return mergeFrom((io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response other) {
        if (other == io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response.getDefaultInstance()) return this;
        if (campaignBuilder_ == null) {
          if (!other.campaign_.isEmpty()) {
            if (campaign_.isEmpty()) {
              campaign_ = other.campaign_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureCampaignIsMutable();
              campaign_.addAll(other.campaign_);
            }
            onChanged();
          }
        } else {
          if (!other.campaign_.isEmpty()) {
            if (campaignBuilder_.isEmpty()) {
              campaignBuilder_.dispose();
              campaignBuilder_ = null;
              campaign_ = other.campaign_;
              bitField0_ = (bitField0_ & ~0x00000001);
              campaignBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getCampaignFieldBuilder() : null;
            } else {
              campaignBuilder_.addAllMessages(other.campaign_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.util.List<io.bloombox.schema.services.marketing.v1beta1.CampaignSummary> campaign_ =
        java.util.Collections.emptyList();
      private void ensureCampaignIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          campaign_ = new java.util.ArrayList<io.bloombox.schema.services.marketing.v1beta1.CampaignSummary>(campaign_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.bloombox.schema.services.marketing.v1beta1.CampaignSummary, io.bloombox.schema.services.marketing.v1beta1.CampaignSummary.Builder, io.bloombox.schema.services.marketing.v1beta1.CampaignSummaryOrBuilder> campaignBuilder_;

      /**
       * <pre>
       * Campaigns for a given partner/location pair.
       * </pre>
       *
       * <code>repeated .bloombox.schema.services.marketing.v1beta1.CampaignSummary campaign = 1;</code>
       */
      public java.util.List<io.bloombox.schema.services.marketing.v1beta1.CampaignSummary> getCampaignList() {
        if (campaignBuilder_ == null) {
          return java.util.Collections.unmodifiableList(campaign_);
        } else {
          return campaignBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Campaigns for a given partner/location pair.
       * </pre>
       *
       * <code>repeated .bloombox.schema.services.marketing.v1beta1.CampaignSummary campaign = 1;</code>
       */
      public int getCampaignCount() {
        if (campaignBuilder_ == null) {
          return campaign_.size();
        } else {
          return campaignBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Campaigns for a given partner/location pair.
       * </pre>
       *
       * <code>repeated .bloombox.schema.services.marketing.v1beta1.CampaignSummary campaign = 1;</code>
       */
      public io.bloombox.schema.services.marketing.v1beta1.CampaignSummary getCampaign(int index) {
        if (campaignBuilder_ == null) {
          return campaign_.get(index);
        } else {
          return campaignBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Campaigns for a given partner/location pair.
       * </pre>
       *
       * <code>repeated .bloombox.schema.services.marketing.v1beta1.CampaignSummary campaign = 1;</code>
       */
      public Builder setCampaign(
          int index, io.bloombox.schema.services.marketing.v1beta1.CampaignSummary value) {
        if (campaignBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCampaignIsMutable();
          campaign_.set(index, value);
          onChanged();
        } else {
          campaignBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Campaigns for a given partner/location pair.
       * </pre>
       *
       * <code>repeated .bloombox.schema.services.marketing.v1beta1.CampaignSummary campaign = 1;</code>
       */
      public Builder setCampaign(
          int index, io.bloombox.schema.services.marketing.v1beta1.CampaignSummary.Builder builderForValue) {
        if (campaignBuilder_ == null) {
          ensureCampaignIsMutable();
          campaign_.set(index, builderForValue.build());
          onChanged();
        } else {
          campaignBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Campaigns for a given partner/location pair.
       * </pre>
       *
       * <code>repeated .bloombox.schema.services.marketing.v1beta1.CampaignSummary campaign = 1;</code>
       */
      public Builder addCampaign(io.bloombox.schema.services.marketing.v1beta1.CampaignSummary value) {
        if (campaignBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCampaignIsMutable();
          campaign_.add(value);
          onChanged();
        } else {
          campaignBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Campaigns for a given partner/location pair.
       * </pre>
       *
       * <code>repeated .bloombox.schema.services.marketing.v1beta1.CampaignSummary campaign = 1;</code>
       */
      public Builder addCampaign(
          int index, io.bloombox.schema.services.marketing.v1beta1.CampaignSummary value) {
        if (campaignBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureCampaignIsMutable();
          campaign_.add(index, value);
          onChanged();
        } else {
          campaignBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Campaigns for a given partner/location pair.
       * </pre>
       *
       * <code>repeated .bloombox.schema.services.marketing.v1beta1.CampaignSummary campaign = 1;</code>
       */
      public Builder addCampaign(
          io.bloombox.schema.services.marketing.v1beta1.CampaignSummary.Builder builderForValue) {
        if (campaignBuilder_ == null) {
          ensureCampaignIsMutable();
          campaign_.add(builderForValue.build());
          onChanged();
        } else {
          campaignBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Campaigns for a given partner/location pair.
       * </pre>
       *
       * <code>repeated .bloombox.schema.services.marketing.v1beta1.CampaignSummary campaign = 1;</code>
       */
      public Builder addCampaign(
          int index, io.bloombox.schema.services.marketing.v1beta1.CampaignSummary.Builder builderForValue) {
        if (campaignBuilder_ == null) {
          ensureCampaignIsMutable();
          campaign_.add(index, builderForValue.build());
          onChanged();
        } else {
          campaignBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Campaigns for a given partner/location pair.
       * </pre>
       *
       * <code>repeated .bloombox.schema.services.marketing.v1beta1.CampaignSummary campaign = 1;</code>
       */
      public Builder addAllCampaign(
          java.lang.Iterable<? extends io.bloombox.schema.services.marketing.v1beta1.CampaignSummary> values) {
        if (campaignBuilder_ == null) {
          ensureCampaignIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, campaign_);
          onChanged();
        } else {
          campaignBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Campaigns for a given partner/location pair.
       * </pre>
       *
       * <code>repeated .bloombox.schema.services.marketing.v1beta1.CampaignSummary campaign = 1;</code>
       */
      public Builder clearCampaign() {
        if (campaignBuilder_ == null) {
          campaign_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          campaignBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Campaigns for a given partner/location pair.
       * </pre>
       *
       * <code>repeated .bloombox.schema.services.marketing.v1beta1.CampaignSummary campaign = 1;</code>
       */
      public Builder removeCampaign(int index) {
        if (campaignBuilder_ == null) {
          ensureCampaignIsMutable();
          campaign_.remove(index);
          onChanged();
        } else {
          campaignBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Campaigns for a given partner/location pair.
       * </pre>
       *
       * <code>repeated .bloombox.schema.services.marketing.v1beta1.CampaignSummary campaign = 1;</code>
       */
      public io.bloombox.schema.services.marketing.v1beta1.CampaignSummary.Builder getCampaignBuilder(
          int index) {
        return getCampaignFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Campaigns for a given partner/location pair.
       * </pre>
       *
       * <code>repeated .bloombox.schema.services.marketing.v1beta1.CampaignSummary campaign = 1;</code>
       */
      public io.bloombox.schema.services.marketing.v1beta1.CampaignSummaryOrBuilder getCampaignOrBuilder(
          int index) {
        if (campaignBuilder_ == null) {
          return campaign_.get(index);  } else {
          return campaignBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Campaigns for a given partner/location pair.
       * </pre>
       *
       * <code>repeated .bloombox.schema.services.marketing.v1beta1.CampaignSummary campaign = 1;</code>
       */
      public java.util.List<? extends io.bloombox.schema.services.marketing.v1beta1.CampaignSummaryOrBuilder> 
           getCampaignOrBuilderList() {
        if (campaignBuilder_ != null) {
          return campaignBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(campaign_);
        }
      }
      /**
       * <pre>
       * Campaigns for a given partner/location pair.
       * </pre>
       *
       * <code>repeated .bloombox.schema.services.marketing.v1beta1.CampaignSummary campaign = 1;</code>
       */
      public io.bloombox.schema.services.marketing.v1beta1.CampaignSummary.Builder addCampaignBuilder() {
        return getCampaignFieldBuilder().addBuilder(
            io.bloombox.schema.services.marketing.v1beta1.CampaignSummary.getDefaultInstance());
      }
      /**
       * <pre>
       * Campaigns for a given partner/location pair.
       * </pre>
       *
       * <code>repeated .bloombox.schema.services.marketing.v1beta1.CampaignSummary campaign = 1;</code>
       */
      public io.bloombox.schema.services.marketing.v1beta1.CampaignSummary.Builder addCampaignBuilder(
          int index) {
        return getCampaignFieldBuilder().addBuilder(
            index, io.bloombox.schema.services.marketing.v1beta1.CampaignSummary.getDefaultInstance());
      }
      /**
       * <pre>
       * Campaigns for a given partner/location pair.
       * </pre>
       *
       * <code>repeated .bloombox.schema.services.marketing.v1beta1.CampaignSummary campaign = 1;</code>
       */
      public java.util.List<io.bloombox.schema.services.marketing.v1beta1.CampaignSummary.Builder> 
           getCampaignBuilderList() {
        return getCampaignFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.bloombox.schema.services.marketing.v1beta1.CampaignSummary, io.bloombox.schema.services.marketing.v1beta1.CampaignSummary.Builder, io.bloombox.schema.services.marketing.v1beta1.CampaignSummaryOrBuilder> 
          getCampaignFieldBuilder() {
        if (campaignBuilder_ == null) {
          campaignBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              io.bloombox.schema.services.marketing.v1beta1.CampaignSummary, io.bloombox.schema.services.marketing.v1beta1.CampaignSummary.Builder, io.bloombox.schema.services.marketing.v1beta1.CampaignSummaryOrBuilder>(
                  campaign_,
                  ((bitField0_ & 0x00000001) == 0x00000001),
                  getParentForChildren(),
                  isClean());
          campaign_ = null;
        }
        return campaignBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.marketing.v1beta1.CampaignList.Response)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.marketing.v1beta1.CampaignList.Response)
    private static final io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response();
    }

    public static io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Response>
        PARSER = new com.google.protobuf.AbstractParser<Response>() {
      public Response parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Response(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Response> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Response> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.marketing.v1beta1.CampaignList.Response getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.services.marketing.v1beta1.CampaignList)) {
      return super.equals(obj);
    }
    io.bloombox.schema.services.marketing.v1beta1.CampaignList other = (io.bloombox.schema.services.marketing.v1beta1.CampaignList) obj;

    boolean result = true;
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.services.marketing.v1beta1.CampaignList parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.CampaignList parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.CampaignList parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.CampaignList parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.CampaignList parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.CampaignList parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.CampaignList parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.CampaignList parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.CampaignList parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.CampaignList parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.CampaignList parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.CampaignList parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.services.marketing.v1beta1.CampaignList prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Represents an RPC operation to list marketing campaigns for a given partner/location context.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.CampaignList}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.services.marketing.v1beta1.CampaignList)
      io.bloombox.schema.services.marketing.v1beta1.CampaignListOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignList_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignList_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.marketing.v1beta1.CampaignList.class, io.bloombox.schema.services.marketing.v1beta1.CampaignList.Builder.class);
    }

    // Construct using io.bloombox.schema.services.marketing.v1beta1.CampaignList.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignList_descriptor;
    }

    public io.bloombox.schema.services.marketing.v1beta1.CampaignList getDefaultInstanceForType() {
      return io.bloombox.schema.services.marketing.v1beta1.CampaignList.getDefaultInstance();
    }

    public io.bloombox.schema.services.marketing.v1beta1.CampaignList build() {
      io.bloombox.schema.services.marketing.v1beta1.CampaignList result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.services.marketing.v1beta1.CampaignList buildPartial() {
      io.bloombox.schema.services.marketing.v1beta1.CampaignList result = new io.bloombox.schema.services.marketing.v1beta1.CampaignList(this);
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.services.marketing.v1beta1.CampaignList) {
        return mergeFrom((io.bloombox.schema.services.marketing.v1beta1.CampaignList)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.services.marketing.v1beta1.CampaignList other) {
      if (other == io.bloombox.schema.services.marketing.v1beta1.CampaignList.getDefaultInstance()) return this;
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.services.marketing.v1beta1.CampaignList parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.services.marketing.v1beta1.CampaignList) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.services.marketing.v1beta1.CampaignList)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.services.marketing.v1beta1.CampaignList)
  private static final io.bloombox.schema.services.marketing.v1beta1.CampaignList DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.services.marketing.v1beta1.CampaignList();
  }

  public static io.bloombox.schema.services.marketing.v1beta1.CampaignList getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CampaignList>
      PARSER = new com.google.protobuf.AbstractParser<CampaignList>() {
    public CampaignList parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new CampaignList(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<CampaignList> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CampaignList> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.services.marketing.v1beta1.CampaignList getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

