/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: marketing/v1beta1/MarketingService_Beta1.proto

package io.bloombox.schema.services.marketing.v1beta1;

/**
 * <pre>
 * Campaign summary payload for listing campaigns, given a particular scope.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.CampaignSummary}
 */
public  final class CampaignSummary extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.services.marketing.v1beta1.CampaignSummary)
    CampaignSummaryOrBuilder {
private static final long serialVersionUID = 0L;
  // Use CampaignSummary.newBuilder() to construct.
  private CampaignSummary(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private CampaignSummary() {
    name_ = "";
    description_ = "";
    live_ = false;
    status_ = 0;
    sms_ = false;
    email_ = false;
    tag_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private CampaignSummary(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 10: {
            io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.Builder subBuilder = null;
            if (key_ != null) {
              subBuilder = key_.toBuilder();
            }
            key_ = input.readMessage(io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(key_);
              key_ = subBuilder.buildPartial();
            }

            break;
          }
          case 18: {
            java.lang.String s = input.readStringRequireUtf8();

            name_ = s;
            break;
          }
          case 26: {
            java.lang.String s = input.readStringRequireUtf8();

            description_ = s;
            break;
          }
          case 32: {

            live_ = input.readBool();
            break;
          }
          case 40: {
            int rawValue = input.readEnum();

            status_ = rawValue;
            break;
          }
          case 48: {

            sms_ = input.readBool();
            break;
          }
          case 56: {

            email_ = input.readBool();
            break;
          }
          case 66: {
            if (!((mutable_bitField0_ & 0x00000080) == 0x00000080)) {
              tag_ = new java.util.ArrayList<io.bloombox.schema.marketing.MarketingCampaign.CampaignTag>();
              mutable_bitField0_ |= 0x00000080;
            }
            tag_.add(
                input.readMessage(io.bloombox.schema.marketing.MarketingCampaign.CampaignTag.parser(), extensionRegistry));
            break;
          }
          case 74: {
            io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
            if (modified_ != null) {
              subBuilder = modified_.toBuilder();
            }
            modified_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(modified_);
              modified_ = subBuilder.buildPartial();
            }

            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000080) == 0x00000080)) {
        tag_ = java.util.Collections.unmodifiableList(tag_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignSummary_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignSummary_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.services.marketing.v1beta1.CampaignSummary.class, io.bloombox.schema.services.marketing.v1beta1.CampaignSummary.Builder.class);
  }

  private int bitField0_;
  public static final int KEY_FIELD_NUMBER = 1;
  private io.bloombox.schema.marketing.MarketingCampaign.CampaignKey key_;
  /**
   * <pre>
   * Key for the underlying campaign.
   * </pre>
   *
   * <code>.bloombox.schema.marketing.CampaignKey key = 1;</code>
   */
  public boolean hasKey() {
    return key_ != null;
  }
  /**
   * <pre>
   * Key for the underlying campaign.
   * </pre>
   *
   * <code>.bloombox.schema.marketing.CampaignKey key = 1;</code>
   */
  public io.bloombox.schema.marketing.MarketingCampaign.CampaignKey getKey() {
    return key_ == null ? io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.getDefaultInstance() : key_;
  }
  /**
   * <pre>
   * Key for the underlying campaign.
   * </pre>
   *
   * <code>.bloombox.schema.marketing.CampaignKey key = 1;</code>
   */
  public io.bloombox.schema.marketing.MarketingCampaign.CampaignKeyOrBuilder getKeyOrBuilder() {
    return getKey();
  }

  public static final int NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object name_;
  /**
   * <pre>
   * Name for the campaign object.
   * </pre>
   *
   * <code>string name = 2;</code>
   */
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Name for the campaign object.
   * </pre>
   *
   * <code>string name = 2;</code>
   */
  public com.google.protobuf.ByteString
      getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;
  private volatile java.lang.Object description_;
  /**
   * <pre>
   * Description for the campaign object.
   * </pre>
   *
   * <code>string description = 3;</code>
   */
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Description for the campaign object.
   * </pre>
   *
   * <code>string description = 3;</code>
   */
  public com.google.protobuf.ByteString
      getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LIVE_FIELD_NUMBER = 4;
  private boolean live_;
  /**
   * <pre>
   * Whether the underlying campaign is live.
   * </pre>
   *
   * <code>bool live = 4;</code>
   */
  public boolean getLive() {
    return live_;
  }

  public static final int STATUS_FIELD_NUMBER = 5;
  private int status_;
  /**
   * <pre>
   * Current status of the campaign.
   * </pre>
   *
   * <code>.bloombox.schema.marketing.CampaignStatus status = 5;</code>
   */
  public int getStatusValue() {
    return status_;
  }
  /**
   * <pre>
   * Current status of the campaign.
   * </pre>
   *
   * <code>.bloombox.schema.marketing.CampaignStatus status = 5;</code>
   */
  public io.bloombox.schema.marketing.MarketingCampaign.CampaignStatus getStatus() {
    io.bloombox.schema.marketing.MarketingCampaign.CampaignStatus result = io.bloombox.schema.marketing.MarketingCampaign.CampaignStatus.valueOf(status_);
    return result == null ? io.bloombox.schema.marketing.MarketingCampaign.CampaignStatus.UNRECOGNIZED : result;
  }

  public static final int SMS_FIELD_NUMBER = 6;
  private boolean sms_;
  /**
   * <pre>
   * Whether this campaign supports SMS.
   * </pre>
   *
   * <code>bool sms = 6;</code>
   */
  public boolean getSms() {
    return sms_;
  }

  public static final int EMAIL_FIELD_NUMBER = 7;
  private boolean email_;
  /**
   * <pre>
   * Whether this campaign supports email.
   * </pre>
   *
   * <code>bool email = 7;</code>
   */
  public boolean getEmail() {
    return email_;
  }

  public static final int TAG_FIELD_NUMBER = 8;
  private java.util.List<io.bloombox.schema.marketing.MarketingCampaign.CampaignTag> tag_;
  /**
   * <pre>
   * Tags for the campaign object.
   * </pre>
   *
   * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8;</code>
   */
  public java.util.List<io.bloombox.schema.marketing.MarketingCampaign.CampaignTag> getTagList() {
    return tag_;
  }
  /**
   * <pre>
   * Tags for the campaign object.
   * </pre>
   *
   * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8;</code>
   */
  public java.util.List<? extends io.bloombox.schema.marketing.MarketingCampaign.CampaignTagOrBuilder> 
      getTagOrBuilderList() {
    return tag_;
  }
  /**
   * <pre>
   * Tags for the campaign object.
   * </pre>
   *
   * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8;</code>
   */
  public int getTagCount() {
    return tag_.size();
  }
  /**
   * <pre>
   * Tags for the campaign object.
   * </pre>
   *
   * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8;</code>
   */
  public io.bloombox.schema.marketing.MarketingCampaign.CampaignTag getTag(int index) {
    return tag_.get(index);
  }
  /**
   * <pre>
   * Tags for the campaign object.
   * </pre>
   *
   * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8;</code>
   */
  public io.bloombox.schema.marketing.MarketingCampaign.CampaignTagOrBuilder getTagOrBuilder(
      int index) {
    return tag_.get(index);
  }

  public static final int MODIFIED_FIELD_NUMBER = 9;
  private io.opencannabis.schema.temporal.Instant modified_;
  /**
   * <pre>
   * When the subject campaign was last modified.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant modified = 9;</code>
   */
  public boolean hasModified() {
    return modified_ != null;
  }
  /**
   * <pre>
   * When the subject campaign was last modified.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant modified = 9;</code>
   */
  public io.opencannabis.schema.temporal.Instant getModified() {
    return modified_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : modified_;
  }
  /**
   * <pre>
   * When the subject campaign was last modified.
   * </pre>
   *
   * <code>.opencannabis.temporal.Instant modified = 9;</code>
   */
  public io.opencannabis.schema.temporal.InstantOrBuilder getModifiedOrBuilder() {
    return getModified();
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (key_ != null) {
      output.writeMessage(1, getKey());
    }
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, name_);
    }
    if (!getDescriptionBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    if (live_ != false) {
      output.writeBool(4, live_);
    }
    if (status_ != io.bloombox.schema.marketing.MarketingCampaign.CampaignStatus.PENDING.getNumber()) {
      output.writeEnum(5, status_);
    }
    if (sms_ != false) {
      output.writeBool(6, sms_);
    }
    if (email_ != false) {
      output.writeBool(7, email_);
    }
    for (int i = 0; i < tag_.size(); i++) {
      output.writeMessage(8, tag_.get(i));
    }
    if (modified_ != null) {
      output.writeMessage(9, getModified());
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (key_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(1, getKey());
    }
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, name_);
    }
    if (!getDescriptionBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    if (live_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(4, live_);
    }
    if (status_ != io.bloombox.schema.marketing.MarketingCampaign.CampaignStatus.PENDING.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(5, status_);
    }
    if (sms_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(6, sms_);
    }
    if (email_ != false) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(7, email_);
    }
    for (int i = 0; i < tag_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(8, tag_.get(i));
    }
    if (modified_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(9, getModified());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.services.marketing.v1beta1.CampaignSummary)) {
      return super.equals(obj);
    }
    io.bloombox.schema.services.marketing.v1beta1.CampaignSummary other = (io.bloombox.schema.services.marketing.v1beta1.CampaignSummary) obj;

    boolean result = true;
    result = result && (hasKey() == other.hasKey());
    if (hasKey()) {
      result = result && getKey()
          .equals(other.getKey());
    }
    result = result && getName()
        .equals(other.getName());
    result = result && getDescription()
        .equals(other.getDescription());
    result = result && (getLive()
        == other.getLive());
    result = result && status_ == other.status_;
    result = result && (getSms()
        == other.getSms());
    result = result && (getEmail()
        == other.getEmail());
    result = result && getTagList()
        .equals(other.getTagList());
    result = result && (hasModified() == other.hasModified());
    if (hasModified()) {
      result = result && getModified()
          .equals(other.getModified());
    }
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasKey()) {
      hash = (37 * hash) + KEY_FIELD_NUMBER;
      hash = (53 * hash) + getKey().hashCode();
    }
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + LIVE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getLive());
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + status_;
    hash = (37 * hash) + SMS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getSms());
    hash = (37 * hash) + EMAIL_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
        getEmail());
    if (getTagCount() > 0) {
      hash = (37 * hash) + TAG_FIELD_NUMBER;
      hash = (53 * hash) + getTagList().hashCode();
    }
    if (hasModified()) {
      hash = (37 * hash) + MODIFIED_FIELD_NUMBER;
      hash = (53 * hash) + getModified().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.services.marketing.v1beta1.CampaignSummary parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.CampaignSummary parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.CampaignSummary parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.CampaignSummary parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.CampaignSummary parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.CampaignSummary parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.CampaignSummary parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.CampaignSummary parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.CampaignSummary parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.CampaignSummary parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.CampaignSummary parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.marketing.v1beta1.CampaignSummary parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.services.marketing.v1beta1.CampaignSummary prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Campaign summary payload for listing campaigns, given a particular scope.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.marketing.v1beta1.CampaignSummary}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.services.marketing.v1beta1.CampaignSummary)
      io.bloombox.schema.services.marketing.v1beta1.CampaignSummaryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignSummary_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignSummary_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.marketing.v1beta1.CampaignSummary.class, io.bloombox.schema.services.marketing.v1beta1.CampaignSummary.Builder.class);
    }

    // Construct using io.bloombox.schema.services.marketing.v1beta1.CampaignSummary.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getTagFieldBuilder();
      }
    }
    public Builder clear() {
      super.clear();
      if (keyBuilder_ == null) {
        key_ = null;
      } else {
        key_ = null;
        keyBuilder_ = null;
      }
      name_ = "";

      description_ = "";

      live_ = false;

      status_ = 0;

      sms_ = false;

      email_ = false;

      if (tagBuilder_ == null) {
        tag_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
      } else {
        tagBuilder_.clear();
      }
      if (modifiedBuilder_ == null) {
        modified_ = null;
      } else {
        modified_ = null;
        modifiedBuilder_ = null;
      }
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.services.marketing.v1beta1.MarketingServiceBeta1.internal_static_bloombox_schema_services_marketing_v1beta1_CampaignSummary_descriptor;
    }

    public io.bloombox.schema.services.marketing.v1beta1.CampaignSummary getDefaultInstanceForType() {
      return io.bloombox.schema.services.marketing.v1beta1.CampaignSummary.getDefaultInstance();
    }

    public io.bloombox.schema.services.marketing.v1beta1.CampaignSummary build() {
      io.bloombox.schema.services.marketing.v1beta1.CampaignSummary result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.services.marketing.v1beta1.CampaignSummary buildPartial() {
      io.bloombox.schema.services.marketing.v1beta1.CampaignSummary result = new io.bloombox.schema.services.marketing.v1beta1.CampaignSummary(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (keyBuilder_ == null) {
        result.key_ = key_;
      } else {
        result.key_ = keyBuilder_.build();
      }
      result.name_ = name_;
      result.description_ = description_;
      result.live_ = live_;
      result.status_ = status_;
      result.sms_ = sms_;
      result.email_ = email_;
      if (tagBuilder_ == null) {
        if (((bitField0_ & 0x00000080) == 0x00000080)) {
          tag_ = java.util.Collections.unmodifiableList(tag_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.tag_ = tag_;
      } else {
        result.tag_ = tagBuilder_.build();
      }
      if (modifiedBuilder_ == null) {
        result.modified_ = modified_;
      } else {
        result.modified_ = modifiedBuilder_.build();
      }
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.services.marketing.v1beta1.CampaignSummary) {
        return mergeFrom((io.bloombox.schema.services.marketing.v1beta1.CampaignSummary)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.services.marketing.v1beta1.CampaignSummary other) {
      if (other == io.bloombox.schema.services.marketing.v1beta1.CampaignSummary.getDefaultInstance()) return this;
      if (other.hasKey()) {
        mergeKey(other.getKey());
      }
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        onChanged();
      }
      if (other.getLive() != false) {
        setLive(other.getLive());
      }
      if (other.status_ != 0) {
        setStatusValue(other.getStatusValue());
      }
      if (other.getSms() != false) {
        setSms(other.getSms());
      }
      if (other.getEmail() != false) {
        setEmail(other.getEmail());
      }
      if (tagBuilder_ == null) {
        if (!other.tag_.isEmpty()) {
          if (tag_.isEmpty()) {
            tag_ = other.tag_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensureTagIsMutable();
            tag_.addAll(other.tag_);
          }
          onChanged();
        }
      } else {
        if (!other.tag_.isEmpty()) {
          if (tagBuilder_.isEmpty()) {
            tagBuilder_.dispose();
            tagBuilder_ = null;
            tag_ = other.tag_;
            bitField0_ = (bitField0_ & ~0x00000080);
            tagBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getTagFieldBuilder() : null;
          } else {
            tagBuilder_.addAllMessages(other.tag_);
          }
        }
      }
      if (other.hasModified()) {
        mergeModified(other.getModified());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.services.marketing.v1beta1.CampaignSummary parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.services.marketing.v1beta1.CampaignSummary) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private io.bloombox.schema.marketing.MarketingCampaign.CampaignKey key_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.marketing.MarketingCampaign.CampaignKey, io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.Builder, io.bloombox.schema.marketing.MarketingCampaign.CampaignKeyOrBuilder> keyBuilder_;
    /**
     * <pre>
     * Key for the underlying campaign.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignKey key = 1;</code>
     */
    public boolean hasKey() {
      return keyBuilder_ != null || key_ != null;
    }
    /**
     * <pre>
     * Key for the underlying campaign.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignKey key = 1;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.CampaignKey getKey() {
      if (keyBuilder_ == null) {
        return key_ == null ? io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.getDefaultInstance() : key_;
      } else {
        return keyBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Key for the underlying campaign.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignKey key = 1;</code>
     */
    public Builder setKey(io.bloombox.schema.marketing.MarketingCampaign.CampaignKey value) {
      if (keyBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        key_ = value;
        onChanged();
      } else {
        keyBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Key for the underlying campaign.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignKey key = 1;</code>
     */
    public Builder setKey(
        io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.Builder builderForValue) {
      if (keyBuilder_ == null) {
        key_ = builderForValue.build();
        onChanged();
      } else {
        keyBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Key for the underlying campaign.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignKey key = 1;</code>
     */
    public Builder mergeKey(io.bloombox.schema.marketing.MarketingCampaign.CampaignKey value) {
      if (keyBuilder_ == null) {
        if (key_ != null) {
          key_ =
            io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.newBuilder(key_).mergeFrom(value).buildPartial();
        } else {
          key_ = value;
        }
        onChanged();
      } else {
        keyBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Key for the underlying campaign.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignKey key = 1;</code>
     */
    public Builder clearKey() {
      if (keyBuilder_ == null) {
        key_ = null;
        onChanged();
      } else {
        key_ = null;
        keyBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Key for the underlying campaign.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignKey key = 1;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.Builder getKeyBuilder() {
      
      onChanged();
      return getKeyFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Key for the underlying campaign.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignKey key = 1;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.CampaignKeyOrBuilder getKeyOrBuilder() {
      if (keyBuilder_ != null) {
        return keyBuilder_.getMessageOrBuilder();
      } else {
        return key_ == null ?
            io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.getDefaultInstance() : key_;
      }
    }
    /**
     * <pre>
     * Key for the underlying campaign.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignKey key = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.marketing.MarketingCampaign.CampaignKey, io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.Builder, io.bloombox.schema.marketing.MarketingCampaign.CampaignKeyOrBuilder> 
        getKeyFieldBuilder() {
      if (keyBuilder_ == null) {
        keyBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.bloombox.schema.marketing.MarketingCampaign.CampaignKey, io.bloombox.schema.marketing.MarketingCampaign.CampaignKey.Builder, io.bloombox.schema.marketing.MarketingCampaign.CampaignKeyOrBuilder>(
                getKey(),
                getParentForChildren(),
                isClean());
        key_ = null;
      }
      return keyBuilder_;
    }

    private java.lang.Object name_ = "";
    /**
     * <pre>
     * Name for the campaign object.
     * </pre>
     *
     * <code>string name = 2;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Name for the campaign object.
     * </pre>
     *
     * <code>string name = 2;</code>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Name for the campaign object.
     * </pre>
     *
     * <code>string name = 2;</code>
     */
    public Builder setName(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      name_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Name for the campaign object.
     * </pre>
     *
     * <code>string name = 2;</code>
     */
    public Builder clearName() {
      
      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Name for the campaign object.
     * </pre>
     *
     * <code>string name = 2;</code>
     */
    public Builder setNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      name_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     * <pre>
     * Description for the campaign object.
     * </pre>
     *
     * <code>string description = 3;</code>
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Description for the campaign object.
     * </pre>
     *
     * <code>string description = 3;</code>
     */
    public com.google.protobuf.ByteString
        getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Description for the campaign object.
     * </pre>
     *
     * <code>string description = 3;</code>
     */
    public Builder setDescription(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      description_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Description for the campaign object.
     * </pre>
     *
     * <code>string description = 3;</code>
     */
    public Builder clearDescription() {
      
      description_ = getDefaultInstance().getDescription();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Description for the campaign object.
     * </pre>
     *
     * <code>string description = 3;</code>
     */
    public Builder setDescriptionBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      description_ = value;
      onChanged();
      return this;
    }

    private boolean live_ ;
    /**
     * <pre>
     * Whether the underlying campaign is live.
     * </pre>
     *
     * <code>bool live = 4;</code>
     */
    public boolean getLive() {
      return live_;
    }
    /**
     * <pre>
     * Whether the underlying campaign is live.
     * </pre>
     *
     * <code>bool live = 4;</code>
     */
    public Builder setLive(boolean value) {
      
      live_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether the underlying campaign is live.
     * </pre>
     *
     * <code>bool live = 4;</code>
     */
    public Builder clearLive() {
      
      live_ = false;
      onChanged();
      return this;
    }

    private int status_ = 0;
    /**
     * <pre>
     * Current status of the campaign.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignStatus status = 5;</code>
     */
    public int getStatusValue() {
      return status_;
    }
    /**
     * <pre>
     * Current status of the campaign.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignStatus status = 5;</code>
     */
    public Builder setStatusValue(int value) {
      status_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Current status of the campaign.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignStatus status = 5;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.CampaignStatus getStatus() {
      io.bloombox.schema.marketing.MarketingCampaign.CampaignStatus result = io.bloombox.schema.marketing.MarketingCampaign.CampaignStatus.valueOf(status_);
      return result == null ? io.bloombox.schema.marketing.MarketingCampaign.CampaignStatus.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Current status of the campaign.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignStatus status = 5;</code>
     */
    public Builder setStatus(io.bloombox.schema.marketing.MarketingCampaign.CampaignStatus value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      status_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Current status of the campaign.
     * </pre>
     *
     * <code>.bloombox.schema.marketing.CampaignStatus status = 5;</code>
     */
    public Builder clearStatus() {
      
      status_ = 0;
      onChanged();
      return this;
    }

    private boolean sms_ ;
    /**
     * <pre>
     * Whether this campaign supports SMS.
     * </pre>
     *
     * <code>bool sms = 6;</code>
     */
    public boolean getSms() {
      return sms_;
    }
    /**
     * <pre>
     * Whether this campaign supports SMS.
     * </pre>
     *
     * <code>bool sms = 6;</code>
     */
    public Builder setSms(boolean value) {
      
      sms_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether this campaign supports SMS.
     * </pre>
     *
     * <code>bool sms = 6;</code>
     */
    public Builder clearSms() {
      
      sms_ = false;
      onChanged();
      return this;
    }

    private boolean email_ ;
    /**
     * <pre>
     * Whether this campaign supports email.
     * </pre>
     *
     * <code>bool email = 7;</code>
     */
    public boolean getEmail() {
      return email_;
    }
    /**
     * <pre>
     * Whether this campaign supports email.
     * </pre>
     *
     * <code>bool email = 7;</code>
     */
    public Builder setEmail(boolean value) {
      
      email_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Whether this campaign supports email.
     * </pre>
     *
     * <code>bool email = 7;</code>
     */
    public Builder clearEmail() {
      
      email_ = false;
      onChanged();
      return this;
    }

    private java.util.List<io.bloombox.schema.marketing.MarketingCampaign.CampaignTag> tag_ =
      java.util.Collections.emptyList();
    private void ensureTagIsMutable() {
      if (!((bitField0_ & 0x00000080) == 0x00000080)) {
        tag_ = new java.util.ArrayList<io.bloombox.schema.marketing.MarketingCampaign.CampaignTag>(tag_);
        bitField0_ |= 0x00000080;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.bloombox.schema.marketing.MarketingCampaign.CampaignTag, io.bloombox.schema.marketing.MarketingCampaign.CampaignTag.Builder, io.bloombox.schema.marketing.MarketingCampaign.CampaignTagOrBuilder> tagBuilder_;

    /**
     * <pre>
     * Tags for the campaign object.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8;</code>
     */
    public java.util.List<io.bloombox.schema.marketing.MarketingCampaign.CampaignTag> getTagList() {
      if (tagBuilder_ == null) {
        return java.util.Collections.unmodifiableList(tag_);
      } else {
        return tagBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Tags for the campaign object.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8;</code>
     */
    public int getTagCount() {
      if (tagBuilder_ == null) {
        return tag_.size();
      } else {
        return tagBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Tags for the campaign object.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.CampaignTag getTag(int index) {
      if (tagBuilder_ == null) {
        return tag_.get(index);
      } else {
        return tagBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Tags for the campaign object.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8;</code>
     */
    public Builder setTag(
        int index, io.bloombox.schema.marketing.MarketingCampaign.CampaignTag value) {
      if (tagBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTagIsMutable();
        tag_.set(index, value);
        onChanged();
      } else {
        tagBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Tags for the campaign object.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8;</code>
     */
    public Builder setTag(
        int index, io.bloombox.schema.marketing.MarketingCampaign.CampaignTag.Builder builderForValue) {
      if (tagBuilder_ == null) {
        ensureTagIsMutable();
        tag_.set(index, builderForValue.build());
        onChanged();
      } else {
        tagBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Tags for the campaign object.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8;</code>
     */
    public Builder addTag(io.bloombox.schema.marketing.MarketingCampaign.CampaignTag value) {
      if (tagBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTagIsMutable();
        tag_.add(value);
        onChanged();
      } else {
        tagBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Tags for the campaign object.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8;</code>
     */
    public Builder addTag(
        int index, io.bloombox.schema.marketing.MarketingCampaign.CampaignTag value) {
      if (tagBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTagIsMutable();
        tag_.add(index, value);
        onChanged();
      } else {
        tagBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Tags for the campaign object.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8;</code>
     */
    public Builder addTag(
        io.bloombox.schema.marketing.MarketingCampaign.CampaignTag.Builder builderForValue) {
      if (tagBuilder_ == null) {
        ensureTagIsMutable();
        tag_.add(builderForValue.build());
        onChanged();
      } else {
        tagBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Tags for the campaign object.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8;</code>
     */
    public Builder addTag(
        int index, io.bloombox.schema.marketing.MarketingCampaign.CampaignTag.Builder builderForValue) {
      if (tagBuilder_ == null) {
        ensureTagIsMutable();
        tag_.add(index, builderForValue.build());
        onChanged();
      } else {
        tagBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Tags for the campaign object.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8;</code>
     */
    public Builder addAllTag(
        java.lang.Iterable<? extends io.bloombox.schema.marketing.MarketingCampaign.CampaignTag> values) {
      if (tagBuilder_ == null) {
        ensureTagIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, tag_);
        onChanged();
      } else {
        tagBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Tags for the campaign object.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8;</code>
     */
    public Builder clearTag() {
      if (tagBuilder_ == null) {
        tag_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        tagBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Tags for the campaign object.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8;</code>
     */
    public Builder removeTag(int index) {
      if (tagBuilder_ == null) {
        ensureTagIsMutable();
        tag_.remove(index);
        onChanged();
      } else {
        tagBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Tags for the campaign object.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.CampaignTag.Builder getTagBuilder(
        int index) {
      return getTagFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Tags for the campaign object.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.CampaignTagOrBuilder getTagOrBuilder(
        int index) {
      if (tagBuilder_ == null) {
        return tag_.get(index);  } else {
        return tagBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Tags for the campaign object.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8;</code>
     */
    public java.util.List<? extends io.bloombox.schema.marketing.MarketingCampaign.CampaignTagOrBuilder> 
         getTagOrBuilderList() {
      if (tagBuilder_ != null) {
        return tagBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(tag_);
      }
    }
    /**
     * <pre>
     * Tags for the campaign object.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.CampaignTag.Builder addTagBuilder() {
      return getTagFieldBuilder().addBuilder(
          io.bloombox.schema.marketing.MarketingCampaign.CampaignTag.getDefaultInstance());
    }
    /**
     * <pre>
     * Tags for the campaign object.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8;</code>
     */
    public io.bloombox.schema.marketing.MarketingCampaign.CampaignTag.Builder addTagBuilder(
        int index) {
      return getTagFieldBuilder().addBuilder(
          index, io.bloombox.schema.marketing.MarketingCampaign.CampaignTag.getDefaultInstance());
    }
    /**
     * <pre>
     * Tags for the campaign object.
     * </pre>
     *
     * <code>repeated .bloombox.schema.marketing.CampaignTag tag = 8;</code>
     */
    public java.util.List<io.bloombox.schema.marketing.MarketingCampaign.CampaignTag.Builder> 
         getTagBuilderList() {
      return getTagFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.bloombox.schema.marketing.MarketingCampaign.CampaignTag, io.bloombox.schema.marketing.MarketingCampaign.CampaignTag.Builder, io.bloombox.schema.marketing.MarketingCampaign.CampaignTagOrBuilder> 
        getTagFieldBuilder() {
      if (tagBuilder_ == null) {
        tagBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            io.bloombox.schema.marketing.MarketingCampaign.CampaignTag, io.bloombox.schema.marketing.MarketingCampaign.CampaignTag.Builder, io.bloombox.schema.marketing.MarketingCampaign.CampaignTagOrBuilder>(
                tag_,
                ((bitField0_ & 0x00000080) == 0x00000080),
                getParentForChildren(),
                isClean());
        tag_ = null;
      }
      return tagBuilder_;
    }

    private io.opencannabis.schema.temporal.Instant modified_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> modifiedBuilder_;
    /**
     * <pre>
     * When the subject campaign was last modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified = 9;</code>
     */
    public boolean hasModified() {
      return modifiedBuilder_ != null || modified_ != null;
    }
    /**
     * <pre>
     * When the subject campaign was last modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified = 9;</code>
     */
    public io.opencannabis.schema.temporal.Instant getModified() {
      if (modifiedBuilder_ == null) {
        return modified_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : modified_;
      } else {
        return modifiedBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * When the subject campaign was last modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified = 9;</code>
     */
    public Builder setModified(io.opencannabis.schema.temporal.Instant value) {
      if (modifiedBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modified_ = value;
        onChanged();
      } else {
        modifiedBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * When the subject campaign was last modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified = 9;</code>
     */
    public Builder setModified(
        io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
      if (modifiedBuilder_ == null) {
        modified_ = builderForValue.build();
        onChanged();
      } else {
        modifiedBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * When the subject campaign was last modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified = 9;</code>
     */
    public Builder mergeModified(io.opencannabis.schema.temporal.Instant value) {
      if (modifiedBuilder_ == null) {
        if (modified_ != null) {
          modified_ =
            io.opencannabis.schema.temporal.Instant.newBuilder(modified_).mergeFrom(value).buildPartial();
        } else {
          modified_ = value;
        }
        onChanged();
      } else {
        modifiedBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * When the subject campaign was last modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified = 9;</code>
     */
    public Builder clearModified() {
      if (modifiedBuilder_ == null) {
        modified_ = null;
        onChanged();
      } else {
        modified_ = null;
        modifiedBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * When the subject campaign was last modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified = 9;</code>
     */
    public io.opencannabis.schema.temporal.Instant.Builder getModifiedBuilder() {
      
      onChanged();
      return getModifiedFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * When the subject campaign was last modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified = 9;</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getModifiedOrBuilder() {
      if (modifiedBuilder_ != null) {
        return modifiedBuilder_.getMessageOrBuilder();
      } else {
        return modified_ == null ?
            io.opencannabis.schema.temporal.Instant.getDefaultInstance() : modified_;
      }
    }
    /**
     * <pre>
     * When the subject campaign was last modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
        getModifiedFieldBuilder() {
      if (modifiedBuilder_ == null) {
        modifiedBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                getModified(),
                getParentForChildren(),
                isClean());
        modified_ = null;
      }
      return modifiedBuilder_;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.services.marketing.v1beta1.CampaignSummary)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.services.marketing.v1beta1.CampaignSummary)
  private static final io.bloombox.schema.services.marketing.v1beta1.CampaignSummary DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.services.marketing.v1beta1.CampaignSummary();
  }

  public static io.bloombox.schema.services.marketing.v1beta1.CampaignSummary getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CampaignSummary>
      PARSER = new com.google.protobuf.AbstractParser<CampaignSummary>() {
    public CampaignSummary parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new CampaignSummary(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<CampaignSummary> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CampaignSummary> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.services.marketing.v1beta1.CampaignSummary getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

