/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: media/v1beta1/MediaService_Beta1.proto

package io.bloombox.schema.services.media.v1beta1;

/**
 * <pre>
 * Enumerates known errors that may be thrown by media operations.
 * </pre>
 *
 * Protobuf enum {@code bloombox.schema.services.media.v1beta1.MediaError}
 */
public enum MediaError
    implements com.google.protobuf.ProtocolMessageEnum {
  /**
   * <pre>
   * No error was encountered.
   * </pre>
   *
   * <code>NO_ERROR = 0;</code>
   */
  NO_ERROR(0),
  /**
   * <pre>
   * The specified partner ID is invalid.
   * </pre>
   *
   * <code>PARTNER_INVALID = 1;</code>
   */
  PARTNER_INVALID(1),
  /**
   * <pre>
   * The specified location ID is invalid.
   * </pre>
   *
   * <code>LOCATION_INVALID = 2;</code>
   */
  LOCATION_INVALID(2),
  /**
   * <pre>
   * The configured access permissions do not allow the requested operation.
   * </pre>
   *
   * <code>ACCESS_DENIED = 3;</code>
   */
  ACCESS_DENIED(3),
  /**
   * <pre>
   * The specified media item could not be located.
   * </pre>
   *
   * <code>MEDIA_NOT_FOUND = 4;</code>
   */
  MEDIA_NOT_FOUND(4),
  /**
   * <pre>
   * The specified media item or media request was invalid.
   * </pre>
   *
   * <code>MEDIA_INVALID = 5;</code>
   */
  MEDIA_INVALID(5),
  /**
   * <pre>
   * The server encountered some internal error.
   * </pre>
   *
   * <code>INTERNAL_ERROR = 99;</code>
   */
  INTERNAL_ERROR(99),
  UNRECOGNIZED(-1),
  ;

  /**
   * <pre>
   * No error was encountered.
   * </pre>
   *
   * <code>NO_ERROR = 0;</code>
   */
  public static final int NO_ERROR_VALUE = 0;
  /**
   * <pre>
   * The specified partner ID is invalid.
   * </pre>
   *
   * <code>PARTNER_INVALID = 1;</code>
   */
  public static final int PARTNER_INVALID_VALUE = 1;
  /**
   * <pre>
   * The specified location ID is invalid.
   * </pre>
   *
   * <code>LOCATION_INVALID = 2;</code>
   */
  public static final int LOCATION_INVALID_VALUE = 2;
  /**
   * <pre>
   * The configured access permissions do not allow the requested operation.
   * </pre>
   *
   * <code>ACCESS_DENIED = 3;</code>
   */
  public static final int ACCESS_DENIED_VALUE = 3;
  /**
   * <pre>
   * The specified media item could not be located.
   * </pre>
   *
   * <code>MEDIA_NOT_FOUND = 4;</code>
   */
  public static final int MEDIA_NOT_FOUND_VALUE = 4;
  /**
   * <pre>
   * The specified media item or media request was invalid.
   * </pre>
   *
   * <code>MEDIA_INVALID = 5;</code>
   */
  public static final int MEDIA_INVALID_VALUE = 5;
  /**
   * <pre>
   * The server encountered some internal error.
   * </pre>
   *
   * <code>INTERNAL_ERROR = 99;</code>
   */
  public static final int INTERNAL_ERROR_VALUE = 99;


  public final int getNumber() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalArgumentException(
          "Can't get the number of an unknown enum value.");
    }
    return value;
  }

  /**
   * @deprecated Use {@link #forNumber(int)} instead.
   */
  @java.lang.Deprecated
  public static MediaError valueOf(int value) {
    return forNumber(value);
  }

  public static MediaError forNumber(int value) {
    switch (value) {
      case 0: return NO_ERROR;
      case 1: return PARTNER_INVALID;
      case 2: return LOCATION_INVALID;
      case 3: return ACCESS_DENIED;
      case 4: return MEDIA_NOT_FOUND;
      case 5: return MEDIA_INVALID;
      case 99: return INTERNAL_ERROR;
      default: return null;
    }
  }

  public static com.google.protobuf.Internal.EnumLiteMap<MediaError>
      internalGetValueMap() {
    return internalValueMap;
  }
  private static final com.google.protobuf.Internal.EnumLiteMap<
      MediaError> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<MediaError>() {
          public MediaError findValueByNumber(int number) {
            return MediaError.forNumber(number);
          }
        };

  public final com.google.protobuf.Descriptors.EnumValueDescriptor
      getValueDescriptor() {
    return getDescriptor().getValues().get(ordinal());
  }
  public final com.google.protobuf.Descriptors.EnumDescriptor
      getDescriptorForType() {
    return getDescriptor();
  }
  public static final com.google.protobuf.Descriptors.EnumDescriptor
      getDescriptor() {
    return io.bloombox.schema.services.media.v1beta1.MediaServiceBeta1.getDescriptor().getEnumTypes().get(0);
  }

  private static final MediaError[] VALUES = values();

  public static MediaError valueOf(
      com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
    if (desc.getType() != getDescriptor()) {
      throw new java.lang.IllegalArgumentException(
        "EnumValueDescriptor is not for this type.");
    }
    if (desc.getIndex() == -1) {
      return UNRECOGNIZED;
    }
    return VALUES[desc.getIndex()];
  }

  private final int value;

  private MediaError(int value) {
    this.value = value;
  }

  // @@protoc_insertion_point(enum_scope:bloombox.schema.services.media.v1beta1.MediaError)
}

