/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: media/v1beta1/MediaService_Beta1.proto

package io.bloombox.schema.services.media.v1beta1;

/**
 * <pre>
 * Specifies the subject properties of this media. That is to say, properties of the item of which this media is the
 * subject. Also referred to as this media item's "parent" in some cases.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.services.media.v1beta1.MediaSubject}
 */
public  final class MediaSubject extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.services.media.v1beta1.MediaSubject)
    MediaSubjectOrBuilder {
private static final long serialVersionUID = 0L;
  // Use MediaSubject.newBuilder() to construct.
  private MediaSubject(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private MediaSubject() {
    name_ = "";
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private MediaSubject(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 10: {
            java.lang.String s = input.readStringRequireUtf8();

            name_ = s;
            break;
          }
          case 18: {
            io.opencannabis.schema.base.ProductKey.Builder subBuilder = null;
            if (attachmentCase_ == 2) {
              subBuilder = ((io.opencannabis.schema.base.ProductKey) attachment_).toBuilder();
            }
            attachment_ =
                input.readMessage(io.opencannabis.schema.base.ProductKey.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((io.opencannabis.schema.base.ProductKey) attachment_);
              attachment_ = subBuilder.buildPartial();
            }
            attachmentCase_ = 2;
            break;
          }
          case 26: {
            io.bloombox.schema.partner.PartnerKey.Builder subBuilder = null;
            if (attachmentCase_ == 3) {
              subBuilder = ((io.bloombox.schema.partner.PartnerKey) attachment_).toBuilder();
            }
            attachment_ =
                input.readMessage(io.bloombox.schema.partner.PartnerKey.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((io.bloombox.schema.partner.PartnerKey) attachment_);
              attachment_ = subBuilder.buildPartial();
            }
            attachmentCase_ = 3;
            break;
          }
          case 34: {
            io.bloombox.schema.partner.PartnerLocationKey.Builder subBuilder = null;
            if (attachmentCase_ == 4) {
              subBuilder = ((io.bloombox.schema.partner.PartnerLocationKey) attachment_).toBuilder();
            }
            attachment_ =
                input.readMessage(io.bloombox.schema.partner.PartnerLocationKey.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom((io.bloombox.schema.partner.PartnerLocationKey) attachment_);
              attachment_ = subBuilder.buildPartial();
            }
            attachmentCase_ = 4;
            break;
          }
          case 40: {
            attachmentCase_ = 5;
            attachment_ = input.readBool();
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.services.media.v1beta1.MediaServiceBeta1.internal_static_bloombox_schema_services_media_v1beta1_MediaSubject_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.services.media.v1beta1.MediaServiceBeta1.internal_static_bloombox_schema_services_media_v1beta1_MediaSubject_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.services.media.v1beta1.MediaSubject.class, io.bloombox.schema.services.media.v1beta1.MediaSubject.Builder.class);
  }

  private int attachmentCase_ = 0;
  private java.lang.Object attachment_;
  public enum AttachmentCase
      implements com.google.protobuf.Internal.EnumLite {
    PRODUCT(2),
    PARTNER(3),
    LOCATION(4),
    GLOBAL(5),
    ATTACHMENT_NOT_SET(0);
    private final int value;
    private AttachmentCase(int value) {
      this.value = value;
    }
    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AttachmentCase valueOf(int value) {
      return forNumber(value);
    }

    public static AttachmentCase forNumber(int value) {
      switch (value) {
        case 2: return PRODUCT;
        case 3: return PARTNER;
        case 4: return LOCATION;
        case 5: return GLOBAL;
        case 0: return ATTACHMENT_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public AttachmentCase
  getAttachmentCase() {
    return AttachmentCase.forNumber(
        attachmentCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  private volatile java.lang.Object name_;
  /**
   * <pre>
   * Name of this media item, with regard to it's subject parent. Optional.
   * </pre>
   *
   * <code>string name = 1;</code>
   */
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Name of this media item, with regard to it's subject parent. Optional.
   * </pre>
   *
   * <code>string name = 1;</code>
   */
  public com.google.protobuf.ByteString
      getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PRODUCT_FIELD_NUMBER = 2;
  /**
   * <pre>
   * Specify a product key as the subject parent of this media.
   * </pre>
   *
   * <code>.opencannabis.base.ProductKey product = 2;</code>
   */
  public boolean hasProduct() {
    return attachmentCase_ == 2;
  }
  /**
   * <pre>
   * Specify a product key as the subject parent of this media.
   * </pre>
   *
   * <code>.opencannabis.base.ProductKey product = 2;</code>
   */
  public io.opencannabis.schema.base.ProductKey getProduct() {
    if (attachmentCase_ == 2) {
       return (io.opencannabis.schema.base.ProductKey) attachment_;
    }
    return io.opencannabis.schema.base.ProductKey.getDefaultInstance();
  }
  /**
   * <pre>
   * Specify a product key as the subject parent of this media.
   * </pre>
   *
   * <code>.opencannabis.base.ProductKey product = 2;</code>
   */
  public io.opencannabis.schema.base.ProductKeyOrBuilder getProductOrBuilder() {
    if (attachmentCase_ == 2) {
       return (io.opencannabis.schema.base.ProductKey) attachment_;
    }
    return io.opencannabis.schema.base.ProductKey.getDefaultInstance();
  }

  public static final int PARTNER_FIELD_NUMBER = 3;
  /**
   * <pre>
   * Specify a partner as the subject parent of this media.
   * </pre>
   *
   * <code>.bloombox.schema.partner.PartnerKey partner = 3;</code>
   */
  public boolean hasPartner() {
    return attachmentCase_ == 3;
  }
  /**
   * <pre>
   * Specify a partner as the subject parent of this media.
   * </pre>
   *
   * <code>.bloombox.schema.partner.PartnerKey partner = 3;</code>
   */
  public io.bloombox.schema.partner.PartnerKey getPartner() {
    if (attachmentCase_ == 3) {
       return (io.bloombox.schema.partner.PartnerKey) attachment_;
    }
    return io.bloombox.schema.partner.PartnerKey.getDefaultInstance();
  }
  /**
   * <pre>
   * Specify a partner as the subject parent of this media.
   * </pre>
   *
   * <code>.bloombox.schema.partner.PartnerKey partner = 3;</code>
   */
  public io.bloombox.schema.partner.PartnerKeyOrBuilder getPartnerOrBuilder() {
    if (attachmentCase_ == 3) {
       return (io.bloombox.schema.partner.PartnerKey) attachment_;
    }
    return io.bloombox.schema.partner.PartnerKey.getDefaultInstance();
  }

  public static final int LOCATION_FIELD_NUMBER = 4;
  /**
   * <pre>
   * Specify a partner and location as the subject parent of this media.
   * </pre>
   *
   * <code>.bloombox.schema.partner.PartnerLocationKey location = 4;</code>
   */
  public boolean hasLocation() {
    return attachmentCase_ == 4;
  }
  /**
   * <pre>
   * Specify a partner and location as the subject parent of this media.
   * </pre>
   *
   * <code>.bloombox.schema.partner.PartnerLocationKey location = 4;</code>
   */
  public io.bloombox.schema.partner.PartnerLocationKey getLocation() {
    if (attachmentCase_ == 4) {
       return (io.bloombox.schema.partner.PartnerLocationKey) attachment_;
    }
    return io.bloombox.schema.partner.PartnerLocationKey.getDefaultInstance();
  }
  /**
   * <pre>
   * Specify a partner and location as the subject parent of this media.
   * </pre>
   *
   * <code>.bloombox.schema.partner.PartnerLocationKey location = 4;</code>
   */
  public io.bloombox.schema.partner.PartnerLocationKeyOrBuilder getLocationOrBuilder() {
    if (attachmentCase_ == 4) {
       return (io.bloombox.schema.partner.PartnerLocationKey) attachment_;
    }
    return io.bloombox.schema.partner.PartnerLocationKey.getDefaultInstance();
  }

  public static final int GLOBAL_FIELD_NUMBER = 5;
  /**
   * <pre>
   * Specify this media as global. This is a special flag that should only be used internally.
   * </pre>
   *
   * <code>bool global = 5;</code>
   */
  public boolean getGlobal() {
    if (attachmentCase_ == 5) {
      return (java.lang.Boolean) attachment_;
    }
    return false;
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!getNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (attachmentCase_ == 2) {
      output.writeMessage(2, (io.opencannabis.schema.base.ProductKey) attachment_);
    }
    if (attachmentCase_ == 3) {
      output.writeMessage(3, (io.bloombox.schema.partner.PartnerKey) attachment_);
    }
    if (attachmentCase_ == 4) {
      output.writeMessage(4, (io.bloombox.schema.partner.PartnerLocationKey) attachment_);
    }
    if (attachmentCase_ == 5) {
      output.writeBool(
          5, (boolean)((java.lang.Boolean) attachment_));
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (attachmentCase_ == 2) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(2, (io.opencannabis.schema.base.ProductKey) attachment_);
    }
    if (attachmentCase_ == 3) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, (io.bloombox.schema.partner.PartnerKey) attachment_);
    }
    if (attachmentCase_ == 4) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(4, (io.bloombox.schema.partner.PartnerLocationKey) attachment_);
    }
    if (attachmentCase_ == 5) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(
            5, (boolean)((java.lang.Boolean) attachment_));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.services.media.v1beta1.MediaSubject)) {
      return super.equals(obj);
    }
    io.bloombox.schema.services.media.v1beta1.MediaSubject other = (io.bloombox.schema.services.media.v1beta1.MediaSubject) obj;

    boolean result = true;
    result = result && getName()
        .equals(other.getName());
    result = result && getAttachmentCase().equals(
        other.getAttachmentCase());
    if (!result) return false;
    switch (attachmentCase_) {
      case 2:
        result = result && getProduct()
            .equals(other.getProduct());
        break;
      case 3:
        result = result && getPartner()
            .equals(other.getPartner());
        break;
      case 4:
        result = result && getLocation()
            .equals(other.getLocation());
        break;
      case 5:
        result = result && (getGlobal()
            == other.getGlobal());
        break;
      case 0:
      default:
    }
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    switch (attachmentCase_) {
      case 2:
        hash = (37 * hash) + PRODUCT_FIELD_NUMBER;
        hash = (53 * hash) + getProduct().hashCode();
        break;
      case 3:
        hash = (37 * hash) + PARTNER_FIELD_NUMBER;
        hash = (53 * hash) + getPartner().hashCode();
        break;
      case 4:
        hash = (37 * hash) + LOCATION_FIELD_NUMBER;
        hash = (53 * hash) + getLocation().hashCode();
        break;
      case 5:
        hash = (37 * hash) + GLOBAL_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
            getGlobal());
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.services.media.v1beta1.MediaSubject parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.media.v1beta1.MediaSubject parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.media.v1beta1.MediaSubject parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.media.v1beta1.MediaSubject parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.media.v1beta1.MediaSubject parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.media.v1beta1.MediaSubject parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.media.v1beta1.MediaSubject parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.media.v1beta1.MediaSubject parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.media.v1beta1.MediaSubject parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.media.v1beta1.MediaSubject parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.media.v1beta1.MediaSubject parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.media.v1beta1.MediaSubject parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.services.media.v1beta1.MediaSubject prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies the subject properties of this media. That is to say, properties of the item of which this media is the
   * subject. Also referred to as this media item's "parent" in some cases.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.media.v1beta1.MediaSubject}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.services.media.v1beta1.MediaSubject)
      io.bloombox.schema.services.media.v1beta1.MediaSubjectOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.media.v1beta1.MediaServiceBeta1.internal_static_bloombox_schema_services_media_v1beta1_MediaSubject_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.media.v1beta1.MediaServiceBeta1.internal_static_bloombox_schema_services_media_v1beta1_MediaSubject_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.media.v1beta1.MediaSubject.class, io.bloombox.schema.services.media.v1beta1.MediaSubject.Builder.class);
    }

    // Construct using io.bloombox.schema.services.media.v1beta1.MediaSubject.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      name_ = "";

      attachmentCase_ = 0;
      attachment_ = null;
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.services.media.v1beta1.MediaServiceBeta1.internal_static_bloombox_schema_services_media_v1beta1_MediaSubject_descriptor;
    }

    public io.bloombox.schema.services.media.v1beta1.MediaSubject getDefaultInstanceForType() {
      return io.bloombox.schema.services.media.v1beta1.MediaSubject.getDefaultInstance();
    }

    public io.bloombox.schema.services.media.v1beta1.MediaSubject build() {
      io.bloombox.schema.services.media.v1beta1.MediaSubject result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.services.media.v1beta1.MediaSubject buildPartial() {
      io.bloombox.schema.services.media.v1beta1.MediaSubject result = new io.bloombox.schema.services.media.v1beta1.MediaSubject(this);
      result.name_ = name_;
      if (attachmentCase_ == 2) {
        if (productBuilder_ == null) {
          result.attachment_ = attachment_;
        } else {
          result.attachment_ = productBuilder_.build();
        }
      }
      if (attachmentCase_ == 3) {
        if (partnerBuilder_ == null) {
          result.attachment_ = attachment_;
        } else {
          result.attachment_ = partnerBuilder_.build();
        }
      }
      if (attachmentCase_ == 4) {
        if (locationBuilder_ == null) {
          result.attachment_ = attachment_;
        } else {
          result.attachment_ = locationBuilder_.build();
        }
      }
      if (attachmentCase_ == 5) {
        result.attachment_ = attachment_;
      }
      result.attachmentCase_ = attachmentCase_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.services.media.v1beta1.MediaSubject) {
        return mergeFrom((io.bloombox.schema.services.media.v1beta1.MediaSubject)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.services.media.v1beta1.MediaSubject other) {
      if (other == io.bloombox.schema.services.media.v1beta1.MediaSubject.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        onChanged();
      }
      switch (other.getAttachmentCase()) {
        case PRODUCT: {
          mergeProduct(other.getProduct());
          break;
        }
        case PARTNER: {
          mergePartner(other.getPartner());
          break;
        }
        case LOCATION: {
          mergeLocation(other.getLocation());
          break;
        }
        case GLOBAL: {
          setGlobal(other.getGlobal());
          break;
        }
        case ATTACHMENT_NOT_SET: {
          break;
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.services.media.v1beta1.MediaSubject parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.services.media.v1beta1.MediaSubject) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int attachmentCase_ = 0;
    private java.lang.Object attachment_;
    public AttachmentCase
        getAttachmentCase() {
      return AttachmentCase.forNumber(
          attachmentCase_);
    }

    public Builder clearAttachment() {
      attachmentCase_ = 0;
      attachment_ = null;
      onChanged();
      return this;
    }


    private java.lang.Object name_ = "";
    /**
     * <pre>
     * Name of this media item, with regard to it's subject parent. Optional.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Name of this media item, with regard to it's subject parent. Optional.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Name of this media item, with regard to it's subject parent. Optional.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public Builder setName(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      name_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Name of this media item, with regard to it's subject parent. Optional.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public Builder clearName() {
      
      name_ = getDefaultInstance().getName();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Name of this media item, with regard to it's subject parent. Optional.
     * </pre>
     *
     * <code>string name = 1;</code>
     */
    public Builder setNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      name_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder> productBuilder_;
    /**
     * <pre>
     * Specify a product key as the subject parent of this media.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey product = 2;</code>
     */
    public boolean hasProduct() {
      return attachmentCase_ == 2;
    }
    /**
     * <pre>
     * Specify a product key as the subject parent of this media.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey product = 2;</code>
     */
    public io.opencannabis.schema.base.ProductKey getProduct() {
      if (productBuilder_ == null) {
        if (attachmentCase_ == 2) {
          return (io.opencannabis.schema.base.ProductKey) attachment_;
        }
        return io.opencannabis.schema.base.ProductKey.getDefaultInstance();
      } else {
        if (attachmentCase_ == 2) {
          return productBuilder_.getMessage();
        }
        return io.opencannabis.schema.base.ProductKey.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Specify a product key as the subject parent of this media.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey product = 2;</code>
     */
    public Builder setProduct(io.opencannabis.schema.base.ProductKey value) {
      if (productBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        attachment_ = value;
        onChanged();
      } else {
        productBuilder_.setMessage(value);
      }
      attachmentCase_ = 2;
      return this;
    }
    /**
     * <pre>
     * Specify a product key as the subject parent of this media.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey product = 2;</code>
     */
    public Builder setProduct(
        io.opencannabis.schema.base.ProductKey.Builder builderForValue) {
      if (productBuilder_ == null) {
        attachment_ = builderForValue.build();
        onChanged();
      } else {
        productBuilder_.setMessage(builderForValue.build());
      }
      attachmentCase_ = 2;
      return this;
    }
    /**
     * <pre>
     * Specify a product key as the subject parent of this media.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey product = 2;</code>
     */
    public Builder mergeProduct(io.opencannabis.schema.base.ProductKey value) {
      if (productBuilder_ == null) {
        if (attachmentCase_ == 2 &&
            attachment_ != io.opencannabis.schema.base.ProductKey.getDefaultInstance()) {
          attachment_ = io.opencannabis.schema.base.ProductKey.newBuilder((io.opencannabis.schema.base.ProductKey) attachment_)
              .mergeFrom(value).buildPartial();
        } else {
          attachment_ = value;
        }
        onChanged();
      } else {
        if (attachmentCase_ == 2) {
          productBuilder_.mergeFrom(value);
        }
        productBuilder_.setMessage(value);
      }
      attachmentCase_ = 2;
      return this;
    }
    /**
     * <pre>
     * Specify a product key as the subject parent of this media.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey product = 2;</code>
     */
    public Builder clearProduct() {
      if (productBuilder_ == null) {
        if (attachmentCase_ == 2) {
          attachmentCase_ = 0;
          attachment_ = null;
          onChanged();
        }
      } else {
        if (attachmentCase_ == 2) {
          attachmentCase_ = 0;
          attachment_ = null;
        }
        productBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Specify a product key as the subject parent of this media.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey product = 2;</code>
     */
    public io.opencannabis.schema.base.ProductKey.Builder getProductBuilder() {
      return getProductFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Specify a product key as the subject parent of this media.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey product = 2;</code>
     */
    public io.opencannabis.schema.base.ProductKeyOrBuilder getProductOrBuilder() {
      if ((attachmentCase_ == 2) && (productBuilder_ != null)) {
        return productBuilder_.getMessageOrBuilder();
      } else {
        if (attachmentCase_ == 2) {
          return (io.opencannabis.schema.base.ProductKey) attachment_;
        }
        return io.opencannabis.schema.base.ProductKey.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Specify a product key as the subject parent of this media.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey product = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder> 
        getProductFieldBuilder() {
      if (productBuilder_ == null) {
        if (!(attachmentCase_ == 2)) {
          attachment_ = io.opencannabis.schema.base.ProductKey.getDefaultInstance();
        }
        productBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder>(
                (io.opencannabis.schema.base.ProductKey) attachment_,
                getParentForChildren(),
                isClean());
        attachment_ = null;
      }
      attachmentCase_ = 2;
      onChanged();;
      return productBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.partner.PartnerKey, io.bloombox.schema.partner.PartnerKey.Builder, io.bloombox.schema.partner.PartnerKeyOrBuilder> partnerBuilder_;
    /**
     * <pre>
     * Specify a partner as the subject parent of this media.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerKey partner = 3;</code>
     */
    public boolean hasPartner() {
      return attachmentCase_ == 3;
    }
    /**
     * <pre>
     * Specify a partner as the subject parent of this media.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerKey partner = 3;</code>
     */
    public io.bloombox.schema.partner.PartnerKey getPartner() {
      if (partnerBuilder_ == null) {
        if (attachmentCase_ == 3) {
          return (io.bloombox.schema.partner.PartnerKey) attachment_;
        }
        return io.bloombox.schema.partner.PartnerKey.getDefaultInstance();
      } else {
        if (attachmentCase_ == 3) {
          return partnerBuilder_.getMessage();
        }
        return io.bloombox.schema.partner.PartnerKey.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Specify a partner as the subject parent of this media.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerKey partner = 3;</code>
     */
    public Builder setPartner(io.bloombox.schema.partner.PartnerKey value) {
      if (partnerBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        attachment_ = value;
        onChanged();
      } else {
        partnerBuilder_.setMessage(value);
      }
      attachmentCase_ = 3;
      return this;
    }
    /**
     * <pre>
     * Specify a partner as the subject parent of this media.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerKey partner = 3;</code>
     */
    public Builder setPartner(
        io.bloombox.schema.partner.PartnerKey.Builder builderForValue) {
      if (partnerBuilder_ == null) {
        attachment_ = builderForValue.build();
        onChanged();
      } else {
        partnerBuilder_.setMessage(builderForValue.build());
      }
      attachmentCase_ = 3;
      return this;
    }
    /**
     * <pre>
     * Specify a partner as the subject parent of this media.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerKey partner = 3;</code>
     */
    public Builder mergePartner(io.bloombox.schema.partner.PartnerKey value) {
      if (partnerBuilder_ == null) {
        if (attachmentCase_ == 3 &&
            attachment_ != io.bloombox.schema.partner.PartnerKey.getDefaultInstance()) {
          attachment_ = io.bloombox.schema.partner.PartnerKey.newBuilder((io.bloombox.schema.partner.PartnerKey) attachment_)
              .mergeFrom(value).buildPartial();
        } else {
          attachment_ = value;
        }
        onChanged();
      } else {
        if (attachmentCase_ == 3) {
          partnerBuilder_.mergeFrom(value);
        }
        partnerBuilder_.setMessage(value);
      }
      attachmentCase_ = 3;
      return this;
    }
    /**
     * <pre>
     * Specify a partner as the subject parent of this media.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerKey partner = 3;</code>
     */
    public Builder clearPartner() {
      if (partnerBuilder_ == null) {
        if (attachmentCase_ == 3) {
          attachmentCase_ = 0;
          attachment_ = null;
          onChanged();
        }
      } else {
        if (attachmentCase_ == 3) {
          attachmentCase_ = 0;
          attachment_ = null;
        }
        partnerBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Specify a partner as the subject parent of this media.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerKey partner = 3;</code>
     */
    public io.bloombox.schema.partner.PartnerKey.Builder getPartnerBuilder() {
      return getPartnerFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Specify a partner as the subject parent of this media.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerKey partner = 3;</code>
     */
    public io.bloombox.schema.partner.PartnerKeyOrBuilder getPartnerOrBuilder() {
      if ((attachmentCase_ == 3) && (partnerBuilder_ != null)) {
        return partnerBuilder_.getMessageOrBuilder();
      } else {
        if (attachmentCase_ == 3) {
          return (io.bloombox.schema.partner.PartnerKey) attachment_;
        }
        return io.bloombox.schema.partner.PartnerKey.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Specify a partner as the subject parent of this media.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerKey partner = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.partner.PartnerKey, io.bloombox.schema.partner.PartnerKey.Builder, io.bloombox.schema.partner.PartnerKeyOrBuilder> 
        getPartnerFieldBuilder() {
      if (partnerBuilder_ == null) {
        if (!(attachmentCase_ == 3)) {
          attachment_ = io.bloombox.schema.partner.PartnerKey.getDefaultInstance();
        }
        partnerBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.bloombox.schema.partner.PartnerKey, io.bloombox.schema.partner.PartnerKey.Builder, io.bloombox.schema.partner.PartnerKeyOrBuilder>(
                (io.bloombox.schema.partner.PartnerKey) attachment_,
                getParentForChildren(),
                isClean());
        attachment_ = null;
      }
      attachmentCase_ = 3;
      onChanged();;
      return partnerBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.partner.PartnerLocationKey, io.bloombox.schema.partner.PartnerLocationKey.Builder, io.bloombox.schema.partner.PartnerLocationKeyOrBuilder> locationBuilder_;
    /**
     * <pre>
     * Specify a partner and location as the subject parent of this media.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerLocationKey location = 4;</code>
     */
    public boolean hasLocation() {
      return attachmentCase_ == 4;
    }
    /**
     * <pre>
     * Specify a partner and location as the subject parent of this media.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerLocationKey location = 4;</code>
     */
    public io.bloombox.schema.partner.PartnerLocationKey getLocation() {
      if (locationBuilder_ == null) {
        if (attachmentCase_ == 4) {
          return (io.bloombox.schema.partner.PartnerLocationKey) attachment_;
        }
        return io.bloombox.schema.partner.PartnerLocationKey.getDefaultInstance();
      } else {
        if (attachmentCase_ == 4) {
          return locationBuilder_.getMessage();
        }
        return io.bloombox.schema.partner.PartnerLocationKey.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Specify a partner and location as the subject parent of this media.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerLocationKey location = 4;</code>
     */
    public Builder setLocation(io.bloombox.schema.partner.PartnerLocationKey value) {
      if (locationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        attachment_ = value;
        onChanged();
      } else {
        locationBuilder_.setMessage(value);
      }
      attachmentCase_ = 4;
      return this;
    }
    /**
     * <pre>
     * Specify a partner and location as the subject parent of this media.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerLocationKey location = 4;</code>
     */
    public Builder setLocation(
        io.bloombox.schema.partner.PartnerLocationKey.Builder builderForValue) {
      if (locationBuilder_ == null) {
        attachment_ = builderForValue.build();
        onChanged();
      } else {
        locationBuilder_.setMessage(builderForValue.build());
      }
      attachmentCase_ = 4;
      return this;
    }
    /**
     * <pre>
     * Specify a partner and location as the subject parent of this media.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerLocationKey location = 4;</code>
     */
    public Builder mergeLocation(io.bloombox.schema.partner.PartnerLocationKey value) {
      if (locationBuilder_ == null) {
        if (attachmentCase_ == 4 &&
            attachment_ != io.bloombox.schema.partner.PartnerLocationKey.getDefaultInstance()) {
          attachment_ = io.bloombox.schema.partner.PartnerLocationKey.newBuilder((io.bloombox.schema.partner.PartnerLocationKey) attachment_)
              .mergeFrom(value).buildPartial();
        } else {
          attachment_ = value;
        }
        onChanged();
      } else {
        if (attachmentCase_ == 4) {
          locationBuilder_.mergeFrom(value);
        }
        locationBuilder_.setMessage(value);
      }
      attachmentCase_ = 4;
      return this;
    }
    /**
     * <pre>
     * Specify a partner and location as the subject parent of this media.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerLocationKey location = 4;</code>
     */
    public Builder clearLocation() {
      if (locationBuilder_ == null) {
        if (attachmentCase_ == 4) {
          attachmentCase_ = 0;
          attachment_ = null;
          onChanged();
        }
      } else {
        if (attachmentCase_ == 4) {
          attachmentCase_ = 0;
          attachment_ = null;
        }
        locationBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Specify a partner and location as the subject parent of this media.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerLocationKey location = 4;</code>
     */
    public io.bloombox.schema.partner.PartnerLocationKey.Builder getLocationBuilder() {
      return getLocationFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Specify a partner and location as the subject parent of this media.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerLocationKey location = 4;</code>
     */
    public io.bloombox.schema.partner.PartnerLocationKeyOrBuilder getLocationOrBuilder() {
      if ((attachmentCase_ == 4) && (locationBuilder_ != null)) {
        return locationBuilder_.getMessageOrBuilder();
      } else {
        if (attachmentCase_ == 4) {
          return (io.bloombox.schema.partner.PartnerLocationKey) attachment_;
        }
        return io.bloombox.schema.partner.PartnerLocationKey.getDefaultInstance();
      }
    }
    /**
     * <pre>
     * Specify a partner and location as the subject parent of this media.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerLocationKey location = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.bloombox.schema.partner.PartnerLocationKey, io.bloombox.schema.partner.PartnerLocationKey.Builder, io.bloombox.schema.partner.PartnerLocationKeyOrBuilder> 
        getLocationFieldBuilder() {
      if (locationBuilder_ == null) {
        if (!(attachmentCase_ == 4)) {
          attachment_ = io.bloombox.schema.partner.PartnerLocationKey.getDefaultInstance();
        }
        locationBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.bloombox.schema.partner.PartnerLocationKey, io.bloombox.schema.partner.PartnerLocationKey.Builder, io.bloombox.schema.partner.PartnerLocationKeyOrBuilder>(
                (io.bloombox.schema.partner.PartnerLocationKey) attachment_,
                getParentForChildren(),
                isClean());
        attachment_ = null;
      }
      attachmentCase_ = 4;
      onChanged();;
      return locationBuilder_;
    }

    /**
     * <pre>
     * Specify this media as global. This is a special flag that should only be used internally.
     * </pre>
     *
     * <code>bool global = 5;</code>
     */
    public boolean getGlobal() {
      if (attachmentCase_ == 5) {
        return (java.lang.Boolean) attachment_;
      }
      return false;
    }
    /**
     * <pre>
     * Specify this media as global. This is a special flag that should only be used internally.
     * </pre>
     *
     * <code>bool global = 5;</code>
     */
    public Builder setGlobal(boolean value) {
      attachmentCase_ = 5;
      attachment_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specify this media as global. This is a special flag that should only be used internally.
     * </pre>
     *
     * <code>bool global = 5;</code>
     */
    public Builder clearGlobal() {
      if (attachmentCase_ == 5) {
        attachmentCase_ = 0;
        attachment_ = null;
        onChanged();
      }
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.services.media.v1beta1.MediaSubject)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.services.media.v1beta1.MediaSubject)
  private static final io.bloombox.schema.services.media.v1beta1.MediaSubject DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.services.media.v1beta1.MediaSubject();
  }

  public static io.bloombox.schema.services.media.v1beta1.MediaSubject getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MediaSubject>
      PARSER = new com.google.protobuf.AbstractParser<MediaSubject>() {
    public MediaSubject parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new MediaSubject(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<MediaSubject> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MediaSubject> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.services.media.v1beta1.MediaSubject getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

