/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: media/v1beta1/MediaService_Beta1.proto

package io.bloombox.schema.services.media.v1beta1;

/**
 * <pre>
 * Specifies an RPC operation to upload a new piece of media, provisioning a media item record (and key) along the way.
 * The resulting key, or an error encountered while attempting to fulfill the operation, is returned.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.services.media.v1beta1.UploadMedia}
 */
public  final class UploadMedia extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.services.media.v1beta1.UploadMedia)
    UploadMediaOrBuilder {
private static final long serialVersionUID = 0L;
  // Use UploadMedia.newBuilder() to construct.
  private UploadMedia(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private UploadMedia() {
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private UploadMedia(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.services.media.v1beta1.MediaServiceBeta1.internal_static_bloombox_schema_services_media_v1beta1_UploadMedia_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.services.media.v1beta1.MediaServiceBeta1.internal_static_bloombox_schema_services_media_v1beta1_UploadMedia_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.services.media.v1beta1.UploadMedia.class, io.bloombox.schema.services.media.v1beta1.UploadMedia.Builder.class);
  }

  public interface RequestOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.media.v1beta1.UploadMedia.Request)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Partnership scope value. Includes the partner account and location.
     * </pre>
     *
     * <code>string scope = 1;</code>
     */
    java.lang.String getScope();
    /**
     * <pre>
     * Partnership scope value. Includes the partner account and location.
     * </pre>
     *
     * <code>string scope = 1;</code>
     */
    com.google.protobuf.ByteString
        getScopeBytes();

    /**
     * <pre>
     * Subject attachment and scoping settings for the media item to be created.
     * </pre>
     *
     * <code>.bloombox.schema.services.media.v1beta1.MediaSubject subject = 2;</code>
     */
    boolean hasSubject();
    /**
     * <pre>
     * Subject attachment and scoping settings for the media item to be created.
     * </pre>
     *
     * <code>.bloombox.schema.services.media.v1beta1.MediaSubject subject = 2;</code>
     */
    io.bloombox.schema.services.media.v1beta1.MediaSubject getSubject();
    /**
     * <pre>
     * Subject attachment and scoping settings for the media item to be created.
     * </pre>
     *
     * <code>.bloombox.schema.services.media.v1beta1.MediaSubject subject = 2;</code>
     */
    io.bloombox.schema.services.media.v1beta1.MediaSubjectOrBuilder getSubjectOrBuilder();

    /**
     * <pre>
     * Inline media content, if applicable to this request.
     * </pre>
     *
     * <code>.bloombox.schema.services.media.v1beta1.MediaContent content = 3;</code>
     */
    boolean hasContent();
    /**
     * <pre>
     * Inline media content, if applicable to this request.
     * </pre>
     *
     * <code>.bloombox.schema.services.media.v1beta1.MediaContent content = 3;</code>
     */
    io.bloombox.schema.services.media.v1beta1.MediaContent getContent();
    /**
     * <pre>
     * Inline media content, if applicable to this request.
     * </pre>
     *
     * <code>.bloombox.schema.services.media.v1beta1.MediaContent content = 3;</code>
     */
    io.bloombox.schema.services.media.v1beta1.MediaContentOrBuilder getContentOrBuilder();
  }
  /**
   * <pre>
   * Specifies an RPC request to upload a new media item.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.media.v1beta1.UploadMedia.Request}
   */
  public  static final class Request extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.media.v1beta1.UploadMedia.Request)
      RequestOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Request.newBuilder() to construct.
    private Request(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Request() {
      scope_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Request(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              scope_ = s;
              break;
            }
            case 18: {
              io.bloombox.schema.services.media.v1beta1.MediaSubject.Builder subBuilder = null;
              if (subject_ != null) {
                subBuilder = subject_.toBuilder();
              }
              subject_ = input.readMessage(io.bloombox.schema.services.media.v1beta1.MediaSubject.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(subject_);
                subject_ = subBuilder.buildPartial();
              }

              break;
            }
            case 26: {
              io.bloombox.schema.services.media.v1beta1.MediaContent.Builder subBuilder = null;
              if (content_ != null) {
                subBuilder = content_.toBuilder();
              }
              content_ = input.readMessage(io.bloombox.schema.services.media.v1beta1.MediaContent.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(content_);
                content_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.media.v1beta1.MediaServiceBeta1.internal_static_bloombox_schema_services_media_v1beta1_UploadMedia_Request_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.media.v1beta1.MediaServiceBeta1.internal_static_bloombox_schema_services_media_v1beta1_UploadMedia_Request_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.media.v1beta1.UploadMedia.Request.class, io.bloombox.schema.services.media.v1beta1.UploadMedia.Request.Builder.class);
    }

    public static final int SCOPE_FIELD_NUMBER = 1;
    private volatile java.lang.Object scope_;
    /**
     * <pre>
     * Partnership scope value. Includes the partner account and location.
     * </pre>
     *
     * <code>string scope = 1;</code>
     */
    public java.lang.String getScope() {
      java.lang.Object ref = scope_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        scope_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Partnership scope value. Includes the partner account and location.
     * </pre>
     *
     * <code>string scope = 1;</code>
     */
    public com.google.protobuf.ByteString
        getScopeBytes() {
      java.lang.Object ref = scope_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        scope_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SUBJECT_FIELD_NUMBER = 2;
    private io.bloombox.schema.services.media.v1beta1.MediaSubject subject_;
    /**
     * <pre>
     * Subject attachment and scoping settings for the media item to be created.
     * </pre>
     *
     * <code>.bloombox.schema.services.media.v1beta1.MediaSubject subject = 2;</code>
     */
    public boolean hasSubject() {
      return subject_ != null;
    }
    /**
     * <pre>
     * Subject attachment and scoping settings for the media item to be created.
     * </pre>
     *
     * <code>.bloombox.schema.services.media.v1beta1.MediaSubject subject = 2;</code>
     */
    public io.bloombox.schema.services.media.v1beta1.MediaSubject getSubject() {
      return subject_ == null ? io.bloombox.schema.services.media.v1beta1.MediaSubject.getDefaultInstance() : subject_;
    }
    /**
     * <pre>
     * Subject attachment and scoping settings for the media item to be created.
     * </pre>
     *
     * <code>.bloombox.schema.services.media.v1beta1.MediaSubject subject = 2;</code>
     */
    public io.bloombox.schema.services.media.v1beta1.MediaSubjectOrBuilder getSubjectOrBuilder() {
      return getSubject();
    }

    public static final int CONTENT_FIELD_NUMBER = 3;
    private io.bloombox.schema.services.media.v1beta1.MediaContent content_;
    /**
     * <pre>
     * Inline media content, if applicable to this request.
     * </pre>
     *
     * <code>.bloombox.schema.services.media.v1beta1.MediaContent content = 3;</code>
     */
    public boolean hasContent() {
      return content_ != null;
    }
    /**
     * <pre>
     * Inline media content, if applicable to this request.
     * </pre>
     *
     * <code>.bloombox.schema.services.media.v1beta1.MediaContent content = 3;</code>
     */
    public io.bloombox.schema.services.media.v1beta1.MediaContent getContent() {
      return content_ == null ? io.bloombox.schema.services.media.v1beta1.MediaContent.getDefaultInstance() : content_;
    }
    /**
     * <pre>
     * Inline media content, if applicable to this request.
     * </pre>
     *
     * <code>.bloombox.schema.services.media.v1beta1.MediaContent content = 3;</code>
     */
    public io.bloombox.schema.services.media.v1beta1.MediaContentOrBuilder getContentOrBuilder() {
      return getContent();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getScopeBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, scope_);
      }
      if (subject_ != null) {
        output.writeMessage(2, getSubject());
      }
      if (content_ != null) {
        output.writeMessage(3, getContent());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getScopeBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, scope_);
      }
      if (subject_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getSubject());
      }
      if (content_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getContent());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.media.v1beta1.UploadMedia.Request)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.media.v1beta1.UploadMedia.Request other = (io.bloombox.schema.services.media.v1beta1.UploadMedia.Request) obj;

      boolean result = true;
      result = result && getScope()
          .equals(other.getScope());
      result = result && (hasSubject() == other.hasSubject());
      if (hasSubject()) {
        result = result && getSubject()
            .equals(other.getSubject());
      }
      result = result && (hasContent() == other.hasContent());
      if (hasContent()) {
        result = result && getContent()
            .equals(other.getContent());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SCOPE_FIELD_NUMBER;
      hash = (53 * hash) + getScope().hashCode();
      if (hasSubject()) {
        hash = (37 * hash) + SUBJECT_FIELD_NUMBER;
        hash = (53 * hash) + getSubject().hashCode();
      }
      if (hasContent()) {
        hash = (37 * hash) + CONTENT_FIELD_NUMBER;
        hash = (53 * hash) + getContent().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.media.v1beta1.UploadMedia.Request parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.media.v1beta1.UploadMedia.Request parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.media.v1beta1.UploadMedia.Request parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.media.v1beta1.UploadMedia.Request parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.media.v1beta1.UploadMedia.Request parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.media.v1beta1.UploadMedia.Request parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.media.v1beta1.UploadMedia.Request parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.media.v1beta1.UploadMedia.Request parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.media.v1beta1.UploadMedia.Request parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.media.v1beta1.UploadMedia.Request parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.media.v1beta1.UploadMedia.Request parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.media.v1beta1.UploadMedia.Request parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.media.v1beta1.UploadMedia.Request prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies an RPC request to upload a new media item.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.media.v1beta1.UploadMedia.Request}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.media.v1beta1.UploadMedia.Request)
        io.bloombox.schema.services.media.v1beta1.UploadMedia.RequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.media.v1beta1.MediaServiceBeta1.internal_static_bloombox_schema_services_media_v1beta1_UploadMedia_Request_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.media.v1beta1.MediaServiceBeta1.internal_static_bloombox_schema_services_media_v1beta1_UploadMedia_Request_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.media.v1beta1.UploadMedia.Request.class, io.bloombox.schema.services.media.v1beta1.UploadMedia.Request.Builder.class);
      }

      // Construct using io.bloombox.schema.services.media.v1beta1.UploadMedia.Request.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        scope_ = "";

        if (subjectBuilder_ == null) {
          subject_ = null;
        } else {
          subject_ = null;
          subjectBuilder_ = null;
        }
        if (contentBuilder_ == null) {
          content_ = null;
        } else {
          content_ = null;
          contentBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.media.v1beta1.MediaServiceBeta1.internal_static_bloombox_schema_services_media_v1beta1_UploadMedia_Request_descriptor;
      }

      public io.bloombox.schema.services.media.v1beta1.UploadMedia.Request getDefaultInstanceForType() {
        return io.bloombox.schema.services.media.v1beta1.UploadMedia.Request.getDefaultInstance();
      }

      public io.bloombox.schema.services.media.v1beta1.UploadMedia.Request build() {
        io.bloombox.schema.services.media.v1beta1.UploadMedia.Request result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.media.v1beta1.UploadMedia.Request buildPartial() {
        io.bloombox.schema.services.media.v1beta1.UploadMedia.Request result = new io.bloombox.schema.services.media.v1beta1.UploadMedia.Request(this);
        result.scope_ = scope_;
        if (subjectBuilder_ == null) {
          result.subject_ = subject_;
        } else {
          result.subject_ = subjectBuilder_.build();
        }
        if (contentBuilder_ == null) {
          result.content_ = content_;
        } else {
          result.content_ = contentBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.media.v1beta1.UploadMedia.Request) {
          return mergeFrom((io.bloombox.schema.services.media.v1beta1.UploadMedia.Request)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.media.v1beta1.UploadMedia.Request other) {
        if (other == io.bloombox.schema.services.media.v1beta1.UploadMedia.Request.getDefaultInstance()) return this;
        if (!other.getScope().isEmpty()) {
          scope_ = other.scope_;
          onChanged();
        }
        if (other.hasSubject()) {
          mergeSubject(other.getSubject());
        }
        if (other.hasContent()) {
          mergeContent(other.getContent());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.media.v1beta1.UploadMedia.Request parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.media.v1beta1.UploadMedia.Request) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object scope_ = "";
      /**
       * <pre>
       * Partnership scope value. Includes the partner account and location.
       * </pre>
       *
       * <code>string scope = 1;</code>
       */
      public java.lang.String getScope() {
        java.lang.Object ref = scope_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          scope_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Partnership scope value. Includes the partner account and location.
       * </pre>
       *
       * <code>string scope = 1;</code>
       */
      public com.google.protobuf.ByteString
          getScopeBytes() {
        java.lang.Object ref = scope_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          scope_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Partnership scope value. Includes the partner account and location.
       * </pre>
       *
       * <code>string scope = 1;</code>
       */
      public Builder setScope(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        scope_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Partnership scope value. Includes the partner account and location.
       * </pre>
       *
       * <code>string scope = 1;</code>
       */
      public Builder clearScope() {
        
        scope_ = getDefaultInstance().getScope();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Partnership scope value. Includes the partner account and location.
       * </pre>
       *
       * <code>string scope = 1;</code>
       */
      public Builder setScopeBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        scope_ = value;
        onChanged();
        return this;
      }

      private io.bloombox.schema.services.media.v1beta1.MediaSubject subject_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.services.media.v1beta1.MediaSubject, io.bloombox.schema.services.media.v1beta1.MediaSubject.Builder, io.bloombox.schema.services.media.v1beta1.MediaSubjectOrBuilder> subjectBuilder_;
      /**
       * <pre>
       * Subject attachment and scoping settings for the media item to be created.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.MediaSubject subject = 2;</code>
       */
      public boolean hasSubject() {
        return subjectBuilder_ != null || subject_ != null;
      }
      /**
       * <pre>
       * Subject attachment and scoping settings for the media item to be created.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.MediaSubject subject = 2;</code>
       */
      public io.bloombox.schema.services.media.v1beta1.MediaSubject getSubject() {
        if (subjectBuilder_ == null) {
          return subject_ == null ? io.bloombox.schema.services.media.v1beta1.MediaSubject.getDefaultInstance() : subject_;
        } else {
          return subjectBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Subject attachment and scoping settings for the media item to be created.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.MediaSubject subject = 2;</code>
       */
      public Builder setSubject(io.bloombox.schema.services.media.v1beta1.MediaSubject value) {
        if (subjectBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          subject_ = value;
          onChanged();
        } else {
          subjectBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Subject attachment and scoping settings for the media item to be created.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.MediaSubject subject = 2;</code>
       */
      public Builder setSubject(
          io.bloombox.schema.services.media.v1beta1.MediaSubject.Builder builderForValue) {
        if (subjectBuilder_ == null) {
          subject_ = builderForValue.build();
          onChanged();
        } else {
          subjectBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Subject attachment and scoping settings for the media item to be created.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.MediaSubject subject = 2;</code>
       */
      public Builder mergeSubject(io.bloombox.schema.services.media.v1beta1.MediaSubject value) {
        if (subjectBuilder_ == null) {
          if (subject_ != null) {
            subject_ =
              io.bloombox.schema.services.media.v1beta1.MediaSubject.newBuilder(subject_).mergeFrom(value).buildPartial();
          } else {
            subject_ = value;
          }
          onChanged();
        } else {
          subjectBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Subject attachment and scoping settings for the media item to be created.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.MediaSubject subject = 2;</code>
       */
      public Builder clearSubject() {
        if (subjectBuilder_ == null) {
          subject_ = null;
          onChanged();
        } else {
          subject_ = null;
          subjectBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Subject attachment and scoping settings for the media item to be created.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.MediaSubject subject = 2;</code>
       */
      public io.bloombox.schema.services.media.v1beta1.MediaSubject.Builder getSubjectBuilder() {
        
        onChanged();
        return getSubjectFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Subject attachment and scoping settings for the media item to be created.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.MediaSubject subject = 2;</code>
       */
      public io.bloombox.schema.services.media.v1beta1.MediaSubjectOrBuilder getSubjectOrBuilder() {
        if (subjectBuilder_ != null) {
          return subjectBuilder_.getMessageOrBuilder();
        } else {
          return subject_ == null ?
              io.bloombox.schema.services.media.v1beta1.MediaSubject.getDefaultInstance() : subject_;
        }
      }
      /**
       * <pre>
       * Subject attachment and scoping settings for the media item to be created.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.MediaSubject subject = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.services.media.v1beta1.MediaSubject, io.bloombox.schema.services.media.v1beta1.MediaSubject.Builder, io.bloombox.schema.services.media.v1beta1.MediaSubjectOrBuilder> 
          getSubjectFieldBuilder() {
        if (subjectBuilder_ == null) {
          subjectBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.services.media.v1beta1.MediaSubject, io.bloombox.schema.services.media.v1beta1.MediaSubject.Builder, io.bloombox.schema.services.media.v1beta1.MediaSubjectOrBuilder>(
                  getSubject(),
                  getParentForChildren(),
                  isClean());
          subject_ = null;
        }
        return subjectBuilder_;
      }

      private io.bloombox.schema.services.media.v1beta1.MediaContent content_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.services.media.v1beta1.MediaContent, io.bloombox.schema.services.media.v1beta1.MediaContent.Builder, io.bloombox.schema.services.media.v1beta1.MediaContentOrBuilder> contentBuilder_;
      /**
       * <pre>
       * Inline media content, if applicable to this request.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.MediaContent content = 3;</code>
       */
      public boolean hasContent() {
        return contentBuilder_ != null || content_ != null;
      }
      /**
       * <pre>
       * Inline media content, if applicable to this request.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.MediaContent content = 3;</code>
       */
      public io.bloombox.schema.services.media.v1beta1.MediaContent getContent() {
        if (contentBuilder_ == null) {
          return content_ == null ? io.bloombox.schema.services.media.v1beta1.MediaContent.getDefaultInstance() : content_;
        } else {
          return contentBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Inline media content, if applicable to this request.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.MediaContent content = 3;</code>
       */
      public Builder setContent(io.bloombox.schema.services.media.v1beta1.MediaContent value) {
        if (contentBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          content_ = value;
          onChanged();
        } else {
          contentBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Inline media content, if applicable to this request.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.MediaContent content = 3;</code>
       */
      public Builder setContent(
          io.bloombox.schema.services.media.v1beta1.MediaContent.Builder builderForValue) {
        if (contentBuilder_ == null) {
          content_ = builderForValue.build();
          onChanged();
        } else {
          contentBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Inline media content, if applicable to this request.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.MediaContent content = 3;</code>
       */
      public Builder mergeContent(io.bloombox.schema.services.media.v1beta1.MediaContent value) {
        if (contentBuilder_ == null) {
          if (content_ != null) {
            content_ =
              io.bloombox.schema.services.media.v1beta1.MediaContent.newBuilder(content_).mergeFrom(value).buildPartial();
          } else {
            content_ = value;
          }
          onChanged();
        } else {
          contentBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Inline media content, if applicable to this request.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.MediaContent content = 3;</code>
       */
      public Builder clearContent() {
        if (contentBuilder_ == null) {
          content_ = null;
          onChanged();
        } else {
          content_ = null;
          contentBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Inline media content, if applicable to this request.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.MediaContent content = 3;</code>
       */
      public io.bloombox.schema.services.media.v1beta1.MediaContent.Builder getContentBuilder() {
        
        onChanged();
        return getContentFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Inline media content, if applicable to this request.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.MediaContent content = 3;</code>
       */
      public io.bloombox.schema.services.media.v1beta1.MediaContentOrBuilder getContentOrBuilder() {
        if (contentBuilder_ != null) {
          return contentBuilder_.getMessageOrBuilder();
        } else {
          return content_ == null ?
              io.bloombox.schema.services.media.v1beta1.MediaContent.getDefaultInstance() : content_;
        }
      }
      /**
       * <pre>
       * Inline media content, if applicable to this request.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.MediaContent content = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.services.media.v1beta1.MediaContent, io.bloombox.schema.services.media.v1beta1.MediaContent.Builder, io.bloombox.schema.services.media.v1beta1.MediaContentOrBuilder> 
          getContentFieldBuilder() {
        if (contentBuilder_ == null) {
          contentBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.services.media.v1beta1.MediaContent, io.bloombox.schema.services.media.v1beta1.MediaContent.Builder, io.bloombox.schema.services.media.v1beta1.MediaContentOrBuilder>(
                  getContent(),
                  getParentForChildren(),
                  isClean());
          content_ = null;
        }
        return contentBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.media.v1beta1.UploadMedia.Request)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.media.v1beta1.UploadMedia.Request)
    private static final io.bloombox.schema.services.media.v1beta1.UploadMedia.Request DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.media.v1beta1.UploadMedia.Request();
    }

    public static io.bloombox.schema.services.media.v1beta1.UploadMedia.Request getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Request>
        PARSER = new com.google.protobuf.AbstractParser<Request>() {
      public Request parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Request(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Request> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Request> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.media.v1beta1.UploadMedia.Request getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ResponseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.media.v1beta1.UploadMedia.Response)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Specifies an upload transaction, created/provisioned in response to the specified media upload request. When
     * this property is specified, the client is expected to transmit its upload data to the URI target specified in
     * this payload.
     * </pre>
     *
     * <code>.bloombox.schema.services.media.v1beta1.UploadTransaction transaction = 1;</code>
     */
    boolean hasTransaction();
    /**
     * <pre>
     * Specifies an upload transaction, created/provisioned in response to the specified media upload request. When
     * this property is specified, the client is expected to transmit its upload data to the URI target specified in
     * this payload.
     * </pre>
     *
     * <code>.bloombox.schema.services.media.v1beta1.UploadTransaction transaction = 1;</code>
     */
    io.bloombox.schema.services.media.v1beta1.UploadTransaction getTransaction();
    /**
     * <pre>
     * Specifies an upload transaction, created/provisioned in response to the specified media upload request. When
     * this property is specified, the client is expected to transmit its upload data to the URI target specified in
     * this payload.
     * </pre>
     *
     * <code>.bloombox.schema.services.media.v1beta1.UploadTransaction transaction = 1;</code>
     */
    io.bloombox.schema.services.media.v1beta1.UploadTransactionOrBuilder getTransactionOrBuilder();

    /**
     * <pre>
     * Specifies the result of an upload operation, when data is provided inline, or otherwise, no followup is
     * required by the client to complete the operation.
     * </pre>
     *
     * <code>.bloombox.schema.services.media.v1beta1.OperationResult result = 2;</code>
     */
    boolean hasResult();
    /**
     * <pre>
     * Specifies the result of an upload operation, when data is provided inline, or otherwise, no followup is
     * required by the client to complete the operation.
     * </pre>
     *
     * <code>.bloombox.schema.services.media.v1beta1.OperationResult result = 2;</code>
     */
    io.bloombox.schema.services.media.v1beta1.OperationResult getResult();
    /**
     * <pre>
     * Specifies the result of an upload operation, when data is provided inline, or otherwise, no followup is
     * required by the client to complete the operation.
     * </pre>
     *
     * <code>.bloombox.schema.services.media.v1beta1.OperationResult result = 2;</code>
     */
    io.bloombox.schema.services.media.v1beta1.OperationResultOrBuilder getResultOrBuilder();

    public io.bloombox.schema.services.media.v1beta1.UploadMedia.Response.OperationCase getOperationCase();
  }
  /**
   * <pre>
   * Specifies the response to a request to upload a new media item.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.media.v1beta1.UploadMedia.Response}
   */
  public  static final class Response extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.media.v1beta1.UploadMedia.Response)
      ResponseOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Response.newBuilder() to construct.
    private Response(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Response() {
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Response(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              io.bloombox.schema.services.media.v1beta1.UploadTransaction.Builder subBuilder = null;
              if (operationCase_ == 1) {
                subBuilder = ((io.bloombox.schema.services.media.v1beta1.UploadTransaction) operation_).toBuilder();
              }
              operation_ =
                  input.readMessage(io.bloombox.schema.services.media.v1beta1.UploadTransaction.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((io.bloombox.schema.services.media.v1beta1.UploadTransaction) operation_);
                operation_ = subBuilder.buildPartial();
              }
              operationCase_ = 1;
              break;
            }
            case 18: {
              io.bloombox.schema.services.media.v1beta1.OperationResult.Builder subBuilder = null;
              if (operationCase_ == 2) {
                subBuilder = ((io.bloombox.schema.services.media.v1beta1.OperationResult) operation_).toBuilder();
              }
              operation_ =
                  input.readMessage(io.bloombox.schema.services.media.v1beta1.OperationResult.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((io.bloombox.schema.services.media.v1beta1.OperationResult) operation_);
                operation_ = subBuilder.buildPartial();
              }
              operationCase_ = 2;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.media.v1beta1.MediaServiceBeta1.internal_static_bloombox_schema_services_media_v1beta1_UploadMedia_Response_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.media.v1beta1.MediaServiceBeta1.internal_static_bloombox_schema_services_media_v1beta1_UploadMedia_Response_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.media.v1beta1.UploadMedia.Response.class, io.bloombox.schema.services.media.v1beta1.UploadMedia.Response.Builder.class);
    }

    private int operationCase_ = 0;
    private java.lang.Object operation_;
    public enum OperationCase
        implements com.google.protobuf.Internal.EnumLite {
      TRANSACTION(1),
      RESULT(2),
      OPERATION_NOT_SET(0);
      private final int value;
      private OperationCase(int value) {
        this.value = value;
      }
      /**
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static OperationCase valueOf(int value) {
        return forNumber(value);
      }

      public static OperationCase forNumber(int value) {
        switch (value) {
          case 1: return TRANSACTION;
          case 2: return RESULT;
          case 0: return OPERATION_NOT_SET;
          default: return null;
        }
      }
      public int getNumber() {
        return this.value;
      }
    };

    public OperationCase
    getOperationCase() {
      return OperationCase.forNumber(
          operationCase_);
    }

    public static final int TRANSACTION_FIELD_NUMBER = 1;
    /**
     * <pre>
     * Specifies an upload transaction, created/provisioned in response to the specified media upload request. When
     * this property is specified, the client is expected to transmit its upload data to the URI target specified in
     * this payload.
     * </pre>
     *
     * <code>.bloombox.schema.services.media.v1beta1.UploadTransaction transaction = 1;</code>
     */
    public boolean hasTransaction() {
      return operationCase_ == 1;
    }
    /**
     * <pre>
     * Specifies an upload transaction, created/provisioned in response to the specified media upload request. When
     * this property is specified, the client is expected to transmit its upload data to the URI target specified in
     * this payload.
     * </pre>
     *
     * <code>.bloombox.schema.services.media.v1beta1.UploadTransaction transaction = 1;</code>
     */
    public io.bloombox.schema.services.media.v1beta1.UploadTransaction getTransaction() {
      if (operationCase_ == 1) {
         return (io.bloombox.schema.services.media.v1beta1.UploadTransaction) operation_;
      }
      return io.bloombox.schema.services.media.v1beta1.UploadTransaction.getDefaultInstance();
    }
    /**
     * <pre>
     * Specifies an upload transaction, created/provisioned in response to the specified media upload request. When
     * this property is specified, the client is expected to transmit its upload data to the URI target specified in
     * this payload.
     * </pre>
     *
     * <code>.bloombox.schema.services.media.v1beta1.UploadTransaction transaction = 1;</code>
     */
    public io.bloombox.schema.services.media.v1beta1.UploadTransactionOrBuilder getTransactionOrBuilder() {
      if (operationCase_ == 1) {
         return (io.bloombox.schema.services.media.v1beta1.UploadTransaction) operation_;
      }
      return io.bloombox.schema.services.media.v1beta1.UploadTransaction.getDefaultInstance();
    }

    public static final int RESULT_FIELD_NUMBER = 2;
    /**
     * <pre>
     * Specifies the result of an upload operation, when data is provided inline, or otherwise, no followup is
     * required by the client to complete the operation.
     * </pre>
     *
     * <code>.bloombox.schema.services.media.v1beta1.OperationResult result = 2;</code>
     */
    public boolean hasResult() {
      return operationCase_ == 2;
    }
    /**
     * <pre>
     * Specifies the result of an upload operation, when data is provided inline, or otherwise, no followup is
     * required by the client to complete the operation.
     * </pre>
     *
     * <code>.bloombox.schema.services.media.v1beta1.OperationResult result = 2;</code>
     */
    public io.bloombox.schema.services.media.v1beta1.OperationResult getResult() {
      if (operationCase_ == 2) {
         return (io.bloombox.schema.services.media.v1beta1.OperationResult) operation_;
      }
      return io.bloombox.schema.services.media.v1beta1.OperationResult.getDefaultInstance();
    }
    /**
     * <pre>
     * Specifies the result of an upload operation, when data is provided inline, or otherwise, no followup is
     * required by the client to complete the operation.
     * </pre>
     *
     * <code>.bloombox.schema.services.media.v1beta1.OperationResult result = 2;</code>
     */
    public io.bloombox.schema.services.media.v1beta1.OperationResultOrBuilder getResultOrBuilder() {
      if (operationCase_ == 2) {
         return (io.bloombox.schema.services.media.v1beta1.OperationResult) operation_;
      }
      return io.bloombox.schema.services.media.v1beta1.OperationResult.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (operationCase_ == 1) {
        output.writeMessage(1, (io.bloombox.schema.services.media.v1beta1.UploadTransaction) operation_);
      }
      if (operationCase_ == 2) {
        output.writeMessage(2, (io.bloombox.schema.services.media.v1beta1.OperationResult) operation_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (operationCase_ == 1) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, (io.bloombox.schema.services.media.v1beta1.UploadTransaction) operation_);
      }
      if (operationCase_ == 2) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, (io.bloombox.schema.services.media.v1beta1.OperationResult) operation_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.media.v1beta1.UploadMedia.Response)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.media.v1beta1.UploadMedia.Response other = (io.bloombox.schema.services.media.v1beta1.UploadMedia.Response) obj;

      boolean result = true;
      result = result && getOperationCase().equals(
          other.getOperationCase());
      if (!result) return false;
      switch (operationCase_) {
        case 1:
          result = result && getTransaction()
              .equals(other.getTransaction());
          break;
        case 2:
          result = result && getResult()
              .equals(other.getResult());
          break;
        case 0:
        default:
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (operationCase_) {
        case 1:
          hash = (37 * hash) + TRANSACTION_FIELD_NUMBER;
          hash = (53 * hash) + getTransaction().hashCode();
          break;
        case 2:
          hash = (37 * hash) + RESULT_FIELD_NUMBER;
          hash = (53 * hash) + getResult().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.media.v1beta1.UploadMedia.Response parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.media.v1beta1.UploadMedia.Response parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.media.v1beta1.UploadMedia.Response parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.media.v1beta1.UploadMedia.Response parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.media.v1beta1.UploadMedia.Response parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.media.v1beta1.UploadMedia.Response parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.media.v1beta1.UploadMedia.Response parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.media.v1beta1.UploadMedia.Response parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.media.v1beta1.UploadMedia.Response parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.media.v1beta1.UploadMedia.Response parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.media.v1beta1.UploadMedia.Response parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.media.v1beta1.UploadMedia.Response parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.media.v1beta1.UploadMedia.Response prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies the response to a request to upload a new media item.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.media.v1beta1.UploadMedia.Response}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.media.v1beta1.UploadMedia.Response)
        io.bloombox.schema.services.media.v1beta1.UploadMedia.ResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.media.v1beta1.MediaServiceBeta1.internal_static_bloombox_schema_services_media_v1beta1_UploadMedia_Response_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.media.v1beta1.MediaServiceBeta1.internal_static_bloombox_schema_services_media_v1beta1_UploadMedia_Response_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.media.v1beta1.UploadMedia.Response.class, io.bloombox.schema.services.media.v1beta1.UploadMedia.Response.Builder.class);
      }

      // Construct using io.bloombox.schema.services.media.v1beta1.UploadMedia.Response.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        operationCase_ = 0;
        operation_ = null;
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.media.v1beta1.MediaServiceBeta1.internal_static_bloombox_schema_services_media_v1beta1_UploadMedia_Response_descriptor;
      }

      public io.bloombox.schema.services.media.v1beta1.UploadMedia.Response getDefaultInstanceForType() {
        return io.bloombox.schema.services.media.v1beta1.UploadMedia.Response.getDefaultInstance();
      }

      public io.bloombox.schema.services.media.v1beta1.UploadMedia.Response build() {
        io.bloombox.schema.services.media.v1beta1.UploadMedia.Response result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.media.v1beta1.UploadMedia.Response buildPartial() {
        io.bloombox.schema.services.media.v1beta1.UploadMedia.Response result = new io.bloombox.schema.services.media.v1beta1.UploadMedia.Response(this);
        if (operationCase_ == 1) {
          if (transactionBuilder_ == null) {
            result.operation_ = operation_;
          } else {
            result.operation_ = transactionBuilder_.build();
          }
        }
        if (operationCase_ == 2) {
          if (resultBuilder_ == null) {
            result.operation_ = operation_;
          } else {
            result.operation_ = resultBuilder_.build();
          }
        }
        result.operationCase_ = operationCase_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.media.v1beta1.UploadMedia.Response) {
          return mergeFrom((io.bloombox.schema.services.media.v1beta1.UploadMedia.Response)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.media.v1beta1.UploadMedia.Response other) {
        if (other == io.bloombox.schema.services.media.v1beta1.UploadMedia.Response.getDefaultInstance()) return this;
        switch (other.getOperationCase()) {
          case TRANSACTION: {
            mergeTransaction(other.getTransaction());
            break;
          }
          case RESULT: {
            mergeResult(other.getResult());
            break;
          }
          case OPERATION_NOT_SET: {
            break;
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.media.v1beta1.UploadMedia.Response parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.media.v1beta1.UploadMedia.Response) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int operationCase_ = 0;
      private java.lang.Object operation_;
      public OperationCase
          getOperationCase() {
        return OperationCase.forNumber(
            operationCase_);
      }

      public Builder clearOperation() {
        operationCase_ = 0;
        operation_ = null;
        onChanged();
        return this;
      }


      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.services.media.v1beta1.UploadTransaction, io.bloombox.schema.services.media.v1beta1.UploadTransaction.Builder, io.bloombox.schema.services.media.v1beta1.UploadTransactionOrBuilder> transactionBuilder_;
      /**
       * <pre>
       * Specifies an upload transaction, created/provisioned in response to the specified media upload request. When
       * this property is specified, the client is expected to transmit its upload data to the URI target specified in
       * this payload.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.UploadTransaction transaction = 1;</code>
       */
      public boolean hasTransaction() {
        return operationCase_ == 1;
      }
      /**
       * <pre>
       * Specifies an upload transaction, created/provisioned in response to the specified media upload request. When
       * this property is specified, the client is expected to transmit its upload data to the URI target specified in
       * this payload.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.UploadTransaction transaction = 1;</code>
       */
      public io.bloombox.schema.services.media.v1beta1.UploadTransaction getTransaction() {
        if (transactionBuilder_ == null) {
          if (operationCase_ == 1) {
            return (io.bloombox.schema.services.media.v1beta1.UploadTransaction) operation_;
          }
          return io.bloombox.schema.services.media.v1beta1.UploadTransaction.getDefaultInstance();
        } else {
          if (operationCase_ == 1) {
            return transactionBuilder_.getMessage();
          }
          return io.bloombox.schema.services.media.v1beta1.UploadTransaction.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Specifies an upload transaction, created/provisioned in response to the specified media upload request. When
       * this property is specified, the client is expected to transmit its upload data to the URI target specified in
       * this payload.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.UploadTransaction transaction = 1;</code>
       */
      public Builder setTransaction(io.bloombox.schema.services.media.v1beta1.UploadTransaction value) {
        if (transactionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          operation_ = value;
          onChanged();
        } else {
          transactionBuilder_.setMessage(value);
        }
        operationCase_ = 1;
        return this;
      }
      /**
       * <pre>
       * Specifies an upload transaction, created/provisioned in response to the specified media upload request. When
       * this property is specified, the client is expected to transmit its upload data to the URI target specified in
       * this payload.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.UploadTransaction transaction = 1;</code>
       */
      public Builder setTransaction(
          io.bloombox.schema.services.media.v1beta1.UploadTransaction.Builder builderForValue) {
        if (transactionBuilder_ == null) {
          operation_ = builderForValue.build();
          onChanged();
        } else {
          transactionBuilder_.setMessage(builderForValue.build());
        }
        operationCase_ = 1;
        return this;
      }
      /**
       * <pre>
       * Specifies an upload transaction, created/provisioned in response to the specified media upload request. When
       * this property is specified, the client is expected to transmit its upload data to the URI target specified in
       * this payload.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.UploadTransaction transaction = 1;</code>
       */
      public Builder mergeTransaction(io.bloombox.schema.services.media.v1beta1.UploadTransaction value) {
        if (transactionBuilder_ == null) {
          if (operationCase_ == 1 &&
              operation_ != io.bloombox.schema.services.media.v1beta1.UploadTransaction.getDefaultInstance()) {
            operation_ = io.bloombox.schema.services.media.v1beta1.UploadTransaction.newBuilder((io.bloombox.schema.services.media.v1beta1.UploadTransaction) operation_)
                .mergeFrom(value).buildPartial();
          } else {
            operation_ = value;
          }
          onChanged();
        } else {
          if (operationCase_ == 1) {
            transactionBuilder_.mergeFrom(value);
          }
          transactionBuilder_.setMessage(value);
        }
        operationCase_ = 1;
        return this;
      }
      /**
       * <pre>
       * Specifies an upload transaction, created/provisioned in response to the specified media upload request. When
       * this property is specified, the client is expected to transmit its upload data to the URI target specified in
       * this payload.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.UploadTransaction transaction = 1;</code>
       */
      public Builder clearTransaction() {
        if (transactionBuilder_ == null) {
          if (operationCase_ == 1) {
            operationCase_ = 0;
            operation_ = null;
            onChanged();
          }
        } else {
          if (operationCase_ == 1) {
            operationCase_ = 0;
            operation_ = null;
          }
          transactionBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Specifies an upload transaction, created/provisioned in response to the specified media upload request. When
       * this property is specified, the client is expected to transmit its upload data to the URI target specified in
       * this payload.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.UploadTransaction transaction = 1;</code>
       */
      public io.bloombox.schema.services.media.v1beta1.UploadTransaction.Builder getTransactionBuilder() {
        return getTransactionFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Specifies an upload transaction, created/provisioned in response to the specified media upload request. When
       * this property is specified, the client is expected to transmit its upload data to the URI target specified in
       * this payload.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.UploadTransaction transaction = 1;</code>
       */
      public io.bloombox.schema.services.media.v1beta1.UploadTransactionOrBuilder getTransactionOrBuilder() {
        if ((operationCase_ == 1) && (transactionBuilder_ != null)) {
          return transactionBuilder_.getMessageOrBuilder();
        } else {
          if (operationCase_ == 1) {
            return (io.bloombox.schema.services.media.v1beta1.UploadTransaction) operation_;
          }
          return io.bloombox.schema.services.media.v1beta1.UploadTransaction.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Specifies an upload transaction, created/provisioned in response to the specified media upload request. When
       * this property is specified, the client is expected to transmit its upload data to the URI target specified in
       * this payload.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.UploadTransaction transaction = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.services.media.v1beta1.UploadTransaction, io.bloombox.schema.services.media.v1beta1.UploadTransaction.Builder, io.bloombox.schema.services.media.v1beta1.UploadTransactionOrBuilder> 
          getTransactionFieldBuilder() {
        if (transactionBuilder_ == null) {
          if (!(operationCase_ == 1)) {
            operation_ = io.bloombox.schema.services.media.v1beta1.UploadTransaction.getDefaultInstance();
          }
          transactionBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.services.media.v1beta1.UploadTransaction, io.bloombox.schema.services.media.v1beta1.UploadTransaction.Builder, io.bloombox.schema.services.media.v1beta1.UploadTransactionOrBuilder>(
                  (io.bloombox.schema.services.media.v1beta1.UploadTransaction) operation_,
                  getParentForChildren(),
                  isClean());
          operation_ = null;
        }
        operationCase_ = 1;
        onChanged();;
        return transactionBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.services.media.v1beta1.OperationResult, io.bloombox.schema.services.media.v1beta1.OperationResult.Builder, io.bloombox.schema.services.media.v1beta1.OperationResultOrBuilder> resultBuilder_;
      /**
       * <pre>
       * Specifies the result of an upload operation, when data is provided inline, or otherwise, no followup is
       * required by the client to complete the operation.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.OperationResult result = 2;</code>
       */
      public boolean hasResult() {
        return operationCase_ == 2;
      }
      /**
       * <pre>
       * Specifies the result of an upload operation, when data is provided inline, or otherwise, no followup is
       * required by the client to complete the operation.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.OperationResult result = 2;</code>
       */
      public io.bloombox.schema.services.media.v1beta1.OperationResult getResult() {
        if (resultBuilder_ == null) {
          if (operationCase_ == 2) {
            return (io.bloombox.schema.services.media.v1beta1.OperationResult) operation_;
          }
          return io.bloombox.schema.services.media.v1beta1.OperationResult.getDefaultInstance();
        } else {
          if (operationCase_ == 2) {
            return resultBuilder_.getMessage();
          }
          return io.bloombox.schema.services.media.v1beta1.OperationResult.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Specifies the result of an upload operation, when data is provided inline, or otherwise, no followup is
       * required by the client to complete the operation.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.OperationResult result = 2;</code>
       */
      public Builder setResult(io.bloombox.schema.services.media.v1beta1.OperationResult value) {
        if (resultBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          operation_ = value;
          onChanged();
        } else {
          resultBuilder_.setMessage(value);
        }
        operationCase_ = 2;
        return this;
      }
      /**
       * <pre>
       * Specifies the result of an upload operation, when data is provided inline, or otherwise, no followup is
       * required by the client to complete the operation.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.OperationResult result = 2;</code>
       */
      public Builder setResult(
          io.bloombox.schema.services.media.v1beta1.OperationResult.Builder builderForValue) {
        if (resultBuilder_ == null) {
          operation_ = builderForValue.build();
          onChanged();
        } else {
          resultBuilder_.setMessage(builderForValue.build());
        }
        operationCase_ = 2;
        return this;
      }
      /**
       * <pre>
       * Specifies the result of an upload operation, when data is provided inline, or otherwise, no followup is
       * required by the client to complete the operation.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.OperationResult result = 2;</code>
       */
      public Builder mergeResult(io.bloombox.schema.services.media.v1beta1.OperationResult value) {
        if (resultBuilder_ == null) {
          if (operationCase_ == 2 &&
              operation_ != io.bloombox.schema.services.media.v1beta1.OperationResult.getDefaultInstance()) {
            operation_ = io.bloombox.schema.services.media.v1beta1.OperationResult.newBuilder((io.bloombox.schema.services.media.v1beta1.OperationResult) operation_)
                .mergeFrom(value).buildPartial();
          } else {
            operation_ = value;
          }
          onChanged();
        } else {
          if (operationCase_ == 2) {
            resultBuilder_.mergeFrom(value);
          }
          resultBuilder_.setMessage(value);
        }
        operationCase_ = 2;
        return this;
      }
      /**
       * <pre>
       * Specifies the result of an upload operation, when data is provided inline, or otherwise, no followup is
       * required by the client to complete the operation.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.OperationResult result = 2;</code>
       */
      public Builder clearResult() {
        if (resultBuilder_ == null) {
          if (operationCase_ == 2) {
            operationCase_ = 0;
            operation_ = null;
            onChanged();
          }
        } else {
          if (operationCase_ == 2) {
            operationCase_ = 0;
            operation_ = null;
          }
          resultBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Specifies the result of an upload operation, when data is provided inline, or otherwise, no followup is
       * required by the client to complete the operation.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.OperationResult result = 2;</code>
       */
      public io.bloombox.schema.services.media.v1beta1.OperationResult.Builder getResultBuilder() {
        return getResultFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Specifies the result of an upload operation, when data is provided inline, or otherwise, no followup is
       * required by the client to complete the operation.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.OperationResult result = 2;</code>
       */
      public io.bloombox.schema.services.media.v1beta1.OperationResultOrBuilder getResultOrBuilder() {
        if ((operationCase_ == 2) && (resultBuilder_ != null)) {
          return resultBuilder_.getMessageOrBuilder();
        } else {
          if (operationCase_ == 2) {
            return (io.bloombox.schema.services.media.v1beta1.OperationResult) operation_;
          }
          return io.bloombox.schema.services.media.v1beta1.OperationResult.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Specifies the result of an upload operation, when data is provided inline, or otherwise, no followup is
       * required by the client to complete the operation.
       * </pre>
       *
       * <code>.bloombox.schema.services.media.v1beta1.OperationResult result = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.services.media.v1beta1.OperationResult, io.bloombox.schema.services.media.v1beta1.OperationResult.Builder, io.bloombox.schema.services.media.v1beta1.OperationResultOrBuilder> 
          getResultFieldBuilder() {
        if (resultBuilder_ == null) {
          if (!(operationCase_ == 2)) {
            operation_ = io.bloombox.schema.services.media.v1beta1.OperationResult.getDefaultInstance();
          }
          resultBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.services.media.v1beta1.OperationResult, io.bloombox.schema.services.media.v1beta1.OperationResult.Builder, io.bloombox.schema.services.media.v1beta1.OperationResultOrBuilder>(
                  (io.bloombox.schema.services.media.v1beta1.OperationResult) operation_,
                  getParentForChildren(),
                  isClean());
          operation_ = null;
        }
        operationCase_ = 2;
        onChanged();;
        return resultBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.media.v1beta1.UploadMedia.Response)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.media.v1beta1.UploadMedia.Response)
    private static final io.bloombox.schema.services.media.v1beta1.UploadMedia.Response DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.media.v1beta1.UploadMedia.Response();
    }

    public static io.bloombox.schema.services.media.v1beta1.UploadMedia.Response getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Response>
        PARSER = new com.google.protobuf.AbstractParser<Response>() {
      public Response parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Response(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Response> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Response> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.media.v1beta1.UploadMedia.Response getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.services.media.v1beta1.UploadMedia)) {
      return super.equals(obj);
    }
    io.bloombox.schema.services.media.v1beta1.UploadMedia other = (io.bloombox.schema.services.media.v1beta1.UploadMedia) obj;

    boolean result = true;
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.services.media.v1beta1.UploadMedia parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.media.v1beta1.UploadMedia parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.media.v1beta1.UploadMedia parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.media.v1beta1.UploadMedia parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.media.v1beta1.UploadMedia parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.media.v1beta1.UploadMedia parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.media.v1beta1.UploadMedia parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.media.v1beta1.UploadMedia parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.media.v1beta1.UploadMedia parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.media.v1beta1.UploadMedia parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.media.v1beta1.UploadMedia parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.media.v1beta1.UploadMedia parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.services.media.v1beta1.UploadMedia prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies an RPC operation to upload a new piece of media, provisioning a media item record (and key) along the way.
   * The resulting key, or an error encountered while attempting to fulfill the operation, is returned.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.media.v1beta1.UploadMedia}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.services.media.v1beta1.UploadMedia)
      io.bloombox.schema.services.media.v1beta1.UploadMediaOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.media.v1beta1.MediaServiceBeta1.internal_static_bloombox_schema_services_media_v1beta1_UploadMedia_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.media.v1beta1.MediaServiceBeta1.internal_static_bloombox_schema_services_media_v1beta1_UploadMedia_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.media.v1beta1.UploadMedia.class, io.bloombox.schema.services.media.v1beta1.UploadMedia.Builder.class);
    }

    // Construct using io.bloombox.schema.services.media.v1beta1.UploadMedia.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.services.media.v1beta1.MediaServiceBeta1.internal_static_bloombox_schema_services_media_v1beta1_UploadMedia_descriptor;
    }

    public io.bloombox.schema.services.media.v1beta1.UploadMedia getDefaultInstanceForType() {
      return io.bloombox.schema.services.media.v1beta1.UploadMedia.getDefaultInstance();
    }

    public io.bloombox.schema.services.media.v1beta1.UploadMedia build() {
      io.bloombox.schema.services.media.v1beta1.UploadMedia result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.services.media.v1beta1.UploadMedia buildPartial() {
      io.bloombox.schema.services.media.v1beta1.UploadMedia result = new io.bloombox.schema.services.media.v1beta1.UploadMedia(this);
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.services.media.v1beta1.UploadMedia) {
        return mergeFrom((io.bloombox.schema.services.media.v1beta1.UploadMedia)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.services.media.v1beta1.UploadMedia other) {
      if (other == io.bloombox.schema.services.media.v1beta1.UploadMedia.getDefaultInstance()) return this;
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.services.media.v1beta1.UploadMedia parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.services.media.v1beta1.UploadMedia) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.services.media.v1beta1.UploadMedia)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.services.media.v1beta1.UploadMedia)
  private static final io.bloombox.schema.services.media.v1beta1.UploadMedia DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.services.media.v1beta1.UploadMedia();
  }

  public static io.bloombox.schema.services.media.v1beta1.UploadMedia getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UploadMedia>
      PARSER = new com.google.protobuf.AbstractParser<UploadMedia>() {
    public UploadMedia parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new UploadMedia(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<UploadMedia> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UploadMedia> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.services.media.v1beta1.UploadMedia getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

