/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: menu/v1beta1/MenuService_Beta1.proto

package io.bloombox.schema.services.menu.v1beta1;

/**
 * <pre>
 * Specifies an RPC operation to retrieve the set of keys, if any, of products currently featured, for the whole menu
 * or a section thereof.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.services.menu.v1beta1.GetFeatured}
 */
public  final class GetFeatured extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.services.menu.v1beta1.GetFeatured)
    GetFeaturedOrBuilder {
private static final long serialVersionUID = 0L;
  // Use GetFeatured.newBuilder() to construct.
  private GetFeatured(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private GetFeatured() {
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private GetFeatured(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetFeatured_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetFeatured_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.services.menu.v1beta1.GetFeatured.class, io.bloombox.schema.services.menu.v1beta1.GetFeatured.Builder.class);
  }

  public interface RequestOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.menu.v1beta1.GetFeatured.Request)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Partnership scope for the request.
     * </pre>
     *
     * <code>string scope = 1;</code>
     */
    java.lang.String getScope();
    /**
     * <pre>
     * Partnership scope for the request.
     * </pre>
     *
     * <code>string scope = 1;</code>
     */
    com.google.protobuf.ByteString
        getScopeBytes();

    /**
     * <pre>
     * Return keys-only. Should default to true in client library implementations.
     * </pre>
     *
     * <code>bool keys_only = 2;</code>
     */
    boolean getKeysOnly();

    /**
     * <pre>
     * Sections to include in the menu. If unspecified, include all sections.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.Section section = 3;</code>
     */
    int getSectionValue();
    /**
     * <pre>
     * Sections to include in the menu. If unspecified, include all sections.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.Section section = 3;</code>
     */
    io.opencannabis.schema.menu.section.Section getSection();
  }
  /**
   * <pre>
   * Specifies an RPC request to retrieve featured product keys.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.menu.v1beta1.GetFeatured.Request}
   */
  public  static final class Request extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.menu.v1beta1.GetFeatured.Request)
      RequestOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Request.newBuilder() to construct.
    private Request(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Request() {
      scope_ = "";
      keysOnly_ = false;
      section_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Request(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              scope_ = s;
              break;
            }
            case 16: {

              keysOnly_ = input.readBool();
              break;
            }
            case 24: {
              int rawValue = input.readEnum();

              section_ = rawValue;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetFeatured_Request_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetFeatured_Request_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request.class, io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request.Builder.class);
    }

    public static final int SCOPE_FIELD_NUMBER = 1;
    private volatile java.lang.Object scope_;
    /**
     * <pre>
     * Partnership scope for the request.
     * </pre>
     *
     * <code>string scope = 1;</code>
     */
    public java.lang.String getScope() {
      java.lang.Object ref = scope_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        scope_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Partnership scope for the request.
     * </pre>
     *
     * <code>string scope = 1;</code>
     */
    public com.google.protobuf.ByteString
        getScopeBytes() {
      java.lang.Object ref = scope_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        scope_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int KEYS_ONLY_FIELD_NUMBER = 2;
    private boolean keysOnly_;
    /**
     * <pre>
     * Return keys-only. Should default to true in client library implementations.
     * </pre>
     *
     * <code>bool keys_only = 2;</code>
     */
    public boolean getKeysOnly() {
      return keysOnly_;
    }

    public static final int SECTION_FIELD_NUMBER = 3;
    private int section_;
    /**
     * <pre>
     * Sections to include in the menu. If unspecified, include all sections.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.Section section = 3;</code>
     */
    public int getSectionValue() {
      return section_;
    }
    /**
     * <pre>
     * Sections to include in the menu. If unspecified, include all sections.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.Section section = 3;</code>
     */
    public io.opencannabis.schema.menu.section.Section getSection() {
      io.opencannabis.schema.menu.section.Section result = io.opencannabis.schema.menu.section.Section.valueOf(section_);
      return result == null ? io.opencannabis.schema.menu.section.Section.UNRECOGNIZED : result;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getScopeBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, scope_);
      }
      if (keysOnly_ != false) {
        output.writeBool(2, keysOnly_);
      }
      if (section_ != io.opencannabis.schema.menu.section.Section.UNSPECIFIED.getNumber()) {
        output.writeEnum(3, section_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getScopeBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, scope_);
      }
      if (keysOnly_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(2, keysOnly_);
      }
      if (section_ != io.opencannabis.schema.menu.section.Section.UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(3, section_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request other = (io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request) obj;

      boolean result = true;
      result = result && getScope()
          .equals(other.getScope());
      result = result && (getKeysOnly()
          == other.getKeysOnly());
      result = result && section_ == other.section_;
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SCOPE_FIELD_NUMBER;
      hash = (53 * hash) + getScope().hashCode();
      hash = (37 * hash) + KEYS_ONLY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getKeysOnly());
      hash = (37 * hash) + SECTION_FIELD_NUMBER;
      hash = (53 * hash) + section_;
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies an RPC request to retrieve featured product keys.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.menu.v1beta1.GetFeatured.Request}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.menu.v1beta1.GetFeatured.Request)
        io.bloombox.schema.services.menu.v1beta1.GetFeatured.RequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetFeatured_Request_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetFeatured_Request_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request.class, io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request.Builder.class);
      }

      // Construct using io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        scope_ = "";

        keysOnly_ = false;

        section_ = 0;

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetFeatured_Request_descriptor;
      }

      public io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request getDefaultInstanceForType() {
        return io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request.getDefaultInstance();
      }

      public io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request build() {
        io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request buildPartial() {
        io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request result = new io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request(this);
        result.scope_ = scope_;
        result.keysOnly_ = keysOnly_;
        result.section_ = section_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request) {
          return mergeFrom((io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request other) {
        if (other == io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request.getDefaultInstance()) return this;
        if (!other.getScope().isEmpty()) {
          scope_ = other.scope_;
          onChanged();
        }
        if (other.getKeysOnly() != false) {
          setKeysOnly(other.getKeysOnly());
        }
        if (other.section_ != 0) {
          setSectionValue(other.getSectionValue());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object scope_ = "";
      /**
       * <pre>
       * Partnership scope for the request.
       * </pre>
       *
       * <code>string scope = 1;</code>
       */
      public java.lang.String getScope() {
        java.lang.Object ref = scope_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          scope_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Partnership scope for the request.
       * </pre>
       *
       * <code>string scope = 1;</code>
       */
      public com.google.protobuf.ByteString
          getScopeBytes() {
        java.lang.Object ref = scope_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          scope_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Partnership scope for the request.
       * </pre>
       *
       * <code>string scope = 1;</code>
       */
      public Builder setScope(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        scope_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Partnership scope for the request.
       * </pre>
       *
       * <code>string scope = 1;</code>
       */
      public Builder clearScope() {
        
        scope_ = getDefaultInstance().getScope();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Partnership scope for the request.
       * </pre>
       *
       * <code>string scope = 1;</code>
       */
      public Builder setScopeBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        scope_ = value;
        onChanged();
        return this;
      }

      private boolean keysOnly_ ;
      /**
       * <pre>
       * Return keys-only. Should default to true in client library implementations.
       * </pre>
       *
       * <code>bool keys_only = 2;</code>
       */
      public boolean getKeysOnly() {
        return keysOnly_;
      }
      /**
       * <pre>
       * Return keys-only. Should default to true in client library implementations.
       * </pre>
       *
       * <code>bool keys_only = 2;</code>
       */
      public Builder setKeysOnly(boolean value) {
        
        keysOnly_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Return keys-only. Should default to true in client library implementations.
       * </pre>
       *
       * <code>bool keys_only = 2;</code>
       */
      public Builder clearKeysOnly() {
        
        keysOnly_ = false;
        onChanged();
        return this;
      }

      private int section_ = 0;
      /**
       * <pre>
       * Sections to include in the menu. If unspecified, include all sections.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.Section section = 3;</code>
       */
      public int getSectionValue() {
        return section_;
      }
      /**
       * <pre>
       * Sections to include in the menu. If unspecified, include all sections.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.Section section = 3;</code>
       */
      public Builder setSectionValue(int value) {
        section_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Sections to include in the menu. If unspecified, include all sections.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.Section section = 3;</code>
       */
      public io.opencannabis.schema.menu.section.Section getSection() {
        io.opencannabis.schema.menu.section.Section result = io.opencannabis.schema.menu.section.Section.valueOf(section_);
        return result == null ? io.opencannabis.schema.menu.section.Section.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Sections to include in the menu. If unspecified, include all sections.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.Section section = 3;</code>
       */
      public Builder setSection(io.opencannabis.schema.menu.section.Section value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        section_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Sections to include in the menu. If unspecified, include all sections.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.Section section = 3;</code>
       */
      public Builder clearSection() {
        
        section_ = 0;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.menu.v1beta1.GetFeatured.Request)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.menu.v1beta1.GetFeatured.Request)
    private static final io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request();
    }

    public static io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Request>
        PARSER = new com.google.protobuf.AbstractParser<Request>() {
      public Request parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Request(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Request> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Request> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.menu.v1beta1.GetFeatured.Request getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ResponseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.menu.v1beta1.GetFeatured.Response)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Featured items, listed in response to the submitted request.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.MenuProduct featured = 1;</code>
     */
    java.util.List<io.opencannabis.schema.menu.MenuProduct> 
        getFeaturedList();
    /**
     * <pre>
     * Featured items, listed in response to the submitted request.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.MenuProduct featured = 1;</code>
     */
    io.opencannabis.schema.menu.MenuProduct getFeatured(int index);
    /**
     * <pre>
     * Featured items, listed in response to the submitted request.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.MenuProduct featured = 1;</code>
     */
    int getFeaturedCount();
    /**
     * <pre>
     * Featured items, listed in response to the submitted request.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.MenuProduct featured = 1;</code>
     */
    java.util.List<? extends io.opencannabis.schema.menu.MenuProductOrBuilder> 
        getFeaturedOrBuilderList();
    /**
     * <pre>
     * Featured items, listed in response to the submitted request.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.MenuProduct featured = 1;</code>
     */
    io.opencannabis.schema.menu.MenuProductOrBuilder getFeaturedOrBuilder(
        int index);
  }
  /**
   * <pre>
   * Specifies the response to a request to fetch keys of currently-featured menu items.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.menu.v1beta1.GetFeatured.Response}
   */
  public  static final class Response extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.menu.v1beta1.GetFeatured.Response)
      ResponseOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Response.newBuilder() to construct.
    private Response(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Response() {
      featured_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Response(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                featured_ = new java.util.ArrayList<io.opencannabis.schema.menu.MenuProduct>();
                mutable_bitField0_ |= 0x00000001;
              }
              featured_.add(
                  input.readMessage(io.opencannabis.schema.menu.MenuProduct.parser(), extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          featured_ = java.util.Collections.unmodifiableList(featured_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetFeatured_Response_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetFeatured_Response_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response.class, io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response.Builder.class);
    }

    public static final int FEATURED_FIELD_NUMBER = 1;
    private java.util.List<io.opencannabis.schema.menu.MenuProduct> featured_;
    /**
     * <pre>
     * Featured items, listed in response to the submitted request.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.MenuProduct featured = 1;</code>
     */
    public java.util.List<io.opencannabis.schema.menu.MenuProduct> getFeaturedList() {
      return featured_;
    }
    /**
     * <pre>
     * Featured items, listed in response to the submitted request.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.MenuProduct featured = 1;</code>
     */
    public java.util.List<? extends io.opencannabis.schema.menu.MenuProductOrBuilder> 
        getFeaturedOrBuilderList() {
      return featured_;
    }
    /**
     * <pre>
     * Featured items, listed in response to the submitted request.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.MenuProduct featured = 1;</code>
     */
    public int getFeaturedCount() {
      return featured_.size();
    }
    /**
     * <pre>
     * Featured items, listed in response to the submitted request.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.MenuProduct featured = 1;</code>
     */
    public io.opencannabis.schema.menu.MenuProduct getFeatured(int index) {
      return featured_.get(index);
    }
    /**
     * <pre>
     * Featured items, listed in response to the submitted request.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.MenuProduct featured = 1;</code>
     */
    public io.opencannabis.schema.menu.MenuProductOrBuilder getFeaturedOrBuilder(
        int index) {
      return featured_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      for (int i = 0; i < featured_.size(); i++) {
        output.writeMessage(1, featured_.get(i));
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < featured_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, featured_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response other = (io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response) obj;

      boolean result = true;
      result = result && getFeaturedList()
          .equals(other.getFeaturedList());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getFeaturedCount() > 0) {
        hash = (37 * hash) + FEATURED_FIELD_NUMBER;
        hash = (53 * hash) + getFeaturedList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies the response to a request to fetch keys of currently-featured menu items.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.menu.v1beta1.GetFeatured.Response}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.menu.v1beta1.GetFeatured.Response)
        io.bloombox.schema.services.menu.v1beta1.GetFeatured.ResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetFeatured_Response_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetFeatured_Response_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response.class, io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response.Builder.class);
      }

      // Construct using io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getFeaturedFieldBuilder();
        }
      }
      public Builder clear() {
        super.clear();
        if (featuredBuilder_ == null) {
          featured_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          featuredBuilder_.clear();
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetFeatured_Response_descriptor;
      }

      public io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response getDefaultInstanceForType() {
        return io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response.getDefaultInstance();
      }

      public io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response build() {
        io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response buildPartial() {
        io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response result = new io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response(this);
        int from_bitField0_ = bitField0_;
        if (featuredBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)) {
            featured_ = java.util.Collections.unmodifiableList(featured_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.featured_ = featured_;
        } else {
          result.featured_ = featuredBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response) {
          return mergeFrom((io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response other) {
        if (other == io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response.getDefaultInstance()) return this;
        if (featuredBuilder_ == null) {
          if (!other.featured_.isEmpty()) {
            if (featured_.isEmpty()) {
              featured_ = other.featured_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureFeaturedIsMutable();
              featured_.addAll(other.featured_);
            }
            onChanged();
          }
        } else {
          if (!other.featured_.isEmpty()) {
            if (featuredBuilder_.isEmpty()) {
              featuredBuilder_.dispose();
              featuredBuilder_ = null;
              featured_ = other.featured_;
              bitField0_ = (bitField0_ & ~0x00000001);
              featuredBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getFeaturedFieldBuilder() : null;
            } else {
              featuredBuilder_.addAllMessages(other.featured_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.util.List<io.opencannabis.schema.menu.MenuProduct> featured_ =
        java.util.Collections.emptyList();
      private void ensureFeaturedIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          featured_ = new java.util.ArrayList<io.opencannabis.schema.menu.MenuProduct>(featured_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.opencannabis.schema.menu.MenuProduct, io.opencannabis.schema.menu.MenuProduct.Builder, io.opencannabis.schema.menu.MenuProductOrBuilder> featuredBuilder_;

      /**
       * <pre>
       * Featured items, listed in response to the submitted request.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct featured = 1;</code>
       */
      public java.util.List<io.opencannabis.schema.menu.MenuProduct> getFeaturedList() {
        if (featuredBuilder_ == null) {
          return java.util.Collections.unmodifiableList(featured_);
        } else {
          return featuredBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Featured items, listed in response to the submitted request.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct featured = 1;</code>
       */
      public int getFeaturedCount() {
        if (featuredBuilder_ == null) {
          return featured_.size();
        } else {
          return featuredBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Featured items, listed in response to the submitted request.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct featured = 1;</code>
       */
      public io.opencannabis.schema.menu.MenuProduct getFeatured(int index) {
        if (featuredBuilder_ == null) {
          return featured_.get(index);
        } else {
          return featuredBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Featured items, listed in response to the submitted request.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct featured = 1;</code>
       */
      public Builder setFeatured(
          int index, io.opencannabis.schema.menu.MenuProduct value) {
        if (featuredBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFeaturedIsMutable();
          featured_.set(index, value);
          onChanged();
        } else {
          featuredBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Featured items, listed in response to the submitted request.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct featured = 1;</code>
       */
      public Builder setFeatured(
          int index, io.opencannabis.schema.menu.MenuProduct.Builder builderForValue) {
        if (featuredBuilder_ == null) {
          ensureFeaturedIsMutable();
          featured_.set(index, builderForValue.build());
          onChanged();
        } else {
          featuredBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Featured items, listed in response to the submitted request.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct featured = 1;</code>
       */
      public Builder addFeatured(io.opencannabis.schema.menu.MenuProduct value) {
        if (featuredBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFeaturedIsMutable();
          featured_.add(value);
          onChanged();
        } else {
          featuredBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Featured items, listed in response to the submitted request.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct featured = 1;</code>
       */
      public Builder addFeatured(
          int index, io.opencannabis.schema.menu.MenuProduct value) {
        if (featuredBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFeaturedIsMutable();
          featured_.add(index, value);
          onChanged();
        } else {
          featuredBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Featured items, listed in response to the submitted request.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct featured = 1;</code>
       */
      public Builder addFeatured(
          io.opencannabis.schema.menu.MenuProduct.Builder builderForValue) {
        if (featuredBuilder_ == null) {
          ensureFeaturedIsMutable();
          featured_.add(builderForValue.build());
          onChanged();
        } else {
          featuredBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Featured items, listed in response to the submitted request.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct featured = 1;</code>
       */
      public Builder addFeatured(
          int index, io.opencannabis.schema.menu.MenuProduct.Builder builderForValue) {
        if (featuredBuilder_ == null) {
          ensureFeaturedIsMutable();
          featured_.add(index, builderForValue.build());
          onChanged();
        } else {
          featuredBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Featured items, listed in response to the submitted request.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct featured = 1;</code>
       */
      public Builder addAllFeatured(
          java.lang.Iterable<? extends io.opencannabis.schema.menu.MenuProduct> values) {
        if (featuredBuilder_ == null) {
          ensureFeaturedIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, featured_);
          onChanged();
        } else {
          featuredBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Featured items, listed in response to the submitted request.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct featured = 1;</code>
       */
      public Builder clearFeatured() {
        if (featuredBuilder_ == null) {
          featured_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          featuredBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Featured items, listed in response to the submitted request.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct featured = 1;</code>
       */
      public Builder removeFeatured(int index) {
        if (featuredBuilder_ == null) {
          ensureFeaturedIsMutable();
          featured_.remove(index);
          onChanged();
        } else {
          featuredBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Featured items, listed in response to the submitted request.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct featured = 1;</code>
       */
      public io.opencannabis.schema.menu.MenuProduct.Builder getFeaturedBuilder(
          int index) {
        return getFeaturedFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Featured items, listed in response to the submitted request.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct featured = 1;</code>
       */
      public io.opencannabis.schema.menu.MenuProductOrBuilder getFeaturedOrBuilder(
          int index) {
        if (featuredBuilder_ == null) {
          return featured_.get(index);  } else {
          return featuredBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Featured items, listed in response to the submitted request.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct featured = 1;</code>
       */
      public java.util.List<? extends io.opencannabis.schema.menu.MenuProductOrBuilder> 
           getFeaturedOrBuilderList() {
        if (featuredBuilder_ != null) {
          return featuredBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(featured_);
        }
      }
      /**
       * <pre>
       * Featured items, listed in response to the submitted request.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct featured = 1;</code>
       */
      public io.opencannabis.schema.menu.MenuProduct.Builder addFeaturedBuilder() {
        return getFeaturedFieldBuilder().addBuilder(
            io.opencannabis.schema.menu.MenuProduct.getDefaultInstance());
      }
      /**
       * <pre>
       * Featured items, listed in response to the submitted request.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct featured = 1;</code>
       */
      public io.opencannabis.schema.menu.MenuProduct.Builder addFeaturedBuilder(
          int index) {
        return getFeaturedFieldBuilder().addBuilder(
            index, io.opencannabis.schema.menu.MenuProduct.getDefaultInstance());
      }
      /**
       * <pre>
       * Featured items, listed in response to the submitted request.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct featured = 1;</code>
       */
      public java.util.List<io.opencannabis.schema.menu.MenuProduct.Builder> 
           getFeaturedBuilderList() {
        return getFeaturedFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.opencannabis.schema.menu.MenuProduct, io.opencannabis.schema.menu.MenuProduct.Builder, io.opencannabis.schema.menu.MenuProductOrBuilder> 
          getFeaturedFieldBuilder() {
        if (featuredBuilder_ == null) {
          featuredBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              io.opencannabis.schema.menu.MenuProduct, io.opencannabis.schema.menu.MenuProduct.Builder, io.opencannabis.schema.menu.MenuProductOrBuilder>(
                  featured_,
                  ((bitField0_ & 0x00000001) == 0x00000001),
                  getParentForChildren(),
                  isClean());
          featured_ = null;
        }
        return featuredBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.menu.v1beta1.GetFeatured.Response)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.menu.v1beta1.GetFeatured.Response)
    private static final io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response();
    }

    public static io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Response>
        PARSER = new com.google.protobuf.AbstractParser<Response>() {
      public Response parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Response(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Response> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Response> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.menu.v1beta1.GetFeatured.Response getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.services.menu.v1beta1.GetFeatured)) {
      return super.equals(obj);
    }
    io.bloombox.schema.services.menu.v1beta1.GetFeatured other = (io.bloombox.schema.services.menu.v1beta1.GetFeatured) obj;

    boolean result = true;
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.services.menu.v1beta1.GetFeatured parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.menu.v1beta1.GetFeatured parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.menu.v1beta1.GetFeatured parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.menu.v1beta1.GetFeatured parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.menu.v1beta1.GetFeatured parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.menu.v1beta1.GetFeatured parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.menu.v1beta1.GetFeatured parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.menu.v1beta1.GetFeatured parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.menu.v1beta1.GetFeatured parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.menu.v1beta1.GetFeatured parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.menu.v1beta1.GetFeatured parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.menu.v1beta1.GetFeatured parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.services.menu.v1beta1.GetFeatured prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies an RPC operation to retrieve the set of keys, if any, of products currently featured, for the whole menu
   * or a section thereof.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.menu.v1beta1.GetFeatured}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.services.menu.v1beta1.GetFeatured)
      io.bloombox.schema.services.menu.v1beta1.GetFeaturedOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetFeatured_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetFeatured_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.menu.v1beta1.GetFeatured.class, io.bloombox.schema.services.menu.v1beta1.GetFeatured.Builder.class);
    }

    // Construct using io.bloombox.schema.services.menu.v1beta1.GetFeatured.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetFeatured_descriptor;
    }

    public io.bloombox.schema.services.menu.v1beta1.GetFeatured getDefaultInstanceForType() {
      return io.bloombox.schema.services.menu.v1beta1.GetFeatured.getDefaultInstance();
    }

    public io.bloombox.schema.services.menu.v1beta1.GetFeatured build() {
      io.bloombox.schema.services.menu.v1beta1.GetFeatured result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.services.menu.v1beta1.GetFeatured buildPartial() {
      io.bloombox.schema.services.menu.v1beta1.GetFeatured result = new io.bloombox.schema.services.menu.v1beta1.GetFeatured(this);
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.services.menu.v1beta1.GetFeatured) {
        return mergeFrom((io.bloombox.schema.services.menu.v1beta1.GetFeatured)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.services.menu.v1beta1.GetFeatured other) {
      if (other == io.bloombox.schema.services.menu.v1beta1.GetFeatured.getDefaultInstance()) return this;
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.services.menu.v1beta1.GetFeatured parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.services.menu.v1beta1.GetFeatured) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.services.menu.v1beta1.GetFeatured)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.services.menu.v1beta1.GetFeatured)
  private static final io.bloombox.schema.services.menu.v1beta1.GetFeatured DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.services.menu.v1beta1.GetFeatured();
  }

  public static io.bloombox.schema.services.menu.v1beta1.GetFeatured getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GetFeatured>
      PARSER = new com.google.protobuf.AbstractParser<GetFeatured>() {
    public GetFeatured parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new GetFeatured(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<GetFeatured> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GetFeatured> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.services.menu.v1beta1.GetFeatured getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

