/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: menu/v1beta1/MenuService_Beta1.proto

package io.bloombox.schema.services.menu.v1beta1;

/**
 * <pre>
 * Specifies an RPC operation to retrieve menu data, either in full (i.e. the entire menu, compose of all sections), or
 * for a given set of specified sections.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.services.menu.v1beta1.GetMenu}
 */
public  final class GetMenu extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.services.menu.v1beta1.GetMenu)
    GetMenuOrBuilder {
private static final long serialVersionUID = 0L;
  // Use GetMenu.newBuilder() to construct.
  private GetMenu(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private GetMenu() {
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private GetMenu(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetMenu_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetMenu_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.services.menu.v1beta1.GetMenu.class, io.bloombox.schema.services.menu.v1beta1.GetMenu.Builder.class);
  }

  public interface RequestOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.menu.v1beta1.GetMenu.Request)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Partnership scope for the request.
     * </pre>
     *
     * <code>string scope = 1;</code>
     */
    java.lang.String getScope();
    /**
     * <pre>
     * Partnership scope for the request.
     * </pre>
     *
     * <code>string scope = 1;</code>
     */
    com.google.protobuf.ByteString
        getScopeBytes();

    /**
     * <pre>
     * Flag indicating a full menu, including hidden/out-of-stock items.
     * </pre>
     *
     * <code>bool full = 2;</code>
     */
    boolean getFull();

    /**
     * <pre>
     * Only include menu keys, no detail data.
     * </pre>
     *
     * <code>bool keys_only = 3;</code>
     */
    boolean getKeysOnly();

    /**
     * <pre>
     * Don't return the menu if it's identical to this fingerprint.
     * </pre>
     *
     * <code>string snapshot = 4;</code>
     */
    java.lang.String getSnapshot();
    /**
     * <pre>
     * Don't return the menu if it's identical to this fingerprint.
     * </pre>
     *
     * <code>string snapshot = 4;</code>
     */
    com.google.protobuf.ByteString
        getSnapshotBytes();

    /**
     * <pre>
     * Bloom filter to consider when returning or processing menu items.
     * </pre>
     *
     * <code>string fingerprint = 5;</code>
     */
    java.lang.String getFingerprint();
    /**
     * <pre>
     * Bloom filter to consider when returning or processing menu items.
     * </pre>
     *
     * <code>string fingerprint = 5;</code>
     */
    com.google.protobuf.ByteString
        getFingerprintBytes();

    /**
     * <pre>
     * Sections to include in the menu. If unspecified, include all sections.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.Section section = 6;</code>
     */
    int getSectionValue();
    /**
     * <pre>
     * Sections to include in the menu. If unspecified, include all sections.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.Section section = 6;</code>
     */
    io.opencannabis.schema.menu.section.Section getSection();

    /**
     * <pre>
     * Whether to request an uncached menu.
     * </pre>
     *
     * <code>bool fresh = 7;</code>
     */
    boolean getFresh();
  }
  /**
   * <pre>
   * Request payload to retrieve a menu.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.menu.v1beta1.GetMenu.Request}
   */
  public  static final class Request extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.menu.v1beta1.GetMenu.Request)
      RequestOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Request.newBuilder() to construct.
    private Request(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Request() {
      scope_ = "";
      full_ = false;
      keysOnly_ = false;
      snapshot_ = "";
      fingerprint_ = "";
      section_ = 0;
      fresh_ = false;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Request(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              scope_ = s;
              break;
            }
            case 16: {

              full_ = input.readBool();
              break;
            }
            case 24: {

              keysOnly_ = input.readBool();
              break;
            }
            case 34: {
              java.lang.String s = input.readStringRequireUtf8();

              snapshot_ = s;
              break;
            }
            case 42: {
              java.lang.String s = input.readStringRequireUtf8();

              fingerprint_ = s;
              break;
            }
            case 48: {
              int rawValue = input.readEnum();

              section_ = rawValue;
              break;
            }
            case 56: {

              fresh_ = input.readBool();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetMenu_Request_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetMenu_Request_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.menu.v1beta1.GetMenu.Request.class, io.bloombox.schema.services.menu.v1beta1.GetMenu.Request.Builder.class);
    }

    public static final int SCOPE_FIELD_NUMBER = 1;
    private volatile java.lang.Object scope_;
    /**
     * <pre>
     * Partnership scope for the request.
     * </pre>
     *
     * <code>string scope = 1;</code>
     */
    public java.lang.String getScope() {
      java.lang.Object ref = scope_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        scope_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Partnership scope for the request.
     * </pre>
     *
     * <code>string scope = 1;</code>
     */
    public com.google.protobuf.ByteString
        getScopeBytes() {
      java.lang.Object ref = scope_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        scope_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FULL_FIELD_NUMBER = 2;
    private boolean full_;
    /**
     * <pre>
     * Flag indicating a full menu, including hidden/out-of-stock items.
     * </pre>
     *
     * <code>bool full = 2;</code>
     */
    public boolean getFull() {
      return full_;
    }

    public static final int KEYS_ONLY_FIELD_NUMBER = 3;
    private boolean keysOnly_;
    /**
     * <pre>
     * Only include menu keys, no detail data.
     * </pre>
     *
     * <code>bool keys_only = 3;</code>
     */
    public boolean getKeysOnly() {
      return keysOnly_;
    }

    public static final int SNAPSHOT_FIELD_NUMBER = 4;
    private volatile java.lang.Object snapshot_;
    /**
     * <pre>
     * Don't return the menu if it's identical to this fingerprint.
     * </pre>
     *
     * <code>string snapshot = 4;</code>
     */
    public java.lang.String getSnapshot() {
      java.lang.Object ref = snapshot_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        snapshot_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Don't return the menu if it's identical to this fingerprint.
     * </pre>
     *
     * <code>string snapshot = 4;</code>
     */
    public com.google.protobuf.ByteString
        getSnapshotBytes() {
      java.lang.Object ref = snapshot_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        snapshot_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FINGERPRINT_FIELD_NUMBER = 5;
    private volatile java.lang.Object fingerprint_;
    /**
     * <pre>
     * Bloom filter to consider when returning or processing menu items.
     * </pre>
     *
     * <code>string fingerprint = 5;</code>
     */
    public java.lang.String getFingerprint() {
      java.lang.Object ref = fingerprint_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fingerprint_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Bloom filter to consider when returning or processing menu items.
     * </pre>
     *
     * <code>string fingerprint = 5;</code>
     */
    public com.google.protobuf.ByteString
        getFingerprintBytes() {
      java.lang.Object ref = fingerprint_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        fingerprint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SECTION_FIELD_NUMBER = 6;
    private int section_;
    /**
     * <pre>
     * Sections to include in the menu. If unspecified, include all sections.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.Section section = 6;</code>
     */
    public int getSectionValue() {
      return section_;
    }
    /**
     * <pre>
     * Sections to include in the menu. If unspecified, include all sections.
     * </pre>
     *
     * <code>.opencannabis.products.menu.section.Section section = 6;</code>
     */
    public io.opencannabis.schema.menu.section.Section getSection() {
      io.opencannabis.schema.menu.section.Section result = io.opencannabis.schema.menu.section.Section.valueOf(section_);
      return result == null ? io.opencannabis.schema.menu.section.Section.UNRECOGNIZED : result;
    }

    public static final int FRESH_FIELD_NUMBER = 7;
    private boolean fresh_;
    /**
     * <pre>
     * Whether to request an uncached menu.
     * </pre>
     *
     * <code>bool fresh = 7;</code>
     */
    public boolean getFresh() {
      return fresh_;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getScopeBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, scope_);
      }
      if (full_ != false) {
        output.writeBool(2, full_);
      }
      if (keysOnly_ != false) {
        output.writeBool(3, keysOnly_);
      }
      if (!getSnapshotBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, snapshot_);
      }
      if (!getFingerprintBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, fingerprint_);
      }
      if (section_ != io.opencannabis.schema.menu.section.Section.UNSPECIFIED.getNumber()) {
        output.writeEnum(6, section_);
      }
      if (fresh_ != false) {
        output.writeBool(7, fresh_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getScopeBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, scope_);
      }
      if (full_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(2, full_);
      }
      if (keysOnly_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(3, keysOnly_);
      }
      if (!getSnapshotBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, snapshot_);
      }
      if (!getFingerprintBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, fingerprint_);
      }
      if (section_ != io.opencannabis.schema.menu.section.Section.UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(6, section_);
      }
      if (fresh_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(7, fresh_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.menu.v1beta1.GetMenu.Request)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.menu.v1beta1.GetMenu.Request other = (io.bloombox.schema.services.menu.v1beta1.GetMenu.Request) obj;

      boolean result = true;
      result = result && getScope()
          .equals(other.getScope());
      result = result && (getFull()
          == other.getFull());
      result = result && (getKeysOnly()
          == other.getKeysOnly());
      result = result && getSnapshot()
          .equals(other.getSnapshot());
      result = result && getFingerprint()
          .equals(other.getFingerprint());
      result = result && section_ == other.section_;
      result = result && (getFresh()
          == other.getFresh());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SCOPE_FIELD_NUMBER;
      hash = (53 * hash) + getScope().hashCode();
      hash = (37 * hash) + FULL_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getFull());
      hash = (37 * hash) + KEYS_ONLY_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getKeysOnly());
      hash = (37 * hash) + SNAPSHOT_FIELD_NUMBER;
      hash = (53 * hash) + getSnapshot().hashCode();
      hash = (37 * hash) + FINGERPRINT_FIELD_NUMBER;
      hash = (53 * hash) + getFingerprint().hashCode();
      hash = (37 * hash) + SECTION_FIELD_NUMBER;
      hash = (53 * hash) + section_;
      hash = (37 * hash) + FRESH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getFresh());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.menu.v1beta1.GetMenu.Request parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetMenu.Request parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetMenu.Request parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetMenu.Request parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetMenu.Request parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetMenu.Request parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetMenu.Request parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetMenu.Request parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetMenu.Request parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetMenu.Request parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetMenu.Request parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetMenu.Request parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.menu.v1beta1.GetMenu.Request prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Request payload to retrieve a menu.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.menu.v1beta1.GetMenu.Request}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.menu.v1beta1.GetMenu.Request)
        io.bloombox.schema.services.menu.v1beta1.GetMenu.RequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetMenu_Request_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetMenu_Request_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.menu.v1beta1.GetMenu.Request.class, io.bloombox.schema.services.menu.v1beta1.GetMenu.Request.Builder.class);
      }

      // Construct using io.bloombox.schema.services.menu.v1beta1.GetMenu.Request.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        scope_ = "";

        full_ = false;

        keysOnly_ = false;

        snapshot_ = "";

        fingerprint_ = "";

        section_ = 0;

        fresh_ = false;

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetMenu_Request_descriptor;
      }

      public io.bloombox.schema.services.menu.v1beta1.GetMenu.Request getDefaultInstanceForType() {
        return io.bloombox.schema.services.menu.v1beta1.GetMenu.Request.getDefaultInstance();
      }

      public io.bloombox.schema.services.menu.v1beta1.GetMenu.Request build() {
        io.bloombox.schema.services.menu.v1beta1.GetMenu.Request result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.menu.v1beta1.GetMenu.Request buildPartial() {
        io.bloombox.schema.services.menu.v1beta1.GetMenu.Request result = new io.bloombox.schema.services.menu.v1beta1.GetMenu.Request(this);
        result.scope_ = scope_;
        result.full_ = full_;
        result.keysOnly_ = keysOnly_;
        result.snapshot_ = snapshot_;
        result.fingerprint_ = fingerprint_;
        result.section_ = section_;
        result.fresh_ = fresh_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.menu.v1beta1.GetMenu.Request) {
          return mergeFrom((io.bloombox.schema.services.menu.v1beta1.GetMenu.Request)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.menu.v1beta1.GetMenu.Request other) {
        if (other == io.bloombox.schema.services.menu.v1beta1.GetMenu.Request.getDefaultInstance()) return this;
        if (!other.getScope().isEmpty()) {
          scope_ = other.scope_;
          onChanged();
        }
        if (other.getFull() != false) {
          setFull(other.getFull());
        }
        if (other.getKeysOnly() != false) {
          setKeysOnly(other.getKeysOnly());
        }
        if (!other.getSnapshot().isEmpty()) {
          snapshot_ = other.snapshot_;
          onChanged();
        }
        if (!other.getFingerprint().isEmpty()) {
          fingerprint_ = other.fingerprint_;
          onChanged();
        }
        if (other.section_ != 0) {
          setSectionValue(other.getSectionValue());
        }
        if (other.getFresh() != false) {
          setFresh(other.getFresh());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.menu.v1beta1.GetMenu.Request parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.menu.v1beta1.GetMenu.Request) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object scope_ = "";
      /**
       * <pre>
       * Partnership scope for the request.
       * </pre>
       *
       * <code>string scope = 1;</code>
       */
      public java.lang.String getScope() {
        java.lang.Object ref = scope_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          scope_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Partnership scope for the request.
       * </pre>
       *
       * <code>string scope = 1;</code>
       */
      public com.google.protobuf.ByteString
          getScopeBytes() {
        java.lang.Object ref = scope_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          scope_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Partnership scope for the request.
       * </pre>
       *
       * <code>string scope = 1;</code>
       */
      public Builder setScope(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        scope_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Partnership scope for the request.
       * </pre>
       *
       * <code>string scope = 1;</code>
       */
      public Builder clearScope() {
        
        scope_ = getDefaultInstance().getScope();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Partnership scope for the request.
       * </pre>
       *
       * <code>string scope = 1;</code>
       */
      public Builder setScopeBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        scope_ = value;
        onChanged();
        return this;
      }

      private boolean full_ ;
      /**
       * <pre>
       * Flag indicating a full menu, including hidden/out-of-stock items.
       * </pre>
       *
       * <code>bool full = 2;</code>
       */
      public boolean getFull() {
        return full_;
      }
      /**
       * <pre>
       * Flag indicating a full menu, including hidden/out-of-stock items.
       * </pre>
       *
       * <code>bool full = 2;</code>
       */
      public Builder setFull(boolean value) {
        
        full_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Flag indicating a full menu, including hidden/out-of-stock items.
       * </pre>
       *
       * <code>bool full = 2;</code>
       */
      public Builder clearFull() {
        
        full_ = false;
        onChanged();
        return this;
      }

      private boolean keysOnly_ ;
      /**
       * <pre>
       * Only include menu keys, no detail data.
       * </pre>
       *
       * <code>bool keys_only = 3;</code>
       */
      public boolean getKeysOnly() {
        return keysOnly_;
      }
      /**
       * <pre>
       * Only include menu keys, no detail data.
       * </pre>
       *
       * <code>bool keys_only = 3;</code>
       */
      public Builder setKeysOnly(boolean value) {
        
        keysOnly_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Only include menu keys, no detail data.
       * </pre>
       *
       * <code>bool keys_only = 3;</code>
       */
      public Builder clearKeysOnly() {
        
        keysOnly_ = false;
        onChanged();
        return this;
      }

      private java.lang.Object snapshot_ = "";
      /**
       * <pre>
       * Don't return the menu if it's identical to this fingerprint.
       * </pre>
       *
       * <code>string snapshot = 4;</code>
       */
      public java.lang.String getSnapshot() {
        java.lang.Object ref = snapshot_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          snapshot_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Don't return the menu if it's identical to this fingerprint.
       * </pre>
       *
       * <code>string snapshot = 4;</code>
       */
      public com.google.protobuf.ByteString
          getSnapshotBytes() {
        java.lang.Object ref = snapshot_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          snapshot_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Don't return the menu if it's identical to this fingerprint.
       * </pre>
       *
       * <code>string snapshot = 4;</code>
       */
      public Builder setSnapshot(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        snapshot_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Don't return the menu if it's identical to this fingerprint.
       * </pre>
       *
       * <code>string snapshot = 4;</code>
       */
      public Builder clearSnapshot() {
        
        snapshot_ = getDefaultInstance().getSnapshot();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Don't return the menu if it's identical to this fingerprint.
       * </pre>
       *
       * <code>string snapshot = 4;</code>
       */
      public Builder setSnapshotBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        snapshot_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object fingerprint_ = "";
      /**
       * <pre>
       * Bloom filter to consider when returning or processing menu items.
       * </pre>
       *
       * <code>string fingerprint = 5;</code>
       */
      public java.lang.String getFingerprint() {
        java.lang.Object ref = fingerprint_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          fingerprint_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Bloom filter to consider when returning or processing menu items.
       * </pre>
       *
       * <code>string fingerprint = 5;</code>
       */
      public com.google.protobuf.ByteString
          getFingerprintBytes() {
        java.lang.Object ref = fingerprint_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          fingerprint_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Bloom filter to consider when returning or processing menu items.
       * </pre>
       *
       * <code>string fingerprint = 5;</code>
       */
      public Builder setFingerprint(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        fingerprint_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Bloom filter to consider when returning or processing menu items.
       * </pre>
       *
       * <code>string fingerprint = 5;</code>
       */
      public Builder clearFingerprint() {
        
        fingerprint_ = getDefaultInstance().getFingerprint();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Bloom filter to consider when returning or processing menu items.
       * </pre>
       *
       * <code>string fingerprint = 5;</code>
       */
      public Builder setFingerprintBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        fingerprint_ = value;
        onChanged();
        return this;
      }

      private int section_ = 0;
      /**
       * <pre>
       * Sections to include in the menu. If unspecified, include all sections.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.Section section = 6;</code>
       */
      public int getSectionValue() {
        return section_;
      }
      /**
       * <pre>
       * Sections to include in the menu. If unspecified, include all sections.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.Section section = 6;</code>
       */
      public Builder setSectionValue(int value) {
        section_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Sections to include in the menu. If unspecified, include all sections.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.Section section = 6;</code>
       */
      public io.opencannabis.schema.menu.section.Section getSection() {
        io.opencannabis.schema.menu.section.Section result = io.opencannabis.schema.menu.section.Section.valueOf(section_);
        return result == null ? io.opencannabis.schema.menu.section.Section.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Sections to include in the menu. If unspecified, include all sections.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.Section section = 6;</code>
       */
      public Builder setSection(io.opencannabis.schema.menu.section.Section value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        section_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Sections to include in the menu. If unspecified, include all sections.
       * </pre>
       *
       * <code>.opencannabis.products.menu.section.Section section = 6;</code>
       */
      public Builder clearSection() {
        
        section_ = 0;
        onChanged();
        return this;
      }

      private boolean fresh_ ;
      /**
       * <pre>
       * Whether to request an uncached menu.
       * </pre>
       *
       * <code>bool fresh = 7;</code>
       */
      public boolean getFresh() {
        return fresh_;
      }
      /**
       * <pre>
       * Whether to request an uncached menu.
       * </pre>
       *
       * <code>bool fresh = 7;</code>
       */
      public Builder setFresh(boolean value) {
        
        fresh_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Whether to request an uncached menu.
       * </pre>
       *
       * <code>bool fresh = 7;</code>
       */
      public Builder clearFresh() {
        
        fresh_ = false;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.menu.v1beta1.GetMenu.Request)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.menu.v1beta1.GetMenu.Request)
    private static final io.bloombox.schema.services.menu.v1beta1.GetMenu.Request DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.menu.v1beta1.GetMenu.Request();
    }

    public static io.bloombox.schema.services.menu.v1beta1.GetMenu.Request getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Request>
        PARSER = new com.google.protobuf.AbstractParser<Request>() {
      public Request parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Request(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Request> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Request> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.menu.v1beta1.GetMenu.Request getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ResponseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.menu.v1beta1.GetMenu.Response)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Specifies the actual menu data payload returned in this response. The menu payload is independently usable, and
     * includes any raw data or metadata needed to process the menu.
     * </pre>
     *
     * <code>.opencannabis.products.menu.Menu catalog = 1;</code>
     */
    boolean hasCatalog();
    /**
     * <pre>
     * Specifies the actual menu data payload returned in this response. The menu payload is independently usable, and
     * includes any raw data or metadata needed to process the menu.
     * </pre>
     *
     * <code>.opencannabis.products.menu.Menu catalog = 1;</code>
     */
    io.opencannabis.schema.menu.Menu getCatalog();
    /**
     * <pre>
     * Specifies the actual menu data payload returned in this response. The menu payload is independently usable, and
     * includes any raw data or metadata needed to process the menu.
     * </pre>
     *
     * <code>.opencannabis.products.menu.Menu catalog = 1;</code>
     */
    io.opencannabis.schema.menu.MenuOrBuilder getCatalogOrBuilder();

    /**
     * <pre>
     * Whether the returned menu was cached or not.
     * </pre>
     *
     * <code>bool cached = 2;</code>
     */
    boolean getCached();
  }
  /**
   * <pre>
   * Specifies the response to a request to retrieve menu data.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.menu.v1beta1.GetMenu.Response}
   */
  public  static final class Response extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.menu.v1beta1.GetMenu.Response)
      ResponseOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Response.newBuilder() to construct.
    private Response(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Response() {
      cached_ = false;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Response(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              io.opencannabis.schema.menu.Menu.Builder subBuilder = null;
              if (catalog_ != null) {
                subBuilder = catalog_.toBuilder();
              }
              catalog_ = input.readMessage(io.opencannabis.schema.menu.Menu.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(catalog_);
                catalog_ = subBuilder.buildPartial();
              }

              break;
            }
            case 16: {

              cached_ = input.readBool();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetMenu_Response_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetMenu_Response_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.menu.v1beta1.GetMenu.Response.class, io.bloombox.schema.services.menu.v1beta1.GetMenu.Response.Builder.class);
    }

    public static final int CATALOG_FIELD_NUMBER = 1;
    private io.opencannabis.schema.menu.Menu catalog_;
    /**
     * <pre>
     * Specifies the actual menu data payload returned in this response. The menu payload is independently usable, and
     * includes any raw data or metadata needed to process the menu.
     * </pre>
     *
     * <code>.opencannabis.products.menu.Menu catalog = 1;</code>
     */
    public boolean hasCatalog() {
      return catalog_ != null;
    }
    /**
     * <pre>
     * Specifies the actual menu data payload returned in this response. The menu payload is independently usable, and
     * includes any raw data or metadata needed to process the menu.
     * </pre>
     *
     * <code>.opencannabis.products.menu.Menu catalog = 1;</code>
     */
    public io.opencannabis.schema.menu.Menu getCatalog() {
      return catalog_ == null ? io.opencannabis.schema.menu.Menu.getDefaultInstance() : catalog_;
    }
    /**
     * <pre>
     * Specifies the actual menu data payload returned in this response. The menu payload is independently usable, and
     * includes any raw data or metadata needed to process the menu.
     * </pre>
     *
     * <code>.opencannabis.products.menu.Menu catalog = 1;</code>
     */
    public io.opencannabis.schema.menu.MenuOrBuilder getCatalogOrBuilder() {
      return getCatalog();
    }

    public static final int CACHED_FIELD_NUMBER = 2;
    private boolean cached_;
    /**
     * <pre>
     * Whether the returned menu was cached or not.
     * </pre>
     *
     * <code>bool cached = 2;</code>
     */
    public boolean getCached() {
      return cached_;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (catalog_ != null) {
        output.writeMessage(1, getCatalog());
      }
      if (cached_ != false) {
        output.writeBool(2, cached_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (catalog_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getCatalog());
      }
      if (cached_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(2, cached_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.menu.v1beta1.GetMenu.Response)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.menu.v1beta1.GetMenu.Response other = (io.bloombox.schema.services.menu.v1beta1.GetMenu.Response) obj;

      boolean result = true;
      result = result && (hasCatalog() == other.hasCatalog());
      if (hasCatalog()) {
        result = result && getCatalog()
            .equals(other.getCatalog());
      }
      result = result && (getCached()
          == other.getCached());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasCatalog()) {
        hash = (37 * hash) + CATALOG_FIELD_NUMBER;
        hash = (53 * hash) + getCatalog().hashCode();
      }
      hash = (37 * hash) + CACHED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getCached());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.menu.v1beta1.GetMenu.Response parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetMenu.Response parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetMenu.Response parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetMenu.Response parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetMenu.Response parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetMenu.Response parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetMenu.Response parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetMenu.Response parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetMenu.Response parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetMenu.Response parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetMenu.Response parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetMenu.Response parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.menu.v1beta1.GetMenu.Response prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies the response to a request to retrieve menu data.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.menu.v1beta1.GetMenu.Response}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.menu.v1beta1.GetMenu.Response)
        io.bloombox.schema.services.menu.v1beta1.GetMenu.ResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetMenu_Response_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetMenu_Response_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.menu.v1beta1.GetMenu.Response.class, io.bloombox.schema.services.menu.v1beta1.GetMenu.Response.Builder.class);
      }

      // Construct using io.bloombox.schema.services.menu.v1beta1.GetMenu.Response.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        if (catalogBuilder_ == null) {
          catalog_ = null;
        } else {
          catalog_ = null;
          catalogBuilder_ = null;
        }
        cached_ = false;

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetMenu_Response_descriptor;
      }

      public io.bloombox.schema.services.menu.v1beta1.GetMenu.Response getDefaultInstanceForType() {
        return io.bloombox.schema.services.menu.v1beta1.GetMenu.Response.getDefaultInstance();
      }

      public io.bloombox.schema.services.menu.v1beta1.GetMenu.Response build() {
        io.bloombox.schema.services.menu.v1beta1.GetMenu.Response result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.menu.v1beta1.GetMenu.Response buildPartial() {
        io.bloombox.schema.services.menu.v1beta1.GetMenu.Response result = new io.bloombox.schema.services.menu.v1beta1.GetMenu.Response(this);
        if (catalogBuilder_ == null) {
          result.catalog_ = catalog_;
        } else {
          result.catalog_ = catalogBuilder_.build();
        }
        result.cached_ = cached_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.menu.v1beta1.GetMenu.Response) {
          return mergeFrom((io.bloombox.schema.services.menu.v1beta1.GetMenu.Response)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.menu.v1beta1.GetMenu.Response other) {
        if (other == io.bloombox.schema.services.menu.v1beta1.GetMenu.Response.getDefaultInstance()) return this;
        if (other.hasCatalog()) {
          mergeCatalog(other.getCatalog());
        }
        if (other.getCached() != false) {
          setCached(other.getCached());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.menu.v1beta1.GetMenu.Response parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.menu.v1beta1.GetMenu.Response) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private io.opencannabis.schema.menu.Menu catalog_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.menu.Menu, io.opencannabis.schema.menu.Menu.Builder, io.opencannabis.schema.menu.MenuOrBuilder> catalogBuilder_;
      /**
       * <pre>
       * Specifies the actual menu data payload returned in this response. The menu payload is independently usable, and
       * includes any raw data or metadata needed to process the menu.
       * </pre>
       *
       * <code>.opencannabis.products.menu.Menu catalog = 1;</code>
       */
      public boolean hasCatalog() {
        return catalogBuilder_ != null || catalog_ != null;
      }
      /**
       * <pre>
       * Specifies the actual menu data payload returned in this response. The menu payload is independently usable, and
       * includes any raw data or metadata needed to process the menu.
       * </pre>
       *
       * <code>.opencannabis.products.menu.Menu catalog = 1;</code>
       */
      public io.opencannabis.schema.menu.Menu getCatalog() {
        if (catalogBuilder_ == null) {
          return catalog_ == null ? io.opencannabis.schema.menu.Menu.getDefaultInstance() : catalog_;
        } else {
          return catalogBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Specifies the actual menu data payload returned in this response. The menu payload is independently usable, and
       * includes any raw data or metadata needed to process the menu.
       * </pre>
       *
       * <code>.opencannabis.products.menu.Menu catalog = 1;</code>
       */
      public Builder setCatalog(io.opencannabis.schema.menu.Menu value) {
        if (catalogBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          catalog_ = value;
          onChanged();
        } else {
          catalogBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies the actual menu data payload returned in this response. The menu payload is independently usable, and
       * includes any raw data or metadata needed to process the menu.
       * </pre>
       *
       * <code>.opencannabis.products.menu.Menu catalog = 1;</code>
       */
      public Builder setCatalog(
          io.opencannabis.schema.menu.Menu.Builder builderForValue) {
        if (catalogBuilder_ == null) {
          catalog_ = builderForValue.build();
          onChanged();
        } else {
          catalogBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Specifies the actual menu data payload returned in this response. The menu payload is independently usable, and
       * includes any raw data or metadata needed to process the menu.
       * </pre>
       *
       * <code>.opencannabis.products.menu.Menu catalog = 1;</code>
       */
      public Builder mergeCatalog(io.opencannabis.schema.menu.Menu value) {
        if (catalogBuilder_ == null) {
          if (catalog_ != null) {
            catalog_ =
              io.opencannabis.schema.menu.Menu.newBuilder(catalog_).mergeFrom(value).buildPartial();
          } else {
            catalog_ = value;
          }
          onChanged();
        } else {
          catalogBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies the actual menu data payload returned in this response. The menu payload is independently usable, and
       * includes any raw data or metadata needed to process the menu.
       * </pre>
       *
       * <code>.opencannabis.products.menu.Menu catalog = 1;</code>
       */
      public Builder clearCatalog() {
        if (catalogBuilder_ == null) {
          catalog_ = null;
          onChanged();
        } else {
          catalog_ = null;
          catalogBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Specifies the actual menu data payload returned in this response. The menu payload is independently usable, and
       * includes any raw data or metadata needed to process the menu.
       * </pre>
       *
       * <code>.opencannabis.products.menu.Menu catalog = 1;</code>
       */
      public io.opencannabis.schema.menu.Menu.Builder getCatalogBuilder() {
        
        onChanged();
        return getCatalogFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Specifies the actual menu data payload returned in this response. The menu payload is independently usable, and
       * includes any raw data or metadata needed to process the menu.
       * </pre>
       *
       * <code>.opencannabis.products.menu.Menu catalog = 1;</code>
       */
      public io.opencannabis.schema.menu.MenuOrBuilder getCatalogOrBuilder() {
        if (catalogBuilder_ != null) {
          return catalogBuilder_.getMessageOrBuilder();
        } else {
          return catalog_ == null ?
              io.opencannabis.schema.menu.Menu.getDefaultInstance() : catalog_;
        }
      }
      /**
       * <pre>
       * Specifies the actual menu data payload returned in this response. The menu payload is independently usable, and
       * includes any raw data or metadata needed to process the menu.
       * </pre>
       *
       * <code>.opencannabis.products.menu.Menu catalog = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.menu.Menu, io.opencannabis.schema.menu.Menu.Builder, io.opencannabis.schema.menu.MenuOrBuilder> 
          getCatalogFieldBuilder() {
        if (catalogBuilder_ == null) {
          catalogBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.menu.Menu, io.opencannabis.schema.menu.Menu.Builder, io.opencannabis.schema.menu.MenuOrBuilder>(
                  getCatalog(),
                  getParentForChildren(),
                  isClean());
          catalog_ = null;
        }
        return catalogBuilder_;
      }

      private boolean cached_ ;
      /**
       * <pre>
       * Whether the returned menu was cached or not.
       * </pre>
       *
       * <code>bool cached = 2;</code>
       */
      public boolean getCached() {
        return cached_;
      }
      /**
       * <pre>
       * Whether the returned menu was cached or not.
       * </pre>
       *
       * <code>bool cached = 2;</code>
       */
      public Builder setCached(boolean value) {
        
        cached_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Whether the returned menu was cached or not.
       * </pre>
       *
       * <code>bool cached = 2;</code>
       */
      public Builder clearCached() {
        
        cached_ = false;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.menu.v1beta1.GetMenu.Response)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.menu.v1beta1.GetMenu.Response)
    private static final io.bloombox.schema.services.menu.v1beta1.GetMenu.Response DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.menu.v1beta1.GetMenu.Response();
    }

    public static io.bloombox.schema.services.menu.v1beta1.GetMenu.Response getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Response>
        PARSER = new com.google.protobuf.AbstractParser<Response>() {
      public Response parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Response(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Response> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Response> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.menu.v1beta1.GetMenu.Response getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.services.menu.v1beta1.GetMenu)) {
      return super.equals(obj);
    }
    io.bloombox.schema.services.menu.v1beta1.GetMenu other = (io.bloombox.schema.services.menu.v1beta1.GetMenu) obj;

    boolean result = true;
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.services.menu.v1beta1.GetMenu parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.menu.v1beta1.GetMenu parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.menu.v1beta1.GetMenu parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.menu.v1beta1.GetMenu parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.menu.v1beta1.GetMenu parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.menu.v1beta1.GetMenu parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.menu.v1beta1.GetMenu parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.menu.v1beta1.GetMenu parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.menu.v1beta1.GetMenu parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.menu.v1beta1.GetMenu parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.menu.v1beta1.GetMenu parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.menu.v1beta1.GetMenu parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.services.menu.v1beta1.GetMenu prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies an RPC operation to retrieve menu data, either in full (i.e. the entire menu, compose of all sections), or
   * for a given set of specified sections.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.menu.v1beta1.GetMenu}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.services.menu.v1beta1.GetMenu)
      io.bloombox.schema.services.menu.v1beta1.GetMenuOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetMenu_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetMenu_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.menu.v1beta1.GetMenu.class, io.bloombox.schema.services.menu.v1beta1.GetMenu.Builder.class);
    }

    // Construct using io.bloombox.schema.services.menu.v1beta1.GetMenu.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetMenu_descriptor;
    }

    public io.bloombox.schema.services.menu.v1beta1.GetMenu getDefaultInstanceForType() {
      return io.bloombox.schema.services.menu.v1beta1.GetMenu.getDefaultInstance();
    }

    public io.bloombox.schema.services.menu.v1beta1.GetMenu build() {
      io.bloombox.schema.services.menu.v1beta1.GetMenu result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.services.menu.v1beta1.GetMenu buildPartial() {
      io.bloombox.schema.services.menu.v1beta1.GetMenu result = new io.bloombox.schema.services.menu.v1beta1.GetMenu(this);
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.services.menu.v1beta1.GetMenu) {
        return mergeFrom((io.bloombox.schema.services.menu.v1beta1.GetMenu)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.services.menu.v1beta1.GetMenu other) {
      if (other == io.bloombox.schema.services.menu.v1beta1.GetMenu.getDefaultInstance()) return this;
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.services.menu.v1beta1.GetMenu parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.services.menu.v1beta1.GetMenu) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.services.menu.v1beta1.GetMenu)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.services.menu.v1beta1.GetMenu)
  private static final io.bloombox.schema.services.menu.v1beta1.GetMenu DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.services.menu.v1beta1.GetMenu();
  }

  public static io.bloombox.schema.services.menu.v1beta1.GetMenu getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GetMenu>
      PARSER = new com.google.protobuf.AbstractParser<GetMenu>() {
    public GetMenu parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new GetMenu(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<GetMenu> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GetMenu> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.services.menu.v1beta1.GetMenu getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

