/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: menu/v1beta1/MenuService_Beta1.proto

package io.bloombox.schema.services.menu.v1beta1;

/**
 * <pre>
 * Specifies an RPC operation to retrieve menu product data via a reference to its key.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.services.menu.v1beta1.GetProduct}
 */
public  final class GetProduct extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.services.menu.v1beta1.GetProduct)
    GetProductOrBuilder {
private static final long serialVersionUID = 0L;
  // Use GetProduct.newBuilder() to construct.
  private GetProduct(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private GetProduct() {
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private GetProduct(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetProduct_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetProduct_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.services.menu.v1beta1.GetProduct.class, io.bloombox.schema.services.menu.v1beta1.GetProduct.Builder.class);
  }

  public interface RequestOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.menu.v1beta1.GetProduct.Request)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Partnership scope for the request.
     * </pre>
     *
     * <code>string scope = 1;</code>
     */
    java.lang.String getScope();
    /**
     * <pre>
     * Partnership scope for the request.
     * </pre>
     *
     * <code>string scope = 1;</code>
     */
    com.google.protobuf.ByteString
        getScopeBytes();

    /**
     * <pre>
     * Product key to fetch.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 2;</code>
     */
    boolean hasKey();
    /**
     * <pre>
     * Product key to fetch.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 2;</code>
     */
    io.opencannabis.schema.base.ProductKey getKey();
    /**
     * <pre>
     * Product key to fetch.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 2;</code>
     */
    io.opencannabis.schema.base.ProductKeyOrBuilder getKeyOrBuilder();

    /**
     * <pre>
     * Request a potentially-cached or forced-uncached copy of the specified product data.
     * </pre>
     *
     * <code>bool fresh = 3;</code>
     */
    boolean getFresh();

    /**
     * <pre>
     * Fingerprint for an existing revision the client has on-hand. If no change has occurred since that revision, the
     * server may indicate so.
     * </pre>
     *
     * <code>string fingerprint = 4;</code>
     */
    java.lang.String getFingerprint();
    /**
     * <pre>
     * Fingerprint for an existing revision the client has on-hand. If no change has occurred since that revision, the
     * server may indicate so.
     * </pre>
     *
     * <code>string fingerprint = 4;</code>
     */
    com.google.protobuf.ByteString
        getFingerprintBytes();
  }
  /**
   * <pre>
   * Specifies a request for product data, returned or inflated from its key.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.menu.v1beta1.GetProduct.Request}
   */
  public  static final class Request extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.menu.v1beta1.GetProduct.Request)
      RequestOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Request.newBuilder() to construct.
    private Request(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Request() {
      scope_ = "";
      fresh_ = false;
      fingerprint_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Request(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              scope_ = s;
              break;
            }
            case 18: {
              io.opencannabis.schema.base.ProductKey.Builder subBuilder = null;
              if (key_ != null) {
                subBuilder = key_.toBuilder();
              }
              key_ = input.readMessage(io.opencannabis.schema.base.ProductKey.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(key_);
                key_ = subBuilder.buildPartial();
              }

              break;
            }
            case 24: {

              fresh_ = input.readBool();
              break;
            }
            case 34: {
              java.lang.String s = input.readStringRequireUtf8();

              fingerprint_ = s;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetProduct_Request_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetProduct_Request_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.menu.v1beta1.GetProduct.Request.class, io.bloombox.schema.services.menu.v1beta1.GetProduct.Request.Builder.class);
    }

    public static final int SCOPE_FIELD_NUMBER = 1;
    private volatile java.lang.Object scope_;
    /**
     * <pre>
     * Partnership scope for the request.
     * </pre>
     *
     * <code>string scope = 1;</code>
     */
    public java.lang.String getScope() {
      java.lang.Object ref = scope_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        scope_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Partnership scope for the request.
     * </pre>
     *
     * <code>string scope = 1;</code>
     */
    public com.google.protobuf.ByteString
        getScopeBytes() {
      java.lang.Object ref = scope_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        scope_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int KEY_FIELD_NUMBER = 2;
    private io.opencannabis.schema.base.ProductKey key_;
    /**
     * <pre>
     * Product key to fetch.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 2;</code>
     */
    public boolean hasKey() {
      return key_ != null;
    }
    /**
     * <pre>
     * Product key to fetch.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 2;</code>
     */
    public io.opencannabis.schema.base.ProductKey getKey() {
      return key_ == null ? io.opencannabis.schema.base.ProductKey.getDefaultInstance() : key_;
    }
    /**
     * <pre>
     * Product key to fetch.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 2;</code>
     */
    public io.opencannabis.schema.base.ProductKeyOrBuilder getKeyOrBuilder() {
      return getKey();
    }

    public static final int FRESH_FIELD_NUMBER = 3;
    private boolean fresh_;
    /**
     * <pre>
     * Request a potentially-cached or forced-uncached copy of the specified product data.
     * </pre>
     *
     * <code>bool fresh = 3;</code>
     */
    public boolean getFresh() {
      return fresh_;
    }

    public static final int FINGERPRINT_FIELD_NUMBER = 4;
    private volatile java.lang.Object fingerprint_;
    /**
     * <pre>
     * Fingerprint for an existing revision the client has on-hand. If no change has occurred since that revision, the
     * server may indicate so.
     * </pre>
     *
     * <code>string fingerprint = 4;</code>
     */
    public java.lang.String getFingerprint() {
      java.lang.Object ref = fingerprint_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fingerprint_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Fingerprint for an existing revision the client has on-hand. If no change has occurred since that revision, the
     * server may indicate so.
     * </pre>
     *
     * <code>string fingerprint = 4;</code>
     */
    public com.google.protobuf.ByteString
        getFingerprintBytes() {
      java.lang.Object ref = fingerprint_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        fingerprint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getScopeBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, scope_);
      }
      if (key_ != null) {
        output.writeMessage(2, getKey());
      }
      if (fresh_ != false) {
        output.writeBool(3, fresh_);
      }
      if (!getFingerprintBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, fingerprint_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getScopeBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, scope_);
      }
      if (key_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getKey());
      }
      if (fresh_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(3, fresh_);
      }
      if (!getFingerprintBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, fingerprint_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.menu.v1beta1.GetProduct.Request)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.menu.v1beta1.GetProduct.Request other = (io.bloombox.schema.services.menu.v1beta1.GetProduct.Request) obj;

      boolean result = true;
      result = result && getScope()
          .equals(other.getScope());
      result = result && (hasKey() == other.hasKey());
      if (hasKey()) {
        result = result && getKey()
            .equals(other.getKey());
      }
      result = result && (getFresh()
          == other.getFresh());
      result = result && getFingerprint()
          .equals(other.getFingerprint());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SCOPE_FIELD_NUMBER;
      hash = (53 * hash) + getScope().hashCode();
      if (hasKey()) {
        hash = (37 * hash) + KEY_FIELD_NUMBER;
        hash = (53 * hash) + getKey().hashCode();
      }
      hash = (37 * hash) + FRESH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getFresh());
      hash = (37 * hash) + FINGERPRINT_FIELD_NUMBER;
      hash = (53 * hash) + getFingerprint().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.menu.v1beta1.GetProduct.Request parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetProduct.Request parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetProduct.Request parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetProduct.Request parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetProduct.Request parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetProduct.Request parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetProduct.Request parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetProduct.Request parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetProduct.Request parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetProduct.Request parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetProduct.Request parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetProduct.Request parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.menu.v1beta1.GetProduct.Request prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies a request for product data, returned or inflated from its key.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.menu.v1beta1.GetProduct.Request}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.menu.v1beta1.GetProduct.Request)
        io.bloombox.schema.services.menu.v1beta1.GetProduct.RequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetProduct_Request_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetProduct_Request_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.menu.v1beta1.GetProduct.Request.class, io.bloombox.schema.services.menu.v1beta1.GetProduct.Request.Builder.class);
      }

      // Construct using io.bloombox.schema.services.menu.v1beta1.GetProduct.Request.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        scope_ = "";

        if (keyBuilder_ == null) {
          key_ = null;
        } else {
          key_ = null;
          keyBuilder_ = null;
        }
        fresh_ = false;

        fingerprint_ = "";

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetProduct_Request_descriptor;
      }

      public io.bloombox.schema.services.menu.v1beta1.GetProduct.Request getDefaultInstanceForType() {
        return io.bloombox.schema.services.menu.v1beta1.GetProduct.Request.getDefaultInstance();
      }

      public io.bloombox.schema.services.menu.v1beta1.GetProduct.Request build() {
        io.bloombox.schema.services.menu.v1beta1.GetProduct.Request result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.menu.v1beta1.GetProduct.Request buildPartial() {
        io.bloombox.schema.services.menu.v1beta1.GetProduct.Request result = new io.bloombox.schema.services.menu.v1beta1.GetProduct.Request(this);
        result.scope_ = scope_;
        if (keyBuilder_ == null) {
          result.key_ = key_;
        } else {
          result.key_ = keyBuilder_.build();
        }
        result.fresh_ = fresh_;
        result.fingerprint_ = fingerprint_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.menu.v1beta1.GetProduct.Request) {
          return mergeFrom((io.bloombox.schema.services.menu.v1beta1.GetProduct.Request)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.menu.v1beta1.GetProduct.Request other) {
        if (other == io.bloombox.schema.services.menu.v1beta1.GetProduct.Request.getDefaultInstance()) return this;
        if (!other.getScope().isEmpty()) {
          scope_ = other.scope_;
          onChanged();
        }
        if (other.hasKey()) {
          mergeKey(other.getKey());
        }
        if (other.getFresh() != false) {
          setFresh(other.getFresh());
        }
        if (!other.getFingerprint().isEmpty()) {
          fingerprint_ = other.fingerprint_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.menu.v1beta1.GetProduct.Request parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.menu.v1beta1.GetProduct.Request) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object scope_ = "";
      /**
       * <pre>
       * Partnership scope for the request.
       * </pre>
       *
       * <code>string scope = 1;</code>
       */
      public java.lang.String getScope() {
        java.lang.Object ref = scope_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          scope_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Partnership scope for the request.
       * </pre>
       *
       * <code>string scope = 1;</code>
       */
      public com.google.protobuf.ByteString
          getScopeBytes() {
        java.lang.Object ref = scope_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          scope_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Partnership scope for the request.
       * </pre>
       *
       * <code>string scope = 1;</code>
       */
      public Builder setScope(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        scope_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Partnership scope for the request.
       * </pre>
       *
       * <code>string scope = 1;</code>
       */
      public Builder clearScope() {
        
        scope_ = getDefaultInstance().getScope();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Partnership scope for the request.
       * </pre>
       *
       * <code>string scope = 1;</code>
       */
      public Builder setScopeBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        scope_ = value;
        onChanged();
        return this;
      }

      private io.opencannabis.schema.base.ProductKey key_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder> keyBuilder_;
      /**
       * <pre>
       * Product key to fetch.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 2;</code>
       */
      public boolean hasKey() {
        return keyBuilder_ != null || key_ != null;
      }
      /**
       * <pre>
       * Product key to fetch.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 2;</code>
       */
      public io.opencannabis.schema.base.ProductKey getKey() {
        if (keyBuilder_ == null) {
          return key_ == null ? io.opencannabis.schema.base.ProductKey.getDefaultInstance() : key_;
        } else {
          return keyBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Product key to fetch.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 2;</code>
       */
      public Builder setKey(io.opencannabis.schema.base.ProductKey value) {
        if (keyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          key_ = value;
          onChanged();
        } else {
          keyBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Product key to fetch.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 2;</code>
       */
      public Builder setKey(
          io.opencannabis.schema.base.ProductKey.Builder builderForValue) {
        if (keyBuilder_ == null) {
          key_ = builderForValue.build();
          onChanged();
        } else {
          keyBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Product key to fetch.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 2;</code>
       */
      public Builder mergeKey(io.opencannabis.schema.base.ProductKey value) {
        if (keyBuilder_ == null) {
          if (key_ != null) {
            key_ =
              io.opencannabis.schema.base.ProductKey.newBuilder(key_).mergeFrom(value).buildPartial();
          } else {
            key_ = value;
          }
          onChanged();
        } else {
          keyBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Product key to fetch.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 2;</code>
       */
      public Builder clearKey() {
        if (keyBuilder_ == null) {
          key_ = null;
          onChanged();
        } else {
          key_ = null;
          keyBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Product key to fetch.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 2;</code>
       */
      public io.opencannabis.schema.base.ProductKey.Builder getKeyBuilder() {
        
        onChanged();
        return getKeyFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Product key to fetch.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 2;</code>
       */
      public io.opencannabis.schema.base.ProductKeyOrBuilder getKeyOrBuilder() {
        if (keyBuilder_ != null) {
          return keyBuilder_.getMessageOrBuilder();
        } else {
          return key_ == null ?
              io.opencannabis.schema.base.ProductKey.getDefaultInstance() : key_;
        }
      }
      /**
       * <pre>
       * Product key to fetch.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder> 
          getKeyFieldBuilder() {
        if (keyBuilder_ == null) {
          keyBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder>(
                  getKey(),
                  getParentForChildren(),
                  isClean());
          key_ = null;
        }
        return keyBuilder_;
      }

      private boolean fresh_ ;
      /**
       * <pre>
       * Request a potentially-cached or forced-uncached copy of the specified product data.
       * </pre>
       *
       * <code>bool fresh = 3;</code>
       */
      public boolean getFresh() {
        return fresh_;
      }
      /**
       * <pre>
       * Request a potentially-cached or forced-uncached copy of the specified product data.
       * </pre>
       *
       * <code>bool fresh = 3;</code>
       */
      public Builder setFresh(boolean value) {
        
        fresh_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Request a potentially-cached or forced-uncached copy of the specified product data.
       * </pre>
       *
       * <code>bool fresh = 3;</code>
       */
      public Builder clearFresh() {
        
        fresh_ = false;
        onChanged();
        return this;
      }

      private java.lang.Object fingerprint_ = "";
      /**
       * <pre>
       * Fingerprint for an existing revision the client has on-hand. If no change has occurred since that revision, the
       * server may indicate so.
       * </pre>
       *
       * <code>string fingerprint = 4;</code>
       */
      public java.lang.String getFingerprint() {
        java.lang.Object ref = fingerprint_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          fingerprint_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Fingerprint for an existing revision the client has on-hand. If no change has occurred since that revision, the
       * server may indicate so.
       * </pre>
       *
       * <code>string fingerprint = 4;</code>
       */
      public com.google.protobuf.ByteString
          getFingerprintBytes() {
        java.lang.Object ref = fingerprint_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          fingerprint_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Fingerprint for an existing revision the client has on-hand. If no change has occurred since that revision, the
       * server may indicate so.
       * </pre>
       *
       * <code>string fingerprint = 4;</code>
       */
      public Builder setFingerprint(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        fingerprint_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Fingerprint for an existing revision the client has on-hand. If no change has occurred since that revision, the
       * server may indicate so.
       * </pre>
       *
       * <code>string fingerprint = 4;</code>
       */
      public Builder clearFingerprint() {
        
        fingerprint_ = getDefaultInstance().getFingerprint();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Fingerprint for an existing revision the client has on-hand. If no change has occurred since that revision, the
       * server may indicate so.
       * </pre>
       *
       * <code>string fingerprint = 4;</code>
       */
      public Builder setFingerprintBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        fingerprint_ = value;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.menu.v1beta1.GetProduct.Request)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.menu.v1beta1.GetProduct.Request)
    private static final io.bloombox.schema.services.menu.v1beta1.GetProduct.Request DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.menu.v1beta1.GetProduct.Request();
    }

    public static io.bloombox.schema.services.menu.v1beta1.GetProduct.Request getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Request>
        PARSER = new com.google.protobuf.AbstractParser<Request>() {
      public Request parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Request(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Request> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Request> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.menu.v1beta1.GetProduct.Request getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ResponseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.menu.v1beta1.GetProduct.Response)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Corresponding item for the keys that was requested, if found.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.MenuProduct product = 1;</code>
     */
    java.util.List<io.opencannabis.schema.menu.MenuProduct> 
        getProductList();
    /**
     * <pre>
     * Corresponding item for the keys that was requested, if found.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.MenuProduct product = 1;</code>
     */
    io.opencannabis.schema.menu.MenuProduct getProduct(int index);
    /**
     * <pre>
     * Corresponding item for the keys that was requested, if found.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.MenuProduct product = 1;</code>
     */
    int getProductCount();
    /**
     * <pre>
     * Corresponding item for the keys that was requested, if found.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.MenuProduct product = 1;</code>
     */
    java.util.List<? extends io.opencannabis.schema.menu.MenuProductOrBuilder> 
        getProductOrBuilderList();
    /**
     * <pre>
     * Corresponding item for the keys that was requested, if found.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.MenuProduct product = 1;</code>
     */
    io.opencannabis.schema.menu.MenuProductOrBuilder getProductOrBuilder(
        int index);

    /**
     * <pre>
     * Specify whether items in the response, or the whole response, was cached.
     * </pre>
     *
     * <code>bool cached = 2;</code>
     */
    boolean getCached();

    /**
     * <pre>
     * Flag set when a request-given fingerprint still matches the underlying object data being requested, enabling the
     * server to respond with a 304 Not Modified-style answer.
     * </pre>
     *
     * <code>bool unchanged = 3;</code>
     */
    boolean getUnchanged();
  }
  /**
   * <pre>
   * Response to a request to retrieve a product data payload by its corresponding key.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.menu.v1beta1.GetProduct.Response}
   */
  public  static final class Response extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.menu.v1beta1.GetProduct.Response)
      ResponseOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Response.newBuilder() to construct.
    private Response(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Response() {
      product_ = java.util.Collections.emptyList();
      cached_ = false;
      unchanged_ = false;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Response(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                product_ = new java.util.ArrayList<io.opencannabis.schema.menu.MenuProduct>();
                mutable_bitField0_ |= 0x00000001;
              }
              product_.add(
                  input.readMessage(io.opencannabis.schema.menu.MenuProduct.parser(), extensionRegistry));
              break;
            }
            case 16: {

              cached_ = input.readBool();
              break;
            }
            case 24: {

              unchanged_ = input.readBool();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          product_ = java.util.Collections.unmodifiableList(product_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetProduct_Response_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetProduct_Response_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.menu.v1beta1.GetProduct.Response.class, io.bloombox.schema.services.menu.v1beta1.GetProduct.Response.Builder.class);
    }

    private int bitField0_;
    public static final int PRODUCT_FIELD_NUMBER = 1;
    private java.util.List<io.opencannabis.schema.menu.MenuProduct> product_;
    /**
     * <pre>
     * Corresponding item for the keys that was requested, if found.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.MenuProduct product = 1;</code>
     */
    public java.util.List<io.opencannabis.schema.menu.MenuProduct> getProductList() {
      return product_;
    }
    /**
     * <pre>
     * Corresponding item for the keys that was requested, if found.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.MenuProduct product = 1;</code>
     */
    public java.util.List<? extends io.opencannabis.schema.menu.MenuProductOrBuilder> 
        getProductOrBuilderList() {
      return product_;
    }
    /**
     * <pre>
     * Corresponding item for the keys that was requested, if found.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.MenuProduct product = 1;</code>
     */
    public int getProductCount() {
      return product_.size();
    }
    /**
     * <pre>
     * Corresponding item for the keys that was requested, if found.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.MenuProduct product = 1;</code>
     */
    public io.opencannabis.schema.menu.MenuProduct getProduct(int index) {
      return product_.get(index);
    }
    /**
     * <pre>
     * Corresponding item for the keys that was requested, if found.
     * </pre>
     *
     * <code>repeated .opencannabis.products.menu.MenuProduct product = 1;</code>
     */
    public io.opencannabis.schema.menu.MenuProductOrBuilder getProductOrBuilder(
        int index) {
      return product_.get(index);
    }

    public static final int CACHED_FIELD_NUMBER = 2;
    private boolean cached_;
    /**
     * <pre>
     * Specify whether items in the response, or the whole response, was cached.
     * </pre>
     *
     * <code>bool cached = 2;</code>
     */
    public boolean getCached() {
      return cached_;
    }

    public static final int UNCHANGED_FIELD_NUMBER = 3;
    private boolean unchanged_;
    /**
     * <pre>
     * Flag set when a request-given fingerprint still matches the underlying object data being requested, enabling the
     * server to respond with a 304 Not Modified-style answer.
     * </pre>
     *
     * <code>bool unchanged = 3;</code>
     */
    public boolean getUnchanged() {
      return unchanged_;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      for (int i = 0; i < product_.size(); i++) {
        output.writeMessage(1, product_.get(i));
      }
      if (cached_ != false) {
        output.writeBool(2, cached_);
      }
      if (unchanged_ != false) {
        output.writeBool(3, unchanged_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < product_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, product_.get(i));
      }
      if (cached_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(2, cached_);
      }
      if (unchanged_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(3, unchanged_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.menu.v1beta1.GetProduct.Response)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.menu.v1beta1.GetProduct.Response other = (io.bloombox.schema.services.menu.v1beta1.GetProduct.Response) obj;

      boolean result = true;
      result = result && getProductList()
          .equals(other.getProductList());
      result = result && (getCached()
          == other.getCached());
      result = result && (getUnchanged()
          == other.getUnchanged());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getProductCount() > 0) {
        hash = (37 * hash) + PRODUCT_FIELD_NUMBER;
        hash = (53 * hash) + getProductList().hashCode();
      }
      hash = (37 * hash) + CACHED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getCached());
      hash = (37 * hash) + UNCHANGED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getUnchanged());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.menu.v1beta1.GetProduct.Response parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetProduct.Response parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetProduct.Response parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetProduct.Response parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetProduct.Response parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetProduct.Response parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetProduct.Response parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetProduct.Response parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetProduct.Response parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetProduct.Response parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetProduct.Response parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.menu.v1beta1.GetProduct.Response parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.menu.v1beta1.GetProduct.Response prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Response to a request to retrieve a product data payload by its corresponding key.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.menu.v1beta1.GetProduct.Response}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.menu.v1beta1.GetProduct.Response)
        io.bloombox.schema.services.menu.v1beta1.GetProduct.ResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetProduct_Response_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetProduct_Response_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.menu.v1beta1.GetProduct.Response.class, io.bloombox.schema.services.menu.v1beta1.GetProduct.Response.Builder.class);
      }

      // Construct using io.bloombox.schema.services.menu.v1beta1.GetProduct.Response.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getProductFieldBuilder();
        }
      }
      public Builder clear() {
        super.clear();
        if (productBuilder_ == null) {
          product_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          productBuilder_.clear();
        }
        cached_ = false;

        unchanged_ = false;

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetProduct_Response_descriptor;
      }

      public io.bloombox.schema.services.menu.v1beta1.GetProduct.Response getDefaultInstanceForType() {
        return io.bloombox.schema.services.menu.v1beta1.GetProduct.Response.getDefaultInstance();
      }

      public io.bloombox.schema.services.menu.v1beta1.GetProduct.Response build() {
        io.bloombox.schema.services.menu.v1beta1.GetProduct.Response result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.menu.v1beta1.GetProduct.Response buildPartial() {
        io.bloombox.schema.services.menu.v1beta1.GetProduct.Response result = new io.bloombox.schema.services.menu.v1beta1.GetProduct.Response(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (productBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)) {
            product_ = java.util.Collections.unmodifiableList(product_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.product_ = product_;
        } else {
          result.product_ = productBuilder_.build();
        }
        result.cached_ = cached_;
        result.unchanged_ = unchanged_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.menu.v1beta1.GetProduct.Response) {
          return mergeFrom((io.bloombox.schema.services.menu.v1beta1.GetProduct.Response)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.menu.v1beta1.GetProduct.Response other) {
        if (other == io.bloombox.schema.services.menu.v1beta1.GetProduct.Response.getDefaultInstance()) return this;
        if (productBuilder_ == null) {
          if (!other.product_.isEmpty()) {
            if (product_.isEmpty()) {
              product_ = other.product_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureProductIsMutable();
              product_.addAll(other.product_);
            }
            onChanged();
          }
        } else {
          if (!other.product_.isEmpty()) {
            if (productBuilder_.isEmpty()) {
              productBuilder_.dispose();
              productBuilder_ = null;
              product_ = other.product_;
              bitField0_ = (bitField0_ & ~0x00000001);
              productBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getProductFieldBuilder() : null;
            } else {
              productBuilder_.addAllMessages(other.product_);
            }
          }
        }
        if (other.getCached() != false) {
          setCached(other.getCached());
        }
        if (other.getUnchanged() != false) {
          setUnchanged(other.getUnchanged());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.menu.v1beta1.GetProduct.Response parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.menu.v1beta1.GetProduct.Response) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.util.List<io.opencannabis.schema.menu.MenuProduct> product_ =
        java.util.Collections.emptyList();
      private void ensureProductIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          product_ = new java.util.ArrayList<io.opencannabis.schema.menu.MenuProduct>(product_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.opencannabis.schema.menu.MenuProduct, io.opencannabis.schema.menu.MenuProduct.Builder, io.opencannabis.schema.menu.MenuProductOrBuilder> productBuilder_;

      /**
       * <pre>
       * Corresponding item for the keys that was requested, if found.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct product = 1;</code>
       */
      public java.util.List<io.opencannabis.schema.menu.MenuProduct> getProductList() {
        if (productBuilder_ == null) {
          return java.util.Collections.unmodifiableList(product_);
        } else {
          return productBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Corresponding item for the keys that was requested, if found.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct product = 1;</code>
       */
      public int getProductCount() {
        if (productBuilder_ == null) {
          return product_.size();
        } else {
          return productBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Corresponding item for the keys that was requested, if found.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct product = 1;</code>
       */
      public io.opencannabis.schema.menu.MenuProduct getProduct(int index) {
        if (productBuilder_ == null) {
          return product_.get(index);
        } else {
          return productBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Corresponding item for the keys that was requested, if found.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct product = 1;</code>
       */
      public Builder setProduct(
          int index, io.opencannabis.schema.menu.MenuProduct value) {
        if (productBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureProductIsMutable();
          product_.set(index, value);
          onChanged();
        } else {
          productBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Corresponding item for the keys that was requested, if found.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct product = 1;</code>
       */
      public Builder setProduct(
          int index, io.opencannabis.schema.menu.MenuProduct.Builder builderForValue) {
        if (productBuilder_ == null) {
          ensureProductIsMutable();
          product_.set(index, builderForValue.build());
          onChanged();
        } else {
          productBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Corresponding item for the keys that was requested, if found.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct product = 1;</code>
       */
      public Builder addProduct(io.opencannabis.schema.menu.MenuProduct value) {
        if (productBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureProductIsMutable();
          product_.add(value);
          onChanged();
        } else {
          productBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Corresponding item for the keys that was requested, if found.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct product = 1;</code>
       */
      public Builder addProduct(
          int index, io.opencannabis.schema.menu.MenuProduct value) {
        if (productBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureProductIsMutable();
          product_.add(index, value);
          onChanged();
        } else {
          productBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Corresponding item for the keys that was requested, if found.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct product = 1;</code>
       */
      public Builder addProduct(
          io.opencannabis.schema.menu.MenuProduct.Builder builderForValue) {
        if (productBuilder_ == null) {
          ensureProductIsMutable();
          product_.add(builderForValue.build());
          onChanged();
        } else {
          productBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Corresponding item for the keys that was requested, if found.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct product = 1;</code>
       */
      public Builder addProduct(
          int index, io.opencannabis.schema.menu.MenuProduct.Builder builderForValue) {
        if (productBuilder_ == null) {
          ensureProductIsMutable();
          product_.add(index, builderForValue.build());
          onChanged();
        } else {
          productBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Corresponding item for the keys that was requested, if found.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct product = 1;</code>
       */
      public Builder addAllProduct(
          java.lang.Iterable<? extends io.opencannabis.schema.menu.MenuProduct> values) {
        if (productBuilder_ == null) {
          ensureProductIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, product_);
          onChanged();
        } else {
          productBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Corresponding item for the keys that was requested, if found.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct product = 1;</code>
       */
      public Builder clearProduct() {
        if (productBuilder_ == null) {
          product_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          productBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Corresponding item for the keys that was requested, if found.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct product = 1;</code>
       */
      public Builder removeProduct(int index) {
        if (productBuilder_ == null) {
          ensureProductIsMutable();
          product_.remove(index);
          onChanged();
        } else {
          productBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Corresponding item for the keys that was requested, if found.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct product = 1;</code>
       */
      public io.opencannabis.schema.menu.MenuProduct.Builder getProductBuilder(
          int index) {
        return getProductFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Corresponding item for the keys that was requested, if found.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct product = 1;</code>
       */
      public io.opencannabis.schema.menu.MenuProductOrBuilder getProductOrBuilder(
          int index) {
        if (productBuilder_ == null) {
          return product_.get(index);  } else {
          return productBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Corresponding item for the keys that was requested, if found.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct product = 1;</code>
       */
      public java.util.List<? extends io.opencannabis.schema.menu.MenuProductOrBuilder> 
           getProductOrBuilderList() {
        if (productBuilder_ != null) {
          return productBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(product_);
        }
      }
      /**
       * <pre>
       * Corresponding item for the keys that was requested, if found.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct product = 1;</code>
       */
      public io.opencannabis.schema.menu.MenuProduct.Builder addProductBuilder() {
        return getProductFieldBuilder().addBuilder(
            io.opencannabis.schema.menu.MenuProduct.getDefaultInstance());
      }
      /**
       * <pre>
       * Corresponding item for the keys that was requested, if found.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct product = 1;</code>
       */
      public io.opencannabis.schema.menu.MenuProduct.Builder addProductBuilder(
          int index) {
        return getProductFieldBuilder().addBuilder(
            index, io.opencannabis.schema.menu.MenuProduct.getDefaultInstance());
      }
      /**
       * <pre>
       * Corresponding item for the keys that was requested, if found.
       * </pre>
       *
       * <code>repeated .opencannabis.products.menu.MenuProduct product = 1;</code>
       */
      public java.util.List<io.opencannabis.schema.menu.MenuProduct.Builder> 
           getProductBuilderList() {
        return getProductFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.opencannabis.schema.menu.MenuProduct, io.opencannabis.schema.menu.MenuProduct.Builder, io.opencannabis.schema.menu.MenuProductOrBuilder> 
          getProductFieldBuilder() {
        if (productBuilder_ == null) {
          productBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              io.opencannabis.schema.menu.MenuProduct, io.opencannabis.schema.menu.MenuProduct.Builder, io.opencannabis.schema.menu.MenuProductOrBuilder>(
                  product_,
                  ((bitField0_ & 0x00000001) == 0x00000001),
                  getParentForChildren(),
                  isClean());
          product_ = null;
        }
        return productBuilder_;
      }

      private boolean cached_ ;
      /**
       * <pre>
       * Specify whether items in the response, or the whole response, was cached.
       * </pre>
       *
       * <code>bool cached = 2;</code>
       */
      public boolean getCached() {
        return cached_;
      }
      /**
       * <pre>
       * Specify whether items in the response, or the whole response, was cached.
       * </pre>
       *
       * <code>bool cached = 2;</code>
       */
      public Builder setCached(boolean value) {
        
        cached_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specify whether items in the response, or the whole response, was cached.
       * </pre>
       *
       * <code>bool cached = 2;</code>
       */
      public Builder clearCached() {
        
        cached_ = false;
        onChanged();
        return this;
      }

      private boolean unchanged_ ;
      /**
       * <pre>
       * Flag set when a request-given fingerprint still matches the underlying object data being requested, enabling the
       * server to respond with a 304 Not Modified-style answer.
       * </pre>
       *
       * <code>bool unchanged = 3;</code>
       */
      public boolean getUnchanged() {
        return unchanged_;
      }
      /**
       * <pre>
       * Flag set when a request-given fingerprint still matches the underlying object data being requested, enabling the
       * server to respond with a 304 Not Modified-style answer.
       * </pre>
       *
       * <code>bool unchanged = 3;</code>
       */
      public Builder setUnchanged(boolean value) {
        
        unchanged_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Flag set when a request-given fingerprint still matches the underlying object data being requested, enabling the
       * server to respond with a 304 Not Modified-style answer.
       * </pre>
       *
       * <code>bool unchanged = 3;</code>
       */
      public Builder clearUnchanged() {
        
        unchanged_ = false;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.menu.v1beta1.GetProduct.Response)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.menu.v1beta1.GetProduct.Response)
    private static final io.bloombox.schema.services.menu.v1beta1.GetProduct.Response DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.menu.v1beta1.GetProduct.Response();
    }

    public static io.bloombox.schema.services.menu.v1beta1.GetProduct.Response getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Response>
        PARSER = new com.google.protobuf.AbstractParser<Response>() {
      public Response parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Response(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Response> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Response> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.menu.v1beta1.GetProduct.Response getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.services.menu.v1beta1.GetProduct)) {
      return super.equals(obj);
    }
    io.bloombox.schema.services.menu.v1beta1.GetProduct other = (io.bloombox.schema.services.menu.v1beta1.GetProduct) obj;

    boolean result = true;
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.services.menu.v1beta1.GetProduct parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.menu.v1beta1.GetProduct parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.menu.v1beta1.GetProduct parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.menu.v1beta1.GetProduct parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.menu.v1beta1.GetProduct parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.menu.v1beta1.GetProduct parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.menu.v1beta1.GetProduct parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.menu.v1beta1.GetProduct parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.menu.v1beta1.GetProduct parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.menu.v1beta1.GetProduct parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.menu.v1beta1.GetProduct parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.menu.v1beta1.GetProduct parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.services.menu.v1beta1.GetProduct prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies an RPC operation to retrieve menu product data via a reference to its key.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.menu.v1beta1.GetProduct}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.services.menu.v1beta1.GetProduct)
      io.bloombox.schema.services.menu.v1beta1.GetProductOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetProduct_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetProduct_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.menu.v1beta1.GetProduct.class, io.bloombox.schema.services.menu.v1beta1.GetProduct.Builder.class);
    }

    // Construct using io.bloombox.schema.services.menu.v1beta1.GetProduct.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.internal_static_bloombox_schema_services_menu_v1beta1_GetProduct_descriptor;
    }

    public io.bloombox.schema.services.menu.v1beta1.GetProduct getDefaultInstanceForType() {
      return io.bloombox.schema.services.menu.v1beta1.GetProduct.getDefaultInstance();
    }

    public io.bloombox.schema.services.menu.v1beta1.GetProduct build() {
      io.bloombox.schema.services.menu.v1beta1.GetProduct result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.services.menu.v1beta1.GetProduct buildPartial() {
      io.bloombox.schema.services.menu.v1beta1.GetProduct result = new io.bloombox.schema.services.menu.v1beta1.GetProduct(this);
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.services.menu.v1beta1.GetProduct) {
        return mergeFrom((io.bloombox.schema.services.menu.v1beta1.GetProduct)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.services.menu.v1beta1.GetProduct other) {
      if (other == io.bloombox.schema.services.menu.v1beta1.GetProduct.getDefaultInstance()) return this;
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.services.menu.v1beta1.GetProduct parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.services.menu.v1beta1.GetProduct) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.services.menu.v1beta1.GetProduct)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.services.menu.v1beta1.GetProduct)
  private static final io.bloombox.schema.services.menu.v1beta1.GetProduct DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.services.menu.v1beta1.GetProduct();
  }

  public static io.bloombox.schema.services.menu.v1beta1.GetProduct getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GetProduct>
      PARSER = new com.google.protobuf.AbstractParser<GetProduct>() {
    public GetProduct parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new GetProduct(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<GetProduct> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GetProduct> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.services.menu.v1beta1.GetProduct getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

