/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: menu/v1beta1/MenuService_Beta1.proto

package io.bloombox.schema.services.menu.v1beta1;

/**
 * <pre>
 * Enumerates known errors that may be thrown by menu operations.
 * </pre>
 *
 * Protobuf enum {@code bloombox.schema.services.menu.v1beta1.MenuError}
 */
public enum MenuError
    implements com.google.protobuf.ProtocolMessageEnum {
  /**
   * <pre>
   * No error was encountered.
   * </pre>
   *
   * <code>NO_ERROR = 0;</code>
   */
  NO_ERROR(0),
  /**
   * <pre>
   * The specified partner ID is invalid.
   * </pre>
   *
   * <code>PARTNER_INVALID = 1;</code>
   */
  PARTNER_INVALID(1),
  /**
   * <pre>
   * The specified location ID is invalid.
   * </pre>
   *
   * <code>LOCATION_INVALID = 2;</code>
   */
  LOCATION_INVALID(2),
  /**
   * <pre>
   * The specified section value was invalid.
   * </pre>
   *
   * <code>SECTION_INVALID = 3;</code>
   */
  SECTION_INVALID(3),
  /**
   * <pre>
   * The specified section could not be found.
   * </pre>
   *
   * <code>SECTION_NOT_FOUND = 4;</code>
   */
  SECTION_NOT_FOUND(4),
  /**
   * <pre>
   * The specified partner/location pair was valid, but menu data could not be resolved.
   * </pre>
   *
   * <code>MENU_NOT_FOUND = 5;</code>
   */
  MENU_NOT_FOUND(5),
  /**
   * <pre>
   * Search services are currently unavailable.
   * </pre>
   *
   * <code>SEARCH_UNAVAILABLE = 6;</code>
   */
  SEARCH_UNAVAILABLE(6),
  /**
   * <pre>
   * Failed to locate a product by key.
   * </pre>
   *
   * <code>PRODUCT_NOT_FOUND = 7;</code>
   */
  PRODUCT_NOT_FOUND(7),
  /**
   * <pre>
   * The configured access permissions do not allow the requested operation.
   * </pre>
   *
   * <code>ACCESS_DENIED = 8;</code>
   */
  ACCESS_DENIED(8),
  /**
   * <pre>
   * The specified product key was found to be invalid.
   * </pre>
   *
   * <code>KEY_INVALID = 9;</code>
   */
  KEY_INVALID(9),
  /**
   * <pre>
   * The provided update was rejected.
   * </pre>
   *
   * <code>UPDATE_INVALID = 10;</code>
   */
  UPDATE_INVALID(10),
  /**
   * <pre>
   * The provided update was rejected due to a conflict.
   * </pre>
   *
   * <code>CONFLICT = 11;</code>
   */
  CONFLICT(11),
  /**
   * <pre>
   * The server encountered some internal error.
   * </pre>
   *
   * <code>INTERNAL_ERROR = 99;</code>
   */
  INTERNAL_ERROR(99),
  UNRECOGNIZED(-1),
  ;

  /**
   * <pre>
   * No error was encountered.
   * </pre>
   *
   * <code>NO_ERROR = 0;</code>
   */
  public static final int NO_ERROR_VALUE = 0;
  /**
   * <pre>
   * The specified partner ID is invalid.
   * </pre>
   *
   * <code>PARTNER_INVALID = 1;</code>
   */
  public static final int PARTNER_INVALID_VALUE = 1;
  /**
   * <pre>
   * The specified location ID is invalid.
   * </pre>
   *
   * <code>LOCATION_INVALID = 2;</code>
   */
  public static final int LOCATION_INVALID_VALUE = 2;
  /**
   * <pre>
   * The specified section value was invalid.
   * </pre>
   *
   * <code>SECTION_INVALID = 3;</code>
   */
  public static final int SECTION_INVALID_VALUE = 3;
  /**
   * <pre>
   * The specified section could not be found.
   * </pre>
   *
   * <code>SECTION_NOT_FOUND = 4;</code>
   */
  public static final int SECTION_NOT_FOUND_VALUE = 4;
  /**
   * <pre>
   * The specified partner/location pair was valid, but menu data could not be resolved.
   * </pre>
   *
   * <code>MENU_NOT_FOUND = 5;</code>
   */
  public static final int MENU_NOT_FOUND_VALUE = 5;
  /**
   * <pre>
   * Search services are currently unavailable.
   * </pre>
   *
   * <code>SEARCH_UNAVAILABLE = 6;</code>
   */
  public static final int SEARCH_UNAVAILABLE_VALUE = 6;
  /**
   * <pre>
   * Failed to locate a product by key.
   * </pre>
   *
   * <code>PRODUCT_NOT_FOUND = 7;</code>
   */
  public static final int PRODUCT_NOT_FOUND_VALUE = 7;
  /**
   * <pre>
   * The configured access permissions do not allow the requested operation.
   * </pre>
   *
   * <code>ACCESS_DENIED = 8;</code>
   */
  public static final int ACCESS_DENIED_VALUE = 8;
  /**
   * <pre>
   * The specified product key was found to be invalid.
   * </pre>
   *
   * <code>KEY_INVALID = 9;</code>
   */
  public static final int KEY_INVALID_VALUE = 9;
  /**
   * <pre>
   * The provided update was rejected.
   * </pre>
   *
   * <code>UPDATE_INVALID = 10;</code>
   */
  public static final int UPDATE_INVALID_VALUE = 10;
  /**
   * <pre>
   * The provided update was rejected due to a conflict.
   * </pre>
   *
   * <code>CONFLICT = 11;</code>
   */
  public static final int CONFLICT_VALUE = 11;
  /**
   * <pre>
   * The server encountered some internal error.
   * </pre>
   *
   * <code>INTERNAL_ERROR = 99;</code>
   */
  public static final int INTERNAL_ERROR_VALUE = 99;


  public final int getNumber() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalArgumentException(
          "Can't get the number of an unknown enum value.");
    }
    return value;
  }

  /**
   * @deprecated Use {@link #forNumber(int)} instead.
   */
  @java.lang.Deprecated
  public static MenuError valueOf(int value) {
    return forNumber(value);
  }

  public static MenuError forNumber(int value) {
    switch (value) {
      case 0: return NO_ERROR;
      case 1: return PARTNER_INVALID;
      case 2: return LOCATION_INVALID;
      case 3: return SECTION_INVALID;
      case 4: return SECTION_NOT_FOUND;
      case 5: return MENU_NOT_FOUND;
      case 6: return SEARCH_UNAVAILABLE;
      case 7: return PRODUCT_NOT_FOUND;
      case 8: return ACCESS_DENIED;
      case 9: return KEY_INVALID;
      case 10: return UPDATE_INVALID;
      case 11: return CONFLICT;
      case 99: return INTERNAL_ERROR;
      default: return null;
    }
  }

  public static com.google.protobuf.Internal.EnumLiteMap<MenuError>
      internalGetValueMap() {
    return internalValueMap;
  }
  private static final com.google.protobuf.Internal.EnumLiteMap<
      MenuError> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<MenuError>() {
          public MenuError findValueByNumber(int number) {
            return MenuError.forNumber(number);
          }
        };

  public final com.google.protobuf.Descriptors.EnumValueDescriptor
      getValueDescriptor() {
    return getDescriptor().getValues().get(ordinal());
  }
  public final com.google.protobuf.Descriptors.EnumDescriptor
      getDescriptorForType() {
    return getDescriptor();
  }
  public static final com.google.protobuf.Descriptors.EnumDescriptor
      getDescriptor() {
    return io.bloombox.schema.services.menu.v1beta1.MenuServiceBeta1.getDescriptor().getEnumTypes().get(0);
  }

  private static final MenuError[] VALUES = values();

  public static MenuError valueOf(
      com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
    if (desc.getType() != getDescriptor()) {
      throw new java.lang.IllegalArgumentException(
        "EnumValueDescriptor is not for this type.");
    }
    if (desc.getIndex() == -1) {
      return UNRECOGNIZED;
    }
    return VALUES[desc.getIndex()];
  }

  private final int value;

  private MenuError(int value) {
    this.value = value;
  }

  // @@protoc_insertion_point(enum_scope:bloombox.schema.services.menu.v1beta1.MenuError)
}

