/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: platform/v1/PlatformService_v1.proto

package io.bloombox.schema.services.platform.v1;

/**
 * <pre>
 * Enumerates known errors that may be thrown by platform API operations.
 * </pre>
 *
 * Protobuf enum {@code bloombox.schema.services.platform.v1.PlatformError}
 */
public enum PlatformError
    implements com.google.protobuf.ProtocolMessageEnum {
  /**
   * <pre>
   * No error was encountered.
   * </pre>
   *
   * <code>NO_ERROR = 0;</code>
   */
  NO_ERROR(0),
  /**
   * <pre>
   * Search services are not currently available.
   * </pre>
   *
   * <code>SEARCH_NOT_AVAILABLE = 1;</code>
   */
  SEARCH_NOT_AVAILABLE(1),
  /**
   * <pre>
   * The domain origin value was missing or invalid.
   * </pre>
   *
   * <code>ORIGIN_INVALID = 2;</code>
   */
  ORIGIN_INVALID(2),
  /**
   * <pre>
   * The specified domain or origin could not be resolved.
   * </pre>
   *
   * <code>ORIGIN_NOT_FOUND = 3;</code>
   */
  ORIGIN_NOT_FOUND(3),
  UNRECOGNIZED(-1),
  ;

  /**
   * <pre>
   * No error was encountered.
   * </pre>
   *
   * <code>NO_ERROR = 0;</code>
   */
  public static final int NO_ERROR_VALUE = 0;
  /**
   * <pre>
   * Search services are not currently available.
   * </pre>
   *
   * <code>SEARCH_NOT_AVAILABLE = 1;</code>
   */
  public static final int SEARCH_NOT_AVAILABLE_VALUE = 1;
  /**
   * <pre>
   * The domain origin value was missing or invalid.
   * </pre>
   *
   * <code>ORIGIN_INVALID = 2;</code>
   */
  public static final int ORIGIN_INVALID_VALUE = 2;
  /**
   * <pre>
   * The specified domain or origin could not be resolved.
   * </pre>
   *
   * <code>ORIGIN_NOT_FOUND = 3;</code>
   */
  public static final int ORIGIN_NOT_FOUND_VALUE = 3;


  public final int getNumber() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalArgumentException(
          "Can't get the number of an unknown enum value.");
    }
    return value;
  }

  /**
   * @deprecated Use {@link #forNumber(int)} instead.
   */
  @java.lang.Deprecated
  public static PlatformError valueOf(int value) {
    return forNumber(value);
  }

  public static PlatformError forNumber(int value) {
    switch (value) {
      case 0: return NO_ERROR;
      case 1: return SEARCH_NOT_AVAILABLE;
      case 2: return ORIGIN_INVALID;
      case 3: return ORIGIN_NOT_FOUND;
      default: return null;
    }
  }

  public static com.google.protobuf.Internal.EnumLiteMap<PlatformError>
      internalGetValueMap() {
    return internalValueMap;
  }
  private static final com.google.protobuf.Internal.EnumLiteMap<
      PlatformError> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<PlatformError>() {
          public PlatformError findValueByNumber(int number) {
            return PlatformError.forNumber(number);
          }
        };

  public final com.google.protobuf.Descriptors.EnumValueDescriptor
      getValueDescriptor() {
    return getDescriptor().getValues().get(ordinal());
  }
  public final com.google.protobuf.Descriptors.EnumDescriptor
      getDescriptorForType() {
    return getDescriptor();
  }
  public static final com.google.protobuf.Descriptors.EnumDescriptor
      getDescriptor() {
    return io.bloombox.schema.services.platform.v1.PlatformServiceV1.getDescriptor().getEnumTypes().get(0);
  }

  private static final PlatformError[] VALUES = values();

  public static PlatformError valueOf(
      com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
    if (desc.getType() != getDescriptor()) {
      throw new java.lang.IllegalArgumentException(
        "EnumValueDescriptor is not for this type.");
    }
    if (desc.getIndex() == -1) {
      return UNRECOGNIZED;
    }
    return VALUES[desc.getIndex()];
  }

  private final int value;

  private PlatformError(int value) {
    this.value = value;
  }

  // @@protoc_insertion_point(enum_scope:bloombox.schema.services.platform.v1.PlatformError)
}

