/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: shop/v1/ShopService_v1.proto

package io.bloombox.schema.services.shop.v1;

/**
 * <pre>
 * Specifies a request and response cycle to validate a US zipcode for delivery eligibility.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.services.shop.v1.CheckZipcode}
 */
public  final class CheckZipcode extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.services.shop.v1.CheckZipcode)
    CheckZipcodeOrBuilder {
private static final long serialVersionUID = 0L;
  // Use CheckZipcode.newBuilder() to construct.
  private CheckZipcode(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private CheckZipcode() {
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private CheckZipcode(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_CheckZipcode_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_CheckZipcode_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.services.shop.v1.CheckZipcode.class, io.bloombox.schema.services.shop.v1.CheckZipcode.Builder.class);
  }

  public interface RequestOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.shop.v1.CheckZipcode.Request)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Zip code to check.
     * </pre>
     *
     * <code>string zipcode = 1;</code>
     */
    java.lang.String getZipcode();
    /**
     * <pre>
     * Zip code to check.
     * </pre>
     *
     * <code>string zipcode = 1;</code>
     */
    com.google.protobuf.ByteString
        getZipcodeBytes();

    /**
     * <pre>
     * Location to check.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerLocationKey location = 2;</code>
     */
    boolean hasLocation();
    /**
     * <pre>
     * Location to check.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerLocationKey location = 2;</code>
     */
    io.bloombox.schema.partner.PartnerLocationKey getLocation();
    /**
     * <pre>
     * Location to check.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerLocationKey location = 2;</code>
     */
    io.bloombox.schema.partner.PartnerLocationKeyOrBuilder getLocationOrBuilder();
  }
  /**
   * Protobuf type {@code bloombox.schema.services.shop.v1.CheckZipcode.Request}
   */
  public  static final class Request extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.shop.v1.CheckZipcode.Request)
      RequestOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Request.newBuilder() to construct.
    private Request(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Request() {
      zipcode_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Request(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              zipcode_ = s;
              break;
            }
            case 18: {
              io.bloombox.schema.partner.PartnerLocationKey.Builder subBuilder = null;
              if (location_ != null) {
                subBuilder = location_.toBuilder();
              }
              location_ = input.readMessage(io.bloombox.schema.partner.PartnerLocationKey.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(location_);
                location_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_CheckZipcode_Request_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_CheckZipcode_Request_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.shop.v1.CheckZipcode.Request.class, io.bloombox.schema.services.shop.v1.CheckZipcode.Request.Builder.class);
    }

    public static final int ZIPCODE_FIELD_NUMBER = 1;
    private volatile java.lang.Object zipcode_;
    /**
     * <pre>
     * Zip code to check.
     * </pre>
     *
     * <code>string zipcode = 1;</code>
     */
    public java.lang.String getZipcode() {
      java.lang.Object ref = zipcode_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        zipcode_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Zip code to check.
     * </pre>
     *
     * <code>string zipcode = 1;</code>
     */
    public com.google.protobuf.ByteString
        getZipcodeBytes() {
      java.lang.Object ref = zipcode_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        zipcode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LOCATION_FIELD_NUMBER = 2;
    private io.bloombox.schema.partner.PartnerLocationKey location_;
    /**
     * <pre>
     * Location to check.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerLocationKey location = 2;</code>
     */
    public boolean hasLocation() {
      return location_ != null;
    }
    /**
     * <pre>
     * Location to check.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerLocationKey location = 2;</code>
     */
    public io.bloombox.schema.partner.PartnerLocationKey getLocation() {
      return location_ == null ? io.bloombox.schema.partner.PartnerLocationKey.getDefaultInstance() : location_;
    }
    /**
     * <pre>
     * Location to check.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerLocationKey location = 2;</code>
     */
    public io.bloombox.schema.partner.PartnerLocationKeyOrBuilder getLocationOrBuilder() {
      return getLocation();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getZipcodeBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, zipcode_);
      }
      if (location_ != null) {
        output.writeMessage(2, getLocation());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getZipcodeBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, zipcode_);
      }
      if (location_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getLocation());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.shop.v1.CheckZipcode.Request)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.shop.v1.CheckZipcode.Request other = (io.bloombox.schema.services.shop.v1.CheckZipcode.Request) obj;

      boolean result = true;
      result = result && getZipcode()
          .equals(other.getZipcode());
      result = result && (hasLocation() == other.hasLocation());
      if (hasLocation()) {
        result = result && getLocation()
            .equals(other.getLocation());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ZIPCODE_FIELD_NUMBER;
      hash = (53 * hash) + getZipcode().hashCode();
      if (hasLocation()) {
        hash = (37 * hash) + LOCATION_FIELD_NUMBER;
        hash = (53 * hash) + getLocation().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Request parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Request parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Request parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Request parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Request parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Request parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Request parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Request parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Request parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Request parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Request parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Request parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.shop.v1.CheckZipcode.Request prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code bloombox.schema.services.shop.v1.CheckZipcode.Request}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.shop.v1.CheckZipcode.Request)
        io.bloombox.schema.services.shop.v1.CheckZipcode.RequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_CheckZipcode_Request_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_CheckZipcode_Request_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.shop.v1.CheckZipcode.Request.class, io.bloombox.schema.services.shop.v1.CheckZipcode.Request.Builder.class);
      }

      // Construct using io.bloombox.schema.services.shop.v1.CheckZipcode.Request.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        zipcode_ = "";

        if (locationBuilder_ == null) {
          location_ = null;
        } else {
          location_ = null;
          locationBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_CheckZipcode_Request_descriptor;
      }

      public io.bloombox.schema.services.shop.v1.CheckZipcode.Request getDefaultInstanceForType() {
        return io.bloombox.schema.services.shop.v1.CheckZipcode.Request.getDefaultInstance();
      }

      public io.bloombox.schema.services.shop.v1.CheckZipcode.Request build() {
        io.bloombox.schema.services.shop.v1.CheckZipcode.Request result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.shop.v1.CheckZipcode.Request buildPartial() {
        io.bloombox.schema.services.shop.v1.CheckZipcode.Request result = new io.bloombox.schema.services.shop.v1.CheckZipcode.Request(this);
        result.zipcode_ = zipcode_;
        if (locationBuilder_ == null) {
          result.location_ = location_;
        } else {
          result.location_ = locationBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.shop.v1.CheckZipcode.Request) {
          return mergeFrom((io.bloombox.schema.services.shop.v1.CheckZipcode.Request)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.shop.v1.CheckZipcode.Request other) {
        if (other == io.bloombox.schema.services.shop.v1.CheckZipcode.Request.getDefaultInstance()) return this;
        if (!other.getZipcode().isEmpty()) {
          zipcode_ = other.zipcode_;
          onChanged();
        }
        if (other.hasLocation()) {
          mergeLocation(other.getLocation());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.shop.v1.CheckZipcode.Request parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.shop.v1.CheckZipcode.Request) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object zipcode_ = "";
      /**
       * <pre>
       * Zip code to check.
       * </pre>
       *
       * <code>string zipcode = 1;</code>
       */
      public java.lang.String getZipcode() {
        java.lang.Object ref = zipcode_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          zipcode_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Zip code to check.
       * </pre>
       *
       * <code>string zipcode = 1;</code>
       */
      public com.google.protobuf.ByteString
          getZipcodeBytes() {
        java.lang.Object ref = zipcode_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          zipcode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Zip code to check.
       * </pre>
       *
       * <code>string zipcode = 1;</code>
       */
      public Builder setZipcode(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        zipcode_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Zip code to check.
       * </pre>
       *
       * <code>string zipcode = 1;</code>
       */
      public Builder clearZipcode() {
        
        zipcode_ = getDefaultInstance().getZipcode();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Zip code to check.
       * </pre>
       *
       * <code>string zipcode = 1;</code>
       */
      public Builder setZipcodeBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        zipcode_ = value;
        onChanged();
        return this;
      }

      private io.bloombox.schema.partner.PartnerLocationKey location_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.partner.PartnerLocationKey, io.bloombox.schema.partner.PartnerLocationKey.Builder, io.bloombox.schema.partner.PartnerLocationKeyOrBuilder> locationBuilder_;
      /**
       * <pre>
       * Location to check.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocationKey location = 2;</code>
       */
      public boolean hasLocation() {
        return locationBuilder_ != null || location_ != null;
      }
      /**
       * <pre>
       * Location to check.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocationKey location = 2;</code>
       */
      public io.bloombox.schema.partner.PartnerLocationKey getLocation() {
        if (locationBuilder_ == null) {
          return location_ == null ? io.bloombox.schema.partner.PartnerLocationKey.getDefaultInstance() : location_;
        } else {
          return locationBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Location to check.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocationKey location = 2;</code>
       */
      public Builder setLocation(io.bloombox.schema.partner.PartnerLocationKey value) {
        if (locationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          location_ = value;
          onChanged();
        } else {
          locationBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Location to check.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocationKey location = 2;</code>
       */
      public Builder setLocation(
          io.bloombox.schema.partner.PartnerLocationKey.Builder builderForValue) {
        if (locationBuilder_ == null) {
          location_ = builderForValue.build();
          onChanged();
        } else {
          locationBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Location to check.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocationKey location = 2;</code>
       */
      public Builder mergeLocation(io.bloombox.schema.partner.PartnerLocationKey value) {
        if (locationBuilder_ == null) {
          if (location_ != null) {
            location_ =
              io.bloombox.schema.partner.PartnerLocationKey.newBuilder(location_).mergeFrom(value).buildPartial();
          } else {
            location_ = value;
          }
          onChanged();
        } else {
          locationBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Location to check.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocationKey location = 2;</code>
       */
      public Builder clearLocation() {
        if (locationBuilder_ == null) {
          location_ = null;
          onChanged();
        } else {
          location_ = null;
          locationBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Location to check.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocationKey location = 2;</code>
       */
      public io.bloombox.schema.partner.PartnerLocationKey.Builder getLocationBuilder() {
        
        onChanged();
        return getLocationFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Location to check.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocationKey location = 2;</code>
       */
      public io.bloombox.schema.partner.PartnerLocationKeyOrBuilder getLocationOrBuilder() {
        if (locationBuilder_ != null) {
          return locationBuilder_.getMessageOrBuilder();
        } else {
          return location_ == null ?
              io.bloombox.schema.partner.PartnerLocationKey.getDefaultInstance() : location_;
        }
      }
      /**
       * <pre>
       * Location to check.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocationKey location = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.partner.PartnerLocationKey, io.bloombox.schema.partner.PartnerLocationKey.Builder, io.bloombox.schema.partner.PartnerLocationKeyOrBuilder> 
          getLocationFieldBuilder() {
        if (locationBuilder_ == null) {
          locationBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.partner.PartnerLocationKey, io.bloombox.schema.partner.PartnerLocationKey.Builder, io.bloombox.schema.partner.PartnerLocationKeyOrBuilder>(
                  getLocation(),
                  getParentForChildren(),
                  isClean());
          location_ = null;
        }
        return locationBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.shop.v1.CheckZipcode.Request)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.shop.v1.CheckZipcode.Request)
    private static final io.bloombox.schema.services.shop.v1.CheckZipcode.Request DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.shop.v1.CheckZipcode.Request();
    }

    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Request getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Request>
        PARSER = new com.google.protobuf.AbstractParser<Request>() {
      public Request parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Request(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Request> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Request> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.shop.v1.CheckZipcode.Request getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ResponseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.shop.v1.CheckZipcode.Response)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Whether that zipcode is supported for delivery or not.
     * </pre>
     *
     * <code>bool supported = 1;</code>
     */
    boolean getSupported();

    /**
     * <pre>
     * Order minimum for delivery in this zipcode.
     * </pre>
     *
     * <code>float delivery_minimum = 2;</code>
     */
    float getDeliveryMinimum();
  }
  /**
   * Protobuf type {@code bloombox.schema.services.shop.v1.CheckZipcode.Response}
   */
  public  static final class Response extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.shop.v1.CheckZipcode.Response)
      ResponseOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Response.newBuilder() to construct.
    private Response(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Response() {
      supported_ = false;
      deliveryMinimum_ = 0F;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Response(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {

              supported_ = input.readBool();
              break;
            }
            case 21: {

              deliveryMinimum_ = input.readFloat();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_CheckZipcode_Response_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_CheckZipcode_Response_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.shop.v1.CheckZipcode.Response.class, io.bloombox.schema.services.shop.v1.CheckZipcode.Response.Builder.class);
    }

    public static final int SUPPORTED_FIELD_NUMBER = 1;
    private boolean supported_;
    /**
     * <pre>
     * Whether that zipcode is supported for delivery or not.
     * </pre>
     *
     * <code>bool supported = 1;</code>
     */
    public boolean getSupported() {
      return supported_;
    }

    public static final int DELIVERY_MINIMUM_FIELD_NUMBER = 2;
    private float deliveryMinimum_;
    /**
     * <pre>
     * Order minimum for delivery in this zipcode.
     * </pre>
     *
     * <code>float delivery_minimum = 2;</code>
     */
    public float getDeliveryMinimum() {
      return deliveryMinimum_;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (supported_ != false) {
        output.writeBool(1, supported_);
      }
      if (deliveryMinimum_ != 0F) {
        output.writeFloat(2, deliveryMinimum_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (supported_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(1, supported_);
      }
      if (deliveryMinimum_ != 0F) {
        size += com.google.protobuf.CodedOutputStream
          .computeFloatSize(2, deliveryMinimum_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.shop.v1.CheckZipcode.Response)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.shop.v1.CheckZipcode.Response other = (io.bloombox.schema.services.shop.v1.CheckZipcode.Response) obj;

      boolean result = true;
      result = result && (getSupported()
          == other.getSupported());
      result = result && (
          java.lang.Float.floatToIntBits(getDeliveryMinimum())
          == java.lang.Float.floatToIntBits(
              other.getDeliveryMinimum()));
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SUPPORTED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getSupported());
      hash = (37 * hash) + DELIVERY_MINIMUM_FIELD_NUMBER;
      hash = (53 * hash) + java.lang.Float.floatToIntBits(
          getDeliveryMinimum());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Response parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Response parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Response parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Response parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Response parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Response parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Response parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Response parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Response parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Response parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Response parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Response parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.shop.v1.CheckZipcode.Response prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code bloombox.schema.services.shop.v1.CheckZipcode.Response}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.shop.v1.CheckZipcode.Response)
        io.bloombox.schema.services.shop.v1.CheckZipcode.ResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_CheckZipcode_Response_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_CheckZipcode_Response_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.shop.v1.CheckZipcode.Response.class, io.bloombox.schema.services.shop.v1.CheckZipcode.Response.Builder.class);
      }

      // Construct using io.bloombox.schema.services.shop.v1.CheckZipcode.Response.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        supported_ = false;

        deliveryMinimum_ = 0F;

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_CheckZipcode_Response_descriptor;
      }

      public io.bloombox.schema.services.shop.v1.CheckZipcode.Response getDefaultInstanceForType() {
        return io.bloombox.schema.services.shop.v1.CheckZipcode.Response.getDefaultInstance();
      }

      public io.bloombox.schema.services.shop.v1.CheckZipcode.Response build() {
        io.bloombox.schema.services.shop.v1.CheckZipcode.Response result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.shop.v1.CheckZipcode.Response buildPartial() {
        io.bloombox.schema.services.shop.v1.CheckZipcode.Response result = new io.bloombox.schema.services.shop.v1.CheckZipcode.Response(this);
        result.supported_ = supported_;
        result.deliveryMinimum_ = deliveryMinimum_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.shop.v1.CheckZipcode.Response) {
          return mergeFrom((io.bloombox.schema.services.shop.v1.CheckZipcode.Response)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.shop.v1.CheckZipcode.Response other) {
        if (other == io.bloombox.schema.services.shop.v1.CheckZipcode.Response.getDefaultInstance()) return this;
        if (other.getSupported() != false) {
          setSupported(other.getSupported());
        }
        if (other.getDeliveryMinimum() != 0F) {
          setDeliveryMinimum(other.getDeliveryMinimum());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.shop.v1.CheckZipcode.Response parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.shop.v1.CheckZipcode.Response) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private boolean supported_ ;
      /**
       * <pre>
       * Whether that zipcode is supported for delivery or not.
       * </pre>
       *
       * <code>bool supported = 1;</code>
       */
      public boolean getSupported() {
        return supported_;
      }
      /**
       * <pre>
       * Whether that zipcode is supported for delivery or not.
       * </pre>
       *
       * <code>bool supported = 1;</code>
       */
      public Builder setSupported(boolean value) {
        
        supported_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Whether that zipcode is supported for delivery or not.
       * </pre>
       *
       * <code>bool supported = 1;</code>
       */
      public Builder clearSupported() {
        
        supported_ = false;
        onChanged();
        return this;
      }

      private float deliveryMinimum_ ;
      /**
       * <pre>
       * Order minimum for delivery in this zipcode.
       * </pre>
       *
       * <code>float delivery_minimum = 2;</code>
       */
      public float getDeliveryMinimum() {
        return deliveryMinimum_;
      }
      /**
       * <pre>
       * Order minimum for delivery in this zipcode.
       * </pre>
       *
       * <code>float delivery_minimum = 2;</code>
       */
      public Builder setDeliveryMinimum(float value) {
        
        deliveryMinimum_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Order minimum for delivery in this zipcode.
       * </pre>
       *
       * <code>float delivery_minimum = 2;</code>
       */
      public Builder clearDeliveryMinimum() {
        
        deliveryMinimum_ = 0F;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.shop.v1.CheckZipcode.Response)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.shop.v1.CheckZipcode.Response)
    private static final io.bloombox.schema.services.shop.v1.CheckZipcode.Response DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.shop.v1.CheckZipcode.Response();
    }

    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Response getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Response>
        PARSER = new com.google.protobuf.AbstractParser<Response>() {
      public Response parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Response(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Response> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Response> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.shop.v1.CheckZipcode.Response getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface OperationOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.shop.v1.CheckZipcode.Operation)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Request for zipcode eligibility verification.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.CheckZipcode.Request request = 1;</code>
     */
    boolean hasRequest();
    /**
     * <pre>
     * Request for zipcode eligibility verification.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.CheckZipcode.Request request = 1;</code>
     */
    io.bloombox.schema.services.shop.v1.CheckZipcode.Request getRequest();
    /**
     * <pre>
     * Request for zipcode eligibility verification.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.CheckZipcode.Request request = 1;</code>
     */
    io.bloombox.schema.services.shop.v1.CheckZipcode.RequestOrBuilder getRequestOrBuilder();

    /**
     * <pre>
     * Response to a request for zipcode eligibility verification.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.CheckZipcode.Response response = 2;</code>
     */
    boolean hasResponse();
    /**
     * <pre>
     * Response to a request for zipcode eligibility verification.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.CheckZipcode.Response response = 2;</code>
     */
    io.bloombox.schema.services.shop.v1.CheckZipcode.Response getResponse();
    /**
     * <pre>
     * Response to a request for zipcode eligibility verification.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.CheckZipcode.Response response = 2;</code>
     */
    io.bloombox.schema.services.shop.v1.CheckZipcode.ResponseOrBuilder getResponseOrBuilder();
  }
  /**
   * Protobuf type {@code bloombox.schema.services.shop.v1.CheckZipcode.Operation}
   */
  public  static final class Operation extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.shop.v1.CheckZipcode.Operation)
      OperationOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Operation.newBuilder() to construct.
    private Operation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Operation() {
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Operation(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              io.bloombox.schema.services.shop.v1.CheckZipcode.Request.Builder subBuilder = null;
              if (request_ != null) {
                subBuilder = request_.toBuilder();
              }
              request_ = input.readMessage(io.bloombox.schema.services.shop.v1.CheckZipcode.Request.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(request_);
                request_ = subBuilder.buildPartial();
              }

              break;
            }
            case 18: {
              io.bloombox.schema.services.shop.v1.CheckZipcode.Response.Builder subBuilder = null;
              if (response_ != null) {
                subBuilder = response_.toBuilder();
              }
              response_ = input.readMessage(io.bloombox.schema.services.shop.v1.CheckZipcode.Response.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(response_);
                response_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_CheckZipcode_Operation_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_CheckZipcode_Operation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.shop.v1.CheckZipcode.Operation.class, io.bloombox.schema.services.shop.v1.CheckZipcode.Operation.Builder.class);
    }

    public static final int REQUEST_FIELD_NUMBER = 1;
    private io.bloombox.schema.services.shop.v1.CheckZipcode.Request request_;
    /**
     * <pre>
     * Request for zipcode eligibility verification.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.CheckZipcode.Request request = 1;</code>
     */
    public boolean hasRequest() {
      return request_ != null;
    }
    /**
     * <pre>
     * Request for zipcode eligibility verification.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.CheckZipcode.Request request = 1;</code>
     */
    public io.bloombox.schema.services.shop.v1.CheckZipcode.Request getRequest() {
      return request_ == null ? io.bloombox.schema.services.shop.v1.CheckZipcode.Request.getDefaultInstance() : request_;
    }
    /**
     * <pre>
     * Request for zipcode eligibility verification.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.CheckZipcode.Request request = 1;</code>
     */
    public io.bloombox.schema.services.shop.v1.CheckZipcode.RequestOrBuilder getRequestOrBuilder() {
      return getRequest();
    }

    public static final int RESPONSE_FIELD_NUMBER = 2;
    private io.bloombox.schema.services.shop.v1.CheckZipcode.Response response_;
    /**
     * <pre>
     * Response to a request for zipcode eligibility verification.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.CheckZipcode.Response response = 2;</code>
     */
    public boolean hasResponse() {
      return response_ != null;
    }
    /**
     * <pre>
     * Response to a request for zipcode eligibility verification.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.CheckZipcode.Response response = 2;</code>
     */
    public io.bloombox.schema.services.shop.v1.CheckZipcode.Response getResponse() {
      return response_ == null ? io.bloombox.schema.services.shop.v1.CheckZipcode.Response.getDefaultInstance() : response_;
    }
    /**
     * <pre>
     * Response to a request for zipcode eligibility verification.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.CheckZipcode.Response response = 2;</code>
     */
    public io.bloombox.schema.services.shop.v1.CheckZipcode.ResponseOrBuilder getResponseOrBuilder() {
      return getResponse();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (request_ != null) {
        output.writeMessage(1, getRequest());
      }
      if (response_ != null) {
        output.writeMessage(2, getResponse());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (request_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getRequest());
      }
      if (response_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getResponse());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.shop.v1.CheckZipcode.Operation)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.shop.v1.CheckZipcode.Operation other = (io.bloombox.schema.services.shop.v1.CheckZipcode.Operation) obj;

      boolean result = true;
      result = result && (hasRequest() == other.hasRequest());
      if (hasRequest()) {
        result = result && getRequest()
            .equals(other.getRequest());
      }
      result = result && (hasResponse() == other.hasResponse());
      if (hasResponse()) {
        result = result && getResponse()
            .equals(other.getResponse());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasRequest()) {
        hash = (37 * hash) + REQUEST_FIELD_NUMBER;
        hash = (53 * hash) + getRequest().hashCode();
      }
      if (hasResponse()) {
        hash = (37 * hash) + RESPONSE_FIELD_NUMBER;
        hash = (53 * hash) + getResponse().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Operation parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Operation parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Operation parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Operation parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Operation parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Operation parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Operation parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Operation parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Operation parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Operation parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Operation parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Operation parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.shop.v1.CheckZipcode.Operation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code bloombox.schema.services.shop.v1.CheckZipcode.Operation}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.shop.v1.CheckZipcode.Operation)
        io.bloombox.schema.services.shop.v1.CheckZipcode.OperationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_CheckZipcode_Operation_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_CheckZipcode_Operation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.shop.v1.CheckZipcode.Operation.class, io.bloombox.schema.services.shop.v1.CheckZipcode.Operation.Builder.class);
      }

      // Construct using io.bloombox.schema.services.shop.v1.CheckZipcode.Operation.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        if (requestBuilder_ == null) {
          request_ = null;
        } else {
          request_ = null;
          requestBuilder_ = null;
        }
        if (responseBuilder_ == null) {
          response_ = null;
        } else {
          response_ = null;
          responseBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_CheckZipcode_Operation_descriptor;
      }

      public io.bloombox.schema.services.shop.v1.CheckZipcode.Operation getDefaultInstanceForType() {
        return io.bloombox.schema.services.shop.v1.CheckZipcode.Operation.getDefaultInstance();
      }

      public io.bloombox.schema.services.shop.v1.CheckZipcode.Operation build() {
        io.bloombox.schema.services.shop.v1.CheckZipcode.Operation result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.shop.v1.CheckZipcode.Operation buildPartial() {
        io.bloombox.schema.services.shop.v1.CheckZipcode.Operation result = new io.bloombox.schema.services.shop.v1.CheckZipcode.Operation(this);
        if (requestBuilder_ == null) {
          result.request_ = request_;
        } else {
          result.request_ = requestBuilder_.build();
        }
        if (responseBuilder_ == null) {
          result.response_ = response_;
        } else {
          result.response_ = responseBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.shop.v1.CheckZipcode.Operation) {
          return mergeFrom((io.bloombox.schema.services.shop.v1.CheckZipcode.Operation)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.shop.v1.CheckZipcode.Operation other) {
        if (other == io.bloombox.schema.services.shop.v1.CheckZipcode.Operation.getDefaultInstance()) return this;
        if (other.hasRequest()) {
          mergeRequest(other.getRequest());
        }
        if (other.hasResponse()) {
          mergeResponse(other.getResponse());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.shop.v1.CheckZipcode.Operation parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.shop.v1.CheckZipcode.Operation) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private io.bloombox.schema.services.shop.v1.CheckZipcode.Request request_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.services.shop.v1.CheckZipcode.Request, io.bloombox.schema.services.shop.v1.CheckZipcode.Request.Builder, io.bloombox.schema.services.shop.v1.CheckZipcode.RequestOrBuilder> requestBuilder_;
      /**
       * <pre>
       * Request for zipcode eligibility verification.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.CheckZipcode.Request request = 1;</code>
       */
      public boolean hasRequest() {
        return requestBuilder_ != null || request_ != null;
      }
      /**
       * <pre>
       * Request for zipcode eligibility verification.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.CheckZipcode.Request request = 1;</code>
       */
      public io.bloombox.schema.services.shop.v1.CheckZipcode.Request getRequest() {
        if (requestBuilder_ == null) {
          return request_ == null ? io.bloombox.schema.services.shop.v1.CheckZipcode.Request.getDefaultInstance() : request_;
        } else {
          return requestBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Request for zipcode eligibility verification.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.CheckZipcode.Request request = 1;</code>
       */
      public Builder setRequest(io.bloombox.schema.services.shop.v1.CheckZipcode.Request value) {
        if (requestBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          request_ = value;
          onChanged();
        } else {
          requestBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Request for zipcode eligibility verification.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.CheckZipcode.Request request = 1;</code>
       */
      public Builder setRequest(
          io.bloombox.schema.services.shop.v1.CheckZipcode.Request.Builder builderForValue) {
        if (requestBuilder_ == null) {
          request_ = builderForValue.build();
          onChanged();
        } else {
          requestBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Request for zipcode eligibility verification.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.CheckZipcode.Request request = 1;</code>
       */
      public Builder mergeRequest(io.bloombox.schema.services.shop.v1.CheckZipcode.Request value) {
        if (requestBuilder_ == null) {
          if (request_ != null) {
            request_ =
              io.bloombox.schema.services.shop.v1.CheckZipcode.Request.newBuilder(request_).mergeFrom(value).buildPartial();
          } else {
            request_ = value;
          }
          onChanged();
        } else {
          requestBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Request for zipcode eligibility verification.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.CheckZipcode.Request request = 1;</code>
       */
      public Builder clearRequest() {
        if (requestBuilder_ == null) {
          request_ = null;
          onChanged();
        } else {
          request_ = null;
          requestBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Request for zipcode eligibility verification.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.CheckZipcode.Request request = 1;</code>
       */
      public io.bloombox.schema.services.shop.v1.CheckZipcode.Request.Builder getRequestBuilder() {
        
        onChanged();
        return getRequestFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Request for zipcode eligibility verification.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.CheckZipcode.Request request = 1;</code>
       */
      public io.bloombox.schema.services.shop.v1.CheckZipcode.RequestOrBuilder getRequestOrBuilder() {
        if (requestBuilder_ != null) {
          return requestBuilder_.getMessageOrBuilder();
        } else {
          return request_ == null ?
              io.bloombox.schema.services.shop.v1.CheckZipcode.Request.getDefaultInstance() : request_;
        }
      }
      /**
       * <pre>
       * Request for zipcode eligibility verification.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.CheckZipcode.Request request = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.services.shop.v1.CheckZipcode.Request, io.bloombox.schema.services.shop.v1.CheckZipcode.Request.Builder, io.bloombox.schema.services.shop.v1.CheckZipcode.RequestOrBuilder> 
          getRequestFieldBuilder() {
        if (requestBuilder_ == null) {
          requestBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.services.shop.v1.CheckZipcode.Request, io.bloombox.schema.services.shop.v1.CheckZipcode.Request.Builder, io.bloombox.schema.services.shop.v1.CheckZipcode.RequestOrBuilder>(
                  getRequest(),
                  getParentForChildren(),
                  isClean());
          request_ = null;
        }
        return requestBuilder_;
      }

      private io.bloombox.schema.services.shop.v1.CheckZipcode.Response response_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.services.shop.v1.CheckZipcode.Response, io.bloombox.schema.services.shop.v1.CheckZipcode.Response.Builder, io.bloombox.schema.services.shop.v1.CheckZipcode.ResponseOrBuilder> responseBuilder_;
      /**
       * <pre>
       * Response to a request for zipcode eligibility verification.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.CheckZipcode.Response response = 2;</code>
       */
      public boolean hasResponse() {
        return responseBuilder_ != null || response_ != null;
      }
      /**
       * <pre>
       * Response to a request for zipcode eligibility verification.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.CheckZipcode.Response response = 2;</code>
       */
      public io.bloombox.schema.services.shop.v1.CheckZipcode.Response getResponse() {
        if (responseBuilder_ == null) {
          return response_ == null ? io.bloombox.schema.services.shop.v1.CheckZipcode.Response.getDefaultInstance() : response_;
        } else {
          return responseBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Response to a request for zipcode eligibility verification.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.CheckZipcode.Response response = 2;</code>
       */
      public Builder setResponse(io.bloombox.schema.services.shop.v1.CheckZipcode.Response value) {
        if (responseBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          response_ = value;
          onChanged();
        } else {
          responseBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Response to a request for zipcode eligibility verification.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.CheckZipcode.Response response = 2;</code>
       */
      public Builder setResponse(
          io.bloombox.schema.services.shop.v1.CheckZipcode.Response.Builder builderForValue) {
        if (responseBuilder_ == null) {
          response_ = builderForValue.build();
          onChanged();
        } else {
          responseBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Response to a request for zipcode eligibility verification.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.CheckZipcode.Response response = 2;</code>
       */
      public Builder mergeResponse(io.bloombox.schema.services.shop.v1.CheckZipcode.Response value) {
        if (responseBuilder_ == null) {
          if (response_ != null) {
            response_ =
              io.bloombox.schema.services.shop.v1.CheckZipcode.Response.newBuilder(response_).mergeFrom(value).buildPartial();
          } else {
            response_ = value;
          }
          onChanged();
        } else {
          responseBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Response to a request for zipcode eligibility verification.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.CheckZipcode.Response response = 2;</code>
       */
      public Builder clearResponse() {
        if (responseBuilder_ == null) {
          response_ = null;
          onChanged();
        } else {
          response_ = null;
          responseBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Response to a request for zipcode eligibility verification.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.CheckZipcode.Response response = 2;</code>
       */
      public io.bloombox.schema.services.shop.v1.CheckZipcode.Response.Builder getResponseBuilder() {
        
        onChanged();
        return getResponseFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Response to a request for zipcode eligibility verification.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.CheckZipcode.Response response = 2;</code>
       */
      public io.bloombox.schema.services.shop.v1.CheckZipcode.ResponseOrBuilder getResponseOrBuilder() {
        if (responseBuilder_ != null) {
          return responseBuilder_.getMessageOrBuilder();
        } else {
          return response_ == null ?
              io.bloombox.schema.services.shop.v1.CheckZipcode.Response.getDefaultInstance() : response_;
        }
      }
      /**
       * <pre>
       * Response to a request for zipcode eligibility verification.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.CheckZipcode.Response response = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.services.shop.v1.CheckZipcode.Response, io.bloombox.schema.services.shop.v1.CheckZipcode.Response.Builder, io.bloombox.schema.services.shop.v1.CheckZipcode.ResponseOrBuilder> 
          getResponseFieldBuilder() {
        if (responseBuilder_ == null) {
          responseBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.services.shop.v1.CheckZipcode.Response, io.bloombox.schema.services.shop.v1.CheckZipcode.Response.Builder, io.bloombox.schema.services.shop.v1.CheckZipcode.ResponseOrBuilder>(
                  getResponse(),
                  getParentForChildren(),
                  isClean());
          response_ = null;
        }
        return responseBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.shop.v1.CheckZipcode.Operation)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.shop.v1.CheckZipcode.Operation)
    private static final io.bloombox.schema.services.shop.v1.CheckZipcode.Operation DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.shop.v1.CheckZipcode.Operation();
    }

    public static io.bloombox.schema.services.shop.v1.CheckZipcode.Operation getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Operation>
        PARSER = new com.google.protobuf.AbstractParser<Operation>() {
      public Operation parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Operation(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Operation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Operation> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.shop.v1.CheckZipcode.Operation getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.services.shop.v1.CheckZipcode)) {
      return super.equals(obj);
    }
    io.bloombox.schema.services.shop.v1.CheckZipcode other = (io.bloombox.schema.services.shop.v1.CheckZipcode) obj;

    boolean result = true;
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.services.shop.v1.CheckZipcode parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.shop.v1.CheckZipcode parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.shop.v1.CheckZipcode parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.shop.v1.CheckZipcode parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.shop.v1.CheckZipcode parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.shop.v1.CheckZipcode parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.shop.v1.CheckZipcode parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.shop.v1.CheckZipcode parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.shop.v1.CheckZipcode parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.shop.v1.CheckZipcode parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.shop.v1.CheckZipcode parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.shop.v1.CheckZipcode parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.services.shop.v1.CheckZipcode prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies a request and response cycle to validate a US zipcode for delivery eligibility.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.shop.v1.CheckZipcode}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.services.shop.v1.CheckZipcode)
      io.bloombox.schema.services.shop.v1.CheckZipcodeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_CheckZipcode_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_CheckZipcode_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.shop.v1.CheckZipcode.class, io.bloombox.schema.services.shop.v1.CheckZipcode.Builder.class);
    }

    // Construct using io.bloombox.schema.services.shop.v1.CheckZipcode.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_CheckZipcode_descriptor;
    }

    public io.bloombox.schema.services.shop.v1.CheckZipcode getDefaultInstanceForType() {
      return io.bloombox.schema.services.shop.v1.CheckZipcode.getDefaultInstance();
    }

    public io.bloombox.schema.services.shop.v1.CheckZipcode build() {
      io.bloombox.schema.services.shop.v1.CheckZipcode result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.services.shop.v1.CheckZipcode buildPartial() {
      io.bloombox.schema.services.shop.v1.CheckZipcode result = new io.bloombox.schema.services.shop.v1.CheckZipcode(this);
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.services.shop.v1.CheckZipcode) {
        return mergeFrom((io.bloombox.schema.services.shop.v1.CheckZipcode)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.services.shop.v1.CheckZipcode other) {
      if (other == io.bloombox.schema.services.shop.v1.CheckZipcode.getDefaultInstance()) return this;
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.services.shop.v1.CheckZipcode parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.services.shop.v1.CheckZipcode) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.services.shop.v1.CheckZipcode)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.services.shop.v1.CheckZipcode)
  private static final io.bloombox.schema.services.shop.v1.CheckZipcode DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.services.shop.v1.CheckZipcode();
  }

  public static io.bloombox.schema.services.shop.v1.CheckZipcode getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CheckZipcode>
      PARSER = new com.google.protobuf.AbstractParser<CheckZipcode>() {
    public CheckZipcode parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new CheckZipcode(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<CheckZipcode> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CheckZipcode> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.services.shop.v1.CheckZipcode getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

