/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: shop/v1/ShopService_v1.proto

package io.bloombox.schema.services.shop.v1;

/**
 * <pre>
 * Specifies an RPC operation to enroll/onboard a new user as a member of a retail dispensary.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.services.shop.v1.EnrollMember}
 */
public  final class EnrollMember extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.services.shop.v1.EnrollMember)
    EnrollMemberOrBuilder {
private static final long serialVersionUID = 0L;
  // Use EnrollMember.newBuilder() to construct.
  private EnrollMember(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private EnrollMember() {
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private EnrollMember(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_EnrollMember_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_EnrollMember_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.services.shop.v1.EnrollMember.class, io.bloombox.schema.services.shop.v1.EnrollMember.Builder.class);
  }

  public interface RequestOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.shop.v1.EnrollMember.Request)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Person record we are enrolling as a member.
     * </pre>
     *
     * <code>.opencannabis.person.Person person = 1;</code>
     */
    boolean hasPerson();
    /**
     * <pre>
     * Person record we are enrolling as a member.
     * </pre>
     *
     * <code>.opencannabis.person.Person person = 1;</code>
     */
    io.opencannabis.schema.person.Person getPerson();
    /**
     * <pre>
     * Person record we are enrolling as a member.
     * </pre>
     *
     * <code>.opencannabis.person.Person person = 1;</code>
     */
    io.opencannabis.schema.person.PersonOrBuilder getPersonOrBuilder();

    /**
     * <pre>
     * Source for this enrollment.
     * </pre>
     *
     * <code>.bloombox.schema.identity.EnrollmentSource source = 2;</code>
     */
    int getSourceValue();
    /**
     * <pre>
     * Source for this enrollment.
     * </pre>
     *
     * <code>.bloombox.schema.identity.EnrollmentSource source = 2;</code>
     */
    io.bloombox.schema.identity.EnrollmentSource getSource();

    /**
     * <pre>
     * Channel that passed us this enrollment.
     * </pre>
     *
     * <code>string channel = 3;</code>
     */
    java.lang.String getChannel();
    /**
     * <pre>
     * Channel that passed us this enrollment.
     * </pre>
     *
     * <code>string channel = 3;</code>
     */
    com.google.protobuf.ByteString
        getChannelBytes();

    /**
     * <pre>
     * Holds information about the user's cannabis recommendation.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 4;</code>
     */
    boolean hasDoctorRec();
    /**
     * <pre>
     * Holds information about the user's cannabis recommendation.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 4;</code>
     */
    io.bloombox.schema.identity.ids.UserDoctorRec getDoctorRec();
    /**
     * <pre>
     * Holds information about the user's cannabis recommendation.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 4;</code>
     */
    io.bloombox.schema.identity.ids.UserDoctorRecOrBuilder getDoctorRecOrBuilder();

    /**
     * <pre>
     * Holds information about the user's driver's license.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ID government_id = 5;</code>
     */
    boolean hasGovernmentId();
    /**
     * <pre>
     * Holds information about the user's driver's license.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ID government_id = 5;</code>
     */
    io.bloombox.schema.identity.ID getGovernmentId();
    /**
     * <pre>
     * Holds information about the user's driver's license.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ID government_id = 5;</code>
     */
    io.bloombox.schema.identity.IDOrBuilder getGovernmentIdOrBuilder();

    /**
     * <pre>
     * Specifies the partner we are enrolling to.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerLocationKey location = 6;</code>
     */
    boolean hasLocation();
    /**
     * <pre>
     * Specifies the partner we are enrolling to.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerLocationKey location = 6;</code>
     */
    io.bloombox.schema.partner.PartnerLocationKey getLocation();
    /**
     * <pre>
     * Specifies the partner we are enrolling to.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerLocationKey location = 6;</code>
     */
    io.bloombox.schema.partner.PartnerLocationKeyOrBuilder getLocationOrBuilder();

    /**
     * <pre>
     * Base64-encoded password. This is for transmission ONLY - do NOT store this value without first either encrypting
     * it strongly, or perfoming a subsequent salt-and-SHA routine.
     * </pre>
     *
     * <code>string password = 7;</code>
     */
    java.lang.String getPassword();
    /**
     * <pre>
     * Base64-encoded password. This is for transmission ONLY - do NOT store this value without first either encrypting
     * it strongly, or perfoming a subsequent salt-and-SHA routine.
     * </pre>
     *
     * <code>string password = 7;</code>
     */
    com.google.protobuf.ByteString
        getPasswordBytes();

    /**
     * <pre>
     * Flag to indicate that this is a dry run, and we should not actually write the user to any external
     * or persistence systems.
     * </pre>
     *
     * <code>bool dry_run = 8;</code>
     */
    boolean getDryRun();

    /**
     * <pre>
     * Specifies information related to a cannabis consumer's consumption preferences.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ConsumerProfile consumer_profile = 9;</code>
     */
    boolean hasConsumerProfile();
    /**
     * <pre>
     * Specifies information related to a cannabis consumer's consumption preferences.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ConsumerProfile consumer_profile = 9;</code>
     */
    io.bloombox.schema.identity.ConsumerProfile getConsumerProfile();
    /**
     * <pre>
     * Specifies information related to a cannabis consumer's consumption preferences.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ConsumerProfile consumer_profile = 9;</code>
     */
    io.bloombox.schema.identity.ConsumerProfileOrBuilder getConsumerProfileOrBuilder();
  }
  /**
   * Protobuf type {@code bloombox.schema.services.shop.v1.EnrollMember.Request}
   */
  public  static final class Request extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.shop.v1.EnrollMember.Request)
      RequestOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Request.newBuilder() to construct.
    private Request(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Request() {
      source_ = 0;
      channel_ = "";
      password_ = "";
      dryRun_ = false;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Request(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              io.opencannabis.schema.person.Person.Builder subBuilder = null;
              if (person_ != null) {
                subBuilder = person_.toBuilder();
              }
              person_ = input.readMessage(io.opencannabis.schema.person.Person.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(person_);
                person_ = subBuilder.buildPartial();
              }

              break;
            }
            case 16: {
              int rawValue = input.readEnum();

              source_ = rawValue;
              break;
            }
            case 26: {
              java.lang.String s = input.readStringRequireUtf8();

              channel_ = s;
              break;
            }
            case 34: {
              io.bloombox.schema.identity.ids.UserDoctorRec.Builder subBuilder = null;
              if (doctorRec_ != null) {
                subBuilder = doctorRec_.toBuilder();
              }
              doctorRec_ = input.readMessage(io.bloombox.schema.identity.ids.UserDoctorRec.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(doctorRec_);
                doctorRec_ = subBuilder.buildPartial();
              }

              break;
            }
            case 42: {
              io.bloombox.schema.identity.ID.Builder subBuilder = null;
              if (governmentId_ != null) {
                subBuilder = governmentId_.toBuilder();
              }
              governmentId_ = input.readMessage(io.bloombox.schema.identity.ID.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(governmentId_);
                governmentId_ = subBuilder.buildPartial();
              }

              break;
            }
            case 50: {
              io.bloombox.schema.partner.PartnerLocationKey.Builder subBuilder = null;
              if (location_ != null) {
                subBuilder = location_.toBuilder();
              }
              location_ = input.readMessage(io.bloombox.schema.partner.PartnerLocationKey.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(location_);
                location_ = subBuilder.buildPartial();
              }

              break;
            }
            case 58: {
              java.lang.String s = input.readStringRequireUtf8();

              password_ = s;
              break;
            }
            case 64: {

              dryRun_ = input.readBool();
              break;
            }
            case 74: {
              io.bloombox.schema.identity.ConsumerProfile.Builder subBuilder = null;
              if (consumerProfile_ != null) {
                subBuilder = consumerProfile_.toBuilder();
              }
              consumerProfile_ = input.readMessage(io.bloombox.schema.identity.ConsumerProfile.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(consumerProfile_);
                consumerProfile_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_EnrollMember_Request_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_EnrollMember_Request_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.shop.v1.EnrollMember.Request.class, io.bloombox.schema.services.shop.v1.EnrollMember.Request.Builder.class);
    }

    public static final int PERSON_FIELD_NUMBER = 1;
    private io.opencannabis.schema.person.Person person_;
    /**
     * <pre>
     * Person record we are enrolling as a member.
     * </pre>
     *
     * <code>.opencannabis.person.Person person = 1;</code>
     */
    public boolean hasPerson() {
      return person_ != null;
    }
    /**
     * <pre>
     * Person record we are enrolling as a member.
     * </pre>
     *
     * <code>.opencannabis.person.Person person = 1;</code>
     */
    public io.opencannabis.schema.person.Person getPerson() {
      return person_ == null ? io.opencannabis.schema.person.Person.getDefaultInstance() : person_;
    }
    /**
     * <pre>
     * Person record we are enrolling as a member.
     * </pre>
     *
     * <code>.opencannabis.person.Person person = 1;</code>
     */
    public io.opencannabis.schema.person.PersonOrBuilder getPersonOrBuilder() {
      return getPerson();
    }

    public static final int SOURCE_FIELD_NUMBER = 2;
    private int source_;
    /**
     * <pre>
     * Source for this enrollment.
     * </pre>
     *
     * <code>.bloombox.schema.identity.EnrollmentSource source = 2;</code>
     */
    public int getSourceValue() {
      return source_;
    }
    /**
     * <pre>
     * Source for this enrollment.
     * </pre>
     *
     * <code>.bloombox.schema.identity.EnrollmentSource source = 2;</code>
     */
    public io.bloombox.schema.identity.EnrollmentSource getSource() {
      io.bloombox.schema.identity.EnrollmentSource result = io.bloombox.schema.identity.EnrollmentSource.valueOf(source_);
      return result == null ? io.bloombox.schema.identity.EnrollmentSource.UNRECOGNIZED : result;
    }

    public static final int CHANNEL_FIELD_NUMBER = 3;
    private volatile java.lang.Object channel_;
    /**
     * <pre>
     * Channel that passed us this enrollment.
     * </pre>
     *
     * <code>string channel = 3;</code>
     */
    public java.lang.String getChannel() {
      java.lang.Object ref = channel_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        channel_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Channel that passed us this enrollment.
     * </pre>
     *
     * <code>string channel = 3;</code>
     */
    public com.google.protobuf.ByteString
        getChannelBytes() {
      java.lang.Object ref = channel_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        channel_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DOCTOR_REC_FIELD_NUMBER = 4;
    private io.bloombox.schema.identity.ids.UserDoctorRec doctorRec_;
    /**
     * <pre>
     * Holds information about the user's cannabis recommendation.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 4;</code>
     */
    public boolean hasDoctorRec() {
      return doctorRec_ != null;
    }
    /**
     * <pre>
     * Holds information about the user's cannabis recommendation.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 4;</code>
     */
    public io.bloombox.schema.identity.ids.UserDoctorRec getDoctorRec() {
      return doctorRec_ == null ? io.bloombox.schema.identity.ids.UserDoctorRec.getDefaultInstance() : doctorRec_;
    }
    /**
     * <pre>
     * Holds information about the user's cannabis recommendation.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 4;</code>
     */
    public io.bloombox.schema.identity.ids.UserDoctorRecOrBuilder getDoctorRecOrBuilder() {
      return getDoctorRec();
    }

    public static final int GOVERNMENT_ID_FIELD_NUMBER = 5;
    private io.bloombox.schema.identity.ID governmentId_;
    /**
     * <pre>
     * Holds information about the user's driver's license.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ID government_id = 5;</code>
     */
    public boolean hasGovernmentId() {
      return governmentId_ != null;
    }
    /**
     * <pre>
     * Holds information about the user's driver's license.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ID government_id = 5;</code>
     */
    public io.bloombox.schema.identity.ID getGovernmentId() {
      return governmentId_ == null ? io.bloombox.schema.identity.ID.getDefaultInstance() : governmentId_;
    }
    /**
     * <pre>
     * Holds information about the user's driver's license.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ID government_id = 5;</code>
     */
    public io.bloombox.schema.identity.IDOrBuilder getGovernmentIdOrBuilder() {
      return getGovernmentId();
    }

    public static final int LOCATION_FIELD_NUMBER = 6;
    private io.bloombox.schema.partner.PartnerLocationKey location_;
    /**
     * <pre>
     * Specifies the partner we are enrolling to.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerLocationKey location = 6;</code>
     */
    public boolean hasLocation() {
      return location_ != null;
    }
    /**
     * <pre>
     * Specifies the partner we are enrolling to.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerLocationKey location = 6;</code>
     */
    public io.bloombox.schema.partner.PartnerLocationKey getLocation() {
      return location_ == null ? io.bloombox.schema.partner.PartnerLocationKey.getDefaultInstance() : location_;
    }
    /**
     * <pre>
     * Specifies the partner we are enrolling to.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerLocationKey location = 6;</code>
     */
    public io.bloombox.schema.partner.PartnerLocationKeyOrBuilder getLocationOrBuilder() {
      return getLocation();
    }

    public static final int PASSWORD_FIELD_NUMBER = 7;
    private volatile java.lang.Object password_;
    /**
     * <pre>
     * Base64-encoded password. This is for transmission ONLY - do NOT store this value without first either encrypting
     * it strongly, or perfoming a subsequent salt-and-SHA routine.
     * </pre>
     *
     * <code>string password = 7;</code>
     */
    public java.lang.String getPassword() {
      java.lang.Object ref = password_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        password_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Base64-encoded password. This is for transmission ONLY - do NOT store this value without first either encrypting
     * it strongly, or perfoming a subsequent salt-and-SHA routine.
     * </pre>
     *
     * <code>string password = 7;</code>
     */
    public com.google.protobuf.ByteString
        getPasswordBytes() {
      java.lang.Object ref = password_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        password_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DRY_RUN_FIELD_NUMBER = 8;
    private boolean dryRun_;
    /**
     * <pre>
     * Flag to indicate that this is a dry run, and we should not actually write the user to any external
     * or persistence systems.
     * </pre>
     *
     * <code>bool dry_run = 8;</code>
     */
    public boolean getDryRun() {
      return dryRun_;
    }

    public static final int CONSUMER_PROFILE_FIELD_NUMBER = 9;
    private io.bloombox.schema.identity.ConsumerProfile consumerProfile_;
    /**
     * <pre>
     * Specifies information related to a cannabis consumer's consumption preferences.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ConsumerProfile consumer_profile = 9;</code>
     */
    public boolean hasConsumerProfile() {
      return consumerProfile_ != null;
    }
    /**
     * <pre>
     * Specifies information related to a cannabis consumer's consumption preferences.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ConsumerProfile consumer_profile = 9;</code>
     */
    public io.bloombox.schema.identity.ConsumerProfile getConsumerProfile() {
      return consumerProfile_ == null ? io.bloombox.schema.identity.ConsumerProfile.getDefaultInstance() : consumerProfile_;
    }
    /**
     * <pre>
     * Specifies information related to a cannabis consumer's consumption preferences.
     * </pre>
     *
     * <code>.bloombox.schema.identity.ConsumerProfile consumer_profile = 9;</code>
     */
    public io.bloombox.schema.identity.ConsumerProfileOrBuilder getConsumerProfileOrBuilder() {
      return getConsumerProfile();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (person_ != null) {
        output.writeMessage(1, getPerson());
      }
      if (source_ != io.bloombox.schema.identity.EnrollmentSource.UNSPECIFIED.getNumber()) {
        output.writeEnum(2, source_);
      }
      if (!getChannelBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, channel_);
      }
      if (doctorRec_ != null) {
        output.writeMessage(4, getDoctorRec());
      }
      if (governmentId_ != null) {
        output.writeMessage(5, getGovernmentId());
      }
      if (location_ != null) {
        output.writeMessage(6, getLocation());
      }
      if (!getPasswordBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 7, password_);
      }
      if (dryRun_ != false) {
        output.writeBool(8, dryRun_);
      }
      if (consumerProfile_ != null) {
        output.writeMessage(9, getConsumerProfile());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (person_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getPerson());
      }
      if (source_ != io.bloombox.schema.identity.EnrollmentSource.UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, source_);
      }
      if (!getChannelBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, channel_);
      }
      if (doctorRec_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, getDoctorRec());
      }
      if (governmentId_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, getGovernmentId());
      }
      if (location_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(6, getLocation());
      }
      if (!getPasswordBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, password_);
      }
      if (dryRun_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(8, dryRun_);
      }
      if (consumerProfile_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(9, getConsumerProfile());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.shop.v1.EnrollMember.Request)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.shop.v1.EnrollMember.Request other = (io.bloombox.schema.services.shop.v1.EnrollMember.Request) obj;

      boolean result = true;
      result = result && (hasPerson() == other.hasPerson());
      if (hasPerson()) {
        result = result && getPerson()
            .equals(other.getPerson());
      }
      result = result && source_ == other.source_;
      result = result && getChannel()
          .equals(other.getChannel());
      result = result && (hasDoctorRec() == other.hasDoctorRec());
      if (hasDoctorRec()) {
        result = result && getDoctorRec()
            .equals(other.getDoctorRec());
      }
      result = result && (hasGovernmentId() == other.hasGovernmentId());
      if (hasGovernmentId()) {
        result = result && getGovernmentId()
            .equals(other.getGovernmentId());
      }
      result = result && (hasLocation() == other.hasLocation());
      if (hasLocation()) {
        result = result && getLocation()
            .equals(other.getLocation());
      }
      result = result && getPassword()
          .equals(other.getPassword());
      result = result && (getDryRun()
          == other.getDryRun());
      result = result && (hasConsumerProfile() == other.hasConsumerProfile());
      if (hasConsumerProfile()) {
        result = result && getConsumerProfile()
            .equals(other.getConsumerProfile());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasPerson()) {
        hash = (37 * hash) + PERSON_FIELD_NUMBER;
        hash = (53 * hash) + getPerson().hashCode();
      }
      hash = (37 * hash) + SOURCE_FIELD_NUMBER;
      hash = (53 * hash) + source_;
      hash = (37 * hash) + CHANNEL_FIELD_NUMBER;
      hash = (53 * hash) + getChannel().hashCode();
      if (hasDoctorRec()) {
        hash = (37 * hash) + DOCTOR_REC_FIELD_NUMBER;
        hash = (53 * hash) + getDoctorRec().hashCode();
      }
      if (hasGovernmentId()) {
        hash = (37 * hash) + GOVERNMENT_ID_FIELD_NUMBER;
        hash = (53 * hash) + getGovernmentId().hashCode();
      }
      if (hasLocation()) {
        hash = (37 * hash) + LOCATION_FIELD_NUMBER;
        hash = (53 * hash) + getLocation().hashCode();
      }
      hash = (37 * hash) + PASSWORD_FIELD_NUMBER;
      hash = (53 * hash) + getPassword().hashCode();
      hash = (37 * hash) + DRY_RUN_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getDryRun());
      if (hasConsumerProfile()) {
        hash = (37 * hash) + CONSUMER_PROFILE_FIELD_NUMBER;
        hash = (53 * hash) + getConsumerProfile().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.shop.v1.EnrollMember.Request parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.shop.v1.EnrollMember.Request parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.EnrollMember.Request parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.shop.v1.EnrollMember.Request parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.EnrollMember.Request parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.shop.v1.EnrollMember.Request parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.EnrollMember.Request parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.shop.v1.EnrollMember.Request parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.EnrollMember.Request parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.shop.v1.EnrollMember.Request parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.EnrollMember.Request parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.shop.v1.EnrollMember.Request parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.shop.v1.EnrollMember.Request prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code bloombox.schema.services.shop.v1.EnrollMember.Request}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.shop.v1.EnrollMember.Request)
        io.bloombox.schema.services.shop.v1.EnrollMember.RequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_EnrollMember_Request_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_EnrollMember_Request_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.shop.v1.EnrollMember.Request.class, io.bloombox.schema.services.shop.v1.EnrollMember.Request.Builder.class);
      }

      // Construct using io.bloombox.schema.services.shop.v1.EnrollMember.Request.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        if (personBuilder_ == null) {
          person_ = null;
        } else {
          person_ = null;
          personBuilder_ = null;
        }
        source_ = 0;

        channel_ = "";

        if (doctorRecBuilder_ == null) {
          doctorRec_ = null;
        } else {
          doctorRec_ = null;
          doctorRecBuilder_ = null;
        }
        if (governmentIdBuilder_ == null) {
          governmentId_ = null;
        } else {
          governmentId_ = null;
          governmentIdBuilder_ = null;
        }
        if (locationBuilder_ == null) {
          location_ = null;
        } else {
          location_ = null;
          locationBuilder_ = null;
        }
        password_ = "";

        dryRun_ = false;

        if (consumerProfileBuilder_ == null) {
          consumerProfile_ = null;
        } else {
          consumerProfile_ = null;
          consumerProfileBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_EnrollMember_Request_descriptor;
      }

      public io.bloombox.schema.services.shop.v1.EnrollMember.Request getDefaultInstanceForType() {
        return io.bloombox.schema.services.shop.v1.EnrollMember.Request.getDefaultInstance();
      }

      public io.bloombox.schema.services.shop.v1.EnrollMember.Request build() {
        io.bloombox.schema.services.shop.v1.EnrollMember.Request result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.shop.v1.EnrollMember.Request buildPartial() {
        io.bloombox.schema.services.shop.v1.EnrollMember.Request result = new io.bloombox.schema.services.shop.v1.EnrollMember.Request(this);
        if (personBuilder_ == null) {
          result.person_ = person_;
        } else {
          result.person_ = personBuilder_.build();
        }
        result.source_ = source_;
        result.channel_ = channel_;
        if (doctorRecBuilder_ == null) {
          result.doctorRec_ = doctorRec_;
        } else {
          result.doctorRec_ = doctorRecBuilder_.build();
        }
        if (governmentIdBuilder_ == null) {
          result.governmentId_ = governmentId_;
        } else {
          result.governmentId_ = governmentIdBuilder_.build();
        }
        if (locationBuilder_ == null) {
          result.location_ = location_;
        } else {
          result.location_ = locationBuilder_.build();
        }
        result.password_ = password_;
        result.dryRun_ = dryRun_;
        if (consumerProfileBuilder_ == null) {
          result.consumerProfile_ = consumerProfile_;
        } else {
          result.consumerProfile_ = consumerProfileBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.shop.v1.EnrollMember.Request) {
          return mergeFrom((io.bloombox.schema.services.shop.v1.EnrollMember.Request)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.shop.v1.EnrollMember.Request other) {
        if (other == io.bloombox.schema.services.shop.v1.EnrollMember.Request.getDefaultInstance()) return this;
        if (other.hasPerson()) {
          mergePerson(other.getPerson());
        }
        if (other.source_ != 0) {
          setSourceValue(other.getSourceValue());
        }
        if (!other.getChannel().isEmpty()) {
          channel_ = other.channel_;
          onChanged();
        }
        if (other.hasDoctorRec()) {
          mergeDoctorRec(other.getDoctorRec());
        }
        if (other.hasGovernmentId()) {
          mergeGovernmentId(other.getGovernmentId());
        }
        if (other.hasLocation()) {
          mergeLocation(other.getLocation());
        }
        if (!other.getPassword().isEmpty()) {
          password_ = other.password_;
          onChanged();
        }
        if (other.getDryRun() != false) {
          setDryRun(other.getDryRun());
        }
        if (other.hasConsumerProfile()) {
          mergeConsumerProfile(other.getConsumerProfile());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.shop.v1.EnrollMember.Request parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.shop.v1.EnrollMember.Request) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private io.opencannabis.schema.person.Person person_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.person.Person, io.opencannabis.schema.person.Person.Builder, io.opencannabis.schema.person.PersonOrBuilder> personBuilder_;
      /**
       * <pre>
       * Person record we are enrolling as a member.
       * </pre>
       *
       * <code>.opencannabis.person.Person person = 1;</code>
       */
      public boolean hasPerson() {
        return personBuilder_ != null || person_ != null;
      }
      /**
       * <pre>
       * Person record we are enrolling as a member.
       * </pre>
       *
       * <code>.opencannabis.person.Person person = 1;</code>
       */
      public io.opencannabis.schema.person.Person getPerson() {
        if (personBuilder_ == null) {
          return person_ == null ? io.opencannabis.schema.person.Person.getDefaultInstance() : person_;
        } else {
          return personBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Person record we are enrolling as a member.
       * </pre>
       *
       * <code>.opencannabis.person.Person person = 1;</code>
       */
      public Builder setPerson(io.opencannabis.schema.person.Person value) {
        if (personBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          person_ = value;
          onChanged();
        } else {
          personBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Person record we are enrolling as a member.
       * </pre>
       *
       * <code>.opencannabis.person.Person person = 1;</code>
       */
      public Builder setPerson(
          io.opencannabis.schema.person.Person.Builder builderForValue) {
        if (personBuilder_ == null) {
          person_ = builderForValue.build();
          onChanged();
        } else {
          personBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Person record we are enrolling as a member.
       * </pre>
       *
       * <code>.opencannabis.person.Person person = 1;</code>
       */
      public Builder mergePerson(io.opencannabis.schema.person.Person value) {
        if (personBuilder_ == null) {
          if (person_ != null) {
            person_ =
              io.opencannabis.schema.person.Person.newBuilder(person_).mergeFrom(value).buildPartial();
          } else {
            person_ = value;
          }
          onChanged();
        } else {
          personBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Person record we are enrolling as a member.
       * </pre>
       *
       * <code>.opencannabis.person.Person person = 1;</code>
       */
      public Builder clearPerson() {
        if (personBuilder_ == null) {
          person_ = null;
          onChanged();
        } else {
          person_ = null;
          personBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Person record we are enrolling as a member.
       * </pre>
       *
       * <code>.opencannabis.person.Person person = 1;</code>
       */
      public io.opencannabis.schema.person.Person.Builder getPersonBuilder() {
        
        onChanged();
        return getPersonFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Person record we are enrolling as a member.
       * </pre>
       *
       * <code>.opencannabis.person.Person person = 1;</code>
       */
      public io.opencannabis.schema.person.PersonOrBuilder getPersonOrBuilder() {
        if (personBuilder_ != null) {
          return personBuilder_.getMessageOrBuilder();
        } else {
          return person_ == null ?
              io.opencannabis.schema.person.Person.getDefaultInstance() : person_;
        }
      }
      /**
       * <pre>
       * Person record we are enrolling as a member.
       * </pre>
       *
       * <code>.opencannabis.person.Person person = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.person.Person, io.opencannabis.schema.person.Person.Builder, io.opencannabis.schema.person.PersonOrBuilder> 
          getPersonFieldBuilder() {
        if (personBuilder_ == null) {
          personBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.person.Person, io.opencannabis.schema.person.Person.Builder, io.opencannabis.schema.person.PersonOrBuilder>(
                  getPerson(),
                  getParentForChildren(),
                  isClean());
          person_ = null;
        }
        return personBuilder_;
      }

      private int source_ = 0;
      /**
       * <pre>
       * Source for this enrollment.
       * </pre>
       *
       * <code>.bloombox.schema.identity.EnrollmentSource source = 2;</code>
       */
      public int getSourceValue() {
        return source_;
      }
      /**
       * <pre>
       * Source for this enrollment.
       * </pre>
       *
       * <code>.bloombox.schema.identity.EnrollmentSource source = 2;</code>
       */
      public Builder setSourceValue(int value) {
        source_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Source for this enrollment.
       * </pre>
       *
       * <code>.bloombox.schema.identity.EnrollmentSource source = 2;</code>
       */
      public io.bloombox.schema.identity.EnrollmentSource getSource() {
        io.bloombox.schema.identity.EnrollmentSource result = io.bloombox.schema.identity.EnrollmentSource.valueOf(source_);
        return result == null ? io.bloombox.schema.identity.EnrollmentSource.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Source for this enrollment.
       * </pre>
       *
       * <code>.bloombox.schema.identity.EnrollmentSource source = 2;</code>
       */
      public Builder setSource(io.bloombox.schema.identity.EnrollmentSource value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        source_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Source for this enrollment.
       * </pre>
       *
       * <code>.bloombox.schema.identity.EnrollmentSource source = 2;</code>
       */
      public Builder clearSource() {
        
        source_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object channel_ = "";
      /**
       * <pre>
       * Channel that passed us this enrollment.
       * </pre>
       *
       * <code>string channel = 3;</code>
       */
      public java.lang.String getChannel() {
        java.lang.Object ref = channel_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          channel_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Channel that passed us this enrollment.
       * </pre>
       *
       * <code>string channel = 3;</code>
       */
      public com.google.protobuf.ByteString
          getChannelBytes() {
        java.lang.Object ref = channel_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          channel_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Channel that passed us this enrollment.
       * </pre>
       *
       * <code>string channel = 3;</code>
       */
      public Builder setChannel(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        channel_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Channel that passed us this enrollment.
       * </pre>
       *
       * <code>string channel = 3;</code>
       */
      public Builder clearChannel() {
        
        channel_ = getDefaultInstance().getChannel();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Channel that passed us this enrollment.
       * </pre>
       *
       * <code>string channel = 3;</code>
       */
      public Builder setChannelBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        channel_ = value;
        onChanged();
        return this;
      }

      private io.bloombox.schema.identity.ids.UserDoctorRec doctorRec_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.identity.ids.UserDoctorRec, io.bloombox.schema.identity.ids.UserDoctorRec.Builder, io.bloombox.schema.identity.ids.UserDoctorRecOrBuilder> doctorRecBuilder_;
      /**
       * <pre>
       * Holds information about the user's cannabis recommendation.
       * </pre>
       *
       * <code>.bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 4;</code>
       */
      public boolean hasDoctorRec() {
        return doctorRecBuilder_ != null || doctorRec_ != null;
      }
      /**
       * <pre>
       * Holds information about the user's cannabis recommendation.
       * </pre>
       *
       * <code>.bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 4;</code>
       */
      public io.bloombox.schema.identity.ids.UserDoctorRec getDoctorRec() {
        if (doctorRecBuilder_ == null) {
          return doctorRec_ == null ? io.bloombox.schema.identity.ids.UserDoctorRec.getDefaultInstance() : doctorRec_;
        } else {
          return doctorRecBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Holds information about the user's cannabis recommendation.
       * </pre>
       *
       * <code>.bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 4;</code>
       */
      public Builder setDoctorRec(io.bloombox.schema.identity.ids.UserDoctorRec value) {
        if (doctorRecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          doctorRec_ = value;
          onChanged();
        } else {
          doctorRecBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Holds information about the user's cannabis recommendation.
       * </pre>
       *
       * <code>.bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 4;</code>
       */
      public Builder setDoctorRec(
          io.bloombox.schema.identity.ids.UserDoctorRec.Builder builderForValue) {
        if (doctorRecBuilder_ == null) {
          doctorRec_ = builderForValue.build();
          onChanged();
        } else {
          doctorRecBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Holds information about the user's cannabis recommendation.
       * </pre>
       *
       * <code>.bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 4;</code>
       */
      public Builder mergeDoctorRec(io.bloombox.schema.identity.ids.UserDoctorRec value) {
        if (doctorRecBuilder_ == null) {
          if (doctorRec_ != null) {
            doctorRec_ =
              io.bloombox.schema.identity.ids.UserDoctorRec.newBuilder(doctorRec_).mergeFrom(value).buildPartial();
          } else {
            doctorRec_ = value;
          }
          onChanged();
        } else {
          doctorRecBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Holds information about the user's cannabis recommendation.
       * </pre>
       *
       * <code>.bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 4;</code>
       */
      public Builder clearDoctorRec() {
        if (doctorRecBuilder_ == null) {
          doctorRec_ = null;
          onChanged();
        } else {
          doctorRec_ = null;
          doctorRecBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Holds information about the user's cannabis recommendation.
       * </pre>
       *
       * <code>.bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 4;</code>
       */
      public io.bloombox.schema.identity.ids.UserDoctorRec.Builder getDoctorRecBuilder() {
        
        onChanged();
        return getDoctorRecFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Holds information about the user's cannabis recommendation.
       * </pre>
       *
       * <code>.bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 4;</code>
       */
      public io.bloombox.schema.identity.ids.UserDoctorRecOrBuilder getDoctorRecOrBuilder() {
        if (doctorRecBuilder_ != null) {
          return doctorRecBuilder_.getMessageOrBuilder();
        } else {
          return doctorRec_ == null ?
              io.bloombox.schema.identity.ids.UserDoctorRec.getDefaultInstance() : doctorRec_;
        }
      }
      /**
       * <pre>
       * Holds information about the user's cannabis recommendation.
       * </pre>
       *
       * <code>.bloombox.schema.identity.ids.UserDoctorRec doctor_rec = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.identity.ids.UserDoctorRec, io.bloombox.schema.identity.ids.UserDoctorRec.Builder, io.bloombox.schema.identity.ids.UserDoctorRecOrBuilder> 
          getDoctorRecFieldBuilder() {
        if (doctorRecBuilder_ == null) {
          doctorRecBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.identity.ids.UserDoctorRec, io.bloombox.schema.identity.ids.UserDoctorRec.Builder, io.bloombox.schema.identity.ids.UserDoctorRecOrBuilder>(
                  getDoctorRec(),
                  getParentForChildren(),
                  isClean());
          doctorRec_ = null;
        }
        return doctorRecBuilder_;
      }

      private io.bloombox.schema.identity.ID governmentId_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.identity.ID, io.bloombox.schema.identity.ID.Builder, io.bloombox.schema.identity.IDOrBuilder> governmentIdBuilder_;
      /**
       * <pre>
       * Holds information about the user's driver's license.
       * </pre>
       *
       * <code>.bloombox.schema.identity.ID government_id = 5;</code>
       */
      public boolean hasGovernmentId() {
        return governmentIdBuilder_ != null || governmentId_ != null;
      }
      /**
       * <pre>
       * Holds information about the user's driver's license.
       * </pre>
       *
       * <code>.bloombox.schema.identity.ID government_id = 5;</code>
       */
      public io.bloombox.schema.identity.ID getGovernmentId() {
        if (governmentIdBuilder_ == null) {
          return governmentId_ == null ? io.bloombox.schema.identity.ID.getDefaultInstance() : governmentId_;
        } else {
          return governmentIdBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Holds information about the user's driver's license.
       * </pre>
       *
       * <code>.bloombox.schema.identity.ID government_id = 5;</code>
       */
      public Builder setGovernmentId(io.bloombox.schema.identity.ID value) {
        if (governmentIdBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          governmentId_ = value;
          onChanged();
        } else {
          governmentIdBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Holds information about the user's driver's license.
       * </pre>
       *
       * <code>.bloombox.schema.identity.ID government_id = 5;</code>
       */
      public Builder setGovernmentId(
          io.bloombox.schema.identity.ID.Builder builderForValue) {
        if (governmentIdBuilder_ == null) {
          governmentId_ = builderForValue.build();
          onChanged();
        } else {
          governmentIdBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Holds information about the user's driver's license.
       * </pre>
       *
       * <code>.bloombox.schema.identity.ID government_id = 5;</code>
       */
      public Builder mergeGovernmentId(io.bloombox.schema.identity.ID value) {
        if (governmentIdBuilder_ == null) {
          if (governmentId_ != null) {
            governmentId_ =
              io.bloombox.schema.identity.ID.newBuilder(governmentId_).mergeFrom(value).buildPartial();
          } else {
            governmentId_ = value;
          }
          onChanged();
        } else {
          governmentIdBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Holds information about the user's driver's license.
       * </pre>
       *
       * <code>.bloombox.schema.identity.ID government_id = 5;</code>
       */
      public Builder clearGovernmentId() {
        if (governmentIdBuilder_ == null) {
          governmentId_ = null;
          onChanged();
        } else {
          governmentId_ = null;
          governmentIdBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Holds information about the user's driver's license.
       * </pre>
       *
       * <code>.bloombox.schema.identity.ID government_id = 5;</code>
       */
      public io.bloombox.schema.identity.ID.Builder getGovernmentIdBuilder() {
        
        onChanged();
        return getGovernmentIdFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Holds information about the user's driver's license.
       * </pre>
       *
       * <code>.bloombox.schema.identity.ID government_id = 5;</code>
       */
      public io.bloombox.schema.identity.IDOrBuilder getGovernmentIdOrBuilder() {
        if (governmentIdBuilder_ != null) {
          return governmentIdBuilder_.getMessageOrBuilder();
        } else {
          return governmentId_ == null ?
              io.bloombox.schema.identity.ID.getDefaultInstance() : governmentId_;
        }
      }
      /**
       * <pre>
       * Holds information about the user's driver's license.
       * </pre>
       *
       * <code>.bloombox.schema.identity.ID government_id = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.identity.ID, io.bloombox.schema.identity.ID.Builder, io.bloombox.schema.identity.IDOrBuilder> 
          getGovernmentIdFieldBuilder() {
        if (governmentIdBuilder_ == null) {
          governmentIdBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.identity.ID, io.bloombox.schema.identity.ID.Builder, io.bloombox.schema.identity.IDOrBuilder>(
                  getGovernmentId(),
                  getParentForChildren(),
                  isClean());
          governmentId_ = null;
        }
        return governmentIdBuilder_;
      }

      private io.bloombox.schema.partner.PartnerLocationKey location_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.partner.PartnerLocationKey, io.bloombox.schema.partner.PartnerLocationKey.Builder, io.bloombox.schema.partner.PartnerLocationKeyOrBuilder> locationBuilder_;
      /**
       * <pre>
       * Specifies the partner we are enrolling to.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocationKey location = 6;</code>
       */
      public boolean hasLocation() {
        return locationBuilder_ != null || location_ != null;
      }
      /**
       * <pre>
       * Specifies the partner we are enrolling to.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocationKey location = 6;</code>
       */
      public io.bloombox.schema.partner.PartnerLocationKey getLocation() {
        if (locationBuilder_ == null) {
          return location_ == null ? io.bloombox.schema.partner.PartnerLocationKey.getDefaultInstance() : location_;
        } else {
          return locationBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Specifies the partner we are enrolling to.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocationKey location = 6;</code>
       */
      public Builder setLocation(io.bloombox.schema.partner.PartnerLocationKey value) {
        if (locationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          location_ = value;
          onChanged();
        } else {
          locationBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies the partner we are enrolling to.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocationKey location = 6;</code>
       */
      public Builder setLocation(
          io.bloombox.schema.partner.PartnerLocationKey.Builder builderForValue) {
        if (locationBuilder_ == null) {
          location_ = builderForValue.build();
          onChanged();
        } else {
          locationBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Specifies the partner we are enrolling to.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocationKey location = 6;</code>
       */
      public Builder mergeLocation(io.bloombox.schema.partner.PartnerLocationKey value) {
        if (locationBuilder_ == null) {
          if (location_ != null) {
            location_ =
              io.bloombox.schema.partner.PartnerLocationKey.newBuilder(location_).mergeFrom(value).buildPartial();
          } else {
            location_ = value;
          }
          onChanged();
        } else {
          locationBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies the partner we are enrolling to.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocationKey location = 6;</code>
       */
      public Builder clearLocation() {
        if (locationBuilder_ == null) {
          location_ = null;
          onChanged();
        } else {
          location_ = null;
          locationBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Specifies the partner we are enrolling to.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocationKey location = 6;</code>
       */
      public io.bloombox.schema.partner.PartnerLocationKey.Builder getLocationBuilder() {
        
        onChanged();
        return getLocationFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Specifies the partner we are enrolling to.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocationKey location = 6;</code>
       */
      public io.bloombox.schema.partner.PartnerLocationKeyOrBuilder getLocationOrBuilder() {
        if (locationBuilder_ != null) {
          return locationBuilder_.getMessageOrBuilder();
        } else {
          return location_ == null ?
              io.bloombox.schema.partner.PartnerLocationKey.getDefaultInstance() : location_;
        }
      }
      /**
       * <pre>
       * Specifies the partner we are enrolling to.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocationKey location = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.partner.PartnerLocationKey, io.bloombox.schema.partner.PartnerLocationKey.Builder, io.bloombox.schema.partner.PartnerLocationKeyOrBuilder> 
          getLocationFieldBuilder() {
        if (locationBuilder_ == null) {
          locationBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.partner.PartnerLocationKey, io.bloombox.schema.partner.PartnerLocationKey.Builder, io.bloombox.schema.partner.PartnerLocationKeyOrBuilder>(
                  getLocation(),
                  getParentForChildren(),
                  isClean());
          location_ = null;
        }
        return locationBuilder_;
      }

      private java.lang.Object password_ = "";
      /**
       * <pre>
       * Base64-encoded password. This is for transmission ONLY - do NOT store this value without first either encrypting
       * it strongly, or perfoming a subsequent salt-and-SHA routine.
       * </pre>
       *
       * <code>string password = 7;</code>
       */
      public java.lang.String getPassword() {
        java.lang.Object ref = password_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          password_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Base64-encoded password. This is for transmission ONLY - do NOT store this value without first either encrypting
       * it strongly, or perfoming a subsequent salt-and-SHA routine.
       * </pre>
       *
       * <code>string password = 7;</code>
       */
      public com.google.protobuf.ByteString
          getPasswordBytes() {
        java.lang.Object ref = password_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          password_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Base64-encoded password. This is for transmission ONLY - do NOT store this value without first either encrypting
       * it strongly, or perfoming a subsequent salt-and-SHA routine.
       * </pre>
       *
       * <code>string password = 7;</code>
       */
      public Builder setPassword(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        password_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Base64-encoded password. This is for transmission ONLY - do NOT store this value without first either encrypting
       * it strongly, or perfoming a subsequent salt-and-SHA routine.
       * </pre>
       *
       * <code>string password = 7;</code>
       */
      public Builder clearPassword() {
        
        password_ = getDefaultInstance().getPassword();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Base64-encoded password. This is for transmission ONLY - do NOT store this value without first either encrypting
       * it strongly, or perfoming a subsequent salt-and-SHA routine.
       * </pre>
       *
       * <code>string password = 7;</code>
       */
      public Builder setPasswordBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        password_ = value;
        onChanged();
        return this;
      }

      private boolean dryRun_ ;
      /**
       * <pre>
       * Flag to indicate that this is a dry run, and we should not actually write the user to any external
       * or persistence systems.
       * </pre>
       *
       * <code>bool dry_run = 8;</code>
       */
      public boolean getDryRun() {
        return dryRun_;
      }
      /**
       * <pre>
       * Flag to indicate that this is a dry run, and we should not actually write the user to any external
       * or persistence systems.
       * </pre>
       *
       * <code>bool dry_run = 8;</code>
       */
      public Builder setDryRun(boolean value) {
        
        dryRun_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Flag to indicate that this is a dry run, and we should not actually write the user to any external
       * or persistence systems.
       * </pre>
       *
       * <code>bool dry_run = 8;</code>
       */
      public Builder clearDryRun() {
        
        dryRun_ = false;
        onChanged();
        return this;
      }

      private io.bloombox.schema.identity.ConsumerProfile consumerProfile_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.identity.ConsumerProfile, io.bloombox.schema.identity.ConsumerProfile.Builder, io.bloombox.schema.identity.ConsumerProfileOrBuilder> consumerProfileBuilder_;
      /**
       * <pre>
       * Specifies information related to a cannabis consumer's consumption preferences.
       * </pre>
       *
       * <code>.bloombox.schema.identity.ConsumerProfile consumer_profile = 9;</code>
       */
      public boolean hasConsumerProfile() {
        return consumerProfileBuilder_ != null || consumerProfile_ != null;
      }
      /**
       * <pre>
       * Specifies information related to a cannabis consumer's consumption preferences.
       * </pre>
       *
       * <code>.bloombox.schema.identity.ConsumerProfile consumer_profile = 9;</code>
       */
      public io.bloombox.schema.identity.ConsumerProfile getConsumerProfile() {
        if (consumerProfileBuilder_ == null) {
          return consumerProfile_ == null ? io.bloombox.schema.identity.ConsumerProfile.getDefaultInstance() : consumerProfile_;
        } else {
          return consumerProfileBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Specifies information related to a cannabis consumer's consumption preferences.
       * </pre>
       *
       * <code>.bloombox.schema.identity.ConsumerProfile consumer_profile = 9;</code>
       */
      public Builder setConsumerProfile(io.bloombox.schema.identity.ConsumerProfile value) {
        if (consumerProfileBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          consumerProfile_ = value;
          onChanged();
        } else {
          consumerProfileBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies information related to a cannabis consumer's consumption preferences.
       * </pre>
       *
       * <code>.bloombox.schema.identity.ConsumerProfile consumer_profile = 9;</code>
       */
      public Builder setConsumerProfile(
          io.bloombox.schema.identity.ConsumerProfile.Builder builderForValue) {
        if (consumerProfileBuilder_ == null) {
          consumerProfile_ = builderForValue.build();
          onChanged();
        } else {
          consumerProfileBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Specifies information related to a cannabis consumer's consumption preferences.
       * </pre>
       *
       * <code>.bloombox.schema.identity.ConsumerProfile consumer_profile = 9;</code>
       */
      public Builder mergeConsumerProfile(io.bloombox.schema.identity.ConsumerProfile value) {
        if (consumerProfileBuilder_ == null) {
          if (consumerProfile_ != null) {
            consumerProfile_ =
              io.bloombox.schema.identity.ConsumerProfile.newBuilder(consumerProfile_).mergeFrom(value).buildPartial();
          } else {
            consumerProfile_ = value;
          }
          onChanged();
        } else {
          consumerProfileBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies information related to a cannabis consumer's consumption preferences.
       * </pre>
       *
       * <code>.bloombox.schema.identity.ConsumerProfile consumer_profile = 9;</code>
       */
      public Builder clearConsumerProfile() {
        if (consumerProfileBuilder_ == null) {
          consumerProfile_ = null;
          onChanged();
        } else {
          consumerProfile_ = null;
          consumerProfileBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Specifies information related to a cannabis consumer's consumption preferences.
       * </pre>
       *
       * <code>.bloombox.schema.identity.ConsumerProfile consumer_profile = 9;</code>
       */
      public io.bloombox.schema.identity.ConsumerProfile.Builder getConsumerProfileBuilder() {
        
        onChanged();
        return getConsumerProfileFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Specifies information related to a cannabis consumer's consumption preferences.
       * </pre>
       *
       * <code>.bloombox.schema.identity.ConsumerProfile consumer_profile = 9;</code>
       */
      public io.bloombox.schema.identity.ConsumerProfileOrBuilder getConsumerProfileOrBuilder() {
        if (consumerProfileBuilder_ != null) {
          return consumerProfileBuilder_.getMessageOrBuilder();
        } else {
          return consumerProfile_ == null ?
              io.bloombox.schema.identity.ConsumerProfile.getDefaultInstance() : consumerProfile_;
        }
      }
      /**
       * <pre>
       * Specifies information related to a cannabis consumer's consumption preferences.
       * </pre>
       *
       * <code>.bloombox.schema.identity.ConsumerProfile consumer_profile = 9;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.identity.ConsumerProfile, io.bloombox.schema.identity.ConsumerProfile.Builder, io.bloombox.schema.identity.ConsumerProfileOrBuilder> 
          getConsumerProfileFieldBuilder() {
        if (consumerProfileBuilder_ == null) {
          consumerProfileBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.identity.ConsumerProfile, io.bloombox.schema.identity.ConsumerProfile.Builder, io.bloombox.schema.identity.ConsumerProfileOrBuilder>(
                  getConsumerProfile(),
                  getParentForChildren(),
                  isClean());
          consumerProfile_ = null;
        }
        return consumerProfileBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.shop.v1.EnrollMember.Request)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.shop.v1.EnrollMember.Request)
    private static final io.bloombox.schema.services.shop.v1.EnrollMember.Request DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.shop.v1.EnrollMember.Request();
    }

    public static io.bloombox.schema.services.shop.v1.EnrollMember.Request getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Request>
        PARSER = new com.google.protobuf.AbstractParser<Request>() {
      public Request parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Request(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Request> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Request> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.shop.v1.EnrollMember.Request getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ResponseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.shop.v1.EnrollMember.Response)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Resulting ID from the new enrollment.
     * </pre>
     *
     * <code>string id = 1;</code>
     */
    java.lang.String getId();
    /**
     * <pre>
     * Resulting ID from the new enrollment.
     * </pre>
     *
     * <code>string id = 1;</code>
     */
    com.google.protobuf.ByteString
        getIdBytes();

    /**
     * <pre>
     * Foreign ID, i.e. local identifier assigned to a new user.
     * </pre>
     *
     * <code>string foreign_id = 2;</code>
     */
    java.lang.String getForeignId();
    /**
     * <pre>
     * Foreign ID, i.e. local identifier assigned to a new user.
     * </pre>
     *
     * <code>string foreign_id = 2;</code>
     */
    com.google.protobuf.ByteString
        getForeignIdBytes();

    /**
     * <pre>
     * Error that prevented a successful response.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.EnrollmentError error = 3;</code>
     */
    int getErrorValue();
    /**
     * <pre>
     * Error that prevented a successful response.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.EnrollmentError error = 3;</code>
     */
    io.bloombox.schema.services.shop.v1.EnrollmentError getError();

    public io.bloombox.schema.services.shop.v1.EnrollMember.Response.ResultCase getResultCase();
  }
  /**
   * Protobuf type {@code bloombox.schema.services.shop.v1.EnrollMember.Response}
   */
  public  static final class Response extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.shop.v1.EnrollMember.Response)
      ResponseOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Response.newBuilder() to construct.
    private Response(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Response() {
      id_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Response(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              id_ = s;
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();
              resultCase_ = 2;
              result_ = s;
              break;
            }
            case 24: {
              int rawValue = input.readEnum();
              resultCase_ = 3;
              result_ = rawValue;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_EnrollMember_Response_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_EnrollMember_Response_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.shop.v1.EnrollMember.Response.class, io.bloombox.schema.services.shop.v1.EnrollMember.Response.Builder.class);
    }

    private int resultCase_ = 0;
    private java.lang.Object result_;
    public enum ResultCase
        implements com.google.protobuf.Internal.EnumLite {
      FOREIGN_ID(2),
      ERROR(3),
      RESULT_NOT_SET(0);
      private final int value;
      private ResultCase(int value) {
        this.value = value;
      }
      /**
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ResultCase valueOf(int value) {
        return forNumber(value);
      }

      public static ResultCase forNumber(int value) {
        switch (value) {
          case 2: return FOREIGN_ID;
          case 3: return ERROR;
          case 0: return RESULT_NOT_SET;
          default: return null;
        }
      }
      public int getNumber() {
        return this.value;
      }
    };

    public ResultCase
    getResultCase() {
      return ResultCase.forNumber(
          resultCase_);
    }

    public static final int ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object id_;
    /**
     * <pre>
     * Resulting ID from the new enrollment.
     * </pre>
     *
     * <code>string id = 1;</code>
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Resulting ID from the new enrollment.
     * </pre>
     *
     * <code>string id = 1;</code>
     */
    public com.google.protobuf.ByteString
        getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FOREIGN_ID_FIELD_NUMBER = 2;
    /**
     * <pre>
     * Foreign ID, i.e. local identifier assigned to a new user.
     * </pre>
     *
     * <code>string foreign_id = 2;</code>
     */
    public java.lang.String getForeignId() {
      java.lang.Object ref = "";
      if (resultCase_ == 2) {
        ref = result_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (resultCase_ == 2) {
          result_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * Foreign ID, i.e. local identifier assigned to a new user.
     * </pre>
     *
     * <code>string foreign_id = 2;</code>
     */
    public com.google.protobuf.ByteString
        getForeignIdBytes() {
      java.lang.Object ref = "";
      if (resultCase_ == 2) {
        ref = result_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        if (resultCase_ == 2) {
          result_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ERROR_FIELD_NUMBER = 3;
    /**
     * <pre>
     * Error that prevented a successful response.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.EnrollmentError error = 3;</code>
     */
    public int getErrorValue() {
      if (resultCase_ == 3) {
        return (java.lang.Integer) result_;
      }
      return 0;
    }
    /**
     * <pre>
     * Error that prevented a successful response.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.EnrollmentError error = 3;</code>
     */
    public io.bloombox.schema.services.shop.v1.EnrollmentError getError() {
      if (resultCase_ == 3) {
        io.bloombox.schema.services.shop.v1.EnrollmentError result = io.bloombox.schema.services.shop.v1.EnrollmentError.valueOf(
            (java.lang.Integer) result_);
        return result == null ? io.bloombox.schema.services.shop.v1.EnrollmentError.UNRECOGNIZED : result;
      }
      return io.bloombox.schema.services.shop.v1.EnrollmentError.NO_ENROLLMENT_ERROR;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
      }
      if (resultCase_ == 2) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, result_);
      }
      if (resultCase_ == 3) {
        output.writeEnum(3, ((java.lang.Integer) result_));
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
      }
      if (resultCase_ == 2) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, result_);
      }
      if (resultCase_ == 3) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(3, ((java.lang.Integer) result_));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.shop.v1.EnrollMember.Response)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.shop.v1.EnrollMember.Response other = (io.bloombox.schema.services.shop.v1.EnrollMember.Response) obj;

      boolean result = true;
      result = result && getId()
          .equals(other.getId());
      result = result && getResultCase().equals(
          other.getResultCase());
      if (!result) return false;
      switch (resultCase_) {
        case 2:
          result = result && getForeignId()
              .equals(other.getForeignId());
          break;
        case 3:
          result = result && getErrorValue()
              == other.getErrorValue();
          break;
        case 0:
        default:
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + getId().hashCode();
      switch (resultCase_) {
        case 2:
          hash = (37 * hash) + FOREIGN_ID_FIELD_NUMBER;
          hash = (53 * hash) + getForeignId().hashCode();
          break;
        case 3:
          hash = (37 * hash) + ERROR_FIELD_NUMBER;
          hash = (53 * hash) + getErrorValue();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.shop.v1.EnrollMember.Response parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.shop.v1.EnrollMember.Response parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.EnrollMember.Response parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.shop.v1.EnrollMember.Response parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.EnrollMember.Response parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.shop.v1.EnrollMember.Response parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.EnrollMember.Response parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.shop.v1.EnrollMember.Response parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.EnrollMember.Response parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.shop.v1.EnrollMember.Response parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.EnrollMember.Response parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.shop.v1.EnrollMember.Response parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.shop.v1.EnrollMember.Response prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code bloombox.schema.services.shop.v1.EnrollMember.Response}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.shop.v1.EnrollMember.Response)
        io.bloombox.schema.services.shop.v1.EnrollMember.ResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_EnrollMember_Response_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_EnrollMember_Response_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.shop.v1.EnrollMember.Response.class, io.bloombox.schema.services.shop.v1.EnrollMember.Response.Builder.class);
      }

      // Construct using io.bloombox.schema.services.shop.v1.EnrollMember.Response.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        id_ = "";

        resultCase_ = 0;
        result_ = null;
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_EnrollMember_Response_descriptor;
      }

      public io.bloombox.schema.services.shop.v1.EnrollMember.Response getDefaultInstanceForType() {
        return io.bloombox.schema.services.shop.v1.EnrollMember.Response.getDefaultInstance();
      }

      public io.bloombox.schema.services.shop.v1.EnrollMember.Response build() {
        io.bloombox.schema.services.shop.v1.EnrollMember.Response result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.shop.v1.EnrollMember.Response buildPartial() {
        io.bloombox.schema.services.shop.v1.EnrollMember.Response result = new io.bloombox.schema.services.shop.v1.EnrollMember.Response(this);
        result.id_ = id_;
        if (resultCase_ == 2) {
          result.result_ = result_;
        }
        if (resultCase_ == 3) {
          result.result_ = result_;
        }
        result.resultCase_ = resultCase_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.shop.v1.EnrollMember.Response) {
          return mergeFrom((io.bloombox.schema.services.shop.v1.EnrollMember.Response)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.shop.v1.EnrollMember.Response other) {
        if (other == io.bloombox.schema.services.shop.v1.EnrollMember.Response.getDefaultInstance()) return this;
        if (!other.getId().isEmpty()) {
          id_ = other.id_;
          onChanged();
        }
        switch (other.getResultCase()) {
          case FOREIGN_ID: {
            resultCase_ = 2;
            result_ = other.result_;
            onChanged();
            break;
          }
          case ERROR: {
            setErrorValue(other.getErrorValue());
            break;
          }
          case RESULT_NOT_SET: {
            break;
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.shop.v1.EnrollMember.Response parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.shop.v1.EnrollMember.Response) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int resultCase_ = 0;
      private java.lang.Object result_;
      public ResultCase
          getResultCase() {
        return ResultCase.forNumber(
            resultCase_);
      }

      public Builder clearResult() {
        resultCase_ = 0;
        result_ = null;
        onChanged();
        return this;
      }


      private java.lang.Object id_ = "";
      /**
       * <pre>
       * Resulting ID from the new enrollment.
       * </pre>
       *
       * <code>string id = 1;</code>
       */
      public java.lang.String getId() {
        java.lang.Object ref = id_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          id_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Resulting ID from the new enrollment.
       * </pre>
       *
       * <code>string id = 1;</code>
       */
      public com.google.protobuf.ByteString
          getIdBytes() {
        java.lang.Object ref = id_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          id_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Resulting ID from the new enrollment.
       * </pre>
       *
       * <code>string id = 1;</code>
       */
      public Builder setId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        id_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Resulting ID from the new enrollment.
       * </pre>
       *
       * <code>string id = 1;</code>
       */
      public Builder clearId() {
        
        id_ = getDefaultInstance().getId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Resulting ID from the new enrollment.
       * </pre>
       *
       * <code>string id = 1;</code>
       */
      public Builder setIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        id_ = value;
        onChanged();
        return this;
      }

      /**
       * <pre>
       * Foreign ID, i.e. local identifier assigned to a new user.
       * </pre>
       *
       * <code>string foreign_id = 2;</code>
       */
      public java.lang.String getForeignId() {
        java.lang.Object ref = "";
        if (resultCase_ == 2) {
          ref = result_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (resultCase_ == 2) {
            result_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Foreign ID, i.e. local identifier assigned to a new user.
       * </pre>
       *
       * <code>string foreign_id = 2;</code>
       */
      public com.google.protobuf.ByteString
          getForeignIdBytes() {
        java.lang.Object ref = "";
        if (resultCase_ == 2) {
          ref = result_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          if (resultCase_ == 2) {
            result_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Foreign ID, i.e. local identifier assigned to a new user.
       * </pre>
       *
       * <code>string foreign_id = 2;</code>
       */
      public Builder setForeignId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  resultCase_ = 2;
        result_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Foreign ID, i.e. local identifier assigned to a new user.
       * </pre>
       *
       * <code>string foreign_id = 2;</code>
       */
      public Builder clearForeignId() {
        if (resultCase_ == 2) {
          resultCase_ = 0;
          result_ = null;
          onChanged();
        }
        return this;
      }
      /**
       * <pre>
       * Foreign ID, i.e. local identifier assigned to a new user.
       * </pre>
       *
       * <code>string foreign_id = 2;</code>
       */
      public Builder setForeignIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        resultCase_ = 2;
        result_ = value;
        onChanged();
        return this;
      }

      /**
       * <pre>
       * Error that prevented a successful response.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.EnrollmentError error = 3;</code>
       */
      public int getErrorValue() {
        if (resultCase_ == 3) {
          return ((java.lang.Integer) result_).intValue();
        }
        return 0;
      }
      /**
       * <pre>
       * Error that prevented a successful response.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.EnrollmentError error = 3;</code>
       */
      public Builder setErrorValue(int value) {
        resultCase_ = 3;
        result_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Error that prevented a successful response.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.EnrollmentError error = 3;</code>
       */
      public io.bloombox.schema.services.shop.v1.EnrollmentError getError() {
        if (resultCase_ == 3) {
          io.bloombox.schema.services.shop.v1.EnrollmentError result = io.bloombox.schema.services.shop.v1.EnrollmentError.valueOf(
              (java.lang.Integer) result_);
          return result == null ? io.bloombox.schema.services.shop.v1.EnrollmentError.UNRECOGNIZED : result;
        }
        return io.bloombox.schema.services.shop.v1.EnrollmentError.NO_ENROLLMENT_ERROR;
      }
      /**
       * <pre>
       * Error that prevented a successful response.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.EnrollmentError error = 3;</code>
       */
      public Builder setError(io.bloombox.schema.services.shop.v1.EnrollmentError value) {
        if (value == null) {
          throw new NullPointerException();
        }
        resultCase_ = 3;
        result_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Error that prevented a successful response.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.EnrollmentError error = 3;</code>
       */
      public Builder clearError() {
        if (resultCase_ == 3) {
          resultCase_ = 0;
          result_ = null;
          onChanged();
        }
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.shop.v1.EnrollMember.Response)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.shop.v1.EnrollMember.Response)
    private static final io.bloombox.schema.services.shop.v1.EnrollMember.Response DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.shop.v1.EnrollMember.Response();
    }

    public static io.bloombox.schema.services.shop.v1.EnrollMember.Response getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Response>
        PARSER = new com.google.protobuf.AbstractParser<Response>() {
      public Response parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Response(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Response> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Response> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.shop.v1.EnrollMember.Response getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface OperationOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.shop.v1.EnrollMember.Operation)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Request for member enrollment.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.EnrollMember.Request request = 1;</code>
     */
    boolean hasRequest();
    /**
     * <pre>
     * Request for member enrollment.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.EnrollMember.Request request = 1;</code>
     */
    io.bloombox.schema.services.shop.v1.EnrollMember.Request getRequest();
    /**
     * <pre>
     * Request for member enrollment.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.EnrollMember.Request request = 1;</code>
     */
    io.bloombox.schema.services.shop.v1.EnrollMember.RequestOrBuilder getRequestOrBuilder();

    /**
     * <pre>
     * Response to a request for member enrollment.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.EnrollMember.Response response = 2;</code>
     */
    boolean hasResponse();
    /**
     * <pre>
     * Response to a request for member enrollment.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.EnrollMember.Response response = 2;</code>
     */
    io.bloombox.schema.services.shop.v1.EnrollMember.Response getResponse();
    /**
     * <pre>
     * Response to a request for member enrollment.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.EnrollMember.Response response = 2;</code>
     */
    io.bloombox.schema.services.shop.v1.EnrollMember.ResponseOrBuilder getResponseOrBuilder();
  }
  /**
   * Protobuf type {@code bloombox.schema.services.shop.v1.EnrollMember.Operation}
   */
  public  static final class Operation extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.shop.v1.EnrollMember.Operation)
      OperationOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Operation.newBuilder() to construct.
    private Operation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Operation() {
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Operation(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              io.bloombox.schema.services.shop.v1.EnrollMember.Request.Builder subBuilder = null;
              if (request_ != null) {
                subBuilder = request_.toBuilder();
              }
              request_ = input.readMessage(io.bloombox.schema.services.shop.v1.EnrollMember.Request.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(request_);
                request_ = subBuilder.buildPartial();
              }

              break;
            }
            case 18: {
              io.bloombox.schema.services.shop.v1.EnrollMember.Response.Builder subBuilder = null;
              if (response_ != null) {
                subBuilder = response_.toBuilder();
              }
              response_ = input.readMessage(io.bloombox.schema.services.shop.v1.EnrollMember.Response.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(response_);
                response_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_EnrollMember_Operation_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_EnrollMember_Operation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.shop.v1.EnrollMember.Operation.class, io.bloombox.schema.services.shop.v1.EnrollMember.Operation.Builder.class);
    }

    public static final int REQUEST_FIELD_NUMBER = 1;
    private io.bloombox.schema.services.shop.v1.EnrollMember.Request request_;
    /**
     * <pre>
     * Request for member enrollment.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.EnrollMember.Request request = 1;</code>
     */
    public boolean hasRequest() {
      return request_ != null;
    }
    /**
     * <pre>
     * Request for member enrollment.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.EnrollMember.Request request = 1;</code>
     */
    public io.bloombox.schema.services.shop.v1.EnrollMember.Request getRequest() {
      return request_ == null ? io.bloombox.schema.services.shop.v1.EnrollMember.Request.getDefaultInstance() : request_;
    }
    /**
     * <pre>
     * Request for member enrollment.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.EnrollMember.Request request = 1;</code>
     */
    public io.bloombox.schema.services.shop.v1.EnrollMember.RequestOrBuilder getRequestOrBuilder() {
      return getRequest();
    }

    public static final int RESPONSE_FIELD_NUMBER = 2;
    private io.bloombox.schema.services.shop.v1.EnrollMember.Response response_;
    /**
     * <pre>
     * Response to a request for member enrollment.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.EnrollMember.Response response = 2;</code>
     */
    public boolean hasResponse() {
      return response_ != null;
    }
    /**
     * <pre>
     * Response to a request for member enrollment.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.EnrollMember.Response response = 2;</code>
     */
    public io.bloombox.schema.services.shop.v1.EnrollMember.Response getResponse() {
      return response_ == null ? io.bloombox.schema.services.shop.v1.EnrollMember.Response.getDefaultInstance() : response_;
    }
    /**
     * <pre>
     * Response to a request for member enrollment.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.EnrollMember.Response response = 2;</code>
     */
    public io.bloombox.schema.services.shop.v1.EnrollMember.ResponseOrBuilder getResponseOrBuilder() {
      return getResponse();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (request_ != null) {
        output.writeMessage(1, getRequest());
      }
      if (response_ != null) {
        output.writeMessage(2, getResponse());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (request_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getRequest());
      }
      if (response_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getResponse());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.shop.v1.EnrollMember.Operation)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.shop.v1.EnrollMember.Operation other = (io.bloombox.schema.services.shop.v1.EnrollMember.Operation) obj;

      boolean result = true;
      result = result && (hasRequest() == other.hasRequest());
      if (hasRequest()) {
        result = result && getRequest()
            .equals(other.getRequest());
      }
      result = result && (hasResponse() == other.hasResponse());
      if (hasResponse()) {
        result = result && getResponse()
            .equals(other.getResponse());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasRequest()) {
        hash = (37 * hash) + REQUEST_FIELD_NUMBER;
        hash = (53 * hash) + getRequest().hashCode();
      }
      if (hasResponse()) {
        hash = (37 * hash) + RESPONSE_FIELD_NUMBER;
        hash = (53 * hash) + getResponse().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.shop.v1.EnrollMember.Operation parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.shop.v1.EnrollMember.Operation parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.EnrollMember.Operation parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.shop.v1.EnrollMember.Operation parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.EnrollMember.Operation parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.shop.v1.EnrollMember.Operation parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.EnrollMember.Operation parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.shop.v1.EnrollMember.Operation parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.EnrollMember.Operation parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.shop.v1.EnrollMember.Operation parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.EnrollMember.Operation parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.shop.v1.EnrollMember.Operation parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.shop.v1.EnrollMember.Operation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code bloombox.schema.services.shop.v1.EnrollMember.Operation}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.shop.v1.EnrollMember.Operation)
        io.bloombox.schema.services.shop.v1.EnrollMember.OperationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_EnrollMember_Operation_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_EnrollMember_Operation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.shop.v1.EnrollMember.Operation.class, io.bloombox.schema.services.shop.v1.EnrollMember.Operation.Builder.class);
      }

      // Construct using io.bloombox.schema.services.shop.v1.EnrollMember.Operation.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        if (requestBuilder_ == null) {
          request_ = null;
        } else {
          request_ = null;
          requestBuilder_ = null;
        }
        if (responseBuilder_ == null) {
          response_ = null;
        } else {
          response_ = null;
          responseBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_EnrollMember_Operation_descriptor;
      }

      public io.bloombox.schema.services.shop.v1.EnrollMember.Operation getDefaultInstanceForType() {
        return io.bloombox.schema.services.shop.v1.EnrollMember.Operation.getDefaultInstance();
      }

      public io.bloombox.schema.services.shop.v1.EnrollMember.Operation build() {
        io.bloombox.schema.services.shop.v1.EnrollMember.Operation result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.shop.v1.EnrollMember.Operation buildPartial() {
        io.bloombox.schema.services.shop.v1.EnrollMember.Operation result = new io.bloombox.schema.services.shop.v1.EnrollMember.Operation(this);
        if (requestBuilder_ == null) {
          result.request_ = request_;
        } else {
          result.request_ = requestBuilder_.build();
        }
        if (responseBuilder_ == null) {
          result.response_ = response_;
        } else {
          result.response_ = responseBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.shop.v1.EnrollMember.Operation) {
          return mergeFrom((io.bloombox.schema.services.shop.v1.EnrollMember.Operation)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.shop.v1.EnrollMember.Operation other) {
        if (other == io.bloombox.schema.services.shop.v1.EnrollMember.Operation.getDefaultInstance()) return this;
        if (other.hasRequest()) {
          mergeRequest(other.getRequest());
        }
        if (other.hasResponse()) {
          mergeResponse(other.getResponse());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.shop.v1.EnrollMember.Operation parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.shop.v1.EnrollMember.Operation) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private io.bloombox.schema.services.shop.v1.EnrollMember.Request request_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.services.shop.v1.EnrollMember.Request, io.bloombox.schema.services.shop.v1.EnrollMember.Request.Builder, io.bloombox.schema.services.shop.v1.EnrollMember.RequestOrBuilder> requestBuilder_;
      /**
       * <pre>
       * Request for member enrollment.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.EnrollMember.Request request = 1;</code>
       */
      public boolean hasRequest() {
        return requestBuilder_ != null || request_ != null;
      }
      /**
       * <pre>
       * Request for member enrollment.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.EnrollMember.Request request = 1;</code>
       */
      public io.bloombox.schema.services.shop.v1.EnrollMember.Request getRequest() {
        if (requestBuilder_ == null) {
          return request_ == null ? io.bloombox.schema.services.shop.v1.EnrollMember.Request.getDefaultInstance() : request_;
        } else {
          return requestBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Request for member enrollment.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.EnrollMember.Request request = 1;</code>
       */
      public Builder setRequest(io.bloombox.schema.services.shop.v1.EnrollMember.Request value) {
        if (requestBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          request_ = value;
          onChanged();
        } else {
          requestBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Request for member enrollment.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.EnrollMember.Request request = 1;</code>
       */
      public Builder setRequest(
          io.bloombox.schema.services.shop.v1.EnrollMember.Request.Builder builderForValue) {
        if (requestBuilder_ == null) {
          request_ = builderForValue.build();
          onChanged();
        } else {
          requestBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Request for member enrollment.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.EnrollMember.Request request = 1;</code>
       */
      public Builder mergeRequest(io.bloombox.schema.services.shop.v1.EnrollMember.Request value) {
        if (requestBuilder_ == null) {
          if (request_ != null) {
            request_ =
              io.bloombox.schema.services.shop.v1.EnrollMember.Request.newBuilder(request_).mergeFrom(value).buildPartial();
          } else {
            request_ = value;
          }
          onChanged();
        } else {
          requestBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Request for member enrollment.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.EnrollMember.Request request = 1;</code>
       */
      public Builder clearRequest() {
        if (requestBuilder_ == null) {
          request_ = null;
          onChanged();
        } else {
          request_ = null;
          requestBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Request for member enrollment.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.EnrollMember.Request request = 1;</code>
       */
      public io.bloombox.schema.services.shop.v1.EnrollMember.Request.Builder getRequestBuilder() {
        
        onChanged();
        return getRequestFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Request for member enrollment.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.EnrollMember.Request request = 1;</code>
       */
      public io.bloombox.schema.services.shop.v1.EnrollMember.RequestOrBuilder getRequestOrBuilder() {
        if (requestBuilder_ != null) {
          return requestBuilder_.getMessageOrBuilder();
        } else {
          return request_ == null ?
              io.bloombox.schema.services.shop.v1.EnrollMember.Request.getDefaultInstance() : request_;
        }
      }
      /**
       * <pre>
       * Request for member enrollment.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.EnrollMember.Request request = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.services.shop.v1.EnrollMember.Request, io.bloombox.schema.services.shop.v1.EnrollMember.Request.Builder, io.bloombox.schema.services.shop.v1.EnrollMember.RequestOrBuilder> 
          getRequestFieldBuilder() {
        if (requestBuilder_ == null) {
          requestBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.services.shop.v1.EnrollMember.Request, io.bloombox.schema.services.shop.v1.EnrollMember.Request.Builder, io.bloombox.schema.services.shop.v1.EnrollMember.RequestOrBuilder>(
                  getRequest(),
                  getParentForChildren(),
                  isClean());
          request_ = null;
        }
        return requestBuilder_;
      }

      private io.bloombox.schema.services.shop.v1.EnrollMember.Response response_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.services.shop.v1.EnrollMember.Response, io.bloombox.schema.services.shop.v1.EnrollMember.Response.Builder, io.bloombox.schema.services.shop.v1.EnrollMember.ResponseOrBuilder> responseBuilder_;
      /**
       * <pre>
       * Response to a request for member enrollment.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.EnrollMember.Response response = 2;</code>
       */
      public boolean hasResponse() {
        return responseBuilder_ != null || response_ != null;
      }
      /**
       * <pre>
       * Response to a request for member enrollment.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.EnrollMember.Response response = 2;</code>
       */
      public io.bloombox.schema.services.shop.v1.EnrollMember.Response getResponse() {
        if (responseBuilder_ == null) {
          return response_ == null ? io.bloombox.schema.services.shop.v1.EnrollMember.Response.getDefaultInstance() : response_;
        } else {
          return responseBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Response to a request for member enrollment.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.EnrollMember.Response response = 2;</code>
       */
      public Builder setResponse(io.bloombox.schema.services.shop.v1.EnrollMember.Response value) {
        if (responseBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          response_ = value;
          onChanged();
        } else {
          responseBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Response to a request for member enrollment.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.EnrollMember.Response response = 2;</code>
       */
      public Builder setResponse(
          io.bloombox.schema.services.shop.v1.EnrollMember.Response.Builder builderForValue) {
        if (responseBuilder_ == null) {
          response_ = builderForValue.build();
          onChanged();
        } else {
          responseBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Response to a request for member enrollment.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.EnrollMember.Response response = 2;</code>
       */
      public Builder mergeResponse(io.bloombox.schema.services.shop.v1.EnrollMember.Response value) {
        if (responseBuilder_ == null) {
          if (response_ != null) {
            response_ =
              io.bloombox.schema.services.shop.v1.EnrollMember.Response.newBuilder(response_).mergeFrom(value).buildPartial();
          } else {
            response_ = value;
          }
          onChanged();
        } else {
          responseBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Response to a request for member enrollment.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.EnrollMember.Response response = 2;</code>
       */
      public Builder clearResponse() {
        if (responseBuilder_ == null) {
          response_ = null;
          onChanged();
        } else {
          response_ = null;
          responseBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Response to a request for member enrollment.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.EnrollMember.Response response = 2;</code>
       */
      public io.bloombox.schema.services.shop.v1.EnrollMember.Response.Builder getResponseBuilder() {
        
        onChanged();
        return getResponseFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Response to a request for member enrollment.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.EnrollMember.Response response = 2;</code>
       */
      public io.bloombox.schema.services.shop.v1.EnrollMember.ResponseOrBuilder getResponseOrBuilder() {
        if (responseBuilder_ != null) {
          return responseBuilder_.getMessageOrBuilder();
        } else {
          return response_ == null ?
              io.bloombox.schema.services.shop.v1.EnrollMember.Response.getDefaultInstance() : response_;
        }
      }
      /**
       * <pre>
       * Response to a request for member enrollment.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.EnrollMember.Response response = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.services.shop.v1.EnrollMember.Response, io.bloombox.schema.services.shop.v1.EnrollMember.Response.Builder, io.bloombox.schema.services.shop.v1.EnrollMember.ResponseOrBuilder> 
          getResponseFieldBuilder() {
        if (responseBuilder_ == null) {
          responseBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.services.shop.v1.EnrollMember.Response, io.bloombox.schema.services.shop.v1.EnrollMember.Response.Builder, io.bloombox.schema.services.shop.v1.EnrollMember.ResponseOrBuilder>(
                  getResponse(),
                  getParentForChildren(),
                  isClean());
          response_ = null;
        }
        return responseBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.shop.v1.EnrollMember.Operation)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.shop.v1.EnrollMember.Operation)
    private static final io.bloombox.schema.services.shop.v1.EnrollMember.Operation DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.shop.v1.EnrollMember.Operation();
    }

    public static io.bloombox.schema.services.shop.v1.EnrollMember.Operation getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Operation>
        PARSER = new com.google.protobuf.AbstractParser<Operation>() {
      public Operation parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Operation(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Operation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Operation> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.shop.v1.EnrollMember.Operation getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.services.shop.v1.EnrollMember)) {
      return super.equals(obj);
    }
    io.bloombox.schema.services.shop.v1.EnrollMember other = (io.bloombox.schema.services.shop.v1.EnrollMember) obj;

    boolean result = true;
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.services.shop.v1.EnrollMember parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.shop.v1.EnrollMember parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.shop.v1.EnrollMember parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.shop.v1.EnrollMember parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.shop.v1.EnrollMember parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.shop.v1.EnrollMember parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.shop.v1.EnrollMember parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.shop.v1.EnrollMember parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.shop.v1.EnrollMember parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.shop.v1.EnrollMember parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.shop.v1.EnrollMember parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.shop.v1.EnrollMember parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.services.shop.v1.EnrollMember prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies an RPC operation to enroll/onboard a new user as a member of a retail dispensary.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.shop.v1.EnrollMember}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.services.shop.v1.EnrollMember)
      io.bloombox.schema.services.shop.v1.EnrollMemberOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_EnrollMember_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_EnrollMember_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.shop.v1.EnrollMember.class, io.bloombox.schema.services.shop.v1.EnrollMember.Builder.class);
    }

    // Construct using io.bloombox.schema.services.shop.v1.EnrollMember.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_EnrollMember_descriptor;
    }

    public io.bloombox.schema.services.shop.v1.EnrollMember getDefaultInstanceForType() {
      return io.bloombox.schema.services.shop.v1.EnrollMember.getDefaultInstance();
    }

    public io.bloombox.schema.services.shop.v1.EnrollMember build() {
      io.bloombox.schema.services.shop.v1.EnrollMember result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.services.shop.v1.EnrollMember buildPartial() {
      io.bloombox.schema.services.shop.v1.EnrollMember result = new io.bloombox.schema.services.shop.v1.EnrollMember(this);
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.services.shop.v1.EnrollMember) {
        return mergeFrom((io.bloombox.schema.services.shop.v1.EnrollMember)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.services.shop.v1.EnrollMember other) {
      if (other == io.bloombox.schema.services.shop.v1.EnrollMember.getDefaultInstance()) return this;
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.services.shop.v1.EnrollMember parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.services.shop.v1.EnrollMember) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.services.shop.v1.EnrollMember)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.services.shop.v1.EnrollMember)
  private static final io.bloombox.schema.services.shop.v1.EnrollMember DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.services.shop.v1.EnrollMember();
  }

  public static io.bloombox.schema.services.shop.v1.EnrollMember getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EnrollMember>
      PARSER = new com.google.protobuf.AbstractParser<EnrollMember>() {
    public EnrollMember parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new EnrollMember(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<EnrollMember> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EnrollMember> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.services.shop.v1.EnrollMember getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

