/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: shop/v1/ShopService_v1.proto

package io.bloombox.schema.services.shop.v1;

/**
 * <pre>
 * Specifies an RPC operation to submit an express pickup or delivery order.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.services.shop.v1.SubmitOrder}
 */
public  final class SubmitOrder extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.services.shop.v1.SubmitOrder)
    SubmitOrderOrBuilder {
private static final long serialVersionUID = 0L;
  // Use SubmitOrder.newBuilder() to construct.
  private SubmitOrder(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private SubmitOrder() {
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private SubmitOrder(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_SubmitOrder_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_SubmitOrder_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.services.shop.v1.SubmitOrder.class, io.bloombox.schema.services.shop.v1.SubmitOrder.Builder.class);
  }

  public interface RequestOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.shop.v1.SubmitOrder.Request)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Order to submit.
     * </pre>
     *
     * <code>.opencannabis.commerce.Order order = 1;</code>
     */
    boolean hasOrder();
    /**
     * <pre>
     * Order to submit.
     * </pre>
     *
     * <code>.opencannabis.commerce.Order order = 1;</code>
     */
    io.opencannabis.schema.commerce.CommercialOrder.Order getOrder();
    /**
     * <pre>
     * Order to submit.
     * </pre>
     *
     * <code>.opencannabis.commerce.Order order = 1;</code>
     */
    io.opencannabis.schema.commerce.CommercialOrder.OrderOrBuilder getOrderOrBuilder();

    /**
     * <pre>
     * Location to check.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerLocationKey location = 2;</code>
     */
    boolean hasLocation();
    /**
     * <pre>
     * Location to check.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerLocationKey location = 2;</code>
     */
    io.bloombox.schema.partner.PartnerLocationKey getLocation();
    /**
     * <pre>
     * Location to check.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerLocationKey location = 2;</code>
     */
    io.bloombox.schema.partner.PartnerLocationKeyOrBuilder getLocationOrBuilder();
  }
  /**
   * Protobuf type {@code bloombox.schema.services.shop.v1.SubmitOrder.Request}
   */
  public  static final class Request extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.shop.v1.SubmitOrder.Request)
      RequestOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Request.newBuilder() to construct.
    private Request(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Request() {
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Request(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              io.opencannabis.schema.commerce.CommercialOrder.Order.Builder subBuilder = null;
              if (order_ != null) {
                subBuilder = order_.toBuilder();
              }
              order_ = input.readMessage(io.opencannabis.schema.commerce.CommercialOrder.Order.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(order_);
                order_ = subBuilder.buildPartial();
              }

              break;
            }
            case 18: {
              io.bloombox.schema.partner.PartnerLocationKey.Builder subBuilder = null;
              if (location_ != null) {
                subBuilder = location_.toBuilder();
              }
              location_ = input.readMessage(io.bloombox.schema.partner.PartnerLocationKey.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(location_);
                location_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_SubmitOrder_Request_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_SubmitOrder_Request_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.shop.v1.SubmitOrder.Request.class, io.bloombox.schema.services.shop.v1.SubmitOrder.Request.Builder.class);
    }

    public static final int ORDER_FIELD_NUMBER = 1;
    private io.opencannabis.schema.commerce.CommercialOrder.Order order_;
    /**
     * <pre>
     * Order to submit.
     * </pre>
     *
     * <code>.opencannabis.commerce.Order order = 1;</code>
     */
    public boolean hasOrder() {
      return order_ != null;
    }
    /**
     * <pre>
     * Order to submit.
     * </pre>
     *
     * <code>.opencannabis.commerce.Order order = 1;</code>
     */
    public io.opencannabis.schema.commerce.CommercialOrder.Order getOrder() {
      return order_ == null ? io.opencannabis.schema.commerce.CommercialOrder.Order.getDefaultInstance() : order_;
    }
    /**
     * <pre>
     * Order to submit.
     * </pre>
     *
     * <code>.opencannabis.commerce.Order order = 1;</code>
     */
    public io.opencannabis.schema.commerce.CommercialOrder.OrderOrBuilder getOrderOrBuilder() {
      return getOrder();
    }

    public static final int LOCATION_FIELD_NUMBER = 2;
    private io.bloombox.schema.partner.PartnerLocationKey location_;
    /**
     * <pre>
     * Location to check.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerLocationKey location = 2;</code>
     */
    public boolean hasLocation() {
      return location_ != null;
    }
    /**
     * <pre>
     * Location to check.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerLocationKey location = 2;</code>
     */
    public io.bloombox.schema.partner.PartnerLocationKey getLocation() {
      return location_ == null ? io.bloombox.schema.partner.PartnerLocationKey.getDefaultInstance() : location_;
    }
    /**
     * <pre>
     * Location to check.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerLocationKey location = 2;</code>
     */
    public io.bloombox.schema.partner.PartnerLocationKeyOrBuilder getLocationOrBuilder() {
      return getLocation();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (order_ != null) {
        output.writeMessage(1, getOrder());
      }
      if (location_ != null) {
        output.writeMessage(2, getLocation());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (order_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getOrder());
      }
      if (location_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getLocation());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.shop.v1.SubmitOrder.Request)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.shop.v1.SubmitOrder.Request other = (io.bloombox.schema.services.shop.v1.SubmitOrder.Request) obj;

      boolean result = true;
      result = result && (hasOrder() == other.hasOrder());
      if (hasOrder()) {
        result = result && getOrder()
            .equals(other.getOrder());
      }
      result = result && (hasLocation() == other.hasLocation());
      if (hasLocation()) {
        result = result && getLocation()
            .equals(other.getLocation());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasOrder()) {
        hash = (37 * hash) + ORDER_FIELD_NUMBER;
        hash = (53 * hash) + getOrder().hashCode();
      }
      if (hasLocation()) {
        hash = (37 * hash) + LOCATION_FIELD_NUMBER;
        hash = (53 * hash) + getLocation().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Request parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Request parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Request parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Request parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Request parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Request parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Request parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Request parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Request parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Request parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Request parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Request parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.shop.v1.SubmitOrder.Request prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code bloombox.schema.services.shop.v1.SubmitOrder.Request}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.shop.v1.SubmitOrder.Request)
        io.bloombox.schema.services.shop.v1.SubmitOrder.RequestOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_SubmitOrder_Request_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_SubmitOrder_Request_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.shop.v1.SubmitOrder.Request.class, io.bloombox.schema.services.shop.v1.SubmitOrder.Request.Builder.class);
      }

      // Construct using io.bloombox.schema.services.shop.v1.SubmitOrder.Request.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        if (orderBuilder_ == null) {
          order_ = null;
        } else {
          order_ = null;
          orderBuilder_ = null;
        }
        if (locationBuilder_ == null) {
          location_ = null;
        } else {
          location_ = null;
          locationBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_SubmitOrder_Request_descriptor;
      }

      public io.bloombox.schema.services.shop.v1.SubmitOrder.Request getDefaultInstanceForType() {
        return io.bloombox.schema.services.shop.v1.SubmitOrder.Request.getDefaultInstance();
      }

      public io.bloombox.schema.services.shop.v1.SubmitOrder.Request build() {
        io.bloombox.schema.services.shop.v1.SubmitOrder.Request result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.shop.v1.SubmitOrder.Request buildPartial() {
        io.bloombox.schema.services.shop.v1.SubmitOrder.Request result = new io.bloombox.schema.services.shop.v1.SubmitOrder.Request(this);
        if (orderBuilder_ == null) {
          result.order_ = order_;
        } else {
          result.order_ = orderBuilder_.build();
        }
        if (locationBuilder_ == null) {
          result.location_ = location_;
        } else {
          result.location_ = locationBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.shop.v1.SubmitOrder.Request) {
          return mergeFrom((io.bloombox.schema.services.shop.v1.SubmitOrder.Request)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.shop.v1.SubmitOrder.Request other) {
        if (other == io.bloombox.schema.services.shop.v1.SubmitOrder.Request.getDefaultInstance()) return this;
        if (other.hasOrder()) {
          mergeOrder(other.getOrder());
        }
        if (other.hasLocation()) {
          mergeLocation(other.getLocation());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.shop.v1.SubmitOrder.Request parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.shop.v1.SubmitOrder.Request) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private io.opencannabis.schema.commerce.CommercialOrder.Order order_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.commerce.CommercialOrder.Order, io.opencannabis.schema.commerce.CommercialOrder.Order.Builder, io.opencannabis.schema.commerce.CommercialOrder.OrderOrBuilder> orderBuilder_;
      /**
       * <pre>
       * Order to submit.
       * </pre>
       *
       * <code>.opencannabis.commerce.Order order = 1;</code>
       */
      public boolean hasOrder() {
        return orderBuilder_ != null || order_ != null;
      }
      /**
       * <pre>
       * Order to submit.
       * </pre>
       *
       * <code>.opencannabis.commerce.Order order = 1;</code>
       */
      public io.opencannabis.schema.commerce.CommercialOrder.Order getOrder() {
        if (orderBuilder_ == null) {
          return order_ == null ? io.opencannabis.schema.commerce.CommercialOrder.Order.getDefaultInstance() : order_;
        } else {
          return orderBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Order to submit.
       * </pre>
       *
       * <code>.opencannabis.commerce.Order order = 1;</code>
       */
      public Builder setOrder(io.opencannabis.schema.commerce.CommercialOrder.Order value) {
        if (orderBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          order_ = value;
          onChanged();
        } else {
          orderBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Order to submit.
       * </pre>
       *
       * <code>.opencannabis.commerce.Order order = 1;</code>
       */
      public Builder setOrder(
          io.opencannabis.schema.commerce.CommercialOrder.Order.Builder builderForValue) {
        if (orderBuilder_ == null) {
          order_ = builderForValue.build();
          onChanged();
        } else {
          orderBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Order to submit.
       * </pre>
       *
       * <code>.opencannabis.commerce.Order order = 1;</code>
       */
      public Builder mergeOrder(io.opencannabis.schema.commerce.CommercialOrder.Order value) {
        if (orderBuilder_ == null) {
          if (order_ != null) {
            order_ =
              io.opencannabis.schema.commerce.CommercialOrder.Order.newBuilder(order_).mergeFrom(value).buildPartial();
          } else {
            order_ = value;
          }
          onChanged();
        } else {
          orderBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Order to submit.
       * </pre>
       *
       * <code>.opencannabis.commerce.Order order = 1;</code>
       */
      public Builder clearOrder() {
        if (orderBuilder_ == null) {
          order_ = null;
          onChanged();
        } else {
          order_ = null;
          orderBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Order to submit.
       * </pre>
       *
       * <code>.opencannabis.commerce.Order order = 1;</code>
       */
      public io.opencannabis.schema.commerce.CommercialOrder.Order.Builder getOrderBuilder() {
        
        onChanged();
        return getOrderFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Order to submit.
       * </pre>
       *
       * <code>.opencannabis.commerce.Order order = 1;</code>
       */
      public io.opencannabis.schema.commerce.CommercialOrder.OrderOrBuilder getOrderOrBuilder() {
        if (orderBuilder_ != null) {
          return orderBuilder_.getMessageOrBuilder();
        } else {
          return order_ == null ?
              io.opencannabis.schema.commerce.CommercialOrder.Order.getDefaultInstance() : order_;
        }
      }
      /**
       * <pre>
       * Order to submit.
       * </pre>
       *
       * <code>.opencannabis.commerce.Order order = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.commerce.CommercialOrder.Order, io.opencannabis.schema.commerce.CommercialOrder.Order.Builder, io.opencannabis.schema.commerce.CommercialOrder.OrderOrBuilder> 
          getOrderFieldBuilder() {
        if (orderBuilder_ == null) {
          orderBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.commerce.CommercialOrder.Order, io.opencannabis.schema.commerce.CommercialOrder.Order.Builder, io.opencannabis.schema.commerce.CommercialOrder.OrderOrBuilder>(
                  getOrder(),
                  getParentForChildren(),
                  isClean());
          order_ = null;
        }
        return orderBuilder_;
      }

      private io.bloombox.schema.partner.PartnerLocationKey location_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.partner.PartnerLocationKey, io.bloombox.schema.partner.PartnerLocationKey.Builder, io.bloombox.schema.partner.PartnerLocationKeyOrBuilder> locationBuilder_;
      /**
       * <pre>
       * Location to check.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocationKey location = 2;</code>
       */
      public boolean hasLocation() {
        return locationBuilder_ != null || location_ != null;
      }
      /**
       * <pre>
       * Location to check.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocationKey location = 2;</code>
       */
      public io.bloombox.schema.partner.PartnerLocationKey getLocation() {
        if (locationBuilder_ == null) {
          return location_ == null ? io.bloombox.schema.partner.PartnerLocationKey.getDefaultInstance() : location_;
        } else {
          return locationBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Location to check.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocationKey location = 2;</code>
       */
      public Builder setLocation(io.bloombox.schema.partner.PartnerLocationKey value) {
        if (locationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          location_ = value;
          onChanged();
        } else {
          locationBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Location to check.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocationKey location = 2;</code>
       */
      public Builder setLocation(
          io.bloombox.schema.partner.PartnerLocationKey.Builder builderForValue) {
        if (locationBuilder_ == null) {
          location_ = builderForValue.build();
          onChanged();
        } else {
          locationBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Location to check.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocationKey location = 2;</code>
       */
      public Builder mergeLocation(io.bloombox.schema.partner.PartnerLocationKey value) {
        if (locationBuilder_ == null) {
          if (location_ != null) {
            location_ =
              io.bloombox.schema.partner.PartnerLocationKey.newBuilder(location_).mergeFrom(value).buildPartial();
          } else {
            location_ = value;
          }
          onChanged();
        } else {
          locationBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Location to check.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocationKey location = 2;</code>
       */
      public Builder clearLocation() {
        if (locationBuilder_ == null) {
          location_ = null;
          onChanged();
        } else {
          location_ = null;
          locationBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Location to check.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocationKey location = 2;</code>
       */
      public io.bloombox.schema.partner.PartnerLocationKey.Builder getLocationBuilder() {
        
        onChanged();
        return getLocationFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Location to check.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocationKey location = 2;</code>
       */
      public io.bloombox.schema.partner.PartnerLocationKeyOrBuilder getLocationOrBuilder() {
        if (locationBuilder_ != null) {
          return locationBuilder_.getMessageOrBuilder();
        } else {
          return location_ == null ?
              io.bloombox.schema.partner.PartnerLocationKey.getDefaultInstance() : location_;
        }
      }
      /**
       * <pre>
       * Location to check.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocationKey location = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.partner.PartnerLocationKey, io.bloombox.schema.partner.PartnerLocationKey.Builder, io.bloombox.schema.partner.PartnerLocationKeyOrBuilder> 
          getLocationFieldBuilder() {
        if (locationBuilder_ == null) {
          locationBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.partner.PartnerLocationKey, io.bloombox.schema.partner.PartnerLocationKey.Builder, io.bloombox.schema.partner.PartnerLocationKeyOrBuilder>(
                  getLocation(),
                  getParentForChildren(),
                  isClean());
          location_ = null;
        }
        return locationBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.shop.v1.SubmitOrder.Request)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.shop.v1.SubmitOrder.Request)
    private static final io.bloombox.schema.services.shop.v1.SubmitOrder.Request DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.shop.v1.SubmitOrder.Request();
    }

    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Request getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Request>
        PARSER = new com.google.protobuf.AbstractParser<Request>() {
      public Request parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Request(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Request> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Request> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.shop.v1.SubmitOrder.Request getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ResponseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.shop.v1.SubmitOrder.Response)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Error, if any.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.OrderError error = 1;</code>
     */
    int getErrorValue();
    /**
     * <pre>
     * Error, if any.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.OrderError error = 1;</code>
     */
    io.bloombox.schema.services.shop.v1.OrderError getError();

    /**
     * <pre>
     * ID assigned to the new order, if no error occurred.
     * </pre>
     *
     * <code>string order_id = 2;</code>
     */
    java.lang.String getOrderId();
    /**
     * <pre>
     * ID assigned to the new order, if no error occurred.
     * </pre>
     *
     * <code>string order_id = 2;</code>
     */
    com.google.protobuf.ByteString
        getOrderIdBytes();
  }
  /**
   * Protobuf type {@code bloombox.schema.services.shop.v1.SubmitOrder.Response}
   */
  public  static final class Response extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.shop.v1.SubmitOrder.Response)
      ResponseOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Response.newBuilder() to construct.
    private Response(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Response() {
      error_ = 0;
      orderId_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Response(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();

              error_ = rawValue;
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();

              orderId_ = s;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_SubmitOrder_Response_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_SubmitOrder_Response_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.shop.v1.SubmitOrder.Response.class, io.bloombox.schema.services.shop.v1.SubmitOrder.Response.Builder.class);
    }

    public static final int ERROR_FIELD_NUMBER = 1;
    private int error_;
    /**
     * <pre>
     * Error, if any.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.OrderError error = 1;</code>
     */
    public int getErrorValue() {
      return error_;
    }
    /**
     * <pre>
     * Error, if any.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.OrderError error = 1;</code>
     */
    public io.bloombox.schema.services.shop.v1.OrderError getError() {
      io.bloombox.schema.services.shop.v1.OrderError result = io.bloombox.schema.services.shop.v1.OrderError.valueOf(error_);
      return result == null ? io.bloombox.schema.services.shop.v1.OrderError.UNRECOGNIZED : result;
    }

    public static final int ORDER_ID_FIELD_NUMBER = 2;
    private volatile java.lang.Object orderId_;
    /**
     * <pre>
     * ID assigned to the new order, if no error occurred.
     * </pre>
     *
     * <code>string order_id = 2;</code>
     */
    public java.lang.String getOrderId() {
      java.lang.Object ref = orderId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        orderId_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * ID assigned to the new order, if no error occurred.
     * </pre>
     *
     * <code>string order_id = 2;</code>
     */
    public com.google.protobuf.ByteString
        getOrderIdBytes() {
      java.lang.Object ref = orderId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        orderId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (error_ != io.bloombox.schema.services.shop.v1.OrderError.NO_ERROR.getNumber()) {
        output.writeEnum(1, error_);
      }
      if (!getOrderIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, orderId_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (error_ != io.bloombox.schema.services.shop.v1.OrderError.NO_ERROR.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, error_);
      }
      if (!getOrderIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, orderId_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.shop.v1.SubmitOrder.Response)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.shop.v1.SubmitOrder.Response other = (io.bloombox.schema.services.shop.v1.SubmitOrder.Response) obj;

      boolean result = true;
      result = result && error_ == other.error_;
      result = result && getOrderId()
          .equals(other.getOrderId());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + error_;
      hash = (37 * hash) + ORDER_ID_FIELD_NUMBER;
      hash = (53 * hash) + getOrderId().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Response parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Response parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Response parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Response parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Response parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Response parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Response parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Response parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Response parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Response parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Response parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Response parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.shop.v1.SubmitOrder.Response prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code bloombox.schema.services.shop.v1.SubmitOrder.Response}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.shop.v1.SubmitOrder.Response)
        io.bloombox.schema.services.shop.v1.SubmitOrder.ResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_SubmitOrder_Response_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_SubmitOrder_Response_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.shop.v1.SubmitOrder.Response.class, io.bloombox.schema.services.shop.v1.SubmitOrder.Response.Builder.class);
      }

      // Construct using io.bloombox.schema.services.shop.v1.SubmitOrder.Response.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        error_ = 0;

        orderId_ = "";

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_SubmitOrder_Response_descriptor;
      }

      public io.bloombox.schema.services.shop.v1.SubmitOrder.Response getDefaultInstanceForType() {
        return io.bloombox.schema.services.shop.v1.SubmitOrder.Response.getDefaultInstance();
      }

      public io.bloombox.schema.services.shop.v1.SubmitOrder.Response build() {
        io.bloombox.schema.services.shop.v1.SubmitOrder.Response result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.shop.v1.SubmitOrder.Response buildPartial() {
        io.bloombox.schema.services.shop.v1.SubmitOrder.Response result = new io.bloombox.schema.services.shop.v1.SubmitOrder.Response(this);
        result.error_ = error_;
        result.orderId_ = orderId_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.shop.v1.SubmitOrder.Response) {
          return mergeFrom((io.bloombox.schema.services.shop.v1.SubmitOrder.Response)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.shop.v1.SubmitOrder.Response other) {
        if (other == io.bloombox.schema.services.shop.v1.SubmitOrder.Response.getDefaultInstance()) return this;
        if (other.error_ != 0) {
          setErrorValue(other.getErrorValue());
        }
        if (!other.getOrderId().isEmpty()) {
          orderId_ = other.orderId_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.shop.v1.SubmitOrder.Response parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.shop.v1.SubmitOrder.Response) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int error_ = 0;
      /**
       * <pre>
       * Error, if any.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.OrderError error = 1;</code>
       */
      public int getErrorValue() {
        return error_;
      }
      /**
       * <pre>
       * Error, if any.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.OrderError error = 1;</code>
       */
      public Builder setErrorValue(int value) {
        error_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Error, if any.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.OrderError error = 1;</code>
       */
      public io.bloombox.schema.services.shop.v1.OrderError getError() {
        io.bloombox.schema.services.shop.v1.OrderError result = io.bloombox.schema.services.shop.v1.OrderError.valueOf(error_);
        return result == null ? io.bloombox.schema.services.shop.v1.OrderError.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Error, if any.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.OrderError error = 1;</code>
       */
      public Builder setError(io.bloombox.schema.services.shop.v1.OrderError value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        error_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Error, if any.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.OrderError error = 1;</code>
       */
      public Builder clearError() {
        
        error_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object orderId_ = "";
      /**
       * <pre>
       * ID assigned to the new order, if no error occurred.
       * </pre>
       *
       * <code>string order_id = 2;</code>
       */
      public java.lang.String getOrderId() {
        java.lang.Object ref = orderId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          orderId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * ID assigned to the new order, if no error occurred.
       * </pre>
       *
       * <code>string order_id = 2;</code>
       */
      public com.google.protobuf.ByteString
          getOrderIdBytes() {
        java.lang.Object ref = orderId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          orderId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * ID assigned to the new order, if no error occurred.
       * </pre>
       *
       * <code>string order_id = 2;</code>
       */
      public Builder setOrderId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        orderId_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * ID assigned to the new order, if no error occurred.
       * </pre>
       *
       * <code>string order_id = 2;</code>
       */
      public Builder clearOrderId() {
        
        orderId_ = getDefaultInstance().getOrderId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * ID assigned to the new order, if no error occurred.
       * </pre>
       *
       * <code>string order_id = 2;</code>
       */
      public Builder setOrderIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        orderId_ = value;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.shop.v1.SubmitOrder.Response)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.shop.v1.SubmitOrder.Response)
    private static final io.bloombox.schema.services.shop.v1.SubmitOrder.Response DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.shop.v1.SubmitOrder.Response();
    }

    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Response getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Response>
        PARSER = new com.google.protobuf.AbstractParser<Response>() {
      public Response parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Response(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Response> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Response> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.shop.v1.SubmitOrder.Response getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface OperationOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.shop.v1.SubmitOrder.Operation)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Request for order submission.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.SubmitOrder.Request request = 1;</code>
     */
    boolean hasRequest();
    /**
     * <pre>
     * Request for order submission.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.SubmitOrder.Request request = 1;</code>
     */
    io.bloombox.schema.services.shop.v1.SubmitOrder.Request getRequest();
    /**
     * <pre>
     * Request for order submission.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.SubmitOrder.Request request = 1;</code>
     */
    io.bloombox.schema.services.shop.v1.SubmitOrder.RequestOrBuilder getRequestOrBuilder();

    /**
     * <pre>
     * Response from order submission.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.SubmitOrder.Response response = 2;</code>
     */
    boolean hasResponse();
    /**
     * <pre>
     * Response from order submission.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.SubmitOrder.Response response = 2;</code>
     */
    io.bloombox.schema.services.shop.v1.SubmitOrder.Response getResponse();
    /**
     * <pre>
     * Response from order submission.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.SubmitOrder.Response response = 2;</code>
     */
    io.bloombox.schema.services.shop.v1.SubmitOrder.ResponseOrBuilder getResponseOrBuilder();
  }
  /**
   * Protobuf type {@code bloombox.schema.services.shop.v1.SubmitOrder.Operation}
   */
  public  static final class Operation extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.shop.v1.SubmitOrder.Operation)
      OperationOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Operation.newBuilder() to construct.
    private Operation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Operation() {
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Operation(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              io.bloombox.schema.services.shop.v1.SubmitOrder.Request.Builder subBuilder = null;
              if (request_ != null) {
                subBuilder = request_.toBuilder();
              }
              request_ = input.readMessage(io.bloombox.schema.services.shop.v1.SubmitOrder.Request.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(request_);
                request_ = subBuilder.buildPartial();
              }

              break;
            }
            case 18: {
              io.bloombox.schema.services.shop.v1.SubmitOrder.Response.Builder subBuilder = null;
              if (response_ != null) {
                subBuilder = response_.toBuilder();
              }
              response_ = input.readMessage(io.bloombox.schema.services.shop.v1.SubmitOrder.Response.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(response_);
                response_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_SubmitOrder_Operation_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_SubmitOrder_Operation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.shop.v1.SubmitOrder.Operation.class, io.bloombox.schema.services.shop.v1.SubmitOrder.Operation.Builder.class);
    }

    public static final int REQUEST_FIELD_NUMBER = 1;
    private io.bloombox.schema.services.shop.v1.SubmitOrder.Request request_;
    /**
     * <pre>
     * Request for order submission.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.SubmitOrder.Request request = 1;</code>
     */
    public boolean hasRequest() {
      return request_ != null;
    }
    /**
     * <pre>
     * Request for order submission.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.SubmitOrder.Request request = 1;</code>
     */
    public io.bloombox.schema.services.shop.v1.SubmitOrder.Request getRequest() {
      return request_ == null ? io.bloombox.schema.services.shop.v1.SubmitOrder.Request.getDefaultInstance() : request_;
    }
    /**
     * <pre>
     * Request for order submission.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.SubmitOrder.Request request = 1;</code>
     */
    public io.bloombox.schema.services.shop.v1.SubmitOrder.RequestOrBuilder getRequestOrBuilder() {
      return getRequest();
    }

    public static final int RESPONSE_FIELD_NUMBER = 2;
    private io.bloombox.schema.services.shop.v1.SubmitOrder.Response response_;
    /**
     * <pre>
     * Response from order submission.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.SubmitOrder.Response response = 2;</code>
     */
    public boolean hasResponse() {
      return response_ != null;
    }
    /**
     * <pre>
     * Response from order submission.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.SubmitOrder.Response response = 2;</code>
     */
    public io.bloombox.schema.services.shop.v1.SubmitOrder.Response getResponse() {
      return response_ == null ? io.bloombox.schema.services.shop.v1.SubmitOrder.Response.getDefaultInstance() : response_;
    }
    /**
     * <pre>
     * Response from order submission.
     * </pre>
     *
     * <code>.bloombox.schema.services.shop.v1.SubmitOrder.Response response = 2;</code>
     */
    public io.bloombox.schema.services.shop.v1.SubmitOrder.ResponseOrBuilder getResponseOrBuilder() {
      return getResponse();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (request_ != null) {
        output.writeMessage(1, getRequest());
      }
      if (response_ != null) {
        output.writeMessage(2, getResponse());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (request_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getRequest());
      }
      if (response_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getResponse());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.shop.v1.SubmitOrder.Operation)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.shop.v1.SubmitOrder.Operation other = (io.bloombox.schema.services.shop.v1.SubmitOrder.Operation) obj;

      boolean result = true;
      result = result && (hasRequest() == other.hasRequest());
      if (hasRequest()) {
        result = result && getRequest()
            .equals(other.getRequest());
      }
      result = result && (hasResponse() == other.hasResponse());
      if (hasResponse()) {
        result = result && getResponse()
            .equals(other.getResponse());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasRequest()) {
        hash = (37 * hash) + REQUEST_FIELD_NUMBER;
        hash = (53 * hash) + getRequest().hashCode();
      }
      if (hasResponse()) {
        hash = (37 * hash) + RESPONSE_FIELD_NUMBER;
        hash = (53 * hash) + getResponse().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Operation parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Operation parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Operation parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Operation parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Operation parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Operation parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Operation parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Operation parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Operation parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Operation parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Operation parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Operation parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.shop.v1.SubmitOrder.Operation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code bloombox.schema.services.shop.v1.SubmitOrder.Operation}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.shop.v1.SubmitOrder.Operation)
        io.bloombox.schema.services.shop.v1.SubmitOrder.OperationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_SubmitOrder_Operation_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_SubmitOrder_Operation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.shop.v1.SubmitOrder.Operation.class, io.bloombox.schema.services.shop.v1.SubmitOrder.Operation.Builder.class);
      }

      // Construct using io.bloombox.schema.services.shop.v1.SubmitOrder.Operation.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        if (requestBuilder_ == null) {
          request_ = null;
        } else {
          request_ = null;
          requestBuilder_ = null;
        }
        if (responseBuilder_ == null) {
          response_ = null;
        } else {
          response_ = null;
          responseBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_SubmitOrder_Operation_descriptor;
      }

      public io.bloombox.schema.services.shop.v1.SubmitOrder.Operation getDefaultInstanceForType() {
        return io.bloombox.schema.services.shop.v1.SubmitOrder.Operation.getDefaultInstance();
      }

      public io.bloombox.schema.services.shop.v1.SubmitOrder.Operation build() {
        io.bloombox.schema.services.shop.v1.SubmitOrder.Operation result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.shop.v1.SubmitOrder.Operation buildPartial() {
        io.bloombox.schema.services.shop.v1.SubmitOrder.Operation result = new io.bloombox.schema.services.shop.v1.SubmitOrder.Operation(this);
        if (requestBuilder_ == null) {
          result.request_ = request_;
        } else {
          result.request_ = requestBuilder_.build();
        }
        if (responseBuilder_ == null) {
          result.response_ = response_;
        } else {
          result.response_ = responseBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.shop.v1.SubmitOrder.Operation) {
          return mergeFrom((io.bloombox.schema.services.shop.v1.SubmitOrder.Operation)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.shop.v1.SubmitOrder.Operation other) {
        if (other == io.bloombox.schema.services.shop.v1.SubmitOrder.Operation.getDefaultInstance()) return this;
        if (other.hasRequest()) {
          mergeRequest(other.getRequest());
        }
        if (other.hasResponse()) {
          mergeResponse(other.getResponse());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.shop.v1.SubmitOrder.Operation parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.shop.v1.SubmitOrder.Operation) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private io.bloombox.schema.services.shop.v1.SubmitOrder.Request request_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.services.shop.v1.SubmitOrder.Request, io.bloombox.schema.services.shop.v1.SubmitOrder.Request.Builder, io.bloombox.schema.services.shop.v1.SubmitOrder.RequestOrBuilder> requestBuilder_;
      /**
       * <pre>
       * Request for order submission.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.SubmitOrder.Request request = 1;</code>
       */
      public boolean hasRequest() {
        return requestBuilder_ != null || request_ != null;
      }
      /**
       * <pre>
       * Request for order submission.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.SubmitOrder.Request request = 1;</code>
       */
      public io.bloombox.schema.services.shop.v1.SubmitOrder.Request getRequest() {
        if (requestBuilder_ == null) {
          return request_ == null ? io.bloombox.schema.services.shop.v1.SubmitOrder.Request.getDefaultInstance() : request_;
        } else {
          return requestBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Request for order submission.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.SubmitOrder.Request request = 1;</code>
       */
      public Builder setRequest(io.bloombox.schema.services.shop.v1.SubmitOrder.Request value) {
        if (requestBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          request_ = value;
          onChanged();
        } else {
          requestBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Request for order submission.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.SubmitOrder.Request request = 1;</code>
       */
      public Builder setRequest(
          io.bloombox.schema.services.shop.v1.SubmitOrder.Request.Builder builderForValue) {
        if (requestBuilder_ == null) {
          request_ = builderForValue.build();
          onChanged();
        } else {
          requestBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Request for order submission.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.SubmitOrder.Request request = 1;</code>
       */
      public Builder mergeRequest(io.bloombox.schema.services.shop.v1.SubmitOrder.Request value) {
        if (requestBuilder_ == null) {
          if (request_ != null) {
            request_ =
              io.bloombox.schema.services.shop.v1.SubmitOrder.Request.newBuilder(request_).mergeFrom(value).buildPartial();
          } else {
            request_ = value;
          }
          onChanged();
        } else {
          requestBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Request for order submission.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.SubmitOrder.Request request = 1;</code>
       */
      public Builder clearRequest() {
        if (requestBuilder_ == null) {
          request_ = null;
          onChanged();
        } else {
          request_ = null;
          requestBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Request for order submission.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.SubmitOrder.Request request = 1;</code>
       */
      public io.bloombox.schema.services.shop.v1.SubmitOrder.Request.Builder getRequestBuilder() {
        
        onChanged();
        return getRequestFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Request for order submission.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.SubmitOrder.Request request = 1;</code>
       */
      public io.bloombox.schema.services.shop.v1.SubmitOrder.RequestOrBuilder getRequestOrBuilder() {
        if (requestBuilder_ != null) {
          return requestBuilder_.getMessageOrBuilder();
        } else {
          return request_ == null ?
              io.bloombox.schema.services.shop.v1.SubmitOrder.Request.getDefaultInstance() : request_;
        }
      }
      /**
       * <pre>
       * Request for order submission.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.SubmitOrder.Request request = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.services.shop.v1.SubmitOrder.Request, io.bloombox.schema.services.shop.v1.SubmitOrder.Request.Builder, io.bloombox.schema.services.shop.v1.SubmitOrder.RequestOrBuilder> 
          getRequestFieldBuilder() {
        if (requestBuilder_ == null) {
          requestBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.services.shop.v1.SubmitOrder.Request, io.bloombox.schema.services.shop.v1.SubmitOrder.Request.Builder, io.bloombox.schema.services.shop.v1.SubmitOrder.RequestOrBuilder>(
                  getRequest(),
                  getParentForChildren(),
                  isClean());
          request_ = null;
        }
        return requestBuilder_;
      }

      private io.bloombox.schema.services.shop.v1.SubmitOrder.Response response_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.services.shop.v1.SubmitOrder.Response, io.bloombox.schema.services.shop.v1.SubmitOrder.Response.Builder, io.bloombox.schema.services.shop.v1.SubmitOrder.ResponseOrBuilder> responseBuilder_;
      /**
       * <pre>
       * Response from order submission.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.SubmitOrder.Response response = 2;</code>
       */
      public boolean hasResponse() {
        return responseBuilder_ != null || response_ != null;
      }
      /**
       * <pre>
       * Response from order submission.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.SubmitOrder.Response response = 2;</code>
       */
      public io.bloombox.schema.services.shop.v1.SubmitOrder.Response getResponse() {
        if (responseBuilder_ == null) {
          return response_ == null ? io.bloombox.schema.services.shop.v1.SubmitOrder.Response.getDefaultInstance() : response_;
        } else {
          return responseBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Response from order submission.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.SubmitOrder.Response response = 2;</code>
       */
      public Builder setResponse(io.bloombox.schema.services.shop.v1.SubmitOrder.Response value) {
        if (responseBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          response_ = value;
          onChanged();
        } else {
          responseBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Response from order submission.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.SubmitOrder.Response response = 2;</code>
       */
      public Builder setResponse(
          io.bloombox.schema.services.shop.v1.SubmitOrder.Response.Builder builderForValue) {
        if (responseBuilder_ == null) {
          response_ = builderForValue.build();
          onChanged();
        } else {
          responseBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Response from order submission.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.SubmitOrder.Response response = 2;</code>
       */
      public Builder mergeResponse(io.bloombox.schema.services.shop.v1.SubmitOrder.Response value) {
        if (responseBuilder_ == null) {
          if (response_ != null) {
            response_ =
              io.bloombox.schema.services.shop.v1.SubmitOrder.Response.newBuilder(response_).mergeFrom(value).buildPartial();
          } else {
            response_ = value;
          }
          onChanged();
        } else {
          responseBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Response from order submission.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.SubmitOrder.Response response = 2;</code>
       */
      public Builder clearResponse() {
        if (responseBuilder_ == null) {
          response_ = null;
          onChanged();
        } else {
          response_ = null;
          responseBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Response from order submission.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.SubmitOrder.Response response = 2;</code>
       */
      public io.bloombox.schema.services.shop.v1.SubmitOrder.Response.Builder getResponseBuilder() {
        
        onChanged();
        return getResponseFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Response from order submission.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.SubmitOrder.Response response = 2;</code>
       */
      public io.bloombox.schema.services.shop.v1.SubmitOrder.ResponseOrBuilder getResponseOrBuilder() {
        if (responseBuilder_ != null) {
          return responseBuilder_.getMessageOrBuilder();
        } else {
          return response_ == null ?
              io.bloombox.schema.services.shop.v1.SubmitOrder.Response.getDefaultInstance() : response_;
        }
      }
      /**
       * <pre>
       * Response from order submission.
       * </pre>
       *
       * <code>.bloombox.schema.services.shop.v1.SubmitOrder.Response response = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.services.shop.v1.SubmitOrder.Response, io.bloombox.schema.services.shop.v1.SubmitOrder.Response.Builder, io.bloombox.schema.services.shop.v1.SubmitOrder.ResponseOrBuilder> 
          getResponseFieldBuilder() {
        if (responseBuilder_ == null) {
          responseBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.services.shop.v1.SubmitOrder.Response, io.bloombox.schema.services.shop.v1.SubmitOrder.Response.Builder, io.bloombox.schema.services.shop.v1.SubmitOrder.ResponseOrBuilder>(
                  getResponse(),
                  getParentForChildren(),
                  isClean());
          response_ = null;
        }
        return responseBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.shop.v1.SubmitOrder.Operation)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.shop.v1.SubmitOrder.Operation)
    private static final io.bloombox.schema.services.shop.v1.SubmitOrder.Operation DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.shop.v1.SubmitOrder.Operation();
    }

    public static io.bloombox.schema.services.shop.v1.SubmitOrder.Operation getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Operation>
        PARSER = new com.google.protobuf.AbstractParser<Operation>() {
      public Operation parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Operation(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Operation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Operation> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.shop.v1.SubmitOrder.Operation getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.services.shop.v1.SubmitOrder)) {
      return super.equals(obj);
    }
    io.bloombox.schema.services.shop.v1.SubmitOrder other = (io.bloombox.schema.services.shop.v1.SubmitOrder) obj;

    boolean result = true;
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.services.shop.v1.SubmitOrder parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.shop.v1.SubmitOrder parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.shop.v1.SubmitOrder parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.shop.v1.SubmitOrder parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.shop.v1.SubmitOrder parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.shop.v1.SubmitOrder parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.shop.v1.SubmitOrder parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.shop.v1.SubmitOrder parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.shop.v1.SubmitOrder parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.shop.v1.SubmitOrder parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.shop.v1.SubmitOrder parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.shop.v1.SubmitOrder parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.services.shop.v1.SubmitOrder prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies an RPC operation to submit an express pickup or delivery order.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.shop.v1.SubmitOrder}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.services.shop.v1.SubmitOrder)
      io.bloombox.schema.services.shop.v1.SubmitOrderOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_SubmitOrder_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_SubmitOrder_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.shop.v1.SubmitOrder.class, io.bloombox.schema.services.shop.v1.SubmitOrder.Builder.class);
    }

    // Construct using io.bloombox.schema.services.shop.v1.SubmitOrder.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.services.shop.v1.ShopServiceV1.internal_static_bloombox_schema_services_shop_v1_SubmitOrder_descriptor;
    }

    public io.bloombox.schema.services.shop.v1.SubmitOrder getDefaultInstanceForType() {
      return io.bloombox.schema.services.shop.v1.SubmitOrder.getDefaultInstance();
    }

    public io.bloombox.schema.services.shop.v1.SubmitOrder build() {
      io.bloombox.schema.services.shop.v1.SubmitOrder result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.services.shop.v1.SubmitOrder buildPartial() {
      io.bloombox.schema.services.shop.v1.SubmitOrder result = new io.bloombox.schema.services.shop.v1.SubmitOrder(this);
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.services.shop.v1.SubmitOrder) {
        return mergeFrom((io.bloombox.schema.services.shop.v1.SubmitOrder)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.services.shop.v1.SubmitOrder other) {
      if (other == io.bloombox.schema.services.shop.v1.SubmitOrder.getDefaultInstance()) return this;
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.services.shop.v1.SubmitOrder parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.services.shop.v1.SubmitOrder) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.services.shop.v1.SubmitOrder)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.services.shop.v1.SubmitOrder)
  private static final io.bloombox.schema.services.shop.v1.SubmitOrder DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.services.shop.v1.SubmitOrder();
  }

  public static io.bloombox.schema.services.shop.v1.SubmitOrder getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SubmitOrder>
      PARSER = new com.google.protobuf.AbstractParser<SubmitOrder>() {
    public SubmitOrder parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new SubmitOrder(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<SubmitOrder> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SubmitOrder> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.services.shop.v1.SubmitOrder getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

