/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: telemetry/v1beta4/TelemetryService_Beta4.proto

package io.bloombox.schema.services.telemetry.v1beta4;

/**
 * <pre>
 * Specifies events that deal with user-submitted searches, including the query itself, the resultset, and any response
 * the user makes based upon that resultset.
 * </pre>
 *
 * Protobuf type {@code bloombox.schema.services.telemetry.v1beta4.SearchEvent}
 */
public  final class SearchEvent extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:bloombox.schema.services.telemetry.v1beta4.SearchEvent)
    SearchEventOrBuilder {
private static final long serialVersionUID = 0L;
  // Use SearchEvent.newBuilder() to construct.
  private SearchEvent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private SearchEvent() {
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private SearchEvent(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.bloombox.schema.services.telemetry.v1beta4.TelemetryServiceBeta4.internal_static_bloombox_schema_services_telemetry_v1beta4_SearchEvent_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.bloombox.schema.services.telemetry.v1beta4.TelemetryServiceBeta4.internal_static_bloombox_schema_services_telemetry_v1beta4_SearchEvent_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.class, io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Builder.class);
  }

  public interface QueryOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Term string for the search, encoded in Base64.
     * </pre>
     *
     * <code>string term = 1;</code>
     */
    java.lang.String getTerm();
    /**
     * <pre>
     * Term string for the search, encoded in Base64.
     * </pre>
     *
     * <code>string term = 1;</code>
     */
    com.google.protobuf.ByteString
        getTermBytes();

    /**
     * <pre>
     * Event context to specify for this event.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.Context context = 2;</code>
     */
    boolean hasContext();
    /**
     * <pre>
     * Event context to specify for this event.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.Context context = 2;</code>
     */
    io.bloombox.schema.telemetry.AnalyticsContext.Context getContext();
    /**
     * <pre>
     * Event context to specify for this event.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.Context context = 2;</code>
     */
    io.bloombox.schema.telemetry.AnalyticsContext.ContextOrBuilder getContextOrBuilder();

    /**
     * <pre>
     * Digital property from which this search originated.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.search.SearchProperty property = 3;</code>
     */
    int getPropertyValue();
    /**
     * <pre>
     * Digital property from which this search originated.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.search.SearchProperty property = 3;</code>
     */
    io.bloombox.schema.telemetry.search.SearchAnalytics.SearchProperty getProperty();

    /**
     * <pre>
     * Number of results.
     * </pre>
     *
     * <code>uint32 total_results = 4;</code>
     */
    int getTotalResults();
  }
  /**
   * <pre>
   * Event constituting a fulltext search submitted by an end user.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query}
   */
  public  static final class Query extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query)
      QueryOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Query.newBuilder() to construct.
    private Query(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Query() {
      term_ = "";
      property_ = 0;
      totalResults_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Query(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              term_ = s;
              break;
            }
            case 18: {
              io.bloombox.schema.telemetry.AnalyticsContext.Context.Builder subBuilder = null;
              if (context_ != null) {
                subBuilder = context_.toBuilder();
              }
              context_ = input.readMessage(io.bloombox.schema.telemetry.AnalyticsContext.Context.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(context_);
                context_ = subBuilder.buildPartial();
              }

              break;
            }
            case 24: {
              int rawValue = input.readEnum();

              property_ = rawValue;
              break;
            }
            case 32: {

              totalResults_ = input.readUInt32();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.telemetry.v1beta4.TelemetryServiceBeta4.internal_static_bloombox_schema_services_telemetry_v1beta4_SearchEvent_Query_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.telemetry.v1beta4.TelemetryServiceBeta4.internal_static_bloombox_schema_services_telemetry_v1beta4_SearchEvent_Query_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query.class, io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query.Builder.class);
    }

    public static final int TERM_FIELD_NUMBER = 1;
    private volatile java.lang.Object term_;
    /**
     * <pre>
     * Term string for the search, encoded in Base64.
     * </pre>
     *
     * <code>string term = 1;</code>
     */
    public java.lang.String getTerm() {
      java.lang.Object ref = term_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        term_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Term string for the search, encoded in Base64.
     * </pre>
     *
     * <code>string term = 1;</code>
     */
    public com.google.protobuf.ByteString
        getTermBytes() {
      java.lang.Object ref = term_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        term_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CONTEXT_FIELD_NUMBER = 2;
    private io.bloombox.schema.telemetry.AnalyticsContext.Context context_;
    /**
     * <pre>
     * Event context to specify for this event.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.Context context = 2;</code>
     */
    public boolean hasContext() {
      return context_ != null;
    }
    /**
     * <pre>
     * Event context to specify for this event.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.Context context = 2;</code>
     */
    public io.bloombox.schema.telemetry.AnalyticsContext.Context getContext() {
      return context_ == null ? io.bloombox.schema.telemetry.AnalyticsContext.Context.getDefaultInstance() : context_;
    }
    /**
     * <pre>
     * Event context to specify for this event.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.Context context = 2;</code>
     */
    public io.bloombox.schema.telemetry.AnalyticsContext.ContextOrBuilder getContextOrBuilder() {
      return getContext();
    }

    public static final int PROPERTY_FIELD_NUMBER = 3;
    private int property_;
    /**
     * <pre>
     * Digital property from which this search originated.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.search.SearchProperty property = 3;</code>
     */
    public int getPropertyValue() {
      return property_;
    }
    /**
     * <pre>
     * Digital property from which this search originated.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.search.SearchProperty property = 3;</code>
     */
    public io.bloombox.schema.telemetry.search.SearchAnalytics.SearchProperty getProperty() {
      io.bloombox.schema.telemetry.search.SearchAnalytics.SearchProperty result = io.bloombox.schema.telemetry.search.SearchAnalytics.SearchProperty.valueOf(property_);
      return result == null ? io.bloombox.schema.telemetry.search.SearchAnalytics.SearchProperty.UNRECOGNIZED : result;
    }

    public static final int TOTAL_RESULTS_FIELD_NUMBER = 4;
    private int totalResults_;
    /**
     * <pre>
     * Number of results.
     * </pre>
     *
     * <code>uint32 total_results = 4;</code>
     */
    public int getTotalResults() {
      return totalResults_;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getTermBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, term_);
      }
      if (context_ != null) {
        output.writeMessage(2, getContext());
      }
      if (property_ != io.bloombox.schema.telemetry.search.SearchAnalytics.SearchProperty.PROPERTY_UNSPECIFIED.getNumber()) {
        output.writeEnum(3, property_);
      }
      if (totalResults_ != 0) {
        output.writeUInt32(4, totalResults_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getTermBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, term_);
      }
      if (context_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getContext());
      }
      if (property_ != io.bloombox.schema.telemetry.search.SearchAnalytics.SearchProperty.PROPERTY_UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(3, property_);
      }
      if (totalResults_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(4, totalResults_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query other = (io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query) obj;

      boolean result = true;
      result = result && getTerm()
          .equals(other.getTerm());
      result = result && (hasContext() == other.hasContext());
      if (hasContext()) {
        result = result && getContext()
            .equals(other.getContext());
      }
      result = result && property_ == other.property_;
      result = result && (getTotalResults()
          == other.getTotalResults());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TERM_FIELD_NUMBER;
      hash = (53 * hash) + getTerm().hashCode();
      if (hasContext()) {
        hash = (37 * hash) + CONTEXT_FIELD_NUMBER;
        hash = (53 * hash) + getContext().hashCode();
      }
      hash = (37 * hash) + PROPERTY_FIELD_NUMBER;
      hash = (53 * hash) + property_;
      hash = (37 * hash) + TOTAL_RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getTotalResults();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Event constituting a fulltext search submitted by an end user.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query)
        io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.QueryOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.telemetry.v1beta4.TelemetryServiceBeta4.internal_static_bloombox_schema_services_telemetry_v1beta4_SearchEvent_Query_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.telemetry.v1beta4.TelemetryServiceBeta4.internal_static_bloombox_schema_services_telemetry_v1beta4_SearchEvent_Query_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query.class, io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query.Builder.class);
      }

      // Construct using io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        term_ = "";

        if (contextBuilder_ == null) {
          context_ = null;
        } else {
          context_ = null;
          contextBuilder_ = null;
        }
        property_ = 0;

        totalResults_ = 0;

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.telemetry.v1beta4.TelemetryServiceBeta4.internal_static_bloombox_schema_services_telemetry_v1beta4_SearchEvent_Query_descriptor;
      }

      public io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query getDefaultInstanceForType() {
        return io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query.getDefaultInstance();
      }

      public io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query build() {
        io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query buildPartial() {
        io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query result = new io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query(this);
        result.term_ = term_;
        if (contextBuilder_ == null) {
          result.context_ = context_;
        } else {
          result.context_ = contextBuilder_.build();
        }
        result.property_ = property_;
        result.totalResults_ = totalResults_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query) {
          return mergeFrom((io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query other) {
        if (other == io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query.getDefaultInstance()) return this;
        if (!other.getTerm().isEmpty()) {
          term_ = other.term_;
          onChanged();
        }
        if (other.hasContext()) {
          mergeContext(other.getContext());
        }
        if (other.property_ != 0) {
          setPropertyValue(other.getPropertyValue());
        }
        if (other.getTotalResults() != 0) {
          setTotalResults(other.getTotalResults());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object term_ = "";
      /**
       * <pre>
       * Term string for the search, encoded in Base64.
       * </pre>
       *
       * <code>string term = 1;</code>
       */
      public java.lang.String getTerm() {
        java.lang.Object ref = term_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          term_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Term string for the search, encoded in Base64.
       * </pre>
       *
       * <code>string term = 1;</code>
       */
      public com.google.protobuf.ByteString
          getTermBytes() {
        java.lang.Object ref = term_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          term_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Term string for the search, encoded in Base64.
       * </pre>
       *
       * <code>string term = 1;</code>
       */
      public Builder setTerm(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        term_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Term string for the search, encoded in Base64.
       * </pre>
       *
       * <code>string term = 1;</code>
       */
      public Builder clearTerm() {
        
        term_ = getDefaultInstance().getTerm();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Term string for the search, encoded in Base64.
       * </pre>
       *
       * <code>string term = 1;</code>
       */
      public Builder setTermBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        term_ = value;
        onChanged();
        return this;
      }

      private io.bloombox.schema.telemetry.AnalyticsContext.Context context_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.telemetry.AnalyticsContext.Context, io.bloombox.schema.telemetry.AnalyticsContext.Context.Builder, io.bloombox.schema.telemetry.AnalyticsContext.ContextOrBuilder> contextBuilder_;
      /**
       * <pre>
       * Event context to specify for this event.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.Context context = 2;</code>
       */
      public boolean hasContext() {
        return contextBuilder_ != null || context_ != null;
      }
      /**
       * <pre>
       * Event context to specify for this event.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.Context context = 2;</code>
       */
      public io.bloombox.schema.telemetry.AnalyticsContext.Context getContext() {
        if (contextBuilder_ == null) {
          return context_ == null ? io.bloombox.schema.telemetry.AnalyticsContext.Context.getDefaultInstance() : context_;
        } else {
          return contextBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Event context to specify for this event.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.Context context = 2;</code>
       */
      public Builder setContext(io.bloombox.schema.telemetry.AnalyticsContext.Context value) {
        if (contextBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          context_ = value;
          onChanged();
        } else {
          contextBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Event context to specify for this event.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.Context context = 2;</code>
       */
      public Builder setContext(
          io.bloombox.schema.telemetry.AnalyticsContext.Context.Builder builderForValue) {
        if (contextBuilder_ == null) {
          context_ = builderForValue.build();
          onChanged();
        } else {
          contextBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Event context to specify for this event.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.Context context = 2;</code>
       */
      public Builder mergeContext(io.bloombox.schema.telemetry.AnalyticsContext.Context value) {
        if (contextBuilder_ == null) {
          if (context_ != null) {
            context_ =
              io.bloombox.schema.telemetry.AnalyticsContext.Context.newBuilder(context_).mergeFrom(value).buildPartial();
          } else {
            context_ = value;
          }
          onChanged();
        } else {
          contextBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Event context to specify for this event.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.Context context = 2;</code>
       */
      public Builder clearContext() {
        if (contextBuilder_ == null) {
          context_ = null;
          onChanged();
        } else {
          context_ = null;
          contextBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Event context to specify for this event.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.Context context = 2;</code>
       */
      public io.bloombox.schema.telemetry.AnalyticsContext.Context.Builder getContextBuilder() {
        
        onChanged();
        return getContextFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Event context to specify for this event.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.Context context = 2;</code>
       */
      public io.bloombox.schema.telemetry.AnalyticsContext.ContextOrBuilder getContextOrBuilder() {
        if (contextBuilder_ != null) {
          return contextBuilder_.getMessageOrBuilder();
        } else {
          return context_ == null ?
              io.bloombox.schema.telemetry.AnalyticsContext.Context.getDefaultInstance() : context_;
        }
      }
      /**
       * <pre>
       * Event context to specify for this event.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.Context context = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.telemetry.AnalyticsContext.Context, io.bloombox.schema.telemetry.AnalyticsContext.Context.Builder, io.bloombox.schema.telemetry.AnalyticsContext.ContextOrBuilder> 
          getContextFieldBuilder() {
        if (contextBuilder_ == null) {
          contextBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.telemetry.AnalyticsContext.Context, io.bloombox.schema.telemetry.AnalyticsContext.Context.Builder, io.bloombox.schema.telemetry.AnalyticsContext.ContextOrBuilder>(
                  getContext(),
                  getParentForChildren(),
                  isClean());
          context_ = null;
        }
        return contextBuilder_;
      }

      private int property_ = 0;
      /**
       * <pre>
       * Digital property from which this search originated.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.search.SearchProperty property = 3;</code>
       */
      public int getPropertyValue() {
        return property_;
      }
      /**
       * <pre>
       * Digital property from which this search originated.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.search.SearchProperty property = 3;</code>
       */
      public Builder setPropertyValue(int value) {
        property_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Digital property from which this search originated.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.search.SearchProperty property = 3;</code>
       */
      public io.bloombox.schema.telemetry.search.SearchAnalytics.SearchProperty getProperty() {
        io.bloombox.schema.telemetry.search.SearchAnalytics.SearchProperty result = io.bloombox.schema.telemetry.search.SearchAnalytics.SearchProperty.valueOf(property_);
        return result == null ? io.bloombox.schema.telemetry.search.SearchAnalytics.SearchProperty.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Digital property from which this search originated.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.search.SearchProperty property = 3;</code>
       */
      public Builder setProperty(io.bloombox.schema.telemetry.search.SearchAnalytics.SearchProperty value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        property_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Digital property from which this search originated.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.search.SearchProperty property = 3;</code>
       */
      public Builder clearProperty() {
        
        property_ = 0;
        onChanged();
        return this;
      }

      private int totalResults_ ;
      /**
       * <pre>
       * Number of results.
       * </pre>
       *
       * <code>uint32 total_results = 4;</code>
       */
      public int getTotalResults() {
        return totalResults_;
      }
      /**
       * <pre>
       * Number of results.
       * </pre>
       *
       * <code>uint32 total_results = 4;</code>
       */
      public Builder setTotalResults(int value) {
        
        totalResults_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Number of results.
       * </pre>
       *
       * <code>uint32 total_results = 4;</code>
       */
      public Builder clearTotalResults() {
        
        totalResults_ = 0;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query)
    private static final io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query();
    }

    public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Query>
        PARSER = new com.google.protobuf.AbstractParser<Query>() {
      public Query parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Query(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Query> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Query> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Query getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ResultOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Term string for the search, encoded in Base64.
     * </pre>
     *
     * <code>string term = 1;</code>
     */
    java.lang.String getTerm();
    /**
     * <pre>
     * Term string for the search, encoded in Base64.
     * </pre>
     *
     * <code>string term = 1;</code>
     */
    com.google.protobuf.ByteString
        getTermBytes();

    /**
     * <pre>
     * Event context to specify for this event.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.Context context = 2;</code>
     */
    boolean hasContext();
    /**
     * <pre>
     * Event context to specify for this event.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.Context context = 2;</code>
     */
    io.bloombox.schema.telemetry.AnalyticsContext.Context getContext();
    /**
     * <pre>
     * Event context to specify for this event.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.Context context = 2;</code>
     */
    io.bloombox.schema.telemetry.AnalyticsContext.ContextOrBuilder getContextOrBuilder();

    /**
     * <pre>
     * Digital property from which this search originated.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.search.SearchProperty property = 3;</code>
     */
    int getPropertyValue();
    /**
     * <pre>
     * Digital property from which this search originated.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.search.SearchProperty property = 3;</code>
     */
    io.bloombox.schema.telemetry.search.SearchAnalytics.SearchProperty getProperty();

    /**
     * <pre>
     * Number of results.
     * </pre>
     *
     * <code>uint32 total_results = 4;</code>
     */
    int getTotalResults();

    /**
     * <pre>
     * Index of the tapped result in the set.
     * </pre>
     *
     * <code>uint32 selected_result = 5;</code>
     */
    int getSelectedResult();

    /**
     * <pre>
     * Product key that was selected as a result of this tap.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 6;</code>
     */
    boolean hasKey();
    /**
     * <pre>
     * Product key that was selected as a result of this tap.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 6;</code>
     */
    io.opencannabis.schema.base.ProductKey getKey();
    /**
     * <pre>
     * Product key that was selected as a result of this tap.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 6;</code>
     */
    io.opencannabis.schema.base.ProductKeyOrBuilder getKeyOrBuilder();
  }
  /**
   * <pre>
   * Result selection event by a user, after performing a search.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result}
   */
  public  static final class Result extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result)
      ResultOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Result.newBuilder() to construct.
    private Result(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Result() {
      term_ = "";
      property_ = 0;
      totalResults_ = 0;
      selectedResult_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Result(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              term_ = s;
              break;
            }
            case 18: {
              io.bloombox.schema.telemetry.AnalyticsContext.Context.Builder subBuilder = null;
              if (context_ != null) {
                subBuilder = context_.toBuilder();
              }
              context_ = input.readMessage(io.bloombox.schema.telemetry.AnalyticsContext.Context.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(context_);
                context_ = subBuilder.buildPartial();
              }

              break;
            }
            case 24: {
              int rawValue = input.readEnum();

              property_ = rawValue;
              break;
            }
            case 32: {

              totalResults_ = input.readUInt32();
              break;
            }
            case 40: {

              selectedResult_ = input.readUInt32();
              break;
            }
            case 50: {
              io.opencannabis.schema.base.ProductKey.Builder subBuilder = null;
              if (key_ != null) {
                subBuilder = key_.toBuilder();
              }
              key_ = input.readMessage(io.opencannabis.schema.base.ProductKey.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(key_);
                key_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.telemetry.v1beta4.TelemetryServiceBeta4.internal_static_bloombox_schema_services_telemetry_v1beta4_SearchEvent_Result_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.telemetry.v1beta4.TelemetryServiceBeta4.internal_static_bloombox_schema_services_telemetry_v1beta4_SearchEvent_Result_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result.class, io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result.Builder.class);
    }

    public static final int TERM_FIELD_NUMBER = 1;
    private volatile java.lang.Object term_;
    /**
     * <pre>
     * Term string for the search, encoded in Base64.
     * </pre>
     *
     * <code>string term = 1;</code>
     */
    public java.lang.String getTerm() {
      java.lang.Object ref = term_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        term_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Term string for the search, encoded in Base64.
     * </pre>
     *
     * <code>string term = 1;</code>
     */
    public com.google.protobuf.ByteString
        getTermBytes() {
      java.lang.Object ref = term_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        term_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CONTEXT_FIELD_NUMBER = 2;
    private io.bloombox.schema.telemetry.AnalyticsContext.Context context_;
    /**
     * <pre>
     * Event context to specify for this event.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.Context context = 2;</code>
     */
    public boolean hasContext() {
      return context_ != null;
    }
    /**
     * <pre>
     * Event context to specify for this event.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.Context context = 2;</code>
     */
    public io.bloombox.schema.telemetry.AnalyticsContext.Context getContext() {
      return context_ == null ? io.bloombox.schema.telemetry.AnalyticsContext.Context.getDefaultInstance() : context_;
    }
    /**
     * <pre>
     * Event context to specify for this event.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.Context context = 2;</code>
     */
    public io.bloombox.schema.telemetry.AnalyticsContext.ContextOrBuilder getContextOrBuilder() {
      return getContext();
    }

    public static final int PROPERTY_FIELD_NUMBER = 3;
    private int property_;
    /**
     * <pre>
     * Digital property from which this search originated.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.search.SearchProperty property = 3;</code>
     */
    public int getPropertyValue() {
      return property_;
    }
    /**
     * <pre>
     * Digital property from which this search originated.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.search.SearchProperty property = 3;</code>
     */
    public io.bloombox.schema.telemetry.search.SearchAnalytics.SearchProperty getProperty() {
      io.bloombox.schema.telemetry.search.SearchAnalytics.SearchProperty result = io.bloombox.schema.telemetry.search.SearchAnalytics.SearchProperty.valueOf(property_);
      return result == null ? io.bloombox.schema.telemetry.search.SearchAnalytics.SearchProperty.UNRECOGNIZED : result;
    }

    public static final int TOTAL_RESULTS_FIELD_NUMBER = 4;
    private int totalResults_;
    /**
     * <pre>
     * Number of results.
     * </pre>
     *
     * <code>uint32 total_results = 4;</code>
     */
    public int getTotalResults() {
      return totalResults_;
    }

    public static final int SELECTED_RESULT_FIELD_NUMBER = 5;
    private int selectedResult_;
    /**
     * <pre>
     * Index of the tapped result in the set.
     * </pre>
     *
     * <code>uint32 selected_result = 5;</code>
     */
    public int getSelectedResult() {
      return selectedResult_;
    }

    public static final int KEY_FIELD_NUMBER = 6;
    private io.opencannabis.schema.base.ProductKey key_;
    /**
     * <pre>
     * Product key that was selected as a result of this tap.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 6;</code>
     */
    public boolean hasKey() {
      return key_ != null;
    }
    /**
     * <pre>
     * Product key that was selected as a result of this tap.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 6;</code>
     */
    public io.opencannabis.schema.base.ProductKey getKey() {
      return key_ == null ? io.opencannabis.schema.base.ProductKey.getDefaultInstance() : key_;
    }
    /**
     * <pre>
     * Product key that was selected as a result of this tap.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 6;</code>
     */
    public io.opencannabis.schema.base.ProductKeyOrBuilder getKeyOrBuilder() {
      return getKey();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getTermBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, term_);
      }
      if (context_ != null) {
        output.writeMessage(2, getContext());
      }
      if (property_ != io.bloombox.schema.telemetry.search.SearchAnalytics.SearchProperty.PROPERTY_UNSPECIFIED.getNumber()) {
        output.writeEnum(3, property_);
      }
      if (totalResults_ != 0) {
        output.writeUInt32(4, totalResults_);
      }
      if (selectedResult_ != 0) {
        output.writeUInt32(5, selectedResult_);
      }
      if (key_ != null) {
        output.writeMessage(6, getKey());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getTermBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, term_);
      }
      if (context_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getContext());
      }
      if (property_ != io.bloombox.schema.telemetry.search.SearchAnalytics.SearchProperty.PROPERTY_UNSPECIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(3, property_);
      }
      if (totalResults_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(4, totalResults_);
      }
      if (selectedResult_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(5, selectedResult_);
      }
      if (key_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(6, getKey());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result)) {
        return super.equals(obj);
      }
      io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result other = (io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result) obj;

      boolean result = true;
      result = result && getTerm()
          .equals(other.getTerm());
      result = result && (hasContext() == other.hasContext());
      if (hasContext()) {
        result = result && getContext()
            .equals(other.getContext());
      }
      result = result && property_ == other.property_;
      result = result && (getTotalResults()
          == other.getTotalResults());
      result = result && (getSelectedResult()
          == other.getSelectedResult());
      result = result && (hasKey() == other.hasKey());
      if (hasKey()) {
        result = result && getKey()
            .equals(other.getKey());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TERM_FIELD_NUMBER;
      hash = (53 * hash) + getTerm().hashCode();
      if (hasContext()) {
        hash = (37 * hash) + CONTEXT_FIELD_NUMBER;
        hash = (53 * hash) + getContext().hashCode();
      }
      hash = (37 * hash) + PROPERTY_FIELD_NUMBER;
      hash = (53 * hash) + property_;
      hash = (37 * hash) + TOTAL_RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getTotalResults();
      hash = (37 * hash) + SELECTED_RESULT_FIELD_NUMBER;
      hash = (53 * hash) + getSelectedResult();
      if (hasKey()) {
        hash = (37 * hash) + KEY_FIELD_NUMBER;
        hash = (53 * hash) + getKey().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Result selection event by a user, after performing a search.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result)
        io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.ResultOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.services.telemetry.v1beta4.TelemetryServiceBeta4.internal_static_bloombox_schema_services_telemetry_v1beta4_SearchEvent_Result_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.services.telemetry.v1beta4.TelemetryServiceBeta4.internal_static_bloombox_schema_services_telemetry_v1beta4_SearchEvent_Result_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result.class, io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result.Builder.class);
      }

      // Construct using io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        term_ = "";

        if (contextBuilder_ == null) {
          context_ = null;
        } else {
          context_ = null;
          contextBuilder_ = null;
        }
        property_ = 0;

        totalResults_ = 0;

        selectedResult_ = 0;

        if (keyBuilder_ == null) {
          key_ = null;
        } else {
          key_ = null;
          keyBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.services.telemetry.v1beta4.TelemetryServiceBeta4.internal_static_bloombox_schema_services_telemetry_v1beta4_SearchEvent_Result_descriptor;
      }

      public io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result getDefaultInstanceForType() {
        return io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result.getDefaultInstance();
      }

      public io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result build() {
        io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result buildPartial() {
        io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result result = new io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result(this);
        result.term_ = term_;
        if (contextBuilder_ == null) {
          result.context_ = context_;
        } else {
          result.context_ = contextBuilder_.build();
        }
        result.property_ = property_;
        result.totalResults_ = totalResults_;
        result.selectedResult_ = selectedResult_;
        if (keyBuilder_ == null) {
          result.key_ = key_;
        } else {
          result.key_ = keyBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result) {
          return mergeFrom((io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result other) {
        if (other == io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result.getDefaultInstance()) return this;
        if (!other.getTerm().isEmpty()) {
          term_ = other.term_;
          onChanged();
        }
        if (other.hasContext()) {
          mergeContext(other.getContext());
        }
        if (other.property_ != 0) {
          setPropertyValue(other.getPropertyValue());
        }
        if (other.getTotalResults() != 0) {
          setTotalResults(other.getTotalResults());
        }
        if (other.getSelectedResult() != 0) {
          setSelectedResult(other.getSelectedResult());
        }
        if (other.hasKey()) {
          mergeKey(other.getKey());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object term_ = "";
      /**
       * <pre>
       * Term string for the search, encoded in Base64.
       * </pre>
       *
       * <code>string term = 1;</code>
       */
      public java.lang.String getTerm() {
        java.lang.Object ref = term_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          term_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Term string for the search, encoded in Base64.
       * </pre>
       *
       * <code>string term = 1;</code>
       */
      public com.google.protobuf.ByteString
          getTermBytes() {
        java.lang.Object ref = term_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          term_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Term string for the search, encoded in Base64.
       * </pre>
       *
       * <code>string term = 1;</code>
       */
      public Builder setTerm(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        term_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Term string for the search, encoded in Base64.
       * </pre>
       *
       * <code>string term = 1;</code>
       */
      public Builder clearTerm() {
        
        term_ = getDefaultInstance().getTerm();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Term string for the search, encoded in Base64.
       * </pre>
       *
       * <code>string term = 1;</code>
       */
      public Builder setTermBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        term_ = value;
        onChanged();
        return this;
      }

      private io.bloombox.schema.telemetry.AnalyticsContext.Context context_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.telemetry.AnalyticsContext.Context, io.bloombox.schema.telemetry.AnalyticsContext.Context.Builder, io.bloombox.schema.telemetry.AnalyticsContext.ContextOrBuilder> contextBuilder_;
      /**
       * <pre>
       * Event context to specify for this event.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.Context context = 2;</code>
       */
      public boolean hasContext() {
        return contextBuilder_ != null || context_ != null;
      }
      /**
       * <pre>
       * Event context to specify for this event.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.Context context = 2;</code>
       */
      public io.bloombox.schema.telemetry.AnalyticsContext.Context getContext() {
        if (contextBuilder_ == null) {
          return context_ == null ? io.bloombox.schema.telemetry.AnalyticsContext.Context.getDefaultInstance() : context_;
        } else {
          return contextBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Event context to specify for this event.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.Context context = 2;</code>
       */
      public Builder setContext(io.bloombox.schema.telemetry.AnalyticsContext.Context value) {
        if (contextBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          context_ = value;
          onChanged();
        } else {
          contextBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Event context to specify for this event.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.Context context = 2;</code>
       */
      public Builder setContext(
          io.bloombox.schema.telemetry.AnalyticsContext.Context.Builder builderForValue) {
        if (contextBuilder_ == null) {
          context_ = builderForValue.build();
          onChanged();
        } else {
          contextBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Event context to specify for this event.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.Context context = 2;</code>
       */
      public Builder mergeContext(io.bloombox.schema.telemetry.AnalyticsContext.Context value) {
        if (contextBuilder_ == null) {
          if (context_ != null) {
            context_ =
              io.bloombox.schema.telemetry.AnalyticsContext.Context.newBuilder(context_).mergeFrom(value).buildPartial();
          } else {
            context_ = value;
          }
          onChanged();
        } else {
          contextBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Event context to specify for this event.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.Context context = 2;</code>
       */
      public Builder clearContext() {
        if (contextBuilder_ == null) {
          context_ = null;
          onChanged();
        } else {
          context_ = null;
          contextBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Event context to specify for this event.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.Context context = 2;</code>
       */
      public io.bloombox.schema.telemetry.AnalyticsContext.Context.Builder getContextBuilder() {
        
        onChanged();
        return getContextFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Event context to specify for this event.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.Context context = 2;</code>
       */
      public io.bloombox.schema.telemetry.AnalyticsContext.ContextOrBuilder getContextOrBuilder() {
        if (contextBuilder_ != null) {
          return contextBuilder_.getMessageOrBuilder();
        } else {
          return context_ == null ?
              io.bloombox.schema.telemetry.AnalyticsContext.Context.getDefaultInstance() : context_;
        }
      }
      /**
       * <pre>
       * Event context to specify for this event.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.Context context = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.telemetry.AnalyticsContext.Context, io.bloombox.schema.telemetry.AnalyticsContext.Context.Builder, io.bloombox.schema.telemetry.AnalyticsContext.ContextOrBuilder> 
          getContextFieldBuilder() {
        if (contextBuilder_ == null) {
          contextBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.telemetry.AnalyticsContext.Context, io.bloombox.schema.telemetry.AnalyticsContext.Context.Builder, io.bloombox.schema.telemetry.AnalyticsContext.ContextOrBuilder>(
                  getContext(),
                  getParentForChildren(),
                  isClean());
          context_ = null;
        }
        return contextBuilder_;
      }

      private int property_ = 0;
      /**
       * <pre>
       * Digital property from which this search originated.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.search.SearchProperty property = 3;</code>
       */
      public int getPropertyValue() {
        return property_;
      }
      /**
       * <pre>
       * Digital property from which this search originated.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.search.SearchProperty property = 3;</code>
       */
      public Builder setPropertyValue(int value) {
        property_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Digital property from which this search originated.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.search.SearchProperty property = 3;</code>
       */
      public io.bloombox.schema.telemetry.search.SearchAnalytics.SearchProperty getProperty() {
        io.bloombox.schema.telemetry.search.SearchAnalytics.SearchProperty result = io.bloombox.schema.telemetry.search.SearchAnalytics.SearchProperty.valueOf(property_);
        return result == null ? io.bloombox.schema.telemetry.search.SearchAnalytics.SearchProperty.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Digital property from which this search originated.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.search.SearchProperty property = 3;</code>
       */
      public Builder setProperty(io.bloombox.schema.telemetry.search.SearchAnalytics.SearchProperty value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        property_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Digital property from which this search originated.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.search.SearchProperty property = 3;</code>
       */
      public Builder clearProperty() {
        
        property_ = 0;
        onChanged();
        return this;
      }

      private int totalResults_ ;
      /**
       * <pre>
       * Number of results.
       * </pre>
       *
       * <code>uint32 total_results = 4;</code>
       */
      public int getTotalResults() {
        return totalResults_;
      }
      /**
       * <pre>
       * Number of results.
       * </pre>
       *
       * <code>uint32 total_results = 4;</code>
       */
      public Builder setTotalResults(int value) {
        
        totalResults_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Number of results.
       * </pre>
       *
       * <code>uint32 total_results = 4;</code>
       */
      public Builder clearTotalResults() {
        
        totalResults_ = 0;
        onChanged();
        return this;
      }

      private int selectedResult_ ;
      /**
       * <pre>
       * Index of the tapped result in the set.
       * </pre>
       *
       * <code>uint32 selected_result = 5;</code>
       */
      public int getSelectedResult() {
        return selectedResult_;
      }
      /**
       * <pre>
       * Index of the tapped result in the set.
       * </pre>
       *
       * <code>uint32 selected_result = 5;</code>
       */
      public Builder setSelectedResult(int value) {
        
        selectedResult_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Index of the tapped result in the set.
       * </pre>
       *
       * <code>uint32 selected_result = 5;</code>
       */
      public Builder clearSelectedResult() {
        
        selectedResult_ = 0;
        onChanged();
        return this;
      }

      private io.opencannabis.schema.base.ProductKey key_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder> keyBuilder_;
      /**
       * <pre>
       * Product key that was selected as a result of this tap.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 6;</code>
       */
      public boolean hasKey() {
        return keyBuilder_ != null || key_ != null;
      }
      /**
       * <pre>
       * Product key that was selected as a result of this tap.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 6;</code>
       */
      public io.opencannabis.schema.base.ProductKey getKey() {
        if (keyBuilder_ == null) {
          return key_ == null ? io.opencannabis.schema.base.ProductKey.getDefaultInstance() : key_;
        } else {
          return keyBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Product key that was selected as a result of this tap.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 6;</code>
       */
      public Builder setKey(io.opencannabis.schema.base.ProductKey value) {
        if (keyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          key_ = value;
          onChanged();
        } else {
          keyBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Product key that was selected as a result of this tap.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 6;</code>
       */
      public Builder setKey(
          io.opencannabis.schema.base.ProductKey.Builder builderForValue) {
        if (keyBuilder_ == null) {
          key_ = builderForValue.build();
          onChanged();
        } else {
          keyBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Product key that was selected as a result of this tap.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 6;</code>
       */
      public Builder mergeKey(io.opencannabis.schema.base.ProductKey value) {
        if (keyBuilder_ == null) {
          if (key_ != null) {
            key_ =
              io.opencannabis.schema.base.ProductKey.newBuilder(key_).mergeFrom(value).buildPartial();
          } else {
            key_ = value;
          }
          onChanged();
        } else {
          keyBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Product key that was selected as a result of this tap.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 6;</code>
       */
      public Builder clearKey() {
        if (keyBuilder_ == null) {
          key_ = null;
          onChanged();
        } else {
          key_ = null;
          keyBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Product key that was selected as a result of this tap.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 6;</code>
       */
      public io.opencannabis.schema.base.ProductKey.Builder getKeyBuilder() {
        
        onChanged();
        return getKeyFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Product key that was selected as a result of this tap.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 6;</code>
       */
      public io.opencannabis.schema.base.ProductKeyOrBuilder getKeyOrBuilder() {
        if (keyBuilder_ != null) {
          return keyBuilder_.getMessageOrBuilder();
        } else {
          return key_ == null ?
              io.opencannabis.schema.base.ProductKey.getDefaultInstance() : key_;
        }
      }
      /**
       * <pre>
       * Product key that was selected as a result of this tap.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder> 
          getKeyFieldBuilder() {
        if (keyBuilder_ == null) {
          keyBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder>(
                  getKey(),
                  getParentForChildren(),
                  isClean());
          key_ = null;
        }
        return keyBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result)
    private static final io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result();
    }

    public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Result>
        PARSER = new com.google.protobuf.AbstractParser<Result>() {
      public Result parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Result(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Result> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Result> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Result getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.bloombox.schema.services.telemetry.v1beta4.SearchEvent)) {
      return super.equals(obj);
    }
    io.bloombox.schema.services.telemetry.v1beta4.SearchEvent other = (io.bloombox.schema.services.telemetry.v1beta4.SearchEvent) obj;

    boolean result = true;
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.bloombox.schema.services.telemetry.v1beta4.SearchEvent prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies events that deal with user-submitted searches, including the query itself, the resultset, and any response
   * the user makes based upon that resultset.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.services.telemetry.v1beta4.SearchEvent}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:bloombox.schema.services.telemetry.v1beta4.SearchEvent)
      io.bloombox.schema.services.telemetry.v1beta4.SearchEventOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.services.telemetry.v1beta4.TelemetryServiceBeta4.internal_static_bloombox_schema_services_telemetry_v1beta4_SearchEvent_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.services.telemetry.v1beta4.TelemetryServiceBeta4.internal_static_bloombox_schema_services_telemetry_v1beta4_SearchEvent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.class, io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.Builder.class);
    }

    // Construct using io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.bloombox.schema.services.telemetry.v1beta4.TelemetryServiceBeta4.internal_static_bloombox_schema_services_telemetry_v1beta4_SearchEvent_descriptor;
    }

    public io.bloombox.schema.services.telemetry.v1beta4.SearchEvent getDefaultInstanceForType() {
      return io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.getDefaultInstance();
    }

    public io.bloombox.schema.services.telemetry.v1beta4.SearchEvent build() {
      io.bloombox.schema.services.telemetry.v1beta4.SearchEvent result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.bloombox.schema.services.telemetry.v1beta4.SearchEvent buildPartial() {
      io.bloombox.schema.services.telemetry.v1beta4.SearchEvent result = new io.bloombox.schema.services.telemetry.v1beta4.SearchEvent(this);
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.bloombox.schema.services.telemetry.v1beta4.SearchEvent) {
        return mergeFrom((io.bloombox.schema.services.telemetry.v1beta4.SearchEvent)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.bloombox.schema.services.telemetry.v1beta4.SearchEvent other) {
      if (other == io.bloombox.schema.services.telemetry.v1beta4.SearchEvent.getDefaultInstance()) return this;
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.bloombox.schema.services.telemetry.v1beta4.SearchEvent parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.bloombox.schema.services.telemetry.v1beta4.SearchEvent) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:bloombox.schema.services.telemetry.v1beta4.SearchEvent)
  }

  // @@protoc_insertion_point(class_scope:bloombox.schema.services.telemetry.v1beta4.SearchEvent)
  private static final io.bloombox.schema.services.telemetry.v1beta4.SearchEvent DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.bloombox.schema.services.telemetry.v1beta4.SearchEvent();
  }

  public static io.bloombox.schema.services.telemetry.v1beta4.SearchEvent getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SearchEvent>
      PARSER = new com.google.protobuf.AbstractParser<SearchEvent>() {
    public SearchEvent parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new SearchEvent(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<SearchEvent> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SearchEvent> getParserForType() {
    return PARSER;
  }

  public io.bloombox.schema.services.telemetry.v1beta4.SearchEvent getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

