/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: analytics/Context.proto

package io.bloombox.schema.telemetry;

public final class AnalyticsContext {
  private AnalyticsContext() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  public interface EventPositionOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.analytics.EventPosition)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Timestamp describing when this event was ingested by the backend telemetry pipeline.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant ingest = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event was ingested by the backend telemetry pipeline."];</code>
     */
    boolean hasIngest();
    /**
     * <pre>
     * Timestamp describing when this event was ingested by the backend telemetry pipeline.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant ingest = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event was ingested by the backend telemetry pipeline."];</code>
     */
    io.opencannabis.schema.temporal.Instant getIngest();
    /**
     * <pre>
     * Timestamp describing when this event was ingested by the backend telemetry pipeline.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant ingest = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event was ingested by the backend telemetry pipeline."];</code>
     */
    io.opencannabis.schema.temporal.InstantOrBuilder getIngestOrBuilder();

    /**
     * <pre>
     * Timestamp describing when this event occurred, as reported by the submitting device or endpoint.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event occurred, as reported by the submitting device or endpoint."];</code>
     */
    boolean hasOccurred();
    /**
     * <pre>
     * Timestamp describing when this event occurred, as reported by the submitting device or endpoint.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event occurred, as reported by the submitting device or endpoint."];</code>
     */
    io.opencannabis.schema.temporal.Instant getOccurred();
    /**
     * <pre>
     * Timestamp describing when this event occurred, as reported by the submitting device or endpoint.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event occurred, as reported by the submitting device or endpoint."];</code>
     */
    io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder();

    /**
     * <pre>
     * Timestamps describing each instance of this event being processed by the telemetry pipeline.
     * </pre>
     *
     * <code>uint64 processed = 4 [(.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event occurred, as reported by the submitting device or endpoint."];</code>
     */
    long getProcessed();

    /**
     * <pre>
     * Timestamps describing each instance of this event being enriched by the telemetry pipeline.
     * </pre>
     *
     * <code>uint64 enriched = 5 [(.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamps describing each instance of this event being enriched by the telemetry pipeline."];</code>
     */
    long getEnriched();
  }
  /**
   * <pre>
   * Indicates temporal positioning - or, the "when" - for a telemetry event, post-ingest.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.analytics.EventPosition}
   */
  public  static final class EventPosition extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.analytics.EventPosition)
      EventPositionOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use EventPosition.newBuilder() to construct.
    private EventPosition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private EventPosition() {
      processed_ = 0L;
      enriched_ = 0L;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private EventPosition(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 18: {
              io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
              if (ingest_ != null) {
                subBuilder = ingest_.toBuilder();
              }
              ingest_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(ingest_);
                ingest_ = subBuilder.buildPartial();
              }

              break;
            }
            case 26: {
              io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
              if (occurred_ != null) {
                subBuilder = occurred_.toBuilder();
              }
              occurred_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(occurred_);
                occurred_ = subBuilder.buildPartial();
              }

              break;
            }
            case 32: {

              processed_ = input.readUInt64();
              break;
            }
            case 40: {

              enriched_ = input.readUInt64();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.telemetry.AnalyticsContext.internal_static_bloombox_schema_analytics_EventPosition_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.telemetry.AnalyticsContext.internal_static_bloombox_schema_analytics_EventPosition_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.telemetry.AnalyticsContext.EventPosition.class, io.bloombox.schema.telemetry.AnalyticsContext.EventPosition.Builder.class);
    }

    public static final int INGEST_FIELD_NUMBER = 2;
    private io.opencannabis.schema.temporal.Instant ingest_;
    /**
     * <pre>
     * Timestamp describing when this event was ingested by the backend telemetry pipeline.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant ingest = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event was ingested by the backend telemetry pipeline."];</code>
     */
    public boolean hasIngest() {
      return ingest_ != null;
    }
    /**
     * <pre>
     * Timestamp describing when this event was ingested by the backend telemetry pipeline.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant ingest = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event was ingested by the backend telemetry pipeline."];</code>
     */
    public io.opencannabis.schema.temporal.Instant getIngest() {
      return ingest_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : ingest_;
    }
    /**
     * <pre>
     * Timestamp describing when this event was ingested by the backend telemetry pipeline.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant ingest = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event was ingested by the backend telemetry pipeline."];</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getIngestOrBuilder() {
      return getIngest();
    }

    public static final int OCCURRED_FIELD_NUMBER = 3;
    private io.opencannabis.schema.temporal.Instant occurred_;
    /**
     * <pre>
     * Timestamp describing when this event occurred, as reported by the submitting device or endpoint.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event occurred, as reported by the submitting device or endpoint."];</code>
     */
    public boolean hasOccurred() {
      return occurred_ != null;
    }
    /**
     * <pre>
     * Timestamp describing when this event occurred, as reported by the submitting device or endpoint.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event occurred, as reported by the submitting device or endpoint."];</code>
     */
    public io.opencannabis.schema.temporal.Instant getOccurred() {
      return occurred_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
    }
    /**
     * <pre>
     * Timestamp describing when this event occurred, as reported by the submitting device or endpoint.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event occurred, as reported by the submitting device or endpoint."];</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder() {
      return getOccurred();
    }

    public static final int PROCESSED_FIELD_NUMBER = 4;
    private long processed_;
    /**
     * <pre>
     * Timestamps describing each instance of this event being processed by the telemetry pipeline.
     * </pre>
     *
     * <code>uint64 processed = 4 [(.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event occurred, as reported by the submitting device or endpoint."];</code>
     */
    public long getProcessed() {
      return processed_;
    }

    public static final int ENRICHED_FIELD_NUMBER = 5;
    private long enriched_;
    /**
     * <pre>
     * Timestamps describing each instance of this event being enriched by the telemetry pipeline.
     * </pre>
     *
     * <code>uint64 enriched = 5 [(.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamps describing each instance of this event being enriched by the telemetry pipeline."];</code>
     */
    public long getEnriched() {
      return enriched_;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (ingest_ != null) {
        output.writeMessage(2, getIngest());
      }
      if (occurred_ != null) {
        output.writeMessage(3, getOccurred());
      }
      if (processed_ != 0L) {
        output.writeUInt64(4, processed_);
      }
      if (enriched_ != 0L) {
        output.writeUInt64(5, enriched_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (ingest_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getIngest());
      }
      if (occurred_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getOccurred());
      }
      if (processed_ != 0L) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(4, processed_);
      }
      if (enriched_ != 0L) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(5, enriched_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.telemetry.AnalyticsContext.EventPosition)) {
        return super.equals(obj);
      }
      io.bloombox.schema.telemetry.AnalyticsContext.EventPosition other = (io.bloombox.schema.telemetry.AnalyticsContext.EventPosition) obj;

      boolean result = true;
      result = result && (hasIngest() == other.hasIngest());
      if (hasIngest()) {
        result = result && getIngest()
            .equals(other.getIngest());
      }
      result = result && (hasOccurred() == other.hasOccurred());
      if (hasOccurred()) {
        result = result && getOccurred()
            .equals(other.getOccurred());
      }
      result = result && (getProcessed()
          == other.getProcessed());
      result = result && (getEnriched()
          == other.getEnriched());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasIngest()) {
        hash = (37 * hash) + INGEST_FIELD_NUMBER;
        hash = (53 * hash) + getIngest().hashCode();
      }
      if (hasOccurred()) {
        hash = (37 * hash) + OCCURRED_FIELD_NUMBER;
        hash = (53 * hash) + getOccurred().hashCode();
      }
      hash = (37 * hash) + PROCESSED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getProcessed());
      hash = (37 * hash) + ENRICHED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getEnriched());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.telemetry.AnalyticsContext.EventPosition parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.AnalyticsContext.EventPosition parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.AnalyticsContext.EventPosition parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.AnalyticsContext.EventPosition parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.AnalyticsContext.EventPosition parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.AnalyticsContext.EventPosition parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.AnalyticsContext.EventPosition parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.AnalyticsContext.EventPosition parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.AnalyticsContext.EventPosition parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.AnalyticsContext.EventPosition parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.AnalyticsContext.EventPosition parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.AnalyticsContext.EventPosition parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.telemetry.AnalyticsContext.EventPosition prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Indicates temporal positioning - or, the "when" - for a telemetry event, post-ingest.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.analytics.EventPosition}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.analytics.EventPosition)
        io.bloombox.schema.telemetry.AnalyticsContext.EventPositionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.telemetry.AnalyticsContext.internal_static_bloombox_schema_analytics_EventPosition_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.telemetry.AnalyticsContext.internal_static_bloombox_schema_analytics_EventPosition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.telemetry.AnalyticsContext.EventPosition.class, io.bloombox.schema.telemetry.AnalyticsContext.EventPosition.Builder.class);
      }

      // Construct using io.bloombox.schema.telemetry.AnalyticsContext.EventPosition.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        if (ingestBuilder_ == null) {
          ingest_ = null;
        } else {
          ingest_ = null;
          ingestBuilder_ = null;
        }
        if (occurredBuilder_ == null) {
          occurred_ = null;
        } else {
          occurred_ = null;
          occurredBuilder_ = null;
        }
        processed_ = 0L;

        enriched_ = 0L;

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.telemetry.AnalyticsContext.internal_static_bloombox_schema_analytics_EventPosition_descriptor;
      }

      public io.bloombox.schema.telemetry.AnalyticsContext.EventPosition getDefaultInstanceForType() {
        return io.bloombox.schema.telemetry.AnalyticsContext.EventPosition.getDefaultInstance();
      }

      public io.bloombox.schema.telemetry.AnalyticsContext.EventPosition build() {
        io.bloombox.schema.telemetry.AnalyticsContext.EventPosition result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.telemetry.AnalyticsContext.EventPosition buildPartial() {
        io.bloombox.schema.telemetry.AnalyticsContext.EventPosition result = new io.bloombox.schema.telemetry.AnalyticsContext.EventPosition(this);
        if (ingestBuilder_ == null) {
          result.ingest_ = ingest_;
        } else {
          result.ingest_ = ingestBuilder_.build();
        }
        if (occurredBuilder_ == null) {
          result.occurred_ = occurred_;
        } else {
          result.occurred_ = occurredBuilder_.build();
        }
        result.processed_ = processed_;
        result.enriched_ = enriched_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.telemetry.AnalyticsContext.EventPosition) {
          return mergeFrom((io.bloombox.schema.telemetry.AnalyticsContext.EventPosition)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.telemetry.AnalyticsContext.EventPosition other) {
        if (other == io.bloombox.schema.telemetry.AnalyticsContext.EventPosition.getDefaultInstance()) return this;
        if (other.hasIngest()) {
          mergeIngest(other.getIngest());
        }
        if (other.hasOccurred()) {
          mergeOccurred(other.getOccurred());
        }
        if (other.getProcessed() != 0L) {
          setProcessed(other.getProcessed());
        }
        if (other.getEnriched() != 0L) {
          setEnriched(other.getEnriched());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.telemetry.AnalyticsContext.EventPosition parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.telemetry.AnalyticsContext.EventPosition) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private io.opencannabis.schema.temporal.Instant ingest_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> ingestBuilder_;
      /**
       * <pre>
       * Timestamp describing when this event was ingested by the backend telemetry pipeline.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant ingest = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event was ingested by the backend telemetry pipeline."];</code>
       */
      public boolean hasIngest() {
        return ingestBuilder_ != null || ingest_ != null;
      }
      /**
       * <pre>
       * Timestamp describing when this event was ingested by the backend telemetry pipeline.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant ingest = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event was ingested by the backend telemetry pipeline."];</code>
       */
      public io.opencannabis.schema.temporal.Instant getIngest() {
        if (ingestBuilder_ == null) {
          return ingest_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : ingest_;
        } else {
          return ingestBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Timestamp describing when this event was ingested by the backend telemetry pipeline.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant ingest = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event was ingested by the backend telemetry pipeline."];</code>
       */
      public Builder setIngest(io.opencannabis.schema.temporal.Instant value) {
        if (ingestBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ingest_ = value;
          onChanged();
        } else {
          ingestBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp describing when this event was ingested by the backend telemetry pipeline.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant ingest = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event was ingested by the backend telemetry pipeline."];</code>
       */
      public Builder setIngest(
          io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
        if (ingestBuilder_ == null) {
          ingest_ = builderForValue.build();
          onChanged();
        } else {
          ingestBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp describing when this event was ingested by the backend telemetry pipeline.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant ingest = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event was ingested by the backend telemetry pipeline."];</code>
       */
      public Builder mergeIngest(io.opencannabis.schema.temporal.Instant value) {
        if (ingestBuilder_ == null) {
          if (ingest_ != null) {
            ingest_ =
              io.opencannabis.schema.temporal.Instant.newBuilder(ingest_).mergeFrom(value).buildPartial();
          } else {
            ingest_ = value;
          }
          onChanged();
        } else {
          ingestBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp describing when this event was ingested by the backend telemetry pipeline.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant ingest = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event was ingested by the backend telemetry pipeline."];</code>
       */
      public Builder clearIngest() {
        if (ingestBuilder_ == null) {
          ingest_ = null;
          onChanged();
        } else {
          ingest_ = null;
          ingestBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp describing when this event was ingested by the backend telemetry pipeline.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant ingest = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event was ingested by the backend telemetry pipeline."];</code>
       */
      public io.opencannabis.schema.temporal.Instant.Builder getIngestBuilder() {
        
        onChanged();
        return getIngestFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Timestamp describing when this event was ingested by the backend telemetry pipeline.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant ingest = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event was ingested by the backend telemetry pipeline."];</code>
       */
      public io.opencannabis.schema.temporal.InstantOrBuilder getIngestOrBuilder() {
        if (ingestBuilder_ != null) {
          return ingestBuilder_.getMessageOrBuilder();
        } else {
          return ingest_ == null ?
              io.opencannabis.schema.temporal.Instant.getDefaultInstance() : ingest_;
        }
      }
      /**
       * <pre>
       * Timestamp describing when this event was ingested by the backend telemetry pipeline.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant ingest = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event was ingested by the backend telemetry pipeline."];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
          getIngestFieldBuilder() {
        if (ingestBuilder_ == null) {
          ingestBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                  getIngest(),
                  getParentForChildren(),
                  isClean());
          ingest_ = null;
        }
        return ingestBuilder_;
      }

      private io.opencannabis.schema.temporal.Instant occurred_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> occurredBuilder_;
      /**
       * <pre>
       * Timestamp describing when this event occurred, as reported by the submitting device or endpoint.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event occurred, as reported by the submitting device or endpoint."];</code>
       */
      public boolean hasOccurred() {
        return occurredBuilder_ != null || occurred_ != null;
      }
      /**
       * <pre>
       * Timestamp describing when this event occurred, as reported by the submitting device or endpoint.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event occurred, as reported by the submitting device or endpoint."];</code>
       */
      public io.opencannabis.schema.temporal.Instant getOccurred() {
        if (occurredBuilder_ == null) {
          return occurred_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
        } else {
          return occurredBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Timestamp describing when this event occurred, as reported by the submitting device or endpoint.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event occurred, as reported by the submitting device or endpoint."];</code>
       */
      public Builder setOccurred(io.opencannabis.schema.temporal.Instant value) {
        if (occurredBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          occurred_ = value;
          onChanged();
        } else {
          occurredBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp describing when this event occurred, as reported by the submitting device or endpoint.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event occurred, as reported by the submitting device or endpoint."];</code>
       */
      public Builder setOccurred(
          io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
        if (occurredBuilder_ == null) {
          occurred_ = builderForValue.build();
          onChanged();
        } else {
          occurredBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp describing when this event occurred, as reported by the submitting device or endpoint.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event occurred, as reported by the submitting device or endpoint."];</code>
       */
      public Builder mergeOccurred(io.opencannabis.schema.temporal.Instant value) {
        if (occurredBuilder_ == null) {
          if (occurred_ != null) {
            occurred_ =
              io.opencannabis.schema.temporal.Instant.newBuilder(occurred_).mergeFrom(value).buildPartial();
          } else {
            occurred_ = value;
          }
          onChanged();
        } else {
          occurredBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp describing when this event occurred, as reported by the submitting device or endpoint.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event occurred, as reported by the submitting device or endpoint."];</code>
       */
      public Builder clearOccurred() {
        if (occurredBuilder_ == null) {
          occurred_ = null;
          onChanged();
        } else {
          occurred_ = null;
          occurredBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp describing when this event occurred, as reported by the submitting device or endpoint.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event occurred, as reported by the submitting device or endpoint."];</code>
       */
      public io.opencannabis.schema.temporal.Instant.Builder getOccurredBuilder() {
        
        onChanged();
        return getOccurredFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Timestamp describing when this event occurred, as reported by the submitting device or endpoint.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event occurred, as reported by the submitting device or endpoint."];</code>
       */
      public io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder() {
        if (occurredBuilder_ != null) {
          return occurredBuilder_.getMessageOrBuilder();
        } else {
          return occurred_ == null ?
              io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
        }
      }
      /**
       * <pre>
       * Timestamp describing when this event occurred, as reported by the submitting device or endpoint.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event occurred, as reported by the submitting device or endpoint."];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
          getOccurredFieldBuilder() {
        if (occurredBuilder_ == null) {
          occurredBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                  getOccurred(),
                  getParentForChildren(),
                  isClean());
          occurred_ = null;
        }
        return occurredBuilder_;
      }

      private long processed_ ;
      /**
       * <pre>
       * Timestamps describing each instance of this event being processed by the telemetry pipeline.
       * </pre>
       *
       * <code>uint64 processed = 4 [(.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event occurred, as reported by the submitting device or endpoint."];</code>
       */
      public long getProcessed() {
        return processed_;
      }
      /**
       * <pre>
       * Timestamps describing each instance of this event being processed by the telemetry pipeline.
       * </pre>
       *
       * <code>uint64 processed = 4 [(.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event occurred, as reported by the submitting device or endpoint."];</code>
       */
      public Builder setProcessed(long value) {
        
        processed_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Timestamps describing each instance of this event being processed by the telemetry pipeline.
       * </pre>
       *
       * <code>uint64 processed = 4 [(.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamp describing when this event occurred, as reported by the submitting device or endpoint."];</code>
       */
      public Builder clearProcessed() {
        
        processed_ = 0L;
        onChanged();
        return this;
      }

      private long enriched_ ;
      /**
       * <pre>
       * Timestamps describing each instance of this event being enriched by the telemetry pipeline.
       * </pre>
       *
       * <code>uint64 enriched = 5 [(.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamps describing each instance of this event being enriched by the telemetry pipeline."];</code>
       */
      public long getEnriched() {
        return enriched_;
      }
      /**
       * <pre>
       * Timestamps describing each instance of this event being enriched by the telemetry pipeline.
       * </pre>
       *
       * <code>uint64 enriched = 5 [(.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamps describing each instance of this event being enriched by the telemetry pipeline."];</code>
       */
      public Builder setEnriched(long value) {
        
        enriched_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Timestamps describing each instance of this event being enriched by the telemetry pipeline.
       * </pre>
       *
       * <code>uint64 enriched = 5 [(.gen_bq_schema.type_override) = "TIMESTAMP", (.gen_bq_schema.description) = "Timestamps describing each instance of this event being enriched by the telemetry pipeline."];</code>
       */
      public Builder clearEnriched() {
        
        enriched_ = 0L;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.analytics.EventPosition)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.analytics.EventPosition)
    private static final io.bloombox.schema.telemetry.AnalyticsContext.EventPosition DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.telemetry.AnalyticsContext.EventPosition();
    }

    public static io.bloombox.schema.telemetry.AnalyticsContext.EventPosition getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<EventPosition>
        PARSER = new com.google.protobuf.AbstractParser<EventPosition>() {
      public EventPosition parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new EventPosition(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<EventPosition> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<EventPosition> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.telemetry.AnalyticsContext.EventPosition getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface EventActorsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.analytics.EventActors)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * User account that was logged in when the event was submitted.
     * </pre>
     *
     * <code>.bloombox.schema.identity.User user = 1 [(.gen_bq_schema.description) = "User account that was logged in when the event was submitted."];</code>
     */
    boolean hasUser();
    /**
     * <pre>
     * User account that was logged in when the event was submitted.
     * </pre>
     *
     * <code>.bloombox.schema.identity.User user = 1 [(.gen_bq_schema.description) = "User account that was logged in when the event was submitted."];</code>
     */
    io.bloombox.schema.identity.User getUser();
    /**
     * <pre>
     * User account that was logged in when the event was submitted.
     * </pre>
     *
     * <code>.bloombox.schema.identity.User user = 1 [(.gen_bq_schema.description) = "User account that was logged in when the event was submitted."];</code>
     */
    io.bloombox.schema.identity.UserOrBuilder getUserOrBuilder();

    /**
     * <pre>
     * Partner account under which the event was submitted.
     * </pre>
     *
     * <code>.bloombox.schema.partner.Partner partner = 2 [(.gen_bq_schema.description) = "Partner account under which the event was submitted."];</code>
     */
    boolean hasPartner();
    /**
     * <pre>
     * Partner account under which the event was submitted.
     * </pre>
     *
     * <code>.bloombox.schema.partner.Partner partner = 2 [(.gen_bq_schema.description) = "Partner account under which the event was submitted."];</code>
     */
    io.bloombox.schema.partner.Partner getPartner();
    /**
     * <pre>
     * Partner account under which the event was submitted.
     * </pre>
     *
     * <code>.bloombox.schema.partner.Partner partner = 2 [(.gen_bq_schema.description) = "Partner account under which the event was submitted."];</code>
     */
    io.bloombox.schema.partner.PartnerOrBuilder getPartnerOrBuilder();

    /**
     * <pre>
     * Location account under which this event was submitted.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerLocation location = 3 [(.gen_bq_schema.description) = "Location account under which this event was submitted."];</code>
     */
    boolean hasLocation();
    /**
     * <pre>
     * Location account under which this event was submitted.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerLocation location = 3 [(.gen_bq_schema.description) = "Location account under which this event was submitted."];</code>
     */
    io.bloombox.schema.partner.PartnerLocation getLocation();
    /**
     * <pre>
     * Location account under which this event was submitted.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerLocation location = 3 [(.gen_bq_schema.description) = "Location account under which this event was submitted."];</code>
     */
    io.bloombox.schema.partner.PartnerLocationOrBuilder getLocationOrBuilder();
  }
  /**
   * <pre>
   * Specifies full, inflated data records for contextually-related objects, w.r.t. the current event.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.analytics.EventActors}
   */
  public  static final class EventActors extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.analytics.EventActors)
      EventActorsOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use EventActors.newBuilder() to construct.
    private EventActors(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private EventActors() {
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private EventActors(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              io.bloombox.schema.identity.User.Builder subBuilder = null;
              if (user_ != null) {
                subBuilder = user_.toBuilder();
              }
              user_ = input.readMessage(io.bloombox.schema.identity.User.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(user_);
                user_ = subBuilder.buildPartial();
              }

              break;
            }
            case 18: {
              io.bloombox.schema.partner.Partner.Builder subBuilder = null;
              if (partner_ != null) {
                subBuilder = partner_.toBuilder();
              }
              partner_ = input.readMessage(io.bloombox.schema.partner.Partner.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(partner_);
                partner_ = subBuilder.buildPartial();
              }

              break;
            }
            case 26: {
              io.bloombox.schema.partner.PartnerLocation.Builder subBuilder = null;
              if (location_ != null) {
                subBuilder = location_.toBuilder();
              }
              location_ = input.readMessage(io.bloombox.schema.partner.PartnerLocation.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(location_);
                location_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.telemetry.AnalyticsContext.internal_static_bloombox_schema_analytics_EventActors_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.telemetry.AnalyticsContext.internal_static_bloombox_schema_analytics_EventActors_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.telemetry.AnalyticsContext.EventActors.class, io.bloombox.schema.telemetry.AnalyticsContext.EventActors.Builder.class);
    }

    public static final int USER_FIELD_NUMBER = 1;
    private io.bloombox.schema.identity.User user_;
    /**
     * <pre>
     * User account that was logged in when the event was submitted.
     * </pre>
     *
     * <code>.bloombox.schema.identity.User user = 1 [(.gen_bq_schema.description) = "User account that was logged in when the event was submitted."];</code>
     */
    public boolean hasUser() {
      return user_ != null;
    }
    /**
     * <pre>
     * User account that was logged in when the event was submitted.
     * </pre>
     *
     * <code>.bloombox.schema.identity.User user = 1 [(.gen_bq_schema.description) = "User account that was logged in when the event was submitted."];</code>
     */
    public io.bloombox.schema.identity.User getUser() {
      return user_ == null ? io.bloombox.schema.identity.User.getDefaultInstance() : user_;
    }
    /**
     * <pre>
     * User account that was logged in when the event was submitted.
     * </pre>
     *
     * <code>.bloombox.schema.identity.User user = 1 [(.gen_bq_schema.description) = "User account that was logged in when the event was submitted."];</code>
     */
    public io.bloombox.schema.identity.UserOrBuilder getUserOrBuilder() {
      return getUser();
    }

    public static final int PARTNER_FIELD_NUMBER = 2;
    private io.bloombox.schema.partner.Partner partner_;
    /**
     * <pre>
     * Partner account under which the event was submitted.
     * </pre>
     *
     * <code>.bloombox.schema.partner.Partner partner = 2 [(.gen_bq_schema.description) = "Partner account under which the event was submitted."];</code>
     */
    public boolean hasPartner() {
      return partner_ != null;
    }
    /**
     * <pre>
     * Partner account under which the event was submitted.
     * </pre>
     *
     * <code>.bloombox.schema.partner.Partner partner = 2 [(.gen_bq_schema.description) = "Partner account under which the event was submitted."];</code>
     */
    public io.bloombox.schema.partner.Partner getPartner() {
      return partner_ == null ? io.bloombox.schema.partner.Partner.getDefaultInstance() : partner_;
    }
    /**
     * <pre>
     * Partner account under which the event was submitted.
     * </pre>
     *
     * <code>.bloombox.schema.partner.Partner partner = 2 [(.gen_bq_schema.description) = "Partner account under which the event was submitted."];</code>
     */
    public io.bloombox.schema.partner.PartnerOrBuilder getPartnerOrBuilder() {
      return getPartner();
    }

    public static final int LOCATION_FIELD_NUMBER = 3;
    private io.bloombox.schema.partner.PartnerLocation location_;
    /**
     * <pre>
     * Location account under which this event was submitted.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerLocation location = 3 [(.gen_bq_schema.description) = "Location account under which this event was submitted."];</code>
     */
    public boolean hasLocation() {
      return location_ != null;
    }
    /**
     * <pre>
     * Location account under which this event was submitted.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerLocation location = 3 [(.gen_bq_schema.description) = "Location account under which this event was submitted."];</code>
     */
    public io.bloombox.schema.partner.PartnerLocation getLocation() {
      return location_ == null ? io.bloombox.schema.partner.PartnerLocation.getDefaultInstance() : location_;
    }
    /**
     * <pre>
     * Location account under which this event was submitted.
     * </pre>
     *
     * <code>.bloombox.schema.partner.PartnerLocation location = 3 [(.gen_bq_schema.description) = "Location account under which this event was submitted."];</code>
     */
    public io.bloombox.schema.partner.PartnerLocationOrBuilder getLocationOrBuilder() {
      return getLocation();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (user_ != null) {
        output.writeMessage(1, getUser());
      }
      if (partner_ != null) {
        output.writeMessage(2, getPartner());
      }
      if (location_ != null) {
        output.writeMessage(3, getLocation());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (user_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getUser());
      }
      if (partner_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getPartner());
      }
      if (location_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getLocation());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.telemetry.AnalyticsContext.EventActors)) {
        return super.equals(obj);
      }
      io.bloombox.schema.telemetry.AnalyticsContext.EventActors other = (io.bloombox.schema.telemetry.AnalyticsContext.EventActors) obj;

      boolean result = true;
      result = result && (hasUser() == other.hasUser());
      if (hasUser()) {
        result = result && getUser()
            .equals(other.getUser());
      }
      result = result && (hasPartner() == other.hasPartner());
      if (hasPartner()) {
        result = result && getPartner()
            .equals(other.getPartner());
      }
      result = result && (hasLocation() == other.hasLocation());
      if (hasLocation()) {
        result = result && getLocation()
            .equals(other.getLocation());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasUser()) {
        hash = (37 * hash) + USER_FIELD_NUMBER;
        hash = (53 * hash) + getUser().hashCode();
      }
      if (hasPartner()) {
        hash = (37 * hash) + PARTNER_FIELD_NUMBER;
        hash = (53 * hash) + getPartner().hashCode();
      }
      if (hasLocation()) {
        hash = (37 * hash) + LOCATION_FIELD_NUMBER;
        hash = (53 * hash) + getLocation().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.telemetry.AnalyticsContext.EventActors parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.AnalyticsContext.EventActors parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.AnalyticsContext.EventActors parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.AnalyticsContext.EventActors parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.AnalyticsContext.EventActors parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.AnalyticsContext.EventActors parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.AnalyticsContext.EventActors parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.AnalyticsContext.EventActors parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.AnalyticsContext.EventActors parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.AnalyticsContext.EventActors parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.AnalyticsContext.EventActors parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.AnalyticsContext.EventActors parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.telemetry.AnalyticsContext.EventActors prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies full, inflated data records for contextually-related objects, w.r.t. the current event.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.analytics.EventActors}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.analytics.EventActors)
        io.bloombox.schema.telemetry.AnalyticsContext.EventActorsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.telemetry.AnalyticsContext.internal_static_bloombox_schema_analytics_EventActors_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.telemetry.AnalyticsContext.internal_static_bloombox_schema_analytics_EventActors_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.telemetry.AnalyticsContext.EventActors.class, io.bloombox.schema.telemetry.AnalyticsContext.EventActors.Builder.class);
      }

      // Construct using io.bloombox.schema.telemetry.AnalyticsContext.EventActors.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        if (userBuilder_ == null) {
          user_ = null;
        } else {
          user_ = null;
          userBuilder_ = null;
        }
        if (partnerBuilder_ == null) {
          partner_ = null;
        } else {
          partner_ = null;
          partnerBuilder_ = null;
        }
        if (locationBuilder_ == null) {
          location_ = null;
        } else {
          location_ = null;
          locationBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.telemetry.AnalyticsContext.internal_static_bloombox_schema_analytics_EventActors_descriptor;
      }

      public io.bloombox.schema.telemetry.AnalyticsContext.EventActors getDefaultInstanceForType() {
        return io.bloombox.schema.telemetry.AnalyticsContext.EventActors.getDefaultInstance();
      }

      public io.bloombox.schema.telemetry.AnalyticsContext.EventActors build() {
        io.bloombox.schema.telemetry.AnalyticsContext.EventActors result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.telemetry.AnalyticsContext.EventActors buildPartial() {
        io.bloombox.schema.telemetry.AnalyticsContext.EventActors result = new io.bloombox.schema.telemetry.AnalyticsContext.EventActors(this);
        if (userBuilder_ == null) {
          result.user_ = user_;
        } else {
          result.user_ = userBuilder_.build();
        }
        if (partnerBuilder_ == null) {
          result.partner_ = partner_;
        } else {
          result.partner_ = partnerBuilder_.build();
        }
        if (locationBuilder_ == null) {
          result.location_ = location_;
        } else {
          result.location_ = locationBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.telemetry.AnalyticsContext.EventActors) {
          return mergeFrom((io.bloombox.schema.telemetry.AnalyticsContext.EventActors)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.telemetry.AnalyticsContext.EventActors other) {
        if (other == io.bloombox.schema.telemetry.AnalyticsContext.EventActors.getDefaultInstance()) return this;
        if (other.hasUser()) {
          mergeUser(other.getUser());
        }
        if (other.hasPartner()) {
          mergePartner(other.getPartner());
        }
        if (other.hasLocation()) {
          mergeLocation(other.getLocation());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.telemetry.AnalyticsContext.EventActors parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.telemetry.AnalyticsContext.EventActors) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private io.bloombox.schema.identity.User user_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.identity.User, io.bloombox.schema.identity.User.Builder, io.bloombox.schema.identity.UserOrBuilder> userBuilder_;
      /**
       * <pre>
       * User account that was logged in when the event was submitted.
       * </pre>
       *
       * <code>.bloombox.schema.identity.User user = 1 [(.gen_bq_schema.description) = "User account that was logged in when the event was submitted."];</code>
       */
      public boolean hasUser() {
        return userBuilder_ != null || user_ != null;
      }
      /**
       * <pre>
       * User account that was logged in when the event was submitted.
       * </pre>
       *
       * <code>.bloombox.schema.identity.User user = 1 [(.gen_bq_schema.description) = "User account that was logged in when the event was submitted."];</code>
       */
      public io.bloombox.schema.identity.User getUser() {
        if (userBuilder_ == null) {
          return user_ == null ? io.bloombox.schema.identity.User.getDefaultInstance() : user_;
        } else {
          return userBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * User account that was logged in when the event was submitted.
       * </pre>
       *
       * <code>.bloombox.schema.identity.User user = 1 [(.gen_bq_schema.description) = "User account that was logged in when the event was submitted."];</code>
       */
      public Builder setUser(io.bloombox.schema.identity.User value) {
        if (userBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          user_ = value;
          onChanged();
        } else {
          userBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * User account that was logged in when the event was submitted.
       * </pre>
       *
       * <code>.bloombox.schema.identity.User user = 1 [(.gen_bq_schema.description) = "User account that was logged in when the event was submitted."];</code>
       */
      public Builder setUser(
          io.bloombox.schema.identity.User.Builder builderForValue) {
        if (userBuilder_ == null) {
          user_ = builderForValue.build();
          onChanged();
        } else {
          userBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * User account that was logged in when the event was submitted.
       * </pre>
       *
       * <code>.bloombox.schema.identity.User user = 1 [(.gen_bq_schema.description) = "User account that was logged in when the event was submitted."];</code>
       */
      public Builder mergeUser(io.bloombox.schema.identity.User value) {
        if (userBuilder_ == null) {
          if (user_ != null) {
            user_ =
              io.bloombox.schema.identity.User.newBuilder(user_).mergeFrom(value).buildPartial();
          } else {
            user_ = value;
          }
          onChanged();
        } else {
          userBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * User account that was logged in when the event was submitted.
       * </pre>
       *
       * <code>.bloombox.schema.identity.User user = 1 [(.gen_bq_schema.description) = "User account that was logged in when the event was submitted."];</code>
       */
      public Builder clearUser() {
        if (userBuilder_ == null) {
          user_ = null;
          onChanged();
        } else {
          user_ = null;
          userBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * User account that was logged in when the event was submitted.
       * </pre>
       *
       * <code>.bloombox.schema.identity.User user = 1 [(.gen_bq_schema.description) = "User account that was logged in when the event was submitted."];</code>
       */
      public io.bloombox.schema.identity.User.Builder getUserBuilder() {
        
        onChanged();
        return getUserFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * User account that was logged in when the event was submitted.
       * </pre>
       *
       * <code>.bloombox.schema.identity.User user = 1 [(.gen_bq_schema.description) = "User account that was logged in when the event was submitted."];</code>
       */
      public io.bloombox.schema.identity.UserOrBuilder getUserOrBuilder() {
        if (userBuilder_ != null) {
          return userBuilder_.getMessageOrBuilder();
        } else {
          return user_ == null ?
              io.bloombox.schema.identity.User.getDefaultInstance() : user_;
        }
      }
      /**
       * <pre>
       * User account that was logged in when the event was submitted.
       * </pre>
       *
       * <code>.bloombox.schema.identity.User user = 1 [(.gen_bq_schema.description) = "User account that was logged in when the event was submitted."];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.identity.User, io.bloombox.schema.identity.User.Builder, io.bloombox.schema.identity.UserOrBuilder> 
          getUserFieldBuilder() {
        if (userBuilder_ == null) {
          userBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.identity.User, io.bloombox.schema.identity.User.Builder, io.bloombox.schema.identity.UserOrBuilder>(
                  getUser(),
                  getParentForChildren(),
                  isClean());
          user_ = null;
        }
        return userBuilder_;
      }

      private io.bloombox.schema.partner.Partner partner_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.partner.Partner, io.bloombox.schema.partner.Partner.Builder, io.bloombox.schema.partner.PartnerOrBuilder> partnerBuilder_;
      /**
       * <pre>
       * Partner account under which the event was submitted.
       * </pre>
       *
       * <code>.bloombox.schema.partner.Partner partner = 2 [(.gen_bq_schema.description) = "Partner account under which the event was submitted."];</code>
       */
      public boolean hasPartner() {
        return partnerBuilder_ != null || partner_ != null;
      }
      /**
       * <pre>
       * Partner account under which the event was submitted.
       * </pre>
       *
       * <code>.bloombox.schema.partner.Partner partner = 2 [(.gen_bq_schema.description) = "Partner account under which the event was submitted."];</code>
       */
      public io.bloombox.schema.partner.Partner getPartner() {
        if (partnerBuilder_ == null) {
          return partner_ == null ? io.bloombox.schema.partner.Partner.getDefaultInstance() : partner_;
        } else {
          return partnerBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Partner account under which the event was submitted.
       * </pre>
       *
       * <code>.bloombox.schema.partner.Partner partner = 2 [(.gen_bq_schema.description) = "Partner account under which the event was submitted."];</code>
       */
      public Builder setPartner(io.bloombox.schema.partner.Partner value) {
        if (partnerBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          partner_ = value;
          onChanged();
        } else {
          partnerBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Partner account under which the event was submitted.
       * </pre>
       *
       * <code>.bloombox.schema.partner.Partner partner = 2 [(.gen_bq_schema.description) = "Partner account under which the event was submitted."];</code>
       */
      public Builder setPartner(
          io.bloombox.schema.partner.Partner.Builder builderForValue) {
        if (partnerBuilder_ == null) {
          partner_ = builderForValue.build();
          onChanged();
        } else {
          partnerBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Partner account under which the event was submitted.
       * </pre>
       *
       * <code>.bloombox.schema.partner.Partner partner = 2 [(.gen_bq_schema.description) = "Partner account under which the event was submitted."];</code>
       */
      public Builder mergePartner(io.bloombox.schema.partner.Partner value) {
        if (partnerBuilder_ == null) {
          if (partner_ != null) {
            partner_ =
              io.bloombox.schema.partner.Partner.newBuilder(partner_).mergeFrom(value).buildPartial();
          } else {
            partner_ = value;
          }
          onChanged();
        } else {
          partnerBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Partner account under which the event was submitted.
       * </pre>
       *
       * <code>.bloombox.schema.partner.Partner partner = 2 [(.gen_bq_schema.description) = "Partner account under which the event was submitted."];</code>
       */
      public Builder clearPartner() {
        if (partnerBuilder_ == null) {
          partner_ = null;
          onChanged();
        } else {
          partner_ = null;
          partnerBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Partner account under which the event was submitted.
       * </pre>
       *
       * <code>.bloombox.schema.partner.Partner partner = 2 [(.gen_bq_schema.description) = "Partner account under which the event was submitted."];</code>
       */
      public io.bloombox.schema.partner.Partner.Builder getPartnerBuilder() {
        
        onChanged();
        return getPartnerFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Partner account under which the event was submitted.
       * </pre>
       *
       * <code>.bloombox.schema.partner.Partner partner = 2 [(.gen_bq_schema.description) = "Partner account under which the event was submitted."];</code>
       */
      public io.bloombox.schema.partner.PartnerOrBuilder getPartnerOrBuilder() {
        if (partnerBuilder_ != null) {
          return partnerBuilder_.getMessageOrBuilder();
        } else {
          return partner_ == null ?
              io.bloombox.schema.partner.Partner.getDefaultInstance() : partner_;
        }
      }
      /**
       * <pre>
       * Partner account under which the event was submitted.
       * </pre>
       *
       * <code>.bloombox.schema.partner.Partner partner = 2 [(.gen_bq_schema.description) = "Partner account under which the event was submitted."];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.partner.Partner, io.bloombox.schema.partner.Partner.Builder, io.bloombox.schema.partner.PartnerOrBuilder> 
          getPartnerFieldBuilder() {
        if (partnerBuilder_ == null) {
          partnerBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.partner.Partner, io.bloombox.schema.partner.Partner.Builder, io.bloombox.schema.partner.PartnerOrBuilder>(
                  getPartner(),
                  getParentForChildren(),
                  isClean());
          partner_ = null;
        }
        return partnerBuilder_;
      }

      private io.bloombox.schema.partner.PartnerLocation location_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.partner.PartnerLocation, io.bloombox.schema.partner.PartnerLocation.Builder, io.bloombox.schema.partner.PartnerLocationOrBuilder> locationBuilder_;
      /**
       * <pre>
       * Location account under which this event was submitted.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocation location = 3 [(.gen_bq_schema.description) = "Location account under which this event was submitted."];</code>
       */
      public boolean hasLocation() {
        return locationBuilder_ != null || location_ != null;
      }
      /**
       * <pre>
       * Location account under which this event was submitted.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocation location = 3 [(.gen_bq_schema.description) = "Location account under which this event was submitted."];</code>
       */
      public io.bloombox.schema.partner.PartnerLocation getLocation() {
        if (locationBuilder_ == null) {
          return location_ == null ? io.bloombox.schema.partner.PartnerLocation.getDefaultInstance() : location_;
        } else {
          return locationBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Location account under which this event was submitted.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocation location = 3 [(.gen_bq_schema.description) = "Location account under which this event was submitted."];</code>
       */
      public Builder setLocation(io.bloombox.schema.partner.PartnerLocation value) {
        if (locationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          location_ = value;
          onChanged();
        } else {
          locationBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Location account under which this event was submitted.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocation location = 3 [(.gen_bq_schema.description) = "Location account under which this event was submitted."];</code>
       */
      public Builder setLocation(
          io.bloombox.schema.partner.PartnerLocation.Builder builderForValue) {
        if (locationBuilder_ == null) {
          location_ = builderForValue.build();
          onChanged();
        } else {
          locationBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Location account under which this event was submitted.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocation location = 3 [(.gen_bq_schema.description) = "Location account under which this event was submitted."];</code>
       */
      public Builder mergeLocation(io.bloombox.schema.partner.PartnerLocation value) {
        if (locationBuilder_ == null) {
          if (location_ != null) {
            location_ =
              io.bloombox.schema.partner.PartnerLocation.newBuilder(location_).mergeFrom(value).buildPartial();
          } else {
            location_ = value;
          }
          onChanged();
        } else {
          locationBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Location account under which this event was submitted.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocation location = 3 [(.gen_bq_schema.description) = "Location account under which this event was submitted."];</code>
       */
      public Builder clearLocation() {
        if (locationBuilder_ == null) {
          location_ = null;
          onChanged();
        } else {
          location_ = null;
          locationBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Location account under which this event was submitted.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocation location = 3 [(.gen_bq_schema.description) = "Location account under which this event was submitted."];</code>
       */
      public io.bloombox.schema.partner.PartnerLocation.Builder getLocationBuilder() {
        
        onChanged();
        return getLocationFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Location account under which this event was submitted.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocation location = 3 [(.gen_bq_schema.description) = "Location account under which this event was submitted."];</code>
       */
      public io.bloombox.schema.partner.PartnerLocationOrBuilder getLocationOrBuilder() {
        if (locationBuilder_ != null) {
          return locationBuilder_.getMessageOrBuilder();
        } else {
          return location_ == null ?
              io.bloombox.schema.partner.PartnerLocation.getDefaultInstance() : location_;
        }
      }
      /**
       * <pre>
       * Location account under which this event was submitted.
       * </pre>
       *
       * <code>.bloombox.schema.partner.PartnerLocation location = 3 [(.gen_bq_schema.description) = "Location account under which this event was submitted."];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.partner.PartnerLocation, io.bloombox.schema.partner.PartnerLocation.Builder, io.bloombox.schema.partner.PartnerLocationOrBuilder> 
          getLocationFieldBuilder() {
        if (locationBuilder_ == null) {
          locationBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.partner.PartnerLocation, io.bloombox.schema.partner.PartnerLocation.Builder, io.bloombox.schema.partner.PartnerLocationOrBuilder>(
                  getLocation(),
                  getParentForChildren(),
                  isClean());
          location_ = null;
        }
        return locationBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.analytics.EventActors)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.analytics.EventActors)
    private static final io.bloombox.schema.telemetry.AnalyticsContext.EventActors DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.telemetry.AnalyticsContext.EventActors();
    }

    public static io.bloombox.schema.telemetry.AnalyticsContext.EventActors getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<EventActors>
        PARSER = new com.google.protobuf.AbstractParser<EventActors>() {
      public EventActors parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new EventActors(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<EventActors> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<EventActors> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.telemetry.AnalyticsContext.EventActors getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ContextOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.analytics.Context)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Collection information, specifies event type or category.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.Collection collection = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Collection information, specifies event type or category."];</code>
     */
    boolean hasCollection();
    /**
     * <pre>
     * Collection information, specifies event type or category.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.Collection collection = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Collection information, specifies event type or category."];</code>
     */
    io.bloombox.schema.telemetry.context.AnalyticsCollection.Collection getCollection();
    /**
     * <pre>
     * Collection information, specifies event type or category.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.Collection collection = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Collection information, specifies event type or category."];</code>
     */
    io.bloombox.schema.telemetry.context.AnalyticsCollection.CollectionOrBuilder getCollectionOrBuilder();

    /**
     * <pre>
     * Specifies the user associated with this event, if known.
     * </pre>
     *
     * <code>.bloombox.schema.identity.UserKey user_key = 2 [(.gen_bq_schema.description) = "Specifies the user associated with this event, if known."];</code>
     */
    boolean hasUserKey();
    /**
     * <pre>
     * Specifies the user associated with this event, if known.
     * </pre>
     *
     * <code>.bloombox.schema.identity.UserKey user_key = 2 [(.gen_bq_schema.description) = "Specifies the user associated with this event, if known."];</code>
     */
    io.bloombox.schema.identity.UserKey getUserKey();
    /**
     * <pre>
     * Specifies the user associated with this event, if known.
     * </pre>
     *
     * <code>.bloombox.schema.identity.UserKey user_key = 2 [(.gen_bq_schema.description) = "Specifies the user associated with this event, if known."];</code>
     */
    io.bloombox.schema.identity.UserKeyOrBuilder getUserKeyOrBuilder();

    /**
     * <pre>
     * Unique device fingerprint for this analytics context.
     * </pre>
     *
     * <code>string fingerprint = 3 [(.gen_bq_schema.description) = "Unique device fingerprint for this analytics context."];</code>
     */
    java.lang.String getFingerprint();
    /**
     * <pre>
     * Unique device fingerprint for this analytics context.
     * </pre>
     *
     * <code>string fingerprint = 3 [(.gen_bq_schema.description) = "Unique device fingerprint for this analytics context."];</code>
     */
    com.google.protobuf.ByteString
        getFingerprintBytes();

    /**
     * <pre>
     * Arbitrary group ID for this event. Gathers events into buckets of variable size, usually used to indicate a user
     * or device session.
     * </pre>
     *
     * <code>string group = 4 [(.gen_bq_schema.description) = "Arbitrary group ID for this event. Gathers events into buckets of variable size, usually used to indicate a user or device session."];</code>
     */
    java.lang.String getGroup();
    /**
     * <pre>
     * Arbitrary group ID for this event. Gathers events into buckets of variable size, usually used to indicate a user
     * or device session.
     * </pre>
     *
     * <code>string group = 4 [(.gen_bq_schema.description) = "Arbitrary group ID for this event. Gathers events into buckets of variable size, usually used to indicate a user or device session."];</code>
     */
    com.google.protobuf.ByteString
        getGroupBytes();

    /**
     * <pre>
     * Hostname of the server or client that transmitted this information, if it is known.
     * </pre>
     *
     * <code>string hostname = 5 [(.gen_bq_schema.description) = "Hostname of the server or client that transmitted this information, if it is known."];</code>
     */
    java.lang.String getHostname();
    /**
     * <pre>
     * Hostname of the server or client that transmitted this information, if it is known.
     * </pre>
     *
     * <code>string hostname = 5 [(.gen_bq_schema.description) = "Hostname of the server or client that transmitted this information, if it is known."];</code>
     */
    com.google.protobuf.ByteString
        getHostnameBytes();

    /**
     * <pre>
     * IP address of the server or client that transmitted this information, if is is known.
     * </pre>
     *
     * <code>string ip_address = 6 [(.gen_bq_schema.description) = "IP address of the server or client that transmitted this information, if is is known."];</code>
     */
    java.lang.String getIpAddress();
    /**
     * <pre>
     * IP address of the server or client that transmitted this information, if is is known.
     * </pre>
     *
     * <code>string ip_address = 6 [(.gen_bq_schema.description) = "IP address of the server or client that transmitted this information, if is is known."];</code>
     */
    com.google.protobuf.ByteString
        getIpAddressBytes();

    /**
     * <pre>
     * Partner and commercial scope of this event.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.Scope scope = 7 [(.gen_bq_schema.description) = "Partner and commercial scope of this event."];</code>
     */
    boolean hasScope();
    /**
     * <pre>
     * Partner and commercial scope of this event.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.Scope scope = 7 [(.gen_bq_schema.description) = "Partner and commercial scope of this event."];</code>
     */
    io.bloombox.schema.telemetry.AnalyticsScope.Scope getScope();
    /**
     * <pre>
     * Partner and commercial scope of this event.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.Scope scope = 7 [(.gen_bq_schema.description) = "Partner and commercial scope of this event."];</code>
     */
    io.bloombox.schema.telemetry.AnalyticsScope.ScopeOrBuilder getScopeOrBuilder();

    /**
     * <pre>
     * Application version information.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.DeviceApplication app = 8 [(.gen_bq_schema.description) = "Application version information."];</code>
     */
    boolean hasApp();
    /**
     * <pre>
     * Application version information.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.DeviceApplication app = 8 [(.gen_bq_schema.description) = "Application version information."];</code>
     */
    io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication getApp();
    /**
     * <pre>
     * Application version information.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.DeviceApplication app = 8 [(.gen_bq_schema.description) = "Application version information."];</code>
     */
    io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplicationOrBuilder getAppOrBuilder();

    /**
     * <pre>
     * Library version information.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.DeviceLibrary library = 9 [(.gen_bq_schema.description) = "Library version information."];</code>
     */
    boolean hasLibrary();
    /**
     * <pre>
     * Library version information.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.DeviceLibrary library = 9 [(.gen_bq_schema.description) = "Library version information."];</code>
     */
    io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary getLibrary();
    /**
     * <pre>
     * Library version information.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.DeviceLibrary library = 9 [(.gen_bq_schema.description) = "Library version information."];</code>
     */
    io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibraryOrBuilder getLibraryOrBuilder();

    /**
     * <pre>
     * Specifies information about a native device, when the event is being sent from a native context of some kind,
     * such as a mobile phone application or embedded device running partner code.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.NativeDeviceContext native = 10 [(.gen_bq_schema.description) = "Specifies information about a native device, when the event is being sent from a native context of some kind, such as a mobile phone application or embedded device running partner code."];</code>
     */
    boolean hasNative();
    /**
     * <pre>
     * Specifies information about a native device, when the event is being sent from a native context of some kind,
     * such as a mobile phone application or embedded device running partner code.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.NativeDeviceContext native = 10 [(.gen_bq_schema.description) = "Specifies information about a native device, when the event is being sent from a native context of some kind, such as a mobile phone application or embedded device running partner code."];</code>
     */
    io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext getNative();
    /**
     * <pre>
     * Specifies information about a native device, when the event is being sent from a native context of some kind,
     * such as a mobile phone application or embedded device running partner code.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.NativeDeviceContext native = 10 [(.gen_bq_schema.description) = "Specifies information about a native device, when the event is being sent from a native context of some kind, such as a mobile phone application or embedded device running partner code."];</code>
     */
    io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContextOrBuilder getNativeOrBuilder();

    /**
     * <pre>
     * Specifies information about a web browser, when the event is being sent from some kind of web browsing context.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.BrowserDeviceContext browser = 11 [(.gen_bq_schema.description) = "Specifies information about a web browser, when the event is being sent from some kind of web browsing context."];</code>
     */
    boolean hasBrowser();
    /**
     * <pre>
     * Specifies information about a web browser, when the event is being sent from some kind of web browsing context.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.BrowserDeviceContext browser = 11 [(.gen_bq_schema.description) = "Specifies information about a web browser, when the event is being sent from some kind of web browsing context."];</code>
     */
    io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext getBrowser();
    /**
     * <pre>
     * Specifies information about a web browser, when the event is being sent from some kind of web browsing context.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.BrowserDeviceContext browser = 11 [(.gen_bq_schema.description) = "Specifies information about a web browser, when the event is being sent from some kind of web browsing context."];</code>
     */
    io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContextOrBuilder getBrowserOrBuilder();

    /**
     * <pre>
     * Origin location for this event, as determined by geolocation or explicit inclusion in the event payload.
     * </pre>
     *
     * <code>.opencannabis.geo.Location location = 12 [(.gen_bq_schema.description) = "Origin location for this event, as determined by geolocation or explicit inclusion in the event payload."];</code>
     */
    boolean hasLocation();
    /**
     * <pre>
     * Origin location for this event, as determined by geolocation or explicit inclusion in the event payload.
     * </pre>
     *
     * <code>.opencannabis.geo.Location location = 12 [(.gen_bq_schema.description) = "Origin location for this event, as determined by geolocation or explicit inclusion in the event payload."];</code>
     */
    io.opencannabis.schema.geo.Location getLocation();
    /**
     * <pre>
     * Origin location for this event, as determined by geolocation or explicit inclusion in the event payload.
     * </pre>
     *
     * <code>.opencannabis.geo.Location location = 12 [(.gen_bq_schema.description) = "Origin location for this event, as determined by geolocation or explicit inclusion in the event payload."];</code>
     */
    io.opencannabis.schema.geo.LocationOrBuilder getLocationOrBuilder();
  }
  /**
   * <pre>
   * Specifies contextual metadata to include with events or exceptions recorded via analytics/telemetry ingest.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.analytics.Context}
   */
  public  static final class Context extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.analytics.Context)
      ContextOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Context.newBuilder() to construct.
    private Context(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Context() {
      fingerprint_ = "";
      group_ = "";
      hostname_ = "";
      ipAddress_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Context(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              io.bloombox.schema.telemetry.context.AnalyticsCollection.Collection.Builder subBuilder = null;
              if (collection_ != null) {
                subBuilder = collection_.toBuilder();
              }
              collection_ = input.readMessage(io.bloombox.schema.telemetry.context.AnalyticsCollection.Collection.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(collection_);
                collection_ = subBuilder.buildPartial();
              }

              break;
            }
            case 18: {
              io.bloombox.schema.identity.UserKey.Builder subBuilder = null;
              if (userKey_ != null) {
                subBuilder = userKey_.toBuilder();
              }
              userKey_ = input.readMessage(io.bloombox.schema.identity.UserKey.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(userKey_);
                userKey_ = subBuilder.buildPartial();
              }

              break;
            }
            case 26: {
              java.lang.String s = input.readStringRequireUtf8();

              fingerprint_ = s;
              break;
            }
            case 34: {
              java.lang.String s = input.readStringRequireUtf8();

              group_ = s;
              break;
            }
            case 42: {
              java.lang.String s = input.readStringRequireUtf8();

              hostname_ = s;
              break;
            }
            case 50: {
              java.lang.String s = input.readStringRequireUtf8();

              ipAddress_ = s;
              break;
            }
            case 58: {
              io.bloombox.schema.telemetry.AnalyticsScope.Scope.Builder subBuilder = null;
              if (scope_ != null) {
                subBuilder = scope_.toBuilder();
              }
              scope_ = input.readMessage(io.bloombox.schema.telemetry.AnalyticsScope.Scope.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(scope_);
                scope_ = subBuilder.buildPartial();
              }

              break;
            }
            case 66: {
              io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication.Builder subBuilder = null;
              if (app_ != null) {
                subBuilder = app_.toBuilder();
              }
              app_ = input.readMessage(io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(app_);
                app_ = subBuilder.buildPartial();
              }

              break;
            }
            case 74: {
              io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary.Builder subBuilder = null;
              if (library_ != null) {
                subBuilder = library_.toBuilder();
              }
              library_ = input.readMessage(io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(library_);
                library_ = subBuilder.buildPartial();
              }

              break;
            }
            case 82: {
              io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext.Builder subBuilder = null;
              if (native_ != null) {
                subBuilder = native_.toBuilder();
              }
              native_ = input.readMessage(io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(native_);
                native_ = subBuilder.buildPartial();
              }

              break;
            }
            case 90: {
              io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext.Builder subBuilder = null;
              if (browser_ != null) {
                subBuilder = browser_.toBuilder();
              }
              browser_ = input.readMessage(io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(browser_);
                browser_ = subBuilder.buildPartial();
              }

              break;
            }
            case 98: {
              io.opencannabis.schema.geo.Location.Builder subBuilder = null;
              if (location_ != null) {
                subBuilder = location_.toBuilder();
              }
              location_ = input.readMessage(io.opencannabis.schema.geo.Location.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(location_);
                location_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.telemetry.AnalyticsContext.internal_static_bloombox_schema_analytics_Context_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.telemetry.AnalyticsContext.internal_static_bloombox_schema_analytics_Context_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.telemetry.AnalyticsContext.Context.class, io.bloombox.schema.telemetry.AnalyticsContext.Context.Builder.class);
    }

    public static final int COLLECTION_FIELD_NUMBER = 1;
    private io.bloombox.schema.telemetry.context.AnalyticsCollection.Collection collection_;
    /**
     * <pre>
     * Collection information, specifies event type or category.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.Collection collection = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Collection information, specifies event type or category."];</code>
     */
    public boolean hasCollection() {
      return collection_ != null;
    }
    /**
     * <pre>
     * Collection information, specifies event type or category.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.Collection collection = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Collection information, specifies event type or category."];</code>
     */
    public io.bloombox.schema.telemetry.context.AnalyticsCollection.Collection getCollection() {
      return collection_ == null ? io.bloombox.schema.telemetry.context.AnalyticsCollection.Collection.getDefaultInstance() : collection_;
    }
    /**
     * <pre>
     * Collection information, specifies event type or category.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.Collection collection = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Collection information, specifies event type or category."];</code>
     */
    public io.bloombox.schema.telemetry.context.AnalyticsCollection.CollectionOrBuilder getCollectionOrBuilder() {
      return getCollection();
    }

    public static final int USER_KEY_FIELD_NUMBER = 2;
    private io.bloombox.schema.identity.UserKey userKey_;
    /**
     * <pre>
     * Specifies the user associated with this event, if known.
     * </pre>
     *
     * <code>.bloombox.schema.identity.UserKey user_key = 2 [(.gen_bq_schema.description) = "Specifies the user associated with this event, if known."];</code>
     */
    public boolean hasUserKey() {
      return userKey_ != null;
    }
    /**
     * <pre>
     * Specifies the user associated with this event, if known.
     * </pre>
     *
     * <code>.bloombox.schema.identity.UserKey user_key = 2 [(.gen_bq_schema.description) = "Specifies the user associated with this event, if known."];</code>
     */
    public io.bloombox.schema.identity.UserKey getUserKey() {
      return userKey_ == null ? io.bloombox.schema.identity.UserKey.getDefaultInstance() : userKey_;
    }
    /**
     * <pre>
     * Specifies the user associated with this event, if known.
     * </pre>
     *
     * <code>.bloombox.schema.identity.UserKey user_key = 2 [(.gen_bq_schema.description) = "Specifies the user associated with this event, if known."];</code>
     */
    public io.bloombox.schema.identity.UserKeyOrBuilder getUserKeyOrBuilder() {
      return getUserKey();
    }

    public static final int FINGERPRINT_FIELD_NUMBER = 3;
    private volatile java.lang.Object fingerprint_;
    /**
     * <pre>
     * Unique device fingerprint for this analytics context.
     * </pre>
     *
     * <code>string fingerprint = 3 [(.gen_bq_schema.description) = "Unique device fingerprint for this analytics context."];</code>
     */
    public java.lang.String getFingerprint() {
      java.lang.Object ref = fingerprint_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fingerprint_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Unique device fingerprint for this analytics context.
     * </pre>
     *
     * <code>string fingerprint = 3 [(.gen_bq_schema.description) = "Unique device fingerprint for this analytics context."];</code>
     */
    public com.google.protobuf.ByteString
        getFingerprintBytes() {
      java.lang.Object ref = fingerprint_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        fingerprint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int GROUP_FIELD_NUMBER = 4;
    private volatile java.lang.Object group_;
    /**
     * <pre>
     * Arbitrary group ID for this event. Gathers events into buckets of variable size, usually used to indicate a user
     * or device session.
     * </pre>
     *
     * <code>string group = 4 [(.gen_bq_schema.description) = "Arbitrary group ID for this event. Gathers events into buckets of variable size, usually used to indicate a user or device session."];</code>
     */
    public java.lang.String getGroup() {
      java.lang.Object ref = group_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        group_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Arbitrary group ID for this event. Gathers events into buckets of variable size, usually used to indicate a user
     * or device session.
     * </pre>
     *
     * <code>string group = 4 [(.gen_bq_schema.description) = "Arbitrary group ID for this event. Gathers events into buckets of variable size, usually used to indicate a user or device session."];</code>
     */
    public com.google.protobuf.ByteString
        getGroupBytes() {
      java.lang.Object ref = group_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        group_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int HOSTNAME_FIELD_NUMBER = 5;
    private volatile java.lang.Object hostname_;
    /**
     * <pre>
     * Hostname of the server or client that transmitted this information, if it is known.
     * </pre>
     *
     * <code>string hostname = 5 [(.gen_bq_schema.description) = "Hostname of the server or client that transmitted this information, if it is known."];</code>
     */
    public java.lang.String getHostname() {
      java.lang.Object ref = hostname_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        hostname_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Hostname of the server or client that transmitted this information, if it is known.
     * </pre>
     *
     * <code>string hostname = 5 [(.gen_bq_schema.description) = "Hostname of the server or client that transmitted this information, if it is known."];</code>
     */
    public com.google.protobuf.ByteString
        getHostnameBytes() {
      java.lang.Object ref = hostname_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        hostname_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int IP_ADDRESS_FIELD_NUMBER = 6;
    private volatile java.lang.Object ipAddress_;
    /**
     * <pre>
     * IP address of the server or client that transmitted this information, if is is known.
     * </pre>
     *
     * <code>string ip_address = 6 [(.gen_bq_schema.description) = "IP address of the server or client that transmitted this information, if is is known."];</code>
     */
    public java.lang.String getIpAddress() {
      java.lang.Object ref = ipAddress_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        ipAddress_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * IP address of the server or client that transmitted this information, if is is known.
     * </pre>
     *
     * <code>string ip_address = 6 [(.gen_bq_schema.description) = "IP address of the server or client that transmitted this information, if is is known."];</code>
     */
    public com.google.protobuf.ByteString
        getIpAddressBytes() {
      java.lang.Object ref = ipAddress_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        ipAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SCOPE_FIELD_NUMBER = 7;
    private io.bloombox.schema.telemetry.AnalyticsScope.Scope scope_;
    /**
     * <pre>
     * Partner and commercial scope of this event.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.Scope scope = 7 [(.gen_bq_schema.description) = "Partner and commercial scope of this event."];</code>
     */
    public boolean hasScope() {
      return scope_ != null;
    }
    /**
     * <pre>
     * Partner and commercial scope of this event.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.Scope scope = 7 [(.gen_bq_schema.description) = "Partner and commercial scope of this event."];</code>
     */
    public io.bloombox.schema.telemetry.AnalyticsScope.Scope getScope() {
      return scope_ == null ? io.bloombox.schema.telemetry.AnalyticsScope.Scope.getDefaultInstance() : scope_;
    }
    /**
     * <pre>
     * Partner and commercial scope of this event.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.Scope scope = 7 [(.gen_bq_schema.description) = "Partner and commercial scope of this event."];</code>
     */
    public io.bloombox.schema.telemetry.AnalyticsScope.ScopeOrBuilder getScopeOrBuilder() {
      return getScope();
    }

    public static final int APP_FIELD_NUMBER = 8;
    private io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication app_;
    /**
     * <pre>
     * Application version information.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.DeviceApplication app = 8 [(.gen_bq_schema.description) = "Application version information."];</code>
     */
    public boolean hasApp() {
      return app_ != null;
    }
    /**
     * <pre>
     * Application version information.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.DeviceApplication app = 8 [(.gen_bq_schema.description) = "Application version information."];</code>
     */
    public io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication getApp() {
      return app_ == null ? io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication.getDefaultInstance() : app_;
    }
    /**
     * <pre>
     * Application version information.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.DeviceApplication app = 8 [(.gen_bq_schema.description) = "Application version information."];</code>
     */
    public io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplicationOrBuilder getAppOrBuilder() {
      return getApp();
    }

    public static final int LIBRARY_FIELD_NUMBER = 9;
    private io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary library_;
    /**
     * <pre>
     * Library version information.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.DeviceLibrary library = 9 [(.gen_bq_schema.description) = "Library version information."];</code>
     */
    public boolean hasLibrary() {
      return library_ != null;
    }
    /**
     * <pre>
     * Library version information.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.DeviceLibrary library = 9 [(.gen_bq_schema.description) = "Library version information."];</code>
     */
    public io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary getLibrary() {
      return library_ == null ? io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary.getDefaultInstance() : library_;
    }
    /**
     * <pre>
     * Library version information.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.DeviceLibrary library = 9 [(.gen_bq_schema.description) = "Library version information."];</code>
     */
    public io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibraryOrBuilder getLibraryOrBuilder() {
      return getLibrary();
    }

    public static final int NATIVE_FIELD_NUMBER = 10;
    private io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext native_;
    /**
     * <pre>
     * Specifies information about a native device, when the event is being sent from a native context of some kind,
     * such as a mobile phone application or embedded device running partner code.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.NativeDeviceContext native = 10 [(.gen_bq_schema.description) = "Specifies information about a native device, when the event is being sent from a native context of some kind, such as a mobile phone application or embedded device running partner code."];</code>
     */
    public boolean hasNative() {
      return native_ != null;
    }
    /**
     * <pre>
     * Specifies information about a native device, when the event is being sent from a native context of some kind,
     * such as a mobile phone application or embedded device running partner code.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.NativeDeviceContext native = 10 [(.gen_bq_schema.description) = "Specifies information about a native device, when the event is being sent from a native context of some kind, such as a mobile phone application or embedded device running partner code."];</code>
     */
    public io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext getNative() {
      return native_ == null ? io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext.getDefaultInstance() : native_;
    }
    /**
     * <pre>
     * Specifies information about a native device, when the event is being sent from a native context of some kind,
     * such as a mobile phone application or embedded device running partner code.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.NativeDeviceContext native = 10 [(.gen_bq_schema.description) = "Specifies information about a native device, when the event is being sent from a native context of some kind, such as a mobile phone application or embedded device running partner code."];</code>
     */
    public io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContextOrBuilder getNativeOrBuilder() {
      return getNative();
    }

    public static final int BROWSER_FIELD_NUMBER = 11;
    private io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext browser_;
    /**
     * <pre>
     * Specifies information about a web browser, when the event is being sent from some kind of web browsing context.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.BrowserDeviceContext browser = 11 [(.gen_bq_schema.description) = "Specifies information about a web browser, when the event is being sent from some kind of web browsing context."];</code>
     */
    public boolean hasBrowser() {
      return browser_ != null;
    }
    /**
     * <pre>
     * Specifies information about a web browser, when the event is being sent from some kind of web browsing context.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.BrowserDeviceContext browser = 11 [(.gen_bq_schema.description) = "Specifies information about a web browser, when the event is being sent from some kind of web browsing context."];</code>
     */
    public io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext getBrowser() {
      return browser_ == null ? io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext.getDefaultInstance() : browser_;
    }
    /**
     * <pre>
     * Specifies information about a web browser, when the event is being sent from some kind of web browsing context.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.BrowserDeviceContext browser = 11 [(.gen_bq_schema.description) = "Specifies information about a web browser, when the event is being sent from some kind of web browsing context."];</code>
     */
    public io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContextOrBuilder getBrowserOrBuilder() {
      return getBrowser();
    }

    public static final int LOCATION_FIELD_NUMBER = 12;
    private io.opencannabis.schema.geo.Location location_;
    /**
     * <pre>
     * Origin location for this event, as determined by geolocation or explicit inclusion in the event payload.
     * </pre>
     *
     * <code>.opencannabis.geo.Location location = 12 [(.gen_bq_schema.description) = "Origin location for this event, as determined by geolocation or explicit inclusion in the event payload."];</code>
     */
    public boolean hasLocation() {
      return location_ != null;
    }
    /**
     * <pre>
     * Origin location for this event, as determined by geolocation or explicit inclusion in the event payload.
     * </pre>
     *
     * <code>.opencannabis.geo.Location location = 12 [(.gen_bq_schema.description) = "Origin location for this event, as determined by geolocation or explicit inclusion in the event payload."];</code>
     */
    public io.opencannabis.schema.geo.Location getLocation() {
      return location_ == null ? io.opencannabis.schema.geo.Location.getDefaultInstance() : location_;
    }
    /**
     * <pre>
     * Origin location for this event, as determined by geolocation or explicit inclusion in the event payload.
     * </pre>
     *
     * <code>.opencannabis.geo.Location location = 12 [(.gen_bq_schema.description) = "Origin location for this event, as determined by geolocation or explicit inclusion in the event payload."];</code>
     */
    public io.opencannabis.schema.geo.LocationOrBuilder getLocationOrBuilder() {
      return getLocation();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (collection_ != null) {
        output.writeMessage(1, getCollection());
      }
      if (userKey_ != null) {
        output.writeMessage(2, getUserKey());
      }
      if (!getFingerprintBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, fingerprint_);
      }
      if (!getGroupBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, group_);
      }
      if (!getHostnameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, hostname_);
      }
      if (!getIpAddressBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, ipAddress_);
      }
      if (scope_ != null) {
        output.writeMessage(7, getScope());
      }
      if (app_ != null) {
        output.writeMessage(8, getApp());
      }
      if (library_ != null) {
        output.writeMessage(9, getLibrary());
      }
      if (native_ != null) {
        output.writeMessage(10, getNative());
      }
      if (browser_ != null) {
        output.writeMessage(11, getBrowser());
      }
      if (location_ != null) {
        output.writeMessage(12, getLocation());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (collection_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getCollection());
      }
      if (userKey_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getUserKey());
      }
      if (!getFingerprintBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, fingerprint_);
      }
      if (!getGroupBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, group_);
      }
      if (!getHostnameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, hostname_);
      }
      if (!getIpAddressBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, ipAddress_);
      }
      if (scope_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(7, getScope());
      }
      if (app_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(8, getApp());
      }
      if (library_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(9, getLibrary());
      }
      if (native_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(10, getNative());
      }
      if (browser_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(11, getBrowser());
      }
      if (location_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(12, getLocation());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.telemetry.AnalyticsContext.Context)) {
        return super.equals(obj);
      }
      io.bloombox.schema.telemetry.AnalyticsContext.Context other = (io.bloombox.schema.telemetry.AnalyticsContext.Context) obj;

      boolean result = true;
      result = result && (hasCollection() == other.hasCollection());
      if (hasCollection()) {
        result = result && getCollection()
            .equals(other.getCollection());
      }
      result = result && (hasUserKey() == other.hasUserKey());
      if (hasUserKey()) {
        result = result && getUserKey()
            .equals(other.getUserKey());
      }
      result = result && getFingerprint()
          .equals(other.getFingerprint());
      result = result && getGroup()
          .equals(other.getGroup());
      result = result && getHostname()
          .equals(other.getHostname());
      result = result && getIpAddress()
          .equals(other.getIpAddress());
      result = result && (hasScope() == other.hasScope());
      if (hasScope()) {
        result = result && getScope()
            .equals(other.getScope());
      }
      result = result && (hasApp() == other.hasApp());
      if (hasApp()) {
        result = result && getApp()
            .equals(other.getApp());
      }
      result = result && (hasLibrary() == other.hasLibrary());
      if (hasLibrary()) {
        result = result && getLibrary()
            .equals(other.getLibrary());
      }
      result = result && (hasNative() == other.hasNative());
      if (hasNative()) {
        result = result && getNative()
            .equals(other.getNative());
      }
      result = result && (hasBrowser() == other.hasBrowser());
      if (hasBrowser()) {
        result = result && getBrowser()
            .equals(other.getBrowser());
      }
      result = result && (hasLocation() == other.hasLocation());
      if (hasLocation()) {
        result = result && getLocation()
            .equals(other.getLocation());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasCollection()) {
        hash = (37 * hash) + COLLECTION_FIELD_NUMBER;
        hash = (53 * hash) + getCollection().hashCode();
      }
      if (hasUserKey()) {
        hash = (37 * hash) + USER_KEY_FIELD_NUMBER;
        hash = (53 * hash) + getUserKey().hashCode();
      }
      hash = (37 * hash) + FINGERPRINT_FIELD_NUMBER;
      hash = (53 * hash) + getFingerprint().hashCode();
      hash = (37 * hash) + GROUP_FIELD_NUMBER;
      hash = (53 * hash) + getGroup().hashCode();
      hash = (37 * hash) + HOSTNAME_FIELD_NUMBER;
      hash = (53 * hash) + getHostname().hashCode();
      hash = (37 * hash) + IP_ADDRESS_FIELD_NUMBER;
      hash = (53 * hash) + getIpAddress().hashCode();
      if (hasScope()) {
        hash = (37 * hash) + SCOPE_FIELD_NUMBER;
        hash = (53 * hash) + getScope().hashCode();
      }
      if (hasApp()) {
        hash = (37 * hash) + APP_FIELD_NUMBER;
        hash = (53 * hash) + getApp().hashCode();
      }
      if (hasLibrary()) {
        hash = (37 * hash) + LIBRARY_FIELD_NUMBER;
        hash = (53 * hash) + getLibrary().hashCode();
      }
      if (hasNative()) {
        hash = (37 * hash) + NATIVE_FIELD_NUMBER;
        hash = (53 * hash) + getNative().hashCode();
      }
      if (hasBrowser()) {
        hash = (37 * hash) + BROWSER_FIELD_NUMBER;
        hash = (53 * hash) + getBrowser().hashCode();
      }
      if (hasLocation()) {
        hash = (37 * hash) + LOCATION_FIELD_NUMBER;
        hash = (53 * hash) + getLocation().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.telemetry.AnalyticsContext.Context parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.AnalyticsContext.Context parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.AnalyticsContext.Context parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.AnalyticsContext.Context parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.AnalyticsContext.Context parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.AnalyticsContext.Context parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.AnalyticsContext.Context parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.AnalyticsContext.Context parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.AnalyticsContext.Context parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.AnalyticsContext.Context parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.AnalyticsContext.Context parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.AnalyticsContext.Context parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.telemetry.AnalyticsContext.Context prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies contextual metadata to include with events or exceptions recorded via analytics/telemetry ingest.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.analytics.Context}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.analytics.Context)
        io.bloombox.schema.telemetry.AnalyticsContext.ContextOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.telemetry.AnalyticsContext.internal_static_bloombox_schema_analytics_Context_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.telemetry.AnalyticsContext.internal_static_bloombox_schema_analytics_Context_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.telemetry.AnalyticsContext.Context.class, io.bloombox.schema.telemetry.AnalyticsContext.Context.Builder.class);
      }

      // Construct using io.bloombox.schema.telemetry.AnalyticsContext.Context.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        if (collectionBuilder_ == null) {
          collection_ = null;
        } else {
          collection_ = null;
          collectionBuilder_ = null;
        }
        if (userKeyBuilder_ == null) {
          userKey_ = null;
        } else {
          userKey_ = null;
          userKeyBuilder_ = null;
        }
        fingerprint_ = "";

        group_ = "";

        hostname_ = "";

        ipAddress_ = "";

        if (scopeBuilder_ == null) {
          scope_ = null;
        } else {
          scope_ = null;
          scopeBuilder_ = null;
        }
        if (appBuilder_ == null) {
          app_ = null;
        } else {
          app_ = null;
          appBuilder_ = null;
        }
        if (libraryBuilder_ == null) {
          library_ = null;
        } else {
          library_ = null;
          libraryBuilder_ = null;
        }
        if (nativeBuilder_ == null) {
          native_ = null;
        } else {
          native_ = null;
          nativeBuilder_ = null;
        }
        if (browserBuilder_ == null) {
          browser_ = null;
        } else {
          browser_ = null;
          browserBuilder_ = null;
        }
        if (locationBuilder_ == null) {
          location_ = null;
        } else {
          location_ = null;
          locationBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.telemetry.AnalyticsContext.internal_static_bloombox_schema_analytics_Context_descriptor;
      }

      public io.bloombox.schema.telemetry.AnalyticsContext.Context getDefaultInstanceForType() {
        return io.bloombox.schema.telemetry.AnalyticsContext.Context.getDefaultInstance();
      }

      public io.bloombox.schema.telemetry.AnalyticsContext.Context build() {
        io.bloombox.schema.telemetry.AnalyticsContext.Context result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.telemetry.AnalyticsContext.Context buildPartial() {
        io.bloombox.schema.telemetry.AnalyticsContext.Context result = new io.bloombox.schema.telemetry.AnalyticsContext.Context(this);
        if (collectionBuilder_ == null) {
          result.collection_ = collection_;
        } else {
          result.collection_ = collectionBuilder_.build();
        }
        if (userKeyBuilder_ == null) {
          result.userKey_ = userKey_;
        } else {
          result.userKey_ = userKeyBuilder_.build();
        }
        result.fingerprint_ = fingerprint_;
        result.group_ = group_;
        result.hostname_ = hostname_;
        result.ipAddress_ = ipAddress_;
        if (scopeBuilder_ == null) {
          result.scope_ = scope_;
        } else {
          result.scope_ = scopeBuilder_.build();
        }
        if (appBuilder_ == null) {
          result.app_ = app_;
        } else {
          result.app_ = appBuilder_.build();
        }
        if (libraryBuilder_ == null) {
          result.library_ = library_;
        } else {
          result.library_ = libraryBuilder_.build();
        }
        if (nativeBuilder_ == null) {
          result.native_ = native_;
        } else {
          result.native_ = nativeBuilder_.build();
        }
        if (browserBuilder_ == null) {
          result.browser_ = browser_;
        } else {
          result.browser_ = browserBuilder_.build();
        }
        if (locationBuilder_ == null) {
          result.location_ = location_;
        } else {
          result.location_ = locationBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.telemetry.AnalyticsContext.Context) {
          return mergeFrom((io.bloombox.schema.telemetry.AnalyticsContext.Context)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.telemetry.AnalyticsContext.Context other) {
        if (other == io.bloombox.schema.telemetry.AnalyticsContext.Context.getDefaultInstance()) return this;
        if (other.hasCollection()) {
          mergeCollection(other.getCollection());
        }
        if (other.hasUserKey()) {
          mergeUserKey(other.getUserKey());
        }
        if (!other.getFingerprint().isEmpty()) {
          fingerprint_ = other.fingerprint_;
          onChanged();
        }
        if (!other.getGroup().isEmpty()) {
          group_ = other.group_;
          onChanged();
        }
        if (!other.getHostname().isEmpty()) {
          hostname_ = other.hostname_;
          onChanged();
        }
        if (!other.getIpAddress().isEmpty()) {
          ipAddress_ = other.ipAddress_;
          onChanged();
        }
        if (other.hasScope()) {
          mergeScope(other.getScope());
        }
        if (other.hasApp()) {
          mergeApp(other.getApp());
        }
        if (other.hasLibrary()) {
          mergeLibrary(other.getLibrary());
        }
        if (other.hasNative()) {
          mergeNative(other.getNative());
        }
        if (other.hasBrowser()) {
          mergeBrowser(other.getBrowser());
        }
        if (other.hasLocation()) {
          mergeLocation(other.getLocation());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.telemetry.AnalyticsContext.Context parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.telemetry.AnalyticsContext.Context) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private io.bloombox.schema.telemetry.context.AnalyticsCollection.Collection collection_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.telemetry.context.AnalyticsCollection.Collection, io.bloombox.schema.telemetry.context.AnalyticsCollection.Collection.Builder, io.bloombox.schema.telemetry.context.AnalyticsCollection.CollectionOrBuilder> collectionBuilder_;
      /**
       * <pre>
       * Collection information, specifies event type or category.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.Collection collection = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Collection information, specifies event type or category."];</code>
       */
      public boolean hasCollection() {
        return collectionBuilder_ != null || collection_ != null;
      }
      /**
       * <pre>
       * Collection information, specifies event type or category.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.Collection collection = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Collection information, specifies event type or category."];</code>
       */
      public io.bloombox.schema.telemetry.context.AnalyticsCollection.Collection getCollection() {
        if (collectionBuilder_ == null) {
          return collection_ == null ? io.bloombox.schema.telemetry.context.AnalyticsCollection.Collection.getDefaultInstance() : collection_;
        } else {
          return collectionBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Collection information, specifies event type or category.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.Collection collection = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Collection information, specifies event type or category."];</code>
       */
      public Builder setCollection(io.bloombox.schema.telemetry.context.AnalyticsCollection.Collection value) {
        if (collectionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          collection_ = value;
          onChanged();
        } else {
          collectionBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Collection information, specifies event type or category.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.Collection collection = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Collection information, specifies event type or category."];</code>
       */
      public Builder setCollection(
          io.bloombox.schema.telemetry.context.AnalyticsCollection.Collection.Builder builderForValue) {
        if (collectionBuilder_ == null) {
          collection_ = builderForValue.build();
          onChanged();
        } else {
          collectionBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Collection information, specifies event type or category.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.Collection collection = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Collection information, specifies event type or category."];</code>
       */
      public Builder mergeCollection(io.bloombox.schema.telemetry.context.AnalyticsCollection.Collection value) {
        if (collectionBuilder_ == null) {
          if (collection_ != null) {
            collection_ =
              io.bloombox.schema.telemetry.context.AnalyticsCollection.Collection.newBuilder(collection_).mergeFrom(value).buildPartial();
          } else {
            collection_ = value;
          }
          onChanged();
        } else {
          collectionBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Collection information, specifies event type or category.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.Collection collection = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Collection information, specifies event type or category."];</code>
       */
      public Builder clearCollection() {
        if (collectionBuilder_ == null) {
          collection_ = null;
          onChanged();
        } else {
          collection_ = null;
          collectionBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Collection information, specifies event type or category.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.Collection collection = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Collection information, specifies event type or category."];</code>
       */
      public io.bloombox.schema.telemetry.context.AnalyticsCollection.Collection.Builder getCollectionBuilder() {
        
        onChanged();
        return getCollectionFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Collection information, specifies event type or category.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.Collection collection = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Collection information, specifies event type or category."];</code>
       */
      public io.bloombox.schema.telemetry.context.AnalyticsCollection.CollectionOrBuilder getCollectionOrBuilder() {
        if (collectionBuilder_ != null) {
          return collectionBuilder_.getMessageOrBuilder();
        } else {
          return collection_ == null ?
              io.bloombox.schema.telemetry.context.AnalyticsCollection.Collection.getDefaultInstance() : collection_;
        }
      }
      /**
       * <pre>
       * Collection information, specifies event type or category.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.Collection collection = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Collection information, specifies event type or category."];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.telemetry.context.AnalyticsCollection.Collection, io.bloombox.schema.telemetry.context.AnalyticsCollection.Collection.Builder, io.bloombox.schema.telemetry.context.AnalyticsCollection.CollectionOrBuilder> 
          getCollectionFieldBuilder() {
        if (collectionBuilder_ == null) {
          collectionBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.telemetry.context.AnalyticsCollection.Collection, io.bloombox.schema.telemetry.context.AnalyticsCollection.Collection.Builder, io.bloombox.schema.telemetry.context.AnalyticsCollection.CollectionOrBuilder>(
                  getCollection(),
                  getParentForChildren(),
                  isClean());
          collection_ = null;
        }
        return collectionBuilder_;
      }

      private io.bloombox.schema.identity.UserKey userKey_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.identity.UserKey, io.bloombox.schema.identity.UserKey.Builder, io.bloombox.schema.identity.UserKeyOrBuilder> userKeyBuilder_;
      /**
       * <pre>
       * Specifies the user associated with this event, if known.
       * </pre>
       *
       * <code>.bloombox.schema.identity.UserKey user_key = 2 [(.gen_bq_schema.description) = "Specifies the user associated with this event, if known."];</code>
       */
      public boolean hasUserKey() {
        return userKeyBuilder_ != null || userKey_ != null;
      }
      /**
       * <pre>
       * Specifies the user associated with this event, if known.
       * </pre>
       *
       * <code>.bloombox.schema.identity.UserKey user_key = 2 [(.gen_bq_schema.description) = "Specifies the user associated with this event, if known."];</code>
       */
      public io.bloombox.schema.identity.UserKey getUserKey() {
        if (userKeyBuilder_ == null) {
          return userKey_ == null ? io.bloombox.schema.identity.UserKey.getDefaultInstance() : userKey_;
        } else {
          return userKeyBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Specifies the user associated with this event, if known.
       * </pre>
       *
       * <code>.bloombox.schema.identity.UserKey user_key = 2 [(.gen_bq_schema.description) = "Specifies the user associated with this event, if known."];</code>
       */
      public Builder setUserKey(io.bloombox.schema.identity.UserKey value) {
        if (userKeyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          userKey_ = value;
          onChanged();
        } else {
          userKeyBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies the user associated with this event, if known.
       * </pre>
       *
       * <code>.bloombox.schema.identity.UserKey user_key = 2 [(.gen_bq_schema.description) = "Specifies the user associated with this event, if known."];</code>
       */
      public Builder setUserKey(
          io.bloombox.schema.identity.UserKey.Builder builderForValue) {
        if (userKeyBuilder_ == null) {
          userKey_ = builderForValue.build();
          onChanged();
        } else {
          userKeyBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Specifies the user associated with this event, if known.
       * </pre>
       *
       * <code>.bloombox.schema.identity.UserKey user_key = 2 [(.gen_bq_schema.description) = "Specifies the user associated with this event, if known."];</code>
       */
      public Builder mergeUserKey(io.bloombox.schema.identity.UserKey value) {
        if (userKeyBuilder_ == null) {
          if (userKey_ != null) {
            userKey_ =
              io.bloombox.schema.identity.UserKey.newBuilder(userKey_).mergeFrom(value).buildPartial();
          } else {
            userKey_ = value;
          }
          onChanged();
        } else {
          userKeyBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies the user associated with this event, if known.
       * </pre>
       *
       * <code>.bloombox.schema.identity.UserKey user_key = 2 [(.gen_bq_schema.description) = "Specifies the user associated with this event, if known."];</code>
       */
      public Builder clearUserKey() {
        if (userKeyBuilder_ == null) {
          userKey_ = null;
          onChanged();
        } else {
          userKey_ = null;
          userKeyBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Specifies the user associated with this event, if known.
       * </pre>
       *
       * <code>.bloombox.schema.identity.UserKey user_key = 2 [(.gen_bq_schema.description) = "Specifies the user associated with this event, if known."];</code>
       */
      public io.bloombox.schema.identity.UserKey.Builder getUserKeyBuilder() {
        
        onChanged();
        return getUserKeyFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Specifies the user associated with this event, if known.
       * </pre>
       *
       * <code>.bloombox.schema.identity.UserKey user_key = 2 [(.gen_bq_schema.description) = "Specifies the user associated with this event, if known."];</code>
       */
      public io.bloombox.schema.identity.UserKeyOrBuilder getUserKeyOrBuilder() {
        if (userKeyBuilder_ != null) {
          return userKeyBuilder_.getMessageOrBuilder();
        } else {
          return userKey_ == null ?
              io.bloombox.schema.identity.UserKey.getDefaultInstance() : userKey_;
        }
      }
      /**
       * <pre>
       * Specifies the user associated with this event, if known.
       * </pre>
       *
       * <code>.bloombox.schema.identity.UserKey user_key = 2 [(.gen_bq_schema.description) = "Specifies the user associated with this event, if known."];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.identity.UserKey, io.bloombox.schema.identity.UserKey.Builder, io.bloombox.schema.identity.UserKeyOrBuilder> 
          getUserKeyFieldBuilder() {
        if (userKeyBuilder_ == null) {
          userKeyBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.identity.UserKey, io.bloombox.schema.identity.UserKey.Builder, io.bloombox.schema.identity.UserKeyOrBuilder>(
                  getUserKey(),
                  getParentForChildren(),
                  isClean());
          userKey_ = null;
        }
        return userKeyBuilder_;
      }

      private java.lang.Object fingerprint_ = "";
      /**
       * <pre>
       * Unique device fingerprint for this analytics context.
       * </pre>
       *
       * <code>string fingerprint = 3 [(.gen_bq_schema.description) = "Unique device fingerprint for this analytics context."];</code>
       */
      public java.lang.String getFingerprint() {
        java.lang.Object ref = fingerprint_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          fingerprint_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Unique device fingerprint for this analytics context.
       * </pre>
       *
       * <code>string fingerprint = 3 [(.gen_bq_schema.description) = "Unique device fingerprint for this analytics context."];</code>
       */
      public com.google.protobuf.ByteString
          getFingerprintBytes() {
        java.lang.Object ref = fingerprint_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          fingerprint_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Unique device fingerprint for this analytics context.
       * </pre>
       *
       * <code>string fingerprint = 3 [(.gen_bq_schema.description) = "Unique device fingerprint for this analytics context."];</code>
       */
      public Builder setFingerprint(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        fingerprint_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Unique device fingerprint for this analytics context.
       * </pre>
       *
       * <code>string fingerprint = 3 [(.gen_bq_schema.description) = "Unique device fingerprint for this analytics context."];</code>
       */
      public Builder clearFingerprint() {
        
        fingerprint_ = getDefaultInstance().getFingerprint();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Unique device fingerprint for this analytics context.
       * </pre>
       *
       * <code>string fingerprint = 3 [(.gen_bq_schema.description) = "Unique device fingerprint for this analytics context."];</code>
       */
      public Builder setFingerprintBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        fingerprint_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object group_ = "";
      /**
       * <pre>
       * Arbitrary group ID for this event. Gathers events into buckets of variable size, usually used to indicate a user
       * or device session.
       * </pre>
       *
       * <code>string group = 4 [(.gen_bq_schema.description) = "Arbitrary group ID for this event. Gathers events into buckets of variable size, usually used to indicate a user or device session."];</code>
       */
      public java.lang.String getGroup() {
        java.lang.Object ref = group_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          group_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Arbitrary group ID for this event. Gathers events into buckets of variable size, usually used to indicate a user
       * or device session.
       * </pre>
       *
       * <code>string group = 4 [(.gen_bq_schema.description) = "Arbitrary group ID for this event. Gathers events into buckets of variable size, usually used to indicate a user or device session."];</code>
       */
      public com.google.protobuf.ByteString
          getGroupBytes() {
        java.lang.Object ref = group_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          group_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Arbitrary group ID for this event. Gathers events into buckets of variable size, usually used to indicate a user
       * or device session.
       * </pre>
       *
       * <code>string group = 4 [(.gen_bq_schema.description) = "Arbitrary group ID for this event. Gathers events into buckets of variable size, usually used to indicate a user or device session."];</code>
       */
      public Builder setGroup(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        group_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Arbitrary group ID for this event. Gathers events into buckets of variable size, usually used to indicate a user
       * or device session.
       * </pre>
       *
       * <code>string group = 4 [(.gen_bq_schema.description) = "Arbitrary group ID for this event. Gathers events into buckets of variable size, usually used to indicate a user or device session."];</code>
       */
      public Builder clearGroup() {
        
        group_ = getDefaultInstance().getGroup();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Arbitrary group ID for this event. Gathers events into buckets of variable size, usually used to indicate a user
       * or device session.
       * </pre>
       *
       * <code>string group = 4 [(.gen_bq_schema.description) = "Arbitrary group ID for this event. Gathers events into buckets of variable size, usually used to indicate a user or device session."];</code>
       */
      public Builder setGroupBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        group_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object hostname_ = "";
      /**
       * <pre>
       * Hostname of the server or client that transmitted this information, if it is known.
       * </pre>
       *
       * <code>string hostname = 5 [(.gen_bq_schema.description) = "Hostname of the server or client that transmitted this information, if it is known."];</code>
       */
      public java.lang.String getHostname() {
        java.lang.Object ref = hostname_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          hostname_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Hostname of the server or client that transmitted this information, if it is known.
       * </pre>
       *
       * <code>string hostname = 5 [(.gen_bq_schema.description) = "Hostname of the server or client that transmitted this information, if it is known."];</code>
       */
      public com.google.protobuf.ByteString
          getHostnameBytes() {
        java.lang.Object ref = hostname_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          hostname_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Hostname of the server or client that transmitted this information, if it is known.
       * </pre>
       *
       * <code>string hostname = 5 [(.gen_bq_schema.description) = "Hostname of the server or client that transmitted this information, if it is known."];</code>
       */
      public Builder setHostname(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        hostname_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Hostname of the server or client that transmitted this information, if it is known.
       * </pre>
       *
       * <code>string hostname = 5 [(.gen_bq_schema.description) = "Hostname of the server or client that transmitted this information, if it is known."];</code>
       */
      public Builder clearHostname() {
        
        hostname_ = getDefaultInstance().getHostname();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Hostname of the server or client that transmitted this information, if it is known.
       * </pre>
       *
       * <code>string hostname = 5 [(.gen_bq_schema.description) = "Hostname of the server or client that transmitted this information, if it is known."];</code>
       */
      public Builder setHostnameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        hostname_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object ipAddress_ = "";
      /**
       * <pre>
       * IP address of the server or client that transmitted this information, if is is known.
       * </pre>
       *
       * <code>string ip_address = 6 [(.gen_bq_schema.description) = "IP address of the server or client that transmitted this information, if is is known."];</code>
       */
      public java.lang.String getIpAddress() {
        java.lang.Object ref = ipAddress_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          ipAddress_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * IP address of the server or client that transmitted this information, if is is known.
       * </pre>
       *
       * <code>string ip_address = 6 [(.gen_bq_schema.description) = "IP address of the server or client that transmitted this information, if is is known."];</code>
       */
      public com.google.protobuf.ByteString
          getIpAddressBytes() {
        java.lang.Object ref = ipAddress_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          ipAddress_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * IP address of the server or client that transmitted this information, if is is known.
       * </pre>
       *
       * <code>string ip_address = 6 [(.gen_bq_schema.description) = "IP address of the server or client that transmitted this information, if is is known."];</code>
       */
      public Builder setIpAddress(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        ipAddress_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * IP address of the server or client that transmitted this information, if is is known.
       * </pre>
       *
       * <code>string ip_address = 6 [(.gen_bq_schema.description) = "IP address of the server or client that transmitted this information, if is is known."];</code>
       */
      public Builder clearIpAddress() {
        
        ipAddress_ = getDefaultInstance().getIpAddress();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * IP address of the server or client that transmitted this information, if is is known.
       * </pre>
       *
       * <code>string ip_address = 6 [(.gen_bq_schema.description) = "IP address of the server or client that transmitted this information, if is is known."];</code>
       */
      public Builder setIpAddressBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        ipAddress_ = value;
        onChanged();
        return this;
      }

      private io.bloombox.schema.telemetry.AnalyticsScope.Scope scope_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.telemetry.AnalyticsScope.Scope, io.bloombox.schema.telemetry.AnalyticsScope.Scope.Builder, io.bloombox.schema.telemetry.AnalyticsScope.ScopeOrBuilder> scopeBuilder_;
      /**
       * <pre>
       * Partner and commercial scope of this event.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.Scope scope = 7 [(.gen_bq_schema.description) = "Partner and commercial scope of this event."];</code>
       */
      public boolean hasScope() {
        return scopeBuilder_ != null || scope_ != null;
      }
      /**
       * <pre>
       * Partner and commercial scope of this event.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.Scope scope = 7 [(.gen_bq_schema.description) = "Partner and commercial scope of this event."];</code>
       */
      public io.bloombox.schema.telemetry.AnalyticsScope.Scope getScope() {
        if (scopeBuilder_ == null) {
          return scope_ == null ? io.bloombox.schema.telemetry.AnalyticsScope.Scope.getDefaultInstance() : scope_;
        } else {
          return scopeBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Partner and commercial scope of this event.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.Scope scope = 7 [(.gen_bq_schema.description) = "Partner and commercial scope of this event."];</code>
       */
      public Builder setScope(io.bloombox.schema.telemetry.AnalyticsScope.Scope value) {
        if (scopeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          scope_ = value;
          onChanged();
        } else {
          scopeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Partner and commercial scope of this event.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.Scope scope = 7 [(.gen_bq_schema.description) = "Partner and commercial scope of this event."];</code>
       */
      public Builder setScope(
          io.bloombox.schema.telemetry.AnalyticsScope.Scope.Builder builderForValue) {
        if (scopeBuilder_ == null) {
          scope_ = builderForValue.build();
          onChanged();
        } else {
          scopeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Partner and commercial scope of this event.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.Scope scope = 7 [(.gen_bq_schema.description) = "Partner and commercial scope of this event."];</code>
       */
      public Builder mergeScope(io.bloombox.schema.telemetry.AnalyticsScope.Scope value) {
        if (scopeBuilder_ == null) {
          if (scope_ != null) {
            scope_ =
              io.bloombox.schema.telemetry.AnalyticsScope.Scope.newBuilder(scope_).mergeFrom(value).buildPartial();
          } else {
            scope_ = value;
          }
          onChanged();
        } else {
          scopeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Partner and commercial scope of this event.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.Scope scope = 7 [(.gen_bq_schema.description) = "Partner and commercial scope of this event."];</code>
       */
      public Builder clearScope() {
        if (scopeBuilder_ == null) {
          scope_ = null;
          onChanged();
        } else {
          scope_ = null;
          scopeBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Partner and commercial scope of this event.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.Scope scope = 7 [(.gen_bq_schema.description) = "Partner and commercial scope of this event."];</code>
       */
      public io.bloombox.schema.telemetry.AnalyticsScope.Scope.Builder getScopeBuilder() {
        
        onChanged();
        return getScopeFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Partner and commercial scope of this event.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.Scope scope = 7 [(.gen_bq_schema.description) = "Partner and commercial scope of this event."];</code>
       */
      public io.bloombox.schema.telemetry.AnalyticsScope.ScopeOrBuilder getScopeOrBuilder() {
        if (scopeBuilder_ != null) {
          return scopeBuilder_.getMessageOrBuilder();
        } else {
          return scope_ == null ?
              io.bloombox.schema.telemetry.AnalyticsScope.Scope.getDefaultInstance() : scope_;
        }
      }
      /**
       * <pre>
       * Partner and commercial scope of this event.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.Scope scope = 7 [(.gen_bq_schema.description) = "Partner and commercial scope of this event."];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.telemetry.AnalyticsScope.Scope, io.bloombox.schema.telemetry.AnalyticsScope.Scope.Builder, io.bloombox.schema.telemetry.AnalyticsScope.ScopeOrBuilder> 
          getScopeFieldBuilder() {
        if (scopeBuilder_ == null) {
          scopeBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.telemetry.AnalyticsScope.Scope, io.bloombox.schema.telemetry.AnalyticsScope.Scope.Builder, io.bloombox.schema.telemetry.AnalyticsScope.ScopeOrBuilder>(
                  getScope(),
                  getParentForChildren(),
                  isClean());
          scope_ = null;
        }
        return scopeBuilder_;
      }

      private io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication app_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication, io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication.Builder, io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplicationOrBuilder> appBuilder_;
      /**
       * <pre>
       * Application version information.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceApplication app = 8 [(.gen_bq_schema.description) = "Application version information."];</code>
       */
      public boolean hasApp() {
        return appBuilder_ != null || app_ != null;
      }
      /**
       * <pre>
       * Application version information.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceApplication app = 8 [(.gen_bq_schema.description) = "Application version information."];</code>
       */
      public io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication getApp() {
        if (appBuilder_ == null) {
          return app_ == null ? io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication.getDefaultInstance() : app_;
        } else {
          return appBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Application version information.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceApplication app = 8 [(.gen_bq_schema.description) = "Application version information."];</code>
       */
      public Builder setApp(io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication value) {
        if (appBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          app_ = value;
          onChanged();
        } else {
          appBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Application version information.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceApplication app = 8 [(.gen_bq_schema.description) = "Application version information."];</code>
       */
      public Builder setApp(
          io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication.Builder builderForValue) {
        if (appBuilder_ == null) {
          app_ = builderForValue.build();
          onChanged();
        } else {
          appBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Application version information.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceApplication app = 8 [(.gen_bq_schema.description) = "Application version information."];</code>
       */
      public Builder mergeApp(io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication value) {
        if (appBuilder_ == null) {
          if (app_ != null) {
            app_ =
              io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication.newBuilder(app_).mergeFrom(value).buildPartial();
          } else {
            app_ = value;
          }
          onChanged();
        } else {
          appBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Application version information.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceApplication app = 8 [(.gen_bq_schema.description) = "Application version information."];</code>
       */
      public Builder clearApp() {
        if (appBuilder_ == null) {
          app_ = null;
          onChanged();
        } else {
          app_ = null;
          appBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Application version information.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceApplication app = 8 [(.gen_bq_schema.description) = "Application version information."];</code>
       */
      public io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication.Builder getAppBuilder() {
        
        onChanged();
        return getAppFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Application version information.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceApplication app = 8 [(.gen_bq_schema.description) = "Application version information."];</code>
       */
      public io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplicationOrBuilder getAppOrBuilder() {
        if (appBuilder_ != null) {
          return appBuilder_.getMessageOrBuilder();
        } else {
          return app_ == null ?
              io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication.getDefaultInstance() : app_;
        }
      }
      /**
       * <pre>
       * Application version information.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceApplication app = 8 [(.gen_bq_schema.description) = "Application version information."];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication, io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication.Builder, io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplicationOrBuilder> 
          getAppFieldBuilder() {
        if (appBuilder_ == null) {
          appBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication, io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication.Builder, io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplicationOrBuilder>(
                  getApp(),
                  getParentForChildren(),
                  isClean());
          app_ = null;
        }
        return appBuilder_;
      }

      private io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary library_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary, io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary.Builder, io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibraryOrBuilder> libraryBuilder_;
      /**
       * <pre>
       * Library version information.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceLibrary library = 9 [(.gen_bq_schema.description) = "Library version information."];</code>
       */
      public boolean hasLibrary() {
        return libraryBuilder_ != null || library_ != null;
      }
      /**
       * <pre>
       * Library version information.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceLibrary library = 9 [(.gen_bq_schema.description) = "Library version information."];</code>
       */
      public io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary getLibrary() {
        if (libraryBuilder_ == null) {
          return library_ == null ? io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary.getDefaultInstance() : library_;
        } else {
          return libraryBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Library version information.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceLibrary library = 9 [(.gen_bq_schema.description) = "Library version information."];</code>
       */
      public Builder setLibrary(io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary value) {
        if (libraryBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          library_ = value;
          onChanged();
        } else {
          libraryBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Library version information.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceLibrary library = 9 [(.gen_bq_schema.description) = "Library version information."];</code>
       */
      public Builder setLibrary(
          io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary.Builder builderForValue) {
        if (libraryBuilder_ == null) {
          library_ = builderForValue.build();
          onChanged();
        } else {
          libraryBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Library version information.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceLibrary library = 9 [(.gen_bq_schema.description) = "Library version information."];</code>
       */
      public Builder mergeLibrary(io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary value) {
        if (libraryBuilder_ == null) {
          if (library_ != null) {
            library_ =
              io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary.newBuilder(library_).mergeFrom(value).buildPartial();
          } else {
            library_ = value;
          }
          onChanged();
        } else {
          libraryBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Library version information.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceLibrary library = 9 [(.gen_bq_schema.description) = "Library version information."];</code>
       */
      public Builder clearLibrary() {
        if (libraryBuilder_ == null) {
          library_ = null;
          onChanged();
        } else {
          library_ = null;
          libraryBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Library version information.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceLibrary library = 9 [(.gen_bq_schema.description) = "Library version information."];</code>
       */
      public io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary.Builder getLibraryBuilder() {
        
        onChanged();
        return getLibraryFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Library version information.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceLibrary library = 9 [(.gen_bq_schema.description) = "Library version information."];</code>
       */
      public io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibraryOrBuilder getLibraryOrBuilder() {
        if (libraryBuilder_ != null) {
          return libraryBuilder_.getMessageOrBuilder();
        } else {
          return library_ == null ?
              io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary.getDefaultInstance() : library_;
        }
      }
      /**
       * <pre>
       * Library version information.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceLibrary library = 9 [(.gen_bq_schema.description) = "Library version information."];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary, io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary.Builder, io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibraryOrBuilder> 
          getLibraryFieldBuilder() {
        if (libraryBuilder_ == null) {
          libraryBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary, io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary.Builder, io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibraryOrBuilder>(
                  getLibrary(),
                  getParentForChildren(),
                  isClean());
          library_ = null;
        }
        return libraryBuilder_;
      }

      private io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext native_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext, io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext.Builder, io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContextOrBuilder> nativeBuilder_;
      /**
       * <pre>
       * Specifies information about a native device, when the event is being sent from a native context of some kind,
       * such as a mobile phone application or embedded device running partner code.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.NativeDeviceContext native = 10 [(.gen_bq_schema.description) = "Specifies information about a native device, when the event is being sent from a native context of some kind, such as a mobile phone application or embedded device running partner code."];</code>
       */
      public boolean hasNative() {
        return nativeBuilder_ != null || native_ != null;
      }
      /**
       * <pre>
       * Specifies information about a native device, when the event is being sent from a native context of some kind,
       * such as a mobile phone application or embedded device running partner code.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.NativeDeviceContext native = 10 [(.gen_bq_schema.description) = "Specifies information about a native device, when the event is being sent from a native context of some kind, such as a mobile phone application or embedded device running partner code."];</code>
       */
      public io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext getNative() {
        if (nativeBuilder_ == null) {
          return native_ == null ? io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext.getDefaultInstance() : native_;
        } else {
          return nativeBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Specifies information about a native device, when the event is being sent from a native context of some kind,
       * such as a mobile phone application or embedded device running partner code.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.NativeDeviceContext native = 10 [(.gen_bq_schema.description) = "Specifies information about a native device, when the event is being sent from a native context of some kind, such as a mobile phone application or embedded device running partner code."];</code>
       */
      public Builder setNative(io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext value) {
        if (nativeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          native_ = value;
          onChanged();
        } else {
          nativeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies information about a native device, when the event is being sent from a native context of some kind,
       * such as a mobile phone application or embedded device running partner code.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.NativeDeviceContext native = 10 [(.gen_bq_schema.description) = "Specifies information about a native device, when the event is being sent from a native context of some kind, such as a mobile phone application or embedded device running partner code."];</code>
       */
      public Builder setNative(
          io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext.Builder builderForValue) {
        if (nativeBuilder_ == null) {
          native_ = builderForValue.build();
          onChanged();
        } else {
          nativeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Specifies information about a native device, when the event is being sent from a native context of some kind,
       * such as a mobile phone application or embedded device running partner code.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.NativeDeviceContext native = 10 [(.gen_bq_schema.description) = "Specifies information about a native device, when the event is being sent from a native context of some kind, such as a mobile phone application or embedded device running partner code."];</code>
       */
      public Builder mergeNative(io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext value) {
        if (nativeBuilder_ == null) {
          if (native_ != null) {
            native_ =
              io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext.newBuilder(native_).mergeFrom(value).buildPartial();
          } else {
            native_ = value;
          }
          onChanged();
        } else {
          nativeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies information about a native device, when the event is being sent from a native context of some kind,
       * such as a mobile phone application or embedded device running partner code.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.NativeDeviceContext native = 10 [(.gen_bq_schema.description) = "Specifies information about a native device, when the event is being sent from a native context of some kind, such as a mobile phone application or embedded device running partner code."];</code>
       */
      public Builder clearNative() {
        if (nativeBuilder_ == null) {
          native_ = null;
          onChanged();
        } else {
          native_ = null;
          nativeBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Specifies information about a native device, when the event is being sent from a native context of some kind,
       * such as a mobile phone application or embedded device running partner code.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.NativeDeviceContext native = 10 [(.gen_bq_schema.description) = "Specifies information about a native device, when the event is being sent from a native context of some kind, such as a mobile phone application or embedded device running partner code."];</code>
       */
      public io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext.Builder getNativeBuilder() {
        
        onChanged();
        return getNativeFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Specifies information about a native device, when the event is being sent from a native context of some kind,
       * such as a mobile phone application or embedded device running partner code.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.NativeDeviceContext native = 10 [(.gen_bq_schema.description) = "Specifies information about a native device, when the event is being sent from a native context of some kind, such as a mobile phone application or embedded device running partner code."];</code>
       */
      public io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContextOrBuilder getNativeOrBuilder() {
        if (nativeBuilder_ != null) {
          return nativeBuilder_.getMessageOrBuilder();
        } else {
          return native_ == null ?
              io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext.getDefaultInstance() : native_;
        }
      }
      /**
       * <pre>
       * Specifies information about a native device, when the event is being sent from a native context of some kind,
       * such as a mobile phone application or embedded device running partner code.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.NativeDeviceContext native = 10 [(.gen_bq_schema.description) = "Specifies information about a native device, when the event is being sent from a native context of some kind, such as a mobile phone application or embedded device running partner code."];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext, io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext.Builder, io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContextOrBuilder> 
          getNativeFieldBuilder() {
        if (nativeBuilder_ == null) {
          nativeBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext, io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext.Builder, io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContextOrBuilder>(
                  getNative(),
                  getParentForChildren(),
                  isClean());
          native_ = null;
        }
        return nativeBuilder_;
      }

      private io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext browser_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext, io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext.Builder, io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContextOrBuilder> browserBuilder_;
      /**
       * <pre>
       * Specifies information about a web browser, when the event is being sent from some kind of web browsing context.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.BrowserDeviceContext browser = 11 [(.gen_bq_schema.description) = "Specifies information about a web browser, when the event is being sent from some kind of web browsing context."];</code>
       */
      public boolean hasBrowser() {
        return browserBuilder_ != null || browser_ != null;
      }
      /**
       * <pre>
       * Specifies information about a web browser, when the event is being sent from some kind of web browsing context.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.BrowserDeviceContext browser = 11 [(.gen_bq_schema.description) = "Specifies information about a web browser, when the event is being sent from some kind of web browsing context."];</code>
       */
      public io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext getBrowser() {
        if (browserBuilder_ == null) {
          return browser_ == null ? io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext.getDefaultInstance() : browser_;
        } else {
          return browserBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Specifies information about a web browser, when the event is being sent from some kind of web browsing context.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.BrowserDeviceContext browser = 11 [(.gen_bq_schema.description) = "Specifies information about a web browser, when the event is being sent from some kind of web browsing context."];</code>
       */
      public Builder setBrowser(io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext value) {
        if (browserBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          browser_ = value;
          onChanged();
        } else {
          browserBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies information about a web browser, when the event is being sent from some kind of web browsing context.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.BrowserDeviceContext browser = 11 [(.gen_bq_schema.description) = "Specifies information about a web browser, when the event is being sent from some kind of web browsing context."];</code>
       */
      public Builder setBrowser(
          io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext.Builder builderForValue) {
        if (browserBuilder_ == null) {
          browser_ = builderForValue.build();
          onChanged();
        } else {
          browserBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Specifies information about a web browser, when the event is being sent from some kind of web browsing context.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.BrowserDeviceContext browser = 11 [(.gen_bq_schema.description) = "Specifies information about a web browser, when the event is being sent from some kind of web browsing context."];</code>
       */
      public Builder mergeBrowser(io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext value) {
        if (browserBuilder_ == null) {
          if (browser_ != null) {
            browser_ =
              io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext.newBuilder(browser_).mergeFrom(value).buildPartial();
          } else {
            browser_ = value;
          }
          onChanged();
        } else {
          browserBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies information about a web browser, when the event is being sent from some kind of web browsing context.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.BrowserDeviceContext browser = 11 [(.gen_bq_schema.description) = "Specifies information about a web browser, when the event is being sent from some kind of web browsing context."];</code>
       */
      public Builder clearBrowser() {
        if (browserBuilder_ == null) {
          browser_ = null;
          onChanged();
        } else {
          browser_ = null;
          browserBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Specifies information about a web browser, when the event is being sent from some kind of web browsing context.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.BrowserDeviceContext browser = 11 [(.gen_bq_schema.description) = "Specifies information about a web browser, when the event is being sent from some kind of web browsing context."];</code>
       */
      public io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext.Builder getBrowserBuilder() {
        
        onChanged();
        return getBrowserFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Specifies information about a web browser, when the event is being sent from some kind of web browsing context.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.BrowserDeviceContext browser = 11 [(.gen_bq_schema.description) = "Specifies information about a web browser, when the event is being sent from some kind of web browsing context."];</code>
       */
      public io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContextOrBuilder getBrowserOrBuilder() {
        if (browserBuilder_ != null) {
          return browserBuilder_.getMessageOrBuilder();
        } else {
          return browser_ == null ?
              io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext.getDefaultInstance() : browser_;
        }
      }
      /**
       * <pre>
       * Specifies information about a web browser, when the event is being sent from some kind of web browsing context.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.BrowserDeviceContext browser = 11 [(.gen_bq_schema.description) = "Specifies information about a web browser, when the event is being sent from some kind of web browsing context."];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext, io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext.Builder, io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContextOrBuilder> 
          getBrowserFieldBuilder() {
        if (browserBuilder_ == null) {
          browserBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext, io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext.Builder, io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContextOrBuilder>(
                  getBrowser(),
                  getParentForChildren(),
                  isClean());
          browser_ = null;
        }
        return browserBuilder_;
      }

      private io.opencannabis.schema.geo.Location location_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.geo.Location, io.opencannabis.schema.geo.Location.Builder, io.opencannabis.schema.geo.LocationOrBuilder> locationBuilder_;
      /**
       * <pre>
       * Origin location for this event, as determined by geolocation or explicit inclusion in the event payload.
       * </pre>
       *
       * <code>.opencannabis.geo.Location location = 12 [(.gen_bq_schema.description) = "Origin location for this event, as determined by geolocation or explicit inclusion in the event payload."];</code>
       */
      public boolean hasLocation() {
        return locationBuilder_ != null || location_ != null;
      }
      /**
       * <pre>
       * Origin location for this event, as determined by geolocation or explicit inclusion in the event payload.
       * </pre>
       *
       * <code>.opencannabis.geo.Location location = 12 [(.gen_bq_schema.description) = "Origin location for this event, as determined by geolocation or explicit inclusion in the event payload."];</code>
       */
      public io.opencannabis.schema.geo.Location getLocation() {
        if (locationBuilder_ == null) {
          return location_ == null ? io.opencannabis.schema.geo.Location.getDefaultInstance() : location_;
        } else {
          return locationBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Origin location for this event, as determined by geolocation or explicit inclusion in the event payload.
       * </pre>
       *
       * <code>.opencannabis.geo.Location location = 12 [(.gen_bq_schema.description) = "Origin location for this event, as determined by geolocation or explicit inclusion in the event payload."];</code>
       */
      public Builder setLocation(io.opencannabis.schema.geo.Location value) {
        if (locationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          location_ = value;
          onChanged();
        } else {
          locationBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Origin location for this event, as determined by geolocation or explicit inclusion in the event payload.
       * </pre>
       *
       * <code>.opencannabis.geo.Location location = 12 [(.gen_bq_schema.description) = "Origin location for this event, as determined by geolocation or explicit inclusion in the event payload."];</code>
       */
      public Builder setLocation(
          io.opencannabis.schema.geo.Location.Builder builderForValue) {
        if (locationBuilder_ == null) {
          location_ = builderForValue.build();
          onChanged();
        } else {
          locationBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Origin location for this event, as determined by geolocation or explicit inclusion in the event payload.
       * </pre>
       *
       * <code>.opencannabis.geo.Location location = 12 [(.gen_bq_schema.description) = "Origin location for this event, as determined by geolocation or explicit inclusion in the event payload."];</code>
       */
      public Builder mergeLocation(io.opencannabis.schema.geo.Location value) {
        if (locationBuilder_ == null) {
          if (location_ != null) {
            location_ =
              io.opencannabis.schema.geo.Location.newBuilder(location_).mergeFrom(value).buildPartial();
          } else {
            location_ = value;
          }
          onChanged();
        } else {
          locationBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Origin location for this event, as determined by geolocation or explicit inclusion in the event payload.
       * </pre>
       *
       * <code>.opencannabis.geo.Location location = 12 [(.gen_bq_schema.description) = "Origin location for this event, as determined by geolocation or explicit inclusion in the event payload."];</code>
       */
      public Builder clearLocation() {
        if (locationBuilder_ == null) {
          location_ = null;
          onChanged();
        } else {
          location_ = null;
          locationBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Origin location for this event, as determined by geolocation or explicit inclusion in the event payload.
       * </pre>
       *
       * <code>.opencannabis.geo.Location location = 12 [(.gen_bq_schema.description) = "Origin location for this event, as determined by geolocation or explicit inclusion in the event payload."];</code>
       */
      public io.opencannabis.schema.geo.Location.Builder getLocationBuilder() {
        
        onChanged();
        return getLocationFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Origin location for this event, as determined by geolocation or explicit inclusion in the event payload.
       * </pre>
       *
       * <code>.opencannabis.geo.Location location = 12 [(.gen_bq_schema.description) = "Origin location for this event, as determined by geolocation or explicit inclusion in the event payload."];</code>
       */
      public io.opencannabis.schema.geo.LocationOrBuilder getLocationOrBuilder() {
        if (locationBuilder_ != null) {
          return locationBuilder_.getMessageOrBuilder();
        } else {
          return location_ == null ?
              io.opencannabis.schema.geo.Location.getDefaultInstance() : location_;
        }
      }
      /**
       * <pre>
       * Origin location for this event, as determined by geolocation or explicit inclusion in the event payload.
       * </pre>
       *
       * <code>.opencannabis.geo.Location location = 12 [(.gen_bq_schema.description) = "Origin location for this event, as determined by geolocation or explicit inclusion in the event payload."];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.geo.Location, io.opencannabis.schema.geo.Location.Builder, io.opencannabis.schema.geo.LocationOrBuilder> 
          getLocationFieldBuilder() {
        if (locationBuilder_ == null) {
          locationBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.geo.Location, io.opencannabis.schema.geo.Location.Builder, io.opencannabis.schema.geo.LocationOrBuilder>(
                  getLocation(),
                  getParentForChildren(),
                  isClean());
          location_ = null;
        }
        return locationBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.analytics.Context)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.analytics.Context)
    private static final io.bloombox.schema.telemetry.AnalyticsContext.Context DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.telemetry.AnalyticsContext.Context();
    }

    public static io.bloombox.schema.telemetry.AnalyticsContext.Context getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Context>
        PARSER = new com.google.protobuf.AbstractParser<Context>() {
      public Context parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Context(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Context> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Context> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.telemetry.AnalyticsContext.Context getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_analytics_EventPosition_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_analytics_EventPosition_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_analytics_EventActors_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_analytics_EventActors_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_analytics_Context_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_analytics_Context_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\027analytics/Context.proto\022\031bloombox.sche" +
      "ma.analytics\032\016bq_field.proto\032\022geo/Locati" +
      "on.proto\032\023identity/User.proto\032\026temporal/" +
      "Instant.proto\032\025partner/Partner.proto\032\035pa" +
      "rtner/PartnerLocation.proto\032\025analytics/S" +
      "cope.proto\032\037analytics/context/Browser.pr" +
      "oto\032\037analytics/context/Library.proto\032\"an" +
      "alytics/context/Collection.proto\032#analyt" +
      "ics/context/Application.proto\032$analytics" +
      "/context/NativeDevice.proto\"\322\004\n\rEventPos" +
      "ition\022\226\001\n\006ingest\030\002 \001(\0132\036.opencannabis.te" +
      "mporal.InstantBf\360?\001\372?\tTIMESTAMP\212@TTimest" +
      "amp describing when this event was inges" +
      "ted by the backend telemetry pipeline.\022\244" +
      "\001\n\010occurred\030\003 \001(\0132\036.opencannabis.tempora" +
      "l.InstantBr\360?\001\372?\tTIMESTAMP\212@`Timestamp d" +
      "escribing when this event occurred, as r" +
      "eported by the submitting device or endp" +
      "oint.\022\202\001\n\tprocessed\030\004 \001(\004Bo\372?\tTIMESTAMP\212" +
      "@`Timestamp describing when this event o" +
      "ccurred, as reported by the submitting d" +
      "evice or endpoint.\022|\n\010enriched\030\005 \001(\004Bj\372?" +
      "\tTIMESTAMP\212@[Timestamps describing each " +
      "instance of this event being enriched by" +
      " the telemetry pipeline.\"\340\002\n\013EventActors" +
      "\022n\n\004user\030\001 \001(\0132\036.bloombox.schema.identit" +
      "y.UserB@\212@=User account that was logged " +
      "in when the event was submitted.\022j\n\007part" +
      "ner\030\002 \001(\0132 .bloombox.schema.partner.Part" +
      "nerB7\212@4Partner account under which the " +
      "event was submitted.\022u\n\010location\030\003 \001(\0132(" +
      ".bloombox.schema.partner.PartnerLocation" +
      "B9\212@6Location account under which this e" +
      "vent was submitted.\"\322\014\n\007Context\022\202\001\n\ncoll" +
      "ection\030\001 \001(\0132-.bloombox.schema.analytics" +
      ".context.CollectionB?\360?\001\212@9Collection in" +
      "formation, specifies event type or categ" +
      "ory.\022p\n\010user_key\030\002 \001(\0132!.bloombox.schema" +
      ".identity.UserKeyB;\212@8Specifies the user" +
      " associated with this event, if known.\022M" +
      "\n\013fingerprint\030\003 \001(\tB8\212@5Unique device fi" +
      "ngerprint for this analytics context.\022\227\001" +
      "\n\005group\030\004 \001(\tB\207\001\212@\203\001Arbitrary group ID f" +
      "or this event. Gathers events into bucke" +
      "ts of variable size, usually used to ind" +
      "icate a user or device session.\022h\n\010hostn" +
      "ame\030\005 \001(\tBV\212@SHostname of the server or " +
      "client that transmitted this information" +
      ", if it is known.\022l\n\nip_address\030\006 \001(\tBX\212" +
      "@UIP address of the server or client tha" +
      "t transmitted this information, if is is" +
      " known.\022_\n\005scope\030\007 \001(\0132 .bloombox.schema" +
      ".analytics.ScopeB.\212@+Partner and commerc" +
      "ial scope of this event.\022f\n\003app\030\010 \001(\01324." +
      "bloombox.schema.analytics.context.Device" +
      "ApplicationB#\212@ Application version info" +
      "rmation.\022b\n\007library\030\t \001(\01320.bloombox.sch" +
      "ema.analytics.context.DeviceLibraryB\037\212@\034" +
      "Library version information.\022\206\002\n\006native\030" +
      "\n \001(\01326.bloombox.schema.analytics.contex" +
      "t.NativeDeviceContextB\275\001\212@\271\001Specifies in" +
      "formation about a native device, when th" +
      "e event is being sent from a native cont" +
      "ext of some kind, such as a mobile phone" +
      " application or embedded device running " +
      "partner code.\022\274\001\n\007browser\030\013 \001(\01327.bloomb" +
      "ox.schema.analytics.context.BrowserDevic" +
      "eContextBr\212@oSpecifies information about" +
      " a web browser, when the event is being " +
      "sent from some kind of web browsing cont" +
      "ext.\022\231\001\n\010location\030\014 \001(\0132\032.opencannabis.g" +
      "eo.LocationBk\212@hOrigin location for this" +
      " event, as determined by geolocation or " +
      "explicit inclusion in the event payload." +
      "B:\n\034io.bloombox.schema.telemetryB\020Analyt" +
      "icsContextH\001P\000\242\002\003BBSb\006proto3"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          gen_bq_schema.BqField.getDescriptor(),
          io.opencannabis.schema.geo.LocationOuterClass.getDescriptor(),
          io.bloombox.schema.identity.UserOuterClass.getDescriptor(),
          io.opencannabis.schema.temporal.InstantOuterClass.getDescriptor(),
          io.bloombox.schema.partner.PartnerOuterClass.getDescriptor(),
          io.bloombox.schema.partner.PartnerLocationOuterClass.getDescriptor(),
          io.bloombox.schema.telemetry.AnalyticsScope.getDescriptor(),
          io.bloombox.schema.telemetry.context.BrowserContext.getDescriptor(),
          io.bloombox.schema.telemetry.context.LibraryContext.getDescriptor(),
          io.bloombox.schema.telemetry.context.AnalyticsCollection.getDescriptor(),
          io.bloombox.schema.telemetry.context.ApplicationContext.getDescriptor(),
          io.bloombox.schema.telemetry.context.DeviceContext.getDescriptor(),
        }, assigner);
    internal_static_bloombox_schema_analytics_EventPosition_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_bloombox_schema_analytics_EventPosition_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_analytics_EventPosition_descriptor,
        new java.lang.String[] { "Ingest", "Occurred", "Processed", "Enriched", });
    internal_static_bloombox_schema_analytics_EventActors_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_bloombox_schema_analytics_EventActors_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_analytics_EventActors_descriptor,
        new java.lang.String[] { "User", "Partner", "Location", });
    internal_static_bloombox_schema_analytics_Context_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_bloombox_schema_analytics_Context_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_analytics_Context_descriptor,
        new java.lang.String[] { "Collection", "UserKey", "Fingerprint", "Group", "Hostname", "IpAddress", "Scope", "App", "Library", "Native", "Browser", "Location", });
    com.google.protobuf.ExtensionRegistry registry =
        com.google.protobuf.ExtensionRegistry.newInstance();
    registry.add(gen_bq_schema.BqField.description);
    registry.add(gen_bq_schema.BqField.require);
    registry.add(gen_bq_schema.BqField.typeOverride);
    com.google.protobuf.Descriptors.FileDescriptor
        .internalUpdateFileDescriptor(descriptor, registry);
    gen_bq_schema.BqField.getDescriptor();
    io.opencannabis.schema.geo.LocationOuterClass.getDescriptor();
    io.bloombox.schema.identity.UserOuterClass.getDescriptor();
    io.opencannabis.schema.temporal.InstantOuterClass.getDescriptor();
    io.bloombox.schema.partner.PartnerOuterClass.getDescriptor();
    io.bloombox.schema.partner.PartnerLocationOuterClass.getDescriptor();
    io.bloombox.schema.telemetry.AnalyticsScope.getDescriptor();
    io.bloombox.schema.telemetry.context.BrowserContext.getDescriptor();
    io.bloombox.schema.telemetry.context.LibraryContext.getDescriptor();
    io.bloombox.schema.telemetry.context.AnalyticsCollection.getDescriptor();
    io.bloombox.schema.telemetry.context.ApplicationContext.getDescriptor();
    io.bloombox.schema.telemetry.context.DeviceContext.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
