/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: analytics/generic/Exception.proto

package io.bloombox.schema.telemetry;

public final class AnalyticsException {
  private AnalyticsException() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  public interface SourceLineReferenceOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.analytics.generic.SourceLineReference)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Line number in a source code file.
     * </pre>
     *
     * <code>int32 line = 3;</code>
     */
    int getLine();

    /**
     * <pre>
     * Column number in a line in a source code file.
     * </pre>
     *
     * <code>int32 column = 4;</code>
     */
    int getColumn();
  }
  /**
   * <pre>
   * References a line and column number in a source file that is mentioned in an error report.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.analytics.generic.SourceLineReference}
   */
  public  static final class SourceLineReference extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.analytics.generic.SourceLineReference)
      SourceLineReferenceOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use SourceLineReference.newBuilder() to construct.
    private SourceLineReference(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private SourceLineReference() {
      line_ = 0;
      column_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private SourceLineReference(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 24: {

              line_ = input.readInt32();
              break;
            }
            case 32: {

              column_ = input.readInt32();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.telemetry.AnalyticsException.internal_static_bloombox_schema_analytics_generic_SourceLineReference_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.telemetry.AnalyticsException.internal_static_bloombox_schema_analytics_generic_SourceLineReference_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference.class, io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference.Builder.class);
    }

    public static final int LINE_FIELD_NUMBER = 3;
    private int line_;
    /**
     * <pre>
     * Line number in a source code file.
     * </pre>
     *
     * <code>int32 line = 3;</code>
     */
    public int getLine() {
      return line_;
    }

    public static final int COLUMN_FIELD_NUMBER = 4;
    private int column_;
    /**
     * <pre>
     * Column number in a line in a source code file.
     * </pre>
     *
     * <code>int32 column = 4;</code>
     */
    public int getColumn() {
      return column_;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (line_ != 0) {
        output.writeInt32(3, line_);
      }
      if (column_ != 0) {
        output.writeInt32(4, column_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (line_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(3, line_);
      }
      if (column_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(4, column_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference)) {
        return super.equals(obj);
      }
      io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference other = (io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference) obj;

      boolean result = true;
      result = result && (getLine()
          == other.getLine());
      result = result && (getColumn()
          == other.getColumn());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + LINE_FIELD_NUMBER;
      hash = (53 * hash) + getLine();
      hash = (37 * hash) + COLUMN_FIELD_NUMBER;
      hash = (53 * hash) + getColumn();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * References a line and column number in a source file that is mentioned in an error report.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.analytics.generic.SourceLineReference}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.analytics.generic.SourceLineReference)
        io.bloombox.schema.telemetry.AnalyticsException.SourceLineReferenceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.telemetry.AnalyticsException.internal_static_bloombox_schema_analytics_generic_SourceLineReference_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.telemetry.AnalyticsException.internal_static_bloombox_schema_analytics_generic_SourceLineReference_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference.class, io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference.Builder.class);
      }

      // Construct using io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        line_ = 0;

        column_ = 0;

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.telemetry.AnalyticsException.internal_static_bloombox_schema_analytics_generic_SourceLineReference_descriptor;
      }

      public io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference getDefaultInstanceForType() {
        return io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference.getDefaultInstance();
      }

      public io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference build() {
        io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference buildPartial() {
        io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference result = new io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference(this);
        result.line_ = line_;
        result.column_ = column_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference) {
          return mergeFrom((io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference other) {
        if (other == io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference.getDefaultInstance()) return this;
        if (other.getLine() != 0) {
          setLine(other.getLine());
        }
        if (other.getColumn() != 0) {
          setColumn(other.getColumn());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int line_ ;
      /**
       * <pre>
       * Line number in a source code file.
       * </pre>
       *
       * <code>int32 line = 3;</code>
       */
      public int getLine() {
        return line_;
      }
      /**
       * <pre>
       * Line number in a source code file.
       * </pre>
       *
       * <code>int32 line = 3;</code>
       */
      public Builder setLine(int value) {
        
        line_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Line number in a source code file.
       * </pre>
       *
       * <code>int32 line = 3;</code>
       */
      public Builder clearLine() {
        
        line_ = 0;
        onChanged();
        return this;
      }

      private int column_ ;
      /**
       * <pre>
       * Column number in a line in a source code file.
       * </pre>
       *
       * <code>int32 column = 4;</code>
       */
      public int getColumn() {
        return column_;
      }
      /**
       * <pre>
       * Column number in a line in a source code file.
       * </pre>
       *
       * <code>int32 column = 4;</code>
       */
      public Builder setColumn(int value) {
        
        column_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Column number in a line in a source code file.
       * </pre>
       *
       * <code>int32 column = 4;</code>
       */
      public Builder clearColumn() {
        
        column_ = 0;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.analytics.generic.SourceLineReference)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.analytics.generic.SourceLineReference)
    private static final io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference();
    }

    public static io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SourceLineReference>
        PARSER = new com.google.protobuf.AbstractParser<SourceLineReference>() {
      public SourceLineReference parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new SourceLineReference(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<SourceLineReference> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SourceLineReference> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface SourceLocationOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.analytics.generic.SourceLocation)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Arbitrary 'module' name for this source code. Usually the containing codebase.
     * </pre>
     *
     * <code>string module = 1;</code>
     */
    java.lang.String getModule();
    /**
     * <pre>
     * Arbitrary 'module' name for this source code. Usually the containing codebase.
     * </pre>
     *
     * <code>string module = 1;</code>
     */
    com.google.protobuf.ByteString
        getModuleBytes();

    /**
     * <pre>
     * Full path to a source code file within that module or codebase.
     * </pre>
     *
     * <code>string filepath = 2;</code>
     */
    java.lang.String getFilepath();
    /**
     * <pre>
     * Full path to a source code file within that module or codebase.
     * </pre>
     *
     * <code>string filepath = 2;</code>
     */
    com.google.protobuf.ByteString
        getFilepathBytes();

    /**
     * <pre>
     * Reference to a line/column in that file.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.generic.SourceLineReference lineref = 3;</code>
     */
    boolean hasLineref();
    /**
     * <pre>
     * Reference to a line/column in that file.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.generic.SourceLineReference lineref = 3;</code>
     */
    io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference getLineref();
    /**
     * <pre>
     * Reference to a line/column in that file.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.generic.SourceLineReference lineref = 3;</code>
     */
    io.bloombox.schema.telemetry.AnalyticsException.SourceLineReferenceOrBuilder getLinerefOrBuilder();

    /**
     * <pre>
     * Raw byte offset in a source code file.
     * </pre>
     *
     * <code>int64 offset = 4;</code>
     */
    long getOffset();

    public io.bloombox.schema.telemetry.AnalyticsException.SourceLocation.PinpointCase getPinpointCase();
  }
  /**
   * <pre>
   * References a location for source code that is mentioned in an error report.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.analytics.generic.SourceLocation}
   */
  public  static final class SourceLocation extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.analytics.generic.SourceLocation)
      SourceLocationOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use SourceLocation.newBuilder() to construct.
    private SourceLocation(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private SourceLocation() {
      module_ = "";
      filepath_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private SourceLocation(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              module_ = s;
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();

              filepath_ = s;
              break;
            }
            case 26: {
              io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference.Builder subBuilder = null;
              if (pinpointCase_ == 3) {
                subBuilder = ((io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference) pinpoint_).toBuilder();
              }
              pinpoint_ =
                  input.readMessage(io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference) pinpoint_);
                pinpoint_ = subBuilder.buildPartial();
              }
              pinpointCase_ = 3;
              break;
            }
            case 32: {
              pinpointCase_ = 4;
              pinpoint_ = input.readInt64();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.telemetry.AnalyticsException.internal_static_bloombox_schema_analytics_generic_SourceLocation_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.telemetry.AnalyticsException.internal_static_bloombox_schema_analytics_generic_SourceLocation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.telemetry.AnalyticsException.SourceLocation.class, io.bloombox.schema.telemetry.AnalyticsException.SourceLocation.Builder.class);
    }

    private int pinpointCase_ = 0;
    private java.lang.Object pinpoint_;
    public enum PinpointCase
        implements com.google.protobuf.Internal.EnumLite {
      LINEREF(3),
      OFFSET(4),
      PINPOINT_NOT_SET(0);
      private final int value;
      private PinpointCase(int value) {
        this.value = value;
      }
      /**
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static PinpointCase valueOf(int value) {
        return forNumber(value);
      }

      public static PinpointCase forNumber(int value) {
        switch (value) {
          case 3: return LINEREF;
          case 4: return OFFSET;
          case 0: return PINPOINT_NOT_SET;
          default: return null;
        }
      }
      public int getNumber() {
        return this.value;
      }
    };

    public PinpointCase
    getPinpointCase() {
      return PinpointCase.forNumber(
          pinpointCase_);
    }

    public static final int MODULE_FIELD_NUMBER = 1;
    private volatile java.lang.Object module_;
    /**
     * <pre>
     * Arbitrary 'module' name for this source code. Usually the containing codebase.
     * </pre>
     *
     * <code>string module = 1;</code>
     */
    public java.lang.String getModule() {
      java.lang.Object ref = module_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        module_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Arbitrary 'module' name for this source code. Usually the containing codebase.
     * </pre>
     *
     * <code>string module = 1;</code>
     */
    public com.google.protobuf.ByteString
        getModuleBytes() {
      java.lang.Object ref = module_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        module_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FILEPATH_FIELD_NUMBER = 2;
    private volatile java.lang.Object filepath_;
    /**
     * <pre>
     * Full path to a source code file within that module or codebase.
     * </pre>
     *
     * <code>string filepath = 2;</code>
     */
    public java.lang.String getFilepath() {
      java.lang.Object ref = filepath_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filepath_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Full path to a source code file within that module or codebase.
     * </pre>
     *
     * <code>string filepath = 2;</code>
     */
    public com.google.protobuf.ByteString
        getFilepathBytes() {
      java.lang.Object ref = filepath_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        filepath_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LINEREF_FIELD_NUMBER = 3;
    /**
     * <pre>
     * Reference to a line/column in that file.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.generic.SourceLineReference lineref = 3;</code>
     */
    public boolean hasLineref() {
      return pinpointCase_ == 3;
    }
    /**
     * <pre>
     * Reference to a line/column in that file.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.generic.SourceLineReference lineref = 3;</code>
     */
    public io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference getLineref() {
      if (pinpointCase_ == 3) {
         return (io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference) pinpoint_;
      }
      return io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference.getDefaultInstance();
    }
    /**
     * <pre>
     * Reference to a line/column in that file.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.generic.SourceLineReference lineref = 3;</code>
     */
    public io.bloombox.schema.telemetry.AnalyticsException.SourceLineReferenceOrBuilder getLinerefOrBuilder() {
      if (pinpointCase_ == 3) {
         return (io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference) pinpoint_;
      }
      return io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference.getDefaultInstance();
    }

    public static final int OFFSET_FIELD_NUMBER = 4;
    /**
     * <pre>
     * Raw byte offset in a source code file.
     * </pre>
     *
     * <code>int64 offset = 4;</code>
     */
    public long getOffset() {
      if (pinpointCase_ == 4) {
        return (java.lang.Long) pinpoint_;
      }
      return 0L;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getModuleBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, module_);
      }
      if (!getFilepathBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, filepath_);
      }
      if (pinpointCase_ == 3) {
        output.writeMessage(3, (io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference) pinpoint_);
      }
      if (pinpointCase_ == 4) {
        output.writeInt64(
            4, (long)((java.lang.Long) pinpoint_));
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getModuleBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, module_);
      }
      if (!getFilepathBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, filepath_);
      }
      if (pinpointCase_ == 3) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, (io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference) pinpoint_);
      }
      if (pinpointCase_ == 4) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt64Size(
              4, (long)((java.lang.Long) pinpoint_));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.telemetry.AnalyticsException.SourceLocation)) {
        return super.equals(obj);
      }
      io.bloombox.schema.telemetry.AnalyticsException.SourceLocation other = (io.bloombox.schema.telemetry.AnalyticsException.SourceLocation) obj;

      boolean result = true;
      result = result && getModule()
          .equals(other.getModule());
      result = result && getFilepath()
          .equals(other.getFilepath());
      result = result && getPinpointCase().equals(
          other.getPinpointCase());
      if (!result) return false;
      switch (pinpointCase_) {
        case 3:
          result = result && getLineref()
              .equals(other.getLineref());
          break;
        case 4:
          result = result && (getOffset()
              == other.getOffset());
          break;
        case 0:
        default:
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MODULE_FIELD_NUMBER;
      hash = (53 * hash) + getModule().hashCode();
      hash = (37 * hash) + FILEPATH_FIELD_NUMBER;
      hash = (53 * hash) + getFilepath().hashCode();
      switch (pinpointCase_) {
        case 3:
          hash = (37 * hash) + LINEREF_FIELD_NUMBER;
          hash = (53 * hash) + getLineref().hashCode();
          break;
        case 4:
          hash = (37 * hash) + OFFSET_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
              getOffset());
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.telemetry.AnalyticsException.SourceLocation parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.AnalyticsException.SourceLocation parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.AnalyticsException.SourceLocation parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.AnalyticsException.SourceLocation parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.AnalyticsException.SourceLocation parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.AnalyticsException.SourceLocation parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.AnalyticsException.SourceLocation parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.AnalyticsException.SourceLocation parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.AnalyticsException.SourceLocation parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.AnalyticsException.SourceLocation parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.AnalyticsException.SourceLocation parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.AnalyticsException.SourceLocation parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.telemetry.AnalyticsException.SourceLocation prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * References a location for source code that is mentioned in an error report.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.analytics.generic.SourceLocation}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.analytics.generic.SourceLocation)
        io.bloombox.schema.telemetry.AnalyticsException.SourceLocationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.telemetry.AnalyticsException.internal_static_bloombox_schema_analytics_generic_SourceLocation_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.telemetry.AnalyticsException.internal_static_bloombox_schema_analytics_generic_SourceLocation_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.telemetry.AnalyticsException.SourceLocation.class, io.bloombox.schema.telemetry.AnalyticsException.SourceLocation.Builder.class);
      }

      // Construct using io.bloombox.schema.telemetry.AnalyticsException.SourceLocation.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        module_ = "";

        filepath_ = "";

        pinpointCase_ = 0;
        pinpoint_ = null;
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.telemetry.AnalyticsException.internal_static_bloombox_schema_analytics_generic_SourceLocation_descriptor;
      }

      public io.bloombox.schema.telemetry.AnalyticsException.SourceLocation getDefaultInstanceForType() {
        return io.bloombox.schema.telemetry.AnalyticsException.SourceLocation.getDefaultInstance();
      }

      public io.bloombox.schema.telemetry.AnalyticsException.SourceLocation build() {
        io.bloombox.schema.telemetry.AnalyticsException.SourceLocation result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.telemetry.AnalyticsException.SourceLocation buildPartial() {
        io.bloombox.schema.telemetry.AnalyticsException.SourceLocation result = new io.bloombox.schema.telemetry.AnalyticsException.SourceLocation(this);
        result.module_ = module_;
        result.filepath_ = filepath_;
        if (pinpointCase_ == 3) {
          if (linerefBuilder_ == null) {
            result.pinpoint_ = pinpoint_;
          } else {
            result.pinpoint_ = linerefBuilder_.build();
          }
        }
        if (pinpointCase_ == 4) {
          result.pinpoint_ = pinpoint_;
        }
        result.pinpointCase_ = pinpointCase_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.telemetry.AnalyticsException.SourceLocation) {
          return mergeFrom((io.bloombox.schema.telemetry.AnalyticsException.SourceLocation)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.telemetry.AnalyticsException.SourceLocation other) {
        if (other == io.bloombox.schema.telemetry.AnalyticsException.SourceLocation.getDefaultInstance()) return this;
        if (!other.getModule().isEmpty()) {
          module_ = other.module_;
          onChanged();
        }
        if (!other.getFilepath().isEmpty()) {
          filepath_ = other.filepath_;
          onChanged();
        }
        switch (other.getPinpointCase()) {
          case LINEREF: {
            mergeLineref(other.getLineref());
            break;
          }
          case OFFSET: {
            setOffset(other.getOffset());
            break;
          }
          case PINPOINT_NOT_SET: {
            break;
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.telemetry.AnalyticsException.SourceLocation parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.telemetry.AnalyticsException.SourceLocation) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int pinpointCase_ = 0;
      private java.lang.Object pinpoint_;
      public PinpointCase
          getPinpointCase() {
        return PinpointCase.forNumber(
            pinpointCase_);
      }

      public Builder clearPinpoint() {
        pinpointCase_ = 0;
        pinpoint_ = null;
        onChanged();
        return this;
      }


      private java.lang.Object module_ = "";
      /**
       * <pre>
       * Arbitrary 'module' name for this source code. Usually the containing codebase.
       * </pre>
       *
       * <code>string module = 1;</code>
       */
      public java.lang.String getModule() {
        java.lang.Object ref = module_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          module_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Arbitrary 'module' name for this source code. Usually the containing codebase.
       * </pre>
       *
       * <code>string module = 1;</code>
       */
      public com.google.protobuf.ByteString
          getModuleBytes() {
        java.lang.Object ref = module_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          module_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Arbitrary 'module' name for this source code. Usually the containing codebase.
       * </pre>
       *
       * <code>string module = 1;</code>
       */
      public Builder setModule(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        module_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Arbitrary 'module' name for this source code. Usually the containing codebase.
       * </pre>
       *
       * <code>string module = 1;</code>
       */
      public Builder clearModule() {
        
        module_ = getDefaultInstance().getModule();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Arbitrary 'module' name for this source code. Usually the containing codebase.
       * </pre>
       *
       * <code>string module = 1;</code>
       */
      public Builder setModuleBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        module_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object filepath_ = "";
      /**
       * <pre>
       * Full path to a source code file within that module or codebase.
       * </pre>
       *
       * <code>string filepath = 2;</code>
       */
      public java.lang.String getFilepath() {
        java.lang.Object ref = filepath_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          filepath_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Full path to a source code file within that module or codebase.
       * </pre>
       *
       * <code>string filepath = 2;</code>
       */
      public com.google.protobuf.ByteString
          getFilepathBytes() {
        java.lang.Object ref = filepath_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          filepath_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Full path to a source code file within that module or codebase.
       * </pre>
       *
       * <code>string filepath = 2;</code>
       */
      public Builder setFilepath(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        filepath_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Full path to a source code file within that module or codebase.
       * </pre>
       *
       * <code>string filepath = 2;</code>
       */
      public Builder clearFilepath() {
        
        filepath_ = getDefaultInstance().getFilepath();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Full path to a source code file within that module or codebase.
       * </pre>
       *
       * <code>string filepath = 2;</code>
       */
      public Builder setFilepathBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        filepath_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference, io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference.Builder, io.bloombox.schema.telemetry.AnalyticsException.SourceLineReferenceOrBuilder> linerefBuilder_;
      /**
       * <pre>
       * Reference to a line/column in that file.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.generic.SourceLineReference lineref = 3;</code>
       */
      public boolean hasLineref() {
        return pinpointCase_ == 3;
      }
      /**
       * <pre>
       * Reference to a line/column in that file.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.generic.SourceLineReference lineref = 3;</code>
       */
      public io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference getLineref() {
        if (linerefBuilder_ == null) {
          if (pinpointCase_ == 3) {
            return (io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference) pinpoint_;
          }
          return io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference.getDefaultInstance();
        } else {
          if (pinpointCase_ == 3) {
            return linerefBuilder_.getMessage();
          }
          return io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Reference to a line/column in that file.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.generic.SourceLineReference lineref = 3;</code>
       */
      public Builder setLineref(io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference value) {
        if (linerefBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          pinpoint_ = value;
          onChanged();
        } else {
          linerefBuilder_.setMessage(value);
        }
        pinpointCase_ = 3;
        return this;
      }
      /**
       * <pre>
       * Reference to a line/column in that file.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.generic.SourceLineReference lineref = 3;</code>
       */
      public Builder setLineref(
          io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference.Builder builderForValue) {
        if (linerefBuilder_ == null) {
          pinpoint_ = builderForValue.build();
          onChanged();
        } else {
          linerefBuilder_.setMessage(builderForValue.build());
        }
        pinpointCase_ = 3;
        return this;
      }
      /**
       * <pre>
       * Reference to a line/column in that file.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.generic.SourceLineReference lineref = 3;</code>
       */
      public Builder mergeLineref(io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference value) {
        if (linerefBuilder_ == null) {
          if (pinpointCase_ == 3 &&
              pinpoint_ != io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference.getDefaultInstance()) {
            pinpoint_ = io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference.newBuilder((io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference) pinpoint_)
                .mergeFrom(value).buildPartial();
          } else {
            pinpoint_ = value;
          }
          onChanged();
        } else {
          if (pinpointCase_ == 3) {
            linerefBuilder_.mergeFrom(value);
          }
          linerefBuilder_.setMessage(value);
        }
        pinpointCase_ = 3;
        return this;
      }
      /**
       * <pre>
       * Reference to a line/column in that file.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.generic.SourceLineReference lineref = 3;</code>
       */
      public Builder clearLineref() {
        if (linerefBuilder_ == null) {
          if (pinpointCase_ == 3) {
            pinpointCase_ = 0;
            pinpoint_ = null;
            onChanged();
          }
        } else {
          if (pinpointCase_ == 3) {
            pinpointCase_ = 0;
            pinpoint_ = null;
          }
          linerefBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Reference to a line/column in that file.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.generic.SourceLineReference lineref = 3;</code>
       */
      public io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference.Builder getLinerefBuilder() {
        return getLinerefFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Reference to a line/column in that file.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.generic.SourceLineReference lineref = 3;</code>
       */
      public io.bloombox.schema.telemetry.AnalyticsException.SourceLineReferenceOrBuilder getLinerefOrBuilder() {
        if ((pinpointCase_ == 3) && (linerefBuilder_ != null)) {
          return linerefBuilder_.getMessageOrBuilder();
        } else {
          if (pinpointCase_ == 3) {
            return (io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference) pinpoint_;
          }
          return io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Reference to a line/column in that file.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.generic.SourceLineReference lineref = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference, io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference.Builder, io.bloombox.schema.telemetry.AnalyticsException.SourceLineReferenceOrBuilder> 
          getLinerefFieldBuilder() {
        if (linerefBuilder_ == null) {
          if (!(pinpointCase_ == 3)) {
            pinpoint_ = io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference.getDefaultInstance();
          }
          linerefBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference, io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference.Builder, io.bloombox.schema.telemetry.AnalyticsException.SourceLineReferenceOrBuilder>(
                  (io.bloombox.schema.telemetry.AnalyticsException.SourceLineReference) pinpoint_,
                  getParentForChildren(),
                  isClean());
          pinpoint_ = null;
        }
        pinpointCase_ = 3;
        onChanged();;
        return linerefBuilder_;
      }

      /**
       * <pre>
       * Raw byte offset in a source code file.
       * </pre>
       *
       * <code>int64 offset = 4;</code>
       */
      public long getOffset() {
        if (pinpointCase_ == 4) {
          return (java.lang.Long) pinpoint_;
        }
        return 0L;
      }
      /**
       * <pre>
       * Raw byte offset in a source code file.
       * </pre>
       *
       * <code>int64 offset = 4;</code>
       */
      public Builder setOffset(long value) {
        pinpointCase_ = 4;
        pinpoint_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Raw byte offset in a source code file.
       * </pre>
       *
       * <code>int64 offset = 4;</code>
       */
      public Builder clearOffset() {
        if (pinpointCase_ == 4) {
          pinpointCase_ = 0;
          pinpoint_ = null;
          onChanged();
        }
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.analytics.generic.SourceLocation)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.analytics.generic.SourceLocation)
    private static final io.bloombox.schema.telemetry.AnalyticsException.SourceLocation DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.telemetry.AnalyticsException.SourceLocation();
    }

    public static io.bloombox.schema.telemetry.AnalyticsException.SourceLocation getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SourceLocation>
        PARSER = new com.google.protobuf.AbstractParser<SourceLocation>() {
      public SourceLocation parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new SourceLocation(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<SourceLocation> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SourceLocation> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.telemetry.AnalyticsException.SourceLocation getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ExceptionOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.analytics.generic.Exception)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * String domain value for this error, if any.
     * </pre>
     *
     * <code>string domain = 1;</code>
     */
    java.lang.String getDomain();
    /**
     * <pre>
     * String domain value for this error, if any.
     * </pre>
     *
     * <code>string domain = 1;</code>
     */
    com.google.protobuf.ByteString
        getDomainBytes();

    /**
     * <pre>
     * Code for this failure type, if any.
     * </pre>
     *
     * <code>int32 code = 2;</code>
     */
    int getCode();

    /**
     * <pre>
     * Source location context for this failure.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.generic.SourceLocation location = 3;</code>
     */
    boolean hasLocation();
    /**
     * <pre>
     * Source location context for this failure.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.generic.SourceLocation location = 3;</code>
     */
    io.bloombox.schema.telemetry.AnalyticsException.SourceLocation getLocation();
    /**
     * <pre>
     * Source location context for this failure.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.generic.SourceLocation location = 3;</code>
     */
    io.bloombox.schema.telemetry.AnalyticsException.SourceLocationOrBuilder getLocationOrBuilder();

    /**
     * <pre>
     * Occurrence timestamp.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 4;</code>
     */
    boolean hasOccurred();
    /**
     * <pre>
     * Occurrence timestamp.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 4;</code>
     */
    io.opencannabis.schema.temporal.Instant getOccurred();
    /**
     * <pre>
     * Occurrence timestamp.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 4;</code>
     */
    io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder();
  }
  /**
   * <pre>
   * Represents an error event.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.analytics.generic.Exception}
   */
  public  static final class Exception extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.analytics.generic.Exception)
      ExceptionOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Exception.newBuilder() to construct.
    private Exception(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Exception() {
      domain_ = "";
      code_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Exception(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              domain_ = s;
              break;
            }
            case 16: {

              code_ = input.readInt32();
              break;
            }
            case 26: {
              io.bloombox.schema.telemetry.AnalyticsException.SourceLocation.Builder subBuilder = null;
              if (location_ != null) {
                subBuilder = location_.toBuilder();
              }
              location_ = input.readMessage(io.bloombox.schema.telemetry.AnalyticsException.SourceLocation.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(location_);
                location_ = subBuilder.buildPartial();
              }

              break;
            }
            case 34: {
              io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
              if (occurred_ != null) {
                subBuilder = occurred_.toBuilder();
              }
              occurred_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(occurred_);
                occurred_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.telemetry.AnalyticsException.internal_static_bloombox_schema_analytics_generic_Exception_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.telemetry.AnalyticsException.internal_static_bloombox_schema_analytics_generic_Exception_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.telemetry.AnalyticsException.Exception.class, io.bloombox.schema.telemetry.AnalyticsException.Exception.Builder.class);
    }

    public static final int DOMAIN_FIELD_NUMBER = 1;
    private volatile java.lang.Object domain_;
    /**
     * <pre>
     * String domain value for this error, if any.
     * </pre>
     *
     * <code>string domain = 1;</code>
     */
    public java.lang.String getDomain() {
      java.lang.Object ref = domain_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        domain_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * String domain value for this error, if any.
     * </pre>
     *
     * <code>string domain = 1;</code>
     */
    public com.google.protobuf.ByteString
        getDomainBytes() {
      java.lang.Object ref = domain_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        domain_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CODE_FIELD_NUMBER = 2;
    private int code_;
    /**
     * <pre>
     * Code for this failure type, if any.
     * </pre>
     *
     * <code>int32 code = 2;</code>
     */
    public int getCode() {
      return code_;
    }

    public static final int LOCATION_FIELD_NUMBER = 3;
    private io.bloombox.schema.telemetry.AnalyticsException.SourceLocation location_;
    /**
     * <pre>
     * Source location context for this failure.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.generic.SourceLocation location = 3;</code>
     */
    public boolean hasLocation() {
      return location_ != null;
    }
    /**
     * <pre>
     * Source location context for this failure.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.generic.SourceLocation location = 3;</code>
     */
    public io.bloombox.schema.telemetry.AnalyticsException.SourceLocation getLocation() {
      return location_ == null ? io.bloombox.schema.telemetry.AnalyticsException.SourceLocation.getDefaultInstance() : location_;
    }
    /**
     * <pre>
     * Source location context for this failure.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.generic.SourceLocation location = 3;</code>
     */
    public io.bloombox.schema.telemetry.AnalyticsException.SourceLocationOrBuilder getLocationOrBuilder() {
      return getLocation();
    }

    public static final int OCCURRED_FIELD_NUMBER = 4;
    private io.opencannabis.schema.temporal.Instant occurred_;
    /**
     * <pre>
     * Occurrence timestamp.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 4;</code>
     */
    public boolean hasOccurred() {
      return occurred_ != null;
    }
    /**
     * <pre>
     * Occurrence timestamp.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 4;</code>
     */
    public io.opencannabis.schema.temporal.Instant getOccurred() {
      return occurred_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
    }
    /**
     * <pre>
     * Occurrence timestamp.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 4;</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder() {
      return getOccurred();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getDomainBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, domain_);
      }
      if (code_ != 0) {
        output.writeInt32(2, code_);
      }
      if (location_ != null) {
        output.writeMessage(3, getLocation());
      }
      if (occurred_ != null) {
        output.writeMessage(4, getOccurred());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getDomainBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, domain_);
      }
      if (code_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(2, code_);
      }
      if (location_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getLocation());
      }
      if (occurred_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, getOccurred());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.telemetry.AnalyticsException.Exception)) {
        return super.equals(obj);
      }
      io.bloombox.schema.telemetry.AnalyticsException.Exception other = (io.bloombox.schema.telemetry.AnalyticsException.Exception) obj;

      boolean result = true;
      result = result && getDomain()
          .equals(other.getDomain());
      result = result && (getCode()
          == other.getCode());
      result = result && (hasLocation() == other.hasLocation());
      if (hasLocation()) {
        result = result && getLocation()
            .equals(other.getLocation());
      }
      result = result && (hasOccurred() == other.hasOccurred());
      if (hasOccurred()) {
        result = result && getOccurred()
            .equals(other.getOccurred());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DOMAIN_FIELD_NUMBER;
      hash = (53 * hash) + getDomain().hashCode();
      hash = (37 * hash) + CODE_FIELD_NUMBER;
      hash = (53 * hash) + getCode();
      if (hasLocation()) {
        hash = (37 * hash) + LOCATION_FIELD_NUMBER;
        hash = (53 * hash) + getLocation().hashCode();
      }
      if (hasOccurred()) {
        hash = (37 * hash) + OCCURRED_FIELD_NUMBER;
        hash = (53 * hash) + getOccurred().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.telemetry.AnalyticsException.Exception parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.AnalyticsException.Exception parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.AnalyticsException.Exception parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.AnalyticsException.Exception parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.AnalyticsException.Exception parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.AnalyticsException.Exception parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.AnalyticsException.Exception parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.AnalyticsException.Exception parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.AnalyticsException.Exception parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.AnalyticsException.Exception parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.AnalyticsException.Exception parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.AnalyticsException.Exception parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.telemetry.AnalyticsException.Exception prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Represents an error event.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.analytics.generic.Exception}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.analytics.generic.Exception)
        io.bloombox.schema.telemetry.AnalyticsException.ExceptionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.telemetry.AnalyticsException.internal_static_bloombox_schema_analytics_generic_Exception_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.telemetry.AnalyticsException.internal_static_bloombox_schema_analytics_generic_Exception_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.telemetry.AnalyticsException.Exception.class, io.bloombox.schema.telemetry.AnalyticsException.Exception.Builder.class);
      }

      // Construct using io.bloombox.schema.telemetry.AnalyticsException.Exception.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        domain_ = "";

        code_ = 0;

        if (locationBuilder_ == null) {
          location_ = null;
        } else {
          location_ = null;
          locationBuilder_ = null;
        }
        if (occurredBuilder_ == null) {
          occurred_ = null;
        } else {
          occurred_ = null;
          occurredBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.telemetry.AnalyticsException.internal_static_bloombox_schema_analytics_generic_Exception_descriptor;
      }

      public io.bloombox.schema.telemetry.AnalyticsException.Exception getDefaultInstanceForType() {
        return io.bloombox.schema.telemetry.AnalyticsException.Exception.getDefaultInstance();
      }

      public io.bloombox.schema.telemetry.AnalyticsException.Exception build() {
        io.bloombox.schema.telemetry.AnalyticsException.Exception result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.telemetry.AnalyticsException.Exception buildPartial() {
        io.bloombox.schema.telemetry.AnalyticsException.Exception result = new io.bloombox.schema.telemetry.AnalyticsException.Exception(this);
        result.domain_ = domain_;
        result.code_ = code_;
        if (locationBuilder_ == null) {
          result.location_ = location_;
        } else {
          result.location_ = locationBuilder_.build();
        }
        if (occurredBuilder_ == null) {
          result.occurred_ = occurred_;
        } else {
          result.occurred_ = occurredBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.telemetry.AnalyticsException.Exception) {
          return mergeFrom((io.bloombox.schema.telemetry.AnalyticsException.Exception)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.telemetry.AnalyticsException.Exception other) {
        if (other == io.bloombox.schema.telemetry.AnalyticsException.Exception.getDefaultInstance()) return this;
        if (!other.getDomain().isEmpty()) {
          domain_ = other.domain_;
          onChanged();
        }
        if (other.getCode() != 0) {
          setCode(other.getCode());
        }
        if (other.hasLocation()) {
          mergeLocation(other.getLocation());
        }
        if (other.hasOccurred()) {
          mergeOccurred(other.getOccurred());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.telemetry.AnalyticsException.Exception parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.telemetry.AnalyticsException.Exception) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object domain_ = "";
      /**
       * <pre>
       * String domain value for this error, if any.
       * </pre>
       *
       * <code>string domain = 1;</code>
       */
      public java.lang.String getDomain() {
        java.lang.Object ref = domain_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          domain_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * String domain value for this error, if any.
       * </pre>
       *
       * <code>string domain = 1;</code>
       */
      public com.google.protobuf.ByteString
          getDomainBytes() {
        java.lang.Object ref = domain_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          domain_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * String domain value for this error, if any.
       * </pre>
       *
       * <code>string domain = 1;</code>
       */
      public Builder setDomain(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        domain_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * String domain value for this error, if any.
       * </pre>
       *
       * <code>string domain = 1;</code>
       */
      public Builder clearDomain() {
        
        domain_ = getDefaultInstance().getDomain();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * String domain value for this error, if any.
       * </pre>
       *
       * <code>string domain = 1;</code>
       */
      public Builder setDomainBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        domain_ = value;
        onChanged();
        return this;
      }

      private int code_ ;
      /**
       * <pre>
       * Code for this failure type, if any.
       * </pre>
       *
       * <code>int32 code = 2;</code>
       */
      public int getCode() {
        return code_;
      }
      /**
       * <pre>
       * Code for this failure type, if any.
       * </pre>
       *
       * <code>int32 code = 2;</code>
       */
      public Builder setCode(int value) {
        
        code_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Code for this failure type, if any.
       * </pre>
       *
       * <code>int32 code = 2;</code>
       */
      public Builder clearCode() {
        
        code_ = 0;
        onChanged();
        return this;
      }

      private io.bloombox.schema.telemetry.AnalyticsException.SourceLocation location_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.telemetry.AnalyticsException.SourceLocation, io.bloombox.schema.telemetry.AnalyticsException.SourceLocation.Builder, io.bloombox.schema.telemetry.AnalyticsException.SourceLocationOrBuilder> locationBuilder_;
      /**
       * <pre>
       * Source location context for this failure.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.generic.SourceLocation location = 3;</code>
       */
      public boolean hasLocation() {
        return locationBuilder_ != null || location_ != null;
      }
      /**
       * <pre>
       * Source location context for this failure.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.generic.SourceLocation location = 3;</code>
       */
      public io.bloombox.schema.telemetry.AnalyticsException.SourceLocation getLocation() {
        if (locationBuilder_ == null) {
          return location_ == null ? io.bloombox.schema.telemetry.AnalyticsException.SourceLocation.getDefaultInstance() : location_;
        } else {
          return locationBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Source location context for this failure.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.generic.SourceLocation location = 3;</code>
       */
      public Builder setLocation(io.bloombox.schema.telemetry.AnalyticsException.SourceLocation value) {
        if (locationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          location_ = value;
          onChanged();
        } else {
          locationBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Source location context for this failure.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.generic.SourceLocation location = 3;</code>
       */
      public Builder setLocation(
          io.bloombox.schema.telemetry.AnalyticsException.SourceLocation.Builder builderForValue) {
        if (locationBuilder_ == null) {
          location_ = builderForValue.build();
          onChanged();
        } else {
          locationBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Source location context for this failure.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.generic.SourceLocation location = 3;</code>
       */
      public Builder mergeLocation(io.bloombox.schema.telemetry.AnalyticsException.SourceLocation value) {
        if (locationBuilder_ == null) {
          if (location_ != null) {
            location_ =
              io.bloombox.schema.telemetry.AnalyticsException.SourceLocation.newBuilder(location_).mergeFrom(value).buildPartial();
          } else {
            location_ = value;
          }
          onChanged();
        } else {
          locationBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Source location context for this failure.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.generic.SourceLocation location = 3;</code>
       */
      public Builder clearLocation() {
        if (locationBuilder_ == null) {
          location_ = null;
          onChanged();
        } else {
          location_ = null;
          locationBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Source location context for this failure.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.generic.SourceLocation location = 3;</code>
       */
      public io.bloombox.schema.telemetry.AnalyticsException.SourceLocation.Builder getLocationBuilder() {
        
        onChanged();
        return getLocationFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Source location context for this failure.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.generic.SourceLocation location = 3;</code>
       */
      public io.bloombox.schema.telemetry.AnalyticsException.SourceLocationOrBuilder getLocationOrBuilder() {
        if (locationBuilder_ != null) {
          return locationBuilder_.getMessageOrBuilder();
        } else {
          return location_ == null ?
              io.bloombox.schema.telemetry.AnalyticsException.SourceLocation.getDefaultInstance() : location_;
        }
      }
      /**
       * <pre>
       * Source location context for this failure.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.generic.SourceLocation location = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.telemetry.AnalyticsException.SourceLocation, io.bloombox.schema.telemetry.AnalyticsException.SourceLocation.Builder, io.bloombox.schema.telemetry.AnalyticsException.SourceLocationOrBuilder> 
          getLocationFieldBuilder() {
        if (locationBuilder_ == null) {
          locationBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.telemetry.AnalyticsException.SourceLocation, io.bloombox.schema.telemetry.AnalyticsException.SourceLocation.Builder, io.bloombox.schema.telemetry.AnalyticsException.SourceLocationOrBuilder>(
                  getLocation(),
                  getParentForChildren(),
                  isClean());
          location_ = null;
        }
        return locationBuilder_;
      }

      private io.opencannabis.schema.temporal.Instant occurred_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> occurredBuilder_;
      /**
       * <pre>
       * Occurrence timestamp.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      public boolean hasOccurred() {
        return occurredBuilder_ != null || occurred_ != null;
      }
      /**
       * <pre>
       * Occurrence timestamp.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      public io.opencannabis.schema.temporal.Instant getOccurred() {
        if (occurredBuilder_ == null) {
          return occurred_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
        } else {
          return occurredBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Occurrence timestamp.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      public Builder setOccurred(io.opencannabis.schema.temporal.Instant value) {
        if (occurredBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          occurred_ = value;
          onChanged();
        } else {
          occurredBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Occurrence timestamp.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      public Builder setOccurred(
          io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
        if (occurredBuilder_ == null) {
          occurred_ = builderForValue.build();
          onChanged();
        } else {
          occurredBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Occurrence timestamp.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      public Builder mergeOccurred(io.opencannabis.schema.temporal.Instant value) {
        if (occurredBuilder_ == null) {
          if (occurred_ != null) {
            occurred_ =
              io.opencannabis.schema.temporal.Instant.newBuilder(occurred_).mergeFrom(value).buildPartial();
          } else {
            occurred_ = value;
          }
          onChanged();
        } else {
          occurredBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Occurrence timestamp.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      public Builder clearOccurred() {
        if (occurredBuilder_ == null) {
          occurred_ = null;
          onChanged();
        } else {
          occurred_ = null;
          occurredBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Occurrence timestamp.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      public io.opencannabis.schema.temporal.Instant.Builder getOccurredBuilder() {
        
        onChanged();
        return getOccurredFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Occurrence timestamp.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      public io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder() {
        if (occurredBuilder_ != null) {
          return occurredBuilder_.getMessageOrBuilder();
        } else {
          return occurred_ == null ?
              io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
        }
      }
      /**
       * <pre>
       * Occurrence timestamp.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
          getOccurredFieldBuilder() {
        if (occurredBuilder_ == null) {
          occurredBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                  getOccurred(),
                  getParentForChildren(),
                  isClean());
          occurred_ = null;
        }
        return occurredBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.analytics.generic.Exception)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.analytics.generic.Exception)
    private static final io.bloombox.schema.telemetry.AnalyticsException.Exception DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.telemetry.AnalyticsException.Exception();
    }

    public static io.bloombox.schema.telemetry.AnalyticsException.Exception getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Exception>
        PARSER = new com.google.protobuf.AbstractParser<Exception>() {
      public Exception parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Exception(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Exception> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Exception> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.telemetry.AnalyticsException.Exception getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_analytics_generic_SourceLineReference_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_analytics_generic_SourceLineReference_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_analytics_generic_SourceLocation_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_analytics_generic_SourceLocation_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_analytics_generic_Exception_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_analytics_generic_Exception_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n!analytics/generic/Exception.proto\022!blo" +
      "ombox.schema.analytics.generic\032\026temporal" +
      "/Instant.proto\"3\n\023SourceLineReference\022\014\n" +
      "\004line\030\003 \001(\005\022\016\n\006column\030\004 \001(\005\"\233\001\n\016SourceLo" +
      "cation\022\016\n\006module\030\001 \001(\t\022\020\n\010filepath\030\002 \001(\t" +
      "\022I\n\007lineref\030\003 \001(\01326.bloombox.schema.anal" +
      "ytics.generic.SourceLineReferenceH\000\022\020\n\006o" +
      "ffset\030\004 \001(\003H\000B\n\n\010pinpoint\"\240\001\n\tException\022" +
      "\016\n\006domain\030\001 \001(\t\022\014\n\004code\030\002 \001(\005\022C\n\010locatio" +
      "n\030\003 \001(\01321.bloombox.schema.analytics.gene" +
      "ric.SourceLocation\0220\n\010occurred\030\004 \001(\0132\036.o" +
      "pencannabis.temporal.InstantB<\n\034io.bloom" +
      "box.schema.telemetryB\022AnalyticsException" +
      "H\001P\000\242\002\003BBSb\006proto3"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          io.opencannabis.schema.temporal.InstantOuterClass.getDescriptor(),
        }, assigner);
    internal_static_bloombox_schema_analytics_generic_SourceLineReference_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_bloombox_schema_analytics_generic_SourceLineReference_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_analytics_generic_SourceLineReference_descriptor,
        new java.lang.String[] { "Line", "Column", });
    internal_static_bloombox_schema_analytics_generic_SourceLocation_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_bloombox_schema_analytics_generic_SourceLocation_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_analytics_generic_SourceLocation_descriptor,
        new java.lang.String[] { "Module", "Filepath", "Lineref", "Offset", "Pinpoint", });
    internal_static_bloombox_schema_analytics_generic_Exception_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_bloombox_schema_analytics_generic_Exception_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_analytics_generic_Exception_descriptor,
        new java.lang.String[] { "Domain", "Code", "Location", "Occurred", });
    io.opencannabis.schema.temporal.InstantOuterClass.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
