/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: analytics/context/Application.proto

package io.bloombox.schema.telemetry.context;

public final class ApplicationContext {
  private ApplicationContext() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   * <pre>
   * Enumerates types of applications that may run on a device and report telemetry information.
   * </pre>
   *
   * Protobuf enum {@code bloombox.schema.analytics.context.ApplicationType}
   */
  public enum ApplicationType
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * The application is internally produced and managed.
     * </pre>
     *
     * <code>INTERNAL = 0;</code>
     */
    INTERNAL(0),
    /**
     * <pre>
     * The application is partner colocated, hosted, or managed.
     * </pre>
     *
     * <code>PARTNER = 1;</code>
     */
    PARTNER(1),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * The application is internally produced and managed.
     * </pre>
     *
     * <code>INTERNAL = 0;</code>
     */
    public static final int INTERNAL_VALUE = 0;
    /**
     * <pre>
     * The application is partner colocated, hosted, or managed.
     * </pre>
     *
     * <code>PARTNER = 1;</code>
     */
    public static final int PARTNER_VALUE = 1;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ApplicationType valueOf(int value) {
      return forNumber(value);
    }

    public static ApplicationType forNumber(int value) {
      switch (value) {
        case 0: return INTERNAL;
        case 1: return PARTNER;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ApplicationType>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        ApplicationType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ApplicationType>() {
            public ApplicationType findValueByNumber(int number) {
              return ApplicationType.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.bloombox.schema.telemetry.context.ApplicationContext.getDescriptor().getEnumTypes().get(0);
    }

    private static final ApplicationType[] VALUES = values();

    public static ApplicationType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ApplicationType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:bloombox.schema.analytics.context.ApplicationType)
  }

  public interface WebApplicationOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.analytics.context.WebApplication)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Specifies an origin for a web application.
     * </pre>
     *
     * <code>string origin = 1 [(.gen_bq_schema.description) = "Specifies an origin for a web application."];</code>
     */
    java.lang.String getOrigin();
    /**
     * <pre>
     * Specifies an origin for a web application.
     * </pre>
     *
     * <code>string origin = 1 [(.gen_bq_schema.description) = "Specifies an origin for a web application."];</code>
     */
    com.google.protobuf.ByteString
        getOriginBytes();

    /**
     * <pre>
     * Full, absolute URL the user was at when the event was sent.
     * </pre>
     *
     * <code>string location = 2 [(.gen_bq_schema.description) = "Full, absolute URL the user was at when the event was sent."];</code>
     */
    java.lang.String getLocation();
    /**
     * <pre>
     * Full, absolute URL the user was at when the event was sent.
     * </pre>
     *
     * <code>string location = 2 [(.gen_bq_schema.description) = "Full, absolute URL the user was at when the event was sent."];</code>
     */
    com.google.protobuf.ByteString
        getLocationBytes();

    /**
     * <pre>
     * Anchor in the URL, if any.
     * </pre>
     *
     * <code>string anchor = 3 [(.gen_bq_schema.description) = "Anchor in the URL, if any."];</code>
     */
    java.lang.String getAnchor();
    /**
     * <pre>
     * Anchor in the URL, if any.
     * </pre>
     *
     * <code>string anchor = 3 [(.gen_bq_schema.description) = "Anchor in the URL, if any."];</code>
     */
    com.google.protobuf.ByteString
        getAnchorBytes();

    /**
     * <pre>
     * Title of the current webpage.
     * </pre>
     *
     * <code>string title = 4 [(.gen_bq_schema.description) = "Title of the current webpage."];</code>
     */
    java.lang.String getTitle();
    /**
     * <pre>
     * Title of the current webpage.
     * </pre>
     *
     * <code>string title = 4 [(.gen_bq_schema.description) = "Title of the current webpage."];</code>
     */
    com.google.protobuf.ByteString
        getTitleBytes();

    /**
     * <pre>
     * Referring URL for this webpage.
     * </pre>
     *
     * <code>string referrer = 5 [(.gen_bq_schema.description) = "Referring URL for this webpage."];</code>
     */
    java.lang.String getReferrer();
    /**
     * <pre>
     * Referring URL for this webpage.
     * </pre>
     *
     * <code>string referrer = 5 [(.gen_bq_schema.description) = "Referring URL for this webpage."];</code>
     */
    com.google.protobuf.ByteString
        getReferrerBytes();

    /**
     * <pre>
     * Protocol that was used to serve this URL.
     * </pre>
     *
     * <code>string protocol = 6 [(.gen_bq_schema.description) = "Protocol that was used to serve this URL."];</code>
     */
    java.lang.String getProtocol();
    /**
     * <pre>
     * Protocol that was used to serve this URL.
     * </pre>
     *
     * <code>string protocol = 6 [(.gen_bq_schema.description) = "Protocol that was used to serve this URL."];</code>
     */
    com.google.protobuf.ByteString
        getProtocolBytes();
  }
  /**
   * <pre>
   * Specifies information about a web application reporting information to the telemetry service.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.analytics.context.WebApplication}
   */
  public  static final class WebApplication extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.analytics.context.WebApplication)
      WebApplicationOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use WebApplication.newBuilder() to construct.
    private WebApplication(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private WebApplication() {
      origin_ = "";
      location_ = "";
      anchor_ = "";
      title_ = "";
      referrer_ = "";
      protocol_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private WebApplication(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              origin_ = s;
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();

              location_ = s;
              break;
            }
            case 26: {
              java.lang.String s = input.readStringRequireUtf8();

              anchor_ = s;
              break;
            }
            case 34: {
              java.lang.String s = input.readStringRequireUtf8();

              title_ = s;
              break;
            }
            case 42: {
              java.lang.String s = input.readStringRequireUtf8();

              referrer_ = s;
              break;
            }
            case 50: {
              java.lang.String s = input.readStringRequireUtf8();

              protocol_ = s;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.telemetry.context.ApplicationContext.internal_static_bloombox_schema_analytics_context_WebApplication_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.telemetry.context.ApplicationContext.internal_static_bloombox_schema_analytics_context_WebApplication_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication.class, io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication.Builder.class);
    }

    public static final int ORIGIN_FIELD_NUMBER = 1;
    private volatile java.lang.Object origin_;
    /**
     * <pre>
     * Specifies an origin for a web application.
     * </pre>
     *
     * <code>string origin = 1 [(.gen_bq_schema.description) = "Specifies an origin for a web application."];</code>
     */
    public java.lang.String getOrigin() {
      java.lang.Object ref = origin_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        origin_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Specifies an origin for a web application.
     * </pre>
     *
     * <code>string origin = 1 [(.gen_bq_schema.description) = "Specifies an origin for a web application."];</code>
     */
    public com.google.protobuf.ByteString
        getOriginBytes() {
      java.lang.Object ref = origin_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        origin_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LOCATION_FIELD_NUMBER = 2;
    private volatile java.lang.Object location_;
    /**
     * <pre>
     * Full, absolute URL the user was at when the event was sent.
     * </pre>
     *
     * <code>string location = 2 [(.gen_bq_schema.description) = "Full, absolute URL the user was at when the event was sent."];</code>
     */
    public java.lang.String getLocation() {
      java.lang.Object ref = location_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        location_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Full, absolute URL the user was at when the event was sent.
     * </pre>
     *
     * <code>string location = 2 [(.gen_bq_schema.description) = "Full, absolute URL the user was at when the event was sent."];</code>
     */
    public com.google.protobuf.ByteString
        getLocationBytes() {
      java.lang.Object ref = location_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        location_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ANCHOR_FIELD_NUMBER = 3;
    private volatile java.lang.Object anchor_;
    /**
     * <pre>
     * Anchor in the URL, if any.
     * </pre>
     *
     * <code>string anchor = 3 [(.gen_bq_schema.description) = "Anchor in the URL, if any."];</code>
     */
    public java.lang.String getAnchor() {
      java.lang.Object ref = anchor_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        anchor_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Anchor in the URL, if any.
     * </pre>
     *
     * <code>string anchor = 3 [(.gen_bq_schema.description) = "Anchor in the URL, if any."];</code>
     */
    public com.google.protobuf.ByteString
        getAnchorBytes() {
      java.lang.Object ref = anchor_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        anchor_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TITLE_FIELD_NUMBER = 4;
    private volatile java.lang.Object title_;
    /**
     * <pre>
     * Title of the current webpage.
     * </pre>
     *
     * <code>string title = 4 [(.gen_bq_schema.description) = "Title of the current webpage."];</code>
     */
    public java.lang.String getTitle() {
      java.lang.Object ref = title_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        title_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Title of the current webpage.
     * </pre>
     *
     * <code>string title = 4 [(.gen_bq_schema.description) = "Title of the current webpage."];</code>
     */
    public com.google.protobuf.ByteString
        getTitleBytes() {
      java.lang.Object ref = title_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        title_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int REFERRER_FIELD_NUMBER = 5;
    private volatile java.lang.Object referrer_;
    /**
     * <pre>
     * Referring URL for this webpage.
     * </pre>
     *
     * <code>string referrer = 5 [(.gen_bq_schema.description) = "Referring URL for this webpage."];</code>
     */
    public java.lang.String getReferrer() {
      java.lang.Object ref = referrer_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        referrer_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Referring URL for this webpage.
     * </pre>
     *
     * <code>string referrer = 5 [(.gen_bq_schema.description) = "Referring URL for this webpage."];</code>
     */
    public com.google.protobuf.ByteString
        getReferrerBytes() {
      java.lang.Object ref = referrer_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        referrer_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PROTOCOL_FIELD_NUMBER = 6;
    private volatile java.lang.Object protocol_;
    /**
     * <pre>
     * Protocol that was used to serve this URL.
     * </pre>
     *
     * <code>string protocol = 6 [(.gen_bq_schema.description) = "Protocol that was used to serve this URL."];</code>
     */
    public java.lang.String getProtocol() {
      java.lang.Object ref = protocol_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        protocol_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Protocol that was used to serve this URL.
     * </pre>
     *
     * <code>string protocol = 6 [(.gen_bq_schema.description) = "Protocol that was used to serve this URL."];</code>
     */
    public com.google.protobuf.ByteString
        getProtocolBytes() {
      java.lang.Object ref = protocol_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        protocol_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getOriginBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, origin_);
      }
      if (!getLocationBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, location_);
      }
      if (!getAnchorBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, anchor_);
      }
      if (!getTitleBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, title_);
      }
      if (!getReferrerBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, referrer_);
      }
      if (!getProtocolBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, protocol_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getOriginBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, origin_);
      }
      if (!getLocationBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, location_);
      }
      if (!getAnchorBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, anchor_);
      }
      if (!getTitleBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, title_);
      }
      if (!getReferrerBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, referrer_);
      }
      if (!getProtocolBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, protocol_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication)) {
        return super.equals(obj);
      }
      io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication other = (io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication) obj;

      boolean result = true;
      result = result && getOrigin()
          .equals(other.getOrigin());
      result = result && getLocation()
          .equals(other.getLocation());
      result = result && getAnchor()
          .equals(other.getAnchor());
      result = result && getTitle()
          .equals(other.getTitle());
      result = result && getReferrer()
          .equals(other.getReferrer());
      result = result && getProtocol()
          .equals(other.getProtocol());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ORIGIN_FIELD_NUMBER;
      hash = (53 * hash) + getOrigin().hashCode();
      hash = (37 * hash) + LOCATION_FIELD_NUMBER;
      hash = (53 * hash) + getLocation().hashCode();
      hash = (37 * hash) + ANCHOR_FIELD_NUMBER;
      hash = (53 * hash) + getAnchor().hashCode();
      hash = (37 * hash) + TITLE_FIELD_NUMBER;
      hash = (53 * hash) + getTitle().hashCode();
      hash = (37 * hash) + REFERRER_FIELD_NUMBER;
      hash = (53 * hash) + getReferrer().hashCode();
      hash = (37 * hash) + PROTOCOL_FIELD_NUMBER;
      hash = (53 * hash) + getProtocol().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies information about a web application reporting information to the telemetry service.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.analytics.context.WebApplication}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.analytics.context.WebApplication)
        io.bloombox.schema.telemetry.context.ApplicationContext.WebApplicationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.telemetry.context.ApplicationContext.internal_static_bloombox_schema_analytics_context_WebApplication_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.telemetry.context.ApplicationContext.internal_static_bloombox_schema_analytics_context_WebApplication_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication.class, io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication.Builder.class);
      }

      // Construct using io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        origin_ = "";

        location_ = "";

        anchor_ = "";

        title_ = "";

        referrer_ = "";

        protocol_ = "";

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.telemetry.context.ApplicationContext.internal_static_bloombox_schema_analytics_context_WebApplication_descriptor;
      }

      public io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication getDefaultInstanceForType() {
        return io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication.getDefaultInstance();
      }

      public io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication build() {
        io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication buildPartial() {
        io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication result = new io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication(this);
        result.origin_ = origin_;
        result.location_ = location_;
        result.anchor_ = anchor_;
        result.title_ = title_;
        result.referrer_ = referrer_;
        result.protocol_ = protocol_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication) {
          return mergeFrom((io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication other) {
        if (other == io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication.getDefaultInstance()) return this;
        if (!other.getOrigin().isEmpty()) {
          origin_ = other.origin_;
          onChanged();
        }
        if (!other.getLocation().isEmpty()) {
          location_ = other.location_;
          onChanged();
        }
        if (!other.getAnchor().isEmpty()) {
          anchor_ = other.anchor_;
          onChanged();
        }
        if (!other.getTitle().isEmpty()) {
          title_ = other.title_;
          onChanged();
        }
        if (!other.getReferrer().isEmpty()) {
          referrer_ = other.referrer_;
          onChanged();
        }
        if (!other.getProtocol().isEmpty()) {
          protocol_ = other.protocol_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object origin_ = "";
      /**
       * <pre>
       * Specifies an origin for a web application.
       * </pre>
       *
       * <code>string origin = 1 [(.gen_bq_schema.description) = "Specifies an origin for a web application."];</code>
       */
      public java.lang.String getOrigin() {
        java.lang.Object ref = origin_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          origin_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Specifies an origin for a web application.
       * </pre>
       *
       * <code>string origin = 1 [(.gen_bq_schema.description) = "Specifies an origin for a web application."];</code>
       */
      public com.google.protobuf.ByteString
          getOriginBytes() {
        java.lang.Object ref = origin_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          origin_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Specifies an origin for a web application.
       * </pre>
       *
       * <code>string origin = 1 [(.gen_bq_schema.description) = "Specifies an origin for a web application."];</code>
       */
      public Builder setOrigin(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        origin_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies an origin for a web application.
       * </pre>
       *
       * <code>string origin = 1 [(.gen_bq_schema.description) = "Specifies an origin for a web application."];</code>
       */
      public Builder clearOrigin() {
        
        origin_ = getDefaultInstance().getOrigin();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies an origin for a web application.
       * </pre>
       *
       * <code>string origin = 1 [(.gen_bq_schema.description) = "Specifies an origin for a web application."];</code>
       */
      public Builder setOriginBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        origin_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object location_ = "";
      /**
       * <pre>
       * Full, absolute URL the user was at when the event was sent.
       * </pre>
       *
       * <code>string location = 2 [(.gen_bq_schema.description) = "Full, absolute URL the user was at when the event was sent."];</code>
       */
      public java.lang.String getLocation() {
        java.lang.Object ref = location_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          location_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Full, absolute URL the user was at when the event was sent.
       * </pre>
       *
       * <code>string location = 2 [(.gen_bq_schema.description) = "Full, absolute URL the user was at when the event was sent."];</code>
       */
      public com.google.protobuf.ByteString
          getLocationBytes() {
        java.lang.Object ref = location_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          location_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Full, absolute URL the user was at when the event was sent.
       * </pre>
       *
       * <code>string location = 2 [(.gen_bq_schema.description) = "Full, absolute URL the user was at when the event was sent."];</code>
       */
      public Builder setLocation(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        location_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Full, absolute URL the user was at when the event was sent.
       * </pre>
       *
       * <code>string location = 2 [(.gen_bq_schema.description) = "Full, absolute URL the user was at when the event was sent."];</code>
       */
      public Builder clearLocation() {
        
        location_ = getDefaultInstance().getLocation();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Full, absolute URL the user was at when the event was sent.
       * </pre>
       *
       * <code>string location = 2 [(.gen_bq_schema.description) = "Full, absolute URL the user was at when the event was sent."];</code>
       */
      public Builder setLocationBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        location_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object anchor_ = "";
      /**
       * <pre>
       * Anchor in the URL, if any.
       * </pre>
       *
       * <code>string anchor = 3 [(.gen_bq_schema.description) = "Anchor in the URL, if any."];</code>
       */
      public java.lang.String getAnchor() {
        java.lang.Object ref = anchor_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          anchor_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Anchor in the URL, if any.
       * </pre>
       *
       * <code>string anchor = 3 [(.gen_bq_schema.description) = "Anchor in the URL, if any."];</code>
       */
      public com.google.protobuf.ByteString
          getAnchorBytes() {
        java.lang.Object ref = anchor_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          anchor_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Anchor in the URL, if any.
       * </pre>
       *
       * <code>string anchor = 3 [(.gen_bq_schema.description) = "Anchor in the URL, if any."];</code>
       */
      public Builder setAnchor(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        anchor_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Anchor in the URL, if any.
       * </pre>
       *
       * <code>string anchor = 3 [(.gen_bq_schema.description) = "Anchor in the URL, if any."];</code>
       */
      public Builder clearAnchor() {
        
        anchor_ = getDefaultInstance().getAnchor();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Anchor in the URL, if any.
       * </pre>
       *
       * <code>string anchor = 3 [(.gen_bq_schema.description) = "Anchor in the URL, if any."];</code>
       */
      public Builder setAnchorBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        anchor_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object title_ = "";
      /**
       * <pre>
       * Title of the current webpage.
       * </pre>
       *
       * <code>string title = 4 [(.gen_bq_schema.description) = "Title of the current webpage."];</code>
       */
      public java.lang.String getTitle() {
        java.lang.Object ref = title_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          title_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Title of the current webpage.
       * </pre>
       *
       * <code>string title = 4 [(.gen_bq_schema.description) = "Title of the current webpage."];</code>
       */
      public com.google.protobuf.ByteString
          getTitleBytes() {
        java.lang.Object ref = title_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          title_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Title of the current webpage.
       * </pre>
       *
       * <code>string title = 4 [(.gen_bq_schema.description) = "Title of the current webpage."];</code>
       */
      public Builder setTitle(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        title_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Title of the current webpage.
       * </pre>
       *
       * <code>string title = 4 [(.gen_bq_schema.description) = "Title of the current webpage."];</code>
       */
      public Builder clearTitle() {
        
        title_ = getDefaultInstance().getTitle();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Title of the current webpage.
       * </pre>
       *
       * <code>string title = 4 [(.gen_bq_schema.description) = "Title of the current webpage."];</code>
       */
      public Builder setTitleBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        title_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object referrer_ = "";
      /**
       * <pre>
       * Referring URL for this webpage.
       * </pre>
       *
       * <code>string referrer = 5 [(.gen_bq_schema.description) = "Referring URL for this webpage."];</code>
       */
      public java.lang.String getReferrer() {
        java.lang.Object ref = referrer_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          referrer_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Referring URL for this webpage.
       * </pre>
       *
       * <code>string referrer = 5 [(.gen_bq_schema.description) = "Referring URL for this webpage."];</code>
       */
      public com.google.protobuf.ByteString
          getReferrerBytes() {
        java.lang.Object ref = referrer_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          referrer_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Referring URL for this webpage.
       * </pre>
       *
       * <code>string referrer = 5 [(.gen_bq_schema.description) = "Referring URL for this webpage."];</code>
       */
      public Builder setReferrer(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        referrer_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Referring URL for this webpage.
       * </pre>
       *
       * <code>string referrer = 5 [(.gen_bq_schema.description) = "Referring URL for this webpage."];</code>
       */
      public Builder clearReferrer() {
        
        referrer_ = getDefaultInstance().getReferrer();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Referring URL for this webpage.
       * </pre>
       *
       * <code>string referrer = 5 [(.gen_bq_schema.description) = "Referring URL for this webpage."];</code>
       */
      public Builder setReferrerBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        referrer_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object protocol_ = "";
      /**
       * <pre>
       * Protocol that was used to serve this URL.
       * </pre>
       *
       * <code>string protocol = 6 [(.gen_bq_schema.description) = "Protocol that was used to serve this URL."];</code>
       */
      public java.lang.String getProtocol() {
        java.lang.Object ref = protocol_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          protocol_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Protocol that was used to serve this URL.
       * </pre>
       *
       * <code>string protocol = 6 [(.gen_bq_schema.description) = "Protocol that was used to serve this URL."];</code>
       */
      public com.google.protobuf.ByteString
          getProtocolBytes() {
        java.lang.Object ref = protocol_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          protocol_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Protocol that was used to serve this URL.
       * </pre>
       *
       * <code>string protocol = 6 [(.gen_bq_schema.description) = "Protocol that was used to serve this URL."];</code>
       */
      public Builder setProtocol(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        protocol_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Protocol that was used to serve this URL.
       * </pre>
       *
       * <code>string protocol = 6 [(.gen_bq_schema.description) = "Protocol that was used to serve this URL."];</code>
       */
      public Builder clearProtocol() {
        
        protocol_ = getDefaultInstance().getProtocol();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Protocol that was used to serve this URL.
       * </pre>
       *
       * <code>string protocol = 6 [(.gen_bq_schema.description) = "Protocol that was used to serve this URL."];</code>
       */
      public Builder setProtocolBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        protocol_ = value;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.analytics.context.WebApplication)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.analytics.context.WebApplication)
    private static final io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication();
    }

    public static io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<WebApplication>
        PARSER = new com.google.protobuf.AbstractParser<WebApplication>() {
      public WebApplication parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new WebApplication(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<WebApplication> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<WebApplication> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface DeviceApplicationOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.analytics.context.DeviceApplication)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Type of application.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.ApplicationType type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Type of application."];</code>
     */
    int getTypeValue();
    /**
     * <pre>
     * Type of application.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.ApplicationType type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Type of application."];</code>
     */
    io.bloombox.schema.telemetry.context.ApplicationContext.ApplicationType getType();

    /**
     * <pre>
     * Version for the reporting application.
     * </pre>
     *
     * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version for the reporting application."];</code>
     */
    boolean hasVersion();
    /**
     * <pre>
     * Version for the reporting application.
     * </pre>
     *
     * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version for the reporting application."];</code>
     */
    io.opencannabis.schema.struct.VersionSpec getVersion();
    /**
     * <pre>
     * Version for the reporting application.
     * </pre>
     *
     * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version for the reporting application."];</code>
     */
    io.opencannabis.schema.struct.VersionSpecOrBuilder getVersionOrBuilder();

    /**
     * <pre>
     * Specifies information about an event that was sent from a web application.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.WebApplication web = 10 [(.gen_bq_schema.description) = "Specifies information about an event that was sent from a web application."];</code>
     */
    boolean hasWeb();
    /**
     * <pre>
     * Specifies information about an event that was sent from a web application.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.WebApplication web = 10 [(.gen_bq_schema.description) = "Specifies information about an event that was sent from a web application."];</code>
     */
    io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication getWeb();
    /**
     * <pre>
     * Specifies information about an event that was sent from a web application.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.WebApplication web = 10 [(.gen_bq_schema.description) = "Specifies information about an event that was sent from a web application."];</code>
     */
    io.bloombox.schema.telemetry.context.ApplicationContext.WebApplicationOrBuilder getWebOrBuilder();

    /**
     * <pre>
     * Specifies a bundle ID for an iOS application.
     * </pre>
     *
     * <code>string bundle_id = 20 [(.gen_bq_schema.description) = "Specifies a bundle ID for an iOS application."];</code>
     */
    java.lang.String getBundleId();
    /**
     * <pre>
     * Specifies a bundle ID for an iOS application.
     * </pre>
     *
     * <code>string bundle_id = 20 [(.gen_bq_schema.description) = "Specifies a bundle ID for an iOS application."];</code>
     */
    com.google.protobuf.ByteString
        getBundleIdBytes();

    /**
     * <pre>
     * Specifies an application ID for an Android application.
     * </pre>
     *
     * <code>string android_package_id = 30 [(.gen_bq_schema.description) = "Specifies an application ID for an Android application."];</code>
     */
    java.lang.String getAndroidPackageId();
    /**
     * <pre>
     * Specifies an application ID for an Android application.
     * </pre>
     *
     * <code>string android_package_id = 30 [(.gen_bq_schema.description) = "Specifies an application ID for an Android application."];</code>
     */
    com.google.protobuf.ByteString
        getAndroidPackageIdBytes();

    public io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication.SpecCase getSpecCase();
  }
  /**
   * <pre>
   * Specifies information about the application reporting information to the telemetry service.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.analytics.context.DeviceApplication}
   */
  public  static final class DeviceApplication extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.analytics.context.DeviceApplication)
      DeviceApplicationOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use DeviceApplication.newBuilder() to construct.
    private DeviceApplication(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private DeviceApplication() {
      type_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private DeviceApplication(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();

              type_ = rawValue;
              break;
            }
            case 18: {
              io.opencannabis.schema.struct.VersionSpec.Builder subBuilder = null;
              if (version_ != null) {
                subBuilder = version_.toBuilder();
              }
              version_ = input.readMessage(io.opencannabis.schema.struct.VersionSpec.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(version_);
                version_ = subBuilder.buildPartial();
              }

              break;
            }
            case 82: {
              io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication.Builder subBuilder = null;
              if (specCase_ == 10) {
                subBuilder = ((io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication) spec_).toBuilder();
              }
              spec_ =
                  input.readMessage(io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication) spec_);
                spec_ = subBuilder.buildPartial();
              }
              specCase_ = 10;
              break;
            }
            case 162: {
              java.lang.String s = input.readStringRequireUtf8();
              specCase_ = 20;
              spec_ = s;
              break;
            }
            case 242: {
              java.lang.String s = input.readStringRequireUtf8();
              specCase_ = 30;
              spec_ = s;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.telemetry.context.ApplicationContext.internal_static_bloombox_schema_analytics_context_DeviceApplication_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.telemetry.context.ApplicationContext.internal_static_bloombox_schema_analytics_context_DeviceApplication_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication.class, io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication.Builder.class);
    }

    private int specCase_ = 0;
    private java.lang.Object spec_;
    public enum SpecCase
        implements com.google.protobuf.Internal.EnumLite {
      WEB(10),
      BUNDLE_ID(20),
      ANDROID_PACKAGE_ID(30),
      SPEC_NOT_SET(0);
      private final int value;
      private SpecCase(int value) {
        this.value = value;
      }
      /**
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static SpecCase valueOf(int value) {
        return forNumber(value);
      }

      public static SpecCase forNumber(int value) {
        switch (value) {
          case 10: return WEB;
          case 20: return BUNDLE_ID;
          case 30: return ANDROID_PACKAGE_ID;
          case 0: return SPEC_NOT_SET;
          default: return null;
        }
      }
      public int getNumber() {
        return this.value;
      }
    };

    public SpecCase
    getSpecCase() {
      return SpecCase.forNumber(
          specCase_);
    }

    public static final int TYPE_FIELD_NUMBER = 1;
    private int type_;
    /**
     * <pre>
     * Type of application.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.ApplicationType type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Type of application."];</code>
     */
    public int getTypeValue() {
      return type_;
    }
    /**
     * <pre>
     * Type of application.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.ApplicationType type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Type of application."];</code>
     */
    public io.bloombox.schema.telemetry.context.ApplicationContext.ApplicationType getType() {
      io.bloombox.schema.telemetry.context.ApplicationContext.ApplicationType result = io.bloombox.schema.telemetry.context.ApplicationContext.ApplicationType.valueOf(type_);
      return result == null ? io.bloombox.schema.telemetry.context.ApplicationContext.ApplicationType.UNRECOGNIZED : result;
    }

    public static final int VERSION_FIELD_NUMBER = 2;
    private io.opencannabis.schema.struct.VersionSpec version_;
    /**
     * <pre>
     * Version for the reporting application.
     * </pre>
     *
     * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version for the reporting application."];</code>
     */
    public boolean hasVersion() {
      return version_ != null;
    }
    /**
     * <pre>
     * Version for the reporting application.
     * </pre>
     *
     * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version for the reporting application."];</code>
     */
    public io.opencannabis.schema.struct.VersionSpec getVersion() {
      return version_ == null ? io.opencannabis.schema.struct.VersionSpec.getDefaultInstance() : version_;
    }
    /**
     * <pre>
     * Version for the reporting application.
     * </pre>
     *
     * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version for the reporting application."];</code>
     */
    public io.opencannabis.schema.struct.VersionSpecOrBuilder getVersionOrBuilder() {
      return getVersion();
    }

    public static final int WEB_FIELD_NUMBER = 10;
    /**
     * <pre>
     * Specifies information about an event that was sent from a web application.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.WebApplication web = 10 [(.gen_bq_schema.description) = "Specifies information about an event that was sent from a web application."];</code>
     */
    public boolean hasWeb() {
      return specCase_ == 10;
    }
    /**
     * <pre>
     * Specifies information about an event that was sent from a web application.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.WebApplication web = 10 [(.gen_bq_schema.description) = "Specifies information about an event that was sent from a web application."];</code>
     */
    public io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication getWeb() {
      if (specCase_ == 10) {
         return (io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication) spec_;
      }
      return io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication.getDefaultInstance();
    }
    /**
     * <pre>
     * Specifies information about an event that was sent from a web application.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.WebApplication web = 10 [(.gen_bq_schema.description) = "Specifies information about an event that was sent from a web application."];</code>
     */
    public io.bloombox.schema.telemetry.context.ApplicationContext.WebApplicationOrBuilder getWebOrBuilder() {
      if (specCase_ == 10) {
         return (io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication) spec_;
      }
      return io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication.getDefaultInstance();
    }

    public static final int BUNDLE_ID_FIELD_NUMBER = 20;
    /**
     * <pre>
     * Specifies a bundle ID for an iOS application.
     * </pre>
     *
     * <code>string bundle_id = 20 [(.gen_bq_schema.description) = "Specifies a bundle ID for an iOS application."];</code>
     */
    public java.lang.String getBundleId() {
      java.lang.Object ref = "";
      if (specCase_ == 20) {
        ref = spec_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (specCase_ == 20) {
          spec_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * Specifies a bundle ID for an iOS application.
     * </pre>
     *
     * <code>string bundle_id = 20 [(.gen_bq_schema.description) = "Specifies a bundle ID for an iOS application."];</code>
     */
    public com.google.protobuf.ByteString
        getBundleIdBytes() {
      java.lang.Object ref = "";
      if (specCase_ == 20) {
        ref = spec_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        if (specCase_ == 20) {
          spec_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ANDROID_PACKAGE_ID_FIELD_NUMBER = 30;
    /**
     * <pre>
     * Specifies an application ID for an Android application.
     * </pre>
     *
     * <code>string android_package_id = 30 [(.gen_bq_schema.description) = "Specifies an application ID for an Android application."];</code>
     */
    public java.lang.String getAndroidPackageId() {
      java.lang.Object ref = "";
      if (specCase_ == 30) {
        ref = spec_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (specCase_ == 30) {
          spec_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * Specifies an application ID for an Android application.
     * </pre>
     *
     * <code>string android_package_id = 30 [(.gen_bq_schema.description) = "Specifies an application ID for an Android application."];</code>
     */
    public com.google.protobuf.ByteString
        getAndroidPackageIdBytes() {
      java.lang.Object ref = "";
      if (specCase_ == 30) {
        ref = spec_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        if (specCase_ == 30) {
          spec_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (type_ != io.bloombox.schema.telemetry.context.ApplicationContext.ApplicationType.INTERNAL.getNumber()) {
        output.writeEnum(1, type_);
      }
      if (version_ != null) {
        output.writeMessage(2, getVersion());
      }
      if (specCase_ == 10) {
        output.writeMessage(10, (io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication) spec_);
      }
      if (specCase_ == 20) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 20, spec_);
      }
      if (specCase_ == 30) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 30, spec_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (type_ != io.bloombox.schema.telemetry.context.ApplicationContext.ApplicationType.INTERNAL.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, type_);
      }
      if (version_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getVersion());
      }
      if (specCase_ == 10) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(10, (io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication) spec_);
      }
      if (specCase_ == 20) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(20, spec_);
      }
      if (specCase_ == 30) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(30, spec_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication)) {
        return super.equals(obj);
      }
      io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication other = (io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication) obj;

      boolean result = true;
      result = result && type_ == other.type_;
      result = result && (hasVersion() == other.hasVersion());
      if (hasVersion()) {
        result = result && getVersion()
            .equals(other.getVersion());
      }
      result = result && getSpecCase().equals(
          other.getSpecCase());
      if (!result) return false;
      switch (specCase_) {
        case 10:
          result = result && getWeb()
              .equals(other.getWeb());
          break;
        case 20:
          result = result && getBundleId()
              .equals(other.getBundleId());
          break;
        case 30:
          result = result && getAndroidPackageId()
              .equals(other.getAndroidPackageId());
          break;
        case 0:
        default:
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      if (hasVersion()) {
        hash = (37 * hash) + VERSION_FIELD_NUMBER;
        hash = (53 * hash) + getVersion().hashCode();
      }
      switch (specCase_) {
        case 10:
          hash = (37 * hash) + WEB_FIELD_NUMBER;
          hash = (53 * hash) + getWeb().hashCode();
          break;
        case 20:
          hash = (37 * hash) + BUNDLE_ID_FIELD_NUMBER;
          hash = (53 * hash) + getBundleId().hashCode();
          break;
        case 30:
          hash = (37 * hash) + ANDROID_PACKAGE_ID_FIELD_NUMBER;
          hash = (53 * hash) + getAndroidPackageId().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies information about the application reporting information to the telemetry service.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.analytics.context.DeviceApplication}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.analytics.context.DeviceApplication)
        io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplicationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.telemetry.context.ApplicationContext.internal_static_bloombox_schema_analytics_context_DeviceApplication_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.telemetry.context.ApplicationContext.internal_static_bloombox_schema_analytics_context_DeviceApplication_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication.class, io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication.Builder.class);
      }

      // Construct using io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        type_ = 0;

        if (versionBuilder_ == null) {
          version_ = null;
        } else {
          version_ = null;
          versionBuilder_ = null;
        }
        specCase_ = 0;
        spec_ = null;
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.telemetry.context.ApplicationContext.internal_static_bloombox_schema_analytics_context_DeviceApplication_descriptor;
      }

      public io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication getDefaultInstanceForType() {
        return io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication.getDefaultInstance();
      }

      public io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication build() {
        io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication buildPartial() {
        io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication result = new io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication(this);
        result.type_ = type_;
        if (versionBuilder_ == null) {
          result.version_ = version_;
        } else {
          result.version_ = versionBuilder_.build();
        }
        if (specCase_ == 10) {
          if (webBuilder_ == null) {
            result.spec_ = spec_;
          } else {
            result.spec_ = webBuilder_.build();
          }
        }
        if (specCase_ == 20) {
          result.spec_ = spec_;
        }
        if (specCase_ == 30) {
          result.spec_ = spec_;
        }
        result.specCase_ = specCase_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication) {
          return mergeFrom((io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication other) {
        if (other == io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication.getDefaultInstance()) return this;
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        if (other.hasVersion()) {
          mergeVersion(other.getVersion());
        }
        switch (other.getSpecCase()) {
          case WEB: {
            mergeWeb(other.getWeb());
            break;
          }
          case BUNDLE_ID: {
            specCase_ = 20;
            spec_ = other.spec_;
            onChanged();
            break;
          }
          case ANDROID_PACKAGE_ID: {
            specCase_ = 30;
            spec_ = other.spec_;
            onChanged();
            break;
          }
          case SPEC_NOT_SET: {
            break;
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int specCase_ = 0;
      private java.lang.Object spec_;
      public SpecCase
          getSpecCase() {
        return SpecCase.forNumber(
            specCase_);
      }

      public Builder clearSpec() {
        specCase_ = 0;
        spec_ = null;
        onChanged();
        return this;
      }


      private int type_ = 0;
      /**
       * <pre>
       * Type of application.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.ApplicationType type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Type of application."];</code>
       */
      public int getTypeValue() {
        return type_;
      }
      /**
       * <pre>
       * Type of application.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.ApplicationType type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Type of application."];</code>
       */
      public Builder setTypeValue(int value) {
        type_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Type of application.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.ApplicationType type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Type of application."];</code>
       */
      public io.bloombox.schema.telemetry.context.ApplicationContext.ApplicationType getType() {
        io.bloombox.schema.telemetry.context.ApplicationContext.ApplicationType result = io.bloombox.schema.telemetry.context.ApplicationContext.ApplicationType.valueOf(type_);
        return result == null ? io.bloombox.schema.telemetry.context.ApplicationContext.ApplicationType.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Type of application.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.ApplicationType type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Type of application."];</code>
       */
      public Builder setType(io.bloombox.schema.telemetry.context.ApplicationContext.ApplicationType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Type of application.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.ApplicationType type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Type of application."];</code>
       */
      public Builder clearType() {
        
        type_ = 0;
        onChanged();
        return this;
      }

      private io.opencannabis.schema.struct.VersionSpec version_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.struct.VersionSpec, io.opencannabis.schema.struct.VersionSpec.Builder, io.opencannabis.schema.struct.VersionSpecOrBuilder> versionBuilder_;
      /**
       * <pre>
       * Version for the reporting application.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version for the reporting application."];</code>
       */
      public boolean hasVersion() {
        return versionBuilder_ != null || version_ != null;
      }
      /**
       * <pre>
       * Version for the reporting application.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version for the reporting application."];</code>
       */
      public io.opencannabis.schema.struct.VersionSpec getVersion() {
        if (versionBuilder_ == null) {
          return version_ == null ? io.opencannabis.schema.struct.VersionSpec.getDefaultInstance() : version_;
        } else {
          return versionBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Version for the reporting application.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version for the reporting application."];</code>
       */
      public Builder setVersion(io.opencannabis.schema.struct.VersionSpec value) {
        if (versionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          version_ = value;
          onChanged();
        } else {
          versionBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Version for the reporting application.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version for the reporting application."];</code>
       */
      public Builder setVersion(
          io.opencannabis.schema.struct.VersionSpec.Builder builderForValue) {
        if (versionBuilder_ == null) {
          version_ = builderForValue.build();
          onChanged();
        } else {
          versionBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Version for the reporting application.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version for the reporting application."];</code>
       */
      public Builder mergeVersion(io.opencannabis.schema.struct.VersionSpec value) {
        if (versionBuilder_ == null) {
          if (version_ != null) {
            version_ =
              io.opencannabis.schema.struct.VersionSpec.newBuilder(version_).mergeFrom(value).buildPartial();
          } else {
            version_ = value;
          }
          onChanged();
        } else {
          versionBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Version for the reporting application.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version for the reporting application."];</code>
       */
      public Builder clearVersion() {
        if (versionBuilder_ == null) {
          version_ = null;
          onChanged();
        } else {
          version_ = null;
          versionBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Version for the reporting application.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version for the reporting application."];</code>
       */
      public io.opencannabis.schema.struct.VersionSpec.Builder getVersionBuilder() {
        
        onChanged();
        return getVersionFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Version for the reporting application.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version for the reporting application."];</code>
       */
      public io.opencannabis.schema.struct.VersionSpecOrBuilder getVersionOrBuilder() {
        if (versionBuilder_ != null) {
          return versionBuilder_.getMessageOrBuilder();
        } else {
          return version_ == null ?
              io.opencannabis.schema.struct.VersionSpec.getDefaultInstance() : version_;
        }
      }
      /**
       * <pre>
       * Version for the reporting application.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version for the reporting application."];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.struct.VersionSpec, io.opencannabis.schema.struct.VersionSpec.Builder, io.opencannabis.schema.struct.VersionSpecOrBuilder> 
          getVersionFieldBuilder() {
        if (versionBuilder_ == null) {
          versionBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.struct.VersionSpec, io.opencannabis.schema.struct.VersionSpec.Builder, io.opencannabis.schema.struct.VersionSpecOrBuilder>(
                  getVersion(),
                  getParentForChildren(),
                  isClean());
          version_ = null;
        }
        return versionBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication, io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication.Builder, io.bloombox.schema.telemetry.context.ApplicationContext.WebApplicationOrBuilder> webBuilder_;
      /**
       * <pre>
       * Specifies information about an event that was sent from a web application.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.WebApplication web = 10 [(.gen_bq_schema.description) = "Specifies information about an event that was sent from a web application."];</code>
       */
      public boolean hasWeb() {
        return specCase_ == 10;
      }
      /**
       * <pre>
       * Specifies information about an event that was sent from a web application.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.WebApplication web = 10 [(.gen_bq_schema.description) = "Specifies information about an event that was sent from a web application."];</code>
       */
      public io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication getWeb() {
        if (webBuilder_ == null) {
          if (specCase_ == 10) {
            return (io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication) spec_;
          }
          return io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication.getDefaultInstance();
        } else {
          if (specCase_ == 10) {
            return webBuilder_.getMessage();
          }
          return io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Specifies information about an event that was sent from a web application.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.WebApplication web = 10 [(.gen_bq_schema.description) = "Specifies information about an event that was sent from a web application."];</code>
       */
      public Builder setWeb(io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication value) {
        if (webBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          spec_ = value;
          onChanged();
        } else {
          webBuilder_.setMessage(value);
        }
        specCase_ = 10;
        return this;
      }
      /**
       * <pre>
       * Specifies information about an event that was sent from a web application.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.WebApplication web = 10 [(.gen_bq_schema.description) = "Specifies information about an event that was sent from a web application."];</code>
       */
      public Builder setWeb(
          io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication.Builder builderForValue) {
        if (webBuilder_ == null) {
          spec_ = builderForValue.build();
          onChanged();
        } else {
          webBuilder_.setMessage(builderForValue.build());
        }
        specCase_ = 10;
        return this;
      }
      /**
       * <pre>
       * Specifies information about an event that was sent from a web application.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.WebApplication web = 10 [(.gen_bq_schema.description) = "Specifies information about an event that was sent from a web application."];</code>
       */
      public Builder mergeWeb(io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication value) {
        if (webBuilder_ == null) {
          if (specCase_ == 10 &&
              spec_ != io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication.getDefaultInstance()) {
            spec_ = io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication.newBuilder((io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication) spec_)
                .mergeFrom(value).buildPartial();
          } else {
            spec_ = value;
          }
          onChanged();
        } else {
          if (specCase_ == 10) {
            webBuilder_.mergeFrom(value);
          }
          webBuilder_.setMessage(value);
        }
        specCase_ = 10;
        return this;
      }
      /**
       * <pre>
       * Specifies information about an event that was sent from a web application.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.WebApplication web = 10 [(.gen_bq_schema.description) = "Specifies information about an event that was sent from a web application."];</code>
       */
      public Builder clearWeb() {
        if (webBuilder_ == null) {
          if (specCase_ == 10) {
            specCase_ = 0;
            spec_ = null;
            onChanged();
          }
        } else {
          if (specCase_ == 10) {
            specCase_ = 0;
            spec_ = null;
          }
          webBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Specifies information about an event that was sent from a web application.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.WebApplication web = 10 [(.gen_bq_schema.description) = "Specifies information about an event that was sent from a web application."];</code>
       */
      public io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication.Builder getWebBuilder() {
        return getWebFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Specifies information about an event that was sent from a web application.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.WebApplication web = 10 [(.gen_bq_schema.description) = "Specifies information about an event that was sent from a web application."];</code>
       */
      public io.bloombox.schema.telemetry.context.ApplicationContext.WebApplicationOrBuilder getWebOrBuilder() {
        if ((specCase_ == 10) && (webBuilder_ != null)) {
          return webBuilder_.getMessageOrBuilder();
        } else {
          if (specCase_ == 10) {
            return (io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication) spec_;
          }
          return io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Specifies information about an event that was sent from a web application.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.WebApplication web = 10 [(.gen_bq_schema.description) = "Specifies information about an event that was sent from a web application."];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication, io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication.Builder, io.bloombox.schema.telemetry.context.ApplicationContext.WebApplicationOrBuilder> 
          getWebFieldBuilder() {
        if (webBuilder_ == null) {
          if (!(specCase_ == 10)) {
            spec_ = io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication.getDefaultInstance();
          }
          webBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication, io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication.Builder, io.bloombox.schema.telemetry.context.ApplicationContext.WebApplicationOrBuilder>(
                  (io.bloombox.schema.telemetry.context.ApplicationContext.WebApplication) spec_,
                  getParentForChildren(),
                  isClean());
          spec_ = null;
        }
        specCase_ = 10;
        onChanged();;
        return webBuilder_;
      }

      /**
       * <pre>
       * Specifies a bundle ID for an iOS application.
       * </pre>
       *
       * <code>string bundle_id = 20 [(.gen_bq_schema.description) = "Specifies a bundle ID for an iOS application."];</code>
       */
      public java.lang.String getBundleId() {
        java.lang.Object ref = "";
        if (specCase_ == 20) {
          ref = spec_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (specCase_ == 20) {
            spec_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Specifies a bundle ID for an iOS application.
       * </pre>
       *
       * <code>string bundle_id = 20 [(.gen_bq_schema.description) = "Specifies a bundle ID for an iOS application."];</code>
       */
      public com.google.protobuf.ByteString
          getBundleIdBytes() {
        java.lang.Object ref = "";
        if (specCase_ == 20) {
          ref = spec_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          if (specCase_ == 20) {
            spec_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Specifies a bundle ID for an iOS application.
       * </pre>
       *
       * <code>string bundle_id = 20 [(.gen_bq_schema.description) = "Specifies a bundle ID for an iOS application."];</code>
       */
      public Builder setBundleId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  specCase_ = 20;
        spec_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies a bundle ID for an iOS application.
       * </pre>
       *
       * <code>string bundle_id = 20 [(.gen_bq_schema.description) = "Specifies a bundle ID for an iOS application."];</code>
       */
      public Builder clearBundleId() {
        if (specCase_ == 20) {
          specCase_ = 0;
          spec_ = null;
          onChanged();
        }
        return this;
      }
      /**
       * <pre>
       * Specifies a bundle ID for an iOS application.
       * </pre>
       *
       * <code>string bundle_id = 20 [(.gen_bq_schema.description) = "Specifies a bundle ID for an iOS application."];</code>
       */
      public Builder setBundleIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        specCase_ = 20;
        spec_ = value;
        onChanged();
        return this;
      }

      /**
       * <pre>
       * Specifies an application ID for an Android application.
       * </pre>
       *
       * <code>string android_package_id = 30 [(.gen_bq_schema.description) = "Specifies an application ID for an Android application."];</code>
       */
      public java.lang.String getAndroidPackageId() {
        java.lang.Object ref = "";
        if (specCase_ == 30) {
          ref = spec_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (specCase_ == 30) {
            spec_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Specifies an application ID for an Android application.
       * </pre>
       *
       * <code>string android_package_id = 30 [(.gen_bq_schema.description) = "Specifies an application ID for an Android application."];</code>
       */
      public com.google.protobuf.ByteString
          getAndroidPackageIdBytes() {
        java.lang.Object ref = "";
        if (specCase_ == 30) {
          ref = spec_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          if (specCase_ == 30) {
            spec_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Specifies an application ID for an Android application.
       * </pre>
       *
       * <code>string android_package_id = 30 [(.gen_bq_schema.description) = "Specifies an application ID for an Android application."];</code>
       */
      public Builder setAndroidPackageId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  specCase_ = 30;
        spec_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies an application ID for an Android application.
       * </pre>
       *
       * <code>string android_package_id = 30 [(.gen_bq_schema.description) = "Specifies an application ID for an Android application."];</code>
       */
      public Builder clearAndroidPackageId() {
        if (specCase_ == 30) {
          specCase_ = 0;
          spec_ = null;
          onChanged();
        }
        return this;
      }
      /**
       * <pre>
       * Specifies an application ID for an Android application.
       * </pre>
       *
       * <code>string android_package_id = 30 [(.gen_bq_schema.description) = "Specifies an application ID for an Android application."];</code>
       */
      public Builder setAndroidPackageIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        specCase_ = 30;
        spec_ = value;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.analytics.context.DeviceApplication)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.analytics.context.DeviceApplication)
    private static final io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication();
    }

    public static io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DeviceApplication>
        PARSER = new com.google.protobuf.AbstractParser<DeviceApplication>() {
      public DeviceApplication parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new DeviceApplication(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<DeviceApplication> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DeviceApplication> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.telemetry.context.ApplicationContext.DeviceApplication getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_analytics_context_WebApplication_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_analytics_context_WebApplication_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_analytics_context_DeviceApplication_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_analytics_context_DeviceApplication_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n#analytics/context/Application.proto\022!b" +
      "loombox.schema.analytics.context\032\016bq_fie" +
      "ld.proto\032\025structs/Version.proto\"\367\002\n\016WebA" +
      "pplication\022=\n\006origin\030\001 \001(\tB-\212@*Specifies" +
      " an origin for a web application.\022P\n\010loc" +
      "ation\030\002 \001(\tB>\212@;Full, absolute URL the u" +
      "ser was at when the event was sent.\022-\n\006a" +
      "nchor\030\003 \001(\tB\035\212@\032Anchor in the URL, if an" +
      "y.\022/\n\005title\030\004 \001(\tB \212@\035Title of the curre" +
      "nt webpage.\0224\n\010referrer\030\005 \001(\tB\"\212@\037Referr" +
      "ing URL for this webpage.\022>\n\010protocol\030\006 " +
      "\001(\tB,\212@)Protocol that was used to serve " +
      "this URL.\"\213\004\n\021DeviceApplication\022\\\n\004type\030" +
      "\001 \001(\01622.bloombox.schema.analytics.contex" +
      "t.ApplicationTypeB\032\360?\001\212@\024Type of applica" +
      "tion.\022]\n\007version\030\002 \001(\0132!.opencannabis.st" +
      "ructs.VersionSpecB)\212@&Version for the re" +
      "porting application.\022\217\001\n\003web\030\n \001(\01321.blo" +
      "ombox.schema.analytics.context.WebApplic" +
      "ationBM\212@JSpecifies information about an" +
      " event that was sent from a web applicat" +
      "ion.H\000\022E\n\tbundle_id\030\024 \001(\tB0\212@-Specifies " +
      "a bundle ID for an iOS application.H\000\022X\n" +
      "\022android_package_id\030\036 \001(\tB:\212@7Specifies " +
      "an application ID for an Android applica" +
      "tion.H\000B\006\n\004spec*,\n\017ApplicationType\022\014\n\010IN" +
      "TERNAL\020\000\022\013\n\007PARTNER\020\001BD\n$io.bloombox.sch" +
      "ema.telemetry.contextB\022ApplicationContex" +
      "tH\001P\000\242\002\003BBSb\006proto3"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          gen_bq_schema.BqField.getDescriptor(),
          io.opencannabis.schema.struct.Version.getDescriptor(),
        }, assigner);
    internal_static_bloombox_schema_analytics_context_WebApplication_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_bloombox_schema_analytics_context_WebApplication_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_analytics_context_WebApplication_descriptor,
        new java.lang.String[] { "Origin", "Location", "Anchor", "Title", "Referrer", "Protocol", });
    internal_static_bloombox_schema_analytics_context_DeviceApplication_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_bloombox_schema_analytics_context_DeviceApplication_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_analytics_context_DeviceApplication_descriptor,
        new java.lang.String[] { "Type", "Version", "Web", "BundleId", "AndroidPackageId", "Spec", });
    com.google.protobuf.ExtensionRegistry registry =
        com.google.protobuf.ExtensionRegistry.newInstance();
    registry.add(gen_bq_schema.BqField.description);
    registry.add(gen_bq_schema.BqField.require);
    com.google.protobuf.Descriptors.FileDescriptor
        .internalUpdateFileDescriptor(descriptor, registry);
    gen_bq_schema.BqField.getDescriptor();
    io.opencannabis.schema.struct.Version.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
