/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: analytics/context/Browser.proto

package io.bloombox.schema.telemetry.context;

public final class BrowserContext {
  private BrowserContext() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   * <pre>
   * Specifies types of browsers or known browser engines.
   * </pre>
   *
   * Protobuf enum {@code bloombox.schema.analytics.context.BrowserType}
   */
  public enum BrowserType
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Specifies an unknown or unrecognized browser.
     * </pre>
     *
     * <code>BROWSER_UNKNOWN = 0;</code>
     */
    BROWSER_UNKNOWN(0),
    /**
     * <pre>
     * Specifies Google Chrome.
     * </pre>
     *
     * <code>CHROME = 1;</code>
     */
    CHROME(1),
    /**
     * <pre>
     * Specifies Apple Safari.
     * </pre>
     *
     * <code>SAFARI = 2;</code>
     */
    SAFARI(2),
    /**
     * <pre>
     * Specifies Mozilla Firefox.
     * </pre>
     *
     * <code>FIREFOX = 3;</code>
     */
    FIREFOX(3),
    /**
     * <pre>
     * Specifies Opera.
     * </pre>
     *
     * <code>OPERA = 4;</code>
     */
    OPERA(4),
    /**
     * <pre>
     * Specifies Microsoft Edge or Microsoft Internet Explorer.
     * </pre>
     *
     * <code>IE_OR_EDGE = 5;</code>
     */
    IE_OR_EDGE(5),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * Specifies an unknown or unrecognized browser.
     * </pre>
     *
     * <code>BROWSER_UNKNOWN = 0;</code>
     */
    public static final int BROWSER_UNKNOWN_VALUE = 0;
    /**
     * <pre>
     * Specifies Google Chrome.
     * </pre>
     *
     * <code>CHROME = 1;</code>
     */
    public static final int CHROME_VALUE = 1;
    /**
     * <pre>
     * Specifies Apple Safari.
     * </pre>
     *
     * <code>SAFARI = 2;</code>
     */
    public static final int SAFARI_VALUE = 2;
    /**
     * <pre>
     * Specifies Mozilla Firefox.
     * </pre>
     *
     * <code>FIREFOX = 3;</code>
     */
    public static final int FIREFOX_VALUE = 3;
    /**
     * <pre>
     * Specifies Opera.
     * </pre>
     *
     * <code>OPERA = 4;</code>
     */
    public static final int OPERA_VALUE = 4;
    /**
     * <pre>
     * Specifies Microsoft Edge or Microsoft Internet Explorer.
     * </pre>
     *
     * <code>IE_OR_EDGE = 5;</code>
     */
    public static final int IE_OR_EDGE_VALUE = 5;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static BrowserType valueOf(int value) {
      return forNumber(value);
    }

    public static BrowserType forNumber(int value) {
      switch (value) {
        case 0: return BROWSER_UNKNOWN;
        case 1: return CHROME;
        case 2: return SAFARI;
        case 3: return FIREFOX;
        case 4: return OPERA;
        case 5: return IE_OR_EDGE;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<BrowserType>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        BrowserType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<BrowserType>() {
            public BrowserType findValueByNumber(int number) {
              return BrowserType.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.bloombox.schema.telemetry.context.BrowserContext.getDescriptor().getEnumTypes().get(0);
    }

    private static final BrowserType[] VALUES = values();

    public static BrowserType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private BrowserType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:bloombox.schema.analytics.context.BrowserType)
  }

  public interface BrowserDeviceContextOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.analytics.context.BrowserDeviceContext)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Specifies the general browser type.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.BrowserType browser_type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the general browser type."];</code>
     */
    int getBrowserTypeValue();
    /**
     * <pre>
     * Specifies the general browser type.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.BrowserType browser_type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the general browser type."];</code>
     */
    io.bloombox.schema.telemetry.context.BrowserContext.BrowserType getBrowserType();

    /**
     * <pre>
     * Version info for the browser.
     * </pre>
     *
     * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version info for the browser."];</code>
     */
    boolean hasVersion();
    /**
     * <pre>
     * Version info for the browser.
     * </pre>
     *
     * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version info for the browser."];</code>
     */
    io.opencannabis.schema.struct.VersionSpec getVersion();
    /**
     * <pre>
     * Version info for the browser.
     * </pre>
     *
     * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version info for the browser."];</code>
     */
    io.opencannabis.schema.struct.VersionSpecOrBuilder getVersionOrBuilder();

    /**
     * <pre>
     * Active language, as reported by the browser.
     * </pre>
     *
     * <code>string language = 3 [(.gen_bq_schema.description) = "Active language, as reported by the browser."];</code>
     */
    java.lang.String getLanguage();
    /**
     * <pre>
     * Active language, as reported by the browser.
     * </pre>
     *
     * <code>string language = 3 [(.gen_bq_schema.description) = "Active language, as reported by the browser."];</code>
     */
    com.google.protobuf.ByteString
        getLanguageBytes();

    /**
     * <pre>
     * Raw user-agent string sent or embedded by the browser.
     * </pre>
     *
     * <code>string user_agent = 4 [(.gen_bq_schema.description) = "Raw user-agent string sent or embedded by the browser."];</code>
     */
    java.lang.String getUserAgent();
    /**
     * <pre>
     * Raw user-agent string sent or embedded by the browser.
     * </pre>
     *
     * <code>string user_agent = 4 [(.gen_bq_schema.description) = "Raw user-agent string sent or embedded by the browser."];</code>
     */
    com.google.protobuf.ByteString
        getUserAgentBytes();

    /**
     * <pre>
     * Maximum touch points for a particular browser.
     * </pre>
     *
     * <code>uint32 touchpoints = 5 [(.gen_bq_schema.description) = "Maximum touch points for a particular browser."];</code>
     */
    int getTouchpoints();

    /**
     * <pre>
     * Hardware concurrency reported by the browser.
     * </pre>
     *
     * <code>uint32 hardware_concurrency = 6 [(.gen_bq_schema.description) = "Hardware concurrency reported by the browser."];</code>
     */
    int getHardwareConcurrency();

    /**
     * <pre>
     * Color depth reported by the browser.
     * </pre>
     *
     * <code>uint32 color_depth = 7 [(.gen_bq_schema.description) = "Color depth reported by the browser."];</code>
     */
    int getColorDepth();
  }
  /**
   * <pre>
   * Specifies a structure describing JavaScript code running in a web browser of some kind.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.analytics.context.BrowserDeviceContext}
   */
  public  static final class BrowserDeviceContext extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.analytics.context.BrowserDeviceContext)
      BrowserDeviceContextOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use BrowserDeviceContext.newBuilder() to construct.
    private BrowserDeviceContext(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private BrowserDeviceContext() {
      browserType_ = 0;
      language_ = "";
      userAgent_ = "";
      touchpoints_ = 0;
      hardwareConcurrency_ = 0;
      colorDepth_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private BrowserDeviceContext(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();

              browserType_ = rawValue;
              break;
            }
            case 18: {
              io.opencannabis.schema.struct.VersionSpec.Builder subBuilder = null;
              if (version_ != null) {
                subBuilder = version_.toBuilder();
              }
              version_ = input.readMessage(io.opencannabis.schema.struct.VersionSpec.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(version_);
                version_ = subBuilder.buildPartial();
              }

              break;
            }
            case 26: {
              java.lang.String s = input.readStringRequireUtf8();

              language_ = s;
              break;
            }
            case 34: {
              java.lang.String s = input.readStringRequireUtf8();

              userAgent_ = s;
              break;
            }
            case 40: {

              touchpoints_ = input.readUInt32();
              break;
            }
            case 48: {

              hardwareConcurrency_ = input.readUInt32();
              break;
            }
            case 56: {

              colorDepth_ = input.readUInt32();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.telemetry.context.BrowserContext.internal_static_bloombox_schema_analytics_context_BrowserDeviceContext_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.telemetry.context.BrowserContext.internal_static_bloombox_schema_analytics_context_BrowserDeviceContext_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext.class, io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext.Builder.class);
    }

    public static final int BROWSER_TYPE_FIELD_NUMBER = 1;
    private int browserType_;
    /**
     * <pre>
     * Specifies the general browser type.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.BrowserType browser_type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the general browser type."];</code>
     */
    public int getBrowserTypeValue() {
      return browserType_;
    }
    /**
     * <pre>
     * Specifies the general browser type.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.BrowserType browser_type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the general browser type."];</code>
     */
    public io.bloombox.schema.telemetry.context.BrowserContext.BrowserType getBrowserType() {
      io.bloombox.schema.telemetry.context.BrowserContext.BrowserType result = io.bloombox.schema.telemetry.context.BrowserContext.BrowserType.valueOf(browserType_);
      return result == null ? io.bloombox.schema.telemetry.context.BrowserContext.BrowserType.UNRECOGNIZED : result;
    }

    public static final int VERSION_FIELD_NUMBER = 2;
    private io.opencannabis.schema.struct.VersionSpec version_;
    /**
     * <pre>
     * Version info for the browser.
     * </pre>
     *
     * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version info for the browser."];</code>
     */
    public boolean hasVersion() {
      return version_ != null;
    }
    /**
     * <pre>
     * Version info for the browser.
     * </pre>
     *
     * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version info for the browser."];</code>
     */
    public io.opencannabis.schema.struct.VersionSpec getVersion() {
      return version_ == null ? io.opencannabis.schema.struct.VersionSpec.getDefaultInstance() : version_;
    }
    /**
     * <pre>
     * Version info for the browser.
     * </pre>
     *
     * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version info for the browser."];</code>
     */
    public io.opencannabis.schema.struct.VersionSpecOrBuilder getVersionOrBuilder() {
      return getVersion();
    }

    public static final int LANGUAGE_FIELD_NUMBER = 3;
    private volatile java.lang.Object language_;
    /**
     * <pre>
     * Active language, as reported by the browser.
     * </pre>
     *
     * <code>string language = 3 [(.gen_bq_schema.description) = "Active language, as reported by the browser."];</code>
     */
    public java.lang.String getLanguage() {
      java.lang.Object ref = language_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        language_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Active language, as reported by the browser.
     * </pre>
     *
     * <code>string language = 3 [(.gen_bq_schema.description) = "Active language, as reported by the browser."];</code>
     */
    public com.google.protobuf.ByteString
        getLanguageBytes() {
      java.lang.Object ref = language_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        language_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int USER_AGENT_FIELD_NUMBER = 4;
    private volatile java.lang.Object userAgent_;
    /**
     * <pre>
     * Raw user-agent string sent or embedded by the browser.
     * </pre>
     *
     * <code>string user_agent = 4 [(.gen_bq_schema.description) = "Raw user-agent string sent or embedded by the browser."];</code>
     */
    public java.lang.String getUserAgent() {
      java.lang.Object ref = userAgent_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        userAgent_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Raw user-agent string sent or embedded by the browser.
     * </pre>
     *
     * <code>string user_agent = 4 [(.gen_bq_schema.description) = "Raw user-agent string sent or embedded by the browser."];</code>
     */
    public com.google.protobuf.ByteString
        getUserAgentBytes() {
      java.lang.Object ref = userAgent_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        userAgent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TOUCHPOINTS_FIELD_NUMBER = 5;
    private int touchpoints_;
    /**
     * <pre>
     * Maximum touch points for a particular browser.
     * </pre>
     *
     * <code>uint32 touchpoints = 5 [(.gen_bq_schema.description) = "Maximum touch points for a particular browser."];</code>
     */
    public int getTouchpoints() {
      return touchpoints_;
    }

    public static final int HARDWARE_CONCURRENCY_FIELD_NUMBER = 6;
    private int hardwareConcurrency_;
    /**
     * <pre>
     * Hardware concurrency reported by the browser.
     * </pre>
     *
     * <code>uint32 hardware_concurrency = 6 [(.gen_bq_schema.description) = "Hardware concurrency reported by the browser."];</code>
     */
    public int getHardwareConcurrency() {
      return hardwareConcurrency_;
    }

    public static final int COLOR_DEPTH_FIELD_NUMBER = 7;
    private int colorDepth_;
    /**
     * <pre>
     * Color depth reported by the browser.
     * </pre>
     *
     * <code>uint32 color_depth = 7 [(.gen_bq_schema.description) = "Color depth reported by the browser."];</code>
     */
    public int getColorDepth() {
      return colorDepth_;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (browserType_ != io.bloombox.schema.telemetry.context.BrowserContext.BrowserType.BROWSER_UNKNOWN.getNumber()) {
        output.writeEnum(1, browserType_);
      }
      if (version_ != null) {
        output.writeMessage(2, getVersion());
      }
      if (!getLanguageBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, language_);
      }
      if (!getUserAgentBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, userAgent_);
      }
      if (touchpoints_ != 0) {
        output.writeUInt32(5, touchpoints_);
      }
      if (hardwareConcurrency_ != 0) {
        output.writeUInt32(6, hardwareConcurrency_);
      }
      if (colorDepth_ != 0) {
        output.writeUInt32(7, colorDepth_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (browserType_ != io.bloombox.schema.telemetry.context.BrowserContext.BrowserType.BROWSER_UNKNOWN.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, browserType_);
      }
      if (version_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getVersion());
      }
      if (!getLanguageBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, language_);
      }
      if (!getUserAgentBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, userAgent_);
      }
      if (touchpoints_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(5, touchpoints_);
      }
      if (hardwareConcurrency_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(6, hardwareConcurrency_);
      }
      if (colorDepth_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(7, colorDepth_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext)) {
        return super.equals(obj);
      }
      io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext other = (io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext) obj;

      boolean result = true;
      result = result && browserType_ == other.browserType_;
      result = result && (hasVersion() == other.hasVersion());
      if (hasVersion()) {
        result = result && getVersion()
            .equals(other.getVersion());
      }
      result = result && getLanguage()
          .equals(other.getLanguage());
      result = result && getUserAgent()
          .equals(other.getUserAgent());
      result = result && (getTouchpoints()
          == other.getTouchpoints());
      result = result && (getHardwareConcurrency()
          == other.getHardwareConcurrency());
      result = result && (getColorDepth()
          == other.getColorDepth());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + BROWSER_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + browserType_;
      if (hasVersion()) {
        hash = (37 * hash) + VERSION_FIELD_NUMBER;
        hash = (53 * hash) + getVersion().hashCode();
      }
      hash = (37 * hash) + LANGUAGE_FIELD_NUMBER;
      hash = (53 * hash) + getLanguage().hashCode();
      hash = (37 * hash) + USER_AGENT_FIELD_NUMBER;
      hash = (53 * hash) + getUserAgent().hashCode();
      hash = (37 * hash) + TOUCHPOINTS_FIELD_NUMBER;
      hash = (53 * hash) + getTouchpoints();
      hash = (37 * hash) + HARDWARE_CONCURRENCY_FIELD_NUMBER;
      hash = (53 * hash) + getHardwareConcurrency();
      hash = (37 * hash) + COLOR_DEPTH_FIELD_NUMBER;
      hash = (53 * hash) + getColorDepth();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies a structure describing JavaScript code running in a web browser of some kind.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.analytics.context.BrowserDeviceContext}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.analytics.context.BrowserDeviceContext)
        io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContextOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.telemetry.context.BrowserContext.internal_static_bloombox_schema_analytics_context_BrowserDeviceContext_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.telemetry.context.BrowserContext.internal_static_bloombox_schema_analytics_context_BrowserDeviceContext_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext.class, io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext.Builder.class);
      }

      // Construct using io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        browserType_ = 0;

        if (versionBuilder_ == null) {
          version_ = null;
        } else {
          version_ = null;
          versionBuilder_ = null;
        }
        language_ = "";

        userAgent_ = "";

        touchpoints_ = 0;

        hardwareConcurrency_ = 0;

        colorDepth_ = 0;

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.telemetry.context.BrowserContext.internal_static_bloombox_schema_analytics_context_BrowserDeviceContext_descriptor;
      }

      public io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext getDefaultInstanceForType() {
        return io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext.getDefaultInstance();
      }

      public io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext build() {
        io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext buildPartial() {
        io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext result = new io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext(this);
        result.browserType_ = browserType_;
        if (versionBuilder_ == null) {
          result.version_ = version_;
        } else {
          result.version_ = versionBuilder_.build();
        }
        result.language_ = language_;
        result.userAgent_ = userAgent_;
        result.touchpoints_ = touchpoints_;
        result.hardwareConcurrency_ = hardwareConcurrency_;
        result.colorDepth_ = colorDepth_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext) {
          return mergeFrom((io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext other) {
        if (other == io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext.getDefaultInstance()) return this;
        if (other.browserType_ != 0) {
          setBrowserTypeValue(other.getBrowserTypeValue());
        }
        if (other.hasVersion()) {
          mergeVersion(other.getVersion());
        }
        if (!other.getLanguage().isEmpty()) {
          language_ = other.language_;
          onChanged();
        }
        if (!other.getUserAgent().isEmpty()) {
          userAgent_ = other.userAgent_;
          onChanged();
        }
        if (other.getTouchpoints() != 0) {
          setTouchpoints(other.getTouchpoints());
        }
        if (other.getHardwareConcurrency() != 0) {
          setHardwareConcurrency(other.getHardwareConcurrency());
        }
        if (other.getColorDepth() != 0) {
          setColorDepth(other.getColorDepth());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int browserType_ = 0;
      /**
       * <pre>
       * Specifies the general browser type.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.BrowserType browser_type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the general browser type."];</code>
       */
      public int getBrowserTypeValue() {
        return browserType_;
      }
      /**
       * <pre>
       * Specifies the general browser type.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.BrowserType browser_type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the general browser type."];</code>
       */
      public Builder setBrowserTypeValue(int value) {
        browserType_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies the general browser type.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.BrowserType browser_type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the general browser type."];</code>
       */
      public io.bloombox.schema.telemetry.context.BrowserContext.BrowserType getBrowserType() {
        io.bloombox.schema.telemetry.context.BrowserContext.BrowserType result = io.bloombox.schema.telemetry.context.BrowserContext.BrowserType.valueOf(browserType_);
        return result == null ? io.bloombox.schema.telemetry.context.BrowserContext.BrowserType.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Specifies the general browser type.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.BrowserType browser_type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the general browser type."];</code>
       */
      public Builder setBrowserType(io.bloombox.schema.telemetry.context.BrowserContext.BrowserType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        browserType_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies the general browser type.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.BrowserType browser_type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the general browser type."];</code>
       */
      public Builder clearBrowserType() {
        
        browserType_ = 0;
        onChanged();
        return this;
      }

      private io.opencannabis.schema.struct.VersionSpec version_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.struct.VersionSpec, io.opencannabis.schema.struct.VersionSpec.Builder, io.opencannabis.schema.struct.VersionSpecOrBuilder> versionBuilder_;
      /**
       * <pre>
       * Version info for the browser.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version info for the browser."];</code>
       */
      public boolean hasVersion() {
        return versionBuilder_ != null || version_ != null;
      }
      /**
       * <pre>
       * Version info for the browser.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version info for the browser."];</code>
       */
      public io.opencannabis.schema.struct.VersionSpec getVersion() {
        if (versionBuilder_ == null) {
          return version_ == null ? io.opencannabis.schema.struct.VersionSpec.getDefaultInstance() : version_;
        } else {
          return versionBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Version info for the browser.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version info for the browser."];</code>
       */
      public Builder setVersion(io.opencannabis.schema.struct.VersionSpec value) {
        if (versionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          version_ = value;
          onChanged();
        } else {
          versionBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Version info for the browser.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version info for the browser."];</code>
       */
      public Builder setVersion(
          io.opencannabis.schema.struct.VersionSpec.Builder builderForValue) {
        if (versionBuilder_ == null) {
          version_ = builderForValue.build();
          onChanged();
        } else {
          versionBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Version info for the browser.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version info for the browser."];</code>
       */
      public Builder mergeVersion(io.opencannabis.schema.struct.VersionSpec value) {
        if (versionBuilder_ == null) {
          if (version_ != null) {
            version_ =
              io.opencannabis.schema.struct.VersionSpec.newBuilder(version_).mergeFrom(value).buildPartial();
          } else {
            version_ = value;
          }
          onChanged();
        } else {
          versionBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Version info for the browser.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version info for the browser."];</code>
       */
      public Builder clearVersion() {
        if (versionBuilder_ == null) {
          version_ = null;
          onChanged();
        } else {
          version_ = null;
          versionBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Version info for the browser.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version info for the browser."];</code>
       */
      public io.opencannabis.schema.struct.VersionSpec.Builder getVersionBuilder() {
        
        onChanged();
        return getVersionFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Version info for the browser.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version info for the browser."];</code>
       */
      public io.opencannabis.schema.struct.VersionSpecOrBuilder getVersionOrBuilder() {
        if (versionBuilder_ != null) {
          return versionBuilder_.getMessageOrBuilder();
        } else {
          return version_ == null ?
              io.opencannabis.schema.struct.VersionSpec.getDefaultInstance() : version_;
        }
      }
      /**
       * <pre>
       * Version info for the browser.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version info for the browser."];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.struct.VersionSpec, io.opencannabis.schema.struct.VersionSpec.Builder, io.opencannabis.schema.struct.VersionSpecOrBuilder> 
          getVersionFieldBuilder() {
        if (versionBuilder_ == null) {
          versionBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.struct.VersionSpec, io.opencannabis.schema.struct.VersionSpec.Builder, io.opencannabis.schema.struct.VersionSpecOrBuilder>(
                  getVersion(),
                  getParentForChildren(),
                  isClean());
          version_ = null;
        }
        return versionBuilder_;
      }

      private java.lang.Object language_ = "";
      /**
       * <pre>
       * Active language, as reported by the browser.
       * </pre>
       *
       * <code>string language = 3 [(.gen_bq_schema.description) = "Active language, as reported by the browser."];</code>
       */
      public java.lang.String getLanguage() {
        java.lang.Object ref = language_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          language_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Active language, as reported by the browser.
       * </pre>
       *
       * <code>string language = 3 [(.gen_bq_schema.description) = "Active language, as reported by the browser."];</code>
       */
      public com.google.protobuf.ByteString
          getLanguageBytes() {
        java.lang.Object ref = language_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          language_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Active language, as reported by the browser.
       * </pre>
       *
       * <code>string language = 3 [(.gen_bq_schema.description) = "Active language, as reported by the browser."];</code>
       */
      public Builder setLanguage(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        language_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Active language, as reported by the browser.
       * </pre>
       *
       * <code>string language = 3 [(.gen_bq_schema.description) = "Active language, as reported by the browser."];</code>
       */
      public Builder clearLanguage() {
        
        language_ = getDefaultInstance().getLanguage();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Active language, as reported by the browser.
       * </pre>
       *
       * <code>string language = 3 [(.gen_bq_schema.description) = "Active language, as reported by the browser."];</code>
       */
      public Builder setLanguageBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        language_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object userAgent_ = "";
      /**
       * <pre>
       * Raw user-agent string sent or embedded by the browser.
       * </pre>
       *
       * <code>string user_agent = 4 [(.gen_bq_schema.description) = "Raw user-agent string sent or embedded by the browser."];</code>
       */
      public java.lang.String getUserAgent() {
        java.lang.Object ref = userAgent_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          userAgent_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Raw user-agent string sent or embedded by the browser.
       * </pre>
       *
       * <code>string user_agent = 4 [(.gen_bq_schema.description) = "Raw user-agent string sent or embedded by the browser."];</code>
       */
      public com.google.protobuf.ByteString
          getUserAgentBytes() {
        java.lang.Object ref = userAgent_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          userAgent_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Raw user-agent string sent or embedded by the browser.
       * </pre>
       *
       * <code>string user_agent = 4 [(.gen_bq_schema.description) = "Raw user-agent string sent or embedded by the browser."];</code>
       */
      public Builder setUserAgent(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        userAgent_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Raw user-agent string sent or embedded by the browser.
       * </pre>
       *
       * <code>string user_agent = 4 [(.gen_bq_schema.description) = "Raw user-agent string sent or embedded by the browser."];</code>
       */
      public Builder clearUserAgent() {
        
        userAgent_ = getDefaultInstance().getUserAgent();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Raw user-agent string sent or embedded by the browser.
       * </pre>
       *
       * <code>string user_agent = 4 [(.gen_bq_schema.description) = "Raw user-agent string sent or embedded by the browser."];</code>
       */
      public Builder setUserAgentBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        userAgent_ = value;
        onChanged();
        return this;
      }

      private int touchpoints_ ;
      /**
       * <pre>
       * Maximum touch points for a particular browser.
       * </pre>
       *
       * <code>uint32 touchpoints = 5 [(.gen_bq_schema.description) = "Maximum touch points for a particular browser."];</code>
       */
      public int getTouchpoints() {
        return touchpoints_;
      }
      /**
       * <pre>
       * Maximum touch points for a particular browser.
       * </pre>
       *
       * <code>uint32 touchpoints = 5 [(.gen_bq_schema.description) = "Maximum touch points for a particular browser."];</code>
       */
      public Builder setTouchpoints(int value) {
        
        touchpoints_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Maximum touch points for a particular browser.
       * </pre>
       *
       * <code>uint32 touchpoints = 5 [(.gen_bq_schema.description) = "Maximum touch points for a particular browser."];</code>
       */
      public Builder clearTouchpoints() {
        
        touchpoints_ = 0;
        onChanged();
        return this;
      }

      private int hardwareConcurrency_ ;
      /**
       * <pre>
       * Hardware concurrency reported by the browser.
       * </pre>
       *
       * <code>uint32 hardware_concurrency = 6 [(.gen_bq_schema.description) = "Hardware concurrency reported by the browser."];</code>
       */
      public int getHardwareConcurrency() {
        return hardwareConcurrency_;
      }
      /**
       * <pre>
       * Hardware concurrency reported by the browser.
       * </pre>
       *
       * <code>uint32 hardware_concurrency = 6 [(.gen_bq_schema.description) = "Hardware concurrency reported by the browser."];</code>
       */
      public Builder setHardwareConcurrency(int value) {
        
        hardwareConcurrency_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Hardware concurrency reported by the browser.
       * </pre>
       *
       * <code>uint32 hardware_concurrency = 6 [(.gen_bq_schema.description) = "Hardware concurrency reported by the browser."];</code>
       */
      public Builder clearHardwareConcurrency() {
        
        hardwareConcurrency_ = 0;
        onChanged();
        return this;
      }

      private int colorDepth_ ;
      /**
       * <pre>
       * Color depth reported by the browser.
       * </pre>
       *
       * <code>uint32 color_depth = 7 [(.gen_bq_schema.description) = "Color depth reported by the browser."];</code>
       */
      public int getColorDepth() {
        return colorDepth_;
      }
      /**
       * <pre>
       * Color depth reported by the browser.
       * </pre>
       *
       * <code>uint32 color_depth = 7 [(.gen_bq_schema.description) = "Color depth reported by the browser."];</code>
       */
      public Builder setColorDepth(int value) {
        
        colorDepth_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Color depth reported by the browser.
       * </pre>
       *
       * <code>uint32 color_depth = 7 [(.gen_bq_schema.description) = "Color depth reported by the browser."];</code>
       */
      public Builder clearColorDepth() {
        
        colorDepth_ = 0;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.analytics.context.BrowserDeviceContext)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.analytics.context.BrowserDeviceContext)
    private static final io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext();
    }

    public static io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<BrowserDeviceContext>
        PARSER = new com.google.protobuf.AbstractParser<BrowserDeviceContext>() {
      public BrowserDeviceContext parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new BrowserDeviceContext(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<BrowserDeviceContext> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<BrowserDeviceContext> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.telemetry.context.BrowserContext.BrowserDeviceContext getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_analytics_context_BrowserDeviceContext_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_analytics_context_BrowserDeviceContext_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\037analytics/context/Browser.proto\022!bloom" +
      "box.schema.analytics.context\032\016bq_field.p" +
      "roto\032\025structs/Version.proto\032\032analytics/c" +
      "ontext/OS.proto\032\037analytics/context/Libra" +
      "ry.proto\032#analytics/context/Application." +
      "proto\032$analytics/context/NativeDevice.pr" +
      "oto\"\305\004\n\024BrowserDeviceContext\022o\n\014browser_" +
      "type\030\001 \001(\0162..bloombox.schema.analytics.c" +
      "ontext.BrowserTypeB)\360?\001\212@#Specifies the " +
      "general browser type.\022T\n\007version\030\002 \001(\0132!" +
      ".opencannabis.structs.VersionSpecB \212@\035Ve" +
      "rsion info for the browser.\022A\n\010language\030" +
      "\003 \001(\tB/\212@,Active language, as reported b" +
      "y the browser.\022M\n\nuser_agent\030\004 \001(\tB9\212@6R" +
      "aw user-agent string sent or embedded by" +
      " the browser.\022F\n\013touchpoints\030\005 \001(\rB1\212@.M" +
      "aximum touch points for a particular bro" +
      "wser.\022N\n\024hardware_concurrency\030\006 \001(\rB0\212@-" +
      "Hardware concurrency reported by the bro" +
      "wser.\022<\n\013color_depth\030\007 \001(\rB\'\212@$Color dep" +
      "th reported by the browser.*b\n\013BrowserTy" +
      "pe\022\023\n\017BROWSER_UNKNOWN\020\000\022\n\n\006CHROME\020\001\022\n\n\006S" +
      "AFARI\020\002\022\013\n\007FIREFOX\020\003\022\t\n\005OPERA\020\004\022\016\n\nIE_OR" +
      "_EDGE\020\005B@\n$io.bloombox.schema.telemetry." +
      "contextB\016BrowserContextH\001P\000\242\002\003BBSb\006proto" +
      "3"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          gen_bq_schema.BqField.getDescriptor(),
          io.opencannabis.schema.struct.Version.getDescriptor(),
          io.bloombox.schema.telemetry.context.OperatingSystemContext.getDescriptor(),
          io.bloombox.schema.telemetry.context.LibraryContext.getDescriptor(),
          io.bloombox.schema.telemetry.context.ApplicationContext.getDescriptor(),
          io.bloombox.schema.telemetry.context.DeviceContext.getDescriptor(),
        }, assigner);
    internal_static_bloombox_schema_analytics_context_BrowserDeviceContext_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_bloombox_schema_analytics_context_BrowserDeviceContext_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_analytics_context_BrowserDeviceContext_descriptor,
        new java.lang.String[] { "BrowserType", "Version", "Language", "UserAgent", "Touchpoints", "HardwareConcurrency", "ColorDepth", });
    com.google.protobuf.ExtensionRegistry registry =
        com.google.protobuf.ExtensionRegistry.newInstance();
    registry.add(gen_bq_schema.BqField.description);
    registry.add(gen_bq_schema.BqField.require);
    com.google.protobuf.Descriptors.FileDescriptor
        .internalUpdateFileDescriptor(descriptor, registry);
    gen_bq_schema.BqField.getDescriptor();
    io.opencannabis.schema.struct.Version.getDescriptor();
    io.bloombox.schema.telemetry.context.OperatingSystemContext.getDescriptor();
    io.bloombox.schema.telemetry.context.LibraryContext.getDescriptor();
    io.bloombox.schema.telemetry.context.ApplicationContext.getDescriptor();
    io.bloombox.schema.telemetry.context.DeviceContext.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
