/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: analytics/context/NativeDevice.proto

package io.bloombox.schema.telemetry.context;

public final class DeviceContext {
  private DeviceContext() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   * <pre>
   * Specifies generic types of native devices that can be described.
   * </pre>
   *
   * Protobuf enum {@code bloombox.schema.analytics.context.DeviceRole}
   */
  public enum DeviceRole
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Indicates that the native device is acting in the role of a client. This is the default option.
     * </pre>
     *
     * <code>CLIENT = 0;</code>
     */
    CLIENT(0),
    /**
     * <pre>
     * Indicates that the native device is acting in the role of a server.
     * </pre>
     *
     * <code>SERVER = 1;</code>
     */
    SERVER(1),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * Indicates that the native device is acting in the role of a client. This is the default option.
     * </pre>
     *
     * <code>CLIENT = 0;</code>
     */
    public static final int CLIENT_VALUE = 0;
    /**
     * <pre>
     * Indicates that the native device is acting in the role of a server.
     * </pre>
     *
     * <code>SERVER = 1;</code>
     */
    public static final int SERVER_VALUE = 1;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DeviceRole valueOf(int value) {
      return forNumber(value);
    }

    public static DeviceRole forNumber(int value) {
      switch (value) {
        case 0: return CLIENT;
        case 1: return SERVER;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DeviceRole>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        DeviceRole> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<DeviceRole>() {
            public DeviceRole findValueByNumber(int number) {
              return DeviceRole.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.bloombox.schema.telemetry.context.DeviceContext.getDescriptor().getEnumTypes().get(0);
    }

    private static final DeviceRole[] VALUES = values();

    public static DeviceRole valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DeviceRole(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:bloombox.schema.analytics.context.DeviceRole)
  }

  /**
   * <pre>
   * Specifies the screen orientation at the time an event was captured.
   * </pre>
   *
   * Protobuf enum {@code bloombox.schema.analytics.context.ScreenOrientation}
   */
  public enum ScreenOrientation
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Unspecified or unknown screen orientation.
     * </pre>
     *
     * <code>UNSPECIFIED_ORIENTATION = 0;</code>
     */
    UNSPECIFIED_ORIENTATION(0),
    /**
     * <pre>
     * Portrait (i.e. width is less than height) screen orientation mode.
     * </pre>
     *
     * <code>PORTRAIT = 1;</code>
     */
    PORTRAIT(1),
    /**
     * <pre>
     * Landscape (i.e. height is less than width) screen orientation mode.
     * </pre>
     *
     * <code>LANDSCAPE = 2;</code>
     */
    LANDSCAPE(2),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * Unspecified or unknown screen orientation.
     * </pre>
     *
     * <code>UNSPECIFIED_ORIENTATION = 0;</code>
     */
    public static final int UNSPECIFIED_ORIENTATION_VALUE = 0;
    /**
     * <pre>
     * Portrait (i.e. width is less than height) screen orientation mode.
     * </pre>
     *
     * <code>PORTRAIT = 1;</code>
     */
    public static final int PORTRAIT_VALUE = 1;
    /**
     * <pre>
     * Landscape (i.e. height is less than width) screen orientation mode.
     * </pre>
     *
     * <code>LANDSCAPE = 2;</code>
     */
    public static final int LANDSCAPE_VALUE = 2;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ScreenOrientation valueOf(int value) {
      return forNumber(value);
    }

    public static ScreenOrientation forNumber(int value) {
      switch (value) {
        case 0: return UNSPECIFIED_ORIENTATION;
        case 1: return PORTRAIT;
        case 2: return LANDSCAPE;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ScreenOrientation>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        ScreenOrientation> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ScreenOrientation>() {
            public ScreenOrientation findValueByNumber(int number) {
              return ScreenOrientation.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.bloombox.schema.telemetry.context.DeviceContext.getDescriptor().getEnumTypes().get(1);
    }

    private static final ScreenOrientation[] VALUES = values();

    public static ScreenOrientation valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ScreenOrientation(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:bloombox.schema.analytics.context.ScreenOrientation)
  }

  public interface PixelSizeOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.analytics.context.PixelSize)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Specifies the width portion of a pixel size.
     * </pre>
     *
     * <code>uint32 width = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the width portion of a pixel size."];</code>
     */
    int getWidth();

    /**
     * <pre>
     * Specifies the height portion of a pixel size.
     * </pre>
     *
     * <code>uint32 height = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the height portion of a pixel size."];</code>
     */
    int getHeight();
  }
  /**
   * <pre>
   * Carries information about a device display, including resolution, pixel density, and viewport size, if applicable.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.analytics.context.PixelSize}
   */
  public  static final class PixelSize extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.analytics.context.PixelSize)
      PixelSizeOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use PixelSize.newBuilder() to construct.
    private PixelSize(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private PixelSize() {
      width_ = 0;
      height_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private PixelSize(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {

              width_ = input.readUInt32();
              break;
            }
            case 16: {

              height_ = input.readUInt32();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.telemetry.context.DeviceContext.internal_static_bloombox_schema_analytics_context_PixelSize_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.telemetry.context.DeviceContext.internal_static_bloombox_schema_analytics_context_PixelSize_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.telemetry.context.DeviceContext.PixelSize.class, io.bloombox.schema.telemetry.context.DeviceContext.PixelSize.Builder.class);
    }

    public static final int WIDTH_FIELD_NUMBER = 1;
    private int width_;
    /**
     * <pre>
     * Specifies the width portion of a pixel size.
     * </pre>
     *
     * <code>uint32 width = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the width portion of a pixel size."];</code>
     */
    public int getWidth() {
      return width_;
    }

    public static final int HEIGHT_FIELD_NUMBER = 2;
    private int height_;
    /**
     * <pre>
     * Specifies the height portion of a pixel size.
     * </pre>
     *
     * <code>uint32 height = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the height portion of a pixel size."];</code>
     */
    public int getHeight() {
      return height_;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (width_ != 0) {
        output.writeUInt32(1, width_);
      }
      if (height_ != 0) {
        output.writeUInt32(2, height_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (width_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(1, width_);
      }
      if (height_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(2, height_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.telemetry.context.DeviceContext.PixelSize)) {
        return super.equals(obj);
      }
      io.bloombox.schema.telemetry.context.DeviceContext.PixelSize other = (io.bloombox.schema.telemetry.context.DeviceContext.PixelSize) obj;

      boolean result = true;
      result = result && (getWidth()
          == other.getWidth());
      result = result && (getHeight()
          == other.getHeight());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + WIDTH_FIELD_NUMBER;
      hash = (53 * hash) + getWidth();
      hash = (37 * hash) + HEIGHT_FIELD_NUMBER;
      hash = (53 * hash) + getHeight();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.telemetry.context.DeviceContext.PixelSize parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.context.DeviceContext.PixelSize parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.DeviceContext.PixelSize parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.context.DeviceContext.PixelSize parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.DeviceContext.PixelSize parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.context.DeviceContext.PixelSize parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.DeviceContext.PixelSize parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.context.DeviceContext.PixelSize parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.DeviceContext.PixelSize parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.context.DeviceContext.PixelSize parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.DeviceContext.PixelSize parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.context.DeviceContext.PixelSize parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.telemetry.context.DeviceContext.PixelSize prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Carries information about a device display, including resolution, pixel density, and viewport size, if applicable.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.analytics.context.PixelSize}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.analytics.context.PixelSize)
        io.bloombox.schema.telemetry.context.DeviceContext.PixelSizeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.telemetry.context.DeviceContext.internal_static_bloombox_schema_analytics_context_PixelSize_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.telemetry.context.DeviceContext.internal_static_bloombox_schema_analytics_context_PixelSize_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.telemetry.context.DeviceContext.PixelSize.class, io.bloombox.schema.telemetry.context.DeviceContext.PixelSize.Builder.class);
      }

      // Construct using io.bloombox.schema.telemetry.context.DeviceContext.PixelSize.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        width_ = 0;

        height_ = 0;

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.telemetry.context.DeviceContext.internal_static_bloombox_schema_analytics_context_PixelSize_descriptor;
      }

      public io.bloombox.schema.telemetry.context.DeviceContext.PixelSize getDefaultInstanceForType() {
        return io.bloombox.schema.telemetry.context.DeviceContext.PixelSize.getDefaultInstance();
      }

      public io.bloombox.schema.telemetry.context.DeviceContext.PixelSize build() {
        io.bloombox.schema.telemetry.context.DeviceContext.PixelSize result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.telemetry.context.DeviceContext.PixelSize buildPartial() {
        io.bloombox.schema.telemetry.context.DeviceContext.PixelSize result = new io.bloombox.schema.telemetry.context.DeviceContext.PixelSize(this);
        result.width_ = width_;
        result.height_ = height_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.telemetry.context.DeviceContext.PixelSize) {
          return mergeFrom((io.bloombox.schema.telemetry.context.DeviceContext.PixelSize)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.telemetry.context.DeviceContext.PixelSize other) {
        if (other == io.bloombox.schema.telemetry.context.DeviceContext.PixelSize.getDefaultInstance()) return this;
        if (other.getWidth() != 0) {
          setWidth(other.getWidth());
        }
        if (other.getHeight() != 0) {
          setHeight(other.getHeight());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.telemetry.context.DeviceContext.PixelSize parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.telemetry.context.DeviceContext.PixelSize) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int width_ ;
      /**
       * <pre>
       * Specifies the width portion of a pixel size.
       * </pre>
       *
       * <code>uint32 width = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the width portion of a pixel size."];</code>
       */
      public int getWidth() {
        return width_;
      }
      /**
       * <pre>
       * Specifies the width portion of a pixel size.
       * </pre>
       *
       * <code>uint32 width = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the width portion of a pixel size."];</code>
       */
      public Builder setWidth(int value) {
        
        width_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies the width portion of a pixel size.
       * </pre>
       *
       * <code>uint32 width = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the width portion of a pixel size."];</code>
       */
      public Builder clearWidth() {
        
        width_ = 0;
        onChanged();
        return this;
      }

      private int height_ ;
      /**
       * <pre>
       * Specifies the height portion of a pixel size.
       * </pre>
       *
       * <code>uint32 height = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the height portion of a pixel size."];</code>
       */
      public int getHeight() {
        return height_;
      }
      /**
       * <pre>
       * Specifies the height portion of a pixel size.
       * </pre>
       *
       * <code>uint32 height = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the height portion of a pixel size."];</code>
       */
      public Builder setHeight(int value) {
        
        height_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies the height portion of a pixel size.
       * </pre>
       *
       * <code>uint32 height = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the height portion of a pixel size."];</code>
       */
      public Builder clearHeight() {
        
        height_ = 0;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.analytics.context.PixelSize)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.analytics.context.PixelSize)
    private static final io.bloombox.schema.telemetry.context.DeviceContext.PixelSize DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.telemetry.context.DeviceContext.PixelSize();
    }

    public static io.bloombox.schema.telemetry.context.DeviceContext.PixelSize getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PixelSize>
        PARSER = new com.google.protobuf.AbstractParser<PixelSize>() {
      public PixelSize parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new PixelSize(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<PixelSize> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PixelSize> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.telemetry.context.DeviceContext.PixelSize getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface DeviceScreenOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.analytics.context.DeviceScreen)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Size of the screen.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.PixelSize screen = 1 [(.gen_bq_schema.description) = "Size of the screen."];</code>
     */
    boolean hasScreen();
    /**
     * <pre>
     * Size of the screen.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.PixelSize screen = 1 [(.gen_bq_schema.description) = "Size of the screen."];</code>
     */
    io.bloombox.schema.telemetry.context.DeviceContext.PixelSize getScreen();
    /**
     * <pre>
     * Size of the screen.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.PixelSize screen = 1 [(.gen_bq_schema.description) = "Size of the screen."];</code>
     */
    io.bloombox.schema.telemetry.context.DeviceContext.PixelSizeOrBuilder getScreenOrBuilder();

    /**
     * <pre>
     * Size of the viewport.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.PixelSize viewport = 2 [(.gen_bq_schema.description) = "Size of the viewport."];</code>
     */
    boolean hasViewport();
    /**
     * <pre>
     * Size of the viewport.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.PixelSize viewport = 2 [(.gen_bq_schema.description) = "Size of the viewport."];</code>
     */
    io.bloombox.schema.telemetry.context.DeviceContext.PixelSize getViewport();
    /**
     * <pre>
     * Size of the viewport.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.PixelSize viewport = 2 [(.gen_bq_schema.description) = "Size of the viewport."];</code>
     */
    io.bloombox.schema.telemetry.context.DeviceContext.PixelSizeOrBuilder getViewportOrBuilder();

    /**
     * <pre>
     * Specifies the pixel density of the screen.
     * </pre>
     *
     * <code>uint32 density = 3 [(.gen_bq_schema.description) = "Specifies the height portion of a pixel size."];</code>
     */
    int getDensity();

    /**
     * <pre>
     * Specifies the orientation of the screen at the time an event was captured.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.ScreenOrientation orientation = 4 [(.gen_bq_schema.description) = "Specifies the orientation of the screen at the time an event was captured."];</code>
     */
    int getOrientationValue();
    /**
     * <pre>
     * Specifies the orientation of the screen at the time an event was captured.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.ScreenOrientation orientation = 4 [(.gen_bq_schema.description) = "Specifies the orientation of the screen at the time an event was captured."];</code>
     */
    io.bloombox.schema.telemetry.context.DeviceContext.ScreenOrientation getOrientation();
  }
  /**
   * <pre>
   * Carries information about the screen being used on the device to display whatever is being instrumented.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.analytics.context.DeviceScreen}
   */
  public  static final class DeviceScreen extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.analytics.context.DeviceScreen)
      DeviceScreenOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use DeviceScreen.newBuilder() to construct.
    private DeviceScreen(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private DeviceScreen() {
      density_ = 0;
      orientation_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private DeviceScreen(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              io.bloombox.schema.telemetry.context.DeviceContext.PixelSize.Builder subBuilder = null;
              if (screen_ != null) {
                subBuilder = screen_.toBuilder();
              }
              screen_ = input.readMessage(io.bloombox.schema.telemetry.context.DeviceContext.PixelSize.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(screen_);
                screen_ = subBuilder.buildPartial();
              }

              break;
            }
            case 18: {
              io.bloombox.schema.telemetry.context.DeviceContext.PixelSize.Builder subBuilder = null;
              if (viewport_ != null) {
                subBuilder = viewport_.toBuilder();
              }
              viewport_ = input.readMessage(io.bloombox.schema.telemetry.context.DeviceContext.PixelSize.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(viewport_);
                viewport_ = subBuilder.buildPartial();
              }

              break;
            }
            case 24: {

              density_ = input.readUInt32();
              break;
            }
            case 32: {
              int rawValue = input.readEnum();

              orientation_ = rawValue;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.telemetry.context.DeviceContext.internal_static_bloombox_schema_analytics_context_DeviceScreen_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.telemetry.context.DeviceContext.internal_static_bloombox_schema_analytics_context_DeviceScreen_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen.class, io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen.Builder.class);
    }

    public static final int SCREEN_FIELD_NUMBER = 1;
    private io.bloombox.schema.telemetry.context.DeviceContext.PixelSize screen_;
    /**
     * <pre>
     * Size of the screen.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.PixelSize screen = 1 [(.gen_bq_schema.description) = "Size of the screen."];</code>
     */
    public boolean hasScreen() {
      return screen_ != null;
    }
    /**
     * <pre>
     * Size of the screen.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.PixelSize screen = 1 [(.gen_bq_schema.description) = "Size of the screen."];</code>
     */
    public io.bloombox.schema.telemetry.context.DeviceContext.PixelSize getScreen() {
      return screen_ == null ? io.bloombox.schema.telemetry.context.DeviceContext.PixelSize.getDefaultInstance() : screen_;
    }
    /**
     * <pre>
     * Size of the screen.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.PixelSize screen = 1 [(.gen_bq_schema.description) = "Size of the screen."];</code>
     */
    public io.bloombox.schema.telemetry.context.DeviceContext.PixelSizeOrBuilder getScreenOrBuilder() {
      return getScreen();
    }

    public static final int VIEWPORT_FIELD_NUMBER = 2;
    private io.bloombox.schema.telemetry.context.DeviceContext.PixelSize viewport_;
    /**
     * <pre>
     * Size of the viewport.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.PixelSize viewport = 2 [(.gen_bq_schema.description) = "Size of the viewport."];</code>
     */
    public boolean hasViewport() {
      return viewport_ != null;
    }
    /**
     * <pre>
     * Size of the viewport.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.PixelSize viewport = 2 [(.gen_bq_schema.description) = "Size of the viewport."];</code>
     */
    public io.bloombox.schema.telemetry.context.DeviceContext.PixelSize getViewport() {
      return viewport_ == null ? io.bloombox.schema.telemetry.context.DeviceContext.PixelSize.getDefaultInstance() : viewport_;
    }
    /**
     * <pre>
     * Size of the viewport.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.PixelSize viewport = 2 [(.gen_bq_schema.description) = "Size of the viewport."];</code>
     */
    public io.bloombox.schema.telemetry.context.DeviceContext.PixelSizeOrBuilder getViewportOrBuilder() {
      return getViewport();
    }

    public static final int DENSITY_FIELD_NUMBER = 3;
    private int density_;
    /**
     * <pre>
     * Specifies the pixel density of the screen.
     * </pre>
     *
     * <code>uint32 density = 3 [(.gen_bq_schema.description) = "Specifies the height portion of a pixel size."];</code>
     */
    public int getDensity() {
      return density_;
    }

    public static final int ORIENTATION_FIELD_NUMBER = 4;
    private int orientation_;
    /**
     * <pre>
     * Specifies the orientation of the screen at the time an event was captured.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.ScreenOrientation orientation = 4 [(.gen_bq_schema.description) = "Specifies the orientation of the screen at the time an event was captured."];</code>
     */
    public int getOrientationValue() {
      return orientation_;
    }
    /**
     * <pre>
     * Specifies the orientation of the screen at the time an event was captured.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.ScreenOrientation orientation = 4 [(.gen_bq_schema.description) = "Specifies the orientation of the screen at the time an event was captured."];</code>
     */
    public io.bloombox.schema.telemetry.context.DeviceContext.ScreenOrientation getOrientation() {
      io.bloombox.schema.telemetry.context.DeviceContext.ScreenOrientation result = io.bloombox.schema.telemetry.context.DeviceContext.ScreenOrientation.valueOf(orientation_);
      return result == null ? io.bloombox.schema.telemetry.context.DeviceContext.ScreenOrientation.UNRECOGNIZED : result;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (screen_ != null) {
        output.writeMessage(1, getScreen());
      }
      if (viewport_ != null) {
        output.writeMessage(2, getViewport());
      }
      if (density_ != 0) {
        output.writeUInt32(3, density_);
      }
      if (orientation_ != io.bloombox.schema.telemetry.context.DeviceContext.ScreenOrientation.UNSPECIFIED_ORIENTATION.getNumber()) {
        output.writeEnum(4, orientation_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (screen_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getScreen());
      }
      if (viewport_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getViewport());
      }
      if (density_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(3, density_);
      }
      if (orientation_ != io.bloombox.schema.telemetry.context.DeviceContext.ScreenOrientation.UNSPECIFIED_ORIENTATION.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(4, orientation_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen)) {
        return super.equals(obj);
      }
      io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen other = (io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen) obj;

      boolean result = true;
      result = result && (hasScreen() == other.hasScreen());
      if (hasScreen()) {
        result = result && getScreen()
            .equals(other.getScreen());
      }
      result = result && (hasViewport() == other.hasViewport());
      if (hasViewport()) {
        result = result && getViewport()
            .equals(other.getViewport());
      }
      result = result && (getDensity()
          == other.getDensity());
      result = result && orientation_ == other.orientation_;
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasScreen()) {
        hash = (37 * hash) + SCREEN_FIELD_NUMBER;
        hash = (53 * hash) + getScreen().hashCode();
      }
      if (hasViewport()) {
        hash = (37 * hash) + VIEWPORT_FIELD_NUMBER;
        hash = (53 * hash) + getViewport().hashCode();
      }
      hash = (37 * hash) + DENSITY_FIELD_NUMBER;
      hash = (53 * hash) + getDensity();
      hash = (37 * hash) + ORIENTATION_FIELD_NUMBER;
      hash = (53 * hash) + orientation_;
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Carries information about the screen being used on the device to display whatever is being instrumented.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.analytics.context.DeviceScreen}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.analytics.context.DeviceScreen)
        io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreenOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.telemetry.context.DeviceContext.internal_static_bloombox_schema_analytics_context_DeviceScreen_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.telemetry.context.DeviceContext.internal_static_bloombox_schema_analytics_context_DeviceScreen_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen.class, io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen.Builder.class);
      }

      // Construct using io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        if (screenBuilder_ == null) {
          screen_ = null;
        } else {
          screen_ = null;
          screenBuilder_ = null;
        }
        if (viewportBuilder_ == null) {
          viewport_ = null;
        } else {
          viewport_ = null;
          viewportBuilder_ = null;
        }
        density_ = 0;

        orientation_ = 0;

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.telemetry.context.DeviceContext.internal_static_bloombox_schema_analytics_context_DeviceScreen_descriptor;
      }

      public io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen getDefaultInstanceForType() {
        return io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen.getDefaultInstance();
      }

      public io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen build() {
        io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen buildPartial() {
        io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen result = new io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen(this);
        if (screenBuilder_ == null) {
          result.screen_ = screen_;
        } else {
          result.screen_ = screenBuilder_.build();
        }
        if (viewportBuilder_ == null) {
          result.viewport_ = viewport_;
        } else {
          result.viewport_ = viewportBuilder_.build();
        }
        result.density_ = density_;
        result.orientation_ = orientation_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen) {
          return mergeFrom((io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen other) {
        if (other == io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen.getDefaultInstance()) return this;
        if (other.hasScreen()) {
          mergeScreen(other.getScreen());
        }
        if (other.hasViewport()) {
          mergeViewport(other.getViewport());
        }
        if (other.getDensity() != 0) {
          setDensity(other.getDensity());
        }
        if (other.orientation_ != 0) {
          setOrientationValue(other.getOrientationValue());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private io.bloombox.schema.telemetry.context.DeviceContext.PixelSize screen_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.telemetry.context.DeviceContext.PixelSize, io.bloombox.schema.telemetry.context.DeviceContext.PixelSize.Builder, io.bloombox.schema.telemetry.context.DeviceContext.PixelSizeOrBuilder> screenBuilder_;
      /**
       * <pre>
       * Size of the screen.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.PixelSize screen = 1 [(.gen_bq_schema.description) = "Size of the screen."];</code>
       */
      public boolean hasScreen() {
        return screenBuilder_ != null || screen_ != null;
      }
      /**
       * <pre>
       * Size of the screen.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.PixelSize screen = 1 [(.gen_bq_schema.description) = "Size of the screen."];</code>
       */
      public io.bloombox.schema.telemetry.context.DeviceContext.PixelSize getScreen() {
        if (screenBuilder_ == null) {
          return screen_ == null ? io.bloombox.schema.telemetry.context.DeviceContext.PixelSize.getDefaultInstance() : screen_;
        } else {
          return screenBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Size of the screen.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.PixelSize screen = 1 [(.gen_bq_schema.description) = "Size of the screen."];</code>
       */
      public Builder setScreen(io.bloombox.schema.telemetry.context.DeviceContext.PixelSize value) {
        if (screenBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          screen_ = value;
          onChanged();
        } else {
          screenBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Size of the screen.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.PixelSize screen = 1 [(.gen_bq_schema.description) = "Size of the screen."];</code>
       */
      public Builder setScreen(
          io.bloombox.schema.telemetry.context.DeviceContext.PixelSize.Builder builderForValue) {
        if (screenBuilder_ == null) {
          screen_ = builderForValue.build();
          onChanged();
        } else {
          screenBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Size of the screen.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.PixelSize screen = 1 [(.gen_bq_schema.description) = "Size of the screen."];</code>
       */
      public Builder mergeScreen(io.bloombox.schema.telemetry.context.DeviceContext.PixelSize value) {
        if (screenBuilder_ == null) {
          if (screen_ != null) {
            screen_ =
              io.bloombox.schema.telemetry.context.DeviceContext.PixelSize.newBuilder(screen_).mergeFrom(value).buildPartial();
          } else {
            screen_ = value;
          }
          onChanged();
        } else {
          screenBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Size of the screen.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.PixelSize screen = 1 [(.gen_bq_schema.description) = "Size of the screen."];</code>
       */
      public Builder clearScreen() {
        if (screenBuilder_ == null) {
          screen_ = null;
          onChanged();
        } else {
          screen_ = null;
          screenBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Size of the screen.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.PixelSize screen = 1 [(.gen_bq_schema.description) = "Size of the screen."];</code>
       */
      public io.bloombox.schema.telemetry.context.DeviceContext.PixelSize.Builder getScreenBuilder() {
        
        onChanged();
        return getScreenFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Size of the screen.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.PixelSize screen = 1 [(.gen_bq_schema.description) = "Size of the screen."];</code>
       */
      public io.bloombox.schema.telemetry.context.DeviceContext.PixelSizeOrBuilder getScreenOrBuilder() {
        if (screenBuilder_ != null) {
          return screenBuilder_.getMessageOrBuilder();
        } else {
          return screen_ == null ?
              io.bloombox.schema.telemetry.context.DeviceContext.PixelSize.getDefaultInstance() : screen_;
        }
      }
      /**
       * <pre>
       * Size of the screen.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.PixelSize screen = 1 [(.gen_bq_schema.description) = "Size of the screen."];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.telemetry.context.DeviceContext.PixelSize, io.bloombox.schema.telemetry.context.DeviceContext.PixelSize.Builder, io.bloombox.schema.telemetry.context.DeviceContext.PixelSizeOrBuilder> 
          getScreenFieldBuilder() {
        if (screenBuilder_ == null) {
          screenBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.telemetry.context.DeviceContext.PixelSize, io.bloombox.schema.telemetry.context.DeviceContext.PixelSize.Builder, io.bloombox.schema.telemetry.context.DeviceContext.PixelSizeOrBuilder>(
                  getScreen(),
                  getParentForChildren(),
                  isClean());
          screen_ = null;
        }
        return screenBuilder_;
      }

      private io.bloombox.schema.telemetry.context.DeviceContext.PixelSize viewport_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.telemetry.context.DeviceContext.PixelSize, io.bloombox.schema.telemetry.context.DeviceContext.PixelSize.Builder, io.bloombox.schema.telemetry.context.DeviceContext.PixelSizeOrBuilder> viewportBuilder_;
      /**
       * <pre>
       * Size of the viewport.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.PixelSize viewport = 2 [(.gen_bq_schema.description) = "Size of the viewport."];</code>
       */
      public boolean hasViewport() {
        return viewportBuilder_ != null || viewport_ != null;
      }
      /**
       * <pre>
       * Size of the viewport.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.PixelSize viewport = 2 [(.gen_bq_schema.description) = "Size of the viewport."];</code>
       */
      public io.bloombox.schema.telemetry.context.DeviceContext.PixelSize getViewport() {
        if (viewportBuilder_ == null) {
          return viewport_ == null ? io.bloombox.schema.telemetry.context.DeviceContext.PixelSize.getDefaultInstance() : viewport_;
        } else {
          return viewportBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Size of the viewport.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.PixelSize viewport = 2 [(.gen_bq_schema.description) = "Size of the viewport."];</code>
       */
      public Builder setViewport(io.bloombox.schema.telemetry.context.DeviceContext.PixelSize value) {
        if (viewportBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          viewport_ = value;
          onChanged();
        } else {
          viewportBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Size of the viewport.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.PixelSize viewport = 2 [(.gen_bq_schema.description) = "Size of the viewport."];</code>
       */
      public Builder setViewport(
          io.bloombox.schema.telemetry.context.DeviceContext.PixelSize.Builder builderForValue) {
        if (viewportBuilder_ == null) {
          viewport_ = builderForValue.build();
          onChanged();
        } else {
          viewportBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Size of the viewport.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.PixelSize viewport = 2 [(.gen_bq_schema.description) = "Size of the viewport."];</code>
       */
      public Builder mergeViewport(io.bloombox.schema.telemetry.context.DeviceContext.PixelSize value) {
        if (viewportBuilder_ == null) {
          if (viewport_ != null) {
            viewport_ =
              io.bloombox.schema.telemetry.context.DeviceContext.PixelSize.newBuilder(viewport_).mergeFrom(value).buildPartial();
          } else {
            viewport_ = value;
          }
          onChanged();
        } else {
          viewportBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Size of the viewport.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.PixelSize viewport = 2 [(.gen_bq_schema.description) = "Size of the viewport."];</code>
       */
      public Builder clearViewport() {
        if (viewportBuilder_ == null) {
          viewport_ = null;
          onChanged();
        } else {
          viewport_ = null;
          viewportBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Size of the viewport.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.PixelSize viewport = 2 [(.gen_bq_schema.description) = "Size of the viewport."];</code>
       */
      public io.bloombox.schema.telemetry.context.DeviceContext.PixelSize.Builder getViewportBuilder() {
        
        onChanged();
        return getViewportFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Size of the viewport.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.PixelSize viewport = 2 [(.gen_bq_schema.description) = "Size of the viewport."];</code>
       */
      public io.bloombox.schema.telemetry.context.DeviceContext.PixelSizeOrBuilder getViewportOrBuilder() {
        if (viewportBuilder_ != null) {
          return viewportBuilder_.getMessageOrBuilder();
        } else {
          return viewport_ == null ?
              io.bloombox.schema.telemetry.context.DeviceContext.PixelSize.getDefaultInstance() : viewport_;
        }
      }
      /**
       * <pre>
       * Size of the viewport.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.PixelSize viewport = 2 [(.gen_bq_schema.description) = "Size of the viewport."];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.telemetry.context.DeviceContext.PixelSize, io.bloombox.schema.telemetry.context.DeviceContext.PixelSize.Builder, io.bloombox.schema.telemetry.context.DeviceContext.PixelSizeOrBuilder> 
          getViewportFieldBuilder() {
        if (viewportBuilder_ == null) {
          viewportBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.telemetry.context.DeviceContext.PixelSize, io.bloombox.schema.telemetry.context.DeviceContext.PixelSize.Builder, io.bloombox.schema.telemetry.context.DeviceContext.PixelSizeOrBuilder>(
                  getViewport(),
                  getParentForChildren(),
                  isClean());
          viewport_ = null;
        }
        return viewportBuilder_;
      }

      private int density_ ;
      /**
       * <pre>
       * Specifies the pixel density of the screen.
       * </pre>
       *
       * <code>uint32 density = 3 [(.gen_bq_schema.description) = "Specifies the height portion of a pixel size."];</code>
       */
      public int getDensity() {
        return density_;
      }
      /**
       * <pre>
       * Specifies the pixel density of the screen.
       * </pre>
       *
       * <code>uint32 density = 3 [(.gen_bq_schema.description) = "Specifies the height portion of a pixel size."];</code>
       */
      public Builder setDensity(int value) {
        
        density_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies the pixel density of the screen.
       * </pre>
       *
       * <code>uint32 density = 3 [(.gen_bq_schema.description) = "Specifies the height portion of a pixel size."];</code>
       */
      public Builder clearDensity() {
        
        density_ = 0;
        onChanged();
        return this;
      }

      private int orientation_ = 0;
      /**
       * <pre>
       * Specifies the orientation of the screen at the time an event was captured.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.ScreenOrientation orientation = 4 [(.gen_bq_schema.description) = "Specifies the orientation of the screen at the time an event was captured."];</code>
       */
      public int getOrientationValue() {
        return orientation_;
      }
      /**
       * <pre>
       * Specifies the orientation of the screen at the time an event was captured.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.ScreenOrientation orientation = 4 [(.gen_bq_schema.description) = "Specifies the orientation of the screen at the time an event was captured."];</code>
       */
      public Builder setOrientationValue(int value) {
        orientation_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies the orientation of the screen at the time an event was captured.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.ScreenOrientation orientation = 4 [(.gen_bq_schema.description) = "Specifies the orientation of the screen at the time an event was captured."];</code>
       */
      public io.bloombox.schema.telemetry.context.DeviceContext.ScreenOrientation getOrientation() {
        io.bloombox.schema.telemetry.context.DeviceContext.ScreenOrientation result = io.bloombox.schema.telemetry.context.DeviceContext.ScreenOrientation.valueOf(orientation_);
        return result == null ? io.bloombox.schema.telemetry.context.DeviceContext.ScreenOrientation.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Specifies the orientation of the screen at the time an event was captured.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.ScreenOrientation orientation = 4 [(.gen_bq_schema.description) = "Specifies the orientation of the screen at the time an event was captured."];</code>
       */
      public Builder setOrientation(io.bloombox.schema.telemetry.context.DeviceContext.ScreenOrientation value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        orientation_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies the orientation of the screen at the time an event was captured.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.ScreenOrientation orientation = 4 [(.gen_bq_schema.description) = "Specifies the orientation of the screen at the time an event was captured."];</code>
       */
      public Builder clearOrientation() {
        
        orientation_ = 0;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.analytics.context.DeviceScreen)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.analytics.context.DeviceScreen)
    private static final io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen();
    }

    public static io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DeviceScreen>
        PARSER = new com.google.protobuf.AbstractParser<DeviceScreen>() {
      public DeviceScreen parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new DeviceScreen(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<DeviceScreen> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DeviceScreen> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface NativeDeviceContextOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.analytics.context.NativeDeviceContext)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Specifies the type of native device.
     * </pre>
     *
     * <code>.opencannabis.device.DeviceType type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the type of native device."];</code>
     */
    int getTypeValue();
    /**
     * <pre>
     * Specifies the type of native device.
     * </pre>
     *
     * <code>.opencannabis.device.DeviceType type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the type of native device."];</code>
     */
    io.opencannabis.schema.device.DeviceType getType();

    /**
     * <pre>
     * Specifies the type of native device.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.DeviceRole role = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the role of the native device."];</code>
     */
    int getRoleValue();
    /**
     * <pre>
     * Specifies the type of native device.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.DeviceRole role = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the role of the native device."];</code>
     */
    io.bloombox.schema.telemetry.context.DeviceContext.DeviceRole getRole();

    /**
     * <pre>
     * Specifies the OS of the native device.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.DeviceOS os = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the OS of the native device."];</code>
     */
    boolean hasOs();
    /**
     * <pre>
     * Specifies the OS of the native device.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.DeviceOS os = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the OS of the native device."];</code>
     */
    io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS getOs();
    /**
     * <pre>
     * Specifies the OS of the native device.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.DeviceOS os = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the OS of the native device."];</code>
     */
    io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOSOrBuilder getOsOrBuilder();

    /**
     * <pre>
     * Bluetooth Low Energy broadcast being emitted by this device.
     * </pre>
     *
     * <code>.opencannabis.proximity.BluetoothBeacon beacon = 6 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signal broadcasting from this device."];</code>
     */
    boolean hasBeacon();
    /**
     * <pre>
     * Bluetooth Low Energy broadcast being emitted by this device.
     * </pre>
     *
     * <code>.opencannabis.proximity.BluetoothBeacon beacon = 6 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signal broadcasting from this device."];</code>
     */
    io.opencannabis.schema.proximity.BluetoothBeacon getBeacon();
    /**
     * <pre>
     * Bluetooth Low Energy broadcast being emitted by this device.
     * </pre>
     *
     * <code>.opencannabis.proximity.BluetoothBeacon beacon = 6 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signal broadcasting from this device."];</code>
     */
    io.opencannabis.schema.proximity.BluetoothBeaconOrBuilder getBeaconOrBuilder();

    /**
     * <pre>
     * BLE signals witnessed by this device.
     * </pre>
     *
     * <code>repeated .opencannabis.proximity.BluetoothBeacon witnessed = 7 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signals witnessed by this device."];</code>
     */
    java.util.List<io.opencannabis.schema.proximity.BluetoothBeacon> 
        getWitnessedList();
    /**
     * <pre>
     * BLE signals witnessed by this device.
     * </pre>
     *
     * <code>repeated .opencannabis.proximity.BluetoothBeacon witnessed = 7 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signals witnessed by this device."];</code>
     */
    io.opencannabis.schema.proximity.BluetoothBeacon getWitnessed(int index);
    /**
     * <pre>
     * BLE signals witnessed by this device.
     * </pre>
     *
     * <code>repeated .opencannabis.proximity.BluetoothBeacon witnessed = 7 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signals witnessed by this device."];</code>
     */
    int getWitnessedCount();
    /**
     * <pre>
     * BLE signals witnessed by this device.
     * </pre>
     *
     * <code>repeated .opencannabis.proximity.BluetoothBeacon witnessed = 7 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signals witnessed by this device."];</code>
     */
    java.util.List<? extends io.opencannabis.schema.proximity.BluetoothBeaconOrBuilder> 
        getWitnessedOrBuilderList();
    /**
     * <pre>
     * BLE signals witnessed by this device.
     * </pre>
     *
     * <code>repeated .opencannabis.proximity.BluetoothBeacon witnessed = 7 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signals witnessed by this device."];</code>
     */
    io.opencannabis.schema.proximity.BluetoothBeaconOrBuilder getWitnessedOrBuilder(
        int index);

    /**
     * <pre>
     * Information about the device screen.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.DeviceScreen screen = 4 [(.gen_bq_schema.description) = "Information about the device screen."];</code>
     */
    boolean hasScreen();
    /**
     * <pre>
     * Information about the device screen.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.DeviceScreen screen = 4 [(.gen_bq_schema.description) = "Information about the device screen."];</code>
     */
    io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen getScreen();
    /**
     * <pre>
     * Information about the device screen.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.DeviceScreen screen = 4 [(.gen_bq_schema.description) = "Information about the device screen."];</code>
     */
    io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreenOrBuilder getScreenOrBuilder();
  }
  /**
   * <pre>
   * Specifies a structure describing code running in some form of a native context.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.analytics.context.NativeDeviceContext}
   */
  public  static final class NativeDeviceContext extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.analytics.context.NativeDeviceContext)
      NativeDeviceContextOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use NativeDeviceContext.newBuilder() to construct.
    private NativeDeviceContext(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private NativeDeviceContext() {
      type_ = 0;
      role_ = 0;
      witnessed_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private NativeDeviceContext(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();

              type_ = rawValue;
              break;
            }
            case 16: {
              int rawValue = input.readEnum();

              role_ = rawValue;
              break;
            }
            case 26: {
              io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS.Builder subBuilder = null;
              if (os_ != null) {
                subBuilder = os_.toBuilder();
              }
              os_ = input.readMessage(io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(os_);
                os_ = subBuilder.buildPartial();
              }

              break;
            }
            case 34: {
              io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen.Builder subBuilder = null;
              if (screen_ != null) {
                subBuilder = screen_.toBuilder();
              }
              screen_ = input.readMessage(io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(screen_);
                screen_ = subBuilder.buildPartial();
              }

              break;
            }
            case 50: {
              io.opencannabis.schema.proximity.BluetoothBeacon.Builder subBuilder = null;
              if (beacon_ != null) {
                subBuilder = beacon_.toBuilder();
              }
              beacon_ = input.readMessage(io.opencannabis.schema.proximity.BluetoothBeacon.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(beacon_);
                beacon_ = subBuilder.buildPartial();
              }

              break;
            }
            case 58: {
              if (!((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
                witnessed_ = new java.util.ArrayList<io.opencannabis.schema.proximity.BluetoothBeacon>();
                mutable_bitField0_ |= 0x00000010;
              }
              witnessed_.add(
                  input.readMessage(io.opencannabis.schema.proximity.BluetoothBeacon.parser(), extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
          witnessed_ = java.util.Collections.unmodifiableList(witnessed_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.telemetry.context.DeviceContext.internal_static_bloombox_schema_analytics_context_NativeDeviceContext_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.telemetry.context.DeviceContext.internal_static_bloombox_schema_analytics_context_NativeDeviceContext_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext.class, io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext.Builder.class);
    }

    private int bitField0_;
    public static final int TYPE_FIELD_NUMBER = 1;
    private int type_;
    /**
     * <pre>
     * Specifies the type of native device.
     * </pre>
     *
     * <code>.opencannabis.device.DeviceType type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the type of native device."];</code>
     */
    public int getTypeValue() {
      return type_;
    }
    /**
     * <pre>
     * Specifies the type of native device.
     * </pre>
     *
     * <code>.opencannabis.device.DeviceType type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the type of native device."];</code>
     */
    public io.opencannabis.schema.device.DeviceType getType() {
      io.opencannabis.schema.device.DeviceType result = io.opencannabis.schema.device.DeviceType.valueOf(type_);
      return result == null ? io.opencannabis.schema.device.DeviceType.UNRECOGNIZED : result;
    }

    public static final int ROLE_FIELD_NUMBER = 2;
    private int role_;
    /**
     * <pre>
     * Specifies the type of native device.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.DeviceRole role = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the role of the native device."];</code>
     */
    public int getRoleValue() {
      return role_;
    }
    /**
     * <pre>
     * Specifies the type of native device.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.DeviceRole role = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the role of the native device."];</code>
     */
    public io.bloombox.schema.telemetry.context.DeviceContext.DeviceRole getRole() {
      io.bloombox.schema.telemetry.context.DeviceContext.DeviceRole result = io.bloombox.schema.telemetry.context.DeviceContext.DeviceRole.valueOf(role_);
      return result == null ? io.bloombox.schema.telemetry.context.DeviceContext.DeviceRole.UNRECOGNIZED : result;
    }

    public static final int OS_FIELD_NUMBER = 3;
    private io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS os_;
    /**
     * <pre>
     * Specifies the OS of the native device.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.DeviceOS os = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the OS of the native device."];</code>
     */
    public boolean hasOs() {
      return os_ != null;
    }
    /**
     * <pre>
     * Specifies the OS of the native device.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.DeviceOS os = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the OS of the native device."];</code>
     */
    public io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS getOs() {
      return os_ == null ? io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS.getDefaultInstance() : os_;
    }
    /**
     * <pre>
     * Specifies the OS of the native device.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.DeviceOS os = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the OS of the native device."];</code>
     */
    public io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOSOrBuilder getOsOrBuilder() {
      return getOs();
    }

    public static final int BEACON_FIELD_NUMBER = 6;
    private io.opencannabis.schema.proximity.BluetoothBeacon beacon_;
    /**
     * <pre>
     * Bluetooth Low Energy broadcast being emitted by this device.
     * </pre>
     *
     * <code>.opencannabis.proximity.BluetoothBeacon beacon = 6 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signal broadcasting from this device."];</code>
     */
    public boolean hasBeacon() {
      return beacon_ != null;
    }
    /**
     * <pre>
     * Bluetooth Low Energy broadcast being emitted by this device.
     * </pre>
     *
     * <code>.opencannabis.proximity.BluetoothBeacon beacon = 6 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signal broadcasting from this device."];</code>
     */
    public io.opencannabis.schema.proximity.BluetoothBeacon getBeacon() {
      return beacon_ == null ? io.opencannabis.schema.proximity.BluetoothBeacon.getDefaultInstance() : beacon_;
    }
    /**
     * <pre>
     * Bluetooth Low Energy broadcast being emitted by this device.
     * </pre>
     *
     * <code>.opencannabis.proximity.BluetoothBeacon beacon = 6 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signal broadcasting from this device."];</code>
     */
    public io.opencannabis.schema.proximity.BluetoothBeaconOrBuilder getBeaconOrBuilder() {
      return getBeacon();
    }

    public static final int WITNESSED_FIELD_NUMBER = 7;
    private java.util.List<io.opencannabis.schema.proximity.BluetoothBeacon> witnessed_;
    /**
     * <pre>
     * BLE signals witnessed by this device.
     * </pre>
     *
     * <code>repeated .opencannabis.proximity.BluetoothBeacon witnessed = 7 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signals witnessed by this device."];</code>
     */
    public java.util.List<io.opencannabis.schema.proximity.BluetoothBeacon> getWitnessedList() {
      return witnessed_;
    }
    /**
     * <pre>
     * BLE signals witnessed by this device.
     * </pre>
     *
     * <code>repeated .opencannabis.proximity.BluetoothBeacon witnessed = 7 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signals witnessed by this device."];</code>
     */
    public java.util.List<? extends io.opencannabis.schema.proximity.BluetoothBeaconOrBuilder> 
        getWitnessedOrBuilderList() {
      return witnessed_;
    }
    /**
     * <pre>
     * BLE signals witnessed by this device.
     * </pre>
     *
     * <code>repeated .opencannabis.proximity.BluetoothBeacon witnessed = 7 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signals witnessed by this device."];</code>
     */
    public int getWitnessedCount() {
      return witnessed_.size();
    }
    /**
     * <pre>
     * BLE signals witnessed by this device.
     * </pre>
     *
     * <code>repeated .opencannabis.proximity.BluetoothBeacon witnessed = 7 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signals witnessed by this device."];</code>
     */
    public io.opencannabis.schema.proximity.BluetoothBeacon getWitnessed(int index) {
      return witnessed_.get(index);
    }
    /**
     * <pre>
     * BLE signals witnessed by this device.
     * </pre>
     *
     * <code>repeated .opencannabis.proximity.BluetoothBeacon witnessed = 7 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signals witnessed by this device."];</code>
     */
    public io.opencannabis.schema.proximity.BluetoothBeaconOrBuilder getWitnessedOrBuilder(
        int index) {
      return witnessed_.get(index);
    }

    public static final int SCREEN_FIELD_NUMBER = 4;
    private io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen screen_;
    /**
     * <pre>
     * Information about the device screen.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.DeviceScreen screen = 4 [(.gen_bq_schema.description) = "Information about the device screen."];</code>
     */
    public boolean hasScreen() {
      return screen_ != null;
    }
    /**
     * <pre>
     * Information about the device screen.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.DeviceScreen screen = 4 [(.gen_bq_schema.description) = "Information about the device screen."];</code>
     */
    public io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen getScreen() {
      return screen_ == null ? io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen.getDefaultInstance() : screen_;
    }
    /**
     * <pre>
     * Information about the device screen.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.DeviceScreen screen = 4 [(.gen_bq_schema.description) = "Information about the device screen."];</code>
     */
    public io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreenOrBuilder getScreenOrBuilder() {
      return getScreen();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (type_ != io.opencannabis.schema.device.DeviceType.UNKNOWN_DEVICE_TYPE.getNumber()) {
        output.writeEnum(1, type_);
      }
      if (role_ != io.bloombox.schema.telemetry.context.DeviceContext.DeviceRole.CLIENT.getNumber()) {
        output.writeEnum(2, role_);
      }
      if (os_ != null) {
        output.writeMessage(3, getOs());
      }
      if (screen_ != null) {
        output.writeMessage(4, getScreen());
      }
      if (beacon_ != null) {
        output.writeMessage(6, getBeacon());
      }
      for (int i = 0; i < witnessed_.size(); i++) {
        output.writeMessage(7, witnessed_.get(i));
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (type_ != io.opencannabis.schema.device.DeviceType.UNKNOWN_DEVICE_TYPE.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, type_);
      }
      if (role_ != io.bloombox.schema.telemetry.context.DeviceContext.DeviceRole.CLIENT.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, role_);
      }
      if (os_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getOs());
      }
      if (screen_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, getScreen());
      }
      if (beacon_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(6, getBeacon());
      }
      for (int i = 0; i < witnessed_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(7, witnessed_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext)) {
        return super.equals(obj);
      }
      io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext other = (io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext) obj;

      boolean result = true;
      result = result && type_ == other.type_;
      result = result && role_ == other.role_;
      result = result && (hasOs() == other.hasOs());
      if (hasOs()) {
        result = result && getOs()
            .equals(other.getOs());
      }
      result = result && (hasBeacon() == other.hasBeacon());
      if (hasBeacon()) {
        result = result && getBeacon()
            .equals(other.getBeacon());
      }
      result = result && getWitnessedList()
          .equals(other.getWitnessedList());
      result = result && (hasScreen() == other.hasScreen());
      if (hasScreen()) {
        result = result && getScreen()
            .equals(other.getScreen());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      hash = (37 * hash) + ROLE_FIELD_NUMBER;
      hash = (53 * hash) + role_;
      if (hasOs()) {
        hash = (37 * hash) + OS_FIELD_NUMBER;
        hash = (53 * hash) + getOs().hashCode();
      }
      if (hasBeacon()) {
        hash = (37 * hash) + BEACON_FIELD_NUMBER;
        hash = (53 * hash) + getBeacon().hashCode();
      }
      if (getWitnessedCount() > 0) {
        hash = (37 * hash) + WITNESSED_FIELD_NUMBER;
        hash = (53 * hash) + getWitnessedList().hashCode();
      }
      if (hasScreen()) {
        hash = (37 * hash) + SCREEN_FIELD_NUMBER;
        hash = (53 * hash) + getScreen().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies a structure describing code running in some form of a native context.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.analytics.context.NativeDeviceContext}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.analytics.context.NativeDeviceContext)
        io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContextOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.telemetry.context.DeviceContext.internal_static_bloombox_schema_analytics_context_NativeDeviceContext_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.telemetry.context.DeviceContext.internal_static_bloombox_schema_analytics_context_NativeDeviceContext_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext.class, io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext.Builder.class);
      }

      // Construct using io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getWitnessedFieldBuilder();
        }
      }
      public Builder clear() {
        super.clear();
        type_ = 0;

        role_ = 0;

        if (osBuilder_ == null) {
          os_ = null;
        } else {
          os_ = null;
          osBuilder_ = null;
        }
        if (beaconBuilder_ == null) {
          beacon_ = null;
        } else {
          beacon_ = null;
          beaconBuilder_ = null;
        }
        if (witnessedBuilder_ == null) {
          witnessed_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
        } else {
          witnessedBuilder_.clear();
        }
        if (screenBuilder_ == null) {
          screen_ = null;
        } else {
          screen_ = null;
          screenBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.telemetry.context.DeviceContext.internal_static_bloombox_schema_analytics_context_NativeDeviceContext_descriptor;
      }

      public io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext getDefaultInstanceForType() {
        return io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext.getDefaultInstance();
      }

      public io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext build() {
        io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext buildPartial() {
        io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext result = new io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        result.type_ = type_;
        result.role_ = role_;
        if (osBuilder_ == null) {
          result.os_ = os_;
        } else {
          result.os_ = osBuilder_.build();
        }
        if (beaconBuilder_ == null) {
          result.beacon_ = beacon_;
        } else {
          result.beacon_ = beaconBuilder_.build();
        }
        if (witnessedBuilder_ == null) {
          if (((bitField0_ & 0x00000010) == 0x00000010)) {
            witnessed_ = java.util.Collections.unmodifiableList(witnessed_);
            bitField0_ = (bitField0_ & ~0x00000010);
          }
          result.witnessed_ = witnessed_;
        } else {
          result.witnessed_ = witnessedBuilder_.build();
        }
        if (screenBuilder_ == null) {
          result.screen_ = screen_;
        } else {
          result.screen_ = screenBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext) {
          return mergeFrom((io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext other) {
        if (other == io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext.getDefaultInstance()) return this;
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        if (other.role_ != 0) {
          setRoleValue(other.getRoleValue());
        }
        if (other.hasOs()) {
          mergeOs(other.getOs());
        }
        if (other.hasBeacon()) {
          mergeBeacon(other.getBeacon());
        }
        if (witnessedBuilder_ == null) {
          if (!other.witnessed_.isEmpty()) {
            if (witnessed_.isEmpty()) {
              witnessed_ = other.witnessed_;
              bitField0_ = (bitField0_ & ~0x00000010);
            } else {
              ensureWitnessedIsMutable();
              witnessed_.addAll(other.witnessed_);
            }
            onChanged();
          }
        } else {
          if (!other.witnessed_.isEmpty()) {
            if (witnessedBuilder_.isEmpty()) {
              witnessedBuilder_.dispose();
              witnessedBuilder_ = null;
              witnessed_ = other.witnessed_;
              bitField0_ = (bitField0_ & ~0x00000010);
              witnessedBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getWitnessedFieldBuilder() : null;
            } else {
              witnessedBuilder_.addAllMessages(other.witnessed_);
            }
          }
        }
        if (other.hasScreen()) {
          mergeScreen(other.getScreen());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private int type_ = 0;
      /**
       * <pre>
       * Specifies the type of native device.
       * </pre>
       *
       * <code>.opencannabis.device.DeviceType type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the type of native device."];</code>
       */
      public int getTypeValue() {
        return type_;
      }
      /**
       * <pre>
       * Specifies the type of native device.
       * </pre>
       *
       * <code>.opencannabis.device.DeviceType type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the type of native device."];</code>
       */
      public Builder setTypeValue(int value) {
        type_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies the type of native device.
       * </pre>
       *
       * <code>.opencannabis.device.DeviceType type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the type of native device."];</code>
       */
      public io.opencannabis.schema.device.DeviceType getType() {
        io.opencannabis.schema.device.DeviceType result = io.opencannabis.schema.device.DeviceType.valueOf(type_);
        return result == null ? io.opencannabis.schema.device.DeviceType.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Specifies the type of native device.
       * </pre>
       *
       * <code>.opencannabis.device.DeviceType type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the type of native device."];</code>
       */
      public Builder setType(io.opencannabis.schema.device.DeviceType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies the type of native device.
       * </pre>
       *
       * <code>.opencannabis.device.DeviceType type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the type of native device."];</code>
       */
      public Builder clearType() {
        
        type_ = 0;
        onChanged();
        return this;
      }

      private int role_ = 0;
      /**
       * <pre>
       * Specifies the type of native device.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceRole role = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the role of the native device."];</code>
       */
      public int getRoleValue() {
        return role_;
      }
      /**
       * <pre>
       * Specifies the type of native device.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceRole role = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the role of the native device."];</code>
       */
      public Builder setRoleValue(int value) {
        role_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies the type of native device.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceRole role = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the role of the native device."];</code>
       */
      public io.bloombox.schema.telemetry.context.DeviceContext.DeviceRole getRole() {
        io.bloombox.schema.telemetry.context.DeviceContext.DeviceRole result = io.bloombox.schema.telemetry.context.DeviceContext.DeviceRole.valueOf(role_);
        return result == null ? io.bloombox.schema.telemetry.context.DeviceContext.DeviceRole.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Specifies the type of native device.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceRole role = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the role of the native device."];</code>
       */
      public Builder setRole(io.bloombox.schema.telemetry.context.DeviceContext.DeviceRole value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        role_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies the type of native device.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceRole role = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the role of the native device."];</code>
       */
      public Builder clearRole() {
        
        role_ = 0;
        onChanged();
        return this;
      }

      private io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS os_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS, io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS.Builder, io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOSOrBuilder> osBuilder_;
      /**
       * <pre>
       * Specifies the OS of the native device.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceOS os = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the OS of the native device."];</code>
       */
      public boolean hasOs() {
        return osBuilder_ != null || os_ != null;
      }
      /**
       * <pre>
       * Specifies the OS of the native device.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceOS os = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the OS of the native device."];</code>
       */
      public io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS getOs() {
        if (osBuilder_ == null) {
          return os_ == null ? io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS.getDefaultInstance() : os_;
        } else {
          return osBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Specifies the OS of the native device.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceOS os = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the OS of the native device."];</code>
       */
      public Builder setOs(io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS value) {
        if (osBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          os_ = value;
          onChanged();
        } else {
          osBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies the OS of the native device.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceOS os = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the OS of the native device."];</code>
       */
      public Builder setOs(
          io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS.Builder builderForValue) {
        if (osBuilder_ == null) {
          os_ = builderForValue.build();
          onChanged();
        } else {
          osBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Specifies the OS of the native device.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceOS os = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the OS of the native device."];</code>
       */
      public Builder mergeOs(io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS value) {
        if (osBuilder_ == null) {
          if (os_ != null) {
            os_ =
              io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS.newBuilder(os_).mergeFrom(value).buildPartial();
          } else {
            os_ = value;
          }
          onChanged();
        } else {
          osBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specifies the OS of the native device.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceOS os = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the OS of the native device."];</code>
       */
      public Builder clearOs() {
        if (osBuilder_ == null) {
          os_ = null;
          onChanged();
        } else {
          os_ = null;
          osBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Specifies the OS of the native device.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceOS os = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the OS of the native device."];</code>
       */
      public io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS.Builder getOsBuilder() {
        
        onChanged();
        return getOsFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Specifies the OS of the native device.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceOS os = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the OS of the native device."];</code>
       */
      public io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOSOrBuilder getOsOrBuilder() {
        if (osBuilder_ != null) {
          return osBuilder_.getMessageOrBuilder();
        } else {
          return os_ == null ?
              io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS.getDefaultInstance() : os_;
        }
      }
      /**
       * <pre>
       * Specifies the OS of the native device.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceOS os = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Specifies the OS of the native device."];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS, io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS.Builder, io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOSOrBuilder> 
          getOsFieldBuilder() {
        if (osBuilder_ == null) {
          osBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS, io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS.Builder, io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOSOrBuilder>(
                  getOs(),
                  getParentForChildren(),
                  isClean());
          os_ = null;
        }
        return osBuilder_;
      }

      private io.opencannabis.schema.proximity.BluetoothBeacon beacon_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.proximity.BluetoothBeacon, io.opencannabis.schema.proximity.BluetoothBeacon.Builder, io.opencannabis.schema.proximity.BluetoothBeaconOrBuilder> beaconBuilder_;
      /**
       * <pre>
       * Bluetooth Low Energy broadcast being emitted by this device.
       * </pre>
       *
       * <code>.opencannabis.proximity.BluetoothBeacon beacon = 6 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signal broadcasting from this device."];</code>
       */
      public boolean hasBeacon() {
        return beaconBuilder_ != null || beacon_ != null;
      }
      /**
       * <pre>
       * Bluetooth Low Energy broadcast being emitted by this device.
       * </pre>
       *
       * <code>.opencannabis.proximity.BluetoothBeacon beacon = 6 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signal broadcasting from this device."];</code>
       */
      public io.opencannabis.schema.proximity.BluetoothBeacon getBeacon() {
        if (beaconBuilder_ == null) {
          return beacon_ == null ? io.opencannabis.schema.proximity.BluetoothBeacon.getDefaultInstance() : beacon_;
        } else {
          return beaconBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Bluetooth Low Energy broadcast being emitted by this device.
       * </pre>
       *
       * <code>.opencannabis.proximity.BluetoothBeacon beacon = 6 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signal broadcasting from this device."];</code>
       */
      public Builder setBeacon(io.opencannabis.schema.proximity.BluetoothBeacon value) {
        if (beaconBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          beacon_ = value;
          onChanged();
        } else {
          beaconBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Bluetooth Low Energy broadcast being emitted by this device.
       * </pre>
       *
       * <code>.opencannabis.proximity.BluetoothBeacon beacon = 6 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signal broadcasting from this device."];</code>
       */
      public Builder setBeacon(
          io.opencannabis.schema.proximity.BluetoothBeacon.Builder builderForValue) {
        if (beaconBuilder_ == null) {
          beacon_ = builderForValue.build();
          onChanged();
        } else {
          beaconBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Bluetooth Low Energy broadcast being emitted by this device.
       * </pre>
       *
       * <code>.opencannabis.proximity.BluetoothBeacon beacon = 6 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signal broadcasting from this device."];</code>
       */
      public Builder mergeBeacon(io.opencannabis.schema.proximity.BluetoothBeacon value) {
        if (beaconBuilder_ == null) {
          if (beacon_ != null) {
            beacon_ =
              io.opencannabis.schema.proximity.BluetoothBeacon.newBuilder(beacon_).mergeFrom(value).buildPartial();
          } else {
            beacon_ = value;
          }
          onChanged();
        } else {
          beaconBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Bluetooth Low Energy broadcast being emitted by this device.
       * </pre>
       *
       * <code>.opencannabis.proximity.BluetoothBeacon beacon = 6 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signal broadcasting from this device."];</code>
       */
      public Builder clearBeacon() {
        if (beaconBuilder_ == null) {
          beacon_ = null;
          onChanged();
        } else {
          beacon_ = null;
          beaconBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Bluetooth Low Energy broadcast being emitted by this device.
       * </pre>
       *
       * <code>.opencannabis.proximity.BluetoothBeacon beacon = 6 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signal broadcasting from this device."];</code>
       */
      public io.opencannabis.schema.proximity.BluetoothBeacon.Builder getBeaconBuilder() {
        
        onChanged();
        return getBeaconFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Bluetooth Low Energy broadcast being emitted by this device.
       * </pre>
       *
       * <code>.opencannabis.proximity.BluetoothBeacon beacon = 6 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signal broadcasting from this device."];</code>
       */
      public io.opencannabis.schema.proximity.BluetoothBeaconOrBuilder getBeaconOrBuilder() {
        if (beaconBuilder_ != null) {
          return beaconBuilder_.getMessageOrBuilder();
        } else {
          return beacon_ == null ?
              io.opencannabis.schema.proximity.BluetoothBeacon.getDefaultInstance() : beacon_;
        }
      }
      /**
       * <pre>
       * Bluetooth Low Energy broadcast being emitted by this device.
       * </pre>
       *
       * <code>.opencannabis.proximity.BluetoothBeacon beacon = 6 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signal broadcasting from this device."];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.proximity.BluetoothBeacon, io.opencannabis.schema.proximity.BluetoothBeacon.Builder, io.opencannabis.schema.proximity.BluetoothBeaconOrBuilder> 
          getBeaconFieldBuilder() {
        if (beaconBuilder_ == null) {
          beaconBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.proximity.BluetoothBeacon, io.opencannabis.schema.proximity.BluetoothBeacon.Builder, io.opencannabis.schema.proximity.BluetoothBeaconOrBuilder>(
                  getBeacon(),
                  getParentForChildren(),
                  isClean());
          beacon_ = null;
        }
        return beaconBuilder_;
      }

      private java.util.List<io.opencannabis.schema.proximity.BluetoothBeacon> witnessed_ =
        java.util.Collections.emptyList();
      private void ensureWitnessedIsMutable() {
        if (!((bitField0_ & 0x00000010) == 0x00000010)) {
          witnessed_ = new java.util.ArrayList<io.opencannabis.schema.proximity.BluetoothBeacon>(witnessed_);
          bitField0_ |= 0x00000010;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.opencannabis.schema.proximity.BluetoothBeacon, io.opencannabis.schema.proximity.BluetoothBeacon.Builder, io.opencannabis.schema.proximity.BluetoothBeaconOrBuilder> witnessedBuilder_;

      /**
       * <pre>
       * BLE signals witnessed by this device.
       * </pre>
       *
       * <code>repeated .opencannabis.proximity.BluetoothBeacon witnessed = 7 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signals witnessed by this device."];</code>
       */
      public java.util.List<io.opencannabis.schema.proximity.BluetoothBeacon> getWitnessedList() {
        if (witnessedBuilder_ == null) {
          return java.util.Collections.unmodifiableList(witnessed_);
        } else {
          return witnessedBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * BLE signals witnessed by this device.
       * </pre>
       *
       * <code>repeated .opencannabis.proximity.BluetoothBeacon witnessed = 7 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signals witnessed by this device."];</code>
       */
      public int getWitnessedCount() {
        if (witnessedBuilder_ == null) {
          return witnessed_.size();
        } else {
          return witnessedBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * BLE signals witnessed by this device.
       * </pre>
       *
       * <code>repeated .opencannabis.proximity.BluetoothBeacon witnessed = 7 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signals witnessed by this device."];</code>
       */
      public io.opencannabis.schema.proximity.BluetoothBeacon getWitnessed(int index) {
        if (witnessedBuilder_ == null) {
          return witnessed_.get(index);
        } else {
          return witnessedBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * BLE signals witnessed by this device.
       * </pre>
       *
       * <code>repeated .opencannabis.proximity.BluetoothBeacon witnessed = 7 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signals witnessed by this device."];</code>
       */
      public Builder setWitnessed(
          int index, io.opencannabis.schema.proximity.BluetoothBeacon value) {
        if (witnessedBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureWitnessedIsMutable();
          witnessed_.set(index, value);
          onChanged();
        } else {
          witnessedBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * BLE signals witnessed by this device.
       * </pre>
       *
       * <code>repeated .opencannabis.proximity.BluetoothBeacon witnessed = 7 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signals witnessed by this device."];</code>
       */
      public Builder setWitnessed(
          int index, io.opencannabis.schema.proximity.BluetoothBeacon.Builder builderForValue) {
        if (witnessedBuilder_ == null) {
          ensureWitnessedIsMutable();
          witnessed_.set(index, builderForValue.build());
          onChanged();
        } else {
          witnessedBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * BLE signals witnessed by this device.
       * </pre>
       *
       * <code>repeated .opencannabis.proximity.BluetoothBeacon witnessed = 7 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signals witnessed by this device."];</code>
       */
      public Builder addWitnessed(io.opencannabis.schema.proximity.BluetoothBeacon value) {
        if (witnessedBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureWitnessedIsMutable();
          witnessed_.add(value);
          onChanged();
        } else {
          witnessedBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * BLE signals witnessed by this device.
       * </pre>
       *
       * <code>repeated .opencannabis.proximity.BluetoothBeacon witnessed = 7 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signals witnessed by this device."];</code>
       */
      public Builder addWitnessed(
          int index, io.opencannabis.schema.proximity.BluetoothBeacon value) {
        if (witnessedBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureWitnessedIsMutable();
          witnessed_.add(index, value);
          onChanged();
        } else {
          witnessedBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * BLE signals witnessed by this device.
       * </pre>
       *
       * <code>repeated .opencannabis.proximity.BluetoothBeacon witnessed = 7 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signals witnessed by this device."];</code>
       */
      public Builder addWitnessed(
          io.opencannabis.schema.proximity.BluetoothBeacon.Builder builderForValue) {
        if (witnessedBuilder_ == null) {
          ensureWitnessedIsMutable();
          witnessed_.add(builderForValue.build());
          onChanged();
        } else {
          witnessedBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * BLE signals witnessed by this device.
       * </pre>
       *
       * <code>repeated .opencannabis.proximity.BluetoothBeacon witnessed = 7 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signals witnessed by this device."];</code>
       */
      public Builder addWitnessed(
          int index, io.opencannabis.schema.proximity.BluetoothBeacon.Builder builderForValue) {
        if (witnessedBuilder_ == null) {
          ensureWitnessedIsMutable();
          witnessed_.add(index, builderForValue.build());
          onChanged();
        } else {
          witnessedBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * BLE signals witnessed by this device.
       * </pre>
       *
       * <code>repeated .opencannabis.proximity.BluetoothBeacon witnessed = 7 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signals witnessed by this device."];</code>
       */
      public Builder addAllWitnessed(
          java.lang.Iterable<? extends io.opencannabis.schema.proximity.BluetoothBeacon> values) {
        if (witnessedBuilder_ == null) {
          ensureWitnessedIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, witnessed_);
          onChanged();
        } else {
          witnessedBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * BLE signals witnessed by this device.
       * </pre>
       *
       * <code>repeated .opencannabis.proximity.BluetoothBeacon witnessed = 7 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signals witnessed by this device."];</code>
       */
      public Builder clearWitnessed() {
        if (witnessedBuilder_ == null) {
          witnessed_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
        } else {
          witnessedBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * BLE signals witnessed by this device.
       * </pre>
       *
       * <code>repeated .opencannabis.proximity.BluetoothBeacon witnessed = 7 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signals witnessed by this device."];</code>
       */
      public Builder removeWitnessed(int index) {
        if (witnessedBuilder_ == null) {
          ensureWitnessedIsMutable();
          witnessed_.remove(index);
          onChanged();
        } else {
          witnessedBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * BLE signals witnessed by this device.
       * </pre>
       *
       * <code>repeated .opencannabis.proximity.BluetoothBeacon witnessed = 7 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signals witnessed by this device."];</code>
       */
      public io.opencannabis.schema.proximity.BluetoothBeacon.Builder getWitnessedBuilder(
          int index) {
        return getWitnessedFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * BLE signals witnessed by this device.
       * </pre>
       *
       * <code>repeated .opencannabis.proximity.BluetoothBeacon witnessed = 7 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signals witnessed by this device."];</code>
       */
      public io.opencannabis.schema.proximity.BluetoothBeaconOrBuilder getWitnessedOrBuilder(
          int index) {
        if (witnessedBuilder_ == null) {
          return witnessed_.get(index);  } else {
          return witnessedBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * BLE signals witnessed by this device.
       * </pre>
       *
       * <code>repeated .opencannabis.proximity.BluetoothBeacon witnessed = 7 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signals witnessed by this device."];</code>
       */
      public java.util.List<? extends io.opencannabis.schema.proximity.BluetoothBeaconOrBuilder> 
           getWitnessedOrBuilderList() {
        if (witnessedBuilder_ != null) {
          return witnessedBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(witnessed_);
        }
      }
      /**
       * <pre>
       * BLE signals witnessed by this device.
       * </pre>
       *
       * <code>repeated .opencannabis.proximity.BluetoothBeacon witnessed = 7 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signals witnessed by this device."];</code>
       */
      public io.opencannabis.schema.proximity.BluetoothBeacon.Builder addWitnessedBuilder() {
        return getWitnessedFieldBuilder().addBuilder(
            io.opencannabis.schema.proximity.BluetoothBeacon.getDefaultInstance());
      }
      /**
       * <pre>
       * BLE signals witnessed by this device.
       * </pre>
       *
       * <code>repeated .opencannabis.proximity.BluetoothBeacon witnessed = 7 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signals witnessed by this device."];</code>
       */
      public io.opencannabis.schema.proximity.BluetoothBeacon.Builder addWitnessedBuilder(
          int index) {
        return getWitnessedFieldBuilder().addBuilder(
            index, io.opencannabis.schema.proximity.BluetoothBeacon.getDefaultInstance());
      }
      /**
       * <pre>
       * BLE signals witnessed by this device.
       * </pre>
       *
       * <code>repeated .opencannabis.proximity.BluetoothBeacon witnessed = 7 [(.gen_bq_schema.ignore) = true, (.gen_bq_schema.description) = "BLE signals witnessed by this device."];</code>
       */
      public java.util.List<io.opencannabis.schema.proximity.BluetoothBeacon.Builder> 
           getWitnessedBuilderList() {
        return getWitnessedFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.opencannabis.schema.proximity.BluetoothBeacon, io.opencannabis.schema.proximity.BluetoothBeacon.Builder, io.opencannabis.schema.proximity.BluetoothBeaconOrBuilder> 
          getWitnessedFieldBuilder() {
        if (witnessedBuilder_ == null) {
          witnessedBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              io.opencannabis.schema.proximity.BluetoothBeacon, io.opencannabis.schema.proximity.BluetoothBeacon.Builder, io.opencannabis.schema.proximity.BluetoothBeaconOrBuilder>(
                  witnessed_,
                  ((bitField0_ & 0x00000010) == 0x00000010),
                  getParentForChildren(),
                  isClean());
          witnessed_ = null;
        }
        return witnessedBuilder_;
      }

      private io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen screen_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen, io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen.Builder, io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreenOrBuilder> screenBuilder_;
      /**
       * <pre>
       * Information about the device screen.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceScreen screen = 4 [(.gen_bq_schema.description) = "Information about the device screen."];</code>
       */
      public boolean hasScreen() {
        return screenBuilder_ != null || screen_ != null;
      }
      /**
       * <pre>
       * Information about the device screen.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceScreen screen = 4 [(.gen_bq_schema.description) = "Information about the device screen."];</code>
       */
      public io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen getScreen() {
        if (screenBuilder_ == null) {
          return screen_ == null ? io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen.getDefaultInstance() : screen_;
        } else {
          return screenBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Information about the device screen.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceScreen screen = 4 [(.gen_bq_schema.description) = "Information about the device screen."];</code>
       */
      public Builder setScreen(io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen value) {
        if (screenBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          screen_ = value;
          onChanged();
        } else {
          screenBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Information about the device screen.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceScreen screen = 4 [(.gen_bq_schema.description) = "Information about the device screen."];</code>
       */
      public Builder setScreen(
          io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen.Builder builderForValue) {
        if (screenBuilder_ == null) {
          screen_ = builderForValue.build();
          onChanged();
        } else {
          screenBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Information about the device screen.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceScreen screen = 4 [(.gen_bq_schema.description) = "Information about the device screen."];</code>
       */
      public Builder mergeScreen(io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen value) {
        if (screenBuilder_ == null) {
          if (screen_ != null) {
            screen_ =
              io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen.newBuilder(screen_).mergeFrom(value).buildPartial();
          } else {
            screen_ = value;
          }
          onChanged();
        } else {
          screenBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Information about the device screen.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceScreen screen = 4 [(.gen_bq_schema.description) = "Information about the device screen."];</code>
       */
      public Builder clearScreen() {
        if (screenBuilder_ == null) {
          screen_ = null;
          onChanged();
        } else {
          screen_ = null;
          screenBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Information about the device screen.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceScreen screen = 4 [(.gen_bq_schema.description) = "Information about the device screen."];</code>
       */
      public io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen.Builder getScreenBuilder() {
        
        onChanged();
        return getScreenFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Information about the device screen.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceScreen screen = 4 [(.gen_bq_schema.description) = "Information about the device screen."];</code>
       */
      public io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreenOrBuilder getScreenOrBuilder() {
        if (screenBuilder_ != null) {
          return screenBuilder_.getMessageOrBuilder();
        } else {
          return screen_ == null ?
              io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen.getDefaultInstance() : screen_;
        }
      }
      /**
       * <pre>
       * Information about the device screen.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.DeviceScreen screen = 4 [(.gen_bq_schema.description) = "Information about the device screen."];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen, io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen.Builder, io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreenOrBuilder> 
          getScreenFieldBuilder() {
        if (screenBuilder_ == null) {
          screenBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen, io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreen.Builder, io.bloombox.schema.telemetry.context.DeviceContext.DeviceScreenOrBuilder>(
                  getScreen(),
                  getParentForChildren(),
                  isClean());
          screen_ = null;
        }
        return screenBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.analytics.context.NativeDeviceContext)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.analytics.context.NativeDeviceContext)
    private static final io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext();
    }

    public static io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<NativeDeviceContext>
        PARSER = new com.google.protobuf.AbstractParser<NativeDeviceContext>() {
      public NativeDeviceContext parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new NativeDeviceContext(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<NativeDeviceContext> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<NativeDeviceContext> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.telemetry.context.DeviceContext.NativeDeviceContext getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_analytics_context_PixelSize_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_analytics_context_PixelSize_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_analytics_context_DeviceScreen_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_analytics_context_DeviceScreen_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_analytics_context_NativeDeviceContext_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_analytics_context_NativeDeviceContext_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n$analytics/context/NativeDevice.proto\022!" +
      "bloombox.schema.analytics.context\032\016bq_fi" +
      "eld.proto\032\023device/Device.proto\032\025structs/" +
      "Version.proto\032\032analytics/context/OS.prot" +
      "o\032#analytics/context/Application.proto\032\037" +
      "proximity/BluetoothBeacon.proto\"\223\001\n\tPixe" +
      "lSize\022A\n\005width\030\001 \001(\rB2\360?\001\212@,Specifies th" +
      "e width portion of a pixel size.\022C\n\006heig" +
      "ht\030\002 \001(\rB3\360?\001\212@-Specifies the height por" +
      "tion of a pixel size.\"\234\003\n\014DeviceScreen\022T" +
      "\n\006screen\030\001 \001(\0132,.bloombox.schema.analyti" +
      "cs.context.PixelSizeB\026\212@\023Size of the scr" +
      "een.\022X\n\010viewport\030\002 \001(\0132,.bloombox.schema" +
      ".analytics.context.PixelSizeB\030\212@\025Size of" +
      " the viewport.\022A\n\007density\030\003 \001(\rB0\212@-Spec" +
      "ifies the height portion of a pixel size" +
      ".\022\230\001\n\013orientation\030\004 \001(\01624.bloombox.schem" +
      "a.analytics.context.ScreenOrientationBM\212" +
      "@JSpecifies the orientation of the scree" +
      "n at the time an event was captured.\"\201\005\n" +
      "\023NativeDeviceContext\022Y\n\004type\030\001 \001(\0162\037.ope" +
      "ncannabis.device.DeviceTypeB*\360?\001\212@$Speci" +
      "fies the type of native device.\022k\n\004role\030" +
      "\002 \001(\0162-.bloombox.schema.analytics.contex" +
      "t.DeviceRoleB.\360?\001\212@(Specifies the role o" +
      "f the native device.\022e\n\002os\030\003 \001(\0132+.bloom" +
      "box.schema.analytics.context.DeviceOSB,\360" +
      "?\001\212@&Specifies the OS of the native devi" +
      "ce.\022h\n\006beacon\030\006 \001(\0132\'.opencannabis.proxi" +
      "mity.BluetoothBeaconB/\200@\001\212@)BLE signal b" +
      "roadcasting from this device.\022g\n\twitness" +
      "ed\030\007 \003(\0132\'.opencannabis.proximity.Blueto" +
      "othBeaconB+\200@\001\212@%BLE signals witnessed b" +
      "y this device.\022h\n\006screen\030\004 \001(\0132/.bloombo" +
      "x.schema.analytics.context.DeviceScreenB" +
      "\'\212@$Information about the device screen." +
      "*$\n\nDeviceRole\022\n\n\006CLIENT\020\000\022\n\n\006SERVER\020\001*M" +
      "\n\021ScreenOrientation\022\033\n\027UNSPECIFIED_ORIEN" +
      "TATION\020\000\022\014\n\010PORTRAIT\020\001\022\r\n\tLANDSCAPE\020\002B?\n" +
      "$io.bloombox.schema.telemetry.contextB\rD" +
      "eviceContextH\001P\000\242\002\003BBSb\006proto3"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          gen_bq_schema.BqField.getDescriptor(),
          io.opencannabis.schema.device.DeviceOuterClass.getDescriptor(),
          io.opencannabis.schema.struct.Version.getDescriptor(),
          io.bloombox.schema.telemetry.context.OperatingSystemContext.getDescriptor(),
          io.bloombox.schema.telemetry.context.ApplicationContext.getDescriptor(),
          io.opencannabis.schema.proximity.BluetoothBeaconOuterClass.getDescriptor(),
        }, assigner);
    internal_static_bloombox_schema_analytics_context_PixelSize_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_bloombox_schema_analytics_context_PixelSize_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_analytics_context_PixelSize_descriptor,
        new java.lang.String[] { "Width", "Height", });
    internal_static_bloombox_schema_analytics_context_DeviceScreen_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_bloombox_schema_analytics_context_DeviceScreen_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_analytics_context_DeviceScreen_descriptor,
        new java.lang.String[] { "Screen", "Viewport", "Density", "Orientation", });
    internal_static_bloombox_schema_analytics_context_NativeDeviceContext_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_bloombox_schema_analytics_context_NativeDeviceContext_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_analytics_context_NativeDeviceContext_descriptor,
        new java.lang.String[] { "Type", "Role", "Os", "Beacon", "Witnessed", "Screen", });
    com.google.protobuf.ExtensionRegistry registry =
        com.google.protobuf.ExtensionRegistry.newInstance();
    registry.add(gen_bq_schema.BqField.description);
    registry.add(gen_bq_schema.BqField.ignore);
    registry.add(gen_bq_schema.BqField.require);
    com.google.protobuf.Descriptors.FileDescriptor
        .internalUpdateFileDescriptor(descriptor, registry);
    gen_bq_schema.BqField.getDescriptor();
    io.opencannabis.schema.device.DeviceOuterClass.getDescriptor();
    io.opencannabis.schema.struct.Version.getDescriptor();
    io.bloombox.schema.telemetry.context.OperatingSystemContext.getDescriptor();
    io.bloombox.schema.telemetry.context.ApplicationContext.getDescriptor();
    io.opencannabis.schema.proximity.BluetoothBeaconOuterClass.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
