/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: analytics/context/Library.proto

package io.bloombox.schema.telemetry.context;

public final class LibraryContext {
  private LibraryContext() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   * <pre>
   * Specifies known API client libraries, produced internally by Bloombox.
   * </pre>
   *
   * Protobuf enum {@code bloombox.schema.analytics.context.APIClient}
   */
  public enum APIClient
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * The underlying library specified no known API client library.
     * </pre>
     *
     * <code>UNIDENTIFIED = 0;</code>
     */
    UNIDENTIFIED(0),
    /**
     * <pre>
     * The underlying library is the official Bloombox JS Client.
     * </pre>
     *
     * <code>JAVA_SCRIPT = 1;</code>
     */
    JAVA_SCRIPT(1),
    /**
     * <pre>
     * The underlying library is the official Bloombox Swift Client.
     * </pre>
     *
     * <code>SWIFT = 2;</code>
     */
    SWIFT(2),
    /**
     * <pre>
     * The underlying library is the official Bloombox Java Client.
     * </pre>
     *
     * <code>JAVA = 3;</code>
     */
    JAVA(3),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * The underlying library specified no known API client library.
     * </pre>
     *
     * <code>UNIDENTIFIED = 0;</code>
     */
    public static final int UNIDENTIFIED_VALUE = 0;
    /**
     * <pre>
     * The underlying library is the official Bloombox JS Client.
     * </pre>
     *
     * <code>JAVA_SCRIPT = 1;</code>
     */
    public static final int JAVA_SCRIPT_VALUE = 1;
    /**
     * <pre>
     * The underlying library is the official Bloombox Swift Client.
     * </pre>
     *
     * <code>SWIFT = 2;</code>
     */
    public static final int SWIFT_VALUE = 2;
    /**
     * <pre>
     * The underlying library is the official Bloombox Java Client.
     * </pre>
     *
     * <code>JAVA = 3;</code>
     */
    public static final int JAVA_VALUE = 3;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static APIClient valueOf(int value) {
      return forNumber(value);
    }

    public static APIClient forNumber(int value) {
      switch (value) {
        case 0: return UNIDENTIFIED;
        case 1: return JAVA_SCRIPT;
        case 2: return SWIFT;
        case 3: return JAVA;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<APIClient>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        APIClient> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<APIClient>() {
            public APIClient findValueByNumber(int number) {
              return APIClient.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.bloombox.schema.telemetry.context.LibraryContext.getDescriptor().getEnumTypes().get(0);
    }

    private static final APIClient[] VALUES = values();

    public static APIClient valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private APIClient(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:bloombox.schema.analytics.context.APIClient)
  }

  public interface DeviceLibraryOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.analytics.context.DeviceLibrary)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Variant name of the library being used to transmit data.
     * </pre>
     *
     * <code>string variant = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Variant name of the library being used to transmit data."];</code>
     */
    java.lang.String getVariant();
    /**
     * <pre>
     * Variant name of the library being used to transmit data.
     * </pre>
     *
     * <code>string variant = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Variant name of the library being used to transmit data."];</code>
     */
    com.google.protobuf.ByteString
        getVariantBytes();

    /**
     * <pre>
     * Version specification for the library being used to transmit data.
     * </pre>
     *
     * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Version specification for the library being used to transmit data."];</code>
     */
    boolean hasVersion();
    /**
     * <pre>
     * Version specification for the library being used to transmit data.
     * </pre>
     *
     * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Version specification for the library being used to transmit data."];</code>
     */
    io.opencannabis.schema.struct.VersionSpec getVersion();
    /**
     * <pre>
     * Version specification for the library being used to transmit data.
     * </pre>
     *
     * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Version specification for the library being used to transmit data."];</code>
     */
    io.opencannabis.schema.struct.VersionSpecOrBuilder getVersionOrBuilder();

    /**
     * <pre>
     * Specifies, if applicable, the internally-produced client library in use.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.APIClient client = 3 [(.gen_bq_schema.description) = "Specifies which internal Bloombox library sent this event, if any."];</code>
     */
    int getClientValue();
    /**
     * <pre>
     * Specifies, if applicable, the internally-produced client library in use.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.APIClient client = 3 [(.gen_bq_schema.description) = "Specifies which internal Bloombox library sent this event, if any."];</code>
     */
    io.bloombox.schema.telemetry.context.LibraryContext.APIClient getClient();
  }
  /**
   * <pre>
   * Specifies information about the library being used to transmit data.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.analytics.context.DeviceLibrary}
   */
  public  static final class DeviceLibrary extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.analytics.context.DeviceLibrary)
      DeviceLibraryOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use DeviceLibrary.newBuilder() to construct.
    private DeviceLibrary(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private DeviceLibrary() {
      variant_ = "";
      client_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private DeviceLibrary(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              variant_ = s;
              break;
            }
            case 18: {
              io.opencannabis.schema.struct.VersionSpec.Builder subBuilder = null;
              if (version_ != null) {
                subBuilder = version_.toBuilder();
              }
              version_ = input.readMessage(io.opencannabis.schema.struct.VersionSpec.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(version_);
                version_ = subBuilder.buildPartial();
              }

              break;
            }
            case 24: {
              int rawValue = input.readEnum();

              client_ = rawValue;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.telemetry.context.LibraryContext.internal_static_bloombox_schema_analytics_context_DeviceLibrary_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.telemetry.context.LibraryContext.internal_static_bloombox_schema_analytics_context_DeviceLibrary_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary.class, io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary.Builder.class);
    }

    public static final int VARIANT_FIELD_NUMBER = 1;
    private volatile java.lang.Object variant_;
    /**
     * <pre>
     * Variant name of the library being used to transmit data.
     * </pre>
     *
     * <code>string variant = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Variant name of the library being used to transmit data."];</code>
     */
    public java.lang.String getVariant() {
      java.lang.Object ref = variant_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        variant_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Variant name of the library being used to transmit data.
     * </pre>
     *
     * <code>string variant = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Variant name of the library being used to transmit data."];</code>
     */
    public com.google.protobuf.ByteString
        getVariantBytes() {
      java.lang.Object ref = variant_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        variant_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VERSION_FIELD_NUMBER = 2;
    private io.opencannabis.schema.struct.VersionSpec version_;
    /**
     * <pre>
     * Version specification for the library being used to transmit data.
     * </pre>
     *
     * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Version specification for the library being used to transmit data."];</code>
     */
    public boolean hasVersion() {
      return version_ != null;
    }
    /**
     * <pre>
     * Version specification for the library being used to transmit data.
     * </pre>
     *
     * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Version specification for the library being used to transmit data."];</code>
     */
    public io.opencannabis.schema.struct.VersionSpec getVersion() {
      return version_ == null ? io.opencannabis.schema.struct.VersionSpec.getDefaultInstance() : version_;
    }
    /**
     * <pre>
     * Version specification for the library being used to transmit data.
     * </pre>
     *
     * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Version specification for the library being used to transmit data."];</code>
     */
    public io.opencannabis.schema.struct.VersionSpecOrBuilder getVersionOrBuilder() {
      return getVersion();
    }

    public static final int CLIENT_FIELD_NUMBER = 3;
    private int client_;
    /**
     * <pre>
     * Specifies, if applicable, the internally-produced client library in use.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.APIClient client = 3 [(.gen_bq_schema.description) = "Specifies which internal Bloombox library sent this event, if any."];</code>
     */
    public int getClientValue() {
      return client_;
    }
    /**
     * <pre>
     * Specifies, if applicable, the internally-produced client library in use.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.APIClient client = 3 [(.gen_bq_schema.description) = "Specifies which internal Bloombox library sent this event, if any."];</code>
     */
    public io.bloombox.schema.telemetry.context.LibraryContext.APIClient getClient() {
      io.bloombox.schema.telemetry.context.LibraryContext.APIClient result = io.bloombox.schema.telemetry.context.LibraryContext.APIClient.valueOf(client_);
      return result == null ? io.bloombox.schema.telemetry.context.LibraryContext.APIClient.UNRECOGNIZED : result;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getVariantBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, variant_);
      }
      if (version_ != null) {
        output.writeMessage(2, getVersion());
      }
      if (client_ != io.bloombox.schema.telemetry.context.LibraryContext.APIClient.UNIDENTIFIED.getNumber()) {
        output.writeEnum(3, client_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getVariantBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, variant_);
      }
      if (version_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getVersion());
      }
      if (client_ != io.bloombox.schema.telemetry.context.LibraryContext.APIClient.UNIDENTIFIED.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(3, client_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary)) {
        return super.equals(obj);
      }
      io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary other = (io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary) obj;

      boolean result = true;
      result = result && getVariant()
          .equals(other.getVariant());
      result = result && (hasVersion() == other.hasVersion());
      if (hasVersion()) {
        result = result && getVersion()
            .equals(other.getVersion());
      }
      result = result && client_ == other.client_;
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + VARIANT_FIELD_NUMBER;
      hash = (53 * hash) + getVariant().hashCode();
      if (hasVersion()) {
        hash = (37 * hash) + VERSION_FIELD_NUMBER;
        hash = (53 * hash) + getVersion().hashCode();
      }
      hash = (37 * hash) + CLIENT_FIELD_NUMBER;
      hash = (53 * hash) + client_;
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies information about the library being used to transmit data.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.analytics.context.DeviceLibrary}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.analytics.context.DeviceLibrary)
        io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibraryOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.telemetry.context.LibraryContext.internal_static_bloombox_schema_analytics_context_DeviceLibrary_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.telemetry.context.LibraryContext.internal_static_bloombox_schema_analytics_context_DeviceLibrary_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary.class, io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary.Builder.class);
      }

      // Construct using io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        variant_ = "";

        if (versionBuilder_ == null) {
          version_ = null;
        } else {
          version_ = null;
          versionBuilder_ = null;
        }
        client_ = 0;

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.telemetry.context.LibraryContext.internal_static_bloombox_schema_analytics_context_DeviceLibrary_descriptor;
      }

      public io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary getDefaultInstanceForType() {
        return io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary.getDefaultInstance();
      }

      public io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary build() {
        io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary buildPartial() {
        io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary result = new io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary(this);
        result.variant_ = variant_;
        if (versionBuilder_ == null) {
          result.version_ = version_;
        } else {
          result.version_ = versionBuilder_.build();
        }
        result.client_ = client_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary) {
          return mergeFrom((io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary other) {
        if (other == io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary.getDefaultInstance()) return this;
        if (!other.getVariant().isEmpty()) {
          variant_ = other.variant_;
          onChanged();
        }
        if (other.hasVersion()) {
          mergeVersion(other.getVersion());
        }
        if (other.client_ != 0) {
          setClientValue(other.getClientValue());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object variant_ = "";
      /**
       * <pre>
       * Variant name of the library being used to transmit data.
       * </pre>
       *
       * <code>string variant = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Variant name of the library being used to transmit data."];</code>
       */
      public java.lang.String getVariant() {
        java.lang.Object ref = variant_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          variant_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Variant name of the library being used to transmit data.
       * </pre>
       *
       * <code>string variant = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Variant name of the library being used to transmit data."];</code>
       */
      public com.google.protobuf.ByteString
          getVariantBytes() {
        java.lang.Object ref = variant_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          variant_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Variant name of the library being used to transmit data.
       * </pre>
       *
       * <code>string variant = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Variant name of the library being used to transmit data."];</code>
       */
      public Builder setVariant(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        variant_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Variant name of the library being used to transmit data.
       * </pre>
       *
       * <code>string variant = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Variant name of the library being used to transmit data."];</code>
       */
      public Builder clearVariant() {
        
        variant_ = getDefaultInstance().getVariant();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Variant name of the library being used to transmit data.
       * </pre>
       *
       * <code>string variant = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Variant name of the library being used to transmit data."];</code>
       */
      public Builder setVariantBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        variant_ = value;
        onChanged();
        return this;
      }

      private io.opencannabis.schema.struct.VersionSpec version_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.struct.VersionSpec, io.opencannabis.schema.struct.VersionSpec.Builder, io.opencannabis.schema.struct.VersionSpecOrBuilder> versionBuilder_;
      /**
       * <pre>
       * Version specification for the library being used to transmit data.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Version specification for the library being used to transmit data."];</code>
       */
      public boolean hasVersion() {
        return versionBuilder_ != null || version_ != null;
      }
      /**
       * <pre>
       * Version specification for the library being used to transmit data.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Version specification for the library being used to transmit data."];</code>
       */
      public io.opencannabis.schema.struct.VersionSpec getVersion() {
        if (versionBuilder_ == null) {
          return version_ == null ? io.opencannabis.schema.struct.VersionSpec.getDefaultInstance() : version_;
        } else {
          return versionBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Version specification for the library being used to transmit data.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Version specification for the library being used to transmit data."];</code>
       */
      public Builder setVersion(io.opencannabis.schema.struct.VersionSpec value) {
        if (versionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          version_ = value;
          onChanged();
        } else {
          versionBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Version specification for the library being used to transmit data.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Version specification for the library being used to transmit data."];</code>
       */
      public Builder setVersion(
          io.opencannabis.schema.struct.VersionSpec.Builder builderForValue) {
        if (versionBuilder_ == null) {
          version_ = builderForValue.build();
          onChanged();
        } else {
          versionBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Version specification for the library being used to transmit data.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Version specification for the library being used to transmit data."];</code>
       */
      public Builder mergeVersion(io.opencannabis.schema.struct.VersionSpec value) {
        if (versionBuilder_ == null) {
          if (version_ != null) {
            version_ =
              io.opencannabis.schema.struct.VersionSpec.newBuilder(version_).mergeFrom(value).buildPartial();
          } else {
            version_ = value;
          }
          onChanged();
        } else {
          versionBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Version specification for the library being used to transmit data.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Version specification for the library being used to transmit data."];</code>
       */
      public Builder clearVersion() {
        if (versionBuilder_ == null) {
          version_ = null;
          onChanged();
        } else {
          version_ = null;
          versionBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Version specification for the library being used to transmit data.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Version specification for the library being used to transmit data."];</code>
       */
      public io.opencannabis.schema.struct.VersionSpec.Builder getVersionBuilder() {
        
        onChanged();
        return getVersionFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Version specification for the library being used to transmit data.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Version specification for the library being used to transmit data."];</code>
       */
      public io.opencannabis.schema.struct.VersionSpecOrBuilder getVersionOrBuilder() {
        if (versionBuilder_ != null) {
          return versionBuilder_.getMessageOrBuilder();
        } else {
          return version_ == null ?
              io.opencannabis.schema.struct.VersionSpec.getDefaultInstance() : version_;
        }
      }
      /**
       * <pre>
       * Version specification for the library being used to transmit data.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Version specification for the library being used to transmit data."];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.struct.VersionSpec, io.opencannabis.schema.struct.VersionSpec.Builder, io.opencannabis.schema.struct.VersionSpecOrBuilder> 
          getVersionFieldBuilder() {
        if (versionBuilder_ == null) {
          versionBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.struct.VersionSpec, io.opencannabis.schema.struct.VersionSpec.Builder, io.opencannabis.schema.struct.VersionSpecOrBuilder>(
                  getVersion(),
                  getParentForChildren(),
                  isClean());
          version_ = null;
        }
        return versionBuilder_;
      }

      private int client_ = 0;
      /**
       * <pre>
       * Specifies, if applicable, the internally-produced client library in use.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.APIClient client = 3 [(.gen_bq_schema.description) = "Specifies which internal Bloombox library sent this event, if any."];</code>
       */
      public int getClientValue() {
        return client_;
      }
      /**
       * <pre>
       * Specifies, if applicable, the internally-produced client library in use.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.APIClient client = 3 [(.gen_bq_schema.description) = "Specifies which internal Bloombox library sent this event, if any."];</code>
       */
      public Builder setClientValue(int value) {
        client_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies, if applicable, the internally-produced client library in use.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.APIClient client = 3 [(.gen_bq_schema.description) = "Specifies which internal Bloombox library sent this event, if any."];</code>
       */
      public io.bloombox.schema.telemetry.context.LibraryContext.APIClient getClient() {
        io.bloombox.schema.telemetry.context.LibraryContext.APIClient result = io.bloombox.schema.telemetry.context.LibraryContext.APIClient.valueOf(client_);
        return result == null ? io.bloombox.schema.telemetry.context.LibraryContext.APIClient.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Specifies, if applicable, the internally-produced client library in use.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.APIClient client = 3 [(.gen_bq_schema.description) = "Specifies which internal Bloombox library sent this event, if any."];</code>
       */
      public Builder setClient(io.bloombox.schema.telemetry.context.LibraryContext.APIClient value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        client_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies, if applicable, the internally-produced client library in use.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.APIClient client = 3 [(.gen_bq_schema.description) = "Specifies which internal Bloombox library sent this event, if any."];</code>
       */
      public Builder clearClient() {
        
        client_ = 0;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.analytics.context.DeviceLibrary)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.analytics.context.DeviceLibrary)
    private static final io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary();
    }

    public static io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DeviceLibrary>
        PARSER = new com.google.protobuf.AbstractParser<DeviceLibrary>() {
      public DeviceLibrary parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new DeviceLibrary(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<DeviceLibrary> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DeviceLibrary> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.telemetry.context.LibraryContext.DeviceLibrary getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_analytics_context_DeviceLibrary_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_analytics_context_DeviceLibrary_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\037analytics/context/Library.proto\022!bloom" +
      "box.schema.analytics.context\032\016bq_field.p" +
      "roto\032\025structs/Version.proto\"\344\002\n\rDeviceLi" +
      "brary\022O\n\007variant\030\001 \001(\tB>\360?\001\212@8Variant na" +
      "me of the library being used to transmit" +
      " data.\022|\n\007version\030\002 \001(\0132!.opencannabis.s" +
      "tructs.VersionSpecBH\360?\001\212@BVersion specif" +
      "ication for the library being used to tr" +
      "ansmit data.\022\203\001\n\006client\030\003 \001(\0162,.bloombox" +
      ".schema.analytics.context.APIClientBE\212@B" +
      "Specifies which internal Bloombox librar" +
      "y sent this event, if any.*C\n\tAPIClient\022" +
      "\020\n\014UNIDENTIFIED\020\000\022\017\n\013JAVA_SCRIPT\020\001\022\t\n\005SW" +
      "IFT\020\002\022\010\n\004JAVA\020\003B@\n$io.bloombox.schema.te" +
      "lemetry.contextB\016LibraryContextH\001P\000\242\002\003BB" +
      "Sb\006proto3"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          gen_bq_schema.BqField.getDescriptor(),
          io.opencannabis.schema.struct.Version.getDescriptor(),
        }, assigner);
    internal_static_bloombox_schema_analytics_context_DeviceLibrary_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_bloombox_schema_analytics_context_DeviceLibrary_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_analytics_context_DeviceLibrary_descriptor,
        new java.lang.String[] { "Variant", "Version", "Client", });
    com.google.protobuf.ExtensionRegistry registry =
        com.google.protobuf.ExtensionRegistry.newInstance();
    registry.add(gen_bq_schema.BqField.description);
    registry.add(gen_bq_schema.BqField.require);
    com.google.protobuf.Descriptors.FileDescriptor
        .internalUpdateFileDescriptor(descriptor, registry);
    gen_bq_schema.BqField.getDescriptor();
    io.opencannabis.schema.struct.Version.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
