/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: analytics/context/OS.proto

package io.bloombox.schema.telemetry.context;

public final class OperatingSystemContext {
  private OperatingSystemContext() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   * <pre>
   * Specifies a device context where code is running natively. This is most applicable to native mobile applications and
   * server applications.
   * </pre>
   *
   * Protobuf enum {@code bloombox.schema.analytics.context.OSType}
   */
  public enum OSType
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Specifies that the OS is unknown or not applicable in this circumstance.
     * </pre>
     *
     * <code>OS_UNKNOWN = 0;</code>
     */
    OS_UNKNOWN(0),
    /**
     * <pre>
     * Specifies that the OS is iOS on an iPhone, iPad or iPod.
     * </pre>
     *
     * <code>iOS = 100;</code>
     */
    iOS(100),
    /**
     * <pre>
     * Specifies that the OS is macOS on an Apple Mac desktop or laptop.
     * </pre>
     *
     * <code>macOS = 101;</code>
     */
    macOS(101),
    /**
     * <pre>
     * Specifies that the OS is tvOS on an Apple TV device.
     * </pre>
     *
     * <code>tvOS = 102;</code>
     */
    tvOS(102),
    /**
     * <pre>
     * Specifies that the OS is watchOS running on an Apple Watch.
     * </pre>
     *
     * <code>watchOS = 103;</code>
     */
    watchOS(103),
    /**
     * <pre>
     * Specifies that the OS is Android on a phone or tablet or other device.
     * </pre>
     *
     * <code>ANDROID = 200;</code>
     */
    ANDROID(200),
    /**
     * <pre>
     * Specifies that the OS is Android Wear on some embedded wearable device, like a watch or Google Glass.
     * </pre>
     *
     * <code>ANDROID_WEAR = 201;</code>
     */
    ANDROID_WEAR(201),
    /**
     * <pre>
     * Specifies that the OS is Windows on a desktop, laptop, or some other device.
     * </pre>
     *
     * <code>WINDOWS = 4;</code>
     */
    WINDOWS(4),
    /**
     * <pre>
     * Specifies that the OS is Windows, running on a mobile device of some kind.
     * </pre>
     *
     * <code>WINDOWS_PHONE = 5;</code>
     */
    WINDOWS_PHONE(5),
    /**
     * <pre>
     * Specifies that the OS is some form of Linux.
     * </pre>
     *
     * <code>LINUX = 6;</code>
     */
    LINUX(6),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * Specifies that the OS is unknown or not applicable in this circumstance.
     * </pre>
     *
     * <code>OS_UNKNOWN = 0;</code>
     */
    public static final int OS_UNKNOWN_VALUE = 0;
    /**
     * <pre>
     * Specifies that the OS is iOS on an iPhone, iPad or iPod.
     * </pre>
     *
     * <code>iOS = 100;</code>
     */
    public static final int iOS_VALUE = 100;
    /**
     * <pre>
     * Specifies that the OS is macOS on an Apple Mac desktop or laptop.
     * </pre>
     *
     * <code>macOS = 101;</code>
     */
    public static final int macOS_VALUE = 101;
    /**
     * <pre>
     * Specifies that the OS is tvOS on an Apple TV device.
     * </pre>
     *
     * <code>tvOS = 102;</code>
     */
    public static final int tvOS_VALUE = 102;
    /**
     * <pre>
     * Specifies that the OS is watchOS running on an Apple Watch.
     * </pre>
     *
     * <code>watchOS = 103;</code>
     */
    public static final int watchOS_VALUE = 103;
    /**
     * <pre>
     * Specifies that the OS is Android on a phone or tablet or other device.
     * </pre>
     *
     * <code>ANDROID = 200;</code>
     */
    public static final int ANDROID_VALUE = 200;
    /**
     * <pre>
     * Specifies that the OS is Android Wear on some embedded wearable device, like a watch or Google Glass.
     * </pre>
     *
     * <code>ANDROID_WEAR = 201;</code>
     */
    public static final int ANDROID_WEAR_VALUE = 201;
    /**
     * <pre>
     * Specifies that the OS is Windows on a desktop, laptop, or some other device.
     * </pre>
     *
     * <code>WINDOWS = 4;</code>
     */
    public static final int WINDOWS_VALUE = 4;
    /**
     * <pre>
     * Specifies that the OS is Windows, running on a mobile device of some kind.
     * </pre>
     *
     * <code>WINDOWS_PHONE = 5;</code>
     */
    public static final int WINDOWS_PHONE_VALUE = 5;
    /**
     * <pre>
     * Specifies that the OS is some form of Linux.
     * </pre>
     *
     * <code>LINUX = 6;</code>
     */
    public static final int LINUX_VALUE = 6;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static OSType valueOf(int value) {
      return forNumber(value);
    }

    public static OSType forNumber(int value) {
      switch (value) {
        case 0: return OS_UNKNOWN;
        case 100: return iOS;
        case 101: return macOS;
        case 102: return tvOS;
        case 103: return watchOS;
        case 200: return ANDROID;
        case 201: return ANDROID_WEAR;
        case 4: return WINDOWS;
        case 5: return WINDOWS_PHONE;
        case 6: return LINUX;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<OSType>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        OSType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<OSType>() {
            public OSType findValueByNumber(int number) {
              return OSType.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.bloombox.schema.telemetry.context.OperatingSystemContext.getDescriptor().getEnumTypes().get(0);
    }

    private static final OSType[] VALUES = values();

    public static OSType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private OSType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:bloombox.schema.analytics.context.OSType)
  }

  public interface DeviceOSOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.analytics.context.DeviceOS)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Type of Operating System being expressed or specified.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.OSType type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Type of Operating System being expressed or specified."];</code>
     */
    int getTypeValue();
    /**
     * <pre>
     * Type of Operating System being expressed or specified.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.OSType type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Type of Operating System being expressed or specified."];</code>
     */
    io.bloombox.schema.telemetry.context.OperatingSystemContext.OSType getType();

    /**
     * <pre>
     * Version of the OS running on the device.
     * </pre>
     *
     * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version of the OS running on the device."];</code>
     */
    boolean hasVersion();
    /**
     * <pre>
     * Version of the OS running on the device.
     * </pre>
     *
     * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version of the OS running on the device."];</code>
     */
    io.opencannabis.schema.struct.VersionSpec getVersion();
    /**
     * <pre>
     * Version of the OS running on the device.
     * </pre>
     *
     * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version of the OS running on the device."];</code>
     */
    io.opencannabis.schema.struct.VersionSpecOrBuilder getVersionOrBuilder();
  }
  /**
   * <pre>
   * Structure describing a device's operating system, including type and version.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.analytics.context.DeviceOS}
   */
  public  static final class DeviceOS extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.analytics.context.DeviceOS)
      DeviceOSOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use DeviceOS.newBuilder() to construct.
    private DeviceOS(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private DeviceOS() {
      type_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private DeviceOS(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();

              type_ = rawValue;
              break;
            }
            case 18: {
              io.opencannabis.schema.struct.VersionSpec.Builder subBuilder = null;
              if (version_ != null) {
                subBuilder = version_.toBuilder();
              }
              version_ = input.readMessage(io.opencannabis.schema.struct.VersionSpec.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(version_);
                version_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.telemetry.context.OperatingSystemContext.internal_static_bloombox_schema_analytics_context_DeviceOS_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.telemetry.context.OperatingSystemContext.internal_static_bloombox_schema_analytics_context_DeviceOS_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS.class, io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS.Builder.class);
    }

    public static final int TYPE_FIELD_NUMBER = 1;
    private int type_;
    /**
     * <pre>
     * Type of Operating System being expressed or specified.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.OSType type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Type of Operating System being expressed or specified."];</code>
     */
    public int getTypeValue() {
      return type_;
    }
    /**
     * <pre>
     * Type of Operating System being expressed or specified.
     * </pre>
     *
     * <code>.bloombox.schema.analytics.context.OSType type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Type of Operating System being expressed or specified."];</code>
     */
    public io.bloombox.schema.telemetry.context.OperatingSystemContext.OSType getType() {
      io.bloombox.schema.telemetry.context.OperatingSystemContext.OSType result = io.bloombox.schema.telemetry.context.OperatingSystemContext.OSType.valueOf(type_);
      return result == null ? io.bloombox.schema.telemetry.context.OperatingSystemContext.OSType.UNRECOGNIZED : result;
    }

    public static final int VERSION_FIELD_NUMBER = 2;
    private io.opencannabis.schema.struct.VersionSpec version_;
    /**
     * <pre>
     * Version of the OS running on the device.
     * </pre>
     *
     * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version of the OS running on the device."];</code>
     */
    public boolean hasVersion() {
      return version_ != null;
    }
    /**
     * <pre>
     * Version of the OS running on the device.
     * </pre>
     *
     * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version of the OS running on the device."];</code>
     */
    public io.opencannabis.schema.struct.VersionSpec getVersion() {
      return version_ == null ? io.opencannabis.schema.struct.VersionSpec.getDefaultInstance() : version_;
    }
    /**
     * <pre>
     * Version of the OS running on the device.
     * </pre>
     *
     * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version of the OS running on the device."];</code>
     */
    public io.opencannabis.schema.struct.VersionSpecOrBuilder getVersionOrBuilder() {
      return getVersion();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (type_ != io.bloombox.schema.telemetry.context.OperatingSystemContext.OSType.OS_UNKNOWN.getNumber()) {
        output.writeEnum(1, type_);
      }
      if (version_ != null) {
        output.writeMessage(2, getVersion());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (type_ != io.bloombox.schema.telemetry.context.OperatingSystemContext.OSType.OS_UNKNOWN.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, type_);
      }
      if (version_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getVersion());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS)) {
        return super.equals(obj);
      }
      io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS other = (io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS) obj;

      boolean result = true;
      result = result && type_ == other.type_;
      result = result && (hasVersion() == other.hasVersion());
      if (hasVersion()) {
        result = result && getVersion()
            .equals(other.getVersion());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      if (hasVersion()) {
        hash = (37 * hash) + VERSION_FIELD_NUMBER;
        hash = (53 * hash) + getVersion().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Structure describing a device's operating system, including type and version.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.analytics.context.DeviceOS}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.analytics.context.DeviceOS)
        io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOSOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.telemetry.context.OperatingSystemContext.internal_static_bloombox_schema_analytics_context_DeviceOS_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.telemetry.context.OperatingSystemContext.internal_static_bloombox_schema_analytics_context_DeviceOS_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS.class, io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS.Builder.class);
      }

      // Construct using io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        type_ = 0;

        if (versionBuilder_ == null) {
          version_ = null;
        } else {
          version_ = null;
          versionBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.telemetry.context.OperatingSystemContext.internal_static_bloombox_schema_analytics_context_DeviceOS_descriptor;
      }

      public io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS getDefaultInstanceForType() {
        return io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS.getDefaultInstance();
      }

      public io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS build() {
        io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS buildPartial() {
        io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS result = new io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS(this);
        result.type_ = type_;
        if (versionBuilder_ == null) {
          result.version_ = version_;
        } else {
          result.version_ = versionBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS) {
          return mergeFrom((io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS other) {
        if (other == io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS.getDefaultInstance()) return this;
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        if (other.hasVersion()) {
          mergeVersion(other.getVersion());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int type_ = 0;
      /**
       * <pre>
       * Type of Operating System being expressed or specified.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.OSType type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Type of Operating System being expressed or specified."];</code>
       */
      public int getTypeValue() {
        return type_;
      }
      /**
       * <pre>
       * Type of Operating System being expressed or specified.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.OSType type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Type of Operating System being expressed or specified."];</code>
       */
      public Builder setTypeValue(int value) {
        type_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Type of Operating System being expressed or specified.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.OSType type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Type of Operating System being expressed or specified."];</code>
       */
      public io.bloombox.schema.telemetry.context.OperatingSystemContext.OSType getType() {
        io.bloombox.schema.telemetry.context.OperatingSystemContext.OSType result = io.bloombox.schema.telemetry.context.OperatingSystemContext.OSType.valueOf(type_);
        return result == null ? io.bloombox.schema.telemetry.context.OperatingSystemContext.OSType.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Type of Operating System being expressed or specified.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.OSType type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Type of Operating System being expressed or specified."];</code>
       */
      public Builder setType(io.bloombox.schema.telemetry.context.OperatingSystemContext.OSType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Type of Operating System being expressed or specified.
       * </pre>
       *
       * <code>.bloombox.schema.analytics.context.OSType type = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Type of Operating System being expressed or specified."];</code>
       */
      public Builder clearType() {
        
        type_ = 0;
        onChanged();
        return this;
      }

      private io.opencannabis.schema.struct.VersionSpec version_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.struct.VersionSpec, io.opencannabis.schema.struct.VersionSpec.Builder, io.opencannabis.schema.struct.VersionSpecOrBuilder> versionBuilder_;
      /**
       * <pre>
       * Version of the OS running on the device.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version of the OS running on the device."];</code>
       */
      public boolean hasVersion() {
        return versionBuilder_ != null || version_ != null;
      }
      /**
       * <pre>
       * Version of the OS running on the device.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version of the OS running on the device."];</code>
       */
      public io.opencannabis.schema.struct.VersionSpec getVersion() {
        if (versionBuilder_ == null) {
          return version_ == null ? io.opencannabis.schema.struct.VersionSpec.getDefaultInstance() : version_;
        } else {
          return versionBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Version of the OS running on the device.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version of the OS running on the device."];</code>
       */
      public Builder setVersion(io.opencannabis.schema.struct.VersionSpec value) {
        if (versionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          version_ = value;
          onChanged();
        } else {
          versionBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Version of the OS running on the device.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version of the OS running on the device."];</code>
       */
      public Builder setVersion(
          io.opencannabis.schema.struct.VersionSpec.Builder builderForValue) {
        if (versionBuilder_ == null) {
          version_ = builderForValue.build();
          onChanged();
        } else {
          versionBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Version of the OS running on the device.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version of the OS running on the device."];</code>
       */
      public Builder mergeVersion(io.opencannabis.schema.struct.VersionSpec value) {
        if (versionBuilder_ == null) {
          if (version_ != null) {
            version_ =
              io.opencannabis.schema.struct.VersionSpec.newBuilder(version_).mergeFrom(value).buildPartial();
          } else {
            version_ = value;
          }
          onChanged();
        } else {
          versionBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Version of the OS running on the device.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version of the OS running on the device."];</code>
       */
      public Builder clearVersion() {
        if (versionBuilder_ == null) {
          version_ = null;
          onChanged();
        } else {
          version_ = null;
          versionBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Version of the OS running on the device.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version of the OS running on the device."];</code>
       */
      public io.opencannabis.schema.struct.VersionSpec.Builder getVersionBuilder() {
        
        onChanged();
        return getVersionFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Version of the OS running on the device.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version of the OS running on the device."];</code>
       */
      public io.opencannabis.schema.struct.VersionSpecOrBuilder getVersionOrBuilder() {
        if (versionBuilder_ != null) {
          return versionBuilder_.getMessageOrBuilder();
        } else {
          return version_ == null ?
              io.opencannabis.schema.struct.VersionSpec.getDefaultInstance() : version_;
        }
      }
      /**
       * <pre>
       * Version of the OS running on the device.
       * </pre>
       *
       * <code>.opencannabis.structs.VersionSpec version = 2 [(.gen_bq_schema.description) = "Version of the OS running on the device."];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.struct.VersionSpec, io.opencannabis.schema.struct.VersionSpec.Builder, io.opencannabis.schema.struct.VersionSpecOrBuilder> 
          getVersionFieldBuilder() {
        if (versionBuilder_ == null) {
          versionBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.struct.VersionSpec, io.opencannabis.schema.struct.VersionSpec.Builder, io.opencannabis.schema.struct.VersionSpecOrBuilder>(
                  getVersion(),
                  getParentForChildren(),
                  isClean());
          version_ = null;
        }
        return versionBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.analytics.context.DeviceOS)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.analytics.context.DeviceOS)
    private static final io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS();
    }

    public static io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DeviceOS>
        PARSER = new com.google.protobuf.AbstractParser<DeviceOS>() {
      public DeviceOS parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new DeviceOS(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<DeviceOS> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DeviceOS> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.telemetry.context.OperatingSystemContext.DeviceOS getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_analytics_context_DeviceOS_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_analytics_context_DeviceOS_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\032analytics/context/OS.proto\022!bloombox.s" +
      "chema.analytics.context\032\016bq_field.proto\032" +
      "\025structs/Version.proto\"\342\001\n\010DeviceOS\022u\n\004t" +
      "ype\030\001 \001(\0162).bloombox.schema.analytics.co" +
      "ntext.OSTypeB<\360?\001\212@6Type of Operating Sy" +
      "stem being expressed or specified.\022_\n\007ve" +
      "rsion\030\002 \001(\0132!.opencannabis.structs.Versi" +
      "onSpecB+\212@(Version of the OS running on " +
      "the device.*\217\001\n\006OSType\022\016\n\nOS_UNKNOWN\020\000\022\007" +
      "\n\003iOS\020d\022\t\n\005macOS\020e\022\010\n\004tvOS\020f\022\013\n\007watchOS\020" +
      "g\022\014\n\007ANDROID\020\310\001\022\021\n\014ANDROID_WEAR\020\311\001\022\013\n\007WI" +
      "NDOWS\020\004\022\021\n\rWINDOWS_PHONE\020\005\022\t\n\005LINUX\020\006BH\n" +
      "$io.bloombox.schema.telemetry.contextB\026O" +
      "peratingSystemContextH\001P\000\242\002\003BBSb\006proto3"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          gen_bq_schema.BqField.getDescriptor(),
          io.opencannabis.schema.struct.Version.getDescriptor(),
        }, assigner);
    internal_static_bloombox_schema_analytics_context_DeviceOS_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_bloombox_schema_analytics_context_DeviceOS_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_analytics_context_DeviceOS_descriptor,
        new java.lang.String[] { "Type", "Version", });
    com.google.protobuf.ExtensionRegistry registry =
        com.google.protobuf.ExtensionRegistry.newInstance();
    registry.add(gen_bq_schema.BqField.description);
    registry.add(gen_bq_schema.BqField.require);
    com.google.protobuf.Descriptors.FileDescriptor
        .internalUpdateFileDescriptor(descriptor, registry);
    gen_bq_schema.BqField.getDescriptor();
    io.opencannabis.schema.struct.Version.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
