/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: analytics/search/SearchProperty.proto

package io.bloombox.schema.telemetry.search;

public final class SearchAnalytics {
  private SearchAnalytics() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   * <pre>
   * Specifies digital properties that support fulltext search, for the purpose of enumerating where a search came from,
   * or was submitted from, during analytics processing.
   * </pre>
   *
   * Protobuf enum {@code bloombox.schema.analytics.search.SearchProperty}
   */
  public enum SearchProperty
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * The origin property was left unspecified or it was unrecognized.
     * </pre>
     *
     * <code>PROPERTY_UNSPECIFIED = 0;</code>
     */
    PROPERTY_UNSPECIFIED(0),
    /**
     * <pre>
     * The search was submitted via the web.
     * </pre>
     *
     * <code>WEB = 1;</code>
     */
    WEB(1),
    /**
     * <pre>
     * The search was submitted via a tablet menu system.
     * </pre>
     *
     * <code>TABLET = 2;</code>
     */
    TABLET(2),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * The origin property was left unspecified or it was unrecognized.
     * </pre>
     *
     * <code>PROPERTY_UNSPECIFIED = 0;</code>
     */
    public static final int PROPERTY_UNSPECIFIED_VALUE = 0;
    /**
     * <pre>
     * The search was submitted via the web.
     * </pre>
     *
     * <code>WEB = 1;</code>
     */
    public static final int WEB_VALUE = 1;
    /**
     * <pre>
     * The search was submitted via a tablet menu system.
     * </pre>
     *
     * <code>TABLET = 2;</code>
     */
    public static final int TABLET_VALUE = 2;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SearchProperty valueOf(int value) {
      return forNumber(value);
    }

    public static SearchProperty forNumber(int value) {
      switch (value) {
        case 0: return PROPERTY_UNSPECIFIED;
        case 1: return WEB;
        case 2: return TABLET;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SearchProperty>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        SearchProperty> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<SearchProperty>() {
            public SearchProperty findValueByNumber(int number) {
              return SearchProperty.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.bloombox.schema.telemetry.search.SearchAnalytics.getDescriptor().getEnumTypes().get(0);
    }

    private static final SearchProperty[] VALUES = values();

    public static SearchProperty valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SearchProperty(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:bloombox.schema.analytics.search.SearchProperty)
  }


  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n%analytics/search/SearchProperty.proto\022" +
      " bloombox.schema.analytics.search*?\n\016Sea" +
      "rchProperty\022\030\n\024PROPERTY_UNSPECIFIED\020\000\022\007\n" +
      "\003WEB\020\001\022\n\n\006TABLET\020\002B@\n#io.bloombox.schema" +
      ".telemetry.searchB\017SearchAnalyticsH\001P\000\242\002" +
      "\003BBSb\006proto3"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
        }, assigner);
  }

  // @@protoc_insertion_point(outer_class_scope)
}
