/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: analytics/stats/OrderStats.proto

package io.bloombox.schema.telemetry.stats;

public final class OrderTelemetry {
  private OrderTelemetry() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  public interface OrderStatsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.analytics.stats.OrderStats)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Original ID of the order.
     * </pre>
     *
     * <code>string oid = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "// Original ID of the order."];</code>
     */
    java.lang.String getOid();
    /**
     * <pre>
     * Original ID of the order.
     * </pre>
     *
     * <code>string oid = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "// Original ID of the order."];</code>
     */
    com.google.protobuf.ByteString
        getOidBytes();

    /**
     * <pre>
     * Partner scope seen as associated with this commercial order.
     * </pre>
     *
     * <code>string partner_scope = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Partner scope seen as associated with this commercial order."];</code>
     */
    java.lang.String getPartnerScope();
    /**
     * <pre>
     * Partner scope seen as associated with this commercial order.
     * </pre>
     *
     * <code>string partner_scope = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Partner scope seen as associated with this commercial order."];</code>
     */
    com.google.protobuf.ByteString
        getPartnerScopeBytes();

    /**
     * <pre>
     * Timestamp representing when this order was submitted.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the first event seen in this session."];</code>
     */
    boolean hasOccurred();
    /**
     * <pre>
     * Timestamp representing when this order was submitted.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the first event seen in this session."];</code>
     */
    io.opencannabis.schema.temporal.Instant getOccurred();
    /**
     * <pre>
     * Timestamp representing when this order was submitted.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the first event seen in this session."];</code>
     */
    io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder();

    /**
     * <pre>
     * Count of unique products ordered (i.e. regardless of item 'count' per order).
     * </pre>
     *
     * <code>uint32 unique_item_count = 4 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Count of unique products ordered (i.e. regardless of item &#92;'count&#92;' per order)."];</code>
     */
    int getUniqueItemCount();

    /**
     * <pre>
     * Count of total products ordered (i.e. including item 'count' per order).
     * </pre>
     *
     * <code>uint32 total_item_count = 5 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Count of total products ordered (i.e. including item &#92;'count&#92;' per order)."];</code>
     */
    int getTotalItemCount();
  }
  /**
   * <pre>
   * Specifies a set of basic calculated statistics, computed at the level of an entire user session.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.analytics.stats.OrderStats}
   */
  public  static final class OrderStats extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.analytics.stats.OrderStats)
      OrderStatsOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use OrderStats.newBuilder() to construct.
    private OrderStats(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private OrderStats() {
      oid_ = "";
      partnerScope_ = "";
      uniqueItemCount_ = 0;
      totalItemCount_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private OrderStats(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              oid_ = s;
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();

              partnerScope_ = s;
              break;
            }
            case 26: {
              io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
              if (occurred_ != null) {
                subBuilder = occurred_.toBuilder();
              }
              occurred_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(occurred_);
                occurred_ = subBuilder.buildPartial();
              }

              break;
            }
            case 32: {

              uniqueItemCount_ = input.readUInt32();
              break;
            }
            case 40: {

              totalItemCount_ = input.readUInt32();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.telemetry.stats.OrderTelemetry.internal_static_bloombox_schema_analytics_stats_OrderStats_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.telemetry.stats.OrderTelemetry.internal_static_bloombox_schema_analytics_stats_OrderStats_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats.class, io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats.Builder.class);
    }

    public static final int OID_FIELD_NUMBER = 1;
    private volatile java.lang.Object oid_;
    /**
     * <pre>
     * Original ID of the order.
     * </pre>
     *
     * <code>string oid = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "// Original ID of the order."];</code>
     */
    public java.lang.String getOid() {
      java.lang.Object ref = oid_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        oid_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Original ID of the order.
     * </pre>
     *
     * <code>string oid = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "// Original ID of the order."];</code>
     */
    public com.google.protobuf.ByteString
        getOidBytes() {
      java.lang.Object ref = oid_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        oid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PARTNER_SCOPE_FIELD_NUMBER = 2;
    private volatile java.lang.Object partnerScope_;
    /**
     * <pre>
     * Partner scope seen as associated with this commercial order.
     * </pre>
     *
     * <code>string partner_scope = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Partner scope seen as associated with this commercial order."];</code>
     */
    public java.lang.String getPartnerScope() {
      java.lang.Object ref = partnerScope_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        partnerScope_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Partner scope seen as associated with this commercial order.
     * </pre>
     *
     * <code>string partner_scope = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Partner scope seen as associated with this commercial order."];</code>
     */
    public com.google.protobuf.ByteString
        getPartnerScopeBytes() {
      java.lang.Object ref = partnerScope_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        partnerScope_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int OCCURRED_FIELD_NUMBER = 3;
    private io.opencannabis.schema.temporal.Instant occurred_;
    /**
     * <pre>
     * Timestamp representing when this order was submitted.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the first event seen in this session."];</code>
     */
    public boolean hasOccurred() {
      return occurred_ != null;
    }
    /**
     * <pre>
     * Timestamp representing when this order was submitted.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the first event seen in this session."];</code>
     */
    public io.opencannabis.schema.temporal.Instant getOccurred() {
      return occurred_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
    }
    /**
     * <pre>
     * Timestamp representing when this order was submitted.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant occurred = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the first event seen in this session."];</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder() {
      return getOccurred();
    }

    public static final int UNIQUE_ITEM_COUNT_FIELD_NUMBER = 4;
    private int uniqueItemCount_;
    /**
     * <pre>
     * Count of unique products ordered (i.e. regardless of item 'count' per order).
     * </pre>
     *
     * <code>uint32 unique_item_count = 4 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Count of unique products ordered (i.e. regardless of item &#92;'count&#92;' per order)."];</code>
     */
    public int getUniqueItemCount() {
      return uniqueItemCount_;
    }

    public static final int TOTAL_ITEM_COUNT_FIELD_NUMBER = 5;
    private int totalItemCount_;
    /**
     * <pre>
     * Count of total products ordered (i.e. including item 'count' per order).
     * </pre>
     *
     * <code>uint32 total_item_count = 5 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Count of total products ordered (i.e. including item &#92;'count&#92;' per order)."];</code>
     */
    public int getTotalItemCount() {
      return totalItemCount_;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getOidBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, oid_);
      }
      if (!getPartnerScopeBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, partnerScope_);
      }
      if (occurred_ != null) {
        output.writeMessage(3, getOccurred());
      }
      if (uniqueItemCount_ != 0) {
        output.writeUInt32(4, uniqueItemCount_);
      }
      if (totalItemCount_ != 0) {
        output.writeUInt32(5, totalItemCount_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getOidBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, oid_);
      }
      if (!getPartnerScopeBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, partnerScope_);
      }
      if (occurred_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getOccurred());
      }
      if (uniqueItemCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(4, uniqueItemCount_);
      }
      if (totalItemCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(5, totalItemCount_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats)) {
        return super.equals(obj);
      }
      io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats other = (io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats) obj;

      boolean result = true;
      result = result && getOid()
          .equals(other.getOid());
      result = result && getPartnerScope()
          .equals(other.getPartnerScope());
      result = result && (hasOccurred() == other.hasOccurred());
      if (hasOccurred()) {
        result = result && getOccurred()
            .equals(other.getOccurred());
      }
      result = result && (getUniqueItemCount()
          == other.getUniqueItemCount());
      result = result && (getTotalItemCount()
          == other.getTotalItemCount());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + OID_FIELD_NUMBER;
      hash = (53 * hash) + getOid().hashCode();
      hash = (37 * hash) + PARTNER_SCOPE_FIELD_NUMBER;
      hash = (53 * hash) + getPartnerScope().hashCode();
      if (hasOccurred()) {
        hash = (37 * hash) + OCCURRED_FIELD_NUMBER;
        hash = (53 * hash) + getOccurred().hashCode();
      }
      hash = (37 * hash) + UNIQUE_ITEM_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getUniqueItemCount();
      hash = (37 * hash) + TOTAL_ITEM_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getTotalItemCount();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies a set of basic calculated statistics, computed at the level of an entire user session.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.analytics.stats.OrderStats}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.analytics.stats.OrderStats)
        io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStatsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.telemetry.stats.OrderTelemetry.internal_static_bloombox_schema_analytics_stats_OrderStats_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.telemetry.stats.OrderTelemetry.internal_static_bloombox_schema_analytics_stats_OrderStats_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats.class, io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats.Builder.class);
      }

      // Construct using io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        oid_ = "";

        partnerScope_ = "";

        if (occurredBuilder_ == null) {
          occurred_ = null;
        } else {
          occurred_ = null;
          occurredBuilder_ = null;
        }
        uniqueItemCount_ = 0;

        totalItemCount_ = 0;

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.telemetry.stats.OrderTelemetry.internal_static_bloombox_schema_analytics_stats_OrderStats_descriptor;
      }

      public io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats getDefaultInstanceForType() {
        return io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats.getDefaultInstance();
      }

      public io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats build() {
        io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats buildPartial() {
        io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats result = new io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats(this);
        result.oid_ = oid_;
        result.partnerScope_ = partnerScope_;
        if (occurredBuilder_ == null) {
          result.occurred_ = occurred_;
        } else {
          result.occurred_ = occurredBuilder_.build();
        }
        result.uniqueItemCount_ = uniqueItemCount_;
        result.totalItemCount_ = totalItemCount_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats) {
          return mergeFrom((io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats other) {
        if (other == io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats.getDefaultInstance()) return this;
        if (!other.getOid().isEmpty()) {
          oid_ = other.oid_;
          onChanged();
        }
        if (!other.getPartnerScope().isEmpty()) {
          partnerScope_ = other.partnerScope_;
          onChanged();
        }
        if (other.hasOccurred()) {
          mergeOccurred(other.getOccurred());
        }
        if (other.getUniqueItemCount() != 0) {
          setUniqueItemCount(other.getUniqueItemCount());
        }
        if (other.getTotalItemCount() != 0) {
          setTotalItemCount(other.getTotalItemCount());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object oid_ = "";
      /**
       * <pre>
       * Original ID of the order.
       * </pre>
       *
       * <code>string oid = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "// Original ID of the order."];</code>
       */
      public java.lang.String getOid() {
        java.lang.Object ref = oid_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          oid_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Original ID of the order.
       * </pre>
       *
       * <code>string oid = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "// Original ID of the order."];</code>
       */
      public com.google.protobuf.ByteString
          getOidBytes() {
        java.lang.Object ref = oid_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          oid_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Original ID of the order.
       * </pre>
       *
       * <code>string oid = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "// Original ID of the order."];</code>
       */
      public Builder setOid(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        oid_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Original ID of the order.
       * </pre>
       *
       * <code>string oid = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "// Original ID of the order."];</code>
       */
      public Builder clearOid() {
        
        oid_ = getDefaultInstance().getOid();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Original ID of the order.
       * </pre>
       *
       * <code>string oid = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "// Original ID of the order."];</code>
       */
      public Builder setOidBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        oid_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object partnerScope_ = "";
      /**
       * <pre>
       * Partner scope seen as associated with this commercial order.
       * </pre>
       *
       * <code>string partner_scope = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Partner scope seen as associated with this commercial order."];</code>
       */
      public java.lang.String getPartnerScope() {
        java.lang.Object ref = partnerScope_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          partnerScope_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Partner scope seen as associated with this commercial order.
       * </pre>
       *
       * <code>string partner_scope = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Partner scope seen as associated with this commercial order."];</code>
       */
      public com.google.protobuf.ByteString
          getPartnerScopeBytes() {
        java.lang.Object ref = partnerScope_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          partnerScope_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Partner scope seen as associated with this commercial order.
       * </pre>
       *
       * <code>string partner_scope = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Partner scope seen as associated with this commercial order."];</code>
       */
      public Builder setPartnerScope(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        partnerScope_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Partner scope seen as associated with this commercial order.
       * </pre>
       *
       * <code>string partner_scope = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Partner scope seen as associated with this commercial order."];</code>
       */
      public Builder clearPartnerScope() {
        
        partnerScope_ = getDefaultInstance().getPartnerScope();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Partner scope seen as associated with this commercial order.
       * </pre>
       *
       * <code>string partner_scope = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Partner scope seen as associated with this commercial order."];</code>
       */
      public Builder setPartnerScopeBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        partnerScope_ = value;
        onChanged();
        return this;
      }

      private io.opencannabis.schema.temporal.Instant occurred_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> occurredBuilder_;
      /**
       * <pre>
       * Timestamp representing when this order was submitted.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the first event seen in this session."];</code>
       */
      public boolean hasOccurred() {
        return occurredBuilder_ != null || occurred_ != null;
      }
      /**
       * <pre>
       * Timestamp representing when this order was submitted.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the first event seen in this session."];</code>
       */
      public io.opencannabis.schema.temporal.Instant getOccurred() {
        if (occurredBuilder_ == null) {
          return occurred_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
        } else {
          return occurredBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Timestamp representing when this order was submitted.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the first event seen in this session."];</code>
       */
      public Builder setOccurred(io.opencannabis.schema.temporal.Instant value) {
        if (occurredBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          occurred_ = value;
          onChanged();
        } else {
          occurredBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp representing when this order was submitted.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the first event seen in this session."];</code>
       */
      public Builder setOccurred(
          io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
        if (occurredBuilder_ == null) {
          occurred_ = builderForValue.build();
          onChanged();
        } else {
          occurredBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp representing when this order was submitted.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the first event seen in this session."];</code>
       */
      public Builder mergeOccurred(io.opencannabis.schema.temporal.Instant value) {
        if (occurredBuilder_ == null) {
          if (occurred_ != null) {
            occurred_ =
              io.opencannabis.schema.temporal.Instant.newBuilder(occurred_).mergeFrom(value).buildPartial();
          } else {
            occurred_ = value;
          }
          onChanged();
        } else {
          occurredBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp representing when this order was submitted.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the first event seen in this session."];</code>
       */
      public Builder clearOccurred() {
        if (occurredBuilder_ == null) {
          occurred_ = null;
          onChanged();
        } else {
          occurred_ = null;
          occurredBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp representing when this order was submitted.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the first event seen in this session."];</code>
       */
      public io.opencannabis.schema.temporal.Instant.Builder getOccurredBuilder() {
        
        onChanged();
        return getOccurredFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Timestamp representing when this order was submitted.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the first event seen in this session."];</code>
       */
      public io.opencannabis.schema.temporal.InstantOrBuilder getOccurredOrBuilder() {
        if (occurredBuilder_ != null) {
          return occurredBuilder_.getMessageOrBuilder();
        } else {
          return occurred_ == null ?
              io.opencannabis.schema.temporal.Instant.getDefaultInstance() : occurred_;
        }
      }
      /**
       * <pre>
       * Timestamp representing when this order was submitted.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant occurred = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the first event seen in this session."];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
          getOccurredFieldBuilder() {
        if (occurredBuilder_ == null) {
          occurredBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                  getOccurred(),
                  getParentForChildren(),
                  isClean());
          occurred_ = null;
        }
        return occurredBuilder_;
      }

      private int uniqueItemCount_ ;
      /**
       * <pre>
       * Count of unique products ordered (i.e. regardless of item 'count' per order).
       * </pre>
       *
       * <code>uint32 unique_item_count = 4 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Count of unique products ordered (i.e. regardless of item &#92;'count&#92;' per order)."];</code>
       */
      public int getUniqueItemCount() {
        return uniqueItemCount_;
      }
      /**
       * <pre>
       * Count of unique products ordered (i.e. regardless of item 'count' per order).
       * </pre>
       *
       * <code>uint32 unique_item_count = 4 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Count of unique products ordered (i.e. regardless of item &#92;'count&#92;' per order)."];</code>
       */
      public Builder setUniqueItemCount(int value) {
        
        uniqueItemCount_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Count of unique products ordered (i.e. regardless of item 'count' per order).
       * </pre>
       *
       * <code>uint32 unique_item_count = 4 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Count of unique products ordered (i.e. regardless of item &#92;'count&#92;' per order)."];</code>
       */
      public Builder clearUniqueItemCount() {
        
        uniqueItemCount_ = 0;
        onChanged();
        return this;
      }

      private int totalItemCount_ ;
      /**
       * <pre>
       * Count of total products ordered (i.e. including item 'count' per order).
       * </pre>
       *
       * <code>uint32 total_item_count = 5 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Count of total products ordered (i.e. including item &#92;'count&#92;' per order)."];</code>
       */
      public int getTotalItemCount() {
        return totalItemCount_;
      }
      /**
       * <pre>
       * Count of total products ordered (i.e. including item 'count' per order).
       * </pre>
       *
       * <code>uint32 total_item_count = 5 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Count of total products ordered (i.e. including item &#92;'count&#92;' per order)."];</code>
       */
      public Builder setTotalItemCount(int value) {
        
        totalItemCount_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Count of total products ordered (i.e. including item 'count' per order).
       * </pre>
       *
       * <code>uint32 total_item_count = 5 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Count of total products ordered (i.e. including item &#92;'count&#92;' per order)."];</code>
       */
      public Builder clearTotalItemCount() {
        
        totalItemCount_ = 0;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.analytics.stats.OrderStats)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.analytics.stats.OrderStats)
    private static final io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats();
    }

    public static io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<OrderStats>
        PARSER = new com.google.protobuf.AbstractParser<OrderStats>() {
      public OrderStats parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new OrderStats(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<OrderStats> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<OrderStats> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.telemetry.stats.OrderTelemetry.OrderStats getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_analytics_stats_OrderStats_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_analytics_stats_OrderStats_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n analytics/stats/OrderStats.proto\022\037bloo" +
      "mbox.schema.analytics.stats\032\016bq_field.pr" +
      "oto\032\026temporal/Instant.proto\"\350\003\n\nOrderSta" +
      "ts\022/\n\003oid\030\001 \001(\tB\"\360?\001\212@\034// Original ID of" +
      " the order.\022Y\n\rpartner_scope\030\002 \001(\tBB\360?\001\212" +
      "@<Partner scope seen as associated with " +
      "this commercial order.\022t\n\010occurred\030\003 \001(\013" +
      "2\036.opencannabis.temporal.InstantBB\360?\001\212@<" +
      "Timestamp representing the first event s" +
      "een in this session.\022n\n\021unique_item_coun" +
      "t\030\004 \001(\rBS\360?\001\212@MCount of unique products " +
      "ordered (i.e. regardless of item \'count\'" +
      " per order).\022h\n\020total_item_count\030\005 \001(\rBN" +
      "\360?\001\212@HCount of total products ordered (i" +
      ".e. including item \'count\' per order).B>" +
      "\n\"io.bloombox.schema.telemetry.statsB\016Or" +
      "derTelemetryH\001P\000\242\002\003BBSb\006proto3"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          gen_bq_schema.BqField.getDescriptor(),
          io.opencannabis.schema.temporal.InstantOuterClass.getDescriptor(),
        }, assigner);
    internal_static_bloombox_schema_analytics_stats_OrderStats_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_bloombox_schema_analytics_stats_OrderStats_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_analytics_stats_OrderStats_descriptor,
        new java.lang.String[] { "Oid", "PartnerScope", "Occurred", "UniqueItemCount", "TotalItemCount", });
    com.google.protobuf.ExtensionRegistry registry =
        com.google.protobuf.ExtensionRegistry.newInstance();
    registry.add(gen_bq_schema.BqField.description);
    registry.add(gen_bq_schema.BqField.require);
    com.google.protobuf.Descriptors.FileDescriptor
        .internalUpdateFileDescriptor(descriptor, registry);
    gen_bq_schema.BqField.getDescriptor();
    io.opencannabis.schema.temporal.InstantOuterClass.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
