/*
 * Copyright 2018, Bloombox, LLC. All rights reserved.
 *
 * Source and object computer code contained herein is the private intellectual
 * property of Bloombox, a California Limited Liability Corporation. Use of this
 * code in source form requires permission in writing before use or the
 * assembly, distribution, or publishing of derivative works, for commercial
 * purposes or any other purpose, from a duly authorized officer of Momentum
 * Ideas Co.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: analytics/stats/SessionStats.proto

package io.bloombox.schema.telemetry.stats;

public final class SessionTelemetry {
  private SessionTelemetry() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  public interface SessionStatsOrBuilder extends
      // @@protoc_insertion_point(interface_extends:bloombox.schema.analytics.stats.SessionStats)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Original ID of the session.
     * </pre>
     *
     * <code>string sid = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Original ID of the session."];</code>
     */
    java.lang.String getSid();
    /**
     * <pre>
     * Original ID of the session.
     * </pre>
     *
     * <code>string sid = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Original ID of the session."];</code>
     */
    com.google.protobuf.ByteString
        getSidBytes();

    /**
     * <pre>
     * Partner scope seen as associated with this session.
     * </pre>
     *
     * <code>string partner_scope = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Partner scope seen as associated with this session."];</code>
     */
    java.lang.String getPartnerScope();
    /**
     * <pre>
     * Partner scope seen as associated with this session.
     * </pre>
     *
     * <code>string partner_scope = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Partner scope seen as associated with this session."];</code>
     */
    com.google.protobuf.ByteString
        getPartnerScopeBytes();

    /**
     * <pre>
     * Count of total events seen in this session.
     * </pre>
     *
     * <code>uint32 event_count = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Count of total events seen in this session."];</code>
     */
    int getEventCount();

    /**
     * <pre>
     * Timestamp representing the first event seen in this session.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant begin = 4 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the first event seen in this session."];</code>
     */
    boolean hasBegin();
    /**
     * <pre>
     * Timestamp representing the first event seen in this session.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant begin = 4 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the first event seen in this session."];</code>
     */
    io.opencannabis.schema.temporal.Instant getBegin();
    /**
     * <pre>
     * Timestamp representing the first event seen in this session.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant begin = 4 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the first event seen in this session."];</code>
     */
    io.opencannabis.schema.temporal.InstantOrBuilder getBeginOrBuilder();

    /**
     * <pre>
     * Timestamp representing the last event seen in this session.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant end = 5 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the last event seen in this session."];</code>
     */
    boolean hasEnd();
    /**
     * <pre>
     * Timestamp representing the last event seen in this session.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant end = 5 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the last event seen in this session."];</code>
     */
    io.opencannabis.schema.temporal.Instant getEnd();
    /**
     * <pre>
     * Timestamp representing the last event seen in this session.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant end = 5 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the last event seen in this session."];</code>
     */
    io.opencannabis.schema.temporal.InstantOrBuilder getEndOrBuilder();

    /**
     * <pre>
     * Device ID seen as associated with this session.
     * </pre>
     *
     * <code>string device_id = 6 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Device ID seen as associated with this session."];</code>
     */
    java.lang.String getDeviceId();
    /**
     * <pre>
     * Device ID seen as associated with this session.
     * </pre>
     *
     * <code>string device_id = 6 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Device ID seen as associated with this session."];</code>
     */
    com.google.protobuf.ByteString
        getDeviceIdBytes();

    /**
     * <pre>
     * User ID seen as associated with this session.
     * </pre>
     *
     * <code>string user_id = 7 [(.gen_bq_schema.description) = "User ID seen as associated with this session."];</code>
     */
    java.lang.String getUserId();
    /**
     * <pre>
     * User ID seen as associated with this session.
     * </pre>
     *
     * <code>string user_id = 7 [(.gen_bq_schema.description) = "User ID seen as associated with this session."];</code>
     */
    com.google.protobuf.ByteString
        getUserIdBytes();
  }
  /**
   * <pre>
   * Specifies a set of basic calculated statistics, computed at the level of an entire user session.
   * </pre>
   *
   * Protobuf type {@code bloombox.schema.analytics.stats.SessionStats}
   */
  public  static final class SessionStats extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:bloombox.schema.analytics.stats.SessionStats)
      SessionStatsOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use SessionStats.newBuilder() to construct.
    private SessionStats(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private SessionStats() {
      sid_ = "";
      partnerScope_ = "";
      eventCount_ = 0;
      deviceId_ = "";
      userId_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private SessionStats(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              sid_ = s;
              break;
            }
            case 18: {
              java.lang.String s = input.readStringRequireUtf8();

              partnerScope_ = s;
              break;
            }
            case 24: {

              eventCount_ = input.readUInt32();
              break;
            }
            case 34: {
              io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
              if (begin_ != null) {
                subBuilder = begin_.toBuilder();
              }
              begin_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(begin_);
                begin_ = subBuilder.buildPartial();
              }

              break;
            }
            case 42: {
              io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
              if (end_ != null) {
                subBuilder = end_.toBuilder();
              }
              end_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(end_);
                end_ = subBuilder.buildPartial();
              }

              break;
            }
            case 50: {
              java.lang.String s = input.readStringRequireUtf8();

              deviceId_ = s;
              break;
            }
            case 58: {
              java.lang.String s = input.readStringRequireUtf8();

              userId_ = s;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.bloombox.schema.telemetry.stats.SessionTelemetry.internal_static_bloombox_schema_analytics_stats_SessionStats_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.bloombox.schema.telemetry.stats.SessionTelemetry.internal_static_bloombox_schema_analytics_stats_SessionStats_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats.class, io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats.Builder.class);
    }

    public static final int SID_FIELD_NUMBER = 1;
    private volatile java.lang.Object sid_;
    /**
     * <pre>
     * Original ID of the session.
     * </pre>
     *
     * <code>string sid = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Original ID of the session."];</code>
     */
    public java.lang.String getSid() {
      java.lang.Object ref = sid_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sid_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Original ID of the session.
     * </pre>
     *
     * <code>string sid = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Original ID of the session."];</code>
     */
    public com.google.protobuf.ByteString
        getSidBytes() {
      java.lang.Object ref = sid_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        sid_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PARTNER_SCOPE_FIELD_NUMBER = 2;
    private volatile java.lang.Object partnerScope_;
    /**
     * <pre>
     * Partner scope seen as associated with this session.
     * </pre>
     *
     * <code>string partner_scope = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Partner scope seen as associated with this session."];</code>
     */
    public java.lang.String getPartnerScope() {
      java.lang.Object ref = partnerScope_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        partnerScope_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Partner scope seen as associated with this session.
     * </pre>
     *
     * <code>string partner_scope = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Partner scope seen as associated with this session."];</code>
     */
    public com.google.protobuf.ByteString
        getPartnerScopeBytes() {
      java.lang.Object ref = partnerScope_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        partnerScope_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int EVENT_COUNT_FIELD_NUMBER = 3;
    private int eventCount_;
    /**
     * <pre>
     * Count of total events seen in this session.
     * </pre>
     *
     * <code>uint32 event_count = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Count of total events seen in this session."];</code>
     */
    public int getEventCount() {
      return eventCount_;
    }

    public static final int BEGIN_FIELD_NUMBER = 4;
    private io.opencannabis.schema.temporal.Instant begin_;
    /**
     * <pre>
     * Timestamp representing the first event seen in this session.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant begin = 4 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the first event seen in this session."];</code>
     */
    public boolean hasBegin() {
      return begin_ != null;
    }
    /**
     * <pre>
     * Timestamp representing the first event seen in this session.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant begin = 4 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the first event seen in this session."];</code>
     */
    public io.opencannabis.schema.temporal.Instant getBegin() {
      return begin_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : begin_;
    }
    /**
     * <pre>
     * Timestamp representing the first event seen in this session.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant begin = 4 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the first event seen in this session."];</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getBeginOrBuilder() {
      return getBegin();
    }

    public static final int END_FIELD_NUMBER = 5;
    private io.opencannabis.schema.temporal.Instant end_;
    /**
     * <pre>
     * Timestamp representing the last event seen in this session.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant end = 5 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the last event seen in this session."];</code>
     */
    public boolean hasEnd() {
      return end_ != null;
    }
    /**
     * <pre>
     * Timestamp representing the last event seen in this session.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant end = 5 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the last event seen in this session."];</code>
     */
    public io.opencannabis.schema.temporal.Instant getEnd() {
      return end_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : end_;
    }
    /**
     * <pre>
     * Timestamp representing the last event seen in this session.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant end = 5 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the last event seen in this session."];</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getEndOrBuilder() {
      return getEnd();
    }

    public static final int DEVICE_ID_FIELD_NUMBER = 6;
    private volatile java.lang.Object deviceId_;
    /**
     * <pre>
     * Device ID seen as associated with this session.
     * </pre>
     *
     * <code>string device_id = 6 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Device ID seen as associated with this session."];</code>
     */
    public java.lang.String getDeviceId() {
      java.lang.Object ref = deviceId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deviceId_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Device ID seen as associated with this session.
     * </pre>
     *
     * <code>string device_id = 6 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Device ID seen as associated with this session."];</code>
     */
    public com.google.protobuf.ByteString
        getDeviceIdBytes() {
      java.lang.Object ref = deviceId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        deviceId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int USER_ID_FIELD_NUMBER = 7;
    private volatile java.lang.Object userId_;
    /**
     * <pre>
     * User ID seen as associated with this session.
     * </pre>
     *
     * <code>string user_id = 7 [(.gen_bq_schema.description) = "User ID seen as associated with this session."];</code>
     */
    public java.lang.String getUserId() {
      java.lang.Object ref = userId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        userId_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * User ID seen as associated with this session.
     * </pre>
     *
     * <code>string user_id = 7 [(.gen_bq_schema.description) = "User ID seen as associated with this session."];</code>
     */
    public com.google.protobuf.ByteString
        getUserIdBytes() {
      java.lang.Object ref = userId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        userId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getSidBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, sid_);
      }
      if (!getPartnerScopeBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, partnerScope_);
      }
      if (eventCount_ != 0) {
        output.writeUInt32(3, eventCount_);
      }
      if (begin_ != null) {
        output.writeMessage(4, getBegin());
      }
      if (end_ != null) {
        output.writeMessage(5, getEnd());
      }
      if (!getDeviceIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, deviceId_);
      }
      if (!getUserIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 7, userId_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getSidBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, sid_);
      }
      if (!getPartnerScopeBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, partnerScope_);
      }
      if (eventCount_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(3, eventCount_);
      }
      if (begin_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, getBegin());
      }
      if (end_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, getEnd());
      }
      if (!getDeviceIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, deviceId_);
      }
      if (!getUserIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, userId_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats)) {
        return super.equals(obj);
      }
      io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats other = (io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats) obj;

      boolean result = true;
      result = result && getSid()
          .equals(other.getSid());
      result = result && getPartnerScope()
          .equals(other.getPartnerScope());
      result = result && (getEventCount()
          == other.getEventCount());
      result = result && (hasBegin() == other.hasBegin());
      if (hasBegin()) {
        result = result && getBegin()
            .equals(other.getBegin());
      }
      result = result && (hasEnd() == other.hasEnd());
      if (hasEnd()) {
        result = result && getEnd()
            .equals(other.getEnd());
      }
      result = result && getDeviceId()
          .equals(other.getDeviceId());
      result = result && getUserId()
          .equals(other.getUserId());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SID_FIELD_NUMBER;
      hash = (53 * hash) + getSid().hashCode();
      hash = (37 * hash) + PARTNER_SCOPE_FIELD_NUMBER;
      hash = (53 * hash) + getPartnerScope().hashCode();
      hash = (37 * hash) + EVENT_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getEventCount();
      if (hasBegin()) {
        hash = (37 * hash) + BEGIN_FIELD_NUMBER;
        hash = (53 * hash) + getBegin().hashCode();
      }
      if (hasEnd()) {
        hash = (37 * hash) + END_FIELD_NUMBER;
        hash = (53 * hash) + getEnd().hashCode();
      }
      hash = (37 * hash) + DEVICE_ID_FIELD_NUMBER;
      hash = (53 * hash) + getDeviceId().hashCode();
      hash = (37 * hash) + USER_ID_FIELD_NUMBER;
      hash = (53 * hash) + getUserId().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies a set of basic calculated statistics, computed at the level of an entire user session.
     * </pre>
     *
     * Protobuf type {@code bloombox.schema.analytics.stats.SessionStats}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:bloombox.schema.analytics.stats.SessionStats)
        io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStatsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.bloombox.schema.telemetry.stats.SessionTelemetry.internal_static_bloombox_schema_analytics_stats_SessionStats_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.bloombox.schema.telemetry.stats.SessionTelemetry.internal_static_bloombox_schema_analytics_stats_SessionStats_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats.class, io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats.Builder.class);
      }

      // Construct using io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        sid_ = "";

        partnerScope_ = "";

        eventCount_ = 0;

        if (beginBuilder_ == null) {
          begin_ = null;
        } else {
          begin_ = null;
          beginBuilder_ = null;
        }
        if (endBuilder_ == null) {
          end_ = null;
        } else {
          end_ = null;
          endBuilder_ = null;
        }
        deviceId_ = "";

        userId_ = "";

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.bloombox.schema.telemetry.stats.SessionTelemetry.internal_static_bloombox_schema_analytics_stats_SessionStats_descriptor;
      }

      public io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats getDefaultInstanceForType() {
        return io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats.getDefaultInstance();
      }

      public io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats build() {
        io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats buildPartial() {
        io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats result = new io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats(this);
        result.sid_ = sid_;
        result.partnerScope_ = partnerScope_;
        result.eventCount_ = eventCount_;
        if (beginBuilder_ == null) {
          result.begin_ = begin_;
        } else {
          result.begin_ = beginBuilder_.build();
        }
        if (endBuilder_ == null) {
          result.end_ = end_;
        } else {
          result.end_ = endBuilder_.build();
        }
        result.deviceId_ = deviceId_;
        result.userId_ = userId_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats) {
          return mergeFrom((io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats other) {
        if (other == io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats.getDefaultInstance()) return this;
        if (!other.getSid().isEmpty()) {
          sid_ = other.sid_;
          onChanged();
        }
        if (!other.getPartnerScope().isEmpty()) {
          partnerScope_ = other.partnerScope_;
          onChanged();
        }
        if (other.getEventCount() != 0) {
          setEventCount(other.getEventCount());
        }
        if (other.hasBegin()) {
          mergeBegin(other.getBegin());
        }
        if (other.hasEnd()) {
          mergeEnd(other.getEnd());
        }
        if (!other.getDeviceId().isEmpty()) {
          deviceId_ = other.deviceId_;
          onChanged();
        }
        if (!other.getUserId().isEmpty()) {
          userId_ = other.userId_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object sid_ = "";
      /**
       * <pre>
       * Original ID of the session.
       * </pre>
       *
       * <code>string sid = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Original ID of the session."];</code>
       */
      public java.lang.String getSid() {
        java.lang.Object ref = sid_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          sid_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Original ID of the session.
       * </pre>
       *
       * <code>string sid = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Original ID of the session."];</code>
       */
      public com.google.protobuf.ByteString
          getSidBytes() {
        java.lang.Object ref = sid_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          sid_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Original ID of the session.
       * </pre>
       *
       * <code>string sid = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Original ID of the session."];</code>
       */
      public Builder setSid(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        sid_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Original ID of the session.
       * </pre>
       *
       * <code>string sid = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Original ID of the session."];</code>
       */
      public Builder clearSid() {
        
        sid_ = getDefaultInstance().getSid();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Original ID of the session.
       * </pre>
       *
       * <code>string sid = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Original ID of the session."];</code>
       */
      public Builder setSidBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        sid_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object partnerScope_ = "";
      /**
       * <pre>
       * Partner scope seen as associated with this session.
       * </pre>
       *
       * <code>string partner_scope = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Partner scope seen as associated with this session."];</code>
       */
      public java.lang.String getPartnerScope() {
        java.lang.Object ref = partnerScope_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          partnerScope_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Partner scope seen as associated with this session.
       * </pre>
       *
       * <code>string partner_scope = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Partner scope seen as associated with this session."];</code>
       */
      public com.google.protobuf.ByteString
          getPartnerScopeBytes() {
        java.lang.Object ref = partnerScope_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          partnerScope_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Partner scope seen as associated with this session.
       * </pre>
       *
       * <code>string partner_scope = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Partner scope seen as associated with this session."];</code>
       */
      public Builder setPartnerScope(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        partnerScope_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Partner scope seen as associated with this session.
       * </pre>
       *
       * <code>string partner_scope = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Partner scope seen as associated with this session."];</code>
       */
      public Builder clearPartnerScope() {
        
        partnerScope_ = getDefaultInstance().getPartnerScope();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Partner scope seen as associated with this session.
       * </pre>
       *
       * <code>string partner_scope = 2 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Partner scope seen as associated with this session."];</code>
       */
      public Builder setPartnerScopeBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        partnerScope_ = value;
        onChanged();
        return this;
      }

      private int eventCount_ ;
      /**
       * <pre>
       * Count of total events seen in this session.
       * </pre>
       *
       * <code>uint32 event_count = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Count of total events seen in this session."];</code>
       */
      public int getEventCount() {
        return eventCount_;
      }
      /**
       * <pre>
       * Count of total events seen in this session.
       * </pre>
       *
       * <code>uint32 event_count = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Count of total events seen in this session."];</code>
       */
      public Builder setEventCount(int value) {
        
        eventCount_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Count of total events seen in this session.
       * </pre>
       *
       * <code>uint32 event_count = 3 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Count of total events seen in this session."];</code>
       */
      public Builder clearEventCount() {
        
        eventCount_ = 0;
        onChanged();
        return this;
      }

      private io.opencannabis.schema.temporal.Instant begin_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> beginBuilder_;
      /**
       * <pre>
       * Timestamp representing the first event seen in this session.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant begin = 4 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the first event seen in this session."];</code>
       */
      public boolean hasBegin() {
        return beginBuilder_ != null || begin_ != null;
      }
      /**
       * <pre>
       * Timestamp representing the first event seen in this session.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant begin = 4 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the first event seen in this session."];</code>
       */
      public io.opencannabis.schema.temporal.Instant getBegin() {
        if (beginBuilder_ == null) {
          return begin_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : begin_;
        } else {
          return beginBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Timestamp representing the first event seen in this session.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant begin = 4 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the first event seen in this session."];</code>
       */
      public Builder setBegin(io.opencannabis.schema.temporal.Instant value) {
        if (beginBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          begin_ = value;
          onChanged();
        } else {
          beginBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp representing the first event seen in this session.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant begin = 4 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the first event seen in this session."];</code>
       */
      public Builder setBegin(
          io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
        if (beginBuilder_ == null) {
          begin_ = builderForValue.build();
          onChanged();
        } else {
          beginBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp representing the first event seen in this session.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant begin = 4 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the first event seen in this session."];</code>
       */
      public Builder mergeBegin(io.opencannabis.schema.temporal.Instant value) {
        if (beginBuilder_ == null) {
          if (begin_ != null) {
            begin_ =
              io.opencannabis.schema.temporal.Instant.newBuilder(begin_).mergeFrom(value).buildPartial();
          } else {
            begin_ = value;
          }
          onChanged();
        } else {
          beginBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp representing the first event seen in this session.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant begin = 4 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the first event seen in this session."];</code>
       */
      public Builder clearBegin() {
        if (beginBuilder_ == null) {
          begin_ = null;
          onChanged();
        } else {
          begin_ = null;
          beginBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp representing the first event seen in this session.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant begin = 4 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the first event seen in this session."];</code>
       */
      public io.opencannabis.schema.temporal.Instant.Builder getBeginBuilder() {
        
        onChanged();
        return getBeginFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Timestamp representing the first event seen in this session.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant begin = 4 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the first event seen in this session."];</code>
       */
      public io.opencannabis.schema.temporal.InstantOrBuilder getBeginOrBuilder() {
        if (beginBuilder_ != null) {
          return beginBuilder_.getMessageOrBuilder();
        } else {
          return begin_ == null ?
              io.opencannabis.schema.temporal.Instant.getDefaultInstance() : begin_;
        }
      }
      /**
       * <pre>
       * Timestamp representing the first event seen in this session.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant begin = 4 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the first event seen in this session."];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
          getBeginFieldBuilder() {
        if (beginBuilder_ == null) {
          beginBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                  getBegin(),
                  getParentForChildren(),
                  isClean());
          begin_ = null;
        }
        return beginBuilder_;
      }

      private io.opencannabis.schema.temporal.Instant end_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> endBuilder_;
      /**
       * <pre>
       * Timestamp representing the last event seen in this session.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant end = 5 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the last event seen in this session."];</code>
       */
      public boolean hasEnd() {
        return endBuilder_ != null || end_ != null;
      }
      /**
       * <pre>
       * Timestamp representing the last event seen in this session.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant end = 5 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the last event seen in this session."];</code>
       */
      public io.opencannabis.schema.temporal.Instant getEnd() {
        if (endBuilder_ == null) {
          return end_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : end_;
        } else {
          return endBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Timestamp representing the last event seen in this session.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant end = 5 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the last event seen in this session."];</code>
       */
      public Builder setEnd(io.opencannabis.schema.temporal.Instant value) {
        if (endBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          end_ = value;
          onChanged();
        } else {
          endBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp representing the last event seen in this session.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant end = 5 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the last event seen in this session."];</code>
       */
      public Builder setEnd(
          io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
        if (endBuilder_ == null) {
          end_ = builderForValue.build();
          onChanged();
        } else {
          endBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp representing the last event seen in this session.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant end = 5 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the last event seen in this session."];</code>
       */
      public Builder mergeEnd(io.opencannabis.schema.temporal.Instant value) {
        if (endBuilder_ == null) {
          if (end_ != null) {
            end_ =
              io.opencannabis.schema.temporal.Instant.newBuilder(end_).mergeFrom(value).buildPartial();
          } else {
            end_ = value;
          }
          onChanged();
        } else {
          endBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp representing the last event seen in this session.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant end = 5 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the last event seen in this session."];</code>
       */
      public Builder clearEnd() {
        if (endBuilder_ == null) {
          end_ = null;
          onChanged();
        } else {
          end_ = null;
          endBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Timestamp representing the last event seen in this session.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant end = 5 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the last event seen in this session."];</code>
       */
      public io.opencannabis.schema.temporal.Instant.Builder getEndBuilder() {
        
        onChanged();
        return getEndFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Timestamp representing the last event seen in this session.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant end = 5 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the last event seen in this session."];</code>
       */
      public io.opencannabis.schema.temporal.InstantOrBuilder getEndOrBuilder() {
        if (endBuilder_ != null) {
          return endBuilder_.getMessageOrBuilder();
        } else {
          return end_ == null ?
              io.opencannabis.schema.temporal.Instant.getDefaultInstance() : end_;
        }
      }
      /**
       * <pre>
       * Timestamp representing the last event seen in this session.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant end = 5 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Timestamp representing the last event seen in this session."];</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
          getEndFieldBuilder() {
        if (endBuilder_ == null) {
          endBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                  getEnd(),
                  getParentForChildren(),
                  isClean());
          end_ = null;
        }
        return endBuilder_;
      }

      private java.lang.Object deviceId_ = "";
      /**
       * <pre>
       * Device ID seen as associated with this session.
       * </pre>
       *
       * <code>string device_id = 6 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Device ID seen as associated with this session."];</code>
       */
      public java.lang.String getDeviceId() {
        java.lang.Object ref = deviceId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          deviceId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Device ID seen as associated with this session.
       * </pre>
       *
       * <code>string device_id = 6 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Device ID seen as associated with this session."];</code>
       */
      public com.google.protobuf.ByteString
          getDeviceIdBytes() {
        java.lang.Object ref = deviceId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          deviceId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Device ID seen as associated with this session.
       * </pre>
       *
       * <code>string device_id = 6 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Device ID seen as associated with this session."];</code>
       */
      public Builder setDeviceId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        deviceId_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Device ID seen as associated with this session.
       * </pre>
       *
       * <code>string device_id = 6 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Device ID seen as associated with this session."];</code>
       */
      public Builder clearDeviceId() {
        
        deviceId_ = getDefaultInstance().getDeviceId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Device ID seen as associated with this session.
       * </pre>
       *
       * <code>string device_id = 6 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Device ID seen as associated with this session."];</code>
       */
      public Builder setDeviceIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        deviceId_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object userId_ = "";
      /**
       * <pre>
       * User ID seen as associated with this session.
       * </pre>
       *
       * <code>string user_id = 7 [(.gen_bq_schema.description) = "User ID seen as associated with this session."];</code>
       */
      public java.lang.String getUserId() {
        java.lang.Object ref = userId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          userId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * User ID seen as associated with this session.
       * </pre>
       *
       * <code>string user_id = 7 [(.gen_bq_schema.description) = "User ID seen as associated with this session."];</code>
       */
      public com.google.protobuf.ByteString
          getUserIdBytes() {
        java.lang.Object ref = userId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          userId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * User ID seen as associated with this session.
       * </pre>
       *
       * <code>string user_id = 7 [(.gen_bq_schema.description) = "User ID seen as associated with this session."];</code>
       */
      public Builder setUserId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        userId_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * User ID seen as associated with this session.
       * </pre>
       *
       * <code>string user_id = 7 [(.gen_bq_schema.description) = "User ID seen as associated with this session."];</code>
       */
      public Builder clearUserId() {
        
        userId_ = getDefaultInstance().getUserId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * User ID seen as associated with this session.
       * </pre>
       *
       * <code>string user_id = 7 [(.gen_bq_schema.description) = "User ID seen as associated with this session."];</code>
       */
      public Builder setUserIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        userId_ = value;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:bloombox.schema.analytics.stats.SessionStats)
    }

    // @@protoc_insertion_point(class_scope:bloombox.schema.analytics.stats.SessionStats)
    private static final io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats();
    }

    public static io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SessionStats>
        PARSER = new com.google.protobuf.AbstractParser<SessionStats>() {
      public SessionStats parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new SessionStats(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<SessionStats> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SessionStats> getParserForType() {
      return PARSER;
    }

    public io.bloombox.schema.telemetry.stats.SessionTelemetry.SessionStats getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_bloombox_schema_analytics_stats_SessionStats_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_bloombox_schema_analytics_stats_SessionStats_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\"analytics/stats/SessionStats.proto\022\037bl" +
      "oombox.schema.analytics.stats\032\016bq_field." +
      "proto\032\026temporal/Instant.proto\"\310\004\n\014Sessio" +
      "nStats\022.\n\003sid\030\001 \001(\tB!\360?\001\212@\033Original ID o" +
      "f the session.\022P\n\rpartner_scope\030\002 \001(\tB9\360" +
      "?\001\212@3Partner scope seen as associated wi" +
      "th this session.\022F\n\013event_count\030\003 \001(\rB1\360" +
      "?\001\212@+Count of total events seen in this " +
      "session.\022q\n\005begin\030\004 \001(\0132\036.opencannabis.t" +
      "emporal.InstantBB\360?\001\212@<Timestamp represe" +
      "nting the first event seen in this sessi" +
      "on.\022n\n\003end\030\005 \001(\0132\036.opencannabis.temporal" +
      ".InstantBA\360?\001\212@;Timestamp representing t" +
      "he last event seen in this session.\022H\n\td" +
      "evice_id\030\006 \001(\tB5\360?\001\212@/Device ID seen as " +
      "associated with this session.\022A\n\007user_id" +
      "\030\007 \001(\tB0\212@-User ID seen as associated wi" +
      "th this session.B@\n\"io.bloombox.schema.t" +
      "elemetry.statsB\020SessionTelemetryH\001P\000\242\002\003B" +
      "BSb\006proto3"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          gen_bq_schema.BqField.getDescriptor(),
          io.opencannabis.schema.temporal.InstantOuterClass.getDescriptor(),
        }, assigner);
    internal_static_bloombox_schema_analytics_stats_SessionStats_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_bloombox_schema_analytics_stats_SessionStats_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_bloombox_schema_analytics_stats_SessionStats_descriptor,
        new java.lang.String[] { "Sid", "PartnerScope", "EventCount", "Begin", "End", "DeviceId", "UserId", });
    com.google.protobuf.ExtensionRegistry registry =
        com.google.protobuf.ExtensionRegistry.newInstance();
    registry.add(gen_bq_schema.BqField.description);
    registry.add(gen_bq_schema.BqField.require);
    com.google.protobuf.Descriptors.FileDescriptor
        .internalUpdateFileDescriptor(descriptor, registry);
    gen_bq_schema.BqField.getDescriptor();
    io.opencannabis.schema.temporal.InstantOuterClass.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
