/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: accounting/Taxes.proto

package io.opencannabis.schema.accounting;

public final class AccountingTaxes {
  private AccountingTaxes() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   * <pre>
   * Enumerates the jurisdictions at which tax may be levied.
   * </pre>
   *
   * Protobuf enum {@code opencannabis.taxes.TaxJurisdictionMode}
   */
  public enum TaxJurisdictionMode
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * The tax is levied by a local municipality.
     * </pre>
     *
     * <code>LOCAL = 0;</code>
     */
    LOCAL(0),
    /**
     * <pre>
     * The tax is levied by a provincial jurisdiction.
     * </pre>
     *
     * <code>PROVINCE = 1;</code>
     */
    PROVINCE(1),
    /**
     * <pre>
     * The tax is levied by a national government.
     * </pre>
     *
     * <code>FEDERAL = 2;</code>
     */
    FEDERAL(2),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * The tax is levied by a local municipality.
     * </pre>
     *
     * <code>LOCAL = 0;</code>
     */
    public static final int LOCAL_VALUE = 0;
    /**
     * <pre>
     * The tax is levied by a provincial jurisdiction.
     * </pre>
     *
     * <code>PROVINCE = 1;</code>
     */
    public static final int PROVINCE_VALUE = 1;
    /**
     * <pre>
     * The tax is levied by a national government.
     * </pre>
     *
     * <code>FEDERAL = 2;</code>
     */
    public static final int FEDERAL_VALUE = 2;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TaxJurisdictionMode valueOf(int value) {
      return forNumber(value);
    }

    public static TaxJurisdictionMode forNumber(int value) {
      switch (value) {
        case 0: return LOCAL;
        case 1: return PROVINCE;
        case 2: return FEDERAL;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TaxJurisdictionMode>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        TaxJurisdictionMode> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<TaxJurisdictionMode>() {
            public TaxJurisdictionMode findValueByNumber(int number) {
              return TaxJurisdictionMode.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.opencannabis.schema.accounting.AccountingTaxes.getDescriptor().getEnumTypes().get(0);
    }

    private static final TaxJurisdictionMode[] VALUES = values();

    public static TaxJurisdictionMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TaxJurisdictionMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:opencannabis.taxes.TaxJurisdictionMode)
  }

  /**
   * <pre>
   * Enumerates the types of bases a tax may be calculated from.
   * </pre>
   *
   * Protobuf enum {@code opencannabis.taxes.TaxBasis}
   */
  public enum TaxBasis
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * The tax is calculated per-item.
     * </pre>
     *
     * <code>ITEM = 0;</code>
     */
    ITEM(0),
    /**
     * <pre>
     * The tax is calculated from the order subtotal.
     * </pre>
     *
     * <code>ORDER_SUBTOTAL = 1;</code>
     */
    ORDER_SUBTOTAL(1),
    /**
     * <pre>
     * The tax is calculated in a second phase, applied to the subtotal which includes other taxes.
     * </pre>
     *
     * <code>ORDER_TOTAL = 2;</code>
     */
    ORDER_TOTAL(2),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * The tax is calculated per-item.
     * </pre>
     *
     * <code>ITEM = 0;</code>
     */
    public static final int ITEM_VALUE = 0;
    /**
     * <pre>
     * The tax is calculated from the order subtotal.
     * </pre>
     *
     * <code>ORDER_SUBTOTAL = 1;</code>
     */
    public static final int ORDER_SUBTOTAL_VALUE = 1;
    /**
     * <pre>
     * The tax is calculated in a second phase, applied to the subtotal which includes other taxes.
     * </pre>
     *
     * <code>ORDER_TOTAL = 2;</code>
     */
    public static final int ORDER_TOTAL_VALUE = 2;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TaxBasis valueOf(int value) {
      return forNumber(value);
    }

    public static TaxBasis forNumber(int value) {
      switch (value) {
        case 0: return ITEM;
        case 1: return ORDER_SUBTOTAL;
        case 2: return ORDER_TOTAL;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TaxBasis>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        TaxBasis> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<TaxBasis>() {
            public TaxBasis findValueByNumber(int number) {
              return TaxBasis.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.opencannabis.schema.accounting.AccountingTaxes.getDescriptor().getEnumTypes().get(1);
    }

    private static final TaxBasis[] VALUES = values();

    public static TaxBasis valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TaxBasis(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:opencannabis.taxes.TaxBasis)
  }

  public interface LocalTaxOrBuilder extends
      // @@protoc_insertion_point(interface_extends:opencannabis.taxes.LocalTax)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Municipality imposing the tax.
     * </pre>
     *
     * <code>string municipality = 1;</code>
     */
    java.lang.String getMunicipality();
    /**
     * <pre>
     * Municipality imposing the tax.
     * </pre>
     *
     * <code>string municipality = 1;</code>
     */
    com.google.protobuf.ByteString
        getMunicipalityBytes();

    /**
     * <pre>
     * Province the municipality is in.
     * </pre>
     *
     * <code>.opencannabis.geo.Province province = 2;</code>
     */
    boolean hasProvince();
    /**
     * <pre>
     * Province the municipality is in.
     * </pre>
     *
     * <code>.opencannabis.geo.Province province = 2;</code>
     */
    io.opencannabis.schema.geo.Province getProvince();
    /**
     * <pre>
     * Province the municipality is in.
     * </pre>
     *
     * <code>.opencannabis.geo.Province province = 2;</code>
     */
    io.opencannabis.schema.geo.ProvinceOrBuilder getProvinceOrBuilder();

    /**
     * <pre>
     * Country the province is in.
     * </pre>
     *
     * <code>.opencannabis.geo.Country country = 3;</code>
     */
    boolean hasCountry();
    /**
     * <pre>
     * Country the province is in.
     * </pre>
     *
     * <code>.opencannabis.geo.Country country = 3;</code>
     */
    io.opencannabis.schema.geo.Country getCountry();
    /**
     * <pre>
     * Country the province is in.
     * </pre>
     *
     * <code>.opencannabis.geo.Country country = 3;</code>
     */
    io.opencannabis.schema.geo.CountryOrBuilder getCountryOrBuilder();
  }
  /**
   * <pre>
   * Specifies information about a municipally- or locally-imposed tax.
   * </pre>
   *
   * Protobuf type {@code opencannabis.taxes.LocalTax}
   */
  public  static final class LocalTax extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:opencannabis.taxes.LocalTax)
      LocalTaxOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use LocalTax.newBuilder() to construct.
    private LocalTax(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private LocalTax() {
      municipality_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private LocalTax(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              municipality_ = s;
              break;
            }
            case 18: {
              io.opencannabis.schema.geo.Province.Builder subBuilder = null;
              if (province_ != null) {
                subBuilder = province_.toBuilder();
              }
              province_ = input.readMessage(io.opencannabis.schema.geo.Province.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(province_);
                province_ = subBuilder.buildPartial();
              }

              break;
            }
            case 26: {
              io.opencannabis.schema.geo.Country.Builder subBuilder = null;
              if (country_ != null) {
                subBuilder = country_.toBuilder();
              }
              country_ = input.readMessage(io.opencannabis.schema.geo.Country.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(country_);
                country_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.accounting.AccountingTaxes.internal_static_opencannabis_taxes_LocalTax_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.accounting.AccountingTaxes.internal_static_opencannabis_taxes_LocalTax_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.accounting.AccountingTaxes.LocalTax.class, io.opencannabis.schema.accounting.AccountingTaxes.LocalTax.Builder.class);
    }

    public static final int MUNICIPALITY_FIELD_NUMBER = 1;
    private volatile java.lang.Object municipality_;
    /**
     * <pre>
     * Municipality imposing the tax.
     * </pre>
     *
     * <code>string municipality = 1;</code>
     */
    public java.lang.String getMunicipality() {
      java.lang.Object ref = municipality_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        municipality_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Municipality imposing the tax.
     * </pre>
     *
     * <code>string municipality = 1;</code>
     */
    public com.google.protobuf.ByteString
        getMunicipalityBytes() {
      java.lang.Object ref = municipality_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        municipality_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PROVINCE_FIELD_NUMBER = 2;
    private io.opencannabis.schema.geo.Province province_;
    /**
     * <pre>
     * Province the municipality is in.
     * </pre>
     *
     * <code>.opencannabis.geo.Province province = 2;</code>
     */
    public boolean hasProvince() {
      return province_ != null;
    }
    /**
     * <pre>
     * Province the municipality is in.
     * </pre>
     *
     * <code>.opencannabis.geo.Province province = 2;</code>
     */
    public io.opencannabis.schema.geo.Province getProvince() {
      return province_ == null ? io.opencannabis.schema.geo.Province.getDefaultInstance() : province_;
    }
    /**
     * <pre>
     * Province the municipality is in.
     * </pre>
     *
     * <code>.opencannabis.geo.Province province = 2;</code>
     */
    public io.opencannabis.schema.geo.ProvinceOrBuilder getProvinceOrBuilder() {
      return getProvince();
    }

    public static final int COUNTRY_FIELD_NUMBER = 3;
    private io.opencannabis.schema.geo.Country country_;
    /**
     * <pre>
     * Country the province is in.
     * </pre>
     *
     * <code>.opencannabis.geo.Country country = 3;</code>
     */
    public boolean hasCountry() {
      return country_ != null;
    }
    /**
     * <pre>
     * Country the province is in.
     * </pre>
     *
     * <code>.opencannabis.geo.Country country = 3;</code>
     */
    public io.opencannabis.schema.geo.Country getCountry() {
      return country_ == null ? io.opencannabis.schema.geo.Country.getDefaultInstance() : country_;
    }
    /**
     * <pre>
     * Country the province is in.
     * </pre>
     *
     * <code>.opencannabis.geo.Country country = 3;</code>
     */
    public io.opencannabis.schema.geo.CountryOrBuilder getCountryOrBuilder() {
      return getCountry();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getMunicipalityBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, municipality_);
      }
      if (province_ != null) {
        output.writeMessage(2, getProvince());
      }
      if (country_ != null) {
        output.writeMessage(3, getCountry());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getMunicipalityBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, municipality_);
      }
      if (province_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getProvince());
      }
      if (country_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getCountry());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.opencannabis.schema.accounting.AccountingTaxes.LocalTax)) {
        return super.equals(obj);
      }
      io.opencannabis.schema.accounting.AccountingTaxes.LocalTax other = (io.opencannabis.schema.accounting.AccountingTaxes.LocalTax) obj;

      boolean result = true;
      result = result && getMunicipality()
          .equals(other.getMunicipality());
      result = result && (hasProvince() == other.hasProvince());
      if (hasProvince()) {
        result = result && getProvince()
            .equals(other.getProvince());
      }
      result = result && (hasCountry() == other.hasCountry());
      if (hasCountry()) {
        result = result && getCountry()
            .equals(other.getCountry());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MUNICIPALITY_FIELD_NUMBER;
      hash = (53 * hash) + getMunicipality().hashCode();
      if (hasProvince()) {
        hash = (37 * hash) + PROVINCE_FIELD_NUMBER;
        hash = (53 * hash) + getProvince().hashCode();
      }
      if (hasCountry()) {
        hash = (37 * hash) + COUNTRY_FIELD_NUMBER;
        hash = (53 * hash) + getCountry().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.opencannabis.schema.accounting.AccountingTaxes.LocalTax parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.LocalTax parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.LocalTax parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.LocalTax parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.LocalTax parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.LocalTax parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.LocalTax parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.LocalTax parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.LocalTax parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.LocalTax parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.LocalTax parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.LocalTax parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.opencannabis.schema.accounting.AccountingTaxes.LocalTax prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies information about a municipally- or locally-imposed tax.
     * </pre>
     *
     * Protobuf type {@code opencannabis.taxes.LocalTax}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:opencannabis.taxes.LocalTax)
        io.opencannabis.schema.accounting.AccountingTaxes.LocalTaxOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.opencannabis.schema.accounting.AccountingTaxes.internal_static_opencannabis_taxes_LocalTax_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.opencannabis.schema.accounting.AccountingTaxes.internal_static_opencannabis_taxes_LocalTax_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.opencannabis.schema.accounting.AccountingTaxes.LocalTax.class, io.opencannabis.schema.accounting.AccountingTaxes.LocalTax.Builder.class);
      }

      // Construct using io.opencannabis.schema.accounting.AccountingTaxes.LocalTax.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        municipality_ = "";

        if (provinceBuilder_ == null) {
          province_ = null;
        } else {
          province_ = null;
          provinceBuilder_ = null;
        }
        if (countryBuilder_ == null) {
          country_ = null;
        } else {
          country_ = null;
          countryBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.opencannabis.schema.accounting.AccountingTaxes.internal_static_opencannabis_taxes_LocalTax_descriptor;
      }

      public io.opencannabis.schema.accounting.AccountingTaxes.LocalTax getDefaultInstanceForType() {
        return io.opencannabis.schema.accounting.AccountingTaxes.LocalTax.getDefaultInstance();
      }

      public io.opencannabis.schema.accounting.AccountingTaxes.LocalTax build() {
        io.opencannabis.schema.accounting.AccountingTaxes.LocalTax result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.opencannabis.schema.accounting.AccountingTaxes.LocalTax buildPartial() {
        io.opencannabis.schema.accounting.AccountingTaxes.LocalTax result = new io.opencannabis.schema.accounting.AccountingTaxes.LocalTax(this);
        result.municipality_ = municipality_;
        if (provinceBuilder_ == null) {
          result.province_ = province_;
        } else {
          result.province_ = provinceBuilder_.build();
        }
        if (countryBuilder_ == null) {
          result.country_ = country_;
        } else {
          result.country_ = countryBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.opencannabis.schema.accounting.AccountingTaxes.LocalTax) {
          return mergeFrom((io.opencannabis.schema.accounting.AccountingTaxes.LocalTax)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.opencannabis.schema.accounting.AccountingTaxes.LocalTax other) {
        if (other == io.opencannabis.schema.accounting.AccountingTaxes.LocalTax.getDefaultInstance()) return this;
        if (!other.getMunicipality().isEmpty()) {
          municipality_ = other.municipality_;
          onChanged();
        }
        if (other.hasProvince()) {
          mergeProvince(other.getProvince());
        }
        if (other.hasCountry()) {
          mergeCountry(other.getCountry());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.opencannabis.schema.accounting.AccountingTaxes.LocalTax parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.opencannabis.schema.accounting.AccountingTaxes.LocalTax) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object municipality_ = "";
      /**
       * <pre>
       * Municipality imposing the tax.
       * </pre>
       *
       * <code>string municipality = 1;</code>
       */
      public java.lang.String getMunicipality() {
        java.lang.Object ref = municipality_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          municipality_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Municipality imposing the tax.
       * </pre>
       *
       * <code>string municipality = 1;</code>
       */
      public com.google.protobuf.ByteString
          getMunicipalityBytes() {
        java.lang.Object ref = municipality_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          municipality_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Municipality imposing the tax.
       * </pre>
       *
       * <code>string municipality = 1;</code>
       */
      public Builder setMunicipality(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        municipality_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Municipality imposing the tax.
       * </pre>
       *
       * <code>string municipality = 1;</code>
       */
      public Builder clearMunicipality() {
        
        municipality_ = getDefaultInstance().getMunicipality();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Municipality imposing the tax.
       * </pre>
       *
       * <code>string municipality = 1;</code>
       */
      public Builder setMunicipalityBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        municipality_ = value;
        onChanged();
        return this;
      }

      private io.opencannabis.schema.geo.Province province_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.geo.Province, io.opencannabis.schema.geo.Province.Builder, io.opencannabis.schema.geo.ProvinceOrBuilder> provinceBuilder_;
      /**
       * <pre>
       * Province the municipality is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Province province = 2;</code>
       */
      public boolean hasProvince() {
        return provinceBuilder_ != null || province_ != null;
      }
      /**
       * <pre>
       * Province the municipality is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Province province = 2;</code>
       */
      public io.opencannabis.schema.geo.Province getProvince() {
        if (provinceBuilder_ == null) {
          return province_ == null ? io.opencannabis.schema.geo.Province.getDefaultInstance() : province_;
        } else {
          return provinceBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Province the municipality is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Province province = 2;</code>
       */
      public Builder setProvince(io.opencannabis.schema.geo.Province value) {
        if (provinceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          province_ = value;
          onChanged();
        } else {
          provinceBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Province the municipality is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Province province = 2;</code>
       */
      public Builder setProvince(
          io.opencannabis.schema.geo.Province.Builder builderForValue) {
        if (provinceBuilder_ == null) {
          province_ = builderForValue.build();
          onChanged();
        } else {
          provinceBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Province the municipality is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Province province = 2;</code>
       */
      public Builder mergeProvince(io.opencannabis.schema.geo.Province value) {
        if (provinceBuilder_ == null) {
          if (province_ != null) {
            province_ =
              io.opencannabis.schema.geo.Province.newBuilder(province_).mergeFrom(value).buildPartial();
          } else {
            province_ = value;
          }
          onChanged();
        } else {
          provinceBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Province the municipality is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Province province = 2;</code>
       */
      public Builder clearProvince() {
        if (provinceBuilder_ == null) {
          province_ = null;
          onChanged();
        } else {
          province_ = null;
          provinceBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Province the municipality is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Province province = 2;</code>
       */
      public io.opencannabis.schema.geo.Province.Builder getProvinceBuilder() {
        
        onChanged();
        return getProvinceFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Province the municipality is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Province province = 2;</code>
       */
      public io.opencannabis.schema.geo.ProvinceOrBuilder getProvinceOrBuilder() {
        if (provinceBuilder_ != null) {
          return provinceBuilder_.getMessageOrBuilder();
        } else {
          return province_ == null ?
              io.opencannabis.schema.geo.Province.getDefaultInstance() : province_;
        }
      }
      /**
       * <pre>
       * Province the municipality is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Province province = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.geo.Province, io.opencannabis.schema.geo.Province.Builder, io.opencannabis.schema.geo.ProvinceOrBuilder> 
          getProvinceFieldBuilder() {
        if (provinceBuilder_ == null) {
          provinceBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.geo.Province, io.opencannabis.schema.geo.Province.Builder, io.opencannabis.schema.geo.ProvinceOrBuilder>(
                  getProvince(),
                  getParentForChildren(),
                  isClean());
          province_ = null;
        }
        return provinceBuilder_;
      }

      private io.opencannabis.schema.geo.Country country_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.geo.Country, io.opencannabis.schema.geo.Country.Builder, io.opencannabis.schema.geo.CountryOrBuilder> countryBuilder_;
      /**
       * <pre>
       * Country the province is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Country country = 3;</code>
       */
      public boolean hasCountry() {
        return countryBuilder_ != null || country_ != null;
      }
      /**
       * <pre>
       * Country the province is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Country country = 3;</code>
       */
      public io.opencannabis.schema.geo.Country getCountry() {
        if (countryBuilder_ == null) {
          return country_ == null ? io.opencannabis.schema.geo.Country.getDefaultInstance() : country_;
        } else {
          return countryBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Country the province is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Country country = 3;</code>
       */
      public Builder setCountry(io.opencannabis.schema.geo.Country value) {
        if (countryBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          country_ = value;
          onChanged();
        } else {
          countryBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Country the province is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Country country = 3;</code>
       */
      public Builder setCountry(
          io.opencannabis.schema.geo.Country.Builder builderForValue) {
        if (countryBuilder_ == null) {
          country_ = builderForValue.build();
          onChanged();
        } else {
          countryBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Country the province is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Country country = 3;</code>
       */
      public Builder mergeCountry(io.opencannabis.schema.geo.Country value) {
        if (countryBuilder_ == null) {
          if (country_ != null) {
            country_ =
              io.opencannabis.schema.geo.Country.newBuilder(country_).mergeFrom(value).buildPartial();
          } else {
            country_ = value;
          }
          onChanged();
        } else {
          countryBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Country the province is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Country country = 3;</code>
       */
      public Builder clearCountry() {
        if (countryBuilder_ == null) {
          country_ = null;
          onChanged();
        } else {
          country_ = null;
          countryBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Country the province is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Country country = 3;</code>
       */
      public io.opencannabis.schema.geo.Country.Builder getCountryBuilder() {
        
        onChanged();
        return getCountryFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Country the province is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Country country = 3;</code>
       */
      public io.opencannabis.schema.geo.CountryOrBuilder getCountryOrBuilder() {
        if (countryBuilder_ != null) {
          return countryBuilder_.getMessageOrBuilder();
        } else {
          return country_ == null ?
              io.opencannabis.schema.geo.Country.getDefaultInstance() : country_;
        }
      }
      /**
       * <pre>
       * Country the province is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Country country = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.geo.Country, io.opencannabis.schema.geo.Country.Builder, io.opencannabis.schema.geo.CountryOrBuilder> 
          getCountryFieldBuilder() {
        if (countryBuilder_ == null) {
          countryBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.geo.Country, io.opencannabis.schema.geo.Country.Builder, io.opencannabis.schema.geo.CountryOrBuilder>(
                  getCountry(),
                  getParentForChildren(),
                  isClean());
          country_ = null;
        }
        return countryBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:opencannabis.taxes.LocalTax)
    }

    // @@protoc_insertion_point(class_scope:opencannabis.taxes.LocalTax)
    private static final io.opencannabis.schema.accounting.AccountingTaxes.LocalTax DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.opencannabis.schema.accounting.AccountingTaxes.LocalTax();
    }

    public static io.opencannabis.schema.accounting.AccountingTaxes.LocalTax getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<LocalTax>
        PARSER = new com.google.protobuf.AbstractParser<LocalTax>() {
      public LocalTax parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new LocalTax(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<LocalTax> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<LocalTax> getParserForType() {
      return PARSER;
    }

    public io.opencannabis.schema.accounting.AccountingTaxes.LocalTax getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ProvincialTaxOrBuilder extends
      // @@protoc_insertion_point(interface_extends:opencannabis.taxes.ProvincialTax)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Province the municipality is in.
     * </pre>
     *
     * <code>.opencannabis.geo.Province province = 1;</code>
     */
    boolean hasProvince();
    /**
     * <pre>
     * Province the municipality is in.
     * </pre>
     *
     * <code>.opencannabis.geo.Province province = 1;</code>
     */
    io.opencannabis.schema.geo.Province getProvince();
    /**
     * <pre>
     * Province the municipality is in.
     * </pre>
     *
     * <code>.opencannabis.geo.Province province = 1;</code>
     */
    io.opencannabis.schema.geo.ProvinceOrBuilder getProvinceOrBuilder();

    /**
     * <pre>
     * Country the province is in.
     * </pre>
     *
     * <code>.opencannabis.geo.Country country = 2;</code>
     */
    boolean hasCountry();
    /**
     * <pre>
     * Country the province is in.
     * </pre>
     *
     * <code>.opencannabis.geo.Country country = 2;</code>
     */
    io.opencannabis.schema.geo.Country getCountry();
    /**
     * <pre>
     * Country the province is in.
     * </pre>
     *
     * <code>.opencannabis.geo.Country country = 2;</code>
     */
    io.opencannabis.schema.geo.CountryOrBuilder getCountryOrBuilder();
  }
  /**
   * <pre>
   * Specifies information about a provincially-imposed tax.
   * </pre>
   *
   * Protobuf type {@code opencannabis.taxes.ProvincialTax}
   */
  public  static final class ProvincialTax extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:opencannabis.taxes.ProvincialTax)
      ProvincialTaxOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use ProvincialTax.newBuilder() to construct.
    private ProvincialTax(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private ProvincialTax() {
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private ProvincialTax(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              io.opencannabis.schema.geo.Province.Builder subBuilder = null;
              if (province_ != null) {
                subBuilder = province_.toBuilder();
              }
              province_ = input.readMessage(io.opencannabis.schema.geo.Province.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(province_);
                province_ = subBuilder.buildPartial();
              }

              break;
            }
            case 18: {
              io.opencannabis.schema.geo.Country.Builder subBuilder = null;
              if (country_ != null) {
                subBuilder = country_.toBuilder();
              }
              country_ = input.readMessage(io.opencannabis.schema.geo.Country.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(country_);
                country_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.accounting.AccountingTaxes.internal_static_opencannabis_taxes_ProvincialTax_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.accounting.AccountingTaxes.internal_static_opencannabis_taxes_ProvincialTax_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax.class, io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax.Builder.class);
    }

    public static final int PROVINCE_FIELD_NUMBER = 1;
    private io.opencannabis.schema.geo.Province province_;
    /**
     * <pre>
     * Province the municipality is in.
     * </pre>
     *
     * <code>.opencannabis.geo.Province province = 1;</code>
     */
    public boolean hasProvince() {
      return province_ != null;
    }
    /**
     * <pre>
     * Province the municipality is in.
     * </pre>
     *
     * <code>.opencannabis.geo.Province province = 1;</code>
     */
    public io.opencannabis.schema.geo.Province getProvince() {
      return province_ == null ? io.opencannabis.schema.geo.Province.getDefaultInstance() : province_;
    }
    /**
     * <pre>
     * Province the municipality is in.
     * </pre>
     *
     * <code>.opencannabis.geo.Province province = 1;</code>
     */
    public io.opencannabis.schema.geo.ProvinceOrBuilder getProvinceOrBuilder() {
      return getProvince();
    }

    public static final int COUNTRY_FIELD_NUMBER = 2;
    private io.opencannabis.schema.geo.Country country_;
    /**
     * <pre>
     * Country the province is in.
     * </pre>
     *
     * <code>.opencannabis.geo.Country country = 2;</code>
     */
    public boolean hasCountry() {
      return country_ != null;
    }
    /**
     * <pre>
     * Country the province is in.
     * </pre>
     *
     * <code>.opencannabis.geo.Country country = 2;</code>
     */
    public io.opencannabis.schema.geo.Country getCountry() {
      return country_ == null ? io.opencannabis.schema.geo.Country.getDefaultInstance() : country_;
    }
    /**
     * <pre>
     * Country the province is in.
     * </pre>
     *
     * <code>.opencannabis.geo.Country country = 2;</code>
     */
    public io.opencannabis.schema.geo.CountryOrBuilder getCountryOrBuilder() {
      return getCountry();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (province_ != null) {
        output.writeMessage(1, getProvince());
      }
      if (country_ != null) {
        output.writeMessage(2, getCountry());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (province_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getProvince());
      }
      if (country_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getCountry());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax)) {
        return super.equals(obj);
      }
      io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax other = (io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax) obj;

      boolean result = true;
      result = result && (hasProvince() == other.hasProvince());
      if (hasProvince()) {
        result = result && getProvince()
            .equals(other.getProvince());
      }
      result = result && (hasCountry() == other.hasCountry());
      if (hasCountry()) {
        result = result && getCountry()
            .equals(other.getCountry());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasProvince()) {
        hash = (37 * hash) + PROVINCE_FIELD_NUMBER;
        hash = (53 * hash) + getProvince().hashCode();
      }
      if (hasCountry()) {
        hash = (37 * hash) + COUNTRY_FIELD_NUMBER;
        hash = (53 * hash) + getCountry().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies information about a provincially-imposed tax.
     * </pre>
     *
     * Protobuf type {@code opencannabis.taxes.ProvincialTax}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:opencannabis.taxes.ProvincialTax)
        io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTaxOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.opencannabis.schema.accounting.AccountingTaxes.internal_static_opencannabis_taxes_ProvincialTax_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.opencannabis.schema.accounting.AccountingTaxes.internal_static_opencannabis_taxes_ProvincialTax_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax.class, io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax.Builder.class);
      }

      // Construct using io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        if (provinceBuilder_ == null) {
          province_ = null;
        } else {
          province_ = null;
          provinceBuilder_ = null;
        }
        if (countryBuilder_ == null) {
          country_ = null;
        } else {
          country_ = null;
          countryBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.opencannabis.schema.accounting.AccountingTaxes.internal_static_opencannabis_taxes_ProvincialTax_descriptor;
      }

      public io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax getDefaultInstanceForType() {
        return io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax.getDefaultInstance();
      }

      public io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax build() {
        io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax buildPartial() {
        io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax result = new io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax(this);
        if (provinceBuilder_ == null) {
          result.province_ = province_;
        } else {
          result.province_ = provinceBuilder_.build();
        }
        if (countryBuilder_ == null) {
          result.country_ = country_;
        } else {
          result.country_ = countryBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax) {
          return mergeFrom((io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax other) {
        if (other == io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax.getDefaultInstance()) return this;
        if (other.hasProvince()) {
          mergeProvince(other.getProvince());
        }
        if (other.hasCountry()) {
          mergeCountry(other.getCountry());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private io.opencannabis.schema.geo.Province province_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.geo.Province, io.opencannabis.schema.geo.Province.Builder, io.opencannabis.schema.geo.ProvinceOrBuilder> provinceBuilder_;
      /**
       * <pre>
       * Province the municipality is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Province province = 1;</code>
       */
      public boolean hasProvince() {
        return provinceBuilder_ != null || province_ != null;
      }
      /**
       * <pre>
       * Province the municipality is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Province province = 1;</code>
       */
      public io.opencannabis.schema.geo.Province getProvince() {
        if (provinceBuilder_ == null) {
          return province_ == null ? io.opencannabis.schema.geo.Province.getDefaultInstance() : province_;
        } else {
          return provinceBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Province the municipality is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Province province = 1;</code>
       */
      public Builder setProvince(io.opencannabis.schema.geo.Province value) {
        if (provinceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          province_ = value;
          onChanged();
        } else {
          provinceBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Province the municipality is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Province province = 1;</code>
       */
      public Builder setProvince(
          io.opencannabis.schema.geo.Province.Builder builderForValue) {
        if (provinceBuilder_ == null) {
          province_ = builderForValue.build();
          onChanged();
        } else {
          provinceBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Province the municipality is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Province province = 1;</code>
       */
      public Builder mergeProvince(io.opencannabis.schema.geo.Province value) {
        if (provinceBuilder_ == null) {
          if (province_ != null) {
            province_ =
              io.opencannabis.schema.geo.Province.newBuilder(province_).mergeFrom(value).buildPartial();
          } else {
            province_ = value;
          }
          onChanged();
        } else {
          provinceBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Province the municipality is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Province province = 1;</code>
       */
      public Builder clearProvince() {
        if (provinceBuilder_ == null) {
          province_ = null;
          onChanged();
        } else {
          province_ = null;
          provinceBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Province the municipality is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Province province = 1;</code>
       */
      public io.opencannabis.schema.geo.Province.Builder getProvinceBuilder() {
        
        onChanged();
        return getProvinceFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Province the municipality is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Province province = 1;</code>
       */
      public io.opencannabis.schema.geo.ProvinceOrBuilder getProvinceOrBuilder() {
        if (provinceBuilder_ != null) {
          return provinceBuilder_.getMessageOrBuilder();
        } else {
          return province_ == null ?
              io.opencannabis.schema.geo.Province.getDefaultInstance() : province_;
        }
      }
      /**
       * <pre>
       * Province the municipality is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Province province = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.geo.Province, io.opencannabis.schema.geo.Province.Builder, io.opencannabis.schema.geo.ProvinceOrBuilder> 
          getProvinceFieldBuilder() {
        if (provinceBuilder_ == null) {
          provinceBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.geo.Province, io.opencannabis.schema.geo.Province.Builder, io.opencannabis.schema.geo.ProvinceOrBuilder>(
                  getProvince(),
                  getParentForChildren(),
                  isClean());
          province_ = null;
        }
        return provinceBuilder_;
      }

      private io.opencannabis.schema.geo.Country country_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.geo.Country, io.opencannabis.schema.geo.Country.Builder, io.opencannabis.schema.geo.CountryOrBuilder> countryBuilder_;
      /**
       * <pre>
       * Country the province is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Country country = 2;</code>
       */
      public boolean hasCountry() {
        return countryBuilder_ != null || country_ != null;
      }
      /**
       * <pre>
       * Country the province is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Country country = 2;</code>
       */
      public io.opencannabis.schema.geo.Country getCountry() {
        if (countryBuilder_ == null) {
          return country_ == null ? io.opencannabis.schema.geo.Country.getDefaultInstance() : country_;
        } else {
          return countryBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Country the province is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Country country = 2;</code>
       */
      public Builder setCountry(io.opencannabis.schema.geo.Country value) {
        if (countryBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          country_ = value;
          onChanged();
        } else {
          countryBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Country the province is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Country country = 2;</code>
       */
      public Builder setCountry(
          io.opencannabis.schema.geo.Country.Builder builderForValue) {
        if (countryBuilder_ == null) {
          country_ = builderForValue.build();
          onChanged();
        } else {
          countryBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Country the province is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Country country = 2;</code>
       */
      public Builder mergeCountry(io.opencannabis.schema.geo.Country value) {
        if (countryBuilder_ == null) {
          if (country_ != null) {
            country_ =
              io.opencannabis.schema.geo.Country.newBuilder(country_).mergeFrom(value).buildPartial();
          } else {
            country_ = value;
          }
          onChanged();
        } else {
          countryBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Country the province is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Country country = 2;</code>
       */
      public Builder clearCountry() {
        if (countryBuilder_ == null) {
          country_ = null;
          onChanged();
        } else {
          country_ = null;
          countryBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Country the province is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Country country = 2;</code>
       */
      public io.opencannabis.schema.geo.Country.Builder getCountryBuilder() {
        
        onChanged();
        return getCountryFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Country the province is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Country country = 2;</code>
       */
      public io.opencannabis.schema.geo.CountryOrBuilder getCountryOrBuilder() {
        if (countryBuilder_ != null) {
          return countryBuilder_.getMessageOrBuilder();
        } else {
          return country_ == null ?
              io.opencannabis.schema.geo.Country.getDefaultInstance() : country_;
        }
      }
      /**
       * <pre>
       * Country the province is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Country country = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.geo.Country, io.opencannabis.schema.geo.Country.Builder, io.opencannabis.schema.geo.CountryOrBuilder> 
          getCountryFieldBuilder() {
        if (countryBuilder_ == null) {
          countryBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.geo.Country, io.opencannabis.schema.geo.Country.Builder, io.opencannabis.schema.geo.CountryOrBuilder>(
                  getCountry(),
                  getParentForChildren(),
                  isClean());
          country_ = null;
        }
        return countryBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:opencannabis.taxes.ProvincialTax)
    }

    // @@protoc_insertion_point(class_scope:opencannabis.taxes.ProvincialTax)
    private static final io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax();
    }

    public static io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ProvincialTax>
        PARSER = new com.google.protobuf.AbstractParser<ProvincialTax>() {
      public ProvincialTax parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new ProvincialTax(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<ProvincialTax> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ProvincialTax> getParserForType() {
      return PARSER;
    }

    public io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface FederalTaxOrBuilder extends
      // @@protoc_insertion_point(interface_extends:opencannabis.taxes.FederalTax)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Province the municipality is in.
     * </pre>
     *
     * <code>.opencannabis.geo.Country country = 1;</code>
     */
    boolean hasCountry();
    /**
     * <pre>
     * Province the municipality is in.
     * </pre>
     *
     * <code>.opencannabis.geo.Country country = 1;</code>
     */
    io.opencannabis.schema.geo.Country getCountry();
    /**
     * <pre>
     * Province the municipality is in.
     * </pre>
     *
     * <code>.opencannabis.geo.Country country = 1;</code>
     */
    io.opencannabis.schema.geo.CountryOrBuilder getCountryOrBuilder();
  }
  /**
   * <pre>
   * Specifies information about a federally-imposed tax.
   * </pre>
   *
   * Protobuf type {@code opencannabis.taxes.FederalTax}
   */
  public  static final class FederalTax extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:opencannabis.taxes.FederalTax)
      FederalTaxOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use FederalTax.newBuilder() to construct.
    private FederalTax(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private FederalTax() {
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private FederalTax(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              io.opencannabis.schema.geo.Country.Builder subBuilder = null;
              if (country_ != null) {
                subBuilder = country_.toBuilder();
              }
              country_ = input.readMessage(io.opencannabis.schema.geo.Country.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(country_);
                country_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.accounting.AccountingTaxes.internal_static_opencannabis_taxes_FederalTax_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.accounting.AccountingTaxes.internal_static_opencannabis_taxes_FederalTax_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.accounting.AccountingTaxes.FederalTax.class, io.opencannabis.schema.accounting.AccountingTaxes.FederalTax.Builder.class);
    }

    public static final int COUNTRY_FIELD_NUMBER = 1;
    private io.opencannabis.schema.geo.Country country_;
    /**
     * <pre>
     * Province the municipality is in.
     * </pre>
     *
     * <code>.opencannabis.geo.Country country = 1;</code>
     */
    public boolean hasCountry() {
      return country_ != null;
    }
    /**
     * <pre>
     * Province the municipality is in.
     * </pre>
     *
     * <code>.opencannabis.geo.Country country = 1;</code>
     */
    public io.opencannabis.schema.geo.Country getCountry() {
      return country_ == null ? io.opencannabis.schema.geo.Country.getDefaultInstance() : country_;
    }
    /**
     * <pre>
     * Province the municipality is in.
     * </pre>
     *
     * <code>.opencannabis.geo.Country country = 1;</code>
     */
    public io.opencannabis.schema.geo.CountryOrBuilder getCountryOrBuilder() {
      return getCountry();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (country_ != null) {
        output.writeMessage(1, getCountry());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (country_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getCountry());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.opencannabis.schema.accounting.AccountingTaxes.FederalTax)) {
        return super.equals(obj);
      }
      io.opencannabis.schema.accounting.AccountingTaxes.FederalTax other = (io.opencannabis.schema.accounting.AccountingTaxes.FederalTax) obj;

      boolean result = true;
      result = result && (hasCountry() == other.hasCountry());
      if (hasCountry()) {
        result = result && getCountry()
            .equals(other.getCountry());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasCountry()) {
        hash = (37 * hash) + COUNTRY_FIELD_NUMBER;
        hash = (53 * hash) + getCountry().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.opencannabis.schema.accounting.AccountingTaxes.FederalTax parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.FederalTax parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.FederalTax parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.FederalTax parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.FederalTax parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.FederalTax parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.FederalTax parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.FederalTax parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.FederalTax parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.FederalTax parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.FederalTax parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.FederalTax parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.opencannabis.schema.accounting.AccountingTaxes.FederalTax prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies information about a federally-imposed tax.
     * </pre>
     *
     * Protobuf type {@code opencannabis.taxes.FederalTax}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:opencannabis.taxes.FederalTax)
        io.opencannabis.schema.accounting.AccountingTaxes.FederalTaxOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.opencannabis.schema.accounting.AccountingTaxes.internal_static_opencannabis_taxes_FederalTax_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.opencannabis.schema.accounting.AccountingTaxes.internal_static_opencannabis_taxes_FederalTax_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.opencannabis.schema.accounting.AccountingTaxes.FederalTax.class, io.opencannabis.schema.accounting.AccountingTaxes.FederalTax.Builder.class);
      }

      // Construct using io.opencannabis.schema.accounting.AccountingTaxes.FederalTax.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        if (countryBuilder_ == null) {
          country_ = null;
        } else {
          country_ = null;
          countryBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.opencannabis.schema.accounting.AccountingTaxes.internal_static_opencannabis_taxes_FederalTax_descriptor;
      }

      public io.opencannabis.schema.accounting.AccountingTaxes.FederalTax getDefaultInstanceForType() {
        return io.opencannabis.schema.accounting.AccountingTaxes.FederalTax.getDefaultInstance();
      }

      public io.opencannabis.schema.accounting.AccountingTaxes.FederalTax build() {
        io.opencannabis.schema.accounting.AccountingTaxes.FederalTax result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.opencannabis.schema.accounting.AccountingTaxes.FederalTax buildPartial() {
        io.opencannabis.schema.accounting.AccountingTaxes.FederalTax result = new io.opencannabis.schema.accounting.AccountingTaxes.FederalTax(this);
        if (countryBuilder_ == null) {
          result.country_ = country_;
        } else {
          result.country_ = countryBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.opencannabis.schema.accounting.AccountingTaxes.FederalTax) {
          return mergeFrom((io.opencannabis.schema.accounting.AccountingTaxes.FederalTax)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.opencannabis.schema.accounting.AccountingTaxes.FederalTax other) {
        if (other == io.opencannabis.schema.accounting.AccountingTaxes.FederalTax.getDefaultInstance()) return this;
        if (other.hasCountry()) {
          mergeCountry(other.getCountry());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.opencannabis.schema.accounting.AccountingTaxes.FederalTax parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.opencannabis.schema.accounting.AccountingTaxes.FederalTax) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private io.opencannabis.schema.geo.Country country_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.geo.Country, io.opencannabis.schema.geo.Country.Builder, io.opencannabis.schema.geo.CountryOrBuilder> countryBuilder_;
      /**
       * <pre>
       * Province the municipality is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Country country = 1;</code>
       */
      public boolean hasCountry() {
        return countryBuilder_ != null || country_ != null;
      }
      /**
       * <pre>
       * Province the municipality is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Country country = 1;</code>
       */
      public io.opencannabis.schema.geo.Country getCountry() {
        if (countryBuilder_ == null) {
          return country_ == null ? io.opencannabis.schema.geo.Country.getDefaultInstance() : country_;
        } else {
          return countryBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Province the municipality is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Country country = 1;</code>
       */
      public Builder setCountry(io.opencannabis.schema.geo.Country value) {
        if (countryBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          country_ = value;
          onChanged();
        } else {
          countryBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Province the municipality is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Country country = 1;</code>
       */
      public Builder setCountry(
          io.opencannabis.schema.geo.Country.Builder builderForValue) {
        if (countryBuilder_ == null) {
          country_ = builderForValue.build();
          onChanged();
        } else {
          countryBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Province the municipality is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Country country = 1;</code>
       */
      public Builder mergeCountry(io.opencannabis.schema.geo.Country value) {
        if (countryBuilder_ == null) {
          if (country_ != null) {
            country_ =
              io.opencannabis.schema.geo.Country.newBuilder(country_).mergeFrom(value).buildPartial();
          } else {
            country_ = value;
          }
          onChanged();
        } else {
          countryBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Province the municipality is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Country country = 1;</code>
       */
      public Builder clearCountry() {
        if (countryBuilder_ == null) {
          country_ = null;
          onChanged();
        } else {
          country_ = null;
          countryBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Province the municipality is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Country country = 1;</code>
       */
      public io.opencannabis.schema.geo.Country.Builder getCountryBuilder() {
        
        onChanged();
        return getCountryFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Province the municipality is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Country country = 1;</code>
       */
      public io.opencannabis.schema.geo.CountryOrBuilder getCountryOrBuilder() {
        if (countryBuilder_ != null) {
          return countryBuilder_.getMessageOrBuilder();
        } else {
          return country_ == null ?
              io.opencannabis.schema.geo.Country.getDefaultInstance() : country_;
        }
      }
      /**
       * <pre>
       * Province the municipality is in.
       * </pre>
       *
       * <code>.opencannabis.geo.Country country = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.geo.Country, io.opencannabis.schema.geo.Country.Builder, io.opencannabis.schema.geo.CountryOrBuilder> 
          getCountryFieldBuilder() {
        if (countryBuilder_ == null) {
          countryBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.geo.Country, io.opencannabis.schema.geo.Country.Builder, io.opencannabis.schema.geo.CountryOrBuilder>(
                  getCountry(),
                  getParentForChildren(),
                  isClean());
          country_ = null;
        }
        return countryBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:opencannabis.taxes.FederalTax)
    }

    // @@protoc_insertion_point(class_scope:opencannabis.taxes.FederalTax)
    private static final io.opencannabis.schema.accounting.AccountingTaxes.FederalTax DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.opencannabis.schema.accounting.AccountingTaxes.FederalTax();
    }

    public static io.opencannabis.schema.accounting.AccountingTaxes.FederalTax getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FederalTax>
        PARSER = new com.google.protobuf.AbstractParser<FederalTax>() {
      public FederalTax parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new FederalTax(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<FederalTax> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FederalTax> getParserForType() {
      return PARSER;
    }

    public io.opencannabis.schema.accounting.AccountingTaxes.FederalTax getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface TaxJurisdictionOrBuilder extends
      // @@protoc_insertion_point(interface_extends:opencannabis.taxes.TaxJurisdiction)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Operating mode of this tax jurisdiction.
     * </pre>
     *
     * <code>.opencannabis.taxes.TaxJurisdictionMode mode = 1;</code>
     */
    int getModeValue();
    /**
     * <pre>
     * Operating mode of this tax jurisdiction.
     * </pre>
     *
     * <code>.opencannabis.taxes.TaxJurisdictionMode mode = 1;</code>
     */
    io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdictionMode getMode();

    /**
     * <pre>
     * Local tax jurisdiction information.
     * </pre>
     *
     * <code>.opencannabis.taxes.LocalTax local = 2;</code>
     */
    boolean hasLocal();
    /**
     * <pre>
     * Local tax jurisdiction information.
     * </pre>
     *
     * <code>.opencannabis.taxes.LocalTax local = 2;</code>
     */
    io.opencannabis.schema.accounting.AccountingTaxes.LocalTax getLocal();
    /**
     * <pre>
     * Local tax jurisdiction information.
     * </pre>
     *
     * <code>.opencannabis.taxes.LocalTax local = 2;</code>
     */
    io.opencannabis.schema.accounting.AccountingTaxes.LocalTaxOrBuilder getLocalOrBuilder();

    /**
     * <pre>
     * Provincial tax jurisdiction information.
     * </pre>
     *
     * <code>.opencannabis.taxes.ProvincialTax provincial = 3;</code>
     */
    boolean hasProvincial();
    /**
     * <pre>
     * Provincial tax jurisdiction information.
     * </pre>
     *
     * <code>.opencannabis.taxes.ProvincialTax provincial = 3;</code>
     */
    io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax getProvincial();
    /**
     * <pre>
     * Provincial tax jurisdiction information.
     * </pre>
     *
     * <code>.opencannabis.taxes.ProvincialTax provincial = 3;</code>
     */
    io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTaxOrBuilder getProvincialOrBuilder();

    /**
     * <pre>
     * Federal tax jurisdiction information.
     * </pre>
     *
     * <code>.opencannabis.taxes.FederalTax federal = 4;</code>
     */
    boolean hasFederal();
    /**
     * <pre>
     * Federal tax jurisdiction information.
     * </pre>
     *
     * <code>.opencannabis.taxes.FederalTax federal = 4;</code>
     */
    io.opencannabis.schema.accounting.AccountingTaxes.FederalTax getFederal();
    /**
     * <pre>
     * Federal tax jurisdiction information.
     * </pre>
     *
     * <code>.opencannabis.taxes.FederalTax federal = 4;</code>
     */
    io.opencannabis.schema.accounting.AccountingTaxes.FederalTaxOrBuilder getFederalOrBuilder();

    public io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction.JurisdictionCase getJurisdictionCase();
  }
  /**
   * <pre>
   * Specifies information about a particular tax jurisdiction.
   * </pre>
   *
   * Protobuf type {@code opencannabis.taxes.TaxJurisdiction}
   */
  public  static final class TaxJurisdiction extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:opencannabis.taxes.TaxJurisdiction)
      TaxJurisdictionOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use TaxJurisdiction.newBuilder() to construct.
    private TaxJurisdiction(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private TaxJurisdiction() {
      mode_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private TaxJurisdiction(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();

              mode_ = rawValue;
              break;
            }
            case 18: {
              io.opencannabis.schema.accounting.AccountingTaxes.LocalTax.Builder subBuilder = null;
              if (jurisdictionCase_ == 2) {
                subBuilder = ((io.opencannabis.schema.accounting.AccountingTaxes.LocalTax) jurisdiction_).toBuilder();
              }
              jurisdiction_ =
                  input.readMessage(io.opencannabis.schema.accounting.AccountingTaxes.LocalTax.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((io.opencannabis.schema.accounting.AccountingTaxes.LocalTax) jurisdiction_);
                jurisdiction_ = subBuilder.buildPartial();
              }
              jurisdictionCase_ = 2;
              break;
            }
            case 26: {
              io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax.Builder subBuilder = null;
              if (jurisdictionCase_ == 3) {
                subBuilder = ((io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax) jurisdiction_).toBuilder();
              }
              jurisdiction_ =
                  input.readMessage(io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax) jurisdiction_);
                jurisdiction_ = subBuilder.buildPartial();
              }
              jurisdictionCase_ = 3;
              break;
            }
            case 34: {
              io.opencannabis.schema.accounting.AccountingTaxes.FederalTax.Builder subBuilder = null;
              if (jurisdictionCase_ == 4) {
                subBuilder = ((io.opencannabis.schema.accounting.AccountingTaxes.FederalTax) jurisdiction_).toBuilder();
              }
              jurisdiction_ =
                  input.readMessage(io.opencannabis.schema.accounting.AccountingTaxes.FederalTax.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((io.opencannabis.schema.accounting.AccountingTaxes.FederalTax) jurisdiction_);
                jurisdiction_ = subBuilder.buildPartial();
              }
              jurisdictionCase_ = 4;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.accounting.AccountingTaxes.internal_static_opencannabis_taxes_TaxJurisdiction_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.accounting.AccountingTaxes.internal_static_opencannabis_taxes_TaxJurisdiction_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction.class, io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction.Builder.class);
    }

    private int jurisdictionCase_ = 0;
    private java.lang.Object jurisdiction_;
    public enum JurisdictionCase
        implements com.google.protobuf.Internal.EnumLite {
      LOCAL(2),
      PROVINCIAL(3),
      FEDERAL(4),
      JURISDICTION_NOT_SET(0);
      private final int value;
      private JurisdictionCase(int value) {
        this.value = value;
      }
      /**
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static JurisdictionCase valueOf(int value) {
        return forNumber(value);
      }

      public static JurisdictionCase forNumber(int value) {
        switch (value) {
          case 2: return LOCAL;
          case 3: return PROVINCIAL;
          case 4: return FEDERAL;
          case 0: return JURISDICTION_NOT_SET;
          default: return null;
        }
      }
      public int getNumber() {
        return this.value;
      }
    };

    public JurisdictionCase
    getJurisdictionCase() {
      return JurisdictionCase.forNumber(
          jurisdictionCase_);
    }

    public static final int MODE_FIELD_NUMBER = 1;
    private int mode_;
    /**
     * <pre>
     * Operating mode of this tax jurisdiction.
     * </pre>
     *
     * <code>.opencannabis.taxes.TaxJurisdictionMode mode = 1;</code>
     */
    public int getModeValue() {
      return mode_;
    }
    /**
     * <pre>
     * Operating mode of this tax jurisdiction.
     * </pre>
     *
     * <code>.opencannabis.taxes.TaxJurisdictionMode mode = 1;</code>
     */
    public io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdictionMode getMode() {
      io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdictionMode result = io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdictionMode.valueOf(mode_);
      return result == null ? io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdictionMode.UNRECOGNIZED : result;
    }

    public static final int LOCAL_FIELD_NUMBER = 2;
    /**
     * <pre>
     * Local tax jurisdiction information.
     * </pre>
     *
     * <code>.opencannabis.taxes.LocalTax local = 2;</code>
     */
    public boolean hasLocal() {
      return jurisdictionCase_ == 2;
    }
    /**
     * <pre>
     * Local tax jurisdiction information.
     * </pre>
     *
     * <code>.opencannabis.taxes.LocalTax local = 2;</code>
     */
    public io.opencannabis.schema.accounting.AccountingTaxes.LocalTax getLocal() {
      if (jurisdictionCase_ == 2) {
         return (io.opencannabis.schema.accounting.AccountingTaxes.LocalTax) jurisdiction_;
      }
      return io.opencannabis.schema.accounting.AccountingTaxes.LocalTax.getDefaultInstance();
    }
    /**
     * <pre>
     * Local tax jurisdiction information.
     * </pre>
     *
     * <code>.opencannabis.taxes.LocalTax local = 2;</code>
     */
    public io.opencannabis.schema.accounting.AccountingTaxes.LocalTaxOrBuilder getLocalOrBuilder() {
      if (jurisdictionCase_ == 2) {
         return (io.opencannabis.schema.accounting.AccountingTaxes.LocalTax) jurisdiction_;
      }
      return io.opencannabis.schema.accounting.AccountingTaxes.LocalTax.getDefaultInstance();
    }

    public static final int PROVINCIAL_FIELD_NUMBER = 3;
    /**
     * <pre>
     * Provincial tax jurisdiction information.
     * </pre>
     *
     * <code>.opencannabis.taxes.ProvincialTax provincial = 3;</code>
     */
    public boolean hasProvincial() {
      return jurisdictionCase_ == 3;
    }
    /**
     * <pre>
     * Provincial tax jurisdiction information.
     * </pre>
     *
     * <code>.opencannabis.taxes.ProvincialTax provincial = 3;</code>
     */
    public io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax getProvincial() {
      if (jurisdictionCase_ == 3) {
         return (io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax) jurisdiction_;
      }
      return io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax.getDefaultInstance();
    }
    /**
     * <pre>
     * Provincial tax jurisdiction information.
     * </pre>
     *
     * <code>.opencannabis.taxes.ProvincialTax provincial = 3;</code>
     */
    public io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTaxOrBuilder getProvincialOrBuilder() {
      if (jurisdictionCase_ == 3) {
         return (io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax) jurisdiction_;
      }
      return io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax.getDefaultInstance();
    }

    public static final int FEDERAL_FIELD_NUMBER = 4;
    /**
     * <pre>
     * Federal tax jurisdiction information.
     * </pre>
     *
     * <code>.opencannabis.taxes.FederalTax federal = 4;</code>
     */
    public boolean hasFederal() {
      return jurisdictionCase_ == 4;
    }
    /**
     * <pre>
     * Federal tax jurisdiction information.
     * </pre>
     *
     * <code>.opencannabis.taxes.FederalTax federal = 4;</code>
     */
    public io.opencannabis.schema.accounting.AccountingTaxes.FederalTax getFederal() {
      if (jurisdictionCase_ == 4) {
         return (io.opencannabis.schema.accounting.AccountingTaxes.FederalTax) jurisdiction_;
      }
      return io.opencannabis.schema.accounting.AccountingTaxes.FederalTax.getDefaultInstance();
    }
    /**
     * <pre>
     * Federal tax jurisdiction information.
     * </pre>
     *
     * <code>.opencannabis.taxes.FederalTax federal = 4;</code>
     */
    public io.opencannabis.schema.accounting.AccountingTaxes.FederalTaxOrBuilder getFederalOrBuilder() {
      if (jurisdictionCase_ == 4) {
         return (io.opencannabis.schema.accounting.AccountingTaxes.FederalTax) jurisdiction_;
      }
      return io.opencannabis.schema.accounting.AccountingTaxes.FederalTax.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (mode_ != io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdictionMode.LOCAL.getNumber()) {
        output.writeEnum(1, mode_);
      }
      if (jurisdictionCase_ == 2) {
        output.writeMessage(2, (io.opencannabis.schema.accounting.AccountingTaxes.LocalTax) jurisdiction_);
      }
      if (jurisdictionCase_ == 3) {
        output.writeMessage(3, (io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax) jurisdiction_);
      }
      if (jurisdictionCase_ == 4) {
        output.writeMessage(4, (io.opencannabis.schema.accounting.AccountingTaxes.FederalTax) jurisdiction_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (mode_ != io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdictionMode.LOCAL.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, mode_);
      }
      if (jurisdictionCase_ == 2) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, (io.opencannabis.schema.accounting.AccountingTaxes.LocalTax) jurisdiction_);
      }
      if (jurisdictionCase_ == 3) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, (io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax) jurisdiction_);
      }
      if (jurisdictionCase_ == 4) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, (io.opencannabis.schema.accounting.AccountingTaxes.FederalTax) jurisdiction_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction)) {
        return super.equals(obj);
      }
      io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction other = (io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction) obj;

      boolean result = true;
      result = result && mode_ == other.mode_;
      result = result && getJurisdictionCase().equals(
          other.getJurisdictionCase());
      if (!result) return false;
      switch (jurisdictionCase_) {
        case 2:
          result = result && getLocal()
              .equals(other.getLocal());
          break;
        case 3:
          result = result && getProvincial()
              .equals(other.getProvincial());
          break;
        case 4:
          result = result && getFederal()
              .equals(other.getFederal());
          break;
        case 0:
        default:
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MODE_FIELD_NUMBER;
      hash = (53 * hash) + mode_;
      switch (jurisdictionCase_) {
        case 2:
          hash = (37 * hash) + LOCAL_FIELD_NUMBER;
          hash = (53 * hash) + getLocal().hashCode();
          break;
        case 3:
          hash = (37 * hash) + PROVINCIAL_FIELD_NUMBER;
          hash = (53 * hash) + getProvincial().hashCode();
          break;
        case 4:
          hash = (37 * hash) + FEDERAL_FIELD_NUMBER;
          hash = (53 * hash) + getFederal().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies information about a particular tax jurisdiction.
     * </pre>
     *
     * Protobuf type {@code opencannabis.taxes.TaxJurisdiction}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:opencannabis.taxes.TaxJurisdiction)
        io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdictionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.opencannabis.schema.accounting.AccountingTaxes.internal_static_opencannabis_taxes_TaxJurisdiction_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.opencannabis.schema.accounting.AccountingTaxes.internal_static_opencannabis_taxes_TaxJurisdiction_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction.class, io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction.Builder.class);
      }

      // Construct using io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        mode_ = 0;

        jurisdictionCase_ = 0;
        jurisdiction_ = null;
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.opencannabis.schema.accounting.AccountingTaxes.internal_static_opencannabis_taxes_TaxJurisdiction_descriptor;
      }

      public io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction getDefaultInstanceForType() {
        return io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction.getDefaultInstance();
      }

      public io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction build() {
        io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction buildPartial() {
        io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction result = new io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction(this);
        result.mode_ = mode_;
        if (jurisdictionCase_ == 2) {
          if (localBuilder_ == null) {
            result.jurisdiction_ = jurisdiction_;
          } else {
            result.jurisdiction_ = localBuilder_.build();
          }
        }
        if (jurisdictionCase_ == 3) {
          if (provincialBuilder_ == null) {
            result.jurisdiction_ = jurisdiction_;
          } else {
            result.jurisdiction_ = provincialBuilder_.build();
          }
        }
        if (jurisdictionCase_ == 4) {
          if (federalBuilder_ == null) {
            result.jurisdiction_ = jurisdiction_;
          } else {
            result.jurisdiction_ = federalBuilder_.build();
          }
        }
        result.jurisdictionCase_ = jurisdictionCase_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction) {
          return mergeFrom((io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction other) {
        if (other == io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction.getDefaultInstance()) return this;
        if (other.mode_ != 0) {
          setModeValue(other.getModeValue());
        }
        switch (other.getJurisdictionCase()) {
          case LOCAL: {
            mergeLocal(other.getLocal());
            break;
          }
          case PROVINCIAL: {
            mergeProvincial(other.getProvincial());
            break;
          }
          case FEDERAL: {
            mergeFederal(other.getFederal());
            break;
          }
          case JURISDICTION_NOT_SET: {
            break;
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int jurisdictionCase_ = 0;
      private java.lang.Object jurisdiction_;
      public JurisdictionCase
          getJurisdictionCase() {
        return JurisdictionCase.forNumber(
            jurisdictionCase_);
      }

      public Builder clearJurisdiction() {
        jurisdictionCase_ = 0;
        jurisdiction_ = null;
        onChanged();
        return this;
      }


      private int mode_ = 0;
      /**
       * <pre>
       * Operating mode of this tax jurisdiction.
       * </pre>
       *
       * <code>.opencannabis.taxes.TaxJurisdictionMode mode = 1;</code>
       */
      public int getModeValue() {
        return mode_;
      }
      /**
       * <pre>
       * Operating mode of this tax jurisdiction.
       * </pre>
       *
       * <code>.opencannabis.taxes.TaxJurisdictionMode mode = 1;</code>
       */
      public Builder setModeValue(int value) {
        mode_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Operating mode of this tax jurisdiction.
       * </pre>
       *
       * <code>.opencannabis.taxes.TaxJurisdictionMode mode = 1;</code>
       */
      public io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdictionMode getMode() {
        io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdictionMode result = io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdictionMode.valueOf(mode_);
        return result == null ? io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdictionMode.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Operating mode of this tax jurisdiction.
       * </pre>
       *
       * <code>.opencannabis.taxes.TaxJurisdictionMode mode = 1;</code>
       */
      public Builder setMode(io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdictionMode value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        mode_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Operating mode of this tax jurisdiction.
       * </pre>
       *
       * <code>.opencannabis.taxes.TaxJurisdictionMode mode = 1;</code>
       */
      public Builder clearMode() {
        
        mode_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.accounting.AccountingTaxes.LocalTax, io.opencannabis.schema.accounting.AccountingTaxes.LocalTax.Builder, io.opencannabis.schema.accounting.AccountingTaxes.LocalTaxOrBuilder> localBuilder_;
      /**
       * <pre>
       * Local tax jurisdiction information.
       * </pre>
       *
       * <code>.opencannabis.taxes.LocalTax local = 2;</code>
       */
      public boolean hasLocal() {
        return jurisdictionCase_ == 2;
      }
      /**
       * <pre>
       * Local tax jurisdiction information.
       * </pre>
       *
       * <code>.opencannabis.taxes.LocalTax local = 2;</code>
       */
      public io.opencannabis.schema.accounting.AccountingTaxes.LocalTax getLocal() {
        if (localBuilder_ == null) {
          if (jurisdictionCase_ == 2) {
            return (io.opencannabis.schema.accounting.AccountingTaxes.LocalTax) jurisdiction_;
          }
          return io.opencannabis.schema.accounting.AccountingTaxes.LocalTax.getDefaultInstance();
        } else {
          if (jurisdictionCase_ == 2) {
            return localBuilder_.getMessage();
          }
          return io.opencannabis.schema.accounting.AccountingTaxes.LocalTax.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Local tax jurisdiction information.
       * </pre>
       *
       * <code>.opencannabis.taxes.LocalTax local = 2;</code>
       */
      public Builder setLocal(io.opencannabis.schema.accounting.AccountingTaxes.LocalTax value) {
        if (localBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          jurisdiction_ = value;
          onChanged();
        } else {
          localBuilder_.setMessage(value);
        }
        jurisdictionCase_ = 2;
        return this;
      }
      /**
       * <pre>
       * Local tax jurisdiction information.
       * </pre>
       *
       * <code>.opencannabis.taxes.LocalTax local = 2;</code>
       */
      public Builder setLocal(
          io.opencannabis.schema.accounting.AccountingTaxes.LocalTax.Builder builderForValue) {
        if (localBuilder_ == null) {
          jurisdiction_ = builderForValue.build();
          onChanged();
        } else {
          localBuilder_.setMessage(builderForValue.build());
        }
        jurisdictionCase_ = 2;
        return this;
      }
      /**
       * <pre>
       * Local tax jurisdiction information.
       * </pre>
       *
       * <code>.opencannabis.taxes.LocalTax local = 2;</code>
       */
      public Builder mergeLocal(io.opencannabis.schema.accounting.AccountingTaxes.LocalTax value) {
        if (localBuilder_ == null) {
          if (jurisdictionCase_ == 2 &&
              jurisdiction_ != io.opencannabis.schema.accounting.AccountingTaxes.LocalTax.getDefaultInstance()) {
            jurisdiction_ = io.opencannabis.schema.accounting.AccountingTaxes.LocalTax.newBuilder((io.opencannabis.schema.accounting.AccountingTaxes.LocalTax) jurisdiction_)
                .mergeFrom(value).buildPartial();
          } else {
            jurisdiction_ = value;
          }
          onChanged();
        } else {
          if (jurisdictionCase_ == 2) {
            localBuilder_.mergeFrom(value);
          }
          localBuilder_.setMessage(value);
        }
        jurisdictionCase_ = 2;
        return this;
      }
      /**
       * <pre>
       * Local tax jurisdiction information.
       * </pre>
       *
       * <code>.opencannabis.taxes.LocalTax local = 2;</code>
       */
      public Builder clearLocal() {
        if (localBuilder_ == null) {
          if (jurisdictionCase_ == 2) {
            jurisdictionCase_ = 0;
            jurisdiction_ = null;
            onChanged();
          }
        } else {
          if (jurisdictionCase_ == 2) {
            jurisdictionCase_ = 0;
            jurisdiction_ = null;
          }
          localBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Local tax jurisdiction information.
       * </pre>
       *
       * <code>.opencannabis.taxes.LocalTax local = 2;</code>
       */
      public io.opencannabis.schema.accounting.AccountingTaxes.LocalTax.Builder getLocalBuilder() {
        return getLocalFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Local tax jurisdiction information.
       * </pre>
       *
       * <code>.opencannabis.taxes.LocalTax local = 2;</code>
       */
      public io.opencannabis.schema.accounting.AccountingTaxes.LocalTaxOrBuilder getLocalOrBuilder() {
        if ((jurisdictionCase_ == 2) && (localBuilder_ != null)) {
          return localBuilder_.getMessageOrBuilder();
        } else {
          if (jurisdictionCase_ == 2) {
            return (io.opencannabis.schema.accounting.AccountingTaxes.LocalTax) jurisdiction_;
          }
          return io.opencannabis.schema.accounting.AccountingTaxes.LocalTax.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Local tax jurisdiction information.
       * </pre>
       *
       * <code>.opencannabis.taxes.LocalTax local = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.accounting.AccountingTaxes.LocalTax, io.opencannabis.schema.accounting.AccountingTaxes.LocalTax.Builder, io.opencannabis.schema.accounting.AccountingTaxes.LocalTaxOrBuilder> 
          getLocalFieldBuilder() {
        if (localBuilder_ == null) {
          if (!(jurisdictionCase_ == 2)) {
            jurisdiction_ = io.opencannabis.schema.accounting.AccountingTaxes.LocalTax.getDefaultInstance();
          }
          localBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.accounting.AccountingTaxes.LocalTax, io.opencannabis.schema.accounting.AccountingTaxes.LocalTax.Builder, io.opencannabis.schema.accounting.AccountingTaxes.LocalTaxOrBuilder>(
                  (io.opencannabis.schema.accounting.AccountingTaxes.LocalTax) jurisdiction_,
                  getParentForChildren(),
                  isClean());
          jurisdiction_ = null;
        }
        jurisdictionCase_ = 2;
        onChanged();;
        return localBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax, io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax.Builder, io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTaxOrBuilder> provincialBuilder_;
      /**
       * <pre>
       * Provincial tax jurisdiction information.
       * </pre>
       *
       * <code>.opencannabis.taxes.ProvincialTax provincial = 3;</code>
       */
      public boolean hasProvincial() {
        return jurisdictionCase_ == 3;
      }
      /**
       * <pre>
       * Provincial tax jurisdiction information.
       * </pre>
       *
       * <code>.opencannabis.taxes.ProvincialTax provincial = 3;</code>
       */
      public io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax getProvincial() {
        if (provincialBuilder_ == null) {
          if (jurisdictionCase_ == 3) {
            return (io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax) jurisdiction_;
          }
          return io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax.getDefaultInstance();
        } else {
          if (jurisdictionCase_ == 3) {
            return provincialBuilder_.getMessage();
          }
          return io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Provincial tax jurisdiction information.
       * </pre>
       *
       * <code>.opencannabis.taxes.ProvincialTax provincial = 3;</code>
       */
      public Builder setProvincial(io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax value) {
        if (provincialBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          jurisdiction_ = value;
          onChanged();
        } else {
          provincialBuilder_.setMessage(value);
        }
        jurisdictionCase_ = 3;
        return this;
      }
      /**
       * <pre>
       * Provincial tax jurisdiction information.
       * </pre>
       *
       * <code>.opencannabis.taxes.ProvincialTax provincial = 3;</code>
       */
      public Builder setProvincial(
          io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax.Builder builderForValue) {
        if (provincialBuilder_ == null) {
          jurisdiction_ = builderForValue.build();
          onChanged();
        } else {
          provincialBuilder_.setMessage(builderForValue.build());
        }
        jurisdictionCase_ = 3;
        return this;
      }
      /**
       * <pre>
       * Provincial tax jurisdiction information.
       * </pre>
       *
       * <code>.opencannabis.taxes.ProvincialTax provincial = 3;</code>
       */
      public Builder mergeProvincial(io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax value) {
        if (provincialBuilder_ == null) {
          if (jurisdictionCase_ == 3 &&
              jurisdiction_ != io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax.getDefaultInstance()) {
            jurisdiction_ = io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax.newBuilder((io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax) jurisdiction_)
                .mergeFrom(value).buildPartial();
          } else {
            jurisdiction_ = value;
          }
          onChanged();
        } else {
          if (jurisdictionCase_ == 3) {
            provincialBuilder_.mergeFrom(value);
          }
          provincialBuilder_.setMessage(value);
        }
        jurisdictionCase_ = 3;
        return this;
      }
      /**
       * <pre>
       * Provincial tax jurisdiction information.
       * </pre>
       *
       * <code>.opencannabis.taxes.ProvincialTax provincial = 3;</code>
       */
      public Builder clearProvincial() {
        if (provincialBuilder_ == null) {
          if (jurisdictionCase_ == 3) {
            jurisdictionCase_ = 0;
            jurisdiction_ = null;
            onChanged();
          }
        } else {
          if (jurisdictionCase_ == 3) {
            jurisdictionCase_ = 0;
            jurisdiction_ = null;
          }
          provincialBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Provincial tax jurisdiction information.
       * </pre>
       *
       * <code>.opencannabis.taxes.ProvincialTax provincial = 3;</code>
       */
      public io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax.Builder getProvincialBuilder() {
        return getProvincialFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Provincial tax jurisdiction information.
       * </pre>
       *
       * <code>.opencannabis.taxes.ProvincialTax provincial = 3;</code>
       */
      public io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTaxOrBuilder getProvincialOrBuilder() {
        if ((jurisdictionCase_ == 3) && (provincialBuilder_ != null)) {
          return provincialBuilder_.getMessageOrBuilder();
        } else {
          if (jurisdictionCase_ == 3) {
            return (io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax) jurisdiction_;
          }
          return io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Provincial tax jurisdiction information.
       * </pre>
       *
       * <code>.opencannabis.taxes.ProvincialTax provincial = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax, io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax.Builder, io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTaxOrBuilder> 
          getProvincialFieldBuilder() {
        if (provincialBuilder_ == null) {
          if (!(jurisdictionCase_ == 3)) {
            jurisdiction_ = io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax.getDefaultInstance();
          }
          provincialBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax, io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax.Builder, io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTaxOrBuilder>(
                  (io.opencannabis.schema.accounting.AccountingTaxes.ProvincialTax) jurisdiction_,
                  getParentForChildren(),
                  isClean());
          jurisdiction_ = null;
        }
        jurisdictionCase_ = 3;
        onChanged();;
        return provincialBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.accounting.AccountingTaxes.FederalTax, io.opencannabis.schema.accounting.AccountingTaxes.FederalTax.Builder, io.opencannabis.schema.accounting.AccountingTaxes.FederalTaxOrBuilder> federalBuilder_;
      /**
       * <pre>
       * Federal tax jurisdiction information.
       * </pre>
       *
       * <code>.opencannabis.taxes.FederalTax federal = 4;</code>
       */
      public boolean hasFederal() {
        return jurisdictionCase_ == 4;
      }
      /**
       * <pre>
       * Federal tax jurisdiction information.
       * </pre>
       *
       * <code>.opencannabis.taxes.FederalTax federal = 4;</code>
       */
      public io.opencannabis.schema.accounting.AccountingTaxes.FederalTax getFederal() {
        if (federalBuilder_ == null) {
          if (jurisdictionCase_ == 4) {
            return (io.opencannabis.schema.accounting.AccountingTaxes.FederalTax) jurisdiction_;
          }
          return io.opencannabis.schema.accounting.AccountingTaxes.FederalTax.getDefaultInstance();
        } else {
          if (jurisdictionCase_ == 4) {
            return federalBuilder_.getMessage();
          }
          return io.opencannabis.schema.accounting.AccountingTaxes.FederalTax.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Federal tax jurisdiction information.
       * </pre>
       *
       * <code>.opencannabis.taxes.FederalTax federal = 4;</code>
       */
      public Builder setFederal(io.opencannabis.schema.accounting.AccountingTaxes.FederalTax value) {
        if (federalBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          jurisdiction_ = value;
          onChanged();
        } else {
          federalBuilder_.setMessage(value);
        }
        jurisdictionCase_ = 4;
        return this;
      }
      /**
       * <pre>
       * Federal tax jurisdiction information.
       * </pre>
       *
       * <code>.opencannabis.taxes.FederalTax federal = 4;</code>
       */
      public Builder setFederal(
          io.opencannabis.schema.accounting.AccountingTaxes.FederalTax.Builder builderForValue) {
        if (federalBuilder_ == null) {
          jurisdiction_ = builderForValue.build();
          onChanged();
        } else {
          federalBuilder_.setMessage(builderForValue.build());
        }
        jurisdictionCase_ = 4;
        return this;
      }
      /**
       * <pre>
       * Federal tax jurisdiction information.
       * </pre>
       *
       * <code>.opencannabis.taxes.FederalTax federal = 4;</code>
       */
      public Builder mergeFederal(io.opencannabis.schema.accounting.AccountingTaxes.FederalTax value) {
        if (federalBuilder_ == null) {
          if (jurisdictionCase_ == 4 &&
              jurisdiction_ != io.opencannabis.schema.accounting.AccountingTaxes.FederalTax.getDefaultInstance()) {
            jurisdiction_ = io.opencannabis.schema.accounting.AccountingTaxes.FederalTax.newBuilder((io.opencannabis.schema.accounting.AccountingTaxes.FederalTax) jurisdiction_)
                .mergeFrom(value).buildPartial();
          } else {
            jurisdiction_ = value;
          }
          onChanged();
        } else {
          if (jurisdictionCase_ == 4) {
            federalBuilder_.mergeFrom(value);
          }
          federalBuilder_.setMessage(value);
        }
        jurisdictionCase_ = 4;
        return this;
      }
      /**
       * <pre>
       * Federal tax jurisdiction information.
       * </pre>
       *
       * <code>.opencannabis.taxes.FederalTax federal = 4;</code>
       */
      public Builder clearFederal() {
        if (federalBuilder_ == null) {
          if (jurisdictionCase_ == 4) {
            jurisdictionCase_ = 0;
            jurisdiction_ = null;
            onChanged();
          }
        } else {
          if (jurisdictionCase_ == 4) {
            jurisdictionCase_ = 0;
            jurisdiction_ = null;
          }
          federalBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Federal tax jurisdiction information.
       * </pre>
       *
       * <code>.opencannabis.taxes.FederalTax federal = 4;</code>
       */
      public io.opencannabis.schema.accounting.AccountingTaxes.FederalTax.Builder getFederalBuilder() {
        return getFederalFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Federal tax jurisdiction information.
       * </pre>
       *
       * <code>.opencannabis.taxes.FederalTax federal = 4;</code>
       */
      public io.opencannabis.schema.accounting.AccountingTaxes.FederalTaxOrBuilder getFederalOrBuilder() {
        if ((jurisdictionCase_ == 4) && (federalBuilder_ != null)) {
          return federalBuilder_.getMessageOrBuilder();
        } else {
          if (jurisdictionCase_ == 4) {
            return (io.opencannabis.schema.accounting.AccountingTaxes.FederalTax) jurisdiction_;
          }
          return io.opencannabis.schema.accounting.AccountingTaxes.FederalTax.getDefaultInstance();
        }
      }
      /**
       * <pre>
       * Federal tax jurisdiction information.
       * </pre>
       *
       * <code>.opencannabis.taxes.FederalTax federal = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.accounting.AccountingTaxes.FederalTax, io.opencannabis.schema.accounting.AccountingTaxes.FederalTax.Builder, io.opencannabis.schema.accounting.AccountingTaxes.FederalTaxOrBuilder> 
          getFederalFieldBuilder() {
        if (federalBuilder_ == null) {
          if (!(jurisdictionCase_ == 4)) {
            jurisdiction_ = io.opencannabis.schema.accounting.AccountingTaxes.FederalTax.getDefaultInstance();
          }
          federalBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.accounting.AccountingTaxes.FederalTax, io.opencannabis.schema.accounting.AccountingTaxes.FederalTax.Builder, io.opencannabis.schema.accounting.AccountingTaxes.FederalTaxOrBuilder>(
                  (io.opencannabis.schema.accounting.AccountingTaxes.FederalTax) jurisdiction_,
                  getParentForChildren(),
                  isClean());
          jurisdiction_ = null;
        }
        jurisdictionCase_ = 4;
        onChanged();;
        return federalBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:opencannabis.taxes.TaxJurisdiction)
    }

    // @@protoc_insertion_point(class_scope:opencannabis.taxes.TaxJurisdiction)
    private static final io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction();
    }

    public static io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TaxJurisdiction>
        PARSER = new com.google.protobuf.AbstractParser<TaxJurisdiction>() {
      public TaxJurisdiction parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new TaxJurisdiction(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<TaxJurisdiction> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TaxJurisdiction> getParserForType() {
      return PARSER;
    }

    public io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface TaxSpecOrBuilder extends
      // @@protoc_insertion_point(interface_extends:opencannabis.taxes.TaxSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * The basis to calculate the tax value from.
     * </pre>
     *
     * <code>.opencannabis.taxes.TaxBasis basis = 1;</code>
     */
    int getBasisValue();
    /**
     * <pre>
     * The basis to calculate the tax value from.
     * </pre>
     *
     * <code>.opencannabis.taxes.TaxBasis basis = 1;</code>
     */
    io.opencannabis.schema.accounting.AccountingTaxes.TaxBasis getBasis();

    /**
     * <pre>
     * Jurisdiction that is levying the tax.
     * </pre>
     *
     * <code>.opencannabis.taxes.TaxJurisdiction jurisdiction = 2;</code>
     */
    boolean hasJurisdiction();
    /**
     * <pre>
     * Jurisdiction that is levying the tax.
     * </pre>
     *
     * <code>.opencannabis.taxes.TaxJurisdiction jurisdiction = 2;</code>
     */
    io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction getJurisdiction();
    /**
     * <pre>
     * Jurisdiction that is levying the tax.
     * </pre>
     *
     * <code>.opencannabis.taxes.TaxJurisdiction jurisdiction = 2;</code>
     */
    io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdictionOrBuilder getJurisdictionOrBuilder();

    /**
     * <pre>
     * What to call this tax on receipts, and other end-user-visible materials.
     * </pre>
     *
     * <code>string transaction_label = 3;</code>
     */
    java.lang.String getTransactionLabel();
    /**
     * <pre>
     * What to call this tax on receipts, and other end-user-visible materials.
     * </pre>
     *
     * <code>string transaction_label = 3;</code>
     */
    com.google.protobuf.ByteString
        getTransactionLabelBytes();

    /**
     * <pre>
     * Percentage rate for the tax.
     * </pre>
     *
     * <code>double percentage = 4;</code>
     */
    double getPercentage();

    /**
     * <pre>
     * Flat rate for the tax.
     * </pre>
     *
     * <code>double static_value = 5;</code>
     */
    double getStaticValue();

    public io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec.RateCase getRateCase();
  }
  /**
   * <pre>
   * Specification record for a type of taxes to apply.
   * </pre>
   *
   * Protobuf type {@code opencannabis.taxes.TaxSpec}
   */
  public  static final class TaxSpec extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:opencannabis.taxes.TaxSpec)
      TaxSpecOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use TaxSpec.newBuilder() to construct.
    private TaxSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private TaxSpec() {
      basis_ = 0;
      transactionLabel_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private TaxSpec(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();

              basis_ = rawValue;
              break;
            }
            case 18: {
              io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction.Builder subBuilder = null;
              if (jurisdiction_ != null) {
                subBuilder = jurisdiction_.toBuilder();
              }
              jurisdiction_ = input.readMessage(io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(jurisdiction_);
                jurisdiction_ = subBuilder.buildPartial();
              }

              break;
            }
            case 26: {
              java.lang.String s = input.readStringRequireUtf8();

              transactionLabel_ = s;
              break;
            }
            case 33: {
              rateCase_ = 4;
              rate_ = input.readDouble();
              break;
            }
            case 41: {
              rateCase_ = 5;
              rate_ = input.readDouble();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.accounting.AccountingTaxes.internal_static_opencannabis_taxes_TaxSpec_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.accounting.AccountingTaxes.internal_static_opencannabis_taxes_TaxSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec.class, io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec.Builder.class);
    }

    private int rateCase_ = 0;
    private java.lang.Object rate_;
    public enum RateCase
        implements com.google.protobuf.Internal.EnumLite {
      PERCENTAGE(4),
      STATIC_VALUE(5),
      RATE_NOT_SET(0);
      private final int value;
      private RateCase(int value) {
        this.value = value;
      }
      /**
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static RateCase valueOf(int value) {
        return forNumber(value);
      }

      public static RateCase forNumber(int value) {
        switch (value) {
          case 4: return PERCENTAGE;
          case 5: return STATIC_VALUE;
          case 0: return RATE_NOT_SET;
          default: return null;
        }
      }
      public int getNumber() {
        return this.value;
      }
    };

    public RateCase
    getRateCase() {
      return RateCase.forNumber(
          rateCase_);
    }

    public static final int BASIS_FIELD_NUMBER = 1;
    private int basis_;
    /**
     * <pre>
     * The basis to calculate the tax value from.
     * </pre>
     *
     * <code>.opencannabis.taxes.TaxBasis basis = 1;</code>
     */
    public int getBasisValue() {
      return basis_;
    }
    /**
     * <pre>
     * The basis to calculate the tax value from.
     * </pre>
     *
     * <code>.opencannabis.taxes.TaxBasis basis = 1;</code>
     */
    public io.opencannabis.schema.accounting.AccountingTaxes.TaxBasis getBasis() {
      io.opencannabis.schema.accounting.AccountingTaxes.TaxBasis result = io.opencannabis.schema.accounting.AccountingTaxes.TaxBasis.valueOf(basis_);
      return result == null ? io.opencannabis.schema.accounting.AccountingTaxes.TaxBasis.UNRECOGNIZED : result;
    }

    public static final int JURISDICTION_FIELD_NUMBER = 2;
    private io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction jurisdiction_;
    /**
     * <pre>
     * Jurisdiction that is levying the tax.
     * </pre>
     *
     * <code>.opencannabis.taxes.TaxJurisdiction jurisdiction = 2;</code>
     */
    public boolean hasJurisdiction() {
      return jurisdiction_ != null;
    }
    /**
     * <pre>
     * Jurisdiction that is levying the tax.
     * </pre>
     *
     * <code>.opencannabis.taxes.TaxJurisdiction jurisdiction = 2;</code>
     */
    public io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction getJurisdiction() {
      return jurisdiction_ == null ? io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction.getDefaultInstance() : jurisdiction_;
    }
    /**
     * <pre>
     * Jurisdiction that is levying the tax.
     * </pre>
     *
     * <code>.opencannabis.taxes.TaxJurisdiction jurisdiction = 2;</code>
     */
    public io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdictionOrBuilder getJurisdictionOrBuilder() {
      return getJurisdiction();
    }

    public static final int TRANSACTION_LABEL_FIELD_NUMBER = 3;
    private volatile java.lang.Object transactionLabel_;
    /**
     * <pre>
     * What to call this tax on receipts, and other end-user-visible materials.
     * </pre>
     *
     * <code>string transaction_label = 3;</code>
     */
    public java.lang.String getTransactionLabel() {
      java.lang.Object ref = transactionLabel_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        transactionLabel_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * What to call this tax on receipts, and other end-user-visible materials.
     * </pre>
     *
     * <code>string transaction_label = 3;</code>
     */
    public com.google.protobuf.ByteString
        getTransactionLabelBytes() {
      java.lang.Object ref = transactionLabel_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        transactionLabel_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PERCENTAGE_FIELD_NUMBER = 4;
    /**
     * <pre>
     * Percentage rate for the tax.
     * </pre>
     *
     * <code>double percentage = 4;</code>
     */
    public double getPercentage() {
      if (rateCase_ == 4) {
        return (java.lang.Double) rate_;
      }
      return 0D;
    }

    public static final int STATIC_VALUE_FIELD_NUMBER = 5;
    /**
     * <pre>
     * Flat rate for the tax.
     * </pre>
     *
     * <code>double static_value = 5;</code>
     */
    public double getStaticValue() {
      if (rateCase_ == 5) {
        return (java.lang.Double) rate_;
      }
      return 0D;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (basis_ != io.opencannabis.schema.accounting.AccountingTaxes.TaxBasis.ITEM.getNumber()) {
        output.writeEnum(1, basis_);
      }
      if (jurisdiction_ != null) {
        output.writeMessage(2, getJurisdiction());
      }
      if (!getTransactionLabelBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, transactionLabel_);
      }
      if (rateCase_ == 4) {
        output.writeDouble(
            4, (double)((java.lang.Double) rate_));
      }
      if (rateCase_ == 5) {
        output.writeDouble(
            5, (double)((java.lang.Double) rate_));
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (basis_ != io.opencannabis.schema.accounting.AccountingTaxes.TaxBasis.ITEM.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, basis_);
      }
      if (jurisdiction_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getJurisdiction());
      }
      if (!getTransactionLabelBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, transactionLabel_);
      }
      if (rateCase_ == 4) {
        size += com.google.protobuf.CodedOutputStream
          .computeDoubleSize(
              4, (double)((java.lang.Double) rate_));
      }
      if (rateCase_ == 5) {
        size += com.google.protobuf.CodedOutputStream
          .computeDoubleSize(
              5, (double)((java.lang.Double) rate_));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec)) {
        return super.equals(obj);
      }
      io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec other = (io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec) obj;

      boolean result = true;
      result = result && basis_ == other.basis_;
      result = result && (hasJurisdiction() == other.hasJurisdiction());
      if (hasJurisdiction()) {
        result = result && getJurisdiction()
            .equals(other.getJurisdiction());
      }
      result = result && getTransactionLabel()
          .equals(other.getTransactionLabel());
      result = result && getRateCase().equals(
          other.getRateCase());
      if (!result) return false;
      switch (rateCase_) {
        case 4:
          result = result && (
              java.lang.Double.doubleToLongBits(getPercentage())
              == java.lang.Double.doubleToLongBits(
                  other.getPercentage()));
          break;
        case 5:
          result = result && (
              java.lang.Double.doubleToLongBits(getStaticValue())
              == java.lang.Double.doubleToLongBits(
                  other.getStaticValue()));
          break;
        case 0:
        default:
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + BASIS_FIELD_NUMBER;
      hash = (53 * hash) + basis_;
      if (hasJurisdiction()) {
        hash = (37 * hash) + JURISDICTION_FIELD_NUMBER;
        hash = (53 * hash) + getJurisdiction().hashCode();
      }
      hash = (37 * hash) + TRANSACTION_LABEL_FIELD_NUMBER;
      hash = (53 * hash) + getTransactionLabel().hashCode();
      switch (rateCase_) {
        case 4:
          hash = (37 * hash) + PERCENTAGE_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
              java.lang.Double.doubleToLongBits(getPercentage()));
          break;
        case 5:
          hash = (37 * hash) + STATIC_VALUE_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
              java.lang.Double.doubleToLongBits(getStaticValue()));
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specification record for a type of taxes to apply.
     * </pre>
     *
     * Protobuf type {@code opencannabis.taxes.TaxSpec}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:opencannabis.taxes.TaxSpec)
        io.opencannabis.schema.accounting.AccountingTaxes.TaxSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.opencannabis.schema.accounting.AccountingTaxes.internal_static_opencannabis_taxes_TaxSpec_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.opencannabis.schema.accounting.AccountingTaxes.internal_static_opencannabis_taxes_TaxSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec.class, io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec.Builder.class);
      }

      // Construct using io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        basis_ = 0;

        if (jurisdictionBuilder_ == null) {
          jurisdiction_ = null;
        } else {
          jurisdiction_ = null;
          jurisdictionBuilder_ = null;
        }
        transactionLabel_ = "";

        rateCase_ = 0;
        rate_ = null;
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.opencannabis.schema.accounting.AccountingTaxes.internal_static_opencannabis_taxes_TaxSpec_descriptor;
      }

      public io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec getDefaultInstanceForType() {
        return io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec.getDefaultInstance();
      }

      public io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec build() {
        io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec buildPartial() {
        io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec result = new io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec(this);
        result.basis_ = basis_;
        if (jurisdictionBuilder_ == null) {
          result.jurisdiction_ = jurisdiction_;
        } else {
          result.jurisdiction_ = jurisdictionBuilder_.build();
        }
        result.transactionLabel_ = transactionLabel_;
        if (rateCase_ == 4) {
          result.rate_ = rate_;
        }
        if (rateCase_ == 5) {
          result.rate_ = rate_;
        }
        result.rateCase_ = rateCase_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec) {
          return mergeFrom((io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec other) {
        if (other == io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec.getDefaultInstance()) return this;
        if (other.basis_ != 0) {
          setBasisValue(other.getBasisValue());
        }
        if (other.hasJurisdiction()) {
          mergeJurisdiction(other.getJurisdiction());
        }
        if (!other.getTransactionLabel().isEmpty()) {
          transactionLabel_ = other.transactionLabel_;
          onChanged();
        }
        switch (other.getRateCase()) {
          case PERCENTAGE: {
            setPercentage(other.getPercentage());
            break;
          }
          case STATIC_VALUE: {
            setStaticValue(other.getStaticValue());
            break;
          }
          case RATE_NOT_SET: {
            break;
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int rateCase_ = 0;
      private java.lang.Object rate_;
      public RateCase
          getRateCase() {
        return RateCase.forNumber(
            rateCase_);
      }

      public Builder clearRate() {
        rateCase_ = 0;
        rate_ = null;
        onChanged();
        return this;
      }


      private int basis_ = 0;
      /**
       * <pre>
       * The basis to calculate the tax value from.
       * </pre>
       *
       * <code>.opencannabis.taxes.TaxBasis basis = 1;</code>
       */
      public int getBasisValue() {
        return basis_;
      }
      /**
       * <pre>
       * The basis to calculate the tax value from.
       * </pre>
       *
       * <code>.opencannabis.taxes.TaxBasis basis = 1;</code>
       */
      public Builder setBasisValue(int value) {
        basis_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The basis to calculate the tax value from.
       * </pre>
       *
       * <code>.opencannabis.taxes.TaxBasis basis = 1;</code>
       */
      public io.opencannabis.schema.accounting.AccountingTaxes.TaxBasis getBasis() {
        io.opencannabis.schema.accounting.AccountingTaxes.TaxBasis result = io.opencannabis.schema.accounting.AccountingTaxes.TaxBasis.valueOf(basis_);
        return result == null ? io.opencannabis.schema.accounting.AccountingTaxes.TaxBasis.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * The basis to calculate the tax value from.
       * </pre>
       *
       * <code>.opencannabis.taxes.TaxBasis basis = 1;</code>
       */
      public Builder setBasis(io.opencannabis.schema.accounting.AccountingTaxes.TaxBasis value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        basis_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The basis to calculate the tax value from.
       * </pre>
       *
       * <code>.opencannabis.taxes.TaxBasis basis = 1;</code>
       */
      public Builder clearBasis() {
        
        basis_ = 0;
        onChanged();
        return this;
      }

      private io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction jurisdiction_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction, io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction.Builder, io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdictionOrBuilder> jurisdictionBuilder_;
      /**
       * <pre>
       * Jurisdiction that is levying the tax.
       * </pre>
       *
       * <code>.opencannabis.taxes.TaxJurisdiction jurisdiction = 2;</code>
       */
      public boolean hasJurisdiction() {
        return jurisdictionBuilder_ != null || jurisdiction_ != null;
      }
      /**
       * <pre>
       * Jurisdiction that is levying the tax.
       * </pre>
       *
       * <code>.opencannabis.taxes.TaxJurisdiction jurisdiction = 2;</code>
       */
      public io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction getJurisdiction() {
        if (jurisdictionBuilder_ == null) {
          return jurisdiction_ == null ? io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction.getDefaultInstance() : jurisdiction_;
        } else {
          return jurisdictionBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Jurisdiction that is levying the tax.
       * </pre>
       *
       * <code>.opencannabis.taxes.TaxJurisdiction jurisdiction = 2;</code>
       */
      public Builder setJurisdiction(io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction value) {
        if (jurisdictionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          jurisdiction_ = value;
          onChanged();
        } else {
          jurisdictionBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Jurisdiction that is levying the tax.
       * </pre>
       *
       * <code>.opencannabis.taxes.TaxJurisdiction jurisdiction = 2;</code>
       */
      public Builder setJurisdiction(
          io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction.Builder builderForValue) {
        if (jurisdictionBuilder_ == null) {
          jurisdiction_ = builderForValue.build();
          onChanged();
        } else {
          jurisdictionBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Jurisdiction that is levying the tax.
       * </pre>
       *
       * <code>.opencannabis.taxes.TaxJurisdiction jurisdiction = 2;</code>
       */
      public Builder mergeJurisdiction(io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction value) {
        if (jurisdictionBuilder_ == null) {
          if (jurisdiction_ != null) {
            jurisdiction_ =
              io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction.newBuilder(jurisdiction_).mergeFrom(value).buildPartial();
          } else {
            jurisdiction_ = value;
          }
          onChanged();
        } else {
          jurisdictionBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Jurisdiction that is levying the tax.
       * </pre>
       *
       * <code>.opencannabis.taxes.TaxJurisdiction jurisdiction = 2;</code>
       */
      public Builder clearJurisdiction() {
        if (jurisdictionBuilder_ == null) {
          jurisdiction_ = null;
          onChanged();
        } else {
          jurisdiction_ = null;
          jurisdictionBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Jurisdiction that is levying the tax.
       * </pre>
       *
       * <code>.opencannabis.taxes.TaxJurisdiction jurisdiction = 2;</code>
       */
      public io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction.Builder getJurisdictionBuilder() {
        
        onChanged();
        return getJurisdictionFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Jurisdiction that is levying the tax.
       * </pre>
       *
       * <code>.opencannabis.taxes.TaxJurisdiction jurisdiction = 2;</code>
       */
      public io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdictionOrBuilder getJurisdictionOrBuilder() {
        if (jurisdictionBuilder_ != null) {
          return jurisdictionBuilder_.getMessageOrBuilder();
        } else {
          return jurisdiction_ == null ?
              io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction.getDefaultInstance() : jurisdiction_;
        }
      }
      /**
       * <pre>
       * Jurisdiction that is levying the tax.
       * </pre>
       *
       * <code>.opencannabis.taxes.TaxJurisdiction jurisdiction = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction, io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction.Builder, io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdictionOrBuilder> 
          getJurisdictionFieldBuilder() {
        if (jurisdictionBuilder_ == null) {
          jurisdictionBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction, io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdiction.Builder, io.opencannabis.schema.accounting.AccountingTaxes.TaxJurisdictionOrBuilder>(
                  getJurisdiction(),
                  getParentForChildren(),
                  isClean());
          jurisdiction_ = null;
        }
        return jurisdictionBuilder_;
      }

      private java.lang.Object transactionLabel_ = "";
      /**
       * <pre>
       * What to call this tax on receipts, and other end-user-visible materials.
       * </pre>
       *
       * <code>string transaction_label = 3;</code>
       */
      public java.lang.String getTransactionLabel() {
        java.lang.Object ref = transactionLabel_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          transactionLabel_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * What to call this tax on receipts, and other end-user-visible materials.
       * </pre>
       *
       * <code>string transaction_label = 3;</code>
       */
      public com.google.protobuf.ByteString
          getTransactionLabelBytes() {
        java.lang.Object ref = transactionLabel_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          transactionLabel_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * What to call this tax on receipts, and other end-user-visible materials.
       * </pre>
       *
       * <code>string transaction_label = 3;</code>
       */
      public Builder setTransactionLabel(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        transactionLabel_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * What to call this tax on receipts, and other end-user-visible materials.
       * </pre>
       *
       * <code>string transaction_label = 3;</code>
       */
      public Builder clearTransactionLabel() {
        
        transactionLabel_ = getDefaultInstance().getTransactionLabel();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * What to call this tax on receipts, and other end-user-visible materials.
       * </pre>
       *
       * <code>string transaction_label = 3;</code>
       */
      public Builder setTransactionLabelBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        transactionLabel_ = value;
        onChanged();
        return this;
      }

      /**
       * <pre>
       * Percentage rate for the tax.
       * </pre>
       *
       * <code>double percentage = 4;</code>
       */
      public double getPercentage() {
        if (rateCase_ == 4) {
          return (java.lang.Double) rate_;
        }
        return 0D;
      }
      /**
       * <pre>
       * Percentage rate for the tax.
       * </pre>
       *
       * <code>double percentage = 4;</code>
       */
      public Builder setPercentage(double value) {
        rateCase_ = 4;
        rate_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Percentage rate for the tax.
       * </pre>
       *
       * <code>double percentage = 4;</code>
       */
      public Builder clearPercentage() {
        if (rateCase_ == 4) {
          rateCase_ = 0;
          rate_ = null;
          onChanged();
        }
        return this;
      }

      /**
       * <pre>
       * Flat rate for the tax.
       * </pre>
       *
       * <code>double static_value = 5;</code>
       */
      public double getStaticValue() {
        if (rateCase_ == 5) {
          return (java.lang.Double) rate_;
        }
        return 0D;
      }
      /**
       * <pre>
       * Flat rate for the tax.
       * </pre>
       *
       * <code>double static_value = 5;</code>
       */
      public Builder setStaticValue(double value) {
        rateCase_ = 5;
        rate_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Flat rate for the tax.
       * </pre>
       *
       * <code>double static_value = 5;</code>
       */
      public Builder clearStaticValue() {
        if (rateCase_ == 5) {
          rateCase_ = 0;
          rate_ = null;
          onChanged();
        }
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:opencannabis.taxes.TaxSpec)
    }

    // @@protoc_insertion_point(class_scope:opencannabis.taxes.TaxSpec)
    private static final io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec();
    }

    public static io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TaxSpec>
        PARSER = new com.google.protobuf.AbstractParser<TaxSpec>() {
      public TaxSpec parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new TaxSpec(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<TaxSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TaxSpec> getParserForType() {
      return PARSER;
    }

    public io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface TaxOrBuilder extends
      // @@protoc_insertion_point(interface_extends:opencannabis.taxes.Tax)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * ID code for this tax entry.
     * </pre>
     *
     * <code>string id = 1;</code>
     */
    java.lang.String getId();
    /**
     * <pre>
     * ID code for this tax entry.
     * </pre>
     *
     * <code>string id = 1;</code>
     */
    com.google.protobuf.ByteString
        getIdBytes();

    /**
     * <pre>
     * Specification for how the tax behaves.
     * </pre>
     *
     * <code>.opencannabis.taxes.TaxSpec spec = 2;</code>
     */
    boolean hasSpec();
    /**
     * <pre>
     * Specification for how the tax behaves.
     * </pre>
     *
     * <code>.opencannabis.taxes.TaxSpec spec = 2;</code>
     */
    io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec getSpec();
    /**
     * <pre>
     * Specification for how the tax behaves.
     * </pre>
     *
     * <code>.opencannabis.taxes.TaxSpec spec = 2;</code>
     */
    io.opencannabis.schema.accounting.AccountingTaxes.TaxSpecOrBuilder getSpecOrBuilder();

    /**
     * <pre>
     * Back-office name for this tax.
     * </pre>
     *
     * <code>string name = 3;</code>
     */
    java.lang.String getName();
    /**
     * <pre>
     * Back-office name for this tax.
     * </pre>
     *
     * <code>string name = 3;</code>
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <pre>
     * User-visible name for this tax.
     * </pre>
     *
     * <code>string label = 4;</code>
     */
    java.lang.String getLabel();
    /**
     * <pre>
     * User-visible name for this tax.
     * </pre>
     *
     * <code>string label = 4;</code>
     */
    com.google.protobuf.ByteString
        getLabelBytes();

    /**
     * <pre>
     * Narrative description for the tax, to be displayed to back-office and end-users in some
     * special circumstances.
     * </pre>
     *
     * <code>string description = 5;</code>
     */
    java.lang.String getDescription();
    /**
     * <pre>
     * Narrative description for the tax, to be displayed to back-office and end-users in some
     * special circumstances.
     * </pre>
     *
     * <code>string description = 5;</code>
     */
    com.google.protobuf.ByteString
        getDescriptionBytes();
  }
  /**
   * <pre>
   * Specifies a tax to be applied during a purchase.
   * </pre>
   *
   * Protobuf type {@code opencannabis.taxes.Tax}
   */
  public  static final class Tax extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:opencannabis.taxes.Tax)
      TaxOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Tax.newBuilder() to construct.
    private Tax(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Tax() {
      id_ = "";
      name_ = "";
      label_ = "";
      description_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Tax(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              id_ = s;
              break;
            }
            case 18: {
              io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec.Builder subBuilder = null;
              if (spec_ != null) {
                subBuilder = spec_.toBuilder();
              }
              spec_ = input.readMessage(io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(spec_);
                spec_ = subBuilder.buildPartial();
              }

              break;
            }
            case 26: {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
            case 34: {
              java.lang.String s = input.readStringRequireUtf8();

              label_ = s;
              break;
            }
            case 42: {
              java.lang.String s = input.readStringRequireUtf8();

              description_ = s;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.accounting.AccountingTaxes.internal_static_opencannabis_taxes_Tax_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.accounting.AccountingTaxes.internal_static_opencannabis_taxes_Tax_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.accounting.AccountingTaxes.Tax.class, io.opencannabis.schema.accounting.AccountingTaxes.Tax.Builder.class);
    }

    public static final int ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object id_;
    /**
     * <pre>
     * ID code for this tax entry.
     * </pre>
     *
     * <code>string id = 1;</code>
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * ID code for this tax entry.
     * </pre>
     *
     * <code>string id = 1;</code>
     */
    public com.google.protobuf.ByteString
        getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SPEC_FIELD_NUMBER = 2;
    private io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec spec_;
    /**
     * <pre>
     * Specification for how the tax behaves.
     * </pre>
     *
     * <code>.opencannabis.taxes.TaxSpec spec = 2;</code>
     */
    public boolean hasSpec() {
      return spec_ != null;
    }
    /**
     * <pre>
     * Specification for how the tax behaves.
     * </pre>
     *
     * <code>.opencannabis.taxes.TaxSpec spec = 2;</code>
     */
    public io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec getSpec() {
      return spec_ == null ? io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec.getDefaultInstance() : spec_;
    }
    /**
     * <pre>
     * Specification for how the tax behaves.
     * </pre>
     *
     * <code>.opencannabis.taxes.TaxSpec spec = 2;</code>
     */
    public io.opencannabis.schema.accounting.AccountingTaxes.TaxSpecOrBuilder getSpecOrBuilder() {
      return getSpec();
    }

    public static final int NAME_FIELD_NUMBER = 3;
    private volatile java.lang.Object name_;
    /**
     * <pre>
     * Back-office name for this tax.
     * </pre>
     *
     * <code>string name = 3;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Back-office name for this tax.
     * </pre>
     *
     * <code>string name = 3;</code>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LABEL_FIELD_NUMBER = 4;
    private volatile java.lang.Object label_;
    /**
     * <pre>
     * User-visible name for this tax.
     * </pre>
     *
     * <code>string label = 4;</code>
     */
    public java.lang.String getLabel() {
      java.lang.Object ref = label_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        label_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * User-visible name for this tax.
     * </pre>
     *
     * <code>string label = 4;</code>
     */
    public com.google.protobuf.ByteString
        getLabelBytes() {
      java.lang.Object ref = label_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        label_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DESCRIPTION_FIELD_NUMBER = 5;
    private volatile java.lang.Object description_;
    /**
     * <pre>
     * Narrative description for the tax, to be displayed to back-office and end-users in some
     * special circumstances.
     * </pre>
     *
     * <code>string description = 5;</code>
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Narrative description for the tax, to be displayed to back-office and end-users in some
     * special circumstances.
     * </pre>
     *
     * <code>string description = 5;</code>
     */
    public com.google.protobuf.ByteString
        getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
      }
      if (spec_ != null) {
        output.writeMessage(2, getSpec());
      }
      if (!getNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, name_);
      }
      if (!getLabelBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, label_);
      }
      if (!getDescriptionBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, description_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
      }
      if (spec_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getSpec());
      }
      if (!getNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, name_);
      }
      if (!getLabelBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, label_);
      }
      if (!getDescriptionBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, description_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.opencannabis.schema.accounting.AccountingTaxes.Tax)) {
        return super.equals(obj);
      }
      io.opencannabis.schema.accounting.AccountingTaxes.Tax other = (io.opencannabis.schema.accounting.AccountingTaxes.Tax) obj;

      boolean result = true;
      result = result && getId()
          .equals(other.getId());
      result = result && (hasSpec() == other.hasSpec());
      if (hasSpec()) {
        result = result && getSpec()
            .equals(other.getSpec());
      }
      result = result && getName()
          .equals(other.getName());
      result = result && getLabel()
          .equals(other.getLabel());
      result = result && getDescription()
          .equals(other.getDescription());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + getId().hashCode();
      if (hasSpec()) {
        hash = (37 * hash) + SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getSpec().hashCode();
      }
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + LABEL_FIELD_NUMBER;
      hash = (53 * hash) + getLabel().hashCode();
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.opencannabis.schema.accounting.AccountingTaxes.Tax parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.Tax parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.Tax parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.Tax parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.Tax parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.Tax parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.Tax parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.Tax parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.Tax parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.Tax parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.Tax parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.accounting.AccountingTaxes.Tax parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.opencannabis.schema.accounting.AccountingTaxes.Tax prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies a tax to be applied during a purchase.
     * </pre>
     *
     * Protobuf type {@code opencannabis.taxes.Tax}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:opencannabis.taxes.Tax)
        io.opencannabis.schema.accounting.AccountingTaxes.TaxOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.opencannabis.schema.accounting.AccountingTaxes.internal_static_opencannabis_taxes_Tax_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.opencannabis.schema.accounting.AccountingTaxes.internal_static_opencannabis_taxes_Tax_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.opencannabis.schema.accounting.AccountingTaxes.Tax.class, io.opencannabis.schema.accounting.AccountingTaxes.Tax.Builder.class);
      }

      // Construct using io.opencannabis.schema.accounting.AccountingTaxes.Tax.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        id_ = "";

        if (specBuilder_ == null) {
          spec_ = null;
        } else {
          spec_ = null;
          specBuilder_ = null;
        }
        name_ = "";

        label_ = "";

        description_ = "";

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.opencannabis.schema.accounting.AccountingTaxes.internal_static_opencannabis_taxes_Tax_descriptor;
      }

      public io.opencannabis.schema.accounting.AccountingTaxes.Tax getDefaultInstanceForType() {
        return io.opencannabis.schema.accounting.AccountingTaxes.Tax.getDefaultInstance();
      }

      public io.opencannabis.schema.accounting.AccountingTaxes.Tax build() {
        io.opencannabis.schema.accounting.AccountingTaxes.Tax result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.opencannabis.schema.accounting.AccountingTaxes.Tax buildPartial() {
        io.opencannabis.schema.accounting.AccountingTaxes.Tax result = new io.opencannabis.schema.accounting.AccountingTaxes.Tax(this);
        result.id_ = id_;
        if (specBuilder_ == null) {
          result.spec_ = spec_;
        } else {
          result.spec_ = specBuilder_.build();
        }
        result.name_ = name_;
        result.label_ = label_;
        result.description_ = description_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.opencannabis.schema.accounting.AccountingTaxes.Tax) {
          return mergeFrom((io.opencannabis.schema.accounting.AccountingTaxes.Tax)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.opencannabis.schema.accounting.AccountingTaxes.Tax other) {
        if (other == io.opencannabis.schema.accounting.AccountingTaxes.Tax.getDefaultInstance()) return this;
        if (!other.getId().isEmpty()) {
          id_ = other.id_;
          onChanged();
        }
        if (other.hasSpec()) {
          mergeSpec(other.getSpec());
        }
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          onChanged();
        }
        if (!other.getLabel().isEmpty()) {
          label_ = other.label_;
          onChanged();
        }
        if (!other.getDescription().isEmpty()) {
          description_ = other.description_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.opencannabis.schema.accounting.AccountingTaxes.Tax parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.opencannabis.schema.accounting.AccountingTaxes.Tax) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object id_ = "";
      /**
       * <pre>
       * ID code for this tax entry.
       * </pre>
       *
       * <code>string id = 1;</code>
       */
      public java.lang.String getId() {
        java.lang.Object ref = id_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          id_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * ID code for this tax entry.
       * </pre>
       *
       * <code>string id = 1;</code>
       */
      public com.google.protobuf.ByteString
          getIdBytes() {
        java.lang.Object ref = id_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          id_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * ID code for this tax entry.
       * </pre>
       *
       * <code>string id = 1;</code>
       */
      public Builder setId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        id_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * ID code for this tax entry.
       * </pre>
       *
       * <code>string id = 1;</code>
       */
      public Builder clearId() {
        
        id_ = getDefaultInstance().getId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * ID code for this tax entry.
       * </pre>
       *
       * <code>string id = 1;</code>
       */
      public Builder setIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        id_ = value;
        onChanged();
        return this;
      }

      private io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec spec_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec, io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec.Builder, io.opencannabis.schema.accounting.AccountingTaxes.TaxSpecOrBuilder> specBuilder_;
      /**
       * <pre>
       * Specification for how the tax behaves.
       * </pre>
       *
       * <code>.opencannabis.taxes.TaxSpec spec = 2;</code>
       */
      public boolean hasSpec() {
        return specBuilder_ != null || spec_ != null;
      }
      /**
       * <pre>
       * Specification for how the tax behaves.
       * </pre>
       *
       * <code>.opencannabis.taxes.TaxSpec spec = 2;</code>
       */
      public io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec getSpec() {
        if (specBuilder_ == null) {
          return spec_ == null ? io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec.getDefaultInstance() : spec_;
        } else {
          return specBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Specification for how the tax behaves.
       * </pre>
       *
       * <code>.opencannabis.taxes.TaxSpec spec = 2;</code>
       */
      public Builder setSpec(io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec value) {
        if (specBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          spec_ = value;
          onChanged();
        } else {
          specBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specification for how the tax behaves.
       * </pre>
       *
       * <code>.opencannabis.taxes.TaxSpec spec = 2;</code>
       */
      public Builder setSpec(
          io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec.Builder builderForValue) {
        if (specBuilder_ == null) {
          spec_ = builderForValue.build();
          onChanged();
        } else {
          specBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Specification for how the tax behaves.
       * </pre>
       *
       * <code>.opencannabis.taxes.TaxSpec spec = 2;</code>
       */
      public Builder mergeSpec(io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec value) {
        if (specBuilder_ == null) {
          if (spec_ != null) {
            spec_ =
              io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec.newBuilder(spec_).mergeFrom(value).buildPartial();
          } else {
            spec_ = value;
          }
          onChanged();
        } else {
          specBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specification for how the tax behaves.
       * </pre>
       *
       * <code>.opencannabis.taxes.TaxSpec spec = 2;</code>
       */
      public Builder clearSpec() {
        if (specBuilder_ == null) {
          spec_ = null;
          onChanged();
        } else {
          spec_ = null;
          specBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Specification for how the tax behaves.
       * </pre>
       *
       * <code>.opencannabis.taxes.TaxSpec spec = 2;</code>
       */
      public io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec.Builder getSpecBuilder() {
        
        onChanged();
        return getSpecFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Specification for how the tax behaves.
       * </pre>
       *
       * <code>.opencannabis.taxes.TaxSpec spec = 2;</code>
       */
      public io.opencannabis.schema.accounting.AccountingTaxes.TaxSpecOrBuilder getSpecOrBuilder() {
        if (specBuilder_ != null) {
          return specBuilder_.getMessageOrBuilder();
        } else {
          return spec_ == null ?
              io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec.getDefaultInstance() : spec_;
        }
      }
      /**
       * <pre>
       * Specification for how the tax behaves.
       * </pre>
       *
       * <code>.opencannabis.taxes.TaxSpec spec = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec, io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec.Builder, io.opencannabis.schema.accounting.AccountingTaxes.TaxSpecOrBuilder> 
          getSpecFieldBuilder() {
        if (specBuilder_ == null) {
          specBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec, io.opencannabis.schema.accounting.AccountingTaxes.TaxSpec.Builder, io.opencannabis.schema.accounting.AccountingTaxes.TaxSpecOrBuilder>(
                  getSpec(),
                  getParentForChildren(),
                  isClean());
          spec_ = null;
        }
        return specBuilder_;
      }

      private java.lang.Object name_ = "";
      /**
       * <pre>
       * Back-office name for this tax.
       * </pre>
       *
       * <code>string name = 3;</code>
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Back-office name for this tax.
       * </pre>
       *
       * <code>string name = 3;</code>
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Back-office name for this tax.
       * </pre>
       *
       * <code>string name = 3;</code>
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        name_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Back-office name for this tax.
       * </pre>
       *
       * <code>string name = 3;</code>
       */
      public Builder clearName() {
        
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Back-office name for this tax.
       * </pre>
       *
       * <code>string name = 3;</code>
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        name_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object label_ = "";
      /**
       * <pre>
       * User-visible name for this tax.
       * </pre>
       *
       * <code>string label = 4;</code>
       */
      public java.lang.String getLabel() {
        java.lang.Object ref = label_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          label_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * User-visible name for this tax.
       * </pre>
       *
       * <code>string label = 4;</code>
       */
      public com.google.protobuf.ByteString
          getLabelBytes() {
        java.lang.Object ref = label_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          label_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * User-visible name for this tax.
       * </pre>
       *
       * <code>string label = 4;</code>
       */
      public Builder setLabel(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        label_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * User-visible name for this tax.
       * </pre>
       *
       * <code>string label = 4;</code>
       */
      public Builder clearLabel() {
        
        label_ = getDefaultInstance().getLabel();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * User-visible name for this tax.
       * </pre>
       *
       * <code>string label = 4;</code>
       */
      public Builder setLabelBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        label_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object description_ = "";
      /**
       * <pre>
       * Narrative description for the tax, to be displayed to back-office and end-users in some
       * special circumstances.
       * </pre>
       *
       * <code>string description = 5;</code>
       */
      public java.lang.String getDescription() {
        java.lang.Object ref = description_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          description_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Narrative description for the tax, to be displayed to back-office and end-users in some
       * special circumstances.
       * </pre>
       *
       * <code>string description = 5;</code>
       */
      public com.google.protobuf.ByteString
          getDescriptionBytes() {
        java.lang.Object ref = description_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          description_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Narrative description for the tax, to be displayed to back-office and end-users in some
       * special circumstances.
       * </pre>
       *
       * <code>string description = 5;</code>
       */
      public Builder setDescription(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        description_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Narrative description for the tax, to be displayed to back-office and end-users in some
       * special circumstances.
       * </pre>
       *
       * <code>string description = 5;</code>
       */
      public Builder clearDescription() {
        
        description_ = getDefaultInstance().getDescription();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Narrative description for the tax, to be displayed to back-office and end-users in some
       * special circumstances.
       * </pre>
       *
       * <code>string description = 5;</code>
       */
      public Builder setDescriptionBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        description_ = value;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:opencannabis.taxes.Tax)
    }

    // @@protoc_insertion_point(class_scope:opencannabis.taxes.Tax)
    private static final io.opencannabis.schema.accounting.AccountingTaxes.Tax DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.opencannabis.schema.accounting.AccountingTaxes.Tax();
    }

    public static io.opencannabis.schema.accounting.AccountingTaxes.Tax getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Tax>
        PARSER = new com.google.protobuf.AbstractParser<Tax>() {
      public Tax parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Tax(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Tax> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Tax> getParserForType() {
      return PARSER;
    }

    public io.opencannabis.schema.accounting.AccountingTaxes.Tax getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_opencannabis_taxes_LocalTax_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_opencannabis_taxes_LocalTax_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_opencannabis_taxes_ProvincialTax_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_opencannabis_taxes_ProvincialTax_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_opencannabis_taxes_FederalTax_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_opencannabis_taxes_FederalTax_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_opencannabis_taxes_TaxJurisdiction_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_opencannabis_taxes_TaxJurisdiction_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_opencannabis_taxes_TaxSpec_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_opencannabis_taxes_TaxSpec_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_opencannabis_taxes_Tax_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_opencannabis_taxes_Tax_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\026accounting/Taxes.proto\022\022opencannabis.t" +
      "axes\032\022geo/Province.proto\032\021geo/Country.pr" +
      "oto\"z\n\010LocalTax\022\024\n\014municipality\030\001 \001(\t\022,\n" +
      "\010province\030\002 \001(\0132\032.opencannabis.geo.Provi" +
      "nce\022*\n\007country\030\003 \001(\0132\031.opencannabis.geo." +
      "Country\"i\n\rProvincialTax\022,\n\010province\030\001 \001" +
      "(\0132\032.opencannabis.geo.Province\022*\n\007countr" +
      "y\030\002 \001(\0132\031.opencannabis.geo.Country\"8\n\nFe" +
      "deralTax\022*\n\007country\030\001 \001(\0132\031.opencannabis" +
      ".geo.Country\"\363\001\n\017TaxJurisdiction\0225\n\004mode" +
      "\030\001 \001(\0162\'.opencannabis.taxes.TaxJurisdict" +
      "ionMode\022-\n\005local\030\002 \001(\0132\034.opencannabis.ta" +
      "xes.LocalTaxH\000\0227\n\nprovincial\030\003 \001(\0132!.ope" +
      "ncannabis.taxes.ProvincialTaxH\000\0221\n\007feder" +
      "al\030\004 \001(\0132\036.opencannabis.taxes.FederalTax" +
      "H\000B\016\n\014jurisdiction\"\302\001\n\007TaxSpec\022+\n\005basis\030" +
      "\001 \001(\0162\034.opencannabis.taxes.TaxBasis\0229\n\014j" +
      "urisdiction\030\002 \001(\0132#.opencannabis.taxes.T" +
      "axJurisdiction\022\031\n\021transaction_label\030\003 \001(" +
      "\t\022\024\n\npercentage\030\004 \001(\001H\000\022\026\n\014static_value\030" +
      "\005 \001(\001H\000B\006\n\004rate\"n\n\003Tax\022\n\n\002id\030\001 \001(\t\022)\n\004sp" +
      "ec\030\002 \001(\0132\033.opencannabis.taxes.TaxSpec\022\014\n" +
      "\004name\030\003 \001(\t\022\r\n\005label\030\004 \001(\t\022\023\n\013descriptio" +
      "n\030\005 \001(\t*;\n\023TaxJurisdictionMode\022\t\n\005LOCAL\020" +
      "\000\022\014\n\010PROVINCE\020\001\022\013\n\007FEDERAL\020\002*9\n\010TaxBasis" +
      "\022\010\n\004ITEM\020\000\022\022\n\016ORDER_SUBTOTAL\020\001\022\017\n\013ORDER_" +
      "TOTAL\020\002B>\n!io.opencannabis.schema.accoun" +
      "tingB\017AccountingTaxesH\001P\000\242\002\003OCSb\006proto3"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          io.opencannabis.schema.geo.ProvinceOuterClass.getDescriptor(),
          io.opencannabis.schema.geo.CountryOuterClass.getDescriptor(),
        }, assigner);
    internal_static_opencannabis_taxes_LocalTax_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_opencannabis_taxes_LocalTax_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_opencannabis_taxes_LocalTax_descriptor,
        new java.lang.String[] { "Municipality", "Province", "Country", });
    internal_static_opencannabis_taxes_ProvincialTax_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_opencannabis_taxes_ProvincialTax_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_opencannabis_taxes_ProvincialTax_descriptor,
        new java.lang.String[] { "Province", "Country", });
    internal_static_opencannabis_taxes_FederalTax_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_opencannabis_taxes_FederalTax_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_opencannabis_taxes_FederalTax_descriptor,
        new java.lang.String[] { "Country", });
    internal_static_opencannabis_taxes_TaxJurisdiction_descriptor =
      getDescriptor().getMessageTypes().get(3);
    internal_static_opencannabis_taxes_TaxJurisdiction_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_opencannabis_taxes_TaxJurisdiction_descriptor,
        new java.lang.String[] { "Mode", "Local", "Provincial", "Federal", "Jurisdiction", });
    internal_static_opencannabis_taxes_TaxSpec_descriptor =
      getDescriptor().getMessageTypes().get(4);
    internal_static_opencannabis_taxes_TaxSpec_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_opencannabis_taxes_TaxSpec_descriptor,
        new java.lang.String[] { "Basis", "Jurisdiction", "TransactionLabel", "Percentage", "StaticValue", "Rate", });
    internal_static_opencannabis_taxes_Tax_descriptor =
      getDescriptor().getMessageTypes().get(5);
    internal_static_opencannabis_taxes_Tax_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_opencannabis_taxes_Tax_descriptor,
        new java.lang.String[] { "Id", "Spec", "Name", "Label", "Description", });
    io.opencannabis.schema.geo.ProvinceOuterClass.getDescriptor();
    io.opencannabis.schema.geo.CountryOuterClass.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
