/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: commerce/Discounts.proto

package io.opencannabis.schema.accounting;

public final class CommercialDiscounts {
  private CommercialDiscounts() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   * <pre>
   * Enumerates types of discounts that may be applied.
   * </pre>
   *
   * Protobuf enum {@code opencannabis.commerce.DiscountType}
   */
  public enum DiscountType
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Some custom discount applied at the time of purchase.
     * </pre>
     *
     * <code>CUSTOM = 0;</code>
     */
    CUSTOM(0),
    /**
     * <pre>
     * Statutorily-mandated discount, for instance, for medical-only patients.
     * </pre>
     *
     * <code>STATUTORY = 1;</code>
     */
    STATUTORY(1),
    /**
     * <pre>
     * Commercial discount, for instance, for vendors, brand ambassadors, and staff.
     * </pre>
     *
     * <code>COMMERCIAL = 2;</code>
     */
    COMMERCIAL(2),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * Some custom discount applied at the time of purchase.
     * </pre>
     *
     * <code>CUSTOM = 0;</code>
     */
    public static final int CUSTOM_VALUE = 0;
    /**
     * <pre>
     * Statutorily-mandated discount, for instance, for medical-only patients.
     * </pre>
     *
     * <code>STATUTORY = 1;</code>
     */
    public static final int STATUTORY_VALUE = 1;
    /**
     * <pre>
     * Commercial discount, for instance, for vendors, brand ambassadors, and staff.
     * </pre>
     *
     * <code>COMMERCIAL = 2;</code>
     */
    public static final int COMMERCIAL_VALUE = 2;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DiscountType valueOf(int value) {
      return forNumber(value);
    }

    public static DiscountType forNumber(int value) {
      switch (value) {
        case 0: return CUSTOM;
        case 1: return STATUTORY;
        case 2: return COMMERCIAL;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DiscountType>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        DiscountType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<DiscountType>() {
            public DiscountType findValueByNumber(int number) {
              return DiscountType.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.opencannabis.schema.accounting.CommercialDiscounts.getDescriptor().getEnumTypes().get(0);
    }

    private static final DiscountType[] VALUES = values();

    public static DiscountType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DiscountType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:opencannabis.commerce.DiscountType)
  }

  /**
   * <pre>
   * Enumerates operational calculation modes for discounts.
   * </pre>
   *
   * Protobuf enum {@code opencannabis.commerce.DiscountBasis}
   */
  public enum DiscountBasis
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * The discount is calculated per-item.
     * </pre>
     *
     * <code>ITEM = 0;</code>
     */
    ITEM(0),
    /**
     * <pre>
     * The discount is calculated from the order subtotal, before tax.
     * </pre>
     *
     * <code>ORDER_SUBTOTAL = 1;</code>
     */
    ORDER_SUBTOTAL(1),
    /**
     * <pre>
     * The discount is calculated from the order total, after tax.
     * </pre>
     *
     * <code>ORDER_TOTAL = 2;</code>
     */
    ORDER_TOTAL(2),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * The discount is calculated per-item.
     * </pre>
     *
     * <code>ITEM = 0;</code>
     */
    public static final int ITEM_VALUE = 0;
    /**
     * <pre>
     * The discount is calculated from the order subtotal, before tax.
     * </pre>
     *
     * <code>ORDER_SUBTOTAL = 1;</code>
     */
    public static final int ORDER_SUBTOTAL_VALUE = 1;
    /**
     * <pre>
     * The discount is calculated from the order total, after tax.
     * </pre>
     *
     * <code>ORDER_TOTAL = 2;</code>
     */
    public static final int ORDER_TOTAL_VALUE = 2;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DiscountBasis valueOf(int value) {
      return forNumber(value);
    }

    public static DiscountBasis forNumber(int value) {
      switch (value) {
        case 0: return ITEM;
        case 1: return ORDER_SUBTOTAL;
        case 2: return ORDER_TOTAL;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DiscountBasis>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        DiscountBasis> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<DiscountBasis>() {
            public DiscountBasis findValueByNumber(int number) {
              return DiscountBasis.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.opencannabis.schema.accounting.CommercialDiscounts.getDescriptor().getEnumTypes().get(1);
    }

    private static final DiscountBasis[] VALUES = values();

    public static DiscountBasis valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DiscountBasis(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:opencannabis.commerce.DiscountBasis)
  }

  public interface DiscountSpecOrBuilder extends
      // @@protoc_insertion_point(interface_extends:opencannabis.commerce.DiscountSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Type of discount to apply.
     * </pre>
     *
     * <code>.opencannabis.commerce.DiscountType type = 1;</code>
     */
    int getTypeValue();
    /**
     * <pre>
     * Type of discount to apply.
     * </pre>
     *
     * <code>.opencannabis.commerce.DiscountType type = 1;</code>
     */
    io.opencannabis.schema.accounting.CommercialDiscounts.DiscountType getType();

    /**
     * <pre>
     * Basis to form when calculating the discount.
     * </pre>
     *
     * <code>.opencannabis.commerce.DiscountBasis basis = 2;</code>
     */
    int getBasisValue();
    /**
     * <pre>
     * Basis to form when calculating the discount.
     * </pre>
     *
     * <code>.opencannabis.commerce.DiscountBasis basis = 2;</code>
     */
    io.opencannabis.schema.accounting.CommercialDiscounts.DiscountBasis getBasis();

    /**
     * <pre>
     * Percentage rate for the discount.
     * </pre>
     *
     * <code>double percentage = 3;</code>
     */
    double getPercentage();

    /**
     * <pre>
     * Flat rate for the discount.
     * </pre>
     *
     * <code>double static_value = 4;</code>
     */
    double getStaticValue();

    public io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec.RateCase getRateCase();
  }
  /**
   * <pre>
   * Specifies the concept of a discount, and how it is set to behave.
   * </pre>
   *
   * Protobuf type {@code opencannabis.commerce.DiscountSpec}
   */
  public  static final class DiscountSpec extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:opencannabis.commerce.DiscountSpec)
      DiscountSpecOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use DiscountSpec.newBuilder() to construct.
    private DiscountSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private DiscountSpec() {
      type_ = 0;
      basis_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private DiscountSpec(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();

              type_ = rawValue;
              break;
            }
            case 16: {
              int rawValue = input.readEnum();

              basis_ = rawValue;
              break;
            }
            case 25: {
              rateCase_ = 3;
              rate_ = input.readDouble();
              break;
            }
            case 33: {
              rateCase_ = 4;
              rate_ = input.readDouble();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.accounting.CommercialDiscounts.internal_static_opencannabis_commerce_DiscountSpec_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.accounting.CommercialDiscounts.internal_static_opencannabis_commerce_DiscountSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec.class, io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec.Builder.class);
    }

    private int rateCase_ = 0;
    private java.lang.Object rate_;
    public enum RateCase
        implements com.google.protobuf.Internal.EnumLite {
      PERCENTAGE(3),
      STATIC_VALUE(4),
      RATE_NOT_SET(0);
      private final int value;
      private RateCase(int value) {
        this.value = value;
      }
      /**
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static RateCase valueOf(int value) {
        return forNumber(value);
      }

      public static RateCase forNumber(int value) {
        switch (value) {
          case 3: return PERCENTAGE;
          case 4: return STATIC_VALUE;
          case 0: return RATE_NOT_SET;
          default: return null;
        }
      }
      public int getNumber() {
        return this.value;
      }
    };

    public RateCase
    getRateCase() {
      return RateCase.forNumber(
          rateCase_);
    }

    public static final int TYPE_FIELD_NUMBER = 1;
    private int type_;
    /**
     * <pre>
     * Type of discount to apply.
     * </pre>
     *
     * <code>.opencannabis.commerce.DiscountType type = 1;</code>
     */
    public int getTypeValue() {
      return type_;
    }
    /**
     * <pre>
     * Type of discount to apply.
     * </pre>
     *
     * <code>.opencannabis.commerce.DiscountType type = 1;</code>
     */
    public io.opencannabis.schema.accounting.CommercialDiscounts.DiscountType getType() {
      io.opencannabis.schema.accounting.CommercialDiscounts.DiscountType result = io.opencannabis.schema.accounting.CommercialDiscounts.DiscountType.valueOf(type_);
      return result == null ? io.opencannabis.schema.accounting.CommercialDiscounts.DiscountType.UNRECOGNIZED : result;
    }

    public static final int BASIS_FIELD_NUMBER = 2;
    private int basis_;
    /**
     * <pre>
     * Basis to form when calculating the discount.
     * </pre>
     *
     * <code>.opencannabis.commerce.DiscountBasis basis = 2;</code>
     */
    public int getBasisValue() {
      return basis_;
    }
    /**
     * <pre>
     * Basis to form when calculating the discount.
     * </pre>
     *
     * <code>.opencannabis.commerce.DiscountBasis basis = 2;</code>
     */
    public io.opencannabis.schema.accounting.CommercialDiscounts.DiscountBasis getBasis() {
      io.opencannabis.schema.accounting.CommercialDiscounts.DiscountBasis result = io.opencannabis.schema.accounting.CommercialDiscounts.DiscountBasis.valueOf(basis_);
      return result == null ? io.opencannabis.schema.accounting.CommercialDiscounts.DiscountBasis.UNRECOGNIZED : result;
    }

    public static final int PERCENTAGE_FIELD_NUMBER = 3;
    /**
     * <pre>
     * Percentage rate for the discount.
     * </pre>
     *
     * <code>double percentage = 3;</code>
     */
    public double getPercentage() {
      if (rateCase_ == 3) {
        return (java.lang.Double) rate_;
      }
      return 0D;
    }

    public static final int STATIC_VALUE_FIELD_NUMBER = 4;
    /**
     * <pre>
     * Flat rate for the discount.
     * </pre>
     *
     * <code>double static_value = 4;</code>
     */
    public double getStaticValue() {
      if (rateCase_ == 4) {
        return (java.lang.Double) rate_;
      }
      return 0D;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (type_ != io.opencannabis.schema.accounting.CommercialDiscounts.DiscountType.CUSTOM.getNumber()) {
        output.writeEnum(1, type_);
      }
      if (basis_ != io.opencannabis.schema.accounting.CommercialDiscounts.DiscountBasis.ITEM.getNumber()) {
        output.writeEnum(2, basis_);
      }
      if (rateCase_ == 3) {
        output.writeDouble(
            3, (double)((java.lang.Double) rate_));
      }
      if (rateCase_ == 4) {
        output.writeDouble(
            4, (double)((java.lang.Double) rate_));
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (type_ != io.opencannabis.schema.accounting.CommercialDiscounts.DiscountType.CUSTOM.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, type_);
      }
      if (basis_ != io.opencannabis.schema.accounting.CommercialDiscounts.DiscountBasis.ITEM.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, basis_);
      }
      if (rateCase_ == 3) {
        size += com.google.protobuf.CodedOutputStream
          .computeDoubleSize(
              3, (double)((java.lang.Double) rate_));
      }
      if (rateCase_ == 4) {
        size += com.google.protobuf.CodedOutputStream
          .computeDoubleSize(
              4, (double)((java.lang.Double) rate_));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec)) {
        return super.equals(obj);
      }
      io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec other = (io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec) obj;

      boolean result = true;
      result = result && type_ == other.type_;
      result = result && basis_ == other.basis_;
      result = result && getRateCase().equals(
          other.getRateCase());
      if (!result) return false;
      switch (rateCase_) {
        case 3:
          result = result && (
              java.lang.Double.doubleToLongBits(getPercentage())
              == java.lang.Double.doubleToLongBits(
                  other.getPercentage()));
          break;
        case 4:
          result = result && (
              java.lang.Double.doubleToLongBits(getStaticValue())
              == java.lang.Double.doubleToLongBits(
                  other.getStaticValue()));
          break;
        case 0:
        default:
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      hash = (37 * hash) + BASIS_FIELD_NUMBER;
      hash = (53 * hash) + basis_;
      switch (rateCase_) {
        case 3:
          hash = (37 * hash) + PERCENTAGE_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
              java.lang.Double.doubleToLongBits(getPercentage()));
          break;
        case 4:
          hash = (37 * hash) + STATIC_VALUE_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
              java.lang.Double.doubleToLongBits(getStaticValue()));
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies the concept of a discount, and how it is set to behave.
     * </pre>
     *
     * Protobuf type {@code opencannabis.commerce.DiscountSpec}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:opencannabis.commerce.DiscountSpec)
        io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.opencannabis.schema.accounting.CommercialDiscounts.internal_static_opencannabis_commerce_DiscountSpec_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.opencannabis.schema.accounting.CommercialDiscounts.internal_static_opencannabis_commerce_DiscountSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec.class, io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec.Builder.class);
      }

      // Construct using io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        type_ = 0;

        basis_ = 0;

        rateCase_ = 0;
        rate_ = null;
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.opencannabis.schema.accounting.CommercialDiscounts.internal_static_opencannabis_commerce_DiscountSpec_descriptor;
      }

      public io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec getDefaultInstanceForType() {
        return io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec.getDefaultInstance();
      }

      public io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec build() {
        io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec buildPartial() {
        io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec result = new io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec(this);
        result.type_ = type_;
        result.basis_ = basis_;
        if (rateCase_ == 3) {
          result.rate_ = rate_;
        }
        if (rateCase_ == 4) {
          result.rate_ = rate_;
        }
        result.rateCase_ = rateCase_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec) {
          return mergeFrom((io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec other) {
        if (other == io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec.getDefaultInstance()) return this;
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        if (other.basis_ != 0) {
          setBasisValue(other.getBasisValue());
        }
        switch (other.getRateCase()) {
          case PERCENTAGE: {
            setPercentage(other.getPercentage());
            break;
          }
          case STATIC_VALUE: {
            setStaticValue(other.getStaticValue());
            break;
          }
          case RATE_NOT_SET: {
            break;
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int rateCase_ = 0;
      private java.lang.Object rate_;
      public RateCase
          getRateCase() {
        return RateCase.forNumber(
            rateCase_);
      }

      public Builder clearRate() {
        rateCase_ = 0;
        rate_ = null;
        onChanged();
        return this;
      }


      private int type_ = 0;
      /**
       * <pre>
       * Type of discount to apply.
       * </pre>
       *
       * <code>.opencannabis.commerce.DiscountType type = 1;</code>
       */
      public int getTypeValue() {
        return type_;
      }
      /**
       * <pre>
       * Type of discount to apply.
       * </pre>
       *
       * <code>.opencannabis.commerce.DiscountType type = 1;</code>
       */
      public Builder setTypeValue(int value) {
        type_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Type of discount to apply.
       * </pre>
       *
       * <code>.opencannabis.commerce.DiscountType type = 1;</code>
       */
      public io.opencannabis.schema.accounting.CommercialDiscounts.DiscountType getType() {
        io.opencannabis.schema.accounting.CommercialDiscounts.DiscountType result = io.opencannabis.schema.accounting.CommercialDiscounts.DiscountType.valueOf(type_);
        return result == null ? io.opencannabis.schema.accounting.CommercialDiscounts.DiscountType.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Type of discount to apply.
       * </pre>
       *
       * <code>.opencannabis.commerce.DiscountType type = 1;</code>
       */
      public Builder setType(io.opencannabis.schema.accounting.CommercialDiscounts.DiscountType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Type of discount to apply.
       * </pre>
       *
       * <code>.opencannabis.commerce.DiscountType type = 1;</code>
       */
      public Builder clearType() {
        
        type_ = 0;
        onChanged();
        return this;
      }

      private int basis_ = 0;
      /**
       * <pre>
       * Basis to form when calculating the discount.
       * </pre>
       *
       * <code>.opencannabis.commerce.DiscountBasis basis = 2;</code>
       */
      public int getBasisValue() {
        return basis_;
      }
      /**
       * <pre>
       * Basis to form when calculating the discount.
       * </pre>
       *
       * <code>.opencannabis.commerce.DiscountBasis basis = 2;</code>
       */
      public Builder setBasisValue(int value) {
        basis_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Basis to form when calculating the discount.
       * </pre>
       *
       * <code>.opencannabis.commerce.DiscountBasis basis = 2;</code>
       */
      public io.opencannabis.schema.accounting.CommercialDiscounts.DiscountBasis getBasis() {
        io.opencannabis.schema.accounting.CommercialDiscounts.DiscountBasis result = io.opencannabis.schema.accounting.CommercialDiscounts.DiscountBasis.valueOf(basis_);
        return result == null ? io.opencannabis.schema.accounting.CommercialDiscounts.DiscountBasis.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Basis to form when calculating the discount.
       * </pre>
       *
       * <code>.opencannabis.commerce.DiscountBasis basis = 2;</code>
       */
      public Builder setBasis(io.opencannabis.schema.accounting.CommercialDiscounts.DiscountBasis value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        basis_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Basis to form when calculating the discount.
       * </pre>
       *
       * <code>.opencannabis.commerce.DiscountBasis basis = 2;</code>
       */
      public Builder clearBasis() {
        
        basis_ = 0;
        onChanged();
        return this;
      }

      /**
       * <pre>
       * Percentage rate for the discount.
       * </pre>
       *
       * <code>double percentage = 3;</code>
       */
      public double getPercentage() {
        if (rateCase_ == 3) {
          return (java.lang.Double) rate_;
        }
        return 0D;
      }
      /**
       * <pre>
       * Percentage rate for the discount.
       * </pre>
       *
       * <code>double percentage = 3;</code>
       */
      public Builder setPercentage(double value) {
        rateCase_ = 3;
        rate_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Percentage rate for the discount.
       * </pre>
       *
       * <code>double percentage = 3;</code>
       */
      public Builder clearPercentage() {
        if (rateCase_ == 3) {
          rateCase_ = 0;
          rate_ = null;
          onChanged();
        }
        return this;
      }

      /**
       * <pre>
       * Flat rate for the discount.
       * </pre>
       *
       * <code>double static_value = 4;</code>
       */
      public double getStaticValue() {
        if (rateCase_ == 4) {
          return (java.lang.Double) rate_;
        }
        return 0D;
      }
      /**
       * <pre>
       * Flat rate for the discount.
       * </pre>
       *
       * <code>double static_value = 4;</code>
       */
      public Builder setStaticValue(double value) {
        rateCase_ = 4;
        rate_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Flat rate for the discount.
       * </pre>
       *
       * <code>double static_value = 4;</code>
       */
      public Builder clearStaticValue() {
        if (rateCase_ == 4) {
          rateCase_ = 0;
          rate_ = null;
          onChanged();
        }
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:opencannabis.commerce.DiscountSpec)
    }

    // @@protoc_insertion_point(class_scope:opencannabis.commerce.DiscountSpec)
    private static final io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec();
    }

    public static io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DiscountSpec>
        PARSER = new com.google.protobuf.AbstractParser<DiscountSpec>() {
      public DiscountSpec parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new DiscountSpec(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<DiscountSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DiscountSpec> getParserForType() {
      return PARSER;
    }

    public io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface DiscountOrBuilder extends
      // @@protoc_insertion_point(interface_extends:opencannabis.commerce.Discount)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * ID code for this discount entry.
     * </pre>
     *
     * <code>string id = 1;</code>
     */
    java.lang.String getId();
    /**
     * <pre>
     * ID code for this discount entry.
     * </pre>
     *
     * <code>string id = 1;</code>
     */
    com.google.protobuf.ByteString
        getIdBytes();

    /**
     * <pre>
     * Specification for how this discount behaves.
     * </pre>
     *
     * <code>.opencannabis.commerce.DiscountSpec spec = 2;</code>
     */
    boolean hasSpec();
    /**
     * <pre>
     * Specification for how this discount behaves.
     * </pre>
     *
     * <code>.opencannabis.commerce.DiscountSpec spec = 2;</code>
     */
    io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec getSpec();
    /**
     * <pre>
     * Specification for how this discount behaves.
     * </pre>
     *
     * <code>.opencannabis.commerce.DiscountSpec spec = 2;</code>
     */
    io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpecOrBuilder getSpecOrBuilder();

    /**
     * <pre>
     * Back-office name for this tax.
     * </pre>
     *
     * <code>string name = 3;</code>
     */
    java.lang.String getName();
    /**
     * <pre>
     * Back-office name for this tax.
     * </pre>
     *
     * <code>string name = 3;</code>
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <pre>
     * User-visible name for this tax.
     * </pre>
     *
     * <code>string label = 4;</code>
     */
    java.lang.String getLabel();
    /**
     * <pre>
     * User-visible name for this tax.
     * </pre>
     *
     * <code>string label = 4;</code>
     */
    com.google.protobuf.ByteString
        getLabelBytes();

    /**
     * <pre>
     * Narrative description for this discount, to be displayed to back-office and end-users in some special
     * circumstances.
     * </pre>
     *
     * <code>string description = 5;</code>
     */
    java.lang.String getDescription();
    /**
     * <pre>
     * Narrative description for this discount, to be displayed to back-office and end-users in some special
     * circumstances.
     * </pre>
     *
     * <code>string description = 5;</code>
     */
    com.google.protobuf.ByteString
        getDescriptionBytes();

    /**
     * <pre>
     * Last time this discount was modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified_at = 7;</code>
     */
    boolean hasModifiedAt();
    /**
     * <pre>
     * Last time this discount was modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified_at = 7;</code>
     */
    io.opencannabis.schema.temporal.Instant getModifiedAt();
    /**
     * <pre>
     * Last time this discount was modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified_at = 7;</code>
     */
    io.opencannabis.schema.temporal.InstantOrBuilder getModifiedAtOrBuilder();

    /**
     * <pre>
     * When this discount was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created_at = 6;</code>
     */
    boolean hasCreatedAt();
    /**
     * <pre>
     * When this discount was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created_at = 6;</code>
     */
    io.opencannabis.schema.temporal.Instant getCreatedAt();
    /**
     * <pre>
     * When this discount was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created_at = 6;</code>
     */
    io.opencannabis.schema.temporal.InstantOrBuilder getCreatedAtOrBuilder();
  }
  /**
   * <pre>
   * Specifies a discount to be applied during a purchase or order.
   * </pre>
   *
   * Protobuf type {@code opencannabis.commerce.Discount}
   */
  public  static final class Discount extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:opencannabis.commerce.Discount)
      DiscountOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Discount.newBuilder() to construct.
    private Discount(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Discount() {
      id_ = "";
      name_ = "";
      label_ = "";
      description_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Discount(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              java.lang.String s = input.readStringRequireUtf8();

              id_ = s;
              break;
            }
            case 18: {
              io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec.Builder subBuilder = null;
              if (spec_ != null) {
                subBuilder = spec_.toBuilder();
              }
              spec_ = input.readMessage(io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(spec_);
                spec_ = subBuilder.buildPartial();
              }

              break;
            }
            case 26: {
              java.lang.String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
            case 34: {
              java.lang.String s = input.readStringRequireUtf8();

              label_ = s;
              break;
            }
            case 42: {
              java.lang.String s = input.readStringRequireUtf8();

              description_ = s;
              break;
            }
            case 50: {
              io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
              if (createdAt_ != null) {
                subBuilder = createdAt_.toBuilder();
              }
              createdAt_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(createdAt_);
                createdAt_ = subBuilder.buildPartial();
              }

              break;
            }
            case 58: {
              io.opencannabis.schema.temporal.Instant.Builder subBuilder = null;
              if (modifiedAt_ != null) {
                subBuilder = modifiedAt_.toBuilder();
              }
              modifiedAt_ = input.readMessage(io.opencannabis.schema.temporal.Instant.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(modifiedAt_);
                modifiedAt_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.accounting.CommercialDiscounts.internal_static_opencannabis_commerce_Discount_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.accounting.CommercialDiscounts.internal_static_opencannabis_commerce_Discount_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.accounting.CommercialDiscounts.Discount.class, io.opencannabis.schema.accounting.CommercialDiscounts.Discount.Builder.class);
    }

    public static final int ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object id_;
    /**
     * <pre>
     * ID code for this discount entry.
     * </pre>
     *
     * <code>string id = 1;</code>
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * ID code for this discount entry.
     * </pre>
     *
     * <code>string id = 1;</code>
     */
    public com.google.protobuf.ByteString
        getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SPEC_FIELD_NUMBER = 2;
    private io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec spec_;
    /**
     * <pre>
     * Specification for how this discount behaves.
     * </pre>
     *
     * <code>.opencannabis.commerce.DiscountSpec spec = 2;</code>
     */
    public boolean hasSpec() {
      return spec_ != null;
    }
    /**
     * <pre>
     * Specification for how this discount behaves.
     * </pre>
     *
     * <code>.opencannabis.commerce.DiscountSpec spec = 2;</code>
     */
    public io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec getSpec() {
      return spec_ == null ? io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec.getDefaultInstance() : spec_;
    }
    /**
     * <pre>
     * Specification for how this discount behaves.
     * </pre>
     *
     * <code>.opencannabis.commerce.DiscountSpec spec = 2;</code>
     */
    public io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpecOrBuilder getSpecOrBuilder() {
      return getSpec();
    }

    public static final int NAME_FIELD_NUMBER = 3;
    private volatile java.lang.Object name_;
    /**
     * <pre>
     * Back-office name for this tax.
     * </pre>
     *
     * <code>string name = 3;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Back-office name for this tax.
     * </pre>
     *
     * <code>string name = 3;</code>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LABEL_FIELD_NUMBER = 4;
    private volatile java.lang.Object label_;
    /**
     * <pre>
     * User-visible name for this tax.
     * </pre>
     *
     * <code>string label = 4;</code>
     */
    public java.lang.String getLabel() {
      java.lang.Object ref = label_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        label_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * User-visible name for this tax.
     * </pre>
     *
     * <code>string label = 4;</code>
     */
    public com.google.protobuf.ByteString
        getLabelBytes() {
      java.lang.Object ref = label_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        label_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DESCRIPTION_FIELD_NUMBER = 5;
    private volatile java.lang.Object description_;
    /**
     * <pre>
     * Narrative description for this discount, to be displayed to back-office and end-users in some special
     * circumstances.
     * </pre>
     *
     * <code>string description = 5;</code>
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      }
    }
    /**
     * <pre>
     * Narrative description for this discount, to be displayed to back-office and end-users in some special
     * circumstances.
     * </pre>
     *
     * <code>string description = 5;</code>
     */
    public com.google.protobuf.ByteString
        getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MODIFIED_AT_FIELD_NUMBER = 7;
    private io.opencannabis.schema.temporal.Instant modifiedAt_;
    /**
     * <pre>
     * Last time this discount was modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified_at = 7;</code>
     */
    public boolean hasModifiedAt() {
      return modifiedAt_ != null;
    }
    /**
     * <pre>
     * Last time this discount was modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified_at = 7;</code>
     */
    public io.opencannabis.schema.temporal.Instant getModifiedAt() {
      return modifiedAt_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : modifiedAt_;
    }
    /**
     * <pre>
     * Last time this discount was modified.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant modified_at = 7;</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getModifiedAtOrBuilder() {
      return getModifiedAt();
    }

    public static final int CREATED_AT_FIELD_NUMBER = 6;
    private io.opencannabis.schema.temporal.Instant createdAt_;
    /**
     * <pre>
     * When this discount was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created_at = 6;</code>
     */
    public boolean hasCreatedAt() {
      return createdAt_ != null;
    }
    /**
     * <pre>
     * When this discount was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created_at = 6;</code>
     */
    public io.opencannabis.schema.temporal.Instant getCreatedAt() {
      return createdAt_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : createdAt_;
    }
    /**
     * <pre>
     * When this discount was created.
     * </pre>
     *
     * <code>.opencannabis.temporal.Instant created_at = 6;</code>
     */
    public io.opencannabis.schema.temporal.InstantOrBuilder getCreatedAtOrBuilder() {
      return getCreatedAt();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
      }
      if (spec_ != null) {
        output.writeMessage(2, getSpec());
      }
      if (!getNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, name_);
      }
      if (!getLabelBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, label_);
      }
      if (!getDescriptionBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, description_);
      }
      if (createdAt_ != null) {
        output.writeMessage(6, getCreatedAt());
      }
      if (modifiedAt_ != null) {
        output.writeMessage(7, getModifiedAt());
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
      }
      if (spec_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getSpec());
      }
      if (!getNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, name_);
      }
      if (!getLabelBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, label_);
      }
      if (!getDescriptionBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, description_);
      }
      if (createdAt_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(6, getCreatedAt());
      }
      if (modifiedAt_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(7, getModifiedAt());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.opencannabis.schema.accounting.CommercialDiscounts.Discount)) {
        return super.equals(obj);
      }
      io.opencannabis.schema.accounting.CommercialDiscounts.Discount other = (io.opencannabis.schema.accounting.CommercialDiscounts.Discount) obj;

      boolean result = true;
      result = result && getId()
          .equals(other.getId());
      result = result && (hasSpec() == other.hasSpec());
      if (hasSpec()) {
        result = result && getSpec()
            .equals(other.getSpec());
      }
      result = result && getName()
          .equals(other.getName());
      result = result && getLabel()
          .equals(other.getLabel());
      result = result && getDescription()
          .equals(other.getDescription());
      result = result && (hasModifiedAt() == other.hasModifiedAt());
      if (hasModifiedAt()) {
        result = result && getModifiedAt()
            .equals(other.getModifiedAt());
      }
      result = result && (hasCreatedAt() == other.hasCreatedAt());
      if (hasCreatedAt()) {
        result = result && getCreatedAt()
            .equals(other.getCreatedAt());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + getId().hashCode();
      if (hasSpec()) {
        hash = (37 * hash) + SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getSpec().hashCode();
      }
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      hash = (37 * hash) + LABEL_FIELD_NUMBER;
      hash = (53 * hash) + getLabel().hashCode();
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
      if (hasModifiedAt()) {
        hash = (37 * hash) + MODIFIED_AT_FIELD_NUMBER;
        hash = (53 * hash) + getModifiedAt().hashCode();
      }
      if (hasCreatedAt()) {
        hash = (37 * hash) + CREATED_AT_FIELD_NUMBER;
        hash = (53 * hash) + getCreatedAt().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.opencannabis.schema.accounting.CommercialDiscounts.Discount parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.accounting.CommercialDiscounts.Discount parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.CommercialDiscounts.Discount parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.accounting.CommercialDiscounts.Discount parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.CommercialDiscounts.Discount parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.accounting.CommercialDiscounts.Discount parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.CommercialDiscounts.Discount parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.accounting.CommercialDiscounts.Discount parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.CommercialDiscounts.Discount parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.accounting.CommercialDiscounts.Discount parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.opencannabis.schema.accounting.CommercialDiscounts.Discount parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.accounting.CommercialDiscounts.Discount parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.opencannabis.schema.accounting.CommercialDiscounts.Discount prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies a discount to be applied during a purchase or order.
     * </pre>
     *
     * Protobuf type {@code opencannabis.commerce.Discount}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:opencannabis.commerce.Discount)
        io.opencannabis.schema.accounting.CommercialDiscounts.DiscountOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.opencannabis.schema.accounting.CommercialDiscounts.internal_static_opencannabis_commerce_Discount_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.opencannabis.schema.accounting.CommercialDiscounts.internal_static_opencannabis_commerce_Discount_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.opencannabis.schema.accounting.CommercialDiscounts.Discount.class, io.opencannabis.schema.accounting.CommercialDiscounts.Discount.Builder.class);
      }

      // Construct using io.opencannabis.schema.accounting.CommercialDiscounts.Discount.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        id_ = "";

        if (specBuilder_ == null) {
          spec_ = null;
        } else {
          spec_ = null;
          specBuilder_ = null;
        }
        name_ = "";

        label_ = "";

        description_ = "";

        if (modifiedAtBuilder_ == null) {
          modifiedAt_ = null;
        } else {
          modifiedAt_ = null;
          modifiedAtBuilder_ = null;
        }
        if (createdAtBuilder_ == null) {
          createdAt_ = null;
        } else {
          createdAt_ = null;
          createdAtBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.opencannabis.schema.accounting.CommercialDiscounts.internal_static_opencannabis_commerce_Discount_descriptor;
      }

      public io.opencannabis.schema.accounting.CommercialDiscounts.Discount getDefaultInstanceForType() {
        return io.opencannabis.schema.accounting.CommercialDiscounts.Discount.getDefaultInstance();
      }

      public io.opencannabis.schema.accounting.CommercialDiscounts.Discount build() {
        io.opencannabis.schema.accounting.CommercialDiscounts.Discount result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.opencannabis.schema.accounting.CommercialDiscounts.Discount buildPartial() {
        io.opencannabis.schema.accounting.CommercialDiscounts.Discount result = new io.opencannabis.schema.accounting.CommercialDiscounts.Discount(this);
        result.id_ = id_;
        if (specBuilder_ == null) {
          result.spec_ = spec_;
        } else {
          result.spec_ = specBuilder_.build();
        }
        result.name_ = name_;
        result.label_ = label_;
        result.description_ = description_;
        if (modifiedAtBuilder_ == null) {
          result.modifiedAt_ = modifiedAt_;
        } else {
          result.modifiedAt_ = modifiedAtBuilder_.build();
        }
        if (createdAtBuilder_ == null) {
          result.createdAt_ = createdAt_;
        } else {
          result.createdAt_ = createdAtBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.opencannabis.schema.accounting.CommercialDiscounts.Discount) {
          return mergeFrom((io.opencannabis.schema.accounting.CommercialDiscounts.Discount)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.opencannabis.schema.accounting.CommercialDiscounts.Discount other) {
        if (other == io.opencannabis.schema.accounting.CommercialDiscounts.Discount.getDefaultInstance()) return this;
        if (!other.getId().isEmpty()) {
          id_ = other.id_;
          onChanged();
        }
        if (other.hasSpec()) {
          mergeSpec(other.getSpec());
        }
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          onChanged();
        }
        if (!other.getLabel().isEmpty()) {
          label_ = other.label_;
          onChanged();
        }
        if (!other.getDescription().isEmpty()) {
          description_ = other.description_;
          onChanged();
        }
        if (other.hasModifiedAt()) {
          mergeModifiedAt(other.getModifiedAt());
        }
        if (other.hasCreatedAt()) {
          mergeCreatedAt(other.getCreatedAt());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.opencannabis.schema.accounting.CommercialDiscounts.Discount parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.opencannabis.schema.accounting.CommercialDiscounts.Discount) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object id_ = "";
      /**
       * <pre>
       * ID code for this discount entry.
       * </pre>
       *
       * <code>string id = 1;</code>
       */
      public java.lang.String getId() {
        java.lang.Object ref = id_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          id_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * ID code for this discount entry.
       * </pre>
       *
       * <code>string id = 1;</code>
       */
      public com.google.protobuf.ByteString
          getIdBytes() {
        java.lang.Object ref = id_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          id_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * ID code for this discount entry.
       * </pre>
       *
       * <code>string id = 1;</code>
       */
      public Builder setId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        id_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * ID code for this discount entry.
       * </pre>
       *
       * <code>string id = 1;</code>
       */
      public Builder clearId() {
        
        id_ = getDefaultInstance().getId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * ID code for this discount entry.
       * </pre>
       *
       * <code>string id = 1;</code>
       */
      public Builder setIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        id_ = value;
        onChanged();
        return this;
      }

      private io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec spec_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec, io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec.Builder, io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpecOrBuilder> specBuilder_;
      /**
       * <pre>
       * Specification for how this discount behaves.
       * </pre>
       *
       * <code>.opencannabis.commerce.DiscountSpec spec = 2;</code>
       */
      public boolean hasSpec() {
        return specBuilder_ != null || spec_ != null;
      }
      /**
       * <pre>
       * Specification for how this discount behaves.
       * </pre>
       *
       * <code>.opencannabis.commerce.DiscountSpec spec = 2;</code>
       */
      public io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec getSpec() {
        if (specBuilder_ == null) {
          return spec_ == null ? io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec.getDefaultInstance() : spec_;
        } else {
          return specBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Specification for how this discount behaves.
       * </pre>
       *
       * <code>.opencannabis.commerce.DiscountSpec spec = 2;</code>
       */
      public Builder setSpec(io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec value) {
        if (specBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          spec_ = value;
          onChanged();
        } else {
          specBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specification for how this discount behaves.
       * </pre>
       *
       * <code>.opencannabis.commerce.DiscountSpec spec = 2;</code>
       */
      public Builder setSpec(
          io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec.Builder builderForValue) {
        if (specBuilder_ == null) {
          spec_ = builderForValue.build();
          onChanged();
        } else {
          specBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Specification for how this discount behaves.
       * </pre>
       *
       * <code>.opencannabis.commerce.DiscountSpec spec = 2;</code>
       */
      public Builder mergeSpec(io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec value) {
        if (specBuilder_ == null) {
          if (spec_ != null) {
            spec_ =
              io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec.newBuilder(spec_).mergeFrom(value).buildPartial();
          } else {
            spec_ = value;
          }
          onChanged();
        } else {
          specBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Specification for how this discount behaves.
       * </pre>
       *
       * <code>.opencannabis.commerce.DiscountSpec spec = 2;</code>
       */
      public Builder clearSpec() {
        if (specBuilder_ == null) {
          spec_ = null;
          onChanged();
        } else {
          spec_ = null;
          specBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Specification for how this discount behaves.
       * </pre>
       *
       * <code>.opencannabis.commerce.DiscountSpec spec = 2;</code>
       */
      public io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec.Builder getSpecBuilder() {
        
        onChanged();
        return getSpecFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Specification for how this discount behaves.
       * </pre>
       *
       * <code>.opencannabis.commerce.DiscountSpec spec = 2;</code>
       */
      public io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpecOrBuilder getSpecOrBuilder() {
        if (specBuilder_ != null) {
          return specBuilder_.getMessageOrBuilder();
        } else {
          return spec_ == null ?
              io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec.getDefaultInstance() : spec_;
        }
      }
      /**
       * <pre>
       * Specification for how this discount behaves.
       * </pre>
       *
       * <code>.opencannabis.commerce.DiscountSpec spec = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec, io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec.Builder, io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpecOrBuilder> 
          getSpecFieldBuilder() {
        if (specBuilder_ == null) {
          specBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec, io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpec.Builder, io.opencannabis.schema.accounting.CommercialDiscounts.DiscountSpecOrBuilder>(
                  getSpec(),
                  getParentForChildren(),
                  isClean());
          spec_ = null;
        }
        return specBuilder_;
      }

      private java.lang.Object name_ = "";
      /**
       * <pre>
       * Back-office name for this tax.
       * </pre>
       *
       * <code>string name = 3;</code>
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Back-office name for this tax.
       * </pre>
       *
       * <code>string name = 3;</code>
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Back-office name for this tax.
       * </pre>
       *
       * <code>string name = 3;</code>
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        name_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Back-office name for this tax.
       * </pre>
       *
       * <code>string name = 3;</code>
       */
      public Builder clearName() {
        
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Back-office name for this tax.
       * </pre>
       *
       * <code>string name = 3;</code>
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        name_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object label_ = "";
      /**
       * <pre>
       * User-visible name for this tax.
       * </pre>
       *
       * <code>string label = 4;</code>
       */
      public java.lang.String getLabel() {
        java.lang.Object ref = label_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          label_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * User-visible name for this tax.
       * </pre>
       *
       * <code>string label = 4;</code>
       */
      public com.google.protobuf.ByteString
          getLabelBytes() {
        java.lang.Object ref = label_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          label_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * User-visible name for this tax.
       * </pre>
       *
       * <code>string label = 4;</code>
       */
      public Builder setLabel(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        label_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * User-visible name for this tax.
       * </pre>
       *
       * <code>string label = 4;</code>
       */
      public Builder clearLabel() {
        
        label_ = getDefaultInstance().getLabel();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * User-visible name for this tax.
       * </pre>
       *
       * <code>string label = 4;</code>
       */
      public Builder setLabelBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        label_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object description_ = "";
      /**
       * <pre>
       * Narrative description for this discount, to be displayed to back-office and end-users in some special
       * circumstances.
       * </pre>
       *
       * <code>string description = 5;</code>
       */
      public java.lang.String getDescription() {
        java.lang.Object ref = description_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          description_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Narrative description for this discount, to be displayed to back-office and end-users in some special
       * circumstances.
       * </pre>
       *
       * <code>string description = 5;</code>
       */
      public com.google.protobuf.ByteString
          getDescriptionBytes() {
        java.lang.Object ref = description_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          description_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Narrative description for this discount, to be displayed to back-office and end-users in some special
       * circumstances.
       * </pre>
       *
       * <code>string description = 5;</code>
       */
      public Builder setDescription(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        description_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Narrative description for this discount, to be displayed to back-office and end-users in some special
       * circumstances.
       * </pre>
       *
       * <code>string description = 5;</code>
       */
      public Builder clearDescription() {
        
        description_ = getDefaultInstance().getDescription();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Narrative description for this discount, to be displayed to back-office and end-users in some special
       * circumstances.
       * </pre>
       *
       * <code>string description = 5;</code>
       */
      public Builder setDescriptionBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        description_ = value;
        onChanged();
        return this;
      }

      private io.opencannabis.schema.temporal.Instant modifiedAt_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> modifiedAtBuilder_;
      /**
       * <pre>
       * Last time this discount was modified.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant modified_at = 7;</code>
       */
      public boolean hasModifiedAt() {
        return modifiedAtBuilder_ != null || modifiedAt_ != null;
      }
      /**
       * <pre>
       * Last time this discount was modified.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant modified_at = 7;</code>
       */
      public io.opencannabis.schema.temporal.Instant getModifiedAt() {
        if (modifiedAtBuilder_ == null) {
          return modifiedAt_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : modifiedAt_;
        } else {
          return modifiedAtBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Last time this discount was modified.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant modified_at = 7;</code>
       */
      public Builder setModifiedAt(io.opencannabis.schema.temporal.Instant value) {
        if (modifiedAtBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          modifiedAt_ = value;
          onChanged();
        } else {
          modifiedAtBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Last time this discount was modified.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant modified_at = 7;</code>
       */
      public Builder setModifiedAt(
          io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
        if (modifiedAtBuilder_ == null) {
          modifiedAt_ = builderForValue.build();
          onChanged();
        } else {
          modifiedAtBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Last time this discount was modified.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant modified_at = 7;</code>
       */
      public Builder mergeModifiedAt(io.opencannabis.schema.temporal.Instant value) {
        if (modifiedAtBuilder_ == null) {
          if (modifiedAt_ != null) {
            modifiedAt_ =
              io.opencannabis.schema.temporal.Instant.newBuilder(modifiedAt_).mergeFrom(value).buildPartial();
          } else {
            modifiedAt_ = value;
          }
          onChanged();
        } else {
          modifiedAtBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Last time this discount was modified.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant modified_at = 7;</code>
       */
      public Builder clearModifiedAt() {
        if (modifiedAtBuilder_ == null) {
          modifiedAt_ = null;
          onChanged();
        } else {
          modifiedAt_ = null;
          modifiedAtBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Last time this discount was modified.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant modified_at = 7;</code>
       */
      public io.opencannabis.schema.temporal.Instant.Builder getModifiedAtBuilder() {
        
        onChanged();
        return getModifiedAtFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Last time this discount was modified.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant modified_at = 7;</code>
       */
      public io.opencannabis.schema.temporal.InstantOrBuilder getModifiedAtOrBuilder() {
        if (modifiedAtBuilder_ != null) {
          return modifiedAtBuilder_.getMessageOrBuilder();
        } else {
          return modifiedAt_ == null ?
              io.opencannabis.schema.temporal.Instant.getDefaultInstance() : modifiedAt_;
        }
      }
      /**
       * <pre>
       * Last time this discount was modified.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant modified_at = 7;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
          getModifiedAtFieldBuilder() {
        if (modifiedAtBuilder_ == null) {
          modifiedAtBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                  getModifiedAt(),
                  getParentForChildren(),
                  isClean());
          modifiedAt_ = null;
        }
        return modifiedAtBuilder_;
      }

      private io.opencannabis.schema.temporal.Instant createdAt_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> createdAtBuilder_;
      /**
       * <pre>
       * When this discount was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant created_at = 6;</code>
       */
      public boolean hasCreatedAt() {
        return createdAtBuilder_ != null || createdAt_ != null;
      }
      /**
       * <pre>
       * When this discount was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant created_at = 6;</code>
       */
      public io.opencannabis.schema.temporal.Instant getCreatedAt() {
        if (createdAtBuilder_ == null) {
          return createdAt_ == null ? io.opencannabis.schema.temporal.Instant.getDefaultInstance() : createdAt_;
        } else {
          return createdAtBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * When this discount was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant created_at = 6;</code>
       */
      public Builder setCreatedAt(io.opencannabis.schema.temporal.Instant value) {
        if (createdAtBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          createdAt_ = value;
          onChanged();
        } else {
          createdAtBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * When this discount was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant created_at = 6;</code>
       */
      public Builder setCreatedAt(
          io.opencannabis.schema.temporal.Instant.Builder builderForValue) {
        if (createdAtBuilder_ == null) {
          createdAt_ = builderForValue.build();
          onChanged();
        } else {
          createdAtBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * When this discount was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant created_at = 6;</code>
       */
      public Builder mergeCreatedAt(io.opencannabis.schema.temporal.Instant value) {
        if (createdAtBuilder_ == null) {
          if (createdAt_ != null) {
            createdAt_ =
              io.opencannabis.schema.temporal.Instant.newBuilder(createdAt_).mergeFrom(value).buildPartial();
          } else {
            createdAt_ = value;
          }
          onChanged();
        } else {
          createdAtBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * When this discount was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant created_at = 6;</code>
       */
      public Builder clearCreatedAt() {
        if (createdAtBuilder_ == null) {
          createdAt_ = null;
          onChanged();
        } else {
          createdAt_ = null;
          createdAtBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * When this discount was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant created_at = 6;</code>
       */
      public io.opencannabis.schema.temporal.Instant.Builder getCreatedAtBuilder() {
        
        onChanged();
        return getCreatedAtFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * When this discount was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant created_at = 6;</code>
       */
      public io.opencannabis.schema.temporal.InstantOrBuilder getCreatedAtOrBuilder() {
        if (createdAtBuilder_ != null) {
          return createdAtBuilder_.getMessageOrBuilder();
        } else {
          return createdAt_ == null ?
              io.opencannabis.schema.temporal.Instant.getDefaultInstance() : createdAt_;
        }
      }
      /**
       * <pre>
       * When this discount was created.
       * </pre>
       *
       * <code>.opencannabis.temporal.Instant created_at = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder> 
          getCreatedAtFieldBuilder() {
        if (createdAtBuilder_ == null) {
          createdAtBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.temporal.Instant, io.opencannabis.schema.temporal.Instant.Builder, io.opencannabis.schema.temporal.InstantOrBuilder>(
                  getCreatedAt(),
                  getParentForChildren(),
                  isClean());
          createdAt_ = null;
        }
        return createdAtBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:opencannabis.commerce.Discount)
    }

    // @@protoc_insertion_point(class_scope:opencannabis.commerce.Discount)
    private static final io.opencannabis.schema.accounting.CommercialDiscounts.Discount DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.opencannabis.schema.accounting.CommercialDiscounts.Discount();
    }

    public static io.opencannabis.schema.accounting.CommercialDiscounts.Discount getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Discount>
        PARSER = new com.google.protobuf.AbstractParser<Discount>() {
      public Discount parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Discount(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Discount> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Discount> getParserForType() {
      return PARSER;
    }

    public io.opencannabis.schema.accounting.CommercialDiscounts.Discount getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_opencannabis_commerce_DiscountSpec_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_opencannabis_commerce_DiscountSpec_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_opencannabis_commerce_Discount_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_opencannabis_commerce_Discount_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\030commerce/Discounts.proto\022\025opencannabis" +
      ".commerce\032\026temporal/Instant.proto\"\254\001\n\014Di" +
      "scountSpec\0221\n\004type\030\001 \001(\0162#.opencannabis." +
      "commerce.DiscountType\0223\n\005basis\030\002 \001(\0162$.o" +
      "pencannabis.commerce.DiscountBasis\022\024\n\npe" +
      "rcentage\030\003 \001(\001H\000\022\026\n\014static_value\030\004 \001(\001H\000" +
      "B\006\n\004rate\"\344\001\n\010Discount\022\n\n\002id\030\001 \001(\t\0221\n\004spe" +
      "c\030\002 \001(\0132#.opencannabis.commerce.Discount" +
      "Spec\022\014\n\004name\030\003 \001(\t\022\r\n\005label\030\004 \001(\t\022\023\n\013des" +
      "cription\030\005 \001(\t\0223\n\013modified_at\030\007 \001(\0132\036.op" +
      "encannabis.temporal.Instant\0222\n\ncreated_a" +
      "t\030\006 \001(\0132\036.opencannabis.temporal.Instant*" +
      "9\n\014DiscountType\022\n\n\006CUSTOM\020\000\022\r\n\tSTATUTORY" +
      "\020\001\022\016\n\nCOMMERCIAL\020\002*>\n\rDiscountBasis\022\010\n\004I" +
      "TEM\020\000\022\022\n\016ORDER_SUBTOTAL\020\001\022\017\n\013ORDER_TOTAL" +
      "\020\002BB\n!io.opencannabis.schema.accountingB" +
      "\023CommercialDiscountsH\001P\000\242\002\003OCSb\006proto3"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          io.opencannabis.schema.temporal.InstantOuterClass.getDescriptor(),
        }, assigner);
    internal_static_opencannabis_commerce_DiscountSpec_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_opencannabis_commerce_DiscountSpec_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_opencannabis_commerce_DiscountSpec_descriptor,
        new java.lang.String[] { "Type", "Basis", "Percentage", "StaticValue", "Rate", });
    internal_static_opencannabis_commerce_Discount_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_opencannabis_commerce_Discount_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_opencannabis_commerce_Discount_descriptor,
        new java.lang.String[] { "Id", "Spec", "Name", "Label", "Description", "ModifiedAt", "CreatedAt", });
    io.opencannabis.schema.temporal.InstantOuterClass.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
