/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: base/ProductKey.proto

package io.opencannabis.schema.base;

/**
 * <pre>
 * Specifies a general key for a product, which is the combined specification of a product ID and type, which is
 * enumerated in `base.ProductType`.
 * </pre>
 *
 * Protobuf type {@code opencannabis.base.ProductKey}
 */
public  final class ProductKey extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:opencannabis.base.ProductKey)
    ProductKeyOrBuilder {
private static final long serialVersionUID = 0L;
  // Use ProductKey.newBuilder() to construct.
  private ProductKey(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private ProductKey() {
    id_ = "";
    type_ = 0;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private ProductKey(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 10: {
            java.lang.String s = input.readStringRequireUtf8();

            id_ = s;
            break;
          }
          case 16: {
            int rawValue = input.readEnum();

            type_ = rawValue;
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.opencannabis.schema.base.BaseProductKey.internal_static_opencannabis_base_ProductKey_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.opencannabis.schema.base.BaseProductKey.internal_static_opencannabis_base_ProductKey_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.opencannabis.schema.base.ProductKey.class, io.opencannabis.schema.base.ProductKey.Builder.class);
  }

  public static final int ID_FIELD_NUMBER = 1;
  private volatile java.lang.Object id_;
  /**
   * <pre>
   * Product ID, an opaque string that is usually autogenerated. Within the scope of an implementing system, this may
   * also be a stringified integer such as an auto-incrementing ID, for relational-type systems. The product ID is
   * expected to be globally addressable and unique across all product categories.
   * </pre>
   *
   * <code>string id = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Product ID, an opaque string that is usually autogenerated."];</code>
   */
  public java.lang.String getId() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      id_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Product ID, an opaque string that is usually autogenerated. Within the scope of an implementing system, this may
   * also be a stringified integer such as an auto-incrementing ID, for relational-type systems. The product ID is
   * expected to be globally addressable and unique across all product categories.
   * </pre>
   *
   * <code>string id = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Product ID, an opaque string that is usually autogenerated."];</code>
   */
  public com.google.protobuf.ByteString
      getIdBytes() {
    java.lang.Object ref = id_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      id_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 2;
  private int type_;
  /**
   * <pre>
   * Type of product the ID is referring to. In most cases this entry can be omitted.
   * </pre>
   *
   * <code>.opencannabis.base.ProductKind type = 2 [(.gen_bq_schema.ignore) = true];</code>
   */
  public int getTypeValue() {
    return type_;
  }
  /**
   * <pre>
   * Type of product the ID is referring to. In most cases this entry can be omitted.
   * </pre>
   *
   * <code>.opencannabis.base.ProductKind type = 2 [(.gen_bq_schema.ignore) = true];</code>
   */
  public io.opencannabis.schema.base.ProductKind getType() {
    io.opencannabis.schema.base.ProductKind result = io.opencannabis.schema.base.ProductKind.valueOf(type_);
    return result == null ? io.opencannabis.schema.base.ProductKind.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!getIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
    }
    if (type_ != io.opencannabis.schema.base.ProductKind.FLOWERS.getNumber()) {
      output.writeEnum(2, type_);
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
    }
    if (type_ != io.opencannabis.schema.base.ProductKind.FLOWERS.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(2, type_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.opencannabis.schema.base.ProductKey)) {
      return super.equals(obj);
    }
    io.opencannabis.schema.base.ProductKey other = (io.opencannabis.schema.base.ProductKey) obj;

    boolean result = true;
    result = result && getId()
        .equals(other.getId());
    result = result && type_ == other.type_;
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ID_FIELD_NUMBER;
    hash = (53 * hash) + getId().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.opencannabis.schema.base.ProductKey parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.base.ProductKey parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.base.ProductKey parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.base.ProductKey parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.base.ProductKey parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.base.ProductKey parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.base.ProductKey parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.base.ProductKey parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.base.ProductKey parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.base.ProductKey parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.base.ProductKey parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.base.ProductKey parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.opencannabis.schema.base.ProductKey prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies a general key for a product, which is the combined specification of a product ID and type, which is
   * enumerated in `base.ProductType`.
   * </pre>
   *
   * Protobuf type {@code opencannabis.base.ProductKey}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:opencannabis.base.ProductKey)
      io.opencannabis.schema.base.ProductKeyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.base.BaseProductKey.internal_static_opencannabis_base_ProductKey_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.base.BaseProductKey.internal_static_opencannabis_base_ProductKey_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.base.ProductKey.class, io.opencannabis.schema.base.ProductKey.Builder.class);
    }

    // Construct using io.opencannabis.schema.base.ProductKey.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      id_ = "";

      type_ = 0;

      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.opencannabis.schema.base.BaseProductKey.internal_static_opencannabis_base_ProductKey_descriptor;
    }

    public io.opencannabis.schema.base.ProductKey getDefaultInstanceForType() {
      return io.opencannabis.schema.base.ProductKey.getDefaultInstance();
    }

    public io.opencannabis.schema.base.ProductKey build() {
      io.opencannabis.schema.base.ProductKey result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.opencannabis.schema.base.ProductKey buildPartial() {
      io.opencannabis.schema.base.ProductKey result = new io.opencannabis.schema.base.ProductKey(this);
      result.id_ = id_;
      result.type_ = type_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.opencannabis.schema.base.ProductKey) {
        return mergeFrom((io.opencannabis.schema.base.ProductKey)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.opencannabis.schema.base.ProductKey other) {
      if (other == io.opencannabis.schema.base.ProductKey.getDefaultInstance()) return this;
      if (!other.getId().isEmpty()) {
        id_ = other.id_;
        onChanged();
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.opencannabis.schema.base.ProductKey parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.opencannabis.schema.base.ProductKey) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object id_ = "";
    /**
     * <pre>
     * Product ID, an opaque string that is usually autogenerated. Within the scope of an implementing system, this may
     * also be a stringified integer such as an auto-incrementing ID, for relational-type systems. The product ID is
     * expected to be globally addressable and unique across all product categories.
     * </pre>
     *
     * <code>string id = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Product ID, an opaque string that is usually autogenerated."];</code>
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        id_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Product ID, an opaque string that is usually autogenerated. Within the scope of an implementing system, this may
     * also be a stringified integer such as an auto-incrementing ID, for relational-type systems. The product ID is
     * expected to be globally addressable and unique across all product categories.
     * </pre>
     *
     * <code>string id = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Product ID, an opaque string that is usually autogenerated."];</code>
     */
    public com.google.protobuf.ByteString
        getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Product ID, an opaque string that is usually autogenerated. Within the scope of an implementing system, this may
     * also be a stringified integer such as an auto-incrementing ID, for relational-type systems. The product ID is
     * expected to be globally addressable and unique across all product categories.
     * </pre>
     *
     * <code>string id = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Product ID, an opaque string that is usually autogenerated."];</code>
     */
    public Builder setId(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      id_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Product ID, an opaque string that is usually autogenerated. Within the scope of an implementing system, this may
     * also be a stringified integer such as an auto-incrementing ID, for relational-type systems. The product ID is
     * expected to be globally addressable and unique across all product categories.
     * </pre>
     *
     * <code>string id = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Product ID, an opaque string that is usually autogenerated."];</code>
     */
    public Builder clearId() {
      
      id_ = getDefaultInstance().getId();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Product ID, an opaque string that is usually autogenerated. Within the scope of an implementing system, this may
     * also be a stringified integer such as an auto-incrementing ID, for relational-type systems. The product ID is
     * expected to be globally addressable and unique across all product categories.
     * </pre>
     *
     * <code>string id = 1 [(.gen_bq_schema.require) = true, (.gen_bq_schema.description) = "Product ID, an opaque string that is usually autogenerated."];</code>
     */
    public Builder setIdBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      id_ = value;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     * <pre>
     * Type of product the ID is referring to. In most cases this entry can be omitted.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKind type = 2 [(.gen_bq_schema.ignore) = true];</code>
     */
    public int getTypeValue() {
      return type_;
    }
    /**
     * <pre>
     * Type of product the ID is referring to. In most cases this entry can be omitted.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKind type = 2 [(.gen_bq_schema.ignore) = true];</code>
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Type of product the ID is referring to. In most cases this entry can be omitted.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKind type = 2 [(.gen_bq_schema.ignore) = true];</code>
     */
    public io.opencannabis.schema.base.ProductKind getType() {
      io.opencannabis.schema.base.ProductKind result = io.opencannabis.schema.base.ProductKind.valueOf(type_);
      return result == null ? io.opencannabis.schema.base.ProductKind.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Type of product the ID is referring to. In most cases this entry can be omitted.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKind type = 2 [(.gen_bq_schema.ignore) = true];</code>
     */
    public Builder setType(io.opencannabis.schema.base.ProductKind value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Type of product the ID is referring to. In most cases this entry can be omitted.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKind type = 2 [(.gen_bq_schema.ignore) = true];</code>
     */
    public Builder clearType() {
      
      type_ = 0;
      onChanged();
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:opencannabis.base.ProductKey)
  }

  // @@protoc_insertion_point(class_scope:opencannabis.base.ProductKey)
  private static final io.opencannabis.schema.base.ProductKey DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.opencannabis.schema.base.ProductKey();
  }

  public static io.opencannabis.schema.base.ProductKey getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ProductKey>
      PARSER = new com.google.protobuf.AbstractParser<ProductKey>() {
    public ProductKey parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new ProductKey(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<ProductKey> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ProductKey> getParserForType() {
    return PARSER;
  }

  public io.opencannabis.schema.base.ProductKey getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

