/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: base/ProductKind.proto

package io.opencannabis.schema.base;

/**
 * <pre>
 * Enumerates types of products known to the spec.
 * </pre>
 *
 * Protobuf enum {@code opencannabis.base.ProductKind}
 */
public enum ProductKind
    implements com.google.protobuf.ProtocolMessageEnum {
  /**
   * <pre>
   * Traditional buds or 'flower'-based products, essentially sold in bags or jars.
   * </pre>
   *
   * <code>FLOWERS = 0;</code>
   */
  FLOWERS(0),
  /**
   * <pre>
   * Manufactured products that are edible, like drinks, snacks, candy, and food.
   * </pre>
   *
   * <code>EDIBLES = 1;</code>
   */
  EDIBLES(1),
  /**
   * <pre>
   * Manufactured products that are concentrated from flowers in some manner, such as wax or oil.
   * </pre>
   *
   * <code>EXTRACTS = 2;</code>
   */
  EXTRACTS(2),
  /**
   * <pre>
   * Pre-rolled items, generally made from flowers, like a cigarette - this would cover joints, etc.
   * </pre>
   *
   * <code>PREROLLS = 3;</code>
   */
  PREROLLS(3),
  /**
   * <pre>
   * Tinctures, topicals, capsules, and other forms of manufactured cannabis.
   * </pre>
   *
   * <code>APOTHECARY = 4;</code>
   */
  APOTHECARY(4),
  /**
   * <pre>
   * Vaporizor cartridges, batteries, and kits.
   * </pre>
   *
   * <code>CARTRIDGES = 5;</code>
   */
  CARTRIDGES(5),
  /**
   * <pre>
   * Plants sold direct, in various forms such as pre-grown (clones) or raw seeds.
   * </pre>
   *
   * <code>PLANTS = 6;</code>
   */
  PLANTS(6),
  /**
   * <pre>
   * Merchandise, usually branded in-house. Also covers glassware and miscellaneous items.
   * </pre>
   *
   * <code>MERCHANDISE = 7;</code>
   */
  MERCHANDISE(7),
  UNRECOGNIZED(-1),
  ;

  /**
   * <pre>
   * Traditional buds or 'flower'-based products, essentially sold in bags or jars.
   * </pre>
   *
   * <code>FLOWERS = 0;</code>
   */
  public static final int FLOWERS_VALUE = 0;
  /**
   * <pre>
   * Manufactured products that are edible, like drinks, snacks, candy, and food.
   * </pre>
   *
   * <code>EDIBLES = 1;</code>
   */
  public static final int EDIBLES_VALUE = 1;
  /**
   * <pre>
   * Manufactured products that are concentrated from flowers in some manner, such as wax or oil.
   * </pre>
   *
   * <code>EXTRACTS = 2;</code>
   */
  public static final int EXTRACTS_VALUE = 2;
  /**
   * <pre>
   * Pre-rolled items, generally made from flowers, like a cigarette - this would cover joints, etc.
   * </pre>
   *
   * <code>PREROLLS = 3;</code>
   */
  public static final int PREROLLS_VALUE = 3;
  /**
   * <pre>
   * Tinctures, topicals, capsules, and other forms of manufactured cannabis.
   * </pre>
   *
   * <code>APOTHECARY = 4;</code>
   */
  public static final int APOTHECARY_VALUE = 4;
  /**
   * <pre>
   * Vaporizor cartridges, batteries, and kits.
   * </pre>
   *
   * <code>CARTRIDGES = 5;</code>
   */
  public static final int CARTRIDGES_VALUE = 5;
  /**
   * <pre>
   * Plants sold direct, in various forms such as pre-grown (clones) or raw seeds.
   * </pre>
   *
   * <code>PLANTS = 6;</code>
   */
  public static final int PLANTS_VALUE = 6;
  /**
   * <pre>
   * Merchandise, usually branded in-house. Also covers glassware and miscellaneous items.
   * </pre>
   *
   * <code>MERCHANDISE = 7;</code>
   */
  public static final int MERCHANDISE_VALUE = 7;


  public final int getNumber() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalArgumentException(
          "Can't get the number of an unknown enum value.");
    }
    return value;
  }

  /**
   * @deprecated Use {@link #forNumber(int)} instead.
   */
  @java.lang.Deprecated
  public static ProductKind valueOf(int value) {
    return forNumber(value);
  }

  public static ProductKind forNumber(int value) {
    switch (value) {
      case 0: return FLOWERS;
      case 1: return EDIBLES;
      case 2: return EXTRACTS;
      case 3: return PREROLLS;
      case 4: return APOTHECARY;
      case 5: return CARTRIDGES;
      case 6: return PLANTS;
      case 7: return MERCHANDISE;
      default: return null;
    }
  }

  public static com.google.protobuf.Internal.EnumLiteMap<ProductKind>
      internalGetValueMap() {
    return internalValueMap;
  }
  private static final com.google.protobuf.Internal.EnumLiteMap<
      ProductKind> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<ProductKind>() {
          public ProductKind findValueByNumber(int number) {
            return ProductKind.forNumber(number);
          }
        };

  public final com.google.protobuf.Descriptors.EnumValueDescriptor
      getValueDescriptor() {
    return getDescriptor().getValues().get(ordinal());
  }
  public final com.google.protobuf.Descriptors.EnumDescriptor
      getDescriptorForType() {
    return getDescriptor();
  }
  public static final com.google.protobuf.Descriptors.EnumDescriptor
      getDescriptor() {
    return io.opencannabis.schema.base.BaseProductKind.getDescriptor().getEnumTypes().get(0);
  }

  private static final ProductKind[] VALUES = values();

  public static ProductKind valueOf(
      com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
    if (desc.getType() != getDescriptor()) {
      throw new java.lang.IllegalArgumentException(
        "EnumValueDescriptor is not for this type.");
    }
    if (desc.getIndex() == -1) {
      return UNRECOGNIZED;
    }
    return VALUES[desc.getIndex()];
  }

  private final int value;

  private ProductKind(int value) {
    this.value = value;
  }

  // @@protoc_insertion_point(enum_scope:opencannabis.base.ProductKind)
}

