/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: commerce/Item.proto

package io.opencannabis.schema.commerce;

public final class OrderItem {
  private OrderItem() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  /**
   * <pre>
   * Specifies weight and price of  ordered product
   * </pre>
   *
   * Protobuf enum {@code opencannabis.commerce.ProductVariant}
   */
  public enum ProductVariant
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Variance by product weight.
     * </pre>
     *
     * <code>WEIGHT = 0;</code>
     */
    WEIGHT(0),
    /**
     * <pre>
     * Variance by product color.
     * </pre>
     *
     * <code>COLOR = 1;</code>
     */
    COLOR(1),
    /**
     * <pre>
     * Variance by product size.
     * </pre>
     *
     * <code>SIZE = 2;</code>
     */
    SIZE(2),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * Variance by product weight.
     * </pre>
     *
     * <code>WEIGHT = 0;</code>
     */
    public static final int WEIGHT_VALUE = 0;
    /**
     * <pre>
     * Variance by product color.
     * </pre>
     *
     * <code>COLOR = 1;</code>
     */
    public static final int COLOR_VALUE = 1;
    /**
     * <pre>
     * Variance by product size.
     * </pre>
     *
     * <code>SIZE = 2;</code>
     */
    public static final int SIZE_VALUE = 2;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ProductVariant valueOf(int value) {
      return forNumber(value);
    }

    public static ProductVariant forNumber(int value) {
      switch (value) {
        case 0: return WEIGHT;
        case 1: return COLOR;
        case 2: return SIZE;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ProductVariant>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        ProductVariant> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ProductVariant>() {
            public ProductVariant findValueByNumber(int number) {
              return ProductVariant.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.opencannabis.schema.commerce.OrderItem.getDescriptor().getEnumTypes().get(0);
    }

    private static final ProductVariant[] VALUES = values();

    public static ProductVariant valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ProductVariant(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:opencannabis.commerce.ProductVariant)
  }

  public interface VariantSpecOrBuilder extends
      // @@protoc_insertion_point(interface_extends:opencannabis.commerce.VariantSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Specifies the variance type for this spec.
     * </pre>
     *
     * <code>.opencannabis.commerce.ProductVariant variant = 1;</code>
     */
    int getVariantValue();
    /**
     * <pre>
     * Specifies the variance type for this spec.
     * </pre>
     *
     * <code>.opencannabis.commerce.ProductVariant variant = 1;</code>
     */
    io.opencannabis.schema.commerce.OrderItem.ProductVariant getVariant();

    /**
     * <pre>
     * Specifies a product weight, when varying by weight.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.PricingWeightTier weight = 2;</code>
     */
    int getWeightValue();
    /**
     * <pre>
     * Specifies a product weight, when varying by weight.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.PricingWeightTier weight = 2;</code>
     */
    io.opencannabis.schema.product.struct.PricingWeightTier getWeight();

    /**
     * <pre>
     * Specifies a size option for the product.
     * </pre>
     *
     * <code>string size = 3;</code>
     */
    java.lang.String getSize();
    /**
     * <pre>
     * Specifies a size option for the product.
     * </pre>
     *
     * <code>string size = 3;</code>
     */
    com.google.protobuf.ByteString
        getSizeBytes();

    /**
     * <pre>
     * Specifies a color option for the product.
     * </pre>
     *
     * <code>string color = 4;</code>
     */
    java.lang.String getColor();
    /**
     * <pre>
     * Specifies a color option for the product.
     * </pre>
     *
     * <code>string color = 4;</code>
     */
    com.google.protobuf.ByteString
        getColorBytes();

    public io.opencannabis.schema.commerce.OrderItem.VariantSpec.SpecCase getSpecCase();
  }
  /**
   * <pre>
   * Specifies if it is a weighted product or a unit priced product and attaches that to item.
   * </pre>
   *
   * Protobuf type {@code opencannabis.commerce.VariantSpec}
   */
  public  static final class VariantSpec extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:opencannabis.commerce.VariantSpec)
      VariantSpecOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use VariantSpec.newBuilder() to construct.
    private VariantSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private VariantSpec() {
      variant_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private VariantSpec(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();

              variant_ = rawValue;
              break;
            }
            case 16: {
              int rawValue = input.readEnum();
              specCase_ = 2;
              spec_ = rawValue;
              break;
            }
            case 26: {
              java.lang.String s = input.readStringRequireUtf8();
              specCase_ = 3;
              spec_ = s;
              break;
            }
            case 34: {
              java.lang.String s = input.readStringRequireUtf8();
              specCase_ = 4;
              spec_ = s;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.commerce.OrderItem.internal_static_opencannabis_commerce_VariantSpec_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.commerce.OrderItem.internal_static_opencannabis_commerce_VariantSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.commerce.OrderItem.VariantSpec.class, io.opencannabis.schema.commerce.OrderItem.VariantSpec.Builder.class);
    }

    private int specCase_ = 0;
    private java.lang.Object spec_;
    public enum SpecCase
        implements com.google.protobuf.Internal.EnumLite {
      WEIGHT(2),
      SIZE(3),
      COLOR(4),
      SPEC_NOT_SET(0);
      private final int value;
      private SpecCase(int value) {
        this.value = value;
      }
      /**
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static SpecCase valueOf(int value) {
        return forNumber(value);
      }

      public static SpecCase forNumber(int value) {
        switch (value) {
          case 2: return WEIGHT;
          case 3: return SIZE;
          case 4: return COLOR;
          case 0: return SPEC_NOT_SET;
          default: return null;
        }
      }
      public int getNumber() {
        return this.value;
      }
    };

    public SpecCase
    getSpecCase() {
      return SpecCase.forNumber(
          specCase_);
    }

    public static final int VARIANT_FIELD_NUMBER = 1;
    private int variant_;
    /**
     * <pre>
     * Specifies the variance type for this spec.
     * </pre>
     *
     * <code>.opencannabis.commerce.ProductVariant variant = 1;</code>
     */
    public int getVariantValue() {
      return variant_;
    }
    /**
     * <pre>
     * Specifies the variance type for this spec.
     * </pre>
     *
     * <code>.opencannabis.commerce.ProductVariant variant = 1;</code>
     */
    public io.opencannabis.schema.commerce.OrderItem.ProductVariant getVariant() {
      io.opencannabis.schema.commerce.OrderItem.ProductVariant result = io.opencannabis.schema.commerce.OrderItem.ProductVariant.valueOf(variant_);
      return result == null ? io.opencannabis.schema.commerce.OrderItem.ProductVariant.UNRECOGNIZED : result;
    }

    public static final int WEIGHT_FIELD_NUMBER = 2;
    /**
     * <pre>
     * Specifies a product weight, when varying by weight.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.PricingWeightTier weight = 2;</code>
     */
    public int getWeightValue() {
      if (specCase_ == 2) {
        return (java.lang.Integer) spec_;
      }
      return 0;
    }
    /**
     * <pre>
     * Specifies a product weight, when varying by weight.
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.PricingWeightTier weight = 2;</code>
     */
    public io.opencannabis.schema.product.struct.PricingWeightTier getWeight() {
      if (specCase_ == 2) {
        io.opencannabis.schema.product.struct.PricingWeightTier result = io.opencannabis.schema.product.struct.PricingWeightTier.valueOf(
            (java.lang.Integer) spec_);
        return result == null ? io.opencannabis.schema.product.struct.PricingWeightTier.UNRECOGNIZED : result;
      }
      return io.opencannabis.schema.product.struct.PricingWeightTier.NO_WEIGHT;
    }

    public static final int SIZE_FIELD_NUMBER = 3;
    /**
     * <pre>
     * Specifies a size option for the product.
     * </pre>
     *
     * <code>string size = 3;</code>
     */
    public java.lang.String getSize() {
      java.lang.Object ref = "";
      if (specCase_ == 3) {
        ref = spec_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (specCase_ == 3) {
          spec_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * Specifies a size option for the product.
     * </pre>
     *
     * <code>string size = 3;</code>
     */
    public com.google.protobuf.ByteString
        getSizeBytes() {
      java.lang.Object ref = "";
      if (specCase_ == 3) {
        ref = spec_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        if (specCase_ == 3) {
          spec_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int COLOR_FIELD_NUMBER = 4;
    /**
     * <pre>
     * Specifies a color option for the product.
     * </pre>
     *
     * <code>string color = 4;</code>
     */
    public java.lang.String getColor() {
      java.lang.Object ref = "";
      if (specCase_ == 4) {
        ref = spec_;
      }
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (specCase_ == 4) {
          spec_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * Specifies a color option for the product.
     * </pre>
     *
     * <code>string color = 4;</code>
     */
    public com.google.protobuf.ByteString
        getColorBytes() {
      java.lang.Object ref = "";
      if (specCase_ == 4) {
        ref = spec_;
      }
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        if (specCase_ == 4) {
          spec_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (variant_ != io.opencannabis.schema.commerce.OrderItem.ProductVariant.WEIGHT.getNumber()) {
        output.writeEnum(1, variant_);
      }
      if (specCase_ == 2) {
        output.writeEnum(2, ((java.lang.Integer) spec_));
      }
      if (specCase_ == 3) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, spec_);
      }
      if (specCase_ == 4) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, spec_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (variant_ != io.opencannabis.schema.commerce.OrderItem.ProductVariant.WEIGHT.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, variant_);
      }
      if (specCase_ == 2) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, ((java.lang.Integer) spec_));
      }
      if (specCase_ == 3) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, spec_);
      }
      if (specCase_ == 4) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, spec_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.opencannabis.schema.commerce.OrderItem.VariantSpec)) {
        return super.equals(obj);
      }
      io.opencannabis.schema.commerce.OrderItem.VariantSpec other = (io.opencannabis.schema.commerce.OrderItem.VariantSpec) obj;

      boolean result = true;
      result = result && variant_ == other.variant_;
      result = result && getSpecCase().equals(
          other.getSpecCase());
      if (!result) return false;
      switch (specCase_) {
        case 2:
          result = result && getWeightValue()
              == other.getWeightValue();
          break;
        case 3:
          result = result && getSize()
              .equals(other.getSize());
          break;
        case 4:
          result = result && getColor()
              .equals(other.getColor());
          break;
        case 0:
        default:
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + VARIANT_FIELD_NUMBER;
      hash = (53 * hash) + variant_;
      switch (specCase_) {
        case 2:
          hash = (37 * hash) + WEIGHT_FIELD_NUMBER;
          hash = (53 * hash) + getWeightValue();
          break;
        case 3:
          hash = (37 * hash) + SIZE_FIELD_NUMBER;
          hash = (53 * hash) + getSize().hashCode();
          break;
        case 4:
          hash = (37 * hash) + COLOR_FIELD_NUMBER;
          hash = (53 * hash) + getColor().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.opencannabis.schema.commerce.OrderItem.VariantSpec parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.commerce.OrderItem.VariantSpec parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.commerce.OrderItem.VariantSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.commerce.OrderItem.VariantSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.commerce.OrderItem.VariantSpec parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.commerce.OrderItem.VariantSpec parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.commerce.OrderItem.VariantSpec parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.commerce.OrderItem.VariantSpec parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.opencannabis.schema.commerce.OrderItem.VariantSpec parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.commerce.OrderItem.VariantSpec parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.opencannabis.schema.commerce.OrderItem.VariantSpec parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.commerce.OrderItem.VariantSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.opencannabis.schema.commerce.OrderItem.VariantSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies if it is a weighted product or a unit priced product and attaches that to item.
     * </pre>
     *
     * Protobuf type {@code opencannabis.commerce.VariantSpec}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:opencannabis.commerce.VariantSpec)
        io.opencannabis.schema.commerce.OrderItem.VariantSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.opencannabis.schema.commerce.OrderItem.internal_static_opencannabis_commerce_VariantSpec_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.opencannabis.schema.commerce.OrderItem.internal_static_opencannabis_commerce_VariantSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.opencannabis.schema.commerce.OrderItem.VariantSpec.class, io.opencannabis.schema.commerce.OrderItem.VariantSpec.Builder.class);
      }

      // Construct using io.opencannabis.schema.commerce.OrderItem.VariantSpec.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        variant_ = 0;

        specCase_ = 0;
        spec_ = null;
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.opencannabis.schema.commerce.OrderItem.internal_static_opencannabis_commerce_VariantSpec_descriptor;
      }

      public io.opencannabis.schema.commerce.OrderItem.VariantSpec getDefaultInstanceForType() {
        return io.opencannabis.schema.commerce.OrderItem.VariantSpec.getDefaultInstance();
      }

      public io.opencannabis.schema.commerce.OrderItem.VariantSpec build() {
        io.opencannabis.schema.commerce.OrderItem.VariantSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.opencannabis.schema.commerce.OrderItem.VariantSpec buildPartial() {
        io.opencannabis.schema.commerce.OrderItem.VariantSpec result = new io.opencannabis.schema.commerce.OrderItem.VariantSpec(this);
        result.variant_ = variant_;
        if (specCase_ == 2) {
          result.spec_ = spec_;
        }
        if (specCase_ == 3) {
          result.spec_ = spec_;
        }
        if (specCase_ == 4) {
          result.spec_ = spec_;
        }
        result.specCase_ = specCase_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.opencannabis.schema.commerce.OrderItem.VariantSpec) {
          return mergeFrom((io.opencannabis.schema.commerce.OrderItem.VariantSpec)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.opencannabis.schema.commerce.OrderItem.VariantSpec other) {
        if (other == io.opencannabis.schema.commerce.OrderItem.VariantSpec.getDefaultInstance()) return this;
        if (other.variant_ != 0) {
          setVariantValue(other.getVariantValue());
        }
        switch (other.getSpecCase()) {
          case WEIGHT: {
            setWeightValue(other.getWeightValue());
            break;
          }
          case SIZE: {
            specCase_ = 3;
            spec_ = other.spec_;
            onChanged();
            break;
          }
          case COLOR: {
            specCase_ = 4;
            spec_ = other.spec_;
            onChanged();
            break;
          }
          case SPEC_NOT_SET: {
            break;
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.opencannabis.schema.commerce.OrderItem.VariantSpec parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.opencannabis.schema.commerce.OrderItem.VariantSpec) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int specCase_ = 0;
      private java.lang.Object spec_;
      public SpecCase
          getSpecCase() {
        return SpecCase.forNumber(
            specCase_);
      }

      public Builder clearSpec() {
        specCase_ = 0;
        spec_ = null;
        onChanged();
        return this;
      }


      private int variant_ = 0;
      /**
       * <pre>
       * Specifies the variance type for this spec.
       * </pre>
       *
       * <code>.opencannabis.commerce.ProductVariant variant = 1;</code>
       */
      public int getVariantValue() {
        return variant_;
      }
      /**
       * <pre>
       * Specifies the variance type for this spec.
       * </pre>
       *
       * <code>.opencannabis.commerce.ProductVariant variant = 1;</code>
       */
      public Builder setVariantValue(int value) {
        variant_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies the variance type for this spec.
       * </pre>
       *
       * <code>.opencannabis.commerce.ProductVariant variant = 1;</code>
       */
      public io.opencannabis.schema.commerce.OrderItem.ProductVariant getVariant() {
        io.opencannabis.schema.commerce.OrderItem.ProductVariant result = io.opencannabis.schema.commerce.OrderItem.ProductVariant.valueOf(variant_);
        return result == null ? io.opencannabis.schema.commerce.OrderItem.ProductVariant.UNRECOGNIZED : result;
      }
      /**
       * <pre>
       * Specifies the variance type for this spec.
       * </pre>
       *
       * <code>.opencannabis.commerce.ProductVariant variant = 1;</code>
       */
      public Builder setVariant(io.opencannabis.schema.commerce.OrderItem.ProductVariant value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        variant_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies the variance type for this spec.
       * </pre>
       *
       * <code>.opencannabis.commerce.ProductVariant variant = 1;</code>
       */
      public Builder clearVariant() {
        
        variant_ = 0;
        onChanged();
        return this;
      }

      /**
       * <pre>
       * Specifies a product weight, when varying by weight.
       * </pre>
       *
       * <code>.opencannabis.structs.pricing.PricingWeightTier weight = 2;</code>
       */
      public int getWeightValue() {
        if (specCase_ == 2) {
          return ((java.lang.Integer) spec_).intValue();
        }
        return 0;
      }
      /**
       * <pre>
       * Specifies a product weight, when varying by weight.
       * </pre>
       *
       * <code>.opencannabis.structs.pricing.PricingWeightTier weight = 2;</code>
       */
      public Builder setWeightValue(int value) {
        specCase_ = 2;
        spec_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies a product weight, when varying by weight.
       * </pre>
       *
       * <code>.opencannabis.structs.pricing.PricingWeightTier weight = 2;</code>
       */
      public io.opencannabis.schema.product.struct.PricingWeightTier getWeight() {
        if (specCase_ == 2) {
          io.opencannabis.schema.product.struct.PricingWeightTier result = io.opencannabis.schema.product.struct.PricingWeightTier.valueOf(
              (java.lang.Integer) spec_);
          return result == null ? io.opencannabis.schema.product.struct.PricingWeightTier.UNRECOGNIZED : result;
        }
        return io.opencannabis.schema.product.struct.PricingWeightTier.NO_WEIGHT;
      }
      /**
       * <pre>
       * Specifies a product weight, when varying by weight.
       * </pre>
       *
       * <code>.opencannabis.structs.pricing.PricingWeightTier weight = 2;</code>
       */
      public Builder setWeight(io.opencannabis.schema.product.struct.PricingWeightTier value) {
        if (value == null) {
          throw new NullPointerException();
        }
        specCase_ = 2;
        spec_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies a product weight, when varying by weight.
       * </pre>
       *
       * <code>.opencannabis.structs.pricing.PricingWeightTier weight = 2;</code>
       */
      public Builder clearWeight() {
        if (specCase_ == 2) {
          specCase_ = 0;
          spec_ = null;
          onChanged();
        }
        return this;
      }

      /**
       * <pre>
       * Specifies a size option for the product.
       * </pre>
       *
       * <code>string size = 3;</code>
       */
      public java.lang.String getSize() {
        java.lang.Object ref = "";
        if (specCase_ == 3) {
          ref = spec_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (specCase_ == 3) {
            spec_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Specifies a size option for the product.
       * </pre>
       *
       * <code>string size = 3;</code>
       */
      public com.google.protobuf.ByteString
          getSizeBytes() {
        java.lang.Object ref = "";
        if (specCase_ == 3) {
          ref = spec_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          if (specCase_ == 3) {
            spec_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Specifies a size option for the product.
       * </pre>
       *
       * <code>string size = 3;</code>
       */
      public Builder setSize(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  specCase_ = 3;
        spec_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies a size option for the product.
       * </pre>
       *
       * <code>string size = 3;</code>
       */
      public Builder clearSize() {
        if (specCase_ == 3) {
          specCase_ = 0;
          spec_ = null;
          onChanged();
        }
        return this;
      }
      /**
       * <pre>
       * Specifies a size option for the product.
       * </pre>
       *
       * <code>string size = 3;</code>
       */
      public Builder setSizeBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        specCase_ = 3;
        spec_ = value;
        onChanged();
        return this;
      }

      /**
       * <pre>
       * Specifies a color option for the product.
       * </pre>
       *
       * <code>string color = 4;</code>
       */
      public java.lang.String getColor() {
        java.lang.Object ref = "";
        if (specCase_ == 4) {
          ref = spec_;
        }
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (specCase_ == 4) {
            spec_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Specifies a color option for the product.
       * </pre>
       *
       * <code>string color = 4;</code>
       */
      public com.google.protobuf.ByteString
          getColorBytes() {
        java.lang.Object ref = "";
        if (specCase_ == 4) {
          ref = spec_;
        }
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          if (specCase_ == 4) {
            spec_ = b;
          }
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Specifies a color option for the product.
       * </pre>
       *
       * <code>string color = 4;</code>
       */
      public Builder setColor(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  specCase_ = 4;
        spec_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Specifies a color option for the product.
       * </pre>
       *
       * <code>string color = 4;</code>
       */
      public Builder clearColor() {
        if (specCase_ == 4) {
          specCase_ = 0;
          spec_ = null;
          onChanged();
        }
        return this;
      }
      /**
       * <pre>
       * Specifies a color option for the product.
       * </pre>
       *
       * <code>string color = 4;</code>
       */
      public Builder setColorBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        specCase_ = 4;
        spec_ = value;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:opencannabis.commerce.VariantSpec)
    }

    // @@protoc_insertion_point(class_scope:opencannabis.commerce.VariantSpec)
    private static final io.opencannabis.schema.commerce.OrderItem.VariantSpec DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.opencannabis.schema.commerce.OrderItem.VariantSpec();
    }

    public static io.opencannabis.schema.commerce.OrderItem.VariantSpec getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<VariantSpec>
        PARSER = new com.google.protobuf.AbstractParser<VariantSpec>() {
      public VariantSpec parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new VariantSpec(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<VariantSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<VariantSpec> getParserForType() {
      return PARSER;
    }

    public io.opencannabis.schema.commerce.OrderItem.VariantSpec getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ItemOrBuilder extends
      // @@protoc_insertion_point(interface_extends:opencannabis.commerce.Item)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * Key for the item, which is the type and ID, combined.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    boolean hasKey();
    /**
     * <pre>
     * Key for the item, which is the type and ID, combined.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    io.opencannabis.schema.base.ProductKey getKey();
    /**
     * <pre>
     * Key for the item, which is the type and ID, combined.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    io.opencannabis.schema.base.ProductKeyOrBuilder getKeyOrBuilder();

    /**
     * <pre>
     * Variance specifications for this item.
     * </pre>
     *
     * <code>repeated .opencannabis.commerce.VariantSpec variant = 2;</code>
     */
    java.util.List<io.opencannabis.schema.commerce.OrderItem.VariantSpec> 
        getVariantList();
    /**
     * <pre>
     * Variance specifications for this item.
     * </pre>
     *
     * <code>repeated .opencannabis.commerce.VariantSpec variant = 2;</code>
     */
    io.opencannabis.schema.commerce.OrderItem.VariantSpec getVariant(int index);
    /**
     * <pre>
     * Variance specifications for this item.
     * </pre>
     *
     * <code>repeated .opencannabis.commerce.VariantSpec variant = 2;</code>
     */
    int getVariantCount();
    /**
     * <pre>
     * Variance specifications for this item.
     * </pre>
     *
     * <code>repeated .opencannabis.commerce.VariantSpec variant = 2;</code>
     */
    java.util.List<? extends io.opencannabis.schema.commerce.OrderItem.VariantSpecOrBuilder> 
        getVariantOrBuilderList();
    /**
     * <pre>
     * Variance specifications for this item.
     * </pre>
     *
     * <code>repeated .opencannabis.commerce.VariantSpec variant = 2;</code>
     */
    io.opencannabis.schema.commerce.OrderItem.VariantSpecOrBuilder getVariantOrBuilder(
        int index);

    /**
     * <pre>
     * Count of this item requested.
     * </pre>
     *
     * <code>uint32 count = 3;</code>
     */
    int getCount();
  }
  /**
   * <pre>
   * Specifies the Item via the product key as well as weight, and count of product ordered
   * </pre>
   *
   * Protobuf type {@code opencannabis.commerce.Item}
   */
  public  static final class Item extends
      com.google.protobuf.GeneratedMessageV3 implements
      // @@protoc_insertion_point(message_implements:opencannabis.commerce.Item)
      ItemOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Item.newBuilder() to construct.
    private Item(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }
    private Item() {
      variant_ = java.util.Collections.emptyList();
      count_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Item(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownFieldProto3(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              io.opencannabis.schema.base.ProductKey.Builder subBuilder = null;
              if (key_ != null) {
                subBuilder = key_.toBuilder();
              }
              key_ = input.readMessage(io.opencannabis.schema.base.ProductKey.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(key_);
                key_ = subBuilder.buildPartial();
              }

              break;
            }
            case 18: {
              if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                variant_ = new java.util.ArrayList<io.opencannabis.schema.commerce.OrderItem.VariantSpec>();
                mutable_bitField0_ |= 0x00000002;
              }
              variant_.add(
                  input.readMessage(io.opencannabis.schema.commerce.OrderItem.VariantSpec.parser(), extensionRegistry));
              break;
            }
            case 24: {

              count_ = input.readUInt32();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
          variant_ = java.util.Collections.unmodifiableList(variant_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.commerce.OrderItem.internal_static_opencannabis_commerce_Item_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.commerce.OrderItem.internal_static_opencannabis_commerce_Item_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.commerce.OrderItem.Item.class, io.opencannabis.schema.commerce.OrderItem.Item.Builder.class);
    }

    private int bitField0_;
    public static final int KEY_FIELD_NUMBER = 1;
    private io.opencannabis.schema.base.ProductKey key_;
    /**
     * <pre>
     * Key for the item, which is the type and ID, combined.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    public boolean hasKey() {
      return key_ != null;
    }
    /**
     * <pre>
     * Key for the item, which is the type and ID, combined.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    public io.opencannabis.schema.base.ProductKey getKey() {
      return key_ == null ? io.opencannabis.schema.base.ProductKey.getDefaultInstance() : key_;
    }
    /**
     * <pre>
     * Key for the item, which is the type and ID, combined.
     * </pre>
     *
     * <code>.opencannabis.base.ProductKey key = 1;</code>
     */
    public io.opencannabis.schema.base.ProductKeyOrBuilder getKeyOrBuilder() {
      return getKey();
    }

    public static final int VARIANT_FIELD_NUMBER = 2;
    private java.util.List<io.opencannabis.schema.commerce.OrderItem.VariantSpec> variant_;
    /**
     * <pre>
     * Variance specifications for this item.
     * </pre>
     *
     * <code>repeated .opencannabis.commerce.VariantSpec variant = 2;</code>
     */
    public java.util.List<io.opencannabis.schema.commerce.OrderItem.VariantSpec> getVariantList() {
      return variant_;
    }
    /**
     * <pre>
     * Variance specifications for this item.
     * </pre>
     *
     * <code>repeated .opencannabis.commerce.VariantSpec variant = 2;</code>
     */
    public java.util.List<? extends io.opencannabis.schema.commerce.OrderItem.VariantSpecOrBuilder> 
        getVariantOrBuilderList() {
      return variant_;
    }
    /**
     * <pre>
     * Variance specifications for this item.
     * </pre>
     *
     * <code>repeated .opencannabis.commerce.VariantSpec variant = 2;</code>
     */
    public int getVariantCount() {
      return variant_.size();
    }
    /**
     * <pre>
     * Variance specifications for this item.
     * </pre>
     *
     * <code>repeated .opencannabis.commerce.VariantSpec variant = 2;</code>
     */
    public io.opencannabis.schema.commerce.OrderItem.VariantSpec getVariant(int index) {
      return variant_.get(index);
    }
    /**
     * <pre>
     * Variance specifications for this item.
     * </pre>
     *
     * <code>repeated .opencannabis.commerce.VariantSpec variant = 2;</code>
     */
    public io.opencannabis.schema.commerce.OrderItem.VariantSpecOrBuilder getVariantOrBuilder(
        int index) {
      return variant_.get(index);
    }

    public static final int COUNT_FIELD_NUMBER = 3;
    private int count_;
    /**
     * <pre>
     * Count of this item requested.
     * </pre>
     *
     * <code>uint32 count = 3;</code>
     */
    public int getCount() {
      return count_;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (key_ != null) {
        output.writeMessage(1, getKey());
      }
      for (int i = 0; i < variant_.size(); i++) {
        output.writeMessage(2, variant_.get(i));
      }
      if (count_ != 0) {
        output.writeUInt32(3, count_);
      }
      unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (key_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getKey());
      }
      for (int i = 0; i < variant_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, variant_.get(i));
      }
      if (count_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(3, count_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof io.opencannabis.schema.commerce.OrderItem.Item)) {
        return super.equals(obj);
      }
      io.opencannabis.schema.commerce.OrderItem.Item other = (io.opencannabis.schema.commerce.OrderItem.Item) obj;

      boolean result = true;
      result = result && (hasKey() == other.hasKey());
      if (hasKey()) {
        result = result && getKey()
            .equals(other.getKey());
      }
      result = result && getVariantList()
          .equals(other.getVariantList());
      result = result && (getCount()
          == other.getCount());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasKey()) {
        hash = (37 * hash) + KEY_FIELD_NUMBER;
        hash = (53 * hash) + getKey().hashCode();
      }
      if (getVariantCount() > 0) {
        hash = (37 * hash) + VARIANT_FIELD_NUMBER;
        hash = (53 * hash) + getVariantList().hashCode();
      }
      hash = (37 * hash) + COUNT_FIELD_NUMBER;
      hash = (53 * hash) + getCount();
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.opencannabis.schema.commerce.OrderItem.Item parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.commerce.OrderItem.Item parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.commerce.OrderItem.Item parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.commerce.OrderItem.Item parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.commerce.OrderItem.Item parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static io.opencannabis.schema.commerce.OrderItem.Item parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static io.opencannabis.schema.commerce.OrderItem.Item parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.commerce.OrderItem.Item parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.opencannabis.schema.commerce.OrderItem.Item parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.commerce.OrderItem.Item parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static io.opencannabis.schema.commerce.OrderItem.Item parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static io.opencannabis.schema.commerce.OrderItem.Item parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(io.opencannabis.schema.commerce.OrderItem.Item prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Specifies the Item via the product key as well as weight, and count of product ordered
     * </pre>
     *
     * Protobuf type {@code opencannabis.commerce.Item}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:opencannabis.commerce.Item)
        io.opencannabis.schema.commerce.OrderItem.ItemOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return io.opencannabis.schema.commerce.OrderItem.internal_static_opencannabis_commerce_Item_descriptor;
      }

      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.opencannabis.schema.commerce.OrderItem.internal_static_opencannabis_commerce_Item_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.opencannabis.schema.commerce.OrderItem.Item.class, io.opencannabis.schema.commerce.OrderItem.Item.Builder.class);
      }

      // Construct using io.opencannabis.schema.commerce.OrderItem.Item.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getVariantFieldBuilder();
        }
      }
      public Builder clear() {
        super.clear();
        if (keyBuilder_ == null) {
          key_ = null;
        } else {
          key_ = null;
          keyBuilder_ = null;
        }
        if (variantBuilder_ == null) {
          variant_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          variantBuilder_.clear();
        }
        count_ = 0;

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return io.opencannabis.schema.commerce.OrderItem.internal_static_opencannabis_commerce_Item_descriptor;
      }

      public io.opencannabis.schema.commerce.OrderItem.Item getDefaultInstanceForType() {
        return io.opencannabis.schema.commerce.OrderItem.Item.getDefaultInstance();
      }

      public io.opencannabis.schema.commerce.OrderItem.Item build() {
        io.opencannabis.schema.commerce.OrderItem.Item result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public io.opencannabis.schema.commerce.OrderItem.Item buildPartial() {
        io.opencannabis.schema.commerce.OrderItem.Item result = new io.opencannabis.schema.commerce.OrderItem.Item(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (keyBuilder_ == null) {
          result.key_ = key_;
        } else {
          result.key_ = keyBuilder_.build();
        }
        if (variantBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)) {
            variant_ = java.util.Collections.unmodifiableList(variant_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.variant_ = variant_;
        } else {
          result.variant_ = variantBuilder_.build();
        }
        result.count_ = count_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder clone() {
        return (Builder) super.clone();
      }
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.opencannabis.schema.commerce.OrderItem.Item) {
          return mergeFrom((io.opencannabis.schema.commerce.OrderItem.Item)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.opencannabis.schema.commerce.OrderItem.Item other) {
        if (other == io.opencannabis.schema.commerce.OrderItem.Item.getDefaultInstance()) return this;
        if (other.hasKey()) {
          mergeKey(other.getKey());
        }
        if (variantBuilder_ == null) {
          if (!other.variant_.isEmpty()) {
            if (variant_.isEmpty()) {
              variant_ = other.variant_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureVariantIsMutable();
              variant_.addAll(other.variant_);
            }
            onChanged();
          }
        } else {
          if (!other.variant_.isEmpty()) {
            if (variantBuilder_.isEmpty()) {
              variantBuilder_.dispose();
              variantBuilder_ = null;
              variant_ = other.variant_;
              bitField0_ = (bitField0_ & ~0x00000002);
              variantBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getVariantFieldBuilder() : null;
            } else {
              variantBuilder_.addAllMessages(other.variant_);
            }
          }
        }
        if (other.getCount() != 0) {
          setCount(other.getCount());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.opencannabis.schema.commerce.OrderItem.Item parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.opencannabis.schema.commerce.OrderItem.Item) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private io.opencannabis.schema.base.ProductKey key_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder> keyBuilder_;
      /**
       * <pre>
       * Key for the item, which is the type and ID, combined.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public boolean hasKey() {
        return keyBuilder_ != null || key_ != null;
      }
      /**
       * <pre>
       * Key for the item, which is the type and ID, combined.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public io.opencannabis.schema.base.ProductKey getKey() {
        if (keyBuilder_ == null) {
          return key_ == null ? io.opencannabis.schema.base.ProductKey.getDefaultInstance() : key_;
        } else {
          return keyBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Key for the item, which is the type and ID, combined.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder setKey(io.opencannabis.schema.base.ProductKey value) {
        if (keyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          key_ = value;
          onChanged();
        } else {
          keyBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <pre>
       * Key for the item, which is the type and ID, combined.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder setKey(
          io.opencannabis.schema.base.ProductKey.Builder builderForValue) {
        if (keyBuilder_ == null) {
          key_ = builderForValue.build();
          onChanged();
        } else {
          keyBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <pre>
       * Key for the item, which is the type and ID, combined.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder mergeKey(io.opencannabis.schema.base.ProductKey value) {
        if (keyBuilder_ == null) {
          if (key_ != null) {
            key_ =
              io.opencannabis.schema.base.ProductKey.newBuilder(key_).mergeFrom(value).buildPartial();
          } else {
            key_ = value;
          }
          onChanged();
        } else {
          keyBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <pre>
       * Key for the item, which is the type and ID, combined.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public Builder clearKey() {
        if (keyBuilder_ == null) {
          key_ = null;
          onChanged();
        } else {
          key_ = null;
          keyBuilder_ = null;
        }

        return this;
      }
      /**
       * <pre>
       * Key for the item, which is the type and ID, combined.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public io.opencannabis.schema.base.ProductKey.Builder getKeyBuilder() {
        
        onChanged();
        return getKeyFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Key for the item, which is the type and ID, combined.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      public io.opencannabis.schema.base.ProductKeyOrBuilder getKeyOrBuilder() {
        if (keyBuilder_ != null) {
          return keyBuilder_.getMessageOrBuilder();
        } else {
          return key_ == null ?
              io.opencannabis.schema.base.ProductKey.getDefaultInstance() : key_;
        }
      }
      /**
       * <pre>
       * Key for the item, which is the type and ID, combined.
       * </pre>
       *
       * <code>.opencannabis.base.ProductKey key = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder> 
          getKeyFieldBuilder() {
        if (keyBuilder_ == null) {
          keyBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              io.opencannabis.schema.base.ProductKey, io.opencannabis.schema.base.ProductKey.Builder, io.opencannabis.schema.base.ProductKeyOrBuilder>(
                  getKey(),
                  getParentForChildren(),
                  isClean());
          key_ = null;
        }
        return keyBuilder_;
      }

      private java.util.List<io.opencannabis.schema.commerce.OrderItem.VariantSpec> variant_ =
        java.util.Collections.emptyList();
      private void ensureVariantIsMutable() {
        if (!((bitField0_ & 0x00000002) == 0x00000002)) {
          variant_ = new java.util.ArrayList<io.opencannabis.schema.commerce.OrderItem.VariantSpec>(variant_);
          bitField0_ |= 0x00000002;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.opencannabis.schema.commerce.OrderItem.VariantSpec, io.opencannabis.schema.commerce.OrderItem.VariantSpec.Builder, io.opencannabis.schema.commerce.OrderItem.VariantSpecOrBuilder> variantBuilder_;

      /**
       * <pre>
       * Variance specifications for this item.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.VariantSpec variant = 2;</code>
       */
      public java.util.List<io.opencannabis.schema.commerce.OrderItem.VariantSpec> getVariantList() {
        if (variantBuilder_ == null) {
          return java.util.Collections.unmodifiableList(variant_);
        } else {
          return variantBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Variance specifications for this item.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.VariantSpec variant = 2;</code>
       */
      public int getVariantCount() {
        if (variantBuilder_ == null) {
          return variant_.size();
        } else {
          return variantBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Variance specifications for this item.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.VariantSpec variant = 2;</code>
       */
      public io.opencannabis.schema.commerce.OrderItem.VariantSpec getVariant(int index) {
        if (variantBuilder_ == null) {
          return variant_.get(index);
        } else {
          return variantBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Variance specifications for this item.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.VariantSpec variant = 2;</code>
       */
      public Builder setVariant(
          int index, io.opencannabis.schema.commerce.OrderItem.VariantSpec value) {
        if (variantBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureVariantIsMutable();
          variant_.set(index, value);
          onChanged();
        } else {
          variantBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Variance specifications for this item.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.VariantSpec variant = 2;</code>
       */
      public Builder setVariant(
          int index, io.opencannabis.schema.commerce.OrderItem.VariantSpec.Builder builderForValue) {
        if (variantBuilder_ == null) {
          ensureVariantIsMutable();
          variant_.set(index, builderForValue.build());
          onChanged();
        } else {
          variantBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Variance specifications for this item.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.VariantSpec variant = 2;</code>
       */
      public Builder addVariant(io.opencannabis.schema.commerce.OrderItem.VariantSpec value) {
        if (variantBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureVariantIsMutable();
          variant_.add(value);
          onChanged();
        } else {
          variantBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Variance specifications for this item.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.VariantSpec variant = 2;</code>
       */
      public Builder addVariant(
          int index, io.opencannabis.schema.commerce.OrderItem.VariantSpec value) {
        if (variantBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureVariantIsMutable();
          variant_.add(index, value);
          onChanged();
        } else {
          variantBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Variance specifications for this item.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.VariantSpec variant = 2;</code>
       */
      public Builder addVariant(
          io.opencannabis.schema.commerce.OrderItem.VariantSpec.Builder builderForValue) {
        if (variantBuilder_ == null) {
          ensureVariantIsMutable();
          variant_.add(builderForValue.build());
          onChanged();
        } else {
          variantBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Variance specifications for this item.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.VariantSpec variant = 2;</code>
       */
      public Builder addVariant(
          int index, io.opencannabis.schema.commerce.OrderItem.VariantSpec.Builder builderForValue) {
        if (variantBuilder_ == null) {
          ensureVariantIsMutable();
          variant_.add(index, builderForValue.build());
          onChanged();
        } else {
          variantBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Variance specifications for this item.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.VariantSpec variant = 2;</code>
       */
      public Builder addAllVariant(
          java.lang.Iterable<? extends io.opencannabis.schema.commerce.OrderItem.VariantSpec> values) {
        if (variantBuilder_ == null) {
          ensureVariantIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, variant_);
          onChanged();
        } else {
          variantBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Variance specifications for this item.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.VariantSpec variant = 2;</code>
       */
      public Builder clearVariant() {
        if (variantBuilder_ == null) {
          variant_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          variantBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Variance specifications for this item.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.VariantSpec variant = 2;</code>
       */
      public Builder removeVariant(int index) {
        if (variantBuilder_ == null) {
          ensureVariantIsMutable();
          variant_.remove(index);
          onChanged();
        } else {
          variantBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Variance specifications for this item.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.VariantSpec variant = 2;</code>
       */
      public io.opencannabis.schema.commerce.OrderItem.VariantSpec.Builder getVariantBuilder(
          int index) {
        return getVariantFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Variance specifications for this item.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.VariantSpec variant = 2;</code>
       */
      public io.opencannabis.schema.commerce.OrderItem.VariantSpecOrBuilder getVariantOrBuilder(
          int index) {
        if (variantBuilder_ == null) {
          return variant_.get(index);  } else {
          return variantBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Variance specifications for this item.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.VariantSpec variant = 2;</code>
       */
      public java.util.List<? extends io.opencannabis.schema.commerce.OrderItem.VariantSpecOrBuilder> 
           getVariantOrBuilderList() {
        if (variantBuilder_ != null) {
          return variantBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(variant_);
        }
      }
      /**
       * <pre>
       * Variance specifications for this item.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.VariantSpec variant = 2;</code>
       */
      public io.opencannabis.schema.commerce.OrderItem.VariantSpec.Builder addVariantBuilder() {
        return getVariantFieldBuilder().addBuilder(
            io.opencannabis.schema.commerce.OrderItem.VariantSpec.getDefaultInstance());
      }
      /**
       * <pre>
       * Variance specifications for this item.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.VariantSpec variant = 2;</code>
       */
      public io.opencannabis.schema.commerce.OrderItem.VariantSpec.Builder addVariantBuilder(
          int index) {
        return getVariantFieldBuilder().addBuilder(
            index, io.opencannabis.schema.commerce.OrderItem.VariantSpec.getDefaultInstance());
      }
      /**
       * <pre>
       * Variance specifications for this item.
       * </pre>
       *
       * <code>repeated .opencannabis.commerce.VariantSpec variant = 2;</code>
       */
      public java.util.List<io.opencannabis.schema.commerce.OrderItem.VariantSpec.Builder> 
           getVariantBuilderList() {
        return getVariantFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          io.opencannabis.schema.commerce.OrderItem.VariantSpec, io.opencannabis.schema.commerce.OrderItem.VariantSpec.Builder, io.opencannabis.schema.commerce.OrderItem.VariantSpecOrBuilder> 
          getVariantFieldBuilder() {
        if (variantBuilder_ == null) {
          variantBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              io.opencannabis.schema.commerce.OrderItem.VariantSpec, io.opencannabis.schema.commerce.OrderItem.VariantSpec.Builder, io.opencannabis.schema.commerce.OrderItem.VariantSpecOrBuilder>(
                  variant_,
                  ((bitField0_ & 0x00000002) == 0x00000002),
                  getParentForChildren(),
                  isClean());
          variant_ = null;
        }
        return variantBuilder_;
      }

      private int count_ ;
      /**
       * <pre>
       * Count of this item requested.
       * </pre>
       *
       * <code>uint32 count = 3;</code>
       */
      public int getCount() {
        return count_;
      }
      /**
       * <pre>
       * Count of this item requested.
       * </pre>
       *
       * <code>uint32 count = 3;</code>
       */
      public Builder setCount(int value) {
        
        count_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Count of this item requested.
       * </pre>
       *
       * <code>uint32 count = 3;</code>
       */
      public Builder clearCount() {
        
        count_ = 0;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFieldsProto3(unknownFields);
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:opencannabis.commerce.Item)
    }

    // @@protoc_insertion_point(class_scope:opencannabis.commerce.Item)
    private static final io.opencannabis.schema.commerce.OrderItem.Item DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new io.opencannabis.schema.commerce.OrderItem.Item();
    }

    public static io.opencannabis.schema.commerce.OrderItem.Item getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Item>
        PARSER = new com.google.protobuf.AbstractParser<Item>() {
      public Item parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Item(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Item> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Item> getParserForType() {
      return PARSER;
    }

    public io.opencannabis.schema.commerce.OrderItem.Item getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_opencannabis_commerce_VariantSpec_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_opencannabis_commerce_VariantSpec_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_opencannabis_commerce_Item_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internal_static_opencannabis_commerce_Item_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\023commerce/Item.proto\022\025opencannabis.comm" +
      "erce\032\025base/ProductKey.proto\032\'structs/pri" +
      "cing/PricingDescriptor.proto\"\261\001\n\013Variant" +
      "Spec\0226\n\007variant\030\001 \001(\0162%.opencannabis.com" +
      "merce.ProductVariant\022A\n\006weight\030\002 \001(\0162/.o" +
      "pencannabis.structs.pricing.PricingWeigh" +
      "tTierH\000\022\016\n\004size\030\003 \001(\tH\000\022\017\n\005color\030\004 \001(\tH\000" +
      "B\006\n\004spec\"v\n\004Item\022*\n\003key\030\001 \001(\0132\035.opencann" +
      "abis.base.ProductKey\0223\n\007variant\030\002 \003(\0132\"." +
      "opencannabis.commerce.VariantSpec\022\r\n\005cou" +
      "nt\030\003 \001(\r*1\n\016ProductVariant\022\n\n\006WEIGHT\020\000\022\t" +
      "\n\005COLOR\020\001\022\010\n\004SIZE\020\002B6\n\037io.opencannabis.s" +
      "chema.commerceB\tOrderItemH\001P\000\242\002\003OCSb\006pro" +
      "to3"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          io.opencannabis.schema.base.BaseProductKey.getDescriptor(),
          io.opencannabis.schema.product.struct.ProductPricingSpec.getDescriptor(),
        }, assigner);
    internal_static_opencannabis_commerce_VariantSpec_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_opencannabis_commerce_VariantSpec_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_opencannabis_commerce_VariantSpec_descriptor,
        new java.lang.String[] { "Variant", "Weight", "Size", "Color", "Spec", });
    internal_static_opencannabis_commerce_Item_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_opencannabis_commerce_Item_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessageV3.FieldAccessorTable(
        internal_static_opencannabis_commerce_Item_descriptor,
        new java.lang.String[] { "Key", "Variant", "Count", });
    io.opencannabis.schema.base.BaseProductKey.getDescriptor();
    io.opencannabis.schema.product.struct.ProductPricingSpec.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
