/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: content/Content.proto

package io.opencannabis.schema.content;

/**
 * <pre>
 * Specifies a freeform content payload of some kind.
 * </pre>
 *
 * Protobuf type {@code opencannabis.content.Content}
 */
public  final class Content extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:opencannabis.content.Content)
    ContentOrBuilder {
private static final long serialVersionUID = 0L;
  // Use Content.newBuilder() to construct.
  private Content(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private Content() {
    type_ = 0;
    encoding_ = 0;
    content_ = "";
    language_ = 0;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private Content(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 8: {
            int rawValue = input.readEnum();

            type_ = rawValue;
            break;
          }
          case 16: {
            int rawValue = input.readEnum();

            encoding_ = rawValue;
            break;
          }
          case 26: {
            java.lang.String s = input.readStringRequireUtf8();

            content_ = s;
            break;
          }
          case 32: {
            int rawValue = input.readEnum();

            language_ = rawValue;
            break;
          }
          case 42: {
            io.opencannabis.schema.base.Compression.Builder subBuilder = null;
            if (compression_ != null) {
              subBuilder = compression_.toBuilder();
            }
            compression_ = input.readMessage(io.opencannabis.schema.base.Compression.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(compression_);
              compression_ = subBuilder.buildPartial();
            }

            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.opencannabis.schema.content.GenericContent.internal_static_opencannabis_content_Content_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.opencannabis.schema.content.GenericContent.internal_static_opencannabis_content_Content_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.opencannabis.schema.content.Content.class, io.opencannabis.schema.content.Content.Builder.class);
  }

  /**
   * <pre>
   * Enumerates supported types/formats for content data.
   * </pre>
   *
   * Protobuf enum {@code opencannabis.content.Content.Type}
   */
  public enum Type
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * Plaintext format.
     * </pre>
     *
     * <code>TEXT = 0;</code>
     */
    TEXT(0),
    /**
     * <pre>
     * Markdown format.
     * </pre>
     *
     * <code>MARKDOWN = 1;</code>
     */
    MARKDOWN(1),
    /**
     * <pre>
     * HTML format.
     * </pre>
     *
     * <code>HTML = 2;</code>
     */
    HTML(2),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * Plaintext format.
     * </pre>
     *
     * <code>TEXT = 0;</code>
     */
    public static final int TEXT_VALUE = 0;
    /**
     * <pre>
     * Markdown format.
     * </pre>
     *
     * <code>MARKDOWN = 1;</code>
     */
    public static final int MARKDOWN_VALUE = 1;
    /**
     * <pre>
     * HTML format.
     * </pre>
     *
     * <code>HTML = 2;</code>
     */
    public static final int HTML_VALUE = 2;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    public static Type forNumber(int value) {
      switch (value) {
        case 0: return TEXT;
        case 1: return MARKDOWN;
        case 2: return HTML;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        Type> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Type>() {
            public Type findValueByNumber(int number) {
              return Type.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.opencannabis.schema.content.Content.getDescriptor().getEnumTypes().get(0);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:opencannabis.content.Content.Type)
  }

  /**
   * <pre>
   * Enumerates supported encodings for content data.
   * </pre>
   *
   * Protobuf enum {@code opencannabis.content.Content.Encoding}
   */
  public enum Encoding
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * UTF-8 standard encoding.
     * </pre>
     *
     * <code>UTF8 = 0;</code>
     */
    UTF8(0),
    /**
     * <pre>
     * Base-64 encoded UTF-8.
     * </pre>
     *
     * <code>B64 = 1;</code>
     */
    B64(1),
    /**
     * <pre>
     * Base-64 encoded ASCII.
     * </pre>
     *
     * <code>B64_ASCII = 2;</code>
     */
    B64_ASCII(2),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * UTF-8 standard encoding.
     * </pre>
     *
     * <code>UTF8 = 0;</code>
     */
    public static final int UTF8_VALUE = 0;
    /**
     * <pre>
     * Base-64 encoded UTF-8.
     * </pre>
     *
     * <code>B64 = 1;</code>
     */
    public static final int B64_VALUE = 1;
    /**
     * <pre>
     * Base-64 encoded ASCII.
     * </pre>
     *
     * <code>B64_ASCII = 2;</code>
     */
    public static final int B64_ASCII_VALUE = 2;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Encoding valueOf(int value) {
      return forNumber(value);
    }

    public static Encoding forNumber(int value) {
      switch (value) {
        case 0: return UTF8;
        case 1: return B64;
        case 2: return B64_ASCII;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Encoding>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        Encoding> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Encoding>() {
            public Encoding findValueByNumber(int number) {
              return Encoding.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return io.opencannabis.schema.content.Content.getDescriptor().getEnumTypes().get(1);
    }

    private static final Encoding[] VALUES = values();

    public static Encoding valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Encoding(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:opencannabis.content.Content.Encoding)
  }

  public static final int TYPE_FIELD_NUMBER = 1;
  private int type_;
  /**
   * <pre>
   * Format/underlying type of content data.
   * </pre>
   *
   * <code>.opencannabis.content.Content.Type type = 1;</code>
   */
  public int getTypeValue() {
    return type_;
  }
  /**
   * <pre>
   * Format/underlying type of content data.
   * </pre>
   *
   * <code>.opencannabis.content.Content.Type type = 1;</code>
   */
  public io.opencannabis.schema.content.Content.Type getType() {
    io.opencannabis.schema.content.Content.Type result = io.opencannabis.schema.content.Content.Type.valueOf(type_);
    return result == null ? io.opencannabis.schema.content.Content.Type.UNRECOGNIZED : result;
  }

  public static final int ENCODING_FIELD_NUMBER = 2;
  private int encoding_;
  /**
   * <pre>
   * Encoding of underlying content data.
   * </pre>
   *
   * <code>.opencannabis.content.Content.Encoding encoding = 2;</code>
   */
  public int getEncodingValue() {
    return encoding_;
  }
  /**
   * <pre>
   * Encoding of underlying content data.
   * </pre>
   *
   * <code>.opencannabis.content.Content.Encoding encoding = 2;</code>
   */
  public io.opencannabis.schema.content.Content.Encoding getEncoding() {
    io.opencannabis.schema.content.Content.Encoding result = io.opencannabis.schema.content.Content.Encoding.valueOf(encoding_);
    return result == null ? io.opencannabis.schema.content.Content.Encoding.UNRECOGNIZED : result;
  }

  public static final int CONTENT_FIELD_NUMBER = 3;
  private volatile java.lang.Object content_;
  /**
   * <pre>
   * Raw bytes of underlying content data.
   * </pre>
   *
   * <code>string content = 3;</code>
   */
  public java.lang.String getContent() {
    java.lang.Object ref = content_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      content_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Raw bytes of underlying content data.
   * </pre>
   *
   * <code>string content = 3;</code>
   */
  public com.google.protobuf.ByteString
      getContentBytes() {
    java.lang.Object ref = content_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      content_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LANGUAGE_FIELD_NUMBER = 4;
  private int language_;
  /**
   * <pre>
   * Language information for underlying content.
   * </pre>
   *
   * <code>.opencannabis.base.Language language = 4;</code>
   */
  public int getLanguageValue() {
    return language_;
  }
  /**
   * <pre>
   * Language information for underlying content.
   * </pre>
   *
   * <code>.opencannabis.base.Language language = 4;</code>
   */
  public io.opencannabis.schema.base.Language getLanguage() {
    io.opencannabis.schema.base.Language result = io.opencannabis.schema.base.Language.valueOf(language_);
    return result == null ? io.opencannabis.schema.base.Language.UNRECOGNIZED : result;
  }

  public static final int COMPRESSION_FIELD_NUMBER = 5;
  private io.opencannabis.schema.base.Compression compression_;
  /**
   * <pre>
   * Compression settings for underlying content.
   * </pre>
   *
   * <code>.opencannabis.base.Compression compression = 5;</code>
   */
  public boolean hasCompression() {
    return compression_ != null;
  }
  /**
   * <pre>
   * Compression settings for underlying content.
   * </pre>
   *
   * <code>.opencannabis.base.Compression compression = 5;</code>
   */
  public io.opencannabis.schema.base.Compression getCompression() {
    return compression_ == null ? io.opencannabis.schema.base.Compression.getDefaultInstance() : compression_;
  }
  /**
   * <pre>
   * Compression settings for underlying content.
   * </pre>
   *
   * <code>.opencannabis.base.Compression compression = 5;</code>
   */
  public io.opencannabis.schema.base.CompressionOrBuilder getCompressionOrBuilder() {
    return getCompression();
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (type_ != io.opencannabis.schema.content.Content.Type.TEXT.getNumber()) {
      output.writeEnum(1, type_);
    }
    if (encoding_ != io.opencannabis.schema.content.Content.Encoding.UTF8.getNumber()) {
      output.writeEnum(2, encoding_);
    }
    if (!getContentBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, content_);
    }
    if (language_ != io.opencannabis.schema.base.Language.ENGLISH.getNumber()) {
      output.writeEnum(4, language_);
    }
    if (compression_ != null) {
      output.writeMessage(5, getCompression());
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (type_ != io.opencannabis.schema.content.Content.Type.TEXT.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(1, type_);
    }
    if (encoding_ != io.opencannabis.schema.content.Content.Encoding.UTF8.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(2, encoding_);
    }
    if (!getContentBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, content_);
    }
    if (language_ != io.opencannabis.schema.base.Language.ENGLISH.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(4, language_);
    }
    if (compression_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, getCompression());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.opencannabis.schema.content.Content)) {
      return super.equals(obj);
    }
    io.opencannabis.schema.content.Content other = (io.opencannabis.schema.content.Content) obj;

    boolean result = true;
    result = result && type_ == other.type_;
    result = result && encoding_ == other.encoding_;
    result = result && getContent()
        .equals(other.getContent());
    result = result && language_ == other.language_;
    result = result && (hasCompression() == other.hasCompression());
    if (hasCompression()) {
      result = result && getCompression()
          .equals(other.getCompression());
    }
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + ENCODING_FIELD_NUMBER;
    hash = (53 * hash) + encoding_;
    hash = (37 * hash) + CONTENT_FIELD_NUMBER;
    hash = (53 * hash) + getContent().hashCode();
    hash = (37 * hash) + LANGUAGE_FIELD_NUMBER;
    hash = (53 * hash) + language_;
    if (hasCompression()) {
      hash = (37 * hash) + COMPRESSION_FIELD_NUMBER;
      hash = (53 * hash) + getCompression().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.opencannabis.schema.content.Content parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.content.Content parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.content.Content parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.content.Content parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.content.Content parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.content.Content parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.content.Content parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.content.Content parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.content.Content parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.content.Content parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.content.Content parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.content.Content parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.opencannabis.schema.content.Content prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies a freeform content payload of some kind.
   * </pre>
   *
   * Protobuf type {@code opencannabis.content.Content}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:opencannabis.content.Content)
      io.opencannabis.schema.content.ContentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.content.GenericContent.internal_static_opencannabis_content_Content_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.content.GenericContent.internal_static_opencannabis_content_Content_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.content.Content.class, io.opencannabis.schema.content.Content.Builder.class);
    }

    // Construct using io.opencannabis.schema.content.Content.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      type_ = 0;

      encoding_ = 0;

      content_ = "";

      language_ = 0;

      if (compressionBuilder_ == null) {
        compression_ = null;
      } else {
        compression_ = null;
        compressionBuilder_ = null;
      }
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.opencannabis.schema.content.GenericContent.internal_static_opencannabis_content_Content_descriptor;
    }

    public io.opencannabis.schema.content.Content getDefaultInstanceForType() {
      return io.opencannabis.schema.content.Content.getDefaultInstance();
    }

    public io.opencannabis.schema.content.Content build() {
      io.opencannabis.schema.content.Content result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.opencannabis.schema.content.Content buildPartial() {
      io.opencannabis.schema.content.Content result = new io.opencannabis.schema.content.Content(this);
      result.type_ = type_;
      result.encoding_ = encoding_;
      result.content_ = content_;
      result.language_ = language_;
      if (compressionBuilder_ == null) {
        result.compression_ = compression_;
      } else {
        result.compression_ = compressionBuilder_.build();
      }
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.opencannabis.schema.content.Content) {
        return mergeFrom((io.opencannabis.schema.content.Content)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.opencannabis.schema.content.Content other) {
      if (other == io.opencannabis.schema.content.Content.getDefaultInstance()) return this;
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (other.encoding_ != 0) {
        setEncodingValue(other.getEncodingValue());
      }
      if (!other.getContent().isEmpty()) {
        content_ = other.content_;
        onChanged();
      }
      if (other.language_ != 0) {
        setLanguageValue(other.getLanguageValue());
      }
      if (other.hasCompression()) {
        mergeCompression(other.getCompression());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.opencannabis.schema.content.Content parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.opencannabis.schema.content.Content) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int type_ = 0;
    /**
     * <pre>
     * Format/underlying type of content data.
     * </pre>
     *
     * <code>.opencannabis.content.Content.Type type = 1;</code>
     */
    public int getTypeValue() {
      return type_;
    }
    /**
     * <pre>
     * Format/underlying type of content data.
     * </pre>
     *
     * <code>.opencannabis.content.Content.Type type = 1;</code>
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Format/underlying type of content data.
     * </pre>
     *
     * <code>.opencannabis.content.Content.Type type = 1;</code>
     */
    public io.opencannabis.schema.content.Content.Type getType() {
      io.opencannabis.schema.content.Content.Type result = io.opencannabis.schema.content.Content.Type.valueOf(type_);
      return result == null ? io.opencannabis.schema.content.Content.Type.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Format/underlying type of content data.
     * </pre>
     *
     * <code>.opencannabis.content.Content.Type type = 1;</code>
     */
    public Builder setType(io.opencannabis.schema.content.Content.Type value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Format/underlying type of content data.
     * </pre>
     *
     * <code>.opencannabis.content.Content.Type type = 1;</code>
     */
    public Builder clearType() {
      
      type_ = 0;
      onChanged();
      return this;
    }

    private int encoding_ = 0;
    /**
     * <pre>
     * Encoding of underlying content data.
     * </pre>
     *
     * <code>.opencannabis.content.Content.Encoding encoding = 2;</code>
     */
    public int getEncodingValue() {
      return encoding_;
    }
    /**
     * <pre>
     * Encoding of underlying content data.
     * </pre>
     *
     * <code>.opencannabis.content.Content.Encoding encoding = 2;</code>
     */
    public Builder setEncodingValue(int value) {
      encoding_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Encoding of underlying content data.
     * </pre>
     *
     * <code>.opencannabis.content.Content.Encoding encoding = 2;</code>
     */
    public io.opencannabis.schema.content.Content.Encoding getEncoding() {
      io.opencannabis.schema.content.Content.Encoding result = io.opencannabis.schema.content.Content.Encoding.valueOf(encoding_);
      return result == null ? io.opencannabis.schema.content.Content.Encoding.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Encoding of underlying content data.
     * </pre>
     *
     * <code>.opencannabis.content.Content.Encoding encoding = 2;</code>
     */
    public Builder setEncoding(io.opencannabis.schema.content.Content.Encoding value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      encoding_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Encoding of underlying content data.
     * </pre>
     *
     * <code>.opencannabis.content.Content.Encoding encoding = 2;</code>
     */
    public Builder clearEncoding() {
      
      encoding_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object content_ = "";
    /**
     * <pre>
     * Raw bytes of underlying content data.
     * </pre>
     *
     * <code>string content = 3;</code>
     */
    public java.lang.String getContent() {
      java.lang.Object ref = content_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        content_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Raw bytes of underlying content data.
     * </pre>
     *
     * <code>string content = 3;</code>
     */
    public com.google.protobuf.ByteString
        getContentBytes() {
      java.lang.Object ref = content_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        content_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Raw bytes of underlying content data.
     * </pre>
     *
     * <code>string content = 3;</code>
     */
    public Builder setContent(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      content_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Raw bytes of underlying content data.
     * </pre>
     *
     * <code>string content = 3;</code>
     */
    public Builder clearContent() {
      
      content_ = getDefaultInstance().getContent();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Raw bytes of underlying content data.
     * </pre>
     *
     * <code>string content = 3;</code>
     */
    public Builder setContentBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      content_ = value;
      onChanged();
      return this;
    }

    private int language_ = 0;
    /**
     * <pre>
     * Language information for underlying content.
     * </pre>
     *
     * <code>.opencannabis.base.Language language = 4;</code>
     */
    public int getLanguageValue() {
      return language_;
    }
    /**
     * <pre>
     * Language information for underlying content.
     * </pre>
     *
     * <code>.opencannabis.base.Language language = 4;</code>
     */
    public Builder setLanguageValue(int value) {
      language_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Language information for underlying content.
     * </pre>
     *
     * <code>.opencannabis.base.Language language = 4;</code>
     */
    public io.opencannabis.schema.base.Language getLanguage() {
      io.opencannabis.schema.base.Language result = io.opencannabis.schema.base.Language.valueOf(language_);
      return result == null ? io.opencannabis.schema.base.Language.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Language information for underlying content.
     * </pre>
     *
     * <code>.opencannabis.base.Language language = 4;</code>
     */
    public Builder setLanguage(io.opencannabis.schema.base.Language value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      language_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Language information for underlying content.
     * </pre>
     *
     * <code>.opencannabis.base.Language language = 4;</code>
     */
    public Builder clearLanguage() {
      
      language_ = 0;
      onChanged();
      return this;
    }

    private io.opencannabis.schema.base.Compression compression_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.base.Compression, io.opencannabis.schema.base.Compression.Builder, io.opencannabis.schema.base.CompressionOrBuilder> compressionBuilder_;
    /**
     * <pre>
     * Compression settings for underlying content.
     * </pre>
     *
     * <code>.opencannabis.base.Compression compression = 5;</code>
     */
    public boolean hasCompression() {
      return compressionBuilder_ != null || compression_ != null;
    }
    /**
     * <pre>
     * Compression settings for underlying content.
     * </pre>
     *
     * <code>.opencannabis.base.Compression compression = 5;</code>
     */
    public io.opencannabis.schema.base.Compression getCompression() {
      if (compressionBuilder_ == null) {
        return compression_ == null ? io.opencannabis.schema.base.Compression.getDefaultInstance() : compression_;
      } else {
        return compressionBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Compression settings for underlying content.
     * </pre>
     *
     * <code>.opencannabis.base.Compression compression = 5;</code>
     */
    public Builder setCompression(io.opencannabis.schema.base.Compression value) {
      if (compressionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        compression_ = value;
        onChanged();
      } else {
        compressionBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Compression settings for underlying content.
     * </pre>
     *
     * <code>.opencannabis.base.Compression compression = 5;</code>
     */
    public Builder setCompression(
        io.opencannabis.schema.base.Compression.Builder builderForValue) {
      if (compressionBuilder_ == null) {
        compression_ = builderForValue.build();
        onChanged();
      } else {
        compressionBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Compression settings for underlying content.
     * </pre>
     *
     * <code>.opencannabis.base.Compression compression = 5;</code>
     */
    public Builder mergeCompression(io.opencannabis.schema.base.Compression value) {
      if (compressionBuilder_ == null) {
        if (compression_ != null) {
          compression_ =
            io.opencannabis.schema.base.Compression.newBuilder(compression_).mergeFrom(value).buildPartial();
        } else {
          compression_ = value;
        }
        onChanged();
      } else {
        compressionBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Compression settings for underlying content.
     * </pre>
     *
     * <code>.opencannabis.base.Compression compression = 5;</code>
     */
    public Builder clearCompression() {
      if (compressionBuilder_ == null) {
        compression_ = null;
        onChanged();
      } else {
        compression_ = null;
        compressionBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Compression settings for underlying content.
     * </pre>
     *
     * <code>.opencannabis.base.Compression compression = 5;</code>
     */
    public io.opencannabis.schema.base.Compression.Builder getCompressionBuilder() {
      
      onChanged();
      return getCompressionFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Compression settings for underlying content.
     * </pre>
     *
     * <code>.opencannabis.base.Compression compression = 5;</code>
     */
    public io.opencannabis.schema.base.CompressionOrBuilder getCompressionOrBuilder() {
      if (compressionBuilder_ != null) {
        return compressionBuilder_.getMessageOrBuilder();
      } else {
        return compression_ == null ?
            io.opencannabis.schema.base.Compression.getDefaultInstance() : compression_;
      }
    }
    /**
     * <pre>
     * Compression settings for underlying content.
     * </pre>
     *
     * <code>.opencannabis.base.Compression compression = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.base.Compression, io.opencannabis.schema.base.Compression.Builder, io.opencannabis.schema.base.CompressionOrBuilder> 
        getCompressionFieldBuilder() {
      if (compressionBuilder_ == null) {
        compressionBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.base.Compression, io.opencannabis.schema.base.Compression.Builder, io.opencannabis.schema.base.CompressionOrBuilder>(
                getCompression(),
                getParentForChildren(),
                isClean());
        compression_ = null;
      }
      return compressionBuilder_;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:opencannabis.content.Content)
  }

  // @@protoc_insertion_point(class_scope:opencannabis.content.Content)
  private static final io.opencannabis.schema.content.Content DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.opencannabis.schema.content.Content();
  }

  public static io.opencannabis.schema.content.Content getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Content>
      PARSER = new com.google.protobuf.AbstractParser<Content>() {
    public Content parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new Content(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<Content> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Content> getParserForType() {
    return PARSER;
  }

  public io.opencannabis.schema.content.Content getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

