/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: content/MaterialsData.proto

package io.opencannabis.schema.content;

/**
 * <pre>
 * Specifies materials-related data about a product that contains cannabis.
 * </pre>
 *
 * Protobuf type {@code opencannabis.content.MaterialsData}
 */
public  final class MaterialsData extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:opencannabis.content.MaterialsData)
    MaterialsDataOrBuilder {
private static final long serialVersionUID = 0L;
  // Use MaterialsData.newBuilder() to construct.
  private MaterialsData(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private MaterialsData() {
    species_ = 0;
    grow_ = 0;
    shelf_ = 0;
    channel_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private MaterialsData(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 8: {
            int rawValue = input.readEnum();

            species_ = rawValue;
            break;
          }
          case 18: {
            io.opencannabis.schema.product.struct.Genetics.Builder subBuilder = null;
            if (genetics_ != null) {
              subBuilder = genetics_.toBuilder();
            }
            genetics_ = input.readMessage(io.opencannabis.schema.product.struct.Genetics.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(genetics_);
              genetics_ = subBuilder.buildPartial();
            }

            break;
          }
          case 24: {
            int rawValue = input.readEnum();

            grow_ = rawValue;
            break;
          }
          case 32: {
            int rawValue = input.readEnum();

            shelf_ = rawValue;
            break;
          }
          case 42: {
            if (!((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
              channel_ = new java.util.ArrayList<io.opencannabis.schema.product.DistributionChannel.DistributionPolicy>();
              mutable_bitField0_ |= 0x00000010;
            }
            channel_.add(
                input.readMessage(io.opencannabis.schema.product.DistributionChannel.DistributionPolicy.parser(), extensionRegistry));
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
        channel_ = java.util.Collections.unmodifiableList(channel_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.opencannabis.schema.content.MaterialsContent.internal_static_opencannabis_content_MaterialsData_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.opencannabis.schema.content.MaterialsContent.internal_static_opencannabis_content_MaterialsData_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.opencannabis.schema.content.MaterialsData.class, io.opencannabis.schema.content.MaterialsData.Builder.class);
  }

  private int bitField0_;
  public static final int SPECIES_FIELD_NUMBER = 1;
  private int species_;
  /**
   * <pre>
   * Species of an item, if known.
   * </pre>
   *
   * <code>.opencannabis.structs.Species species = 1;</code>
   */
  public int getSpeciesValue() {
    return species_;
  }
  /**
   * <pre>
   * Species of an item, if known.
   * </pre>
   *
   * <code>.opencannabis.structs.Species species = 1;</code>
   */
  public io.opencannabis.schema.product.struct.Species getSpecies() {
    io.opencannabis.schema.product.struct.Species result = io.opencannabis.schema.product.struct.Species.valueOf(species_);
    return result == null ? io.opencannabis.schema.product.struct.Species.UNRECOGNIZED : result;
  }

  public static final int GENETICS_FIELD_NUMBER = 2;
  private io.opencannabis.schema.product.struct.Genetics genetics_;
  /**
   * <pre>
   * Specifies the genetics of an item, if known.
   * </pre>
   *
   * <code>.opencannabis.structs.Genetics genetics = 2;</code>
   */
  public boolean hasGenetics() {
    return genetics_ != null;
  }
  /**
   * <pre>
   * Specifies the genetics of an item, if known.
   * </pre>
   *
   * <code>.opencannabis.structs.Genetics genetics = 2;</code>
   */
  public io.opencannabis.schema.product.struct.Genetics getGenetics() {
    return genetics_ == null ? io.opencannabis.schema.product.struct.Genetics.getDefaultInstance() : genetics_;
  }
  /**
   * <pre>
   * Specifies the genetics of an item, if known.
   * </pre>
   *
   * <code>.opencannabis.structs.Genetics genetics = 2;</code>
   */
  public io.opencannabis.schema.product.struct.GeneticsOrBuilder getGeneticsOrBuilder() {
    return getGenetics();
  }

  public static final int GROW_FIELD_NUMBER = 3;
  private int grow_;
  /**
   * <pre>
   * Specifies how this item was grown.
   * </pre>
   *
   * <code>.opencannabis.structs.Grow grow = 3;</code>
   */
  public int getGrowValue() {
    return grow_;
  }
  /**
   * <pre>
   * Specifies how this item was grown.
   * </pre>
   *
   * <code>.opencannabis.structs.Grow grow = 3;</code>
   */
  public io.opencannabis.schema.product.struct.Grow getGrow() {
    io.opencannabis.schema.product.struct.Grow result = io.opencannabis.schema.product.struct.Grow.valueOf(grow_);
    return result == null ? io.opencannabis.schema.product.struct.Grow.UNRECOGNIZED : result;
  }

  public static final int SHELF_FIELD_NUMBER = 4;
  private int shelf_;
  /**
   * <pre>
   * Shelf status of this product.
   * </pre>
   *
   * <code>.opencannabis.structs.Shelf shelf = 4;</code>
   */
  public int getShelfValue() {
    return shelf_;
  }
  /**
   * <pre>
   * Shelf status of this product.
   * </pre>
   *
   * <code>.opencannabis.structs.Shelf shelf = 4;</code>
   */
  public io.opencannabis.schema.product.struct.Shelf getShelf() {
    io.opencannabis.schema.product.struct.Shelf result = io.opencannabis.schema.product.struct.Shelf.valueOf(shelf_);
    return result == null ? io.opencannabis.schema.product.struct.Shelf.UNRECOGNIZED : result;
  }

  public static final int CHANNEL_FIELD_NUMBER = 5;
  private java.util.List<io.opencannabis.schema.product.DistributionChannel.DistributionPolicy> channel_;
  /**
   * <pre>
   * Specifies distribution policy for this particular subject material.
   * </pre>
   *
   * <code>repeated .opencannabis.products.distribution.DistributionPolicy channel = 5;</code>
   */
  public java.util.List<io.opencannabis.schema.product.DistributionChannel.DistributionPolicy> getChannelList() {
    return channel_;
  }
  /**
   * <pre>
   * Specifies distribution policy for this particular subject material.
   * </pre>
   *
   * <code>repeated .opencannabis.products.distribution.DistributionPolicy channel = 5;</code>
   */
  public java.util.List<? extends io.opencannabis.schema.product.DistributionChannel.DistributionPolicyOrBuilder> 
      getChannelOrBuilderList() {
    return channel_;
  }
  /**
   * <pre>
   * Specifies distribution policy for this particular subject material.
   * </pre>
   *
   * <code>repeated .opencannabis.products.distribution.DistributionPolicy channel = 5;</code>
   */
  public int getChannelCount() {
    return channel_.size();
  }
  /**
   * <pre>
   * Specifies distribution policy for this particular subject material.
   * </pre>
   *
   * <code>repeated .opencannabis.products.distribution.DistributionPolicy channel = 5;</code>
   */
  public io.opencannabis.schema.product.DistributionChannel.DistributionPolicy getChannel(int index) {
    return channel_.get(index);
  }
  /**
   * <pre>
   * Specifies distribution policy for this particular subject material.
   * </pre>
   *
   * <code>repeated .opencannabis.products.distribution.DistributionPolicy channel = 5;</code>
   */
  public io.opencannabis.schema.product.DistributionChannel.DistributionPolicyOrBuilder getChannelOrBuilder(
      int index) {
    return channel_.get(index);
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (species_ != io.opencannabis.schema.product.struct.Species.UNSPECIFIED.getNumber()) {
      output.writeEnum(1, species_);
    }
    if (genetics_ != null) {
      output.writeMessage(2, getGenetics());
    }
    if (grow_ != io.opencannabis.schema.product.struct.Grow.GENERIC.getNumber()) {
      output.writeEnum(3, grow_);
    }
    if (shelf_ != io.opencannabis.schema.product.struct.Shelf.GENERIC_SHELF.getNumber()) {
      output.writeEnum(4, shelf_);
    }
    for (int i = 0; i < channel_.size(); i++) {
      output.writeMessage(5, channel_.get(i));
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (species_ != io.opencannabis.schema.product.struct.Species.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(1, species_);
    }
    if (genetics_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(2, getGenetics());
    }
    if (grow_ != io.opencannabis.schema.product.struct.Grow.GENERIC.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(3, grow_);
    }
    if (shelf_ != io.opencannabis.schema.product.struct.Shelf.GENERIC_SHELF.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(4, shelf_);
    }
    for (int i = 0; i < channel_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, channel_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.opencannabis.schema.content.MaterialsData)) {
      return super.equals(obj);
    }
    io.opencannabis.schema.content.MaterialsData other = (io.opencannabis.schema.content.MaterialsData) obj;

    boolean result = true;
    result = result && species_ == other.species_;
    result = result && (hasGenetics() == other.hasGenetics());
    if (hasGenetics()) {
      result = result && getGenetics()
          .equals(other.getGenetics());
    }
    result = result && grow_ == other.grow_;
    result = result && shelf_ == other.shelf_;
    result = result && getChannelList()
        .equals(other.getChannelList());
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SPECIES_FIELD_NUMBER;
    hash = (53 * hash) + species_;
    if (hasGenetics()) {
      hash = (37 * hash) + GENETICS_FIELD_NUMBER;
      hash = (53 * hash) + getGenetics().hashCode();
    }
    hash = (37 * hash) + GROW_FIELD_NUMBER;
    hash = (53 * hash) + grow_;
    hash = (37 * hash) + SHELF_FIELD_NUMBER;
    hash = (53 * hash) + shelf_;
    if (getChannelCount() > 0) {
      hash = (37 * hash) + CHANNEL_FIELD_NUMBER;
      hash = (53 * hash) + getChannelList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.opencannabis.schema.content.MaterialsData parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.content.MaterialsData parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.content.MaterialsData parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.content.MaterialsData parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.content.MaterialsData parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.content.MaterialsData parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.content.MaterialsData parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.content.MaterialsData parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.content.MaterialsData parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.content.MaterialsData parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.content.MaterialsData parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.content.MaterialsData parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.opencannabis.schema.content.MaterialsData prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies materials-related data about a product that contains cannabis.
   * </pre>
   *
   * Protobuf type {@code opencannabis.content.MaterialsData}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:opencannabis.content.MaterialsData)
      io.opencannabis.schema.content.MaterialsDataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.content.MaterialsContent.internal_static_opencannabis_content_MaterialsData_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.content.MaterialsContent.internal_static_opencannabis_content_MaterialsData_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.content.MaterialsData.class, io.opencannabis.schema.content.MaterialsData.Builder.class);
    }

    // Construct using io.opencannabis.schema.content.MaterialsData.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getChannelFieldBuilder();
      }
    }
    public Builder clear() {
      super.clear();
      species_ = 0;

      if (geneticsBuilder_ == null) {
        genetics_ = null;
      } else {
        genetics_ = null;
        geneticsBuilder_ = null;
      }
      grow_ = 0;

      shelf_ = 0;

      if (channelBuilder_ == null) {
        channel_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
      } else {
        channelBuilder_.clear();
      }
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.opencannabis.schema.content.MaterialsContent.internal_static_opencannabis_content_MaterialsData_descriptor;
    }

    public io.opencannabis.schema.content.MaterialsData getDefaultInstanceForType() {
      return io.opencannabis.schema.content.MaterialsData.getDefaultInstance();
    }

    public io.opencannabis.schema.content.MaterialsData build() {
      io.opencannabis.schema.content.MaterialsData result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.opencannabis.schema.content.MaterialsData buildPartial() {
      io.opencannabis.schema.content.MaterialsData result = new io.opencannabis.schema.content.MaterialsData(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.species_ = species_;
      if (geneticsBuilder_ == null) {
        result.genetics_ = genetics_;
      } else {
        result.genetics_ = geneticsBuilder_.build();
      }
      result.grow_ = grow_;
      result.shelf_ = shelf_;
      if (channelBuilder_ == null) {
        if (((bitField0_ & 0x00000010) == 0x00000010)) {
          channel_ = java.util.Collections.unmodifiableList(channel_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.channel_ = channel_;
      } else {
        result.channel_ = channelBuilder_.build();
      }
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.opencannabis.schema.content.MaterialsData) {
        return mergeFrom((io.opencannabis.schema.content.MaterialsData)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.opencannabis.schema.content.MaterialsData other) {
      if (other == io.opencannabis.schema.content.MaterialsData.getDefaultInstance()) return this;
      if (other.species_ != 0) {
        setSpeciesValue(other.getSpeciesValue());
      }
      if (other.hasGenetics()) {
        mergeGenetics(other.getGenetics());
      }
      if (other.grow_ != 0) {
        setGrowValue(other.getGrowValue());
      }
      if (other.shelf_ != 0) {
        setShelfValue(other.getShelfValue());
      }
      if (channelBuilder_ == null) {
        if (!other.channel_.isEmpty()) {
          if (channel_.isEmpty()) {
            channel_ = other.channel_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureChannelIsMutable();
            channel_.addAll(other.channel_);
          }
          onChanged();
        }
      } else {
        if (!other.channel_.isEmpty()) {
          if (channelBuilder_.isEmpty()) {
            channelBuilder_.dispose();
            channelBuilder_ = null;
            channel_ = other.channel_;
            bitField0_ = (bitField0_ & ~0x00000010);
            channelBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getChannelFieldBuilder() : null;
          } else {
            channelBuilder_.addAllMessages(other.channel_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.opencannabis.schema.content.MaterialsData parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.opencannabis.schema.content.MaterialsData) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private int species_ = 0;
    /**
     * <pre>
     * Species of an item, if known.
     * </pre>
     *
     * <code>.opencannabis.structs.Species species = 1;</code>
     */
    public int getSpeciesValue() {
      return species_;
    }
    /**
     * <pre>
     * Species of an item, if known.
     * </pre>
     *
     * <code>.opencannabis.structs.Species species = 1;</code>
     */
    public Builder setSpeciesValue(int value) {
      species_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Species of an item, if known.
     * </pre>
     *
     * <code>.opencannabis.structs.Species species = 1;</code>
     */
    public io.opencannabis.schema.product.struct.Species getSpecies() {
      io.opencannabis.schema.product.struct.Species result = io.opencannabis.schema.product.struct.Species.valueOf(species_);
      return result == null ? io.opencannabis.schema.product.struct.Species.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Species of an item, if known.
     * </pre>
     *
     * <code>.opencannabis.structs.Species species = 1;</code>
     */
    public Builder setSpecies(io.opencannabis.schema.product.struct.Species value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      species_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Species of an item, if known.
     * </pre>
     *
     * <code>.opencannabis.structs.Species species = 1;</code>
     */
    public Builder clearSpecies() {
      
      species_ = 0;
      onChanged();
      return this;
    }

    private io.opencannabis.schema.product.struct.Genetics genetics_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.product.struct.Genetics, io.opencannabis.schema.product.struct.Genetics.Builder, io.opencannabis.schema.product.struct.GeneticsOrBuilder> geneticsBuilder_;
    /**
     * <pre>
     * Specifies the genetics of an item, if known.
     * </pre>
     *
     * <code>.opencannabis.structs.Genetics genetics = 2;</code>
     */
    public boolean hasGenetics() {
      return geneticsBuilder_ != null || genetics_ != null;
    }
    /**
     * <pre>
     * Specifies the genetics of an item, if known.
     * </pre>
     *
     * <code>.opencannabis.structs.Genetics genetics = 2;</code>
     */
    public io.opencannabis.schema.product.struct.Genetics getGenetics() {
      if (geneticsBuilder_ == null) {
        return genetics_ == null ? io.opencannabis.schema.product.struct.Genetics.getDefaultInstance() : genetics_;
      } else {
        return geneticsBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Specifies the genetics of an item, if known.
     * </pre>
     *
     * <code>.opencannabis.structs.Genetics genetics = 2;</code>
     */
    public Builder setGenetics(io.opencannabis.schema.product.struct.Genetics value) {
      if (geneticsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        genetics_ = value;
        onChanged();
      } else {
        geneticsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Specifies the genetics of an item, if known.
     * </pre>
     *
     * <code>.opencannabis.structs.Genetics genetics = 2;</code>
     */
    public Builder setGenetics(
        io.opencannabis.schema.product.struct.Genetics.Builder builderForValue) {
      if (geneticsBuilder_ == null) {
        genetics_ = builderForValue.build();
        onChanged();
      } else {
        geneticsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Specifies the genetics of an item, if known.
     * </pre>
     *
     * <code>.opencannabis.structs.Genetics genetics = 2;</code>
     */
    public Builder mergeGenetics(io.opencannabis.schema.product.struct.Genetics value) {
      if (geneticsBuilder_ == null) {
        if (genetics_ != null) {
          genetics_ =
            io.opencannabis.schema.product.struct.Genetics.newBuilder(genetics_).mergeFrom(value).buildPartial();
        } else {
          genetics_ = value;
        }
        onChanged();
      } else {
        geneticsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Specifies the genetics of an item, if known.
     * </pre>
     *
     * <code>.opencannabis.structs.Genetics genetics = 2;</code>
     */
    public Builder clearGenetics() {
      if (geneticsBuilder_ == null) {
        genetics_ = null;
        onChanged();
      } else {
        genetics_ = null;
        geneticsBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Specifies the genetics of an item, if known.
     * </pre>
     *
     * <code>.opencannabis.structs.Genetics genetics = 2;</code>
     */
    public io.opencannabis.schema.product.struct.Genetics.Builder getGeneticsBuilder() {
      
      onChanged();
      return getGeneticsFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Specifies the genetics of an item, if known.
     * </pre>
     *
     * <code>.opencannabis.structs.Genetics genetics = 2;</code>
     */
    public io.opencannabis.schema.product.struct.GeneticsOrBuilder getGeneticsOrBuilder() {
      if (geneticsBuilder_ != null) {
        return geneticsBuilder_.getMessageOrBuilder();
      } else {
        return genetics_ == null ?
            io.opencannabis.schema.product.struct.Genetics.getDefaultInstance() : genetics_;
      }
    }
    /**
     * <pre>
     * Specifies the genetics of an item, if known.
     * </pre>
     *
     * <code>.opencannabis.structs.Genetics genetics = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.product.struct.Genetics, io.opencannabis.schema.product.struct.Genetics.Builder, io.opencannabis.schema.product.struct.GeneticsOrBuilder> 
        getGeneticsFieldBuilder() {
      if (geneticsBuilder_ == null) {
        geneticsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.product.struct.Genetics, io.opencannabis.schema.product.struct.Genetics.Builder, io.opencannabis.schema.product.struct.GeneticsOrBuilder>(
                getGenetics(),
                getParentForChildren(),
                isClean());
        genetics_ = null;
      }
      return geneticsBuilder_;
    }

    private int grow_ = 0;
    /**
     * <pre>
     * Specifies how this item was grown.
     * </pre>
     *
     * <code>.opencannabis.structs.Grow grow = 3;</code>
     */
    public int getGrowValue() {
      return grow_;
    }
    /**
     * <pre>
     * Specifies how this item was grown.
     * </pre>
     *
     * <code>.opencannabis.structs.Grow grow = 3;</code>
     */
    public Builder setGrowValue(int value) {
      grow_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies how this item was grown.
     * </pre>
     *
     * <code>.opencannabis.structs.Grow grow = 3;</code>
     */
    public io.opencannabis.schema.product.struct.Grow getGrow() {
      io.opencannabis.schema.product.struct.Grow result = io.opencannabis.schema.product.struct.Grow.valueOf(grow_);
      return result == null ? io.opencannabis.schema.product.struct.Grow.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Specifies how this item was grown.
     * </pre>
     *
     * <code>.opencannabis.structs.Grow grow = 3;</code>
     */
    public Builder setGrow(io.opencannabis.schema.product.struct.Grow value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      grow_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies how this item was grown.
     * </pre>
     *
     * <code>.opencannabis.structs.Grow grow = 3;</code>
     */
    public Builder clearGrow() {
      
      grow_ = 0;
      onChanged();
      return this;
    }

    private int shelf_ = 0;
    /**
     * <pre>
     * Shelf status of this product.
     * </pre>
     *
     * <code>.opencannabis.structs.Shelf shelf = 4;</code>
     */
    public int getShelfValue() {
      return shelf_;
    }
    /**
     * <pre>
     * Shelf status of this product.
     * </pre>
     *
     * <code>.opencannabis.structs.Shelf shelf = 4;</code>
     */
    public Builder setShelfValue(int value) {
      shelf_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Shelf status of this product.
     * </pre>
     *
     * <code>.opencannabis.structs.Shelf shelf = 4;</code>
     */
    public io.opencannabis.schema.product.struct.Shelf getShelf() {
      io.opencannabis.schema.product.struct.Shelf result = io.opencannabis.schema.product.struct.Shelf.valueOf(shelf_);
      return result == null ? io.opencannabis.schema.product.struct.Shelf.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Shelf status of this product.
     * </pre>
     *
     * <code>.opencannabis.structs.Shelf shelf = 4;</code>
     */
    public Builder setShelf(io.opencannabis.schema.product.struct.Shelf value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      shelf_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Shelf status of this product.
     * </pre>
     *
     * <code>.opencannabis.structs.Shelf shelf = 4;</code>
     */
    public Builder clearShelf() {
      
      shelf_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<io.opencannabis.schema.product.DistributionChannel.DistributionPolicy> channel_ =
      java.util.Collections.emptyList();
    private void ensureChannelIsMutable() {
      if (!((bitField0_ & 0x00000010) == 0x00000010)) {
        channel_ = new java.util.ArrayList<io.opencannabis.schema.product.DistributionChannel.DistributionPolicy>(channel_);
        bitField0_ |= 0x00000010;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.opencannabis.schema.product.DistributionChannel.DistributionPolicy, io.opencannabis.schema.product.DistributionChannel.DistributionPolicy.Builder, io.opencannabis.schema.product.DistributionChannel.DistributionPolicyOrBuilder> channelBuilder_;

    /**
     * <pre>
     * Specifies distribution policy for this particular subject material.
     * </pre>
     *
     * <code>repeated .opencannabis.products.distribution.DistributionPolicy channel = 5;</code>
     */
    public java.util.List<io.opencannabis.schema.product.DistributionChannel.DistributionPolicy> getChannelList() {
      if (channelBuilder_ == null) {
        return java.util.Collections.unmodifiableList(channel_);
      } else {
        return channelBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Specifies distribution policy for this particular subject material.
     * </pre>
     *
     * <code>repeated .opencannabis.products.distribution.DistributionPolicy channel = 5;</code>
     */
    public int getChannelCount() {
      if (channelBuilder_ == null) {
        return channel_.size();
      } else {
        return channelBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Specifies distribution policy for this particular subject material.
     * </pre>
     *
     * <code>repeated .opencannabis.products.distribution.DistributionPolicy channel = 5;</code>
     */
    public io.opencannabis.schema.product.DistributionChannel.DistributionPolicy getChannel(int index) {
      if (channelBuilder_ == null) {
        return channel_.get(index);
      } else {
        return channelBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Specifies distribution policy for this particular subject material.
     * </pre>
     *
     * <code>repeated .opencannabis.products.distribution.DistributionPolicy channel = 5;</code>
     */
    public Builder setChannel(
        int index, io.opencannabis.schema.product.DistributionChannel.DistributionPolicy value) {
      if (channelBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureChannelIsMutable();
        channel_.set(index, value);
        onChanged();
      } else {
        channelBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies distribution policy for this particular subject material.
     * </pre>
     *
     * <code>repeated .opencannabis.products.distribution.DistributionPolicy channel = 5;</code>
     */
    public Builder setChannel(
        int index, io.opencannabis.schema.product.DistributionChannel.DistributionPolicy.Builder builderForValue) {
      if (channelBuilder_ == null) {
        ensureChannelIsMutable();
        channel_.set(index, builderForValue.build());
        onChanged();
      } else {
        channelBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Specifies distribution policy for this particular subject material.
     * </pre>
     *
     * <code>repeated .opencannabis.products.distribution.DistributionPolicy channel = 5;</code>
     */
    public Builder addChannel(io.opencannabis.schema.product.DistributionChannel.DistributionPolicy value) {
      if (channelBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureChannelIsMutable();
        channel_.add(value);
        onChanged();
      } else {
        channelBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies distribution policy for this particular subject material.
     * </pre>
     *
     * <code>repeated .opencannabis.products.distribution.DistributionPolicy channel = 5;</code>
     */
    public Builder addChannel(
        int index, io.opencannabis.schema.product.DistributionChannel.DistributionPolicy value) {
      if (channelBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureChannelIsMutable();
        channel_.add(index, value);
        onChanged();
      } else {
        channelBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies distribution policy for this particular subject material.
     * </pre>
     *
     * <code>repeated .opencannabis.products.distribution.DistributionPolicy channel = 5;</code>
     */
    public Builder addChannel(
        io.opencannabis.schema.product.DistributionChannel.DistributionPolicy.Builder builderForValue) {
      if (channelBuilder_ == null) {
        ensureChannelIsMutable();
        channel_.add(builderForValue.build());
        onChanged();
      } else {
        channelBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Specifies distribution policy for this particular subject material.
     * </pre>
     *
     * <code>repeated .opencannabis.products.distribution.DistributionPolicy channel = 5;</code>
     */
    public Builder addChannel(
        int index, io.opencannabis.schema.product.DistributionChannel.DistributionPolicy.Builder builderForValue) {
      if (channelBuilder_ == null) {
        ensureChannelIsMutable();
        channel_.add(index, builderForValue.build());
        onChanged();
      } else {
        channelBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Specifies distribution policy for this particular subject material.
     * </pre>
     *
     * <code>repeated .opencannabis.products.distribution.DistributionPolicy channel = 5;</code>
     */
    public Builder addAllChannel(
        java.lang.Iterable<? extends io.opencannabis.schema.product.DistributionChannel.DistributionPolicy> values) {
      if (channelBuilder_ == null) {
        ensureChannelIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, channel_);
        onChanged();
      } else {
        channelBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies distribution policy for this particular subject material.
     * </pre>
     *
     * <code>repeated .opencannabis.products.distribution.DistributionPolicy channel = 5;</code>
     */
    public Builder clearChannel() {
      if (channelBuilder_ == null) {
        channel_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        channelBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Specifies distribution policy for this particular subject material.
     * </pre>
     *
     * <code>repeated .opencannabis.products.distribution.DistributionPolicy channel = 5;</code>
     */
    public Builder removeChannel(int index) {
      if (channelBuilder_ == null) {
        ensureChannelIsMutable();
        channel_.remove(index);
        onChanged();
      } else {
        channelBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Specifies distribution policy for this particular subject material.
     * </pre>
     *
     * <code>repeated .opencannabis.products.distribution.DistributionPolicy channel = 5;</code>
     */
    public io.opencannabis.schema.product.DistributionChannel.DistributionPolicy.Builder getChannelBuilder(
        int index) {
      return getChannelFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Specifies distribution policy for this particular subject material.
     * </pre>
     *
     * <code>repeated .opencannabis.products.distribution.DistributionPolicy channel = 5;</code>
     */
    public io.opencannabis.schema.product.DistributionChannel.DistributionPolicyOrBuilder getChannelOrBuilder(
        int index) {
      if (channelBuilder_ == null) {
        return channel_.get(index);  } else {
        return channelBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Specifies distribution policy for this particular subject material.
     * </pre>
     *
     * <code>repeated .opencannabis.products.distribution.DistributionPolicy channel = 5;</code>
     */
    public java.util.List<? extends io.opencannabis.schema.product.DistributionChannel.DistributionPolicyOrBuilder> 
         getChannelOrBuilderList() {
      if (channelBuilder_ != null) {
        return channelBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(channel_);
      }
    }
    /**
     * <pre>
     * Specifies distribution policy for this particular subject material.
     * </pre>
     *
     * <code>repeated .opencannabis.products.distribution.DistributionPolicy channel = 5;</code>
     */
    public io.opencannabis.schema.product.DistributionChannel.DistributionPolicy.Builder addChannelBuilder() {
      return getChannelFieldBuilder().addBuilder(
          io.opencannabis.schema.product.DistributionChannel.DistributionPolicy.getDefaultInstance());
    }
    /**
     * <pre>
     * Specifies distribution policy for this particular subject material.
     * </pre>
     *
     * <code>repeated .opencannabis.products.distribution.DistributionPolicy channel = 5;</code>
     */
    public io.opencannabis.schema.product.DistributionChannel.DistributionPolicy.Builder addChannelBuilder(
        int index) {
      return getChannelFieldBuilder().addBuilder(
          index, io.opencannabis.schema.product.DistributionChannel.DistributionPolicy.getDefaultInstance());
    }
    /**
     * <pre>
     * Specifies distribution policy for this particular subject material.
     * </pre>
     *
     * <code>repeated .opencannabis.products.distribution.DistributionPolicy channel = 5;</code>
     */
    public java.util.List<io.opencannabis.schema.product.DistributionChannel.DistributionPolicy.Builder> 
         getChannelBuilderList() {
      return getChannelFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.opencannabis.schema.product.DistributionChannel.DistributionPolicy, io.opencannabis.schema.product.DistributionChannel.DistributionPolicy.Builder, io.opencannabis.schema.product.DistributionChannel.DistributionPolicyOrBuilder> 
        getChannelFieldBuilder() {
      if (channelBuilder_ == null) {
        channelBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            io.opencannabis.schema.product.DistributionChannel.DistributionPolicy, io.opencannabis.schema.product.DistributionChannel.DistributionPolicy.Builder, io.opencannabis.schema.product.DistributionChannel.DistributionPolicyOrBuilder>(
                channel_,
                ((bitField0_ & 0x00000010) == 0x00000010),
                getParentForChildren(),
                isClean());
        channel_ = null;
      }
      return channelBuilder_;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:opencannabis.content.MaterialsData)
  }

  // @@protoc_insertion_point(class_scope:opencannabis.content.MaterialsData)
  private static final io.opencannabis.schema.content.MaterialsData DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.opencannabis.schema.content.MaterialsData();
  }

  public static io.opencannabis.schema.content.MaterialsData getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MaterialsData>
      PARSER = new com.google.protobuf.AbstractParser<MaterialsData>() {
    public MaterialsData parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new MaterialsData(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<MaterialsData> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MaterialsData> getParserForType() {
    return PARSER;
  }

  public io.opencannabis.schema.content.MaterialsData getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

