/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: content/ProductContent.proto

package io.opencannabis.schema.content;

/**
 * <pre>
 * Specifies a common model for product content, mostly user-visible, and shared by all concrete models. Most of the
 * information you see when a product is displayed or listed comes from this model.
 * </pre>
 *
 * Protobuf type {@code opencannabis.content.ProductContent}
 */
public  final class ProductContent extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:opencannabis.content.ProductContent)
    ProductContentOrBuilder {
private static final long serialVersionUID = 0L;
  // Use ProductContent.newBuilder() to construct.
  private ProductContent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private ProductContent() {
    media_ = java.util.Collections.emptyList();
    flags_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private ProductContent(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 10: {
            io.opencannabis.schema.content.Name.Builder subBuilder = null;
            if (name_ != null) {
              subBuilder = name_.toBuilder();
            }
            name_ = input.readMessage(io.opencannabis.schema.content.Name.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(name_);
              name_ = subBuilder.buildPartial();
            }

            break;
          }
          case 18: {
            io.opencannabis.schema.content.Brand.Builder subBuilder = null;
            if (brand_ != null) {
              subBuilder = brand_.toBuilder();
            }
            brand_ = input.readMessage(io.opencannabis.schema.content.Brand.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(brand_);
              brand_ = subBuilder.buildPartial();
            }

            break;
          }
          case 26: {
            io.opencannabis.schema.content.Content.Builder subBuilder = null;
            if (summary_ != null) {
              subBuilder = summary_.toBuilder();
            }
            summary_ = input.readMessage(io.opencannabis.schema.content.Content.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(summary_);
              summary_ = subBuilder.buildPartial();
            }

            break;
          }
          case 34: {
            io.opencannabis.schema.content.Content.Builder subBuilder = null;
            if (usage_ != null) {
              subBuilder = usage_.toBuilder();
            }
            usage_ = input.readMessage(io.opencannabis.schema.content.Content.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(usage_);
              usage_ = subBuilder.buildPartial();
            }

            break;
          }
          case 42: {
            io.opencannabis.schema.content.Content.Builder subBuilder = null;
            if (dosage_ != null) {
              subBuilder = dosage_.toBuilder();
            }
            dosage_ = input.readMessage(io.opencannabis.schema.content.Content.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(dosage_);
              dosage_ = subBuilder.buildPartial();
            }

            break;
          }
          case 50: {
            if (!((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
              media_ = new java.util.ArrayList<io.opencannabis.schema.media.MediaItem>();
              mutable_bitField0_ |= 0x00000020;
            }
            media_.add(
                input.readMessage(io.opencannabis.schema.media.MediaItem.parser(), extensionRegistry));
            break;
          }
          case 58: {
            io.opencannabis.schema.product.struct.ProductPricing.Builder subBuilder = null;
            if (pricing_ != null) {
              subBuilder = pricing_.toBuilder();
            }
            pricing_ = input.readMessage(io.opencannabis.schema.product.struct.ProductPricing.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(pricing_);
              pricing_ = subBuilder.buildPartial();
            }

            break;
          }
          case 66: {
            io.opencannabis.schema.product.struct.testing.TestResults.Builder subBuilder = null;
            if (tests_ != null) {
              subBuilder = tests_.toBuilder();
            }
            tests_ = input.readMessage(io.opencannabis.schema.product.struct.testing.TestResults.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(tests_);
              tests_ = subBuilder.buildPartial();
            }

            break;
          }
          case 72: {
            int rawValue = input.readEnum();
            if (!((mutable_bitField0_ & 0x00000100) == 0x00000100)) {
              flags_ = new java.util.ArrayList<java.lang.Integer>();
              mutable_bitField0_ |= 0x00000100;
            }
            flags_.add(rawValue);
            break;
          }
          case 74: {
            int length = input.readRawVarint32();
            int oldLimit = input.pushLimit(length);
            while(input.getBytesUntilLimit() > 0) {
              int rawValue = input.readEnum();
              if (!((mutable_bitField0_ & 0x00000100) == 0x00000100)) {
                flags_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x00000100;
              }
              flags_.add(rawValue);
            }
            input.popLimit(oldLimit);
            break;
          }
          case 82: {
            io.opencannabis.schema.content.ProductTimestamps.Builder subBuilder = null;
            if (ts_ != null) {
              subBuilder = ts_.toBuilder();
            }
            ts_ = input.readMessage(io.opencannabis.schema.content.ProductTimestamps.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(ts_);
              ts_ = subBuilder.buildPartial();
            }

            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000020) == 0x00000020)) {
        media_ = java.util.Collections.unmodifiableList(media_);
      }
      if (((mutable_bitField0_ & 0x00000100) == 0x00000100)) {
        flags_ = java.util.Collections.unmodifiableList(flags_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.opencannabis.schema.content.AttachedContent.internal_static_opencannabis_content_ProductContent_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.opencannabis.schema.content.AttachedContent.internal_static_opencannabis_content_ProductContent_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.opencannabis.schema.content.ProductContent.class, io.opencannabis.schema.content.ProductContent.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;
  private io.opencannabis.schema.content.Name name_;
  /**
   * <pre>
   * Main product name.
   * </pre>
   *
   * <code>.opencannabis.content.Name name = 1;</code>
   */
  public boolean hasName() {
    return name_ != null;
  }
  /**
   * <pre>
   * Main product name.
   * </pre>
   *
   * <code>.opencannabis.content.Name name = 1;</code>
   */
  public io.opencannabis.schema.content.Name getName() {
    return name_ == null ? io.opencannabis.schema.content.Name.getDefaultInstance() : name_;
  }
  /**
   * <pre>
   * Main product name.
   * </pre>
   *
   * <code>.opencannabis.content.Name name = 1;</code>
   */
  public io.opencannabis.schema.content.NameOrBuilder getNameOrBuilder() {
    return getName();
  }

  public static final int BRAND_FIELD_NUMBER = 2;
  private io.opencannabis.schema.content.Brand brand_;
  /**
   * <pre>
   * Brand information for this product.
   * </pre>
   *
   * <code>.opencannabis.content.Brand brand = 2;</code>
   */
  public boolean hasBrand() {
    return brand_ != null;
  }
  /**
   * <pre>
   * Brand information for this product.
   * </pre>
   *
   * <code>.opencannabis.content.Brand brand = 2;</code>
   */
  public io.opencannabis.schema.content.Brand getBrand() {
    return brand_ == null ? io.opencannabis.schema.content.Brand.getDefaultInstance() : brand_;
  }
  /**
   * <pre>
   * Brand information for this product.
   * </pre>
   *
   * <code>.opencannabis.content.Brand brand = 2;</code>
   */
  public io.opencannabis.schema.content.BrandOrBuilder getBrandOrBuilder() {
    return getBrand();
  }

  public static final int SUMMARY_FIELD_NUMBER = 3;
  private io.opencannabis.schema.content.Content summary_;
  /**
   * <pre>
   * Description or narrative-style content about this product.
   * </pre>
   *
   * <code>.opencannabis.content.Content summary = 3;</code>
   */
  public boolean hasSummary() {
    return summary_ != null;
  }
  /**
   * <pre>
   * Description or narrative-style content about this product.
   * </pre>
   *
   * <code>.opencannabis.content.Content summary = 3;</code>
   */
  public io.opencannabis.schema.content.Content getSummary() {
    return summary_ == null ? io.opencannabis.schema.content.Content.getDefaultInstance() : summary_;
  }
  /**
   * <pre>
   * Description or narrative-style content about this product.
   * </pre>
   *
   * <code>.opencannabis.content.Content summary = 3;</code>
   */
  public io.opencannabis.schema.content.ContentOrBuilder getSummaryOrBuilder() {
    return getSummary();
  }

  public static final int USAGE_FIELD_NUMBER = 4;
  private io.opencannabis.schema.content.Content usage_;
  /**
   * <pre>
   * Content about how this product is best used, or recommended to be used, either from the manufacturer or retailer.
   * </pre>
   *
   * <code>.opencannabis.content.Content usage = 4;</code>
   */
  public boolean hasUsage() {
    return usage_ != null;
  }
  /**
   * <pre>
   * Content about how this product is best used, or recommended to be used, either from the manufacturer or retailer.
   * </pre>
   *
   * <code>.opencannabis.content.Content usage = 4;</code>
   */
  public io.opencannabis.schema.content.Content getUsage() {
    return usage_ == null ? io.opencannabis.schema.content.Content.getDefaultInstance() : usage_;
  }
  /**
   * <pre>
   * Content about how this product is best used, or recommended to be used, either from the manufacturer or retailer.
   * </pre>
   *
   * <code>.opencannabis.content.Content usage = 4;</code>
   */
  public io.opencannabis.schema.content.ContentOrBuilder getUsageOrBuilder() {
    return getUsage();
  }

  public static final int DOSAGE_FIELD_NUMBER = 5;
  private io.opencannabis.schema.content.Content dosage_;
  /**
   * <pre>
   * Dosage advice about this product, either from the manufacturer or retailer.
   * </pre>
   *
   * <code>.opencannabis.content.Content dosage = 5;</code>
   */
  public boolean hasDosage() {
    return dosage_ != null;
  }
  /**
   * <pre>
   * Dosage advice about this product, either from the manufacturer or retailer.
   * </pre>
   *
   * <code>.opencannabis.content.Content dosage = 5;</code>
   */
  public io.opencannabis.schema.content.Content getDosage() {
    return dosage_ == null ? io.opencannabis.schema.content.Content.getDefaultInstance() : dosage_;
  }
  /**
   * <pre>
   * Dosage advice about this product, either from the manufacturer or retailer.
   * </pre>
   *
   * <code>.opencannabis.content.Content dosage = 5;</code>
   */
  public io.opencannabis.schema.content.ContentOrBuilder getDosageOrBuilder() {
    return getDosage();
  }

  public static final int MEDIA_FIELD_NUMBER = 6;
  private java.util.List<io.opencannabis.schema.media.MediaItem> media_;
  /**
   * <pre>
   * Product media, including images, videos, and so on.
   * </pre>
   *
   * <code>repeated .opencannabis.media.MediaItem media = 6;</code>
   */
  public java.util.List<io.opencannabis.schema.media.MediaItem> getMediaList() {
    return media_;
  }
  /**
   * <pre>
   * Product media, including images, videos, and so on.
   * </pre>
   *
   * <code>repeated .opencannabis.media.MediaItem media = 6;</code>
   */
  public java.util.List<? extends io.opencannabis.schema.media.MediaItemOrBuilder> 
      getMediaOrBuilderList() {
    return media_;
  }
  /**
   * <pre>
   * Product media, including images, videos, and so on.
   * </pre>
   *
   * <code>repeated .opencannabis.media.MediaItem media = 6;</code>
   */
  public int getMediaCount() {
    return media_.size();
  }
  /**
   * <pre>
   * Product media, including images, videos, and so on.
   * </pre>
   *
   * <code>repeated .opencannabis.media.MediaItem media = 6;</code>
   */
  public io.opencannabis.schema.media.MediaItem getMedia(int index) {
    return media_.get(index);
  }
  /**
   * <pre>
   * Product media, including images, videos, and so on.
   * </pre>
   *
   * <code>repeated .opencannabis.media.MediaItem media = 6;</code>
   */
  public io.opencannabis.schema.media.MediaItemOrBuilder getMediaOrBuilder(
      int index) {
    return media_.get(index);
  }

  public static final int PRICING_FIELD_NUMBER = 7;
  private io.opencannabis.schema.product.struct.ProductPricing pricing_;
  /**
   * <pre>
   * Pricing specification for this product, regardless of pricing type (i.e. weighted or unit-style pricing).
   * </pre>
   *
   * <code>.opencannabis.structs.pricing.ProductPricing pricing = 7;</code>
   */
  public boolean hasPricing() {
    return pricing_ != null;
  }
  /**
   * <pre>
   * Pricing specification for this product, regardless of pricing type (i.e. weighted or unit-style pricing).
   * </pre>
   *
   * <code>.opencannabis.structs.pricing.ProductPricing pricing = 7;</code>
   */
  public io.opencannabis.schema.product.struct.ProductPricing getPricing() {
    return pricing_ == null ? io.opencannabis.schema.product.struct.ProductPricing.getDefaultInstance() : pricing_;
  }
  /**
   * <pre>
   * Pricing specification for this product, regardless of pricing type (i.e. weighted or unit-style pricing).
   * </pre>
   *
   * <code>.opencannabis.structs.pricing.ProductPricing pricing = 7;</code>
   */
  public io.opencannabis.schema.product.struct.ProductPricingOrBuilder getPricingOrBuilder() {
    return getPricing();
  }

  public static final int TESTS_FIELD_NUMBER = 8;
  private io.opencannabis.schema.product.struct.testing.TestResults tests_;
  /**
   * <pre>
   * Lab testing information concerning this product.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.TestResults tests = 8;</code>
   */
  public boolean hasTests() {
    return tests_ != null;
  }
  /**
   * <pre>
   * Lab testing information concerning this product.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.TestResults tests = 8;</code>
   */
  public io.opencannabis.schema.product.struct.testing.TestResults getTests() {
    return tests_ == null ? io.opencannabis.schema.product.struct.testing.TestResults.getDefaultInstance() : tests_;
  }
  /**
   * <pre>
   * Lab testing information concerning this product.
   * </pre>
   *
   * <code>.opencannabis.structs.labtesting.TestResults tests = 8;</code>
   */
  public io.opencannabis.schema.product.struct.testing.TestResultsOrBuilder getTestsOrBuilder() {
    return getTests();
  }

  public static final int FLAGS_FIELD_NUMBER = 9;
  private java.util.List<java.lang.Integer> flags_;
  private static final com.google.protobuf.Internal.ListAdapter.Converter<
      java.lang.Integer, io.opencannabis.schema.product.struct.ProductFlag> flags_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, io.opencannabis.schema.product.struct.ProductFlag>() {
            public io.opencannabis.schema.product.struct.ProductFlag convert(java.lang.Integer from) {
              io.opencannabis.schema.product.struct.ProductFlag result = io.opencannabis.schema.product.struct.ProductFlag.valueOf(from);
              return result == null ? io.opencannabis.schema.product.struct.ProductFlag.UNRECOGNIZED : result;
            }
          };
  /**
   * <pre>
   * Product flags attached to this content.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.ProductFlag flags = 9;</code>
   */
  public java.util.List<io.opencannabis.schema.product.struct.ProductFlag> getFlagsList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, io.opencannabis.schema.product.struct.ProductFlag>(flags_, flags_converter_);
  }
  /**
   * <pre>
   * Product flags attached to this content.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.ProductFlag flags = 9;</code>
   */
  public int getFlagsCount() {
    return flags_.size();
  }
  /**
   * <pre>
   * Product flags attached to this content.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.ProductFlag flags = 9;</code>
   */
  public io.opencannabis.schema.product.struct.ProductFlag getFlags(int index) {
    return flags_converter_.convert(flags_.get(index));
  }
  /**
   * <pre>
   * Product flags attached to this content.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.ProductFlag flags = 9;</code>
   */
  public java.util.List<java.lang.Integer>
  getFlagsValueList() {
    return flags_;
  }
  /**
   * <pre>
   * Product flags attached to this content.
   * </pre>
   *
   * <code>repeated .opencannabis.structs.ProductFlag flags = 9;</code>
   */
  public int getFlagsValue(int index) {
    return flags_.get(index);
  }
  private int flagsMemoizedSerializedSize;

  public static final int TS_FIELD_NUMBER = 10;
  private io.opencannabis.schema.content.ProductTimestamps ts_;
  /**
   * <pre>
   * Timestamps for this product.
   * </pre>
   *
   * <code>.opencannabis.content.ProductTimestamps ts = 10;</code>
   */
  public boolean hasTs() {
    return ts_ != null;
  }
  /**
   * <pre>
   * Timestamps for this product.
   * </pre>
   *
   * <code>.opencannabis.content.ProductTimestamps ts = 10;</code>
   */
  public io.opencannabis.schema.content.ProductTimestamps getTs() {
    return ts_ == null ? io.opencannabis.schema.content.ProductTimestamps.getDefaultInstance() : ts_;
  }
  /**
   * <pre>
   * Timestamps for this product.
   * </pre>
   *
   * <code>.opencannabis.content.ProductTimestamps ts = 10;</code>
   */
  public io.opencannabis.schema.content.ProductTimestampsOrBuilder getTsOrBuilder() {
    return getTs();
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    getSerializedSize();
    if (name_ != null) {
      output.writeMessage(1, getName());
    }
    if (brand_ != null) {
      output.writeMessage(2, getBrand());
    }
    if (summary_ != null) {
      output.writeMessage(3, getSummary());
    }
    if (usage_ != null) {
      output.writeMessage(4, getUsage());
    }
    if (dosage_ != null) {
      output.writeMessage(5, getDosage());
    }
    for (int i = 0; i < media_.size(); i++) {
      output.writeMessage(6, media_.get(i));
    }
    if (pricing_ != null) {
      output.writeMessage(7, getPricing());
    }
    if (tests_ != null) {
      output.writeMessage(8, getTests());
    }
    if (getFlagsList().size() > 0) {
      output.writeUInt32NoTag(74);
      output.writeUInt32NoTag(flagsMemoizedSerializedSize);
    }
    for (int i = 0; i < flags_.size(); i++) {
      output.writeEnumNoTag(flags_.get(i));
    }
    if (ts_ != null) {
      output.writeMessage(10, getTs());
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (name_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(1, getName());
    }
    if (brand_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(2, getBrand());
    }
    if (summary_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(3, getSummary());
    }
    if (usage_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(4, getUsage());
    }
    if (dosage_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, getDosage());
    }
    for (int i = 0; i < media_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(6, media_.get(i));
    }
    if (pricing_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(7, getPricing());
    }
    if (tests_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(8, getTests());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < flags_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream
          .computeEnumSizeNoTag(flags_.get(i));
      }
      size += dataSize;
      if (!getFlagsList().isEmpty()) {  size += 1;
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32SizeNoTag(dataSize);
      }flagsMemoizedSerializedSize = dataSize;
    }
    if (ts_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(10, getTs());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.opencannabis.schema.content.ProductContent)) {
      return super.equals(obj);
    }
    io.opencannabis.schema.content.ProductContent other = (io.opencannabis.schema.content.ProductContent) obj;

    boolean result = true;
    result = result && (hasName() == other.hasName());
    if (hasName()) {
      result = result && getName()
          .equals(other.getName());
    }
    result = result && (hasBrand() == other.hasBrand());
    if (hasBrand()) {
      result = result && getBrand()
          .equals(other.getBrand());
    }
    result = result && (hasSummary() == other.hasSummary());
    if (hasSummary()) {
      result = result && getSummary()
          .equals(other.getSummary());
    }
    result = result && (hasUsage() == other.hasUsage());
    if (hasUsage()) {
      result = result && getUsage()
          .equals(other.getUsage());
    }
    result = result && (hasDosage() == other.hasDosage());
    if (hasDosage()) {
      result = result && getDosage()
          .equals(other.getDosage());
    }
    result = result && getMediaList()
        .equals(other.getMediaList());
    result = result && (hasPricing() == other.hasPricing());
    if (hasPricing()) {
      result = result && getPricing()
          .equals(other.getPricing());
    }
    result = result && (hasTests() == other.hasTests());
    if (hasTests()) {
      result = result && getTests()
          .equals(other.getTests());
    }
    result = result && flags_.equals(other.flags_);
    result = result && (hasTs() == other.hasTs());
    if (hasTs()) {
      result = result && getTs()
          .equals(other.getTs());
    }
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasBrand()) {
      hash = (37 * hash) + BRAND_FIELD_NUMBER;
      hash = (53 * hash) + getBrand().hashCode();
    }
    if (hasSummary()) {
      hash = (37 * hash) + SUMMARY_FIELD_NUMBER;
      hash = (53 * hash) + getSummary().hashCode();
    }
    if (hasUsage()) {
      hash = (37 * hash) + USAGE_FIELD_NUMBER;
      hash = (53 * hash) + getUsage().hashCode();
    }
    if (hasDosage()) {
      hash = (37 * hash) + DOSAGE_FIELD_NUMBER;
      hash = (53 * hash) + getDosage().hashCode();
    }
    if (getMediaCount() > 0) {
      hash = (37 * hash) + MEDIA_FIELD_NUMBER;
      hash = (53 * hash) + getMediaList().hashCode();
    }
    if (hasPricing()) {
      hash = (37 * hash) + PRICING_FIELD_NUMBER;
      hash = (53 * hash) + getPricing().hashCode();
    }
    if (hasTests()) {
      hash = (37 * hash) + TESTS_FIELD_NUMBER;
      hash = (53 * hash) + getTests().hashCode();
    }
    if (getFlagsCount() > 0) {
      hash = (37 * hash) + FLAGS_FIELD_NUMBER;
      hash = (53 * hash) + flags_.hashCode();
    }
    if (hasTs()) {
      hash = (37 * hash) + TS_FIELD_NUMBER;
      hash = (53 * hash) + getTs().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.opencannabis.schema.content.ProductContent parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.content.ProductContent parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.content.ProductContent parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.content.ProductContent parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.content.ProductContent parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.content.ProductContent parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.content.ProductContent parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.content.ProductContent parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.content.ProductContent parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.content.ProductContent parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.content.ProductContent parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.content.ProductContent parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.opencannabis.schema.content.ProductContent prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies a common model for product content, mostly user-visible, and shared by all concrete models. Most of the
   * information you see when a product is displayed or listed comes from this model.
   * </pre>
   *
   * Protobuf type {@code opencannabis.content.ProductContent}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:opencannabis.content.ProductContent)
      io.opencannabis.schema.content.ProductContentOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.content.AttachedContent.internal_static_opencannabis_content_ProductContent_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.content.AttachedContent.internal_static_opencannabis_content_ProductContent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.content.ProductContent.class, io.opencannabis.schema.content.ProductContent.Builder.class);
    }

    // Construct using io.opencannabis.schema.content.ProductContent.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
        getMediaFieldBuilder();
      }
    }
    public Builder clear() {
      super.clear();
      if (nameBuilder_ == null) {
        name_ = null;
      } else {
        name_ = null;
        nameBuilder_ = null;
      }
      if (brandBuilder_ == null) {
        brand_ = null;
      } else {
        brand_ = null;
        brandBuilder_ = null;
      }
      if (summaryBuilder_ == null) {
        summary_ = null;
      } else {
        summary_ = null;
        summaryBuilder_ = null;
      }
      if (usageBuilder_ == null) {
        usage_ = null;
      } else {
        usage_ = null;
        usageBuilder_ = null;
      }
      if (dosageBuilder_ == null) {
        dosage_ = null;
      } else {
        dosage_ = null;
        dosageBuilder_ = null;
      }
      if (mediaBuilder_ == null) {
        media_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
      } else {
        mediaBuilder_.clear();
      }
      if (pricingBuilder_ == null) {
        pricing_ = null;
      } else {
        pricing_ = null;
        pricingBuilder_ = null;
      }
      if (testsBuilder_ == null) {
        tests_ = null;
      } else {
        tests_ = null;
        testsBuilder_ = null;
      }
      flags_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000100);
      if (tsBuilder_ == null) {
        ts_ = null;
      } else {
        ts_ = null;
        tsBuilder_ = null;
      }
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.opencannabis.schema.content.AttachedContent.internal_static_opencannabis_content_ProductContent_descriptor;
    }

    public io.opencannabis.schema.content.ProductContent getDefaultInstanceForType() {
      return io.opencannabis.schema.content.ProductContent.getDefaultInstance();
    }

    public io.opencannabis.schema.content.ProductContent build() {
      io.opencannabis.schema.content.ProductContent result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.opencannabis.schema.content.ProductContent buildPartial() {
      io.opencannabis.schema.content.ProductContent result = new io.opencannabis.schema.content.ProductContent(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (nameBuilder_ == null) {
        result.name_ = name_;
      } else {
        result.name_ = nameBuilder_.build();
      }
      if (brandBuilder_ == null) {
        result.brand_ = brand_;
      } else {
        result.brand_ = brandBuilder_.build();
      }
      if (summaryBuilder_ == null) {
        result.summary_ = summary_;
      } else {
        result.summary_ = summaryBuilder_.build();
      }
      if (usageBuilder_ == null) {
        result.usage_ = usage_;
      } else {
        result.usage_ = usageBuilder_.build();
      }
      if (dosageBuilder_ == null) {
        result.dosage_ = dosage_;
      } else {
        result.dosage_ = dosageBuilder_.build();
      }
      if (mediaBuilder_ == null) {
        if (((bitField0_ & 0x00000020) == 0x00000020)) {
          media_ = java.util.Collections.unmodifiableList(media_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.media_ = media_;
      } else {
        result.media_ = mediaBuilder_.build();
      }
      if (pricingBuilder_ == null) {
        result.pricing_ = pricing_;
      } else {
        result.pricing_ = pricingBuilder_.build();
      }
      if (testsBuilder_ == null) {
        result.tests_ = tests_;
      } else {
        result.tests_ = testsBuilder_.build();
      }
      if (((bitField0_ & 0x00000100) == 0x00000100)) {
        flags_ = java.util.Collections.unmodifiableList(flags_);
        bitField0_ = (bitField0_ & ~0x00000100);
      }
      result.flags_ = flags_;
      if (tsBuilder_ == null) {
        result.ts_ = ts_;
      } else {
        result.ts_ = tsBuilder_.build();
      }
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.opencannabis.schema.content.ProductContent) {
        return mergeFrom((io.opencannabis.schema.content.ProductContent)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.opencannabis.schema.content.ProductContent other) {
      if (other == io.opencannabis.schema.content.ProductContent.getDefaultInstance()) return this;
      if (other.hasName()) {
        mergeName(other.getName());
      }
      if (other.hasBrand()) {
        mergeBrand(other.getBrand());
      }
      if (other.hasSummary()) {
        mergeSummary(other.getSummary());
      }
      if (other.hasUsage()) {
        mergeUsage(other.getUsage());
      }
      if (other.hasDosage()) {
        mergeDosage(other.getDosage());
      }
      if (mediaBuilder_ == null) {
        if (!other.media_.isEmpty()) {
          if (media_.isEmpty()) {
            media_ = other.media_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureMediaIsMutable();
            media_.addAll(other.media_);
          }
          onChanged();
        }
      } else {
        if (!other.media_.isEmpty()) {
          if (mediaBuilder_.isEmpty()) {
            mediaBuilder_.dispose();
            mediaBuilder_ = null;
            media_ = other.media_;
            bitField0_ = (bitField0_ & ~0x00000020);
            mediaBuilder_ = 
              com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                 getMediaFieldBuilder() : null;
          } else {
            mediaBuilder_.addAllMessages(other.media_);
          }
        }
      }
      if (other.hasPricing()) {
        mergePricing(other.getPricing());
      }
      if (other.hasTests()) {
        mergeTests(other.getTests());
      }
      if (!other.flags_.isEmpty()) {
        if (flags_.isEmpty()) {
          flags_ = other.flags_;
          bitField0_ = (bitField0_ & ~0x00000100);
        } else {
          ensureFlagsIsMutable();
          flags_.addAll(other.flags_);
        }
        onChanged();
      }
      if (other.hasTs()) {
        mergeTs(other.getTs());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.opencannabis.schema.content.ProductContent parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.opencannabis.schema.content.ProductContent) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private io.opencannabis.schema.content.Name name_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.content.Name, io.opencannabis.schema.content.Name.Builder, io.opencannabis.schema.content.NameOrBuilder> nameBuilder_;
    /**
     * <pre>
     * Main product name.
     * </pre>
     *
     * <code>.opencannabis.content.Name name = 1;</code>
     */
    public boolean hasName() {
      return nameBuilder_ != null || name_ != null;
    }
    /**
     * <pre>
     * Main product name.
     * </pre>
     *
     * <code>.opencannabis.content.Name name = 1;</code>
     */
    public io.opencannabis.schema.content.Name getName() {
      if (nameBuilder_ == null) {
        return name_ == null ? io.opencannabis.schema.content.Name.getDefaultInstance() : name_;
      } else {
        return nameBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Main product name.
     * </pre>
     *
     * <code>.opencannabis.content.Name name = 1;</code>
     */
    public Builder setName(io.opencannabis.schema.content.Name value) {
      if (nameBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        onChanged();
      } else {
        nameBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Main product name.
     * </pre>
     *
     * <code>.opencannabis.content.Name name = 1;</code>
     */
    public Builder setName(
        io.opencannabis.schema.content.Name.Builder builderForValue) {
      if (nameBuilder_ == null) {
        name_ = builderForValue.build();
        onChanged();
      } else {
        nameBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Main product name.
     * </pre>
     *
     * <code>.opencannabis.content.Name name = 1;</code>
     */
    public Builder mergeName(io.opencannabis.schema.content.Name value) {
      if (nameBuilder_ == null) {
        if (name_ != null) {
          name_ =
            io.opencannabis.schema.content.Name.newBuilder(name_).mergeFrom(value).buildPartial();
        } else {
          name_ = value;
        }
        onChanged();
      } else {
        nameBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Main product name.
     * </pre>
     *
     * <code>.opencannabis.content.Name name = 1;</code>
     */
    public Builder clearName() {
      if (nameBuilder_ == null) {
        name_ = null;
        onChanged();
      } else {
        name_ = null;
        nameBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Main product name.
     * </pre>
     *
     * <code>.opencannabis.content.Name name = 1;</code>
     */
    public io.opencannabis.schema.content.Name.Builder getNameBuilder() {
      
      onChanged();
      return getNameFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Main product name.
     * </pre>
     *
     * <code>.opencannabis.content.Name name = 1;</code>
     */
    public io.opencannabis.schema.content.NameOrBuilder getNameOrBuilder() {
      if (nameBuilder_ != null) {
        return nameBuilder_.getMessageOrBuilder();
      } else {
        return name_ == null ?
            io.opencannabis.schema.content.Name.getDefaultInstance() : name_;
      }
    }
    /**
     * <pre>
     * Main product name.
     * </pre>
     *
     * <code>.opencannabis.content.Name name = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.content.Name, io.opencannabis.schema.content.Name.Builder, io.opencannabis.schema.content.NameOrBuilder> 
        getNameFieldBuilder() {
      if (nameBuilder_ == null) {
        nameBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.content.Name, io.opencannabis.schema.content.Name.Builder, io.opencannabis.schema.content.NameOrBuilder>(
                getName(),
                getParentForChildren(),
                isClean());
        name_ = null;
      }
      return nameBuilder_;
    }

    private io.opencannabis.schema.content.Brand brand_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.content.Brand, io.opencannabis.schema.content.Brand.Builder, io.opencannabis.schema.content.BrandOrBuilder> brandBuilder_;
    /**
     * <pre>
     * Brand information for this product.
     * </pre>
     *
     * <code>.opencannabis.content.Brand brand = 2;</code>
     */
    public boolean hasBrand() {
      return brandBuilder_ != null || brand_ != null;
    }
    /**
     * <pre>
     * Brand information for this product.
     * </pre>
     *
     * <code>.opencannabis.content.Brand brand = 2;</code>
     */
    public io.opencannabis.schema.content.Brand getBrand() {
      if (brandBuilder_ == null) {
        return brand_ == null ? io.opencannabis.schema.content.Brand.getDefaultInstance() : brand_;
      } else {
        return brandBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Brand information for this product.
     * </pre>
     *
     * <code>.opencannabis.content.Brand brand = 2;</code>
     */
    public Builder setBrand(io.opencannabis.schema.content.Brand value) {
      if (brandBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        brand_ = value;
        onChanged();
      } else {
        brandBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Brand information for this product.
     * </pre>
     *
     * <code>.opencannabis.content.Brand brand = 2;</code>
     */
    public Builder setBrand(
        io.opencannabis.schema.content.Brand.Builder builderForValue) {
      if (brandBuilder_ == null) {
        brand_ = builderForValue.build();
        onChanged();
      } else {
        brandBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Brand information for this product.
     * </pre>
     *
     * <code>.opencannabis.content.Brand brand = 2;</code>
     */
    public Builder mergeBrand(io.opencannabis.schema.content.Brand value) {
      if (brandBuilder_ == null) {
        if (brand_ != null) {
          brand_ =
            io.opencannabis.schema.content.Brand.newBuilder(brand_).mergeFrom(value).buildPartial();
        } else {
          brand_ = value;
        }
        onChanged();
      } else {
        brandBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Brand information for this product.
     * </pre>
     *
     * <code>.opencannabis.content.Brand brand = 2;</code>
     */
    public Builder clearBrand() {
      if (brandBuilder_ == null) {
        brand_ = null;
        onChanged();
      } else {
        brand_ = null;
        brandBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Brand information for this product.
     * </pre>
     *
     * <code>.opencannabis.content.Brand brand = 2;</code>
     */
    public io.opencannabis.schema.content.Brand.Builder getBrandBuilder() {
      
      onChanged();
      return getBrandFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Brand information for this product.
     * </pre>
     *
     * <code>.opencannabis.content.Brand brand = 2;</code>
     */
    public io.opencannabis.schema.content.BrandOrBuilder getBrandOrBuilder() {
      if (brandBuilder_ != null) {
        return brandBuilder_.getMessageOrBuilder();
      } else {
        return brand_ == null ?
            io.opencannabis.schema.content.Brand.getDefaultInstance() : brand_;
      }
    }
    /**
     * <pre>
     * Brand information for this product.
     * </pre>
     *
     * <code>.opencannabis.content.Brand brand = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.content.Brand, io.opencannabis.schema.content.Brand.Builder, io.opencannabis.schema.content.BrandOrBuilder> 
        getBrandFieldBuilder() {
      if (brandBuilder_ == null) {
        brandBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.content.Brand, io.opencannabis.schema.content.Brand.Builder, io.opencannabis.schema.content.BrandOrBuilder>(
                getBrand(),
                getParentForChildren(),
                isClean());
        brand_ = null;
      }
      return brandBuilder_;
    }

    private io.opencannabis.schema.content.Content summary_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.content.Content, io.opencannabis.schema.content.Content.Builder, io.opencannabis.schema.content.ContentOrBuilder> summaryBuilder_;
    /**
     * <pre>
     * Description or narrative-style content about this product.
     * </pre>
     *
     * <code>.opencannabis.content.Content summary = 3;</code>
     */
    public boolean hasSummary() {
      return summaryBuilder_ != null || summary_ != null;
    }
    /**
     * <pre>
     * Description or narrative-style content about this product.
     * </pre>
     *
     * <code>.opencannabis.content.Content summary = 3;</code>
     */
    public io.opencannabis.schema.content.Content getSummary() {
      if (summaryBuilder_ == null) {
        return summary_ == null ? io.opencannabis.schema.content.Content.getDefaultInstance() : summary_;
      } else {
        return summaryBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Description or narrative-style content about this product.
     * </pre>
     *
     * <code>.opencannabis.content.Content summary = 3;</code>
     */
    public Builder setSummary(io.opencannabis.schema.content.Content value) {
      if (summaryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        summary_ = value;
        onChanged();
      } else {
        summaryBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Description or narrative-style content about this product.
     * </pre>
     *
     * <code>.opencannabis.content.Content summary = 3;</code>
     */
    public Builder setSummary(
        io.opencannabis.schema.content.Content.Builder builderForValue) {
      if (summaryBuilder_ == null) {
        summary_ = builderForValue.build();
        onChanged();
      } else {
        summaryBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Description or narrative-style content about this product.
     * </pre>
     *
     * <code>.opencannabis.content.Content summary = 3;</code>
     */
    public Builder mergeSummary(io.opencannabis.schema.content.Content value) {
      if (summaryBuilder_ == null) {
        if (summary_ != null) {
          summary_ =
            io.opencannabis.schema.content.Content.newBuilder(summary_).mergeFrom(value).buildPartial();
        } else {
          summary_ = value;
        }
        onChanged();
      } else {
        summaryBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Description or narrative-style content about this product.
     * </pre>
     *
     * <code>.opencannabis.content.Content summary = 3;</code>
     */
    public Builder clearSummary() {
      if (summaryBuilder_ == null) {
        summary_ = null;
        onChanged();
      } else {
        summary_ = null;
        summaryBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Description or narrative-style content about this product.
     * </pre>
     *
     * <code>.opencannabis.content.Content summary = 3;</code>
     */
    public io.opencannabis.schema.content.Content.Builder getSummaryBuilder() {
      
      onChanged();
      return getSummaryFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Description or narrative-style content about this product.
     * </pre>
     *
     * <code>.opencannabis.content.Content summary = 3;</code>
     */
    public io.opencannabis.schema.content.ContentOrBuilder getSummaryOrBuilder() {
      if (summaryBuilder_ != null) {
        return summaryBuilder_.getMessageOrBuilder();
      } else {
        return summary_ == null ?
            io.opencannabis.schema.content.Content.getDefaultInstance() : summary_;
      }
    }
    /**
     * <pre>
     * Description or narrative-style content about this product.
     * </pre>
     *
     * <code>.opencannabis.content.Content summary = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.content.Content, io.opencannabis.schema.content.Content.Builder, io.opencannabis.schema.content.ContentOrBuilder> 
        getSummaryFieldBuilder() {
      if (summaryBuilder_ == null) {
        summaryBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.content.Content, io.opencannabis.schema.content.Content.Builder, io.opencannabis.schema.content.ContentOrBuilder>(
                getSummary(),
                getParentForChildren(),
                isClean());
        summary_ = null;
      }
      return summaryBuilder_;
    }

    private io.opencannabis.schema.content.Content usage_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.content.Content, io.opencannabis.schema.content.Content.Builder, io.opencannabis.schema.content.ContentOrBuilder> usageBuilder_;
    /**
     * <pre>
     * Content about how this product is best used, or recommended to be used, either from the manufacturer or retailer.
     * </pre>
     *
     * <code>.opencannabis.content.Content usage = 4;</code>
     */
    public boolean hasUsage() {
      return usageBuilder_ != null || usage_ != null;
    }
    /**
     * <pre>
     * Content about how this product is best used, or recommended to be used, either from the manufacturer or retailer.
     * </pre>
     *
     * <code>.opencannabis.content.Content usage = 4;</code>
     */
    public io.opencannabis.schema.content.Content getUsage() {
      if (usageBuilder_ == null) {
        return usage_ == null ? io.opencannabis.schema.content.Content.getDefaultInstance() : usage_;
      } else {
        return usageBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Content about how this product is best used, or recommended to be used, either from the manufacturer or retailer.
     * </pre>
     *
     * <code>.opencannabis.content.Content usage = 4;</code>
     */
    public Builder setUsage(io.opencannabis.schema.content.Content value) {
      if (usageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        usage_ = value;
        onChanged();
      } else {
        usageBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Content about how this product is best used, or recommended to be used, either from the manufacturer or retailer.
     * </pre>
     *
     * <code>.opencannabis.content.Content usage = 4;</code>
     */
    public Builder setUsage(
        io.opencannabis.schema.content.Content.Builder builderForValue) {
      if (usageBuilder_ == null) {
        usage_ = builderForValue.build();
        onChanged();
      } else {
        usageBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Content about how this product is best used, or recommended to be used, either from the manufacturer or retailer.
     * </pre>
     *
     * <code>.opencannabis.content.Content usage = 4;</code>
     */
    public Builder mergeUsage(io.opencannabis.schema.content.Content value) {
      if (usageBuilder_ == null) {
        if (usage_ != null) {
          usage_ =
            io.opencannabis.schema.content.Content.newBuilder(usage_).mergeFrom(value).buildPartial();
        } else {
          usage_ = value;
        }
        onChanged();
      } else {
        usageBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Content about how this product is best used, or recommended to be used, either from the manufacturer or retailer.
     * </pre>
     *
     * <code>.opencannabis.content.Content usage = 4;</code>
     */
    public Builder clearUsage() {
      if (usageBuilder_ == null) {
        usage_ = null;
        onChanged();
      } else {
        usage_ = null;
        usageBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Content about how this product is best used, or recommended to be used, either from the manufacturer or retailer.
     * </pre>
     *
     * <code>.opencannabis.content.Content usage = 4;</code>
     */
    public io.opencannabis.schema.content.Content.Builder getUsageBuilder() {
      
      onChanged();
      return getUsageFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Content about how this product is best used, or recommended to be used, either from the manufacturer or retailer.
     * </pre>
     *
     * <code>.opencannabis.content.Content usage = 4;</code>
     */
    public io.opencannabis.schema.content.ContentOrBuilder getUsageOrBuilder() {
      if (usageBuilder_ != null) {
        return usageBuilder_.getMessageOrBuilder();
      } else {
        return usage_ == null ?
            io.opencannabis.schema.content.Content.getDefaultInstance() : usage_;
      }
    }
    /**
     * <pre>
     * Content about how this product is best used, or recommended to be used, either from the manufacturer or retailer.
     * </pre>
     *
     * <code>.opencannabis.content.Content usage = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.content.Content, io.opencannabis.schema.content.Content.Builder, io.opencannabis.schema.content.ContentOrBuilder> 
        getUsageFieldBuilder() {
      if (usageBuilder_ == null) {
        usageBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.content.Content, io.opencannabis.schema.content.Content.Builder, io.opencannabis.schema.content.ContentOrBuilder>(
                getUsage(),
                getParentForChildren(),
                isClean());
        usage_ = null;
      }
      return usageBuilder_;
    }

    private io.opencannabis.schema.content.Content dosage_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.content.Content, io.opencannabis.schema.content.Content.Builder, io.opencannabis.schema.content.ContentOrBuilder> dosageBuilder_;
    /**
     * <pre>
     * Dosage advice about this product, either from the manufacturer or retailer.
     * </pre>
     *
     * <code>.opencannabis.content.Content dosage = 5;</code>
     */
    public boolean hasDosage() {
      return dosageBuilder_ != null || dosage_ != null;
    }
    /**
     * <pre>
     * Dosage advice about this product, either from the manufacturer or retailer.
     * </pre>
     *
     * <code>.opencannabis.content.Content dosage = 5;</code>
     */
    public io.opencannabis.schema.content.Content getDosage() {
      if (dosageBuilder_ == null) {
        return dosage_ == null ? io.opencannabis.schema.content.Content.getDefaultInstance() : dosage_;
      } else {
        return dosageBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Dosage advice about this product, either from the manufacturer or retailer.
     * </pre>
     *
     * <code>.opencannabis.content.Content dosage = 5;</code>
     */
    public Builder setDosage(io.opencannabis.schema.content.Content value) {
      if (dosageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dosage_ = value;
        onChanged();
      } else {
        dosageBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Dosage advice about this product, either from the manufacturer or retailer.
     * </pre>
     *
     * <code>.opencannabis.content.Content dosage = 5;</code>
     */
    public Builder setDosage(
        io.opencannabis.schema.content.Content.Builder builderForValue) {
      if (dosageBuilder_ == null) {
        dosage_ = builderForValue.build();
        onChanged();
      } else {
        dosageBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Dosage advice about this product, either from the manufacturer or retailer.
     * </pre>
     *
     * <code>.opencannabis.content.Content dosage = 5;</code>
     */
    public Builder mergeDosage(io.opencannabis.schema.content.Content value) {
      if (dosageBuilder_ == null) {
        if (dosage_ != null) {
          dosage_ =
            io.opencannabis.schema.content.Content.newBuilder(dosage_).mergeFrom(value).buildPartial();
        } else {
          dosage_ = value;
        }
        onChanged();
      } else {
        dosageBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Dosage advice about this product, either from the manufacturer or retailer.
     * </pre>
     *
     * <code>.opencannabis.content.Content dosage = 5;</code>
     */
    public Builder clearDosage() {
      if (dosageBuilder_ == null) {
        dosage_ = null;
        onChanged();
      } else {
        dosage_ = null;
        dosageBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Dosage advice about this product, either from the manufacturer or retailer.
     * </pre>
     *
     * <code>.opencannabis.content.Content dosage = 5;</code>
     */
    public io.opencannabis.schema.content.Content.Builder getDosageBuilder() {
      
      onChanged();
      return getDosageFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Dosage advice about this product, either from the manufacturer or retailer.
     * </pre>
     *
     * <code>.opencannabis.content.Content dosage = 5;</code>
     */
    public io.opencannabis.schema.content.ContentOrBuilder getDosageOrBuilder() {
      if (dosageBuilder_ != null) {
        return dosageBuilder_.getMessageOrBuilder();
      } else {
        return dosage_ == null ?
            io.opencannabis.schema.content.Content.getDefaultInstance() : dosage_;
      }
    }
    /**
     * <pre>
     * Dosage advice about this product, either from the manufacturer or retailer.
     * </pre>
     *
     * <code>.opencannabis.content.Content dosage = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.content.Content, io.opencannabis.schema.content.Content.Builder, io.opencannabis.schema.content.ContentOrBuilder> 
        getDosageFieldBuilder() {
      if (dosageBuilder_ == null) {
        dosageBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.content.Content, io.opencannabis.schema.content.Content.Builder, io.opencannabis.schema.content.ContentOrBuilder>(
                getDosage(),
                getParentForChildren(),
                isClean());
        dosage_ = null;
      }
      return dosageBuilder_;
    }

    private java.util.List<io.opencannabis.schema.media.MediaItem> media_ =
      java.util.Collections.emptyList();
    private void ensureMediaIsMutable() {
      if (!((bitField0_ & 0x00000020) == 0x00000020)) {
        media_ = new java.util.ArrayList<io.opencannabis.schema.media.MediaItem>(media_);
        bitField0_ |= 0x00000020;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.opencannabis.schema.media.MediaItem, io.opencannabis.schema.media.MediaItem.Builder, io.opencannabis.schema.media.MediaItemOrBuilder> mediaBuilder_;

    /**
     * <pre>
     * Product media, including images, videos, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.media.MediaItem media = 6;</code>
     */
    public java.util.List<io.opencannabis.schema.media.MediaItem> getMediaList() {
      if (mediaBuilder_ == null) {
        return java.util.Collections.unmodifiableList(media_);
      } else {
        return mediaBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Product media, including images, videos, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.media.MediaItem media = 6;</code>
     */
    public int getMediaCount() {
      if (mediaBuilder_ == null) {
        return media_.size();
      } else {
        return mediaBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Product media, including images, videos, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.media.MediaItem media = 6;</code>
     */
    public io.opencannabis.schema.media.MediaItem getMedia(int index) {
      if (mediaBuilder_ == null) {
        return media_.get(index);
      } else {
        return mediaBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Product media, including images, videos, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.media.MediaItem media = 6;</code>
     */
    public Builder setMedia(
        int index, io.opencannabis.schema.media.MediaItem value) {
      if (mediaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMediaIsMutable();
        media_.set(index, value);
        onChanged();
      } else {
        mediaBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Product media, including images, videos, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.media.MediaItem media = 6;</code>
     */
    public Builder setMedia(
        int index, io.opencannabis.schema.media.MediaItem.Builder builderForValue) {
      if (mediaBuilder_ == null) {
        ensureMediaIsMutable();
        media_.set(index, builderForValue.build());
        onChanged();
      } else {
        mediaBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Product media, including images, videos, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.media.MediaItem media = 6;</code>
     */
    public Builder addMedia(io.opencannabis.schema.media.MediaItem value) {
      if (mediaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMediaIsMutable();
        media_.add(value);
        onChanged();
      } else {
        mediaBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Product media, including images, videos, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.media.MediaItem media = 6;</code>
     */
    public Builder addMedia(
        int index, io.opencannabis.schema.media.MediaItem value) {
      if (mediaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMediaIsMutable();
        media_.add(index, value);
        onChanged();
      } else {
        mediaBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Product media, including images, videos, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.media.MediaItem media = 6;</code>
     */
    public Builder addMedia(
        io.opencannabis.schema.media.MediaItem.Builder builderForValue) {
      if (mediaBuilder_ == null) {
        ensureMediaIsMutable();
        media_.add(builderForValue.build());
        onChanged();
      } else {
        mediaBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Product media, including images, videos, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.media.MediaItem media = 6;</code>
     */
    public Builder addMedia(
        int index, io.opencannabis.schema.media.MediaItem.Builder builderForValue) {
      if (mediaBuilder_ == null) {
        ensureMediaIsMutable();
        media_.add(index, builderForValue.build());
        onChanged();
      } else {
        mediaBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Product media, including images, videos, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.media.MediaItem media = 6;</code>
     */
    public Builder addAllMedia(
        java.lang.Iterable<? extends io.opencannabis.schema.media.MediaItem> values) {
      if (mediaBuilder_ == null) {
        ensureMediaIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, media_);
        onChanged();
      } else {
        mediaBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Product media, including images, videos, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.media.MediaItem media = 6;</code>
     */
    public Builder clearMedia() {
      if (mediaBuilder_ == null) {
        media_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        mediaBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Product media, including images, videos, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.media.MediaItem media = 6;</code>
     */
    public Builder removeMedia(int index) {
      if (mediaBuilder_ == null) {
        ensureMediaIsMutable();
        media_.remove(index);
        onChanged();
      } else {
        mediaBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Product media, including images, videos, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.media.MediaItem media = 6;</code>
     */
    public io.opencannabis.schema.media.MediaItem.Builder getMediaBuilder(
        int index) {
      return getMediaFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Product media, including images, videos, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.media.MediaItem media = 6;</code>
     */
    public io.opencannabis.schema.media.MediaItemOrBuilder getMediaOrBuilder(
        int index) {
      if (mediaBuilder_ == null) {
        return media_.get(index);  } else {
        return mediaBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Product media, including images, videos, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.media.MediaItem media = 6;</code>
     */
    public java.util.List<? extends io.opencannabis.schema.media.MediaItemOrBuilder> 
         getMediaOrBuilderList() {
      if (mediaBuilder_ != null) {
        return mediaBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(media_);
      }
    }
    /**
     * <pre>
     * Product media, including images, videos, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.media.MediaItem media = 6;</code>
     */
    public io.opencannabis.schema.media.MediaItem.Builder addMediaBuilder() {
      return getMediaFieldBuilder().addBuilder(
          io.opencannabis.schema.media.MediaItem.getDefaultInstance());
    }
    /**
     * <pre>
     * Product media, including images, videos, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.media.MediaItem media = 6;</code>
     */
    public io.opencannabis.schema.media.MediaItem.Builder addMediaBuilder(
        int index) {
      return getMediaFieldBuilder().addBuilder(
          index, io.opencannabis.schema.media.MediaItem.getDefaultInstance());
    }
    /**
     * <pre>
     * Product media, including images, videos, and so on.
     * </pre>
     *
     * <code>repeated .opencannabis.media.MediaItem media = 6;</code>
     */
    public java.util.List<io.opencannabis.schema.media.MediaItem.Builder> 
         getMediaBuilderList() {
      return getMediaFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        io.opencannabis.schema.media.MediaItem, io.opencannabis.schema.media.MediaItem.Builder, io.opencannabis.schema.media.MediaItemOrBuilder> 
        getMediaFieldBuilder() {
      if (mediaBuilder_ == null) {
        mediaBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            io.opencannabis.schema.media.MediaItem, io.opencannabis.schema.media.MediaItem.Builder, io.opencannabis.schema.media.MediaItemOrBuilder>(
                media_,
                ((bitField0_ & 0x00000020) == 0x00000020),
                getParentForChildren(),
                isClean());
        media_ = null;
      }
      return mediaBuilder_;
    }

    private io.opencannabis.schema.product.struct.ProductPricing pricing_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.product.struct.ProductPricing, io.opencannabis.schema.product.struct.ProductPricing.Builder, io.opencannabis.schema.product.struct.ProductPricingOrBuilder> pricingBuilder_;
    /**
     * <pre>
     * Pricing specification for this product, regardless of pricing type (i.e. weighted or unit-style pricing).
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.ProductPricing pricing = 7;</code>
     */
    public boolean hasPricing() {
      return pricingBuilder_ != null || pricing_ != null;
    }
    /**
     * <pre>
     * Pricing specification for this product, regardless of pricing type (i.e. weighted or unit-style pricing).
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.ProductPricing pricing = 7;</code>
     */
    public io.opencannabis.schema.product.struct.ProductPricing getPricing() {
      if (pricingBuilder_ == null) {
        return pricing_ == null ? io.opencannabis.schema.product.struct.ProductPricing.getDefaultInstance() : pricing_;
      } else {
        return pricingBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Pricing specification for this product, regardless of pricing type (i.e. weighted or unit-style pricing).
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.ProductPricing pricing = 7;</code>
     */
    public Builder setPricing(io.opencannabis.schema.product.struct.ProductPricing value) {
      if (pricingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pricing_ = value;
        onChanged();
      } else {
        pricingBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Pricing specification for this product, regardless of pricing type (i.e. weighted or unit-style pricing).
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.ProductPricing pricing = 7;</code>
     */
    public Builder setPricing(
        io.opencannabis.schema.product.struct.ProductPricing.Builder builderForValue) {
      if (pricingBuilder_ == null) {
        pricing_ = builderForValue.build();
        onChanged();
      } else {
        pricingBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Pricing specification for this product, regardless of pricing type (i.e. weighted or unit-style pricing).
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.ProductPricing pricing = 7;</code>
     */
    public Builder mergePricing(io.opencannabis.schema.product.struct.ProductPricing value) {
      if (pricingBuilder_ == null) {
        if (pricing_ != null) {
          pricing_ =
            io.opencannabis.schema.product.struct.ProductPricing.newBuilder(pricing_).mergeFrom(value).buildPartial();
        } else {
          pricing_ = value;
        }
        onChanged();
      } else {
        pricingBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Pricing specification for this product, regardless of pricing type (i.e. weighted or unit-style pricing).
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.ProductPricing pricing = 7;</code>
     */
    public Builder clearPricing() {
      if (pricingBuilder_ == null) {
        pricing_ = null;
        onChanged();
      } else {
        pricing_ = null;
        pricingBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Pricing specification for this product, regardless of pricing type (i.e. weighted or unit-style pricing).
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.ProductPricing pricing = 7;</code>
     */
    public io.opencannabis.schema.product.struct.ProductPricing.Builder getPricingBuilder() {
      
      onChanged();
      return getPricingFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Pricing specification for this product, regardless of pricing type (i.e. weighted or unit-style pricing).
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.ProductPricing pricing = 7;</code>
     */
    public io.opencannabis.schema.product.struct.ProductPricingOrBuilder getPricingOrBuilder() {
      if (pricingBuilder_ != null) {
        return pricingBuilder_.getMessageOrBuilder();
      } else {
        return pricing_ == null ?
            io.opencannabis.schema.product.struct.ProductPricing.getDefaultInstance() : pricing_;
      }
    }
    /**
     * <pre>
     * Pricing specification for this product, regardless of pricing type (i.e. weighted or unit-style pricing).
     * </pre>
     *
     * <code>.opencannabis.structs.pricing.ProductPricing pricing = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.product.struct.ProductPricing, io.opencannabis.schema.product.struct.ProductPricing.Builder, io.opencannabis.schema.product.struct.ProductPricingOrBuilder> 
        getPricingFieldBuilder() {
      if (pricingBuilder_ == null) {
        pricingBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.product.struct.ProductPricing, io.opencannabis.schema.product.struct.ProductPricing.Builder, io.opencannabis.schema.product.struct.ProductPricingOrBuilder>(
                getPricing(),
                getParentForChildren(),
                isClean());
        pricing_ = null;
      }
      return pricingBuilder_;
    }

    private io.opencannabis.schema.product.struct.testing.TestResults tests_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.product.struct.testing.TestResults, io.opencannabis.schema.product.struct.testing.TestResults.Builder, io.opencannabis.schema.product.struct.testing.TestResultsOrBuilder> testsBuilder_;
    /**
     * <pre>
     * Lab testing information concerning this product.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.TestResults tests = 8;</code>
     */
    public boolean hasTests() {
      return testsBuilder_ != null || tests_ != null;
    }
    /**
     * <pre>
     * Lab testing information concerning this product.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.TestResults tests = 8;</code>
     */
    public io.opencannabis.schema.product.struct.testing.TestResults getTests() {
      if (testsBuilder_ == null) {
        return tests_ == null ? io.opencannabis.schema.product.struct.testing.TestResults.getDefaultInstance() : tests_;
      } else {
        return testsBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Lab testing information concerning this product.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.TestResults tests = 8;</code>
     */
    public Builder setTests(io.opencannabis.schema.product.struct.testing.TestResults value) {
      if (testsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tests_ = value;
        onChanged();
      } else {
        testsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Lab testing information concerning this product.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.TestResults tests = 8;</code>
     */
    public Builder setTests(
        io.opencannabis.schema.product.struct.testing.TestResults.Builder builderForValue) {
      if (testsBuilder_ == null) {
        tests_ = builderForValue.build();
        onChanged();
      } else {
        testsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Lab testing information concerning this product.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.TestResults tests = 8;</code>
     */
    public Builder mergeTests(io.opencannabis.schema.product.struct.testing.TestResults value) {
      if (testsBuilder_ == null) {
        if (tests_ != null) {
          tests_ =
            io.opencannabis.schema.product.struct.testing.TestResults.newBuilder(tests_).mergeFrom(value).buildPartial();
        } else {
          tests_ = value;
        }
        onChanged();
      } else {
        testsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Lab testing information concerning this product.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.TestResults tests = 8;</code>
     */
    public Builder clearTests() {
      if (testsBuilder_ == null) {
        tests_ = null;
        onChanged();
      } else {
        tests_ = null;
        testsBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Lab testing information concerning this product.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.TestResults tests = 8;</code>
     */
    public io.opencannabis.schema.product.struct.testing.TestResults.Builder getTestsBuilder() {
      
      onChanged();
      return getTestsFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Lab testing information concerning this product.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.TestResults tests = 8;</code>
     */
    public io.opencannabis.schema.product.struct.testing.TestResultsOrBuilder getTestsOrBuilder() {
      if (testsBuilder_ != null) {
        return testsBuilder_.getMessageOrBuilder();
      } else {
        return tests_ == null ?
            io.opencannabis.schema.product.struct.testing.TestResults.getDefaultInstance() : tests_;
      }
    }
    /**
     * <pre>
     * Lab testing information concerning this product.
     * </pre>
     *
     * <code>.opencannabis.structs.labtesting.TestResults tests = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.product.struct.testing.TestResults, io.opencannabis.schema.product.struct.testing.TestResults.Builder, io.opencannabis.schema.product.struct.testing.TestResultsOrBuilder> 
        getTestsFieldBuilder() {
      if (testsBuilder_ == null) {
        testsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.product.struct.testing.TestResults, io.opencannabis.schema.product.struct.testing.TestResults.Builder, io.opencannabis.schema.product.struct.testing.TestResultsOrBuilder>(
                getTests(),
                getParentForChildren(),
                isClean());
        tests_ = null;
      }
      return testsBuilder_;
    }

    private java.util.List<java.lang.Integer> flags_ =
      java.util.Collections.emptyList();
    private void ensureFlagsIsMutable() {
      if (!((bitField0_ & 0x00000100) == 0x00000100)) {
        flags_ = new java.util.ArrayList<java.lang.Integer>(flags_);
        bitField0_ |= 0x00000100;
      }
    }
    /**
     * <pre>
     * Product flags attached to this content.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.ProductFlag flags = 9;</code>
     */
    public java.util.List<io.opencannabis.schema.product.struct.ProductFlag> getFlagsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, io.opencannabis.schema.product.struct.ProductFlag>(flags_, flags_converter_);
    }
    /**
     * <pre>
     * Product flags attached to this content.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.ProductFlag flags = 9;</code>
     */
    public int getFlagsCount() {
      return flags_.size();
    }
    /**
     * <pre>
     * Product flags attached to this content.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.ProductFlag flags = 9;</code>
     */
    public io.opencannabis.schema.product.struct.ProductFlag getFlags(int index) {
      return flags_converter_.convert(flags_.get(index));
    }
    /**
     * <pre>
     * Product flags attached to this content.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.ProductFlag flags = 9;</code>
     */
    public Builder setFlags(
        int index, io.opencannabis.schema.product.struct.ProductFlag value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFlagsIsMutable();
      flags_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Product flags attached to this content.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.ProductFlag flags = 9;</code>
     */
    public Builder addFlags(io.opencannabis.schema.product.struct.ProductFlag value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureFlagsIsMutable();
      flags_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Product flags attached to this content.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.ProductFlag flags = 9;</code>
     */
    public Builder addAllFlags(
        java.lang.Iterable<? extends io.opencannabis.schema.product.struct.ProductFlag> values) {
      ensureFlagsIsMutable();
      for (io.opencannabis.schema.product.struct.ProductFlag value : values) {
        flags_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Product flags attached to this content.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.ProductFlag flags = 9;</code>
     */
    public Builder clearFlags() {
      flags_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Product flags attached to this content.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.ProductFlag flags = 9;</code>
     */
    public java.util.List<java.lang.Integer>
    getFlagsValueList() {
      return java.util.Collections.unmodifiableList(flags_);
    }
    /**
     * <pre>
     * Product flags attached to this content.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.ProductFlag flags = 9;</code>
     */
    public int getFlagsValue(int index) {
      return flags_.get(index);
    }
    /**
     * <pre>
     * Product flags attached to this content.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.ProductFlag flags = 9;</code>
     */
    public Builder setFlagsValue(
        int index, int value) {
      ensureFlagsIsMutable();
      flags_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Product flags attached to this content.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.ProductFlag flags = 9;</code>
     */
    public Builder addFlagsValue(int value) {
      ensureFlagsIsMutable();
      flags_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Product flags attached to this content.
     * </pre>
     *
     * <code>repeated .opencannabis.structs.ProductFlag flags = 9;</code>
     */
    public Builder addAllFlagsValue(
        java.lang.Iterable<java.lang.Integer> values) {
      ensureFlagsIsMutable();
      for (int value : values) {
        flags_.add(value);
      }
      onChanged();
      return this;
    }

    private io.opencannabis.schema.content.ProductTimestamps ts_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.content.ProductTimestamps, io.opencannabis.schema.content.ProductTimestamps.Builder, io.opencannabis.schema.content.ProductTimestampsOrBuilder> tsBuilder_;
    /**
     * <pre>
     * Timestamps for this product.
     * </pre>
     *
     * <code>.opencannabis.content.ProductTimestamps ts = 10;</code>
     */
    public boolean hasTs() {
      return tsBuilder_ != null || ts_ != null;
    }
    /**
     * <pre>
     * Timestamps for this product.
     * </pre>
     *
     * <code>.opencannabis.content.ProductTimestamps ts = 10;</code>
     */
    public io.opencannabis.schema.content.ProductTimestamps getTs() {
      if (tsBuilder_ == null) {
        return ts_ == null ? io.opencannabis.schema.content.ProductTimestamps.getDefaultInstance() : ts_;
      } else {
        return tsBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Timestamps for this product.
     * </pre>
     *
     * <code>.opencannabis.content.ProductTimestamps ts = 10;</code>
     */
    public Builder setTs(io.opencannabis.schema.content.ProductTimestamps value) {
      if (tsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ts_ = value;
        onChanged();
      } else {
        tsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Timestamps for this product.
     * </pre>
     *
     * <code>.opencannabis.content.ProductTimestamps ts = 10;</code>
     */
    public Builder setTs(
        io.opencannabis.schema.content.ProductTimestamps.Builder builderForValue) {
      if (tsBuilder_ == null) {
        ts_ = builderForValue.build();
        onChanged();
      } else {
        tsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Timestamps for this product.
     * </pre>
     *
     * <code>.opencannabis.content.ProductTimestamps ts = 10;</code>
     */
    public Builder mergeTs(io.opencannabis.schema.content.ProductTimestamps value) {
      if (tsBuilder_ == null) {
        if (ts_ != null) {
          ts_ =
            io.opencannabis.schema.content.ProductTimestamps.newBuilder(ts_).mergeFrom(value).buildPartial();
        } else {
          ts_ = value;
        }
        onChanged();
      } else {
        tsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Timestamps for this product.
     * </pre>
     *
     * <code>.opencannabis.content.ProductTimestamps ts = 10;</code>
     */
    public Builder clearTs() {
      if (tsBuilder_ == null) {
        ts_ = null;
        onChanged();
      } else {
        ts_ = null;
        tsBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Timestamps for this product.
     * </pre>
     *
     * <code>.opencannabis.content.ProductTimestamps ts = 10;</code>
     */
    public io.opencannabis.schema.content.ProductTimestamps.Builder getTsBuilder() {
      
      onChanged();
      return getTsFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Timestamps for this product.
     * </pre>
     *
     * <code>.opencannabis.content.ProductTimestamps ts = 10;</code>
     */
    public io.opencannabis.schema.content.ProductTimestampsOrBuilder getTsOrBuilder() {
      if (tsBuilder_ != null) {
        return tsBuilder_.getMessageOrBuilder();
      } else {
        return ts_ == null ?
            io.opencannabis.schema.content.ProductTimestamps.getDefaultInstance() : ts_;
      }
    }
    /**
     * <pre>
     * Timestamps for this product.
     * </pre>
     *
     * <code>.opencannabis.content.ProductTimestamps ts = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.content.ProductTimestamps, io.opencannabis.schema.content.ProductTimestamps.Builder, io.opencannabis.schema.content.ProductTimestampsOrBuilder> 
        getTsFieldBuilder() {
      if (tsBuilder_ == null) {
        tsBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.content.ProductTimestamps, io.opencannabis.schema.content.ProductTimestamps.Builder, io.opencannabis.schema.content.ProductTimestampsOrBuilder>(
                getTs(),
                getParentForChildren(),
                isClean());
        ts_ = null;
      }
      return tsBuilder_;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:opencannabis.content.ProductContent)
  }

  // @@protoc_insertion_point(class_scope:opencannabis.content.ProductContent)
  private static final io.opencannabis.schema.content.ProductContent DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.opencannabis.schema.content.ProductContent();
  }

  public static io.opencannabis.schema.content.ProductContent getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ProductContent>
      PARSER = new com.google.protobuf.AbstractParser<ProductContent>() {
    public ProductContent parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new ProductContent(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<ProductContent> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ProductContent> getParserForType() {
    return PARSER;
  }

  public io.opencannabis.schema.content.ProductContent getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

