/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: crypto/primitives/Integrity.proto

package io.opencannabis.schema.crypto.primitives.integrity;

/**
 * <pre>
 * Specifies the hash portion of hashed data, along with the algorithm used to calculate the digest enclosed. This
 * particular container does not specify or otherwise contain the original referenced data.
 * </pre>
 *
 * Protobuf type {@code opencannabis.crypto.primitives.integrity.Hash}
 */
public  final class Hash extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:opencannabis.crypto.primitives.integrity.Hash)
    HashOrBuilder {
private static final long serialVersionUID = 0L;
  // Use Hash.newBuilder() to construct.
  private Hash(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private Hash() {
    algorithm_ = 0;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private Hash(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 8: {
            int rawValue = input.readEnum();

            algorithm_ = rawValue;
            break;
          }
          case 18: {
            digestCase_ = 2;
            digest_ = input.readBytes();
            break;
          }
          case 26: {
            java.lang.String s = input.readStringRequireUtf8();
            digestCase_ = 3;
            digest_ = s;
            break;
          }
          case 34: {
            java.lang.String s = input.readStringRequireUtf8();
            digestCase_ = 4;
            digest_ = s;
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.opencannabis.schema.crypto.primitives.integrity.Integrity.internal_static_opencannabis_crypto_primitives_integrity_Hash_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.opencannabis.schema.crypto.primitives.integrity.Integrity.internal_static_opencannabis_crypto_primitives_integrity_Hash_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.opencannabis.schema.crypto.primitives.integrity.Hash.class, io.opencannabis.schema.crypto.primitives.integrity.Hash.Builder.class);
  }

  private int digestCase_ = 0;
  private java.lang.Object digest_;
  public enum DigestCase
      implements com.google.protobuf.Internal.EnumLite {
    RAW(2),
    HEX(3),
    B64(4),
    DIGEST_NOT_SET(0);
    private final int value;
    private DigestCase(int value) {
      this.value = value;
    }
    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DigestCase valueOf(int value) {
      return forNumber(value);
    }

    public static DigestCase forNumber(int value) {
      switch (value) {
        case 2: return RAW;
        case 3: return HEX;
        case 4: return B64;
        case 0: return DIGEST_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public DigestCase
  getDigestCase() {
    return DigestCase.forNumber(
        digestCase_);
  }

  public static final int ALGORITHM_FIELD_NUMBER = 1;
  private int algorithm_;
  /**
   * <pre>
   * Specifies the algorithm in use.
   * </pre>
   *
   * <code>.opencannabis.crypto.primitives.integrity.HashAlgorithm algorithm = 1;</code>
   */
  public int getAlgorithmValue() {
    return algorithm_;
  }
  /**
   * <pre>
   * Specifies the algorithm in use.
   * </pre>
   *
   * <code>.opencannabis.crypto.primitives.integrity.HashAlgorithm algorithm = 1;</code>
   */
  public io.opencannabis.schema.crypto.primitives.integrity.HashAlgorithm getAlgorithm() {
    io.opencannabis.schema.crypto.primitives.integrity.HashAlgorithm result = io.opencannabis.schema.crypto.primitives.integrity.HashAlgorithm.valueOf(algorithm_);
    return result == null ? io.opencannabis.schema.crypto.primitives.integrity.HashAlgorithm.UNRECOGNIZED : result;
  }

  public static final int RAW_FIELD_NUMBER = 2;
  /**
   * <pre>
   * Raw binary output of the hash algorithm.
   * </pre>
   *
   * <code>bytes raw = 2;</code>
   */
  public com.google.protobuf.ByteString getRaw() {
    if (digestCase_ == 2) {
      return (com.google.protobuf.ByteString) digest_;
    }
    return com.google.protobuf.ByteString.EMPTY;
  }

  public static final int HEX_FIELD_NUMBER = 3;
  /**
   * <pre>
   * Hex-encoded digest value.
   * </pre>
   *
   * <code>string hex = 3;</code>
   */
  public java.lang.String getHex() {
    java.lang.Object ref = "";
    if (digestCase_ == 3) {
      ref = digest_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (digestCase_ == 3) {
        digest_ = s;
      }
      return s;
    }
  }
  /**
   * <pre>
   * Hex-encoded digest value.
   * </pre>
   *
   * <code>string hex = 3;</code>
   */
  public com.google.protobuf.ByteString
      getHexBytes() {
    java.lang.Object ref = "";
    if (digestCase_ == 3) {
      ref = digest_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      if (digestCase_ == 3) {
        digest_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int B64_FIELD_NUMBER = 4;
  /**
   * <pre>
   * Base64-encoded digest value.
   * </pre>
   *
   * <code>string b64 = 4;</code>
   */
  public java.lang.String getB64() {
    java.lang.Object ref = "";
    if (digestCase_ == 4) {
      ref = digest_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (digestCase_ == 4) {
        digest_ = s;
      }
      return s;
    }
  }
  /**
   * <pre>
   * Base64-encoded digest value.
   * </pre>
   *
   * <code>string b64 = 4;</code>
   */
  public com.google.protobuf.ByteString
      getB64Bytes() {
    java.lang.Object ref = "";
    if (digestCase_ == 4) {
      ref = digest_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      if (digestCase_ == 4) {
        digest_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (algorithm_ != io.opencannabis.schema.crypto.primitives.integrity.HashAlgorithm.SHA1.getNumber()) {
      output.writeEnum(1, algorithm_);
    }
    if (digestCase_ == 2) {
      output.writeBytes(
          2, (com.google.protobuf.ByteString) digest_);
    }
    if (digestCase_ == 3) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, digest_);
    }
    if (digestCase_ == 4) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, digest_);
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (algorithm_ != io.opencannabis.schema.crypto.primitives.integrity.HashAlgorithm.SHA1.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(1, algorithm_);
    }
    if (digestCase_ == 2) {
      size += com.google.protobuf.CodedOutputStream
        .computeBytesSize(
            2, (com.google.protobuf.ByteString) digest_);
    }
    if (digestCase_ == 3) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, digest_);
    }
    if (digestCase_ == 4) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, digest_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.opencannabis.schema.crypto.primitives.integrity.Hash)) {
      return super.equals(obj);
    }
    io.opencannabis.schema.crypto.primitives.integrity.Hash other = (io.opencannabis.schema.crypto.primitives.integrity.Hash) obj;

    boolean result = true;
    result = result && algorithm_ == other.algorithm_;
    result = result && getDigestCase().equals(
        other.getDigestCase());
    if (!result) return false;
    switch (digestCase_) {
      case 2:
        result = result && getRaw()
            .equals(other.getRaw());
        break;
      case 3:
        result = result && getHex()
            .equals(other.getHex());
        break;
      case 4:
        result = result && getB64()
            .equals(other.getB64());
        break;
      case 0:
      default:
    }
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ALGORITHM_FIELD_NUMBER;
    hash = (53 * hash) + algorithm_;
    switch (digestCase_) {
      case 2:
        hash = (37 * hash) + RAW_FIELD_NUMBER;
        hash = (53 * hash) + getRaw().hashCode();
        break;
      case 3:
        hash = (37 * hash) + HEX_FIELD_NUMBER;
        hash = (53 * hash) + getHex().hashCode();
        break;
      case 4:
        hash = (37 * hash) + B64_FIELD_NUMBER;
        hash = (53 * hash) + getB64().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.opencannabis.schema.crypto.primitives.integrity.Hash parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.crypto.primitives.integrity.Hash parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.crypto.primitives.integrity.Hash parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.crypto.primitives.integrity.Hash parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.crypto.primitives.integrity.Hash parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.crypto.primitives.integrity.Hash parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.crypto.primitives.integrity.Hash parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.crypto.primitives.integrity.Hash parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.crypto.primitives.integrity.Hash parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.crypto.primitives.integrity.Hash parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.crypto.primitives.integrity.Hash parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.crypto.primitives.integrity.Hash parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.opencannabis.schema.crypto.primitives.integrity.Hash prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies the hash portion of hashed data, along with the algorithm used to calculate the digest enclosed. This
   * particular container does not specify or otherwise contain the original referenced data.
   * </pre>
   *
   * Protobuf type {@code opencannabis.crypto.primitives.integrity.Hash}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:opencannabis.crypto.primitives.integrity.Hash)
      io.opencannabis.schema.crypto.primitives.integrity.HashOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.crypto.primitives.integrity.Integrity.internal_static_opencannabis_crypto_primitives_integrity_Hash_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.crypto.primitives.integrity.Integrity.internal_static_opencannabis_crypto_primitives_integrity_Hash_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.crypto.primitives.integrity.Hash.class, io.opencannabis.schema.crypto.primitives.integrity.Hash.Builder.class);
    }

    // Construct using io.opencannabis.schema.crypto.primitives.integrity.Hash.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      algorithm_ = 0;

      digestCase_ = 0;
      digest_ = null;
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.opencannabis.schema.crypto.primitives.integrity.Integrity.internal_static_opencannabis_crypto_primitives_integrity_Hash_descriptor;
    }

    public io.opencannabis.schema.crypto.primitives.integrity.Hash getDefaultInstanceForType() {
      return io.opencannabis.schema.crypto.primitives.integrity.Hash.getDefaultInstance();
    }

    public io.opencannabis.schema.crypto.primitives.integrity.Hash build() {
      io.opencannabis.schema.crypto.primitives.integrity.Hash result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.opencannabis.schema.crypto.primitives.integrity.Hash buildPartial() {
      io.opencannabis.schema.crypto.primitives.integrity.Hash result = new io.opencannabis.schema.crypto.primitives.integrity.Hash(this);
      result.algorithm_ = algorithm_;
      if (digestCase_ == 2) {
        result.digest_ = digest_;
      }
      if (digestCase_ == 3) {
        result.digest_ = digest_;
      }
      if (digestCase_ == 4) {
        result.digest_ = digest_;
      }
      result.digestCase_ = digestCase_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.opencannabis.schema.crypto.primitives.integrity.Hash) {
        return mergeFrom((io.opencannabis.schema.crypto.primitives.integrity.Hash)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.opencannabis.schema.crypto.primitives.integrity.Hash other) {
      if (other == io.opencannabis.schema.crypto.primitives.integrity.Hash.getDefaultInstance()) return this;
      if (other.algorithm_ != 0) {
        setAlgorithmValue(other.getAlgorithmValue());
      }
      switch (other.getDigestCase()) {
        case RAW: {
          setRaw(other.getRaw());
          break;
        }
        case HEX: {
          digestCase_ = 3;
          digest_ = other.digest_;
          onChanged();
          break;
        }
        case B64: {
          digestCase_ = 4;
          digest_ = other.digest_;
          onChanged();
          break;
        }
        case DIGEST_NOT_SET: {
          break;
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.opencannabis.schema.crypto.primitives.integrity.Hash parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.opencannabis.schema.crypto.primitives.integrity.Hash) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int digestCase_ = 0;
    private java.lang.Object digest_;
    public DigestCase
        getDigestCase() {
      return DigestCase.forNumber(
          digestCase_);
    }

    public Builder clearDigest() {
      digestCase_ = 0;
      digest_ = null;
      onChanged();
      return this;
    }


    private int algorithm_ = 0;
    /**
     * <pre>
     * Specifies the algorithm in use.
     * </pre>
     *
     * <code>.opencannabis.crypto.primitives.integrity.HashAlgorithm algorithm = 1;</code>
     */
    public int getAlgorithmValue() {
      return algorithm_;
    }
    /**
     * <pre>
     * Specifies the algorithm in use.
     * </pre>
     *
     * <code>.opencannabis.crypto.primitives.integrity.HashAlgorithm algorithm = 1;</code>
     */
    public Builder setAlgorithmValue(int value) {
      algorithm_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies the algorithm in use.
     * </pre>
     *
     * <code>.opencannabis.crypto.primitives.integrity.HashAlgorithm algorithm = 1;</code>
     */
    public io.opencannabis.schema.crypto.primitives.integrity.HashAlgorithm getAlgorithm() {
      io.opencannabis.schema.crypto.primitives.integrity.HashAlgorithm result = io.opencannabis.schema.crypto.primitives.integrity.HashAlgorithm.valueOf(algorithm_);
      return result == null ? io.opencannabis.schema.crypto.primitives.integrity.HashAlgorithm.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Specifies the algorithm in use.
     * </pre>
     *
     * <code>.opencannabis.crypto.primitives.integrity.HashAlgorithm algorithm = 1;</code>
     */
    public Builder setAlgorithm(io.opencannabis.schema.crypto.primitives.integrity.HashAlgorithm value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      algorithm_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Specifies the algorithm in use.
     * </pre>
     *
     * <code>.opencannabis.crypto.primitives.integrity.HashAlgorithm algorithm = 1;</code>
     */
    public Builder clearAlgorithm() {
      
      algorithm_ = 0;
      onChanged();
      return this;
    }

    /**
     * <pre>
     * Raw binary output of the hash algorithm.
     * </pre>
     *
     * <code>bytes raw = 2;</code>
     */
    public com.google.protobuf.ByteString getRaw() {
      if (digestCase_ == 2) {
        return (com.google.protobuf.ByteString) digest_;
      }
      return com.google.protobuf.ByteString.EMPTY;
    }
    /**
     * <pre>
     * Raw binary output of the hash algorithm.
     * </pre>
     *
     * <code>bytes raw = 2;</code>
     */
    public Builder setRaw(com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  digestCase_ = 2;
      digest_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Raw binary output of the hash algorithm.
     * </pre>
     *
     * <code>bytes raw = 2;</code>
     */
    public Builder clearRaw() {
      if (digestCase_ == 2) {
        digestCase_ = 0;
        digest_ = null;
        onChanged();
      }
      return this;
    }

    /**
     * <pre>
     * Hex-encoded digest value.
     * </pre>
     *
     * <code>string hex = 3;</code>
     */
    public java.lang.String getHex() {
      java.lang.Object ref = "";
      if (digestCase_ == 3) {
        ref = digest_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (digestCase_ == 3) {
          digest_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Hex-encoded digest value.
     * </pre>
     *
     * <code>string hex = 3;</code>
     */
    public com.google.protobuf.ByteString
        getHexBytes() {
      java.lang.Object ref = "";
      if (digestCase_ == 3) {
        ref = digest_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        if (digestCase_ == 3) {
          digest_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Hex-encoded digest value.
     * </pre>
     *
     * <code>string hex = 3;</code>
     */
    public Builder setHex(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  digestCase_ = 3;
      digest_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Hex-encoded digest value.
     * </pre>
     *
     * <code>string hex = 3;</code>
     */
    public Builder clearHex() {
      if (digestCase_ == 3) {
        digestCase_ = 0;
        digest_ = null;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * Hex-encoded digest value.
     * </pre>
     *
     * <code>string hex = 3;</code>
     */
    public Builder setHexBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      digestCase_ = 3;
      digest_ = value;
      onChanged();
      return this;
    }

    /**
     * <pre>
     * Base64-encoded digest value.
     * </pre>
     *
     * <code>string b64 = 4;</code>
     */
    public java.lang.String getB64() {
      java.lang.Object ref = "";
      if (digestCase_ == 4) {
        ref = digest_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (digestCase_ == 4) {
          digest_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Base64-encoded digest value.
     * </pre>
     *
     * <code>string b64 = 4;</code>
     */
    public com.google.protobuf.ByteString
        getB64Bytes() {
      java.lang.Object ref = "";
      if (digestCase_ == 4) {
        ref = digest_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        if (digestCase_ == 4) {
          digest_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Base64-encoded digest value.
     * </pre>
     *
     * <code>string b64 = 4;</code>
     */
    public Builder setB64(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  digestCase_ = 4;
      digest_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Base64-encoded digest value.
     * </pre>
     *
     * <code>string b64 = 4;</code>
     */
    public Builder clearB64() {
      if (digestCase_ == 4) {
        digestCase_ = 0;
        digest_ = null;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * Base64-encoded digest value.
     * </pre>
     *
     * <code>string b64 = 4;</code>
     */
    public Builder setB64Bytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      digestCase_ = 4;
      digest_ = value;
      onChanged();
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:opencannabis.crypto.primitives.integrity.Hash)
  }

  // @@protoc_insertion_point(class_scope:opencannabis.crypto.primitives.integrity.Hash)
  private static final io.opencannabis.schema.crypto.primitives.integrity.Hash DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.opencannabis.schema.crypto.primitives.integrity.Hash();
  }

  public static io.opencannabis.schema.crypto.primitives.integrity.Hash getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Hash>
      PARSER = new com.google.protobuf.AbstractParser<Hash>() {
    public Hash parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new Hash(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<Hash> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Hash> getParserForType() {
    return PARSER;
  }

  public io.opencannabis.schema.crypto.primitives.integrity.Hash getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

