/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: crypto/primitives/Integrity.proto

package io.opencannabis.schema.crypto.primitives.integrity;

/**
 * <pre>
 * Enumerates hash algorithms supported or known by the runtime for shared use.
 * </pre>
 *
 * Protobuf enum {@code opencannabis.crypto.primitives.integrity.HashAlgorithm}
 */
public enum HashAlgorithm
    implements com.google.protobuf.ProtocolMessageEnum {
  /**
   * <pre>
   * Secure Hash Algorithm v2.
   * </pre>
   *
   * <code>SHA1 = 0;</code>
   */
  SHA1(0),
  /**
   * <pre>
   * Message Digest v5.
   * </pre>
   *
   * <code>MD5 = 1;</code>
   */
  MD5(1),
  /**
   * <pre>
   * Secure Hash Algorithm, with 256-bit width.
   * </pre>
   *
   * <code>SHA256 = 2;</code>
   */
  SHA256(2),
  /**
   * <pre>
   * Secure Hash Algorithm, with 384-bit width.
   * </pre>
   *
   * <code>SHA384 = 3;</code>
   */
  SHA384(3),
  /**
   * <pre>
   * Secure Hash Algorithm, with 512-bit width.
   * </pre>
   *
   * <code>SHA512 = 4;</code>
   */
  SHA512(4),
  /**
   * <pre>
   * Specifies hashing with MurmurHash.
   * </pre>
   *
   * <code>MURMUR = 6;</code>
   */
  MURMUR(6),
  UNRECOGNIZED(-1),
  ;

  /**
   * <pre>
   * Secure Hash Algorithm v2.
   * </pre>
   *
   * <code>SHA1 = 0;</code>
   */
  public static final int SHA1_VALUE = 0;
  /**
   * <pre>
   * Message Digest v5.
   * </pre>
   *
   * <code>MD5 = 1;</code>
   */
  public static final int MD5_VALUE = 1;
  /**
   * <pre>
   * Secure Hash Algorithm, with 256-bit width.
   * </pre>
   *
   * <code>SHA256 = 2;</code>
   */
  public static final int SHA256_VALUE = 2;
  /**
   * <pre>
   * Secure Hash Algorithm, with 384-bit width.
   * </pre>
   *
   * <code>SHA384 = 3;</code>
   */
  public static final int SHA384_VALUE = 3;
  /**
   * <pre>
   * Secure Hash Algorithm, with 512-bit width.
   * </pre>
   *
   * <code>SHA512 = 4;</code>
   */
  public static final int SHA512_VALUE = 4;
  /**
   * <pre>
   * Specifies hashing with MurmurHash.
   * </pre>
   *
   * <code>MURMUR = 6;</code>
   */
  public static final int MURMUR_VALUE = 6;


  public final int getNumber() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalArgumentException(
          "Can't get the number of an unknown enum value.");
    }
    return value;
  }

  /**
   * @deprecated Use {@link #forNumber(int)} instead.
   */
  @java.lang.Deprecated
  public static HashAlgorithm valueOf(int value) {
    return forNumber(value);
  }

  public static HashAlgorithm forNumber(int value) {
    switch (value) {
      case 0: return SHA1;
      case 1: return MD5;
      case 2: return SHA256;
      case 3: return SHA384;
      case 4: return SHA512;
      case 6: return MURMUR;
      default: return null;
    }
  }

  public static com.google.protobuf.Internal.EnumLiteMap<HashAlgorithm>
      internalGetValueMap() {
    return internalValueMap;
  }
  private static final com.google.protobuf.Internal.EnumLiteMap<
      HashAlgorithm> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<HashAlgorithm>() {
          public HashAlgorithm findValueByNumber(int number) {
            return HashAlgorithm.forNumber(number);
          }
        };

  public final com.google.protobuf.Descriptors.EnumValueDescriptor
      getValueDescriptor() {
    return getDescriptor().getValues().get(ordinal());
  }
  public final com.google.protobuf.Descriptors.EnumDescriptor
      getDescriptorForType() {
    return getDescriptor();
  }
  public static final com.google.protobuf.Descriptors.EnumDescriptor
      getDescriptor() {
    return io.opencannabis.schema.crypto.primitives.integrity.Integrity.getDescriptor().getEnumTypes().get(0);
  }

  private static final HashAlgorithm[] VALUES = values();

  public static HashAlgorithm valueOf(
      com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
    if (desc.getType() != getDescriptor()) {
      throw new java.lang.IllegalArgumentException(
        "EnumValueDescriptor is not for this type.");
    }
    if (desc.getIndex() == -1) {
      return UNRECOGNIZED;
    }
    return VALUES[desc.getIndex()];
  }

  private final int value;

  private HashAlgorithm(int value) {
    this.value = value;
  }

  // @@protoc_insertion_point(enum_scope:opencannabis.crypto.primitives.integrity.HashAlgorithm)
}

