/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: crypto/primitives/Integrity.proto

package io.opencannabis.schema.crypto.primitives.integrity;

/**
 * <pre>
 * Specifies a set of raw data, of some kind, and an attached digest/hash value, along with the algorithm used to
 * calculate the digest.
 * </pre>
 *
 * Protobuf type {@code opencannabis.crypto.primitives.integrity.HashedData}
 */
public  final class HashedData extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:opencannabis.crypto.primitives.integrity.HashedData)
    HashedDataOrBuilder {
private static final long serialVersionUID = 0L;
  // Use HashedData.newBuilder() to construct.
  private HashedData(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private HashedData() {
    data_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private HashedData(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 10: {

            data_ = input.readBytes();
            break;
          }
          case 18: {
            io.opencannabis.schema.crypto.primitives.integrity.Hash.Builder subBuilder = null;
            if (hash_ != null) {
              subBuilder = hash_.toBuilder();
            }
            hash_ = input.readMessage(io.opencannabis.schema.crypto.primitives.integrity.Hash.parser(), extensionRegistry);
            if (subBuilder != null) {
              subBuilder.mergeFrom(hash_);
              hash_ = subBuilder.buildPartial();
            }

            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.opencannabis.schema.crypto.primitives.integrity.Integrity.internal_static_opencannabis_crypto_primitives_integrity_HashedData_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.opencannabis.schema.crypto.primitives.integrity.Integrity.internal_static_opencannabis_crypto_primitives_integrity_HashedData_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.opencannabis.schema.crypto.primitives.integrity.HashedData.class, io.opencannabis.schema.crypto.primitives.integrity.HashedData.Builder.class);
  }

  public static final int DATA_FIELD_NUMBER = 1;
  private com.google.protobuf.ByteString data_;
  /**
   * <pre>
   * Raw data that we are transmitting.
   * </pre>
   *
   * <code>bytes data = 1;</code>
   */
  public com.google.protobuf.ByteString getData() {
    return data_;
  }

  public static final int HASH_FIELD_NUMBER = 2;
  private io.opencannabis.schema.crypto.primitives.integrity.Hash hash_;
  /**
   * <pre>
   * Hash for the raw data in this payload.
   * </pre>
   *
   * <code>.opencannabis.crypto.primitives.integrity.Hash hash = 2;</code>
   */
  public boolean hasHash() {
    return hash_ != null;
  }
  /**
   * <pre>
   * Hash for the raw data in this payload.
   * </pre>
   *
   * <code>.opencannabis.crypto.primitives.integrity.Hash hash = 2;</code>
   */
  public io.opencannabis.schema.crypto.primitives.integrity.Hash getHash() {
    return hash_ == null ? io.opencannabis.schema.crypto.primitives.integrity.Hash.getDefaultInstance() : hash_;
  }
  /**
   * <pre>
   * Hash for the raw data in this payload.
   * </pre>
   *
   * <code>.opencannabis.crypto.primitives.integrity.Hash hash = 2;</code>
   */
  public io.opencannabis.schema.crypto.primitives.integrity.HashOrBuilder getHashOrBuilder() {
    return getHash();
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!data_.isEmpty()) {
      output.writeBytes(1, data_);
    }
    if (hash_ != null) {
      output.writeMessage(2, getHash());
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!data_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream
        .computeBytesSize(1, data_);
    }
    if (hash_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(2, getHash());
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.opencannabis.schema.crypto.primitives.integrity.HashedData)) {
      return super.equals(obj);
    }
    io.opencannabis.schema.crypto.primitives.integrity.HashedData other = (io.opencannabis.schema.crypto.primitives.integrity.HashedData) obj;

    boolean result = true;
    result = result && getData()
        .equals(other.getData());
    result = result && (hasHash() == other.hasHash());
    if (hasHash()) {
      result = result && getHash()
          .equals(other.getHash());
    }
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DATA_FIELD_NUMBER;
    hash = (53 * hash) + getData().hashCode();
    if (hasHash()) {
      hash = (37 * hash) + HASH_FIELD_NUMBER;
      hash = (53 * hash) + getHash().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.opencannabis.schema.crypto.primitives.integrity.HashedData parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.crypto.primitives.integrity.HashedData parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.crypto.primitives.integrity.HashedData parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.crypto.primitives.integrity.HashedData parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.crypto.primitives.integrity.HashedData parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.crypto.primitives.integrity.HashedData parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.crypto.primitives.integrity.HashedData parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.crypto.primitives.integrity.HashedData parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.crypto.primitives.integrity.HashedData parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.crypto.primitives.integrity.HashedData parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.crypto.primitives.integrity.HashedData parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.crypto.primitives.integrity.HashedData parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.opencannabis.schema.crypto.primitives.integrity.HashedData prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies a set of raw data, of some kind, and an attached digest/hash value, along with the algorithm used to
   * calculate the digest.
   * </pre>
   *
   * Protobuf type {@code opencannabis.crypto.primitives.integrity.HashedData}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:opencannabis.crypto.primitives.integrity.HashedData)
      io.opencannabis.schema.crypto.primitives.integrity.HashedDataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.crypto.primitives.integrity.Integrity.internal_static_opencannabis_crypto_primitives_integrity_HashedData_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.crypto.primitives.integrity.Integrity.internal_static_opencannabis_crypto_primitives_integrity_HashedData_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.crypto.primitives.integrity.HashedData.class, io.opencannabis.schema.crypto.primitives.integrity.HashedData.Builder.class);
    }

    // Construct using io.opencannabis.schema.crypto.primitives.integrity.HashedData.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      data_ = com.google.protobuf.ByteString.EMPTY;

      if (hashBuilder_ == null) {
        hash_ = null;
      } else {
        hash_ = null;
        hashBuilder_ = null;
      }
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.opencannabis.schema.crypto.primitives.integrity.Integrity.internal_static_opencannabis_crypto_primitives_integrity_HashedData_descriptor;
    }

    public io.opencannabis.schema.crypto.primitives.integrity.HashedData getDefaultInstanceForType() {
      return io.opencannabis.schema.crypto.primitives.integrity.HashedData.getDefaultInstance();
    }

    public io.opencannabis.schema.crypto.primitives.integrity.HashedData build() {
      io.opencannabis.schema.crypto.primitives.integrity.HashedData result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.opencannabis.schema.crypto.primitives.integrity.HashedData buildPartial() {
      io.opencannabis.schema.crypto.primitives.integrity.HashedData result = new io.opencannabis.schema.crypto.primitives.integrity.HashedData(this);
      result.data_ = data_;
      if (hashBuilder_ == null) {
        result.hash_ = hash_;
      } else {
        result.hash_ = hashBuilder_.build();
      }
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.opencannabis.schema.crypto.primitives.integrity.HashedData) {
        return mergeFrom((io.opencannabis.schema.crypto.primitives.integrity.HashedData)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.opencannabis.schema.crypto.primitives.integrity.HashedData other) {
      if (other == io.opencannabis.schema.crypto.primitives.integrity.HashedData.getDefaultInstance()) return this;
      if (other.getData() != com.google.protobuf.ByteString.EMPTY) {
        setData(other.getData());
      }
      if (other.hasHash()) {
        mergeHash(other.getHash());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.opencannabis.schema.crypto.primitives.integrity.HashedData parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.opencannabis.schema.crypto.primitives.integrity.HashedData) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private com.google.protobuf.ByteString data_ = com.google.protobuf.ByteString.EMPTY;
    /**
     * <pre>
     * Raw data that we are transmitting.
     * </pre>
     *
     * <code>bytes data = 1;</code>
     */
    public com.google.protobuf.ByteString getData() {
      return data_;
    }
    /**
     * <pre>
     * Raw data that we are transmitting.
     * </pre>
     *
     * <code>bytes data = 1;</code>
     */
    public Builder setData(com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      data_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Raw data that we are transmitting.
     * </pre>
     *
     * <code>bytes data = 1;</code>
     */
    public Builder clearData() {
      
      data_ = getDefaultInstance().getData();
      onChanged();
      return this;
    }

    private io.opencannabis.schema.crypto.primitives.integrity.Hash hash_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.crypto.primitives.integrity.Hash, io.opencannabis.schema.crypto.primitives.integrity.Hash.Builder, io.opencannabis.schema.crypto.primitives.integrity.HashOrBuilder> hashBuilder_;
    /**
     * <pre>
     * Hash for the raw data in this payload.
     * </pre>
     *
     * <code>.opencannabis.crypto.primitives.integrity.Hash hash = 2;</code>
     */
    public boolean hasHash() {
      return hashBuilder_ != null || hash_ != null;
    }
    /**
     * <pre>
     * Hash for the raw data in this payload.
     * </pre>
     *
     * <code>.opencannabis.crypto.primitives.integrity.Hash hash = 2;</code>
     */
    public io.opencannabis.schema.crypto.primitives.integrity.Hash getHash() {
      if (hashBuilder_ == null) {
        return hash_ == null ? io.opencannabis.schema.crypto.primitives.integrity.Hash.getDefaultInstance() : hash_;
      } else {
        return hashBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Hash for the raw data in this payload.
     * </pre>
     *
     * <code>.opencannabis.crypto.primitives.integrity.Hash hash = 2;</code>
     */
    public Builder setHash(io.opencannabis.schema.crypto.primitives.integrity.Hash value) {
      if (hashBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        hash_ = value;
        onChanged();
      } else {
        hashBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     * <pre>
     * Hash for the raw data in this payload.
     * </pre>
     *
     * <code>.opencannabis.crypto.primitives.integrity.Hash hash = 2;</code>
     */
    public Builder setHash(
        io.opencannabis.schema.crypto.primitives.integrity.Hash.Builder builderForValue) {
      if (hashBuilder_ == null) {
        hash_ = builderForValue.build();
        onChanged();
      } else {
        hashBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     * <pre>
     * Hash for the raw data in this payload.
     * </pre>
     *
     * <code>.opencannabis.crypto.primitives.integrity.Hash hash = 2;</code>
     */
    public Builder mergeHash(io.opencannabis.schema.crypto.primitives.integrity.Hash value) {
      if (hashBuilder_ == null) {
        if (hash_ != null) {
          hash_ =
            io.opencannabis.schema.crypto.primitives.integrity.Hash.newBuilder(hash_).mergeFrom(value).buildPartial();
        } else {
          hash_ = value;
        }
        onChanged();
      } else {
        hashBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     * <pre>
     * Hash for the raw data in this payload.
     * </pre>
     *
     * <code>.opencannabis.crypto.primitives.integrity.Hash hash = 2;</code>
     */
    public Builder clearHash() {
      if (hashBuilder_ == null) {
        hash_ = null;
        onChanged();
      } else {
        hash_ = null;
        hashBuilder_ = null;
      }

      return this;
    }
    /**
     * <pre>
     * Hash for the raw data in this payload.
     * </pre>
     *
     * <code>.opencannabis.crypto.primitives.integrity.Hash hash = 2;</code>
     */
    public io.opencannabis.schema.crypto.primitives.integrity.Hash.Builder getHashBuilder() {
      
      onChanged();
      return getHashFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Hash for the raw data in this payload.
     * </pre>
     *
     * <code>.opencannabis.crypto.primitives.integrity.Hash hash = 2;</code>
     */
    public io.opencannabis.schema.crypto.primitives.integrity.HashOrBuilder getHashOrBuilder() {
      if (hashBuilder_ != null) {
        return hashBuilder_.getMessageOrBuilder();
      } else {
        return hash_ == null ?
            io.opencannabis.schema.crypto.primitives.integrity.Hash.getDefaultInstance() : hash_;
      }
    }
    /**
     * <pre>
     * Hash for the raw data in this payload.
     * </pre>
     *
     * <code>.opencannabis.crypto.primitives.integrity.Hash hash = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        io.opencannabis.schema.crypto.primitives.integrity.Hash, io.opencannabis.schema.crypto.primitives.integrity.Hash.Builder, io.opencannabis.schema.crypto.primitives.integrity.HashOrBuilder> 
        getHashFieldBuilder() {
      if (hashBuilder_ == null) {
        hashBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            io.opencannabis.schema.crypto.primitives.integrity.Hash, io.opencannabis.schema.crypto.primitives.integrity.Hash.Builder, io.opencannabis.schema.crypto.primitives.integrity.HashOrBuilder>(
                getHash(),
                getParentForChildren(),
                isClean());
        hash_ = null;
      }
      return hashBuilder_;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:opencannabis.crypto.primitives.integrity.HashedData)
  }

  // @@protoc_insertion_point(class_scope:opencannabis.crypto.primitives.integrity.HashedData)
  private static final io.opencannabis.schema.crypto.primitives.integrity.HashedData DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.opencannabis.schema.crypto.primitives.integrity.HashedData();
  }

  public static io.opencannabis.schema.crypto.primitives.integrity.HashedData getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<HashedData>
      PARSER = new com.google.protobuf.AbstractParser<HashedData>() {
    public HashedData parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new HashedData(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<HashedData> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<HashedData> getParserForType() {
    return PARSER;
  }

  public io.opencannabis.schema.crypto.primitives.integrity.HashedData getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

