/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: commerce/Currency.proto

package io.opencannabis.schema.currency;

/**
 * <pre>
 * Specifies known or explicitly supported currency types.
 * </pre>
 *
 * Protobuf enum {@code opencannabis.commerce.CurrencyType}
 */
public enum CurrencyType
    implements com.google.protobuf.ProtocolMessageEnum {
  /**
   * <pre>
   * Fiat-based currency, such as the US Dollar.
   * </pre>
   *
   * <code>FIAT = 0;</code>
   */
  FIAT(0),
  /**
   * <pre>
   * Real currency, such as gold or other raw materials.
   * </pre>
   *
   * <code>REAL = 1;</code>
   */
  REAL(1),
  /**
   * <pre>
   * Crypto-currency, based on unique cryptographic signatures or proof-of-work.
   * </pre>
   *
   * <code>CRYPTO = 2;</code>
   */
  CRYPTO(2),
  UNRECOGNIZED(-1),
  ;

  /**
   * <pre>
   * Fiat-based currency, such as the US Dollar.
   * </pre>
   *
   * <code>FIAT = 0;</code>
   */
  public static final int FIAT_VALUE = 0;
  /**
   * <pre>
   * Real currency, such as gold or other raw materials.
   * </pre>
   *
   * <code>REAL = 1;</code>
   */
  public static final int REAL_VALUE = 1;
  /**
   * <pre>
   * Crypto-currency, based on unique cryptographic signatures or proof-of-work.
   * </pre>
   *
   * <code>CRYPTO = 2;</code>
   */
  public static final int CRYPTO_VALUE = 2;


  public final int getNumber() {
    if (this == UNRECOGNIZED) {
      throw new java.lang.IllegalArgumentException(
          "Can't get the number of an unknown enum value.");
    }
    return value;
  }

  /**
   * @deprecated Use {@link #forNumber(int)} instead.
   */
  @java.lang.Deprecated
  public static CurrencyType valueOf(int value) {
    return forNumber(value);
  }

  public static CurrencyType forNumber(int value) {
    switch (value) {
      case 0: return FIAT;
      case 1: return REAL;
      case 2: return CRYPTO;
      default: return null;
    }
  }

  public static com.google.protobuf.Internal.EnumLiteMap<CurrencyType>
      internalGetValueMap() {
    return internalValueMap;
  }
  private static final com.google.protobuf.Internal.EnumLiteMap<
      CurrencyType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<CurrencyType>() {
          public CurrencyType findValueByNumber(int number) {
            return CurrencyType.forNumber(number);
          }
        };

  public final com.google.protobuf.Descriptors.EnumValueDescriptor
      getValueDescriptor() {
    return getDescriptor().getValues().get(ordinal());
  }
  public final com.google.protobuf.Descriptors.EnumDescriptor
      getDescriptorForType() {
    return getDescriptor();
  }
  public static final com.google.protobuf.Descriptors.EnumDescriptor
      getDescriptor() {
    return io.opencannabis.schema.currency.CommerceCurrency.getDescriptor().getEnumTypes().get(0);
  }

  private static final CurrencyType[] VALUES = values();

  public static CurrencyType valueOf(
      com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
    if (desc.getType() != getDescriptor()) {
      throw new java.lang.IllegalArgumentException(
        "EnumValueDescriptor is not for this type.");
    }
    if (desc.getIndex() == -1) {
      return UNRECOGNIZED;
    }
    return VALUES[desc.getIndex()];
  }

  private final int value;

  private CurrencyType(int value) {
    this.value = value;
  }

  // @@protoc_insertion_point(enum_scope:opencannabis.commerce.CurrencyType)
}

