/*
 * Copyright 2018, Bloombox, LLC.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: commerce/Currency.proto

package io.opencannabis.schema.currency;

/**
 * <pre>
 * Specifies a value, with a particular currency specification as the unit.
 * </pre>
 *
 * Protobuf type {@code opencannabis.commerce.CurrencyValue}
 */
public  final class CurrencyValue extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:opencannabis.commerce.CurrencyValue)
    CurrencyValueOrBuilder {
private static final long serialVersionUID = 0L;
  // Use CurrencyValue.newBuilder() to construct.
  private CurrencyValue(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private CurrencyValue() {
    value_ = 0F;
    type_ = 0;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private CurrencyValue(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!parseUnknownFieldProto3(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
          case 13: {

            value_ = input.readFloat();
            break;
          }
          case 16: {
            int rawValue = input.readEnum();

            type_ = rawValue;
            break;
          }
          case 80: {
            int rawValue = input.readEnum();
            specCase_ = 10;
            spec_ = rawValue;
            break;
          }
          case 802: {
            java.lang.String s = input.readStringRequireUtf8();
            specCase_ = 100;
            spec_ = s;
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.opencannabis.schema.currency.CommerceCurrency.internal_static_opencannabis_commerce_CurrencyValue_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.opencannabis.schema.currency.CommerceCurrency.internal_static_opencannabis_commerce_CurrencyValue_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.opencannabis.schema.currency.CurrencyValue.class, io.opencannabis.schema.currency.CurrencyValue.Builder.class);
  }

  private int specCase_ = 0;
  private java.lang.Object spec_;
  public enum SpecCase
      implements com.google.protobuf.Internal.EnumLite {
    FIAT(10),
    CUSTOM(100),
    SPEC_NOT_SET(0);
    private final int value;
    private SpecCase(int value) {
      this.value = value;
    }
    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SpecCase valueOf(int value) {
      return forNumber(value);
    }

    public static SpecCase forNumber(int value) {
      switch (value) {
        case 10: return FIAT;
        case 100: return CUSTOM;
        case 0: return SPEC_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public SpecCase
  getSpecCase() {
    return SpecCase.forNumber(
        specCase_);
  }

  public static final int VALUE_FIELD_NUMBER = 1;
  private float value_;
  /**
   * <pre>
   * Numeric amount value to specify.
   * </pre>
   *
   * <code>float value = 1;</code>
   */
  public float getValue() {
    return value_;
  }

  public static final int TYPE_FIELD_NUMBER = 2;
  private int type_;
  /**
   * <pre>
   * Categorical or general type for the specified currency.
   * </pre>
   *
   * <code>.opencannabis.commerce.CurrencyType type = 2;</code>
   */
  public int getTypeValue() {
    return type_;
  }
  /**
   * <pre>
   * Categorical or general type for the specified currency.
   * </pre>
   *
   * <code>.opencannabis.commerce.CurrencyType type = 2;</code>
   */
  public io.opencannabis.schema.currency.CurrencyType getType() {
    io.opencannabis.schema.currency.CurrencyType result = io.opencannabis.schema.currency.CurrencyType.valueOf(type_);
    return result == null ? io.opencannabis.schema.currency.CurrencyType.UNRECOGNIZED : result;
  }

  public static final int FIAT_FIELD_NUMBER = 10;
  /**
   * <pre>
   * Fiat currency selection for a given currency value.
   * </pre>
   *
   * <code>.opencannabis.commerce.FiatCurrency fiat = 10;</code>
   */
  public int getFiatValue() {
    if (specCase_ == 10) {
      return (java.lang.Integer) spec_;
    }
    return 0;
  }
  /**
   * <pre>
   * Fiat currency selection for a given currency value.
   * </pre>
   *
   * <code>.opencannabis.commerce.FiatCurrency fiat = 10;</code>
   */
  public io.opencannabis.schema.currency.FiatCurrency getFiat() {
    if (specCase_ == 10) {
      io.opencannabis.schema.currency.FiatCurrency result = io.opencannabis.schema.currency.FiatCurrency.valueOf(
          (java.lang.Integer) spec_);
      return result == null ? io.opencannabis.schema.currency.FiatCurrency.UNRECOGNIZED : result;
    }
    return io.opencannabis.schema.currency.FiatCurrency.USD;
  }

  public static final int CUSTOM_FIELD_NUMBER = 100;
  /**
   * <pre>
   * Custom currency, by name or symbol, for a given currency value.
   * </pre>
   *
   * <code>string custom = 100;</code>
   */
  public java.lang.String getCustom() {
    java.lang.Object ref = "";
    if (specCase_ == 100) {
      ref = spec_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (specCase_ == 100) {
        spec_ = s;
      }
      return s;
    }
  }
  /**
   * <pre>
   * Custom currency, by name or symbol, for a given currency value.
   * </pre>
   *
   * <code>string custom = 100;</code>
   */
  public com.google.protobuf.ByteString
      getCustomBytes() {
    java.lang.Object ref = "";
    if (specCase_ == 100) {
      ref = spec_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      if (specCase_ == 100) {
        spec_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (value_ != 0F) {
      output.writeFloat(1, value_);
    }
    if (type_ != io.opencannabis.schema.currency.CurrencyType.FIAT.getNumber()) {
      output.writeEnum(2, type_);
    }
    if (specCase_ == 10) {
      output.writeEnum(10, ((java.lang.Integer) spec_));
    }
    if (specCase_ == 100) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 100, spec_);
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (value_ != 0F) {
      size += com.google.protobuf.CodedOutputStream
        .computeFloatSize(1, value_);
    }
    if (type_ != io.opencannabis.schema.currency.CurrencyType.FIAT.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(2, type_);
    }
    if (specCase_ == 10) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(10, ((java.lang.Integer) spec_));
    }
    if (specCase_ == 100) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(100, spec_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.opencannabis.schema.currency.CurrencyValue)) {
      return super.equals(obj);
    }
    io.opencannabis.schema.currency.CurrencyValue other = (io.opencannabis.schema.currency.CurrencyValue) obj;

    boolean result = true;
    result = result && (
        java.lang.Float.floatToIntBits(getValue())
        == java.lang.Float.floatToIntBits(
            other.getValue()));
    result = result && type_ == other.type_;
    result = result && getSpecCase().equals(
        other.getSpecCase());
    if (!result) return false;
    switch (specCase_) {
      case 10:
        result = result && getFiatValue()
            == other.getFiatValue();
        break;
      case 100:
        result = result && getCustom()
            .equals(other.getCustom());
        break;
      case 0:
      default:
    }
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + VALUE_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(
        getValue());
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    switch (specCase_) {
      case 10:
        hash = (37 * hash) + FIAT_FIELD_NUMBER;
        hash = (53 * hash) + getFiatValue();
        break;
      case 100:
        hash = (37 * hash) + CUSTOM_FIELD_NUMBER;
        hash = (53 * hash) + getCustom().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.opencannabis.schema.currency.CurrencyValue parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.currency.CurrencyValue parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.currency.CurrencyValue parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.currency.CurrencyValue parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.currency.CurrencyValue parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opencannabis.schema.currency.CurrencyValue parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opencannabis.schema.currency.CurrencyValue parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.currency.CurrencyValue parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.currency.CurrencyValue parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.currency.CurrencyValue parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opencannabis.schema.currency.CurrencyValue parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.opencannabis.schema.currency.CurrencyValue parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.opencannabis.schema.currency.CurrencyValue prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Specifies a value, with a particular currency specification as the unit.
   * </pre>
   *
   * Protobuf type {@code opencannabis.commerce.CurrencyValue}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:opencannabis.commerce.CurrencyValue)
      io.opencannabis.schema.currency.CurrencyValueOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opencannabis.schema.currency.CommerceCurrency.internal_static_opencannabis_commerce_CurrencyValue_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opencannabis.schema.currency.CommerceCurrency.internal_static_opencannabis_commerce_CurrencyValue_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opencannabis.schema.currency.CurrencyValue.class, io.opencannabis.schema.currency.CurrencyValue.Builder.class);
    }

    // Construct using io.opencannabis.schema.currency.CurrencyValue.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    public Builder clear() {
      super.clear();
      value_ = 0F;

      type_ = 0;

      specCase_ = 0;
      spec_ = null;
      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.opencannabis.schema.currency.CommerceCurrency.internal_static_opencannabis_commerce_CurrencyValue_descriptor;
    }

    public io.opencannabis.schema.currency.CurrencyValue getDefaultInstanceForType() {
      return io.opencannabis.schema.currency.CurrencyValue.getDefaultInstance();
    }

    public io.opencannabis.schema.currency.CurrencyValue build() {
      io.opencannabis.schema.currency.CurrencyValue result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public io.opencannabis.schema.currency.CurrencyValue buildPartial() {
      io.opencannabis.schema.currency.CurrencyValue result = new io.opencannabis.schema.currency.CurrencyValue(this);
      result.value_ = value_;
      result.type_ = type_;
      if (specCase_ == 10) {
        result.spec_ = spec_;
      }
      if (specCase_ == 100) {
        result.spec_ = spec_;
      }
      result.specCase_ = specCase_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.opencannabis.schema.currency.CurrencyValue) {
        return mergeFrom((io.opencannabis.schema.currency.CurrencyValue)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.opencannabis.schema.currency.CurrencyValue other) {
      if (other == io.opencannabis.schema.currency.CurrencyValue.getDefaultInstance()) return this;
      if (other.getValue() != 0F) {
        setValue(other.getValue());
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      switch (other.getSpecCase()) {
        case FIAT: {
          setFiatValue(other.getFiatValue());
          break;
        }
        case CUSTOM: {
          specCase_ = 100;
          spec_ = other.spec_;
          onChanged();
          break;
        }
        case SPEC_NOT_SET: {
          break;
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      io.opencannabis.schema.currency.CurrencyValue parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (io.opencannabis.schema.currency.CurrencyValue) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int specCase_ = 0;
    private java.lang.Object spec_;
    public SpecCase
        getSpecCase() {
      return SpecCase.forNumber(
          specCase_);
    }

    public Builder clearSpec() {
      specCase_ = 0;
      spec_ = null;
      onChanged();
      return this;
    }


    private float value_ ;
    /**
     * <pre>
     * Numeric amount value to specify.
     * </pre>
     *
     * <code>float value = 1;</code>
     */
    public float getValue() {
      return value_;
    }
    /**
     * <pre>
     * Numeric amount value to specify.
     * </pre>
     *
     * <code>float value = 1;</code>
     */
    public Builder setValue(float value) {
      
      value_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Numeric amount value to specify.
     * </pre>
     *
     * <code>float value = 1;</code>
     */
    public Builder clearValue() {
      
      value_ = 0F;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     * <pre>
     * Categorical or general type for the specified currency.
     * </pre>
     *
     * <code>.opencannabis.commerce.CurrencyType type = 2;</code>
     */
    public int getTypeValue() {
      return type_;
    }
    /**
     * <pre>
     * Categorical or general type for the specified currency.
     * </pre>
     *
     * <code>.opencannabis.commerce.CurrencyType type = 2;</code>
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Categorical or general type for the specified currency.
     * </pre>
     *
     * <code>.opencannabis.commerce.CurrencyType type = 2;</code>
     */
    public io.opencannabis.schema.currency.CurrencyType getType() {
      io.opencannabis.schema.currency.CurrencyType result = io.opencannabis.schema.currency.CurrencyType.valueOf(type_);
      return result == null ? io.opencannabis.schema.currency.CurrencyType.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Categorical or general type for the specified currency.
     * </pre>
     *
     * <code>.opencannabis.commerce.CurrencyType type = 2;</code>
     */
    public Builder setType(io.opencannabis.schema.currency.CurrencyType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Categorical or general type for the specified currency.
     * </pre>
     *
     * <code>.opencannabis.commerce.CurrencyType type = 2;</code>
     */
    public Builder clearType() {
      
      type_ = 0;
      onChanged();
      return this;
    }

    /**
     * <pre>
     * Fiat currency selection for a given currency value.
     * </pre>
     *
     * <code>.opencannabis.commerce.FiatCurrency fiat = 10;</code>
     */
    public int getFiatValue() {
      if (specCase_ == 10) {
        return ((java.lang.Integer) spec_).intValue();
      }
      return 0;
    }
    /**
     * <pre>
     * Fiat currency selection for a given currency value.
     * </pre>
     *
     * <code>.opencannabis.commerce.FiatCurrency fiat = 10;</code>
     */
    public Builder setFiatValue(int value) {
      specCase_ = 10;
      spec_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Fiat currency selection for a given currency value.
     * </pre>
     *
     * <code>.opencannabis.commerce.FiatCurrency fiat = 10;</code>
     */
    public io.opencannabis.schema.currency.FiatCurrency getFiat() {
      if (specCase_ == 10) {
        io.opencannabis.schema.currency.FiatCurrency result = io.opencannabis.schema.currency.FiatCurrency.valueOf(
            (java.lang.Integer) spec_);
        return result == null ? io.opencannabis.schema.currency.FiatCurrency.UNRECOGNIZED : result;
      }
      return io.opencannabis.schema.currency.FiatCurrency.USD;
    }
    /**
     * <pre>
     * Fiat currency selection for a given currency value.
     * </pre>
     *
     * <code>.opencannabis.commerce.FiatCurrency fiat = 10;</code>
     */
    public Builder setFiat(io.opencannabis.schema.currency.FiatCurrency value) {
      if (value == null) {
        throw new NullPointerException();
      }
      specCase_ = 10;
      spec_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Fiat currency selection for a given currency value.
     * </pre>
     *
     * <code>.opencannabis.commerce.FiatCurrency fiat = 10;</code>
     */
    public Builder clearFiat() {
      if (specCase_ == 10) {
        specCase_ = 0;
        spec_ = null;
        onChanged();
      }
      return this;
    }

    /**
     * <pre>
     * Custom currency, by name or symbol, for a given currency value.
     * </pre>
     *
     * <code>string custom = 100;</code>
     */
    public java.lang.String getCustom() {
      java.lang.Object ref = "";
      if (specCase_ == 100) {
        ref = spec_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (specCase_ == 100) {
          spec_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Custom currency, by name or symbol, for a given currency value.
     * </pre>
     *
     * <code>string custom = 100;</code>
     */
    public com.google.protobuf.ByteString
        getCustomBytes() {
      java.lang.Object ref = "";
      if (specCase_ == 100) {
        ref = spec_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        if (specCase_ == 100) {
          spec_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Custom currency, by name or symbol, for a given currency value.
     * </pre>
     *
     * <code>string custom = 100;</code>
     */
    public Builder setCustom(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  specCase_ = 100;
      spec_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Custom currency, by name or symbol, for a given currency value.
     * </pre>
     *
     * <code>string custom = 100;</code>
     */
    public Builder clearCustom() {
      if (specCase_ == 100) {
        specCase_ = 0;
        spec_ = null;
        onChanged();
      }
      return this;
    }
    /**
     * <pre>
     * Custom currency, by name or symbol, for a given currency value.
     * </pre>
     *
     * <code>string custom = 100;</code>
     */
    public Builder setCustomBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      specCase_ = 100;
      spec_ = value;
      onChanged();
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:opencannabis.commerce.CurrencyValue)
  }

  // @@protoc_insertion_point(class_scope:opencannabis.commerce.CurrencyValue)
  private static final io.opencannabis.schema.currency.CurrencyValue DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.opencannabis.schema.currency.CurrencyValue();
  }

  public static io.opencannabis.schema.currency.CurrencyValue getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CurrencyValue>
      PARSER = new com.google.protobuf.AbstractParser<CurrencyValue>() {
    public CurrencyValue parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new CurrencyValue(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<CurrencyValue> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CurrencyValue> getParserForType() {
    return PARSER;
  }

  public io.opencannabis.schema.currency.CurrencyValue getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

